/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.traffic;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.test.utils.KafkaTestUtils;
import io.confluent.kafka.traffic.TopicBasedTrafficNetworkIdRoutesUpdater;
import io.confluent.kafka.traffic.TrafficNetworkIdAllowedRoutes;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.server.BrokerSession;
import kafka.server.KafkaConfig;
import kafka.utils.TestUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.connect.util.KafkaBasedLog;
import org.apache.kafka.metadata.MetadataCache;
import org.apache.kafka.server.traffic.TrafficNetworkIdRoutesStore;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TopicBasedTrafficNetworkIdRoutesUpdaterTest {
    private static final String TOPIC = "_confluent-network_id_routes";
    private String sessionUuid;
    private static final String CLUSTER_NETWORK_ID = "ne-uuid";
    private static final String PKC_ID = "pkc-uuid";
    private ObjectMapper objectMapper;
    private TopicBasedTrafficNetworkIdRoutesUpdater updater;
    private KafkaBasedLog<String, String> kafkaBasedLog;
    private MetadataCache metadataCache;
    private Set<String> disallowedNetworks;

    @BeforeEach
    public void setUp() throws Exception {
        this.disallowedNetworks = new HashSet<String>();
        this.sessionUuid = UUID.randomUUID().toString();
        this.objectMapper = new ObjectMapper();
        this.kafkaBasedLog = (KafkaBasedLog)Mockito.mock(KafkaBasedLog.class);
        this.metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        Mockito.when((Object)this.metadataCache.contains(TOPIC)).thenReturn((Object)true);
        this.updater = this.createAndStartStoreWithMockLog(this.sessionUuid, new HashMap(), new Metrics(), (Time)new MockTime(), this.kafkaBasedLog);
        KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        Mockito.when((Object)config.brokerSessionUuid()).thenReturn((Object)this.sessionUuid);
        Mockito.when((Object)config.closeConnectionsOnCredentialDelete()).thenReturn((Object)true);
        BrokerSession.addSession((KafkaConfig)config, publicCredential -> this.disallowedNetworks.add((String)publicCredential.networkId().get()));
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.closeStore(this.updater);
        BrokerSession.closeSession((String)this.sessionUuid);
    }

    @Test
    public void testStoreStartWaitsForTopicCreation() throws InterruptedException {
        AtomicInteger topicCreatedCallCount = new AtomicInteger(0);
        AtomicBoolean topicCreated = new AtomicBoolean(false);
        MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        Mockito.when((Object)metadataCache.contains(TOPIC)).thenAnswer(invocation -> {
            topicCreatedCallCount.incrementAndGet();
            return topicCreated.get();
        });
        MockTime time = new MockTime();
        KafkaBasedLog kafkaBasedLog = (KafkaBasedLog)Mockito.mock(KafkaBasedLog.class);
        try (TopicBasedTrafficNetworkIdRoutesUpdater updater = this.createStoreWithMockLog(metadataCache, UUID.randomUUID().toString(), new HashMap(), new Metrics(), (Time)time, (KafkaBasedLog<String, String>)kafkaBasedLog, 10L);){
            Endpoint endpoint = new Endpoint("EXTERNAL_BACKCHANNEL", SecurityProtocol.PLAINTEXT, "localhost", 9092);
            Map futures = updater.start(Collections.singletonList(endpoint));
            futures.values().forEach(f -> f.join());
            Assertions.assertEquals((Object)TopicBasedTrafficNetworkIdRoutesUpdater.State.STARTING, updater.state.get());
            TestUtils.waitUntilTrue(() -> topicCreatedCallCount.get() > 5, () -> "periodic task isn't checking for topic creation.", (long)15000L, (long)100L);
            topicCreated.set(true);
            TestUtils.waitUntilTrue(() -> updater.state.get() == TopicBasedTrafficNetworkIdRoutesUpdater.State.RUNNING, () -> "updater.never made it to RUNNING state.", (long)15000L, (long)100L);
            Assertions.assertTrue((boolean)updater.storeStartTaskFuture.isCancelled());
        }
    }

    @Test
    public void testNonRoutesListenersDoNotWaitForStoreStart() {
        CountDownLatch latch = new CountDownLatch(1);
        Map<Endpoint, CompletableFuture<Void>> futures = this.startStoreWithDelayedLogStartup(latch, "EXTERNAL");
        futures.values().forEach(f -> Assertions.assertTrue((boolean)f.isDone()));
        latch.countDown();
    }

    @Test
    public void testOnlyRoutesListenersWaitForStoreStart() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        Map<Endpoint, CompletableFuture<Void>> futures = this.startStoreWithDelayedLogStartup(latch, "EXTERNAL_BACKCHANNEL");
        futures.values().forEach(f -> Assertions.assertFalse((boolean)f.isDone()));
        latch.countDown();
        for (CompletableFuture<Void> future : futures.values()) {
            future.get(15000L, TimeUnit.MILLISECONDS);
        }
    }

    private Map<Endpoint, CompletableFuture<Void>> startStoreWithDelayedLogStartup(CountDownLatch latch, String listenerName) {
        KafkaBasedLog kafkaBasedLog = (KafkaBasedLog)Mockito.mock(KafkaBasedLog.class);
        ((KafkaBasedLog)Mockito.doAnswer(invocation -> {
            latch.await();
            return null;
        }).when((Object)kafkaBasedLog)).start();
        TopicBasedTrafficNetworkIdRoutesUpdater updater = this.createStoreWithMockLog(this.metadataCache, UUID.randomUUID().toString(), new HashMap(), new Metrics(), (Time)new MockTime(), (KafkaBasedLog<String, String>)kafkaBasedLog);
        Endpoint externalEndpoint = new Endpoint(listenerName, SecurityProtocol.PLAINTEXT, "localhost", 9092);
        Map futures = updater.start(Collections.singletonList(externalEndpoint));
        Assertions.assertEquals((Object)TopicBasedTrafficNetworkIdRoutesUpdater.State.STARTING, updater.state.get());
        return futures;
    }

    @Test
    public void testDisabledInConfig() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        HashMap interBrokerClientConfig = new HashMap();
        String sessionUuid = UUID.randomUUID().toString();
        configs.put(KafkaConfig.BrokerSessionUuidProp(), sessionUuid);
        configs.put("confluent.traffic.cdc.network.id.routes.enable", false);
        TopicBasedTrafficNetworkIdRoutesUpdater updater = new TopicBasedTrafficNetworkIdRoutesUpdater(this.metadataCache, interBrokerClientConfig, new Metrics(), (Time)new MockTime());
        Assertions.assertEquals((Object)TopicBasedTrafficNetworkIdRoutesUpdater.State.NOT_STARTED, updater.state.get());
        Assertions.assertNull((Object)TrafficNetworkIdRoutesStore.getRoutes((String)sessionUuid));
        updater.configure(configs);
        Assertions.assertEquals((Object)TopicBasedTrafficNetworkIdRoutesUpdater.State.NOT_ENABLED, updater.state.get());
        Assertions.assertNull((Object)TrafficNetworkIdRoutesStore.getRoutes((String)sessionUuid));
        updater.close();
        Assertions.assertEquals((Object)TopicBasedTrafficNetworkIdRoutesUpdater.State.NOT_ENABLED, updater.state.get());
        Assertions.assertNull((Object)TrafficNetworkIdRoutesStore.getRoutes((String)sessionUuid));
        configs.put("confluent.traffic.cdc.network.id.routes.enable", null);
        updater = new TopicBasedTrafficNetworkIdRoutesUpdater(this.metadataCache, interBrokerClientConfig, new Metrics(), (Time)new MockTime());
        Assertions.assertEquals((Object)TopicBasedTrafficNetworkIdRoutesUpdater.State.NOT_STARTED, updater.state.get());
        Assertions.assertNull((Object)TrafficNetworkIdRoutesStore.getRoutes((String)sessionUuid));
        updater.configure(configs);
        Assertions.assertEquals((Object)TopicBasedTrafficNetworkIdRoutesUpdater.State.NOT_ENABLED, updater.state.get());
        Assertions.assertNull((Object)TrafficNetworkIdRoutesStore.getRoutes((String)sessionUuid));
        updater.close();
        Assertions.assertEquals((Object)TopicBasedTrafficNetworkIdRoutesUpdater.State.NOT_ENABLED, updater.state.get());
        Assertions.assertNull((Object)TrafficNetworkIdRoutesStore.getRoutes((String)sessionUuid));
    }

    private TopicBasedTrafficNetworkIdRoutesUpdater createAndStartStoreWithMockLog(String sessionUuid, Map<String, ?> interBrokerClientConfig, Metrics metrics, Time time, KafkaBasedLog<String, String> kafkaBasedLog) {
        TopicBasedTrafficNetworkIdRoutesUpdater updater = this.createStoreWithMockLog(this.metadataCache, sessionUuid, interBrokerClientConfig, metrics, time, kafkaBasedLog);
        Endpoint endpoint = new Endpoint("EXTERNAL_BACKCHANNEL", SecurityProtocol.PLAINTEXT, "localhost", 9092);
        updater.start(Collections.singletonList(endpoint)).values().forEach(f -> f.join());
        return updater;
    }

    private TopicBasedTrafficNetworkIdRoutesUpdater createStoreWithMockLog(MetadataCache metadataCache, String sessionUuid, Map<String, ?> interBrokerClientConfig, Metrics metrics, Time time, KafkaBasedLog<String, String> kafkaBasedLog) {
        return this.createStoreWithMockLog(metadataCache, sessionUuid, interBrokerClientConfig, metrics, time, kafkaBasedLog, TimeUnit.MINUTES.toMillis(5L));
    }

    private TopicBasedTrafficNetworkIdRoutesUpdater createStoreWithMockLog(MetadataCache metadataCache, String sessionUuid, Map<String, ?> interBrokerClientConfig, Metrics metrics, Time time, KafkaBasedLog<String, String> kafkaBasedLog, long periodicStartTaskMs) {
        TopicBasedTrafficNetworkIdRoutesUpdater updater = new TopicBasedTrafficNetworkIdRoutesUpdater(metadataCache, interBrokerClientConfig, metrics, time);
        updater.configureInternal(kafkaBasedLog, sessionUuid, CLUSTER_NETWORK_ID, TOPIC, Collections.singletonList("EXTERNAL_BACKCHANNEL"), periodicStartTaskMs);
        return updater;
    }

    private void closeStore(TopicBasedTrafficNetworkIdRoutesUpdater updater) {
        updater.close();
        ((KafkaBasedLog)Mockito.verify(this.kafkaBasedLog, (VerificationMode)Mockito.times((int)1))).stop();
        Assertions.assertEquals((Object)TopicBasedTrafficNetworkIdRoutesUpdater.State.CLOSED, updater.state.get());
    }

    private String encodeValue(List<String> allowedNetworkIds) throws IOException {
        return this.encodeValue(new TrafficNetworkIdAllowedRoutes(allowedNetworkIds, null));
    }

    private String encodeValue(List<String> allowedNetworkIds, List<String> allowedDNSDomainSuffixes) throws IOException {
        return this.encodeValue(new TrafficNetworkIdAllowedRoutes(allowedNetworkIds, allowedDNSDomainSuffixes));
    }

    private String encodeValue(TrafficNetworkIdAllowedRoutes routes) throws IOException {
        StringWriter writer = new StringWriter();
        this.objectMapper.writeValue((Writer)writer, (Object)routes);
        return writer.toString();
    }

    private String encodeValueWithExtraFields(List<String> allowedNetworkIds, List<String> allowedDNSDomainSuffixes) throws IOException {
        return this.encodeValue(new TestTrafficNetworkIdAllowedRoutes(allowedNetworkIds, allowedDNSDomainSuffixes));
    }

    private ConsumerRecord<String, String> createRecord(long seqId, String key, String value) {
        RecordHeaders headers = KafkaTestUtils.createGoodSequenceIdRecordHeaders(seqId, false);
        return new ConsumerRecord(TOPIC, 0, 0L, -1L, TimestampType.NO_TIMESTAMP_TYPE, -1, -1, (Object)key, (Object)value, (Headers)headers, Optional.empty());
    }

    @Test
    public void testMultipleStarts() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.updater.start(Collections.emptyList()), (String)"Starting the updater twice should throw");
    }

    @Test
    public void testFailedStartWillCloseResources() {
        HashMap interBrokerClientConfig = new HashMap();
        KafkaBasedLog kafkaBasedLog = (KafkaBasedLog)Mockito.mock(KafkaBasedLog.class);
        ((KafkaBasedLog)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("unknown exception during startup")}).when((Object)kafkaBasedLog)).start();
        TopicBasedTrafficNetworkIdRoutesUpdater updater = this.createStoreWithMockLog(this.metadataCache, UUID.randomUUID().toString(), interBrokerClientConfig, new Metrics(), (Time)new MockTime(), (KafkaBasedLog<String, String>)kafkaBasedLog);
        Endpoint endpoint = new Endpoint("EXTERNAL_BACKCHANNEL", SecurityProtocol.PLAINTEXT, "localhost", 9092);
        Assertions.assertThrows(Exception.class, () -> updater.start(Collections.singletonList(endpoint)).values().forEach(f -> f.join()));
        Assertions.assertEquals((Object)TopicBasedTrafficNetworkIdRoutesUpdater.State.FAILED_TO_START, updater.state.get());
        updater.close();
        ((KafkaBasedLog)Mockito.verify((Object)kafkaBasedLog, (VerificationMode)Mockito.times((int)1))).stop();
        Assertions.assertEquals((Object)TopicBasedTrafficNetworkIdRoutesUpdater.State.FAILED_TO_START, updater.state.get());
    }

    @Test
    public void testIgnoreBadMessages() throws IOException {
        Assertions.assertNull((Object)TrafficNetworkIdRoutesStore.getRoutes((String)this.sessionUuid));
        Assertions.assertNull((Object)this.updater.getLastSeenSequenceId());
        List<String> allowedNetworkIds = Arrays.asList("ne1", "ne2");
        ConsumerRecord noHeaders = new ConsumerRecord(TOPIC, 0, 0L, (Object)CLUSTER_NETWORK_ID, (Object)this.encodeValue(allowedNetworkIds));
        this.updater.consume(noHeaders);
        Assertions.assertNull((Object)TrafficNetworkIdRoutesStore.getRoutes((String)this.sessionUuid));
        Assertions.assertNull((Object)this.updater.getLastSeenSequenceId());
        ConsumerRecord<String, String> noKey = this.createRecord(1L, null, this.encodeValue(allowedNetworkIds));
        this.updater.consume(noKey);
        Assertions.assertNull((Object)TrafficNetworkIdRoutesStore.getRoutes((String)this.sessionUuid));
        Assertions.assertNull((Object)this.updater.getLastSeenSequenceId());
        ConsumerRecord<String, String> badKey = this.createRecord(1L, "ne-uuid=pkc-foo", this.encodeValue(allowedNetworkIds));
        this.updater.consume(badKey);
        Assertions.assertNull((Object)TrafficNetworkIdRoutesStore.getRoutes((String)this.sessionUuid));
        Assertions.assertNull((Object)this.updater.getLastSeenSequenceId());
        badKey = this.createRecord(1L, "network-foo:pkc-foo", this.encodeValue(allowedNetworkIds));
        this.updater.consume(badKey);
        Assertions.assertNull((Object)TrafficNetworkIdRoutesStore.getRoutes((String)this.sessionUuid));
        Assertions.assertNull((Object)this.updater.getLastSeenSequenceId());
        ConsumerRecord<String, String> noValue = this.createRecord(1L, "ne-uuid:pkc-foo", "foo");
        this.updater.consume(noValue);
        Assertions.assertNull((Object)TrafficNetworkIdRoutesStore.getRoutes((String)this.sessionUuid));
        Assertions.assertEquals((long)1L, (Long)this.updater.getLastSeenSequenceId());
    }

    @Test
    public void testForceDisconnectOneRoute() throws IOException {
        this.updater.state.set(TopicBasedTrafficNetworkIdRoutesUpdater.State.RUNNING);
        String key = "ne-uuid:pkc-uuid";
        Assertions.assertNull((Object)this.updater.getLastSeenSequenceId());
        this.updater.consume(this.createRecord(1L, key, this.encodeValue(Collections.emptyList())));
        Assertions.assertTrue((boolean)this.disallowedNetworks.isEmpty());
        this.ensureNetworkDisallowed("nr1");
        this.ensureNetworkDisallowed("nr2");
        this.updater.consume(this.createRecord(2L, key, this.encodeValue(Arrays.asList("nr1"))));
        this.ensureNetworkAllowed("nr1");
        this.ensureNetworkDisallowed("nr2");
        Assertions.assertTrue((boolean)this.disallowedNetworks.isEmpty());
        this.updater.consume(this.createRecord(3L, key, this.encodeValue(Collections.emptyList())));
        Assertions.assertEquals((int)1, (int)this.disallowedNetworks.size());
        Assertions.assertTrue((boolean)this.disallowedNetworks.contains("nr1"));
        this.ensureNetworkDisallowed("nr1");
        this.ensureNetworkDisallowed("nr2");
        this.disallowedNetworks.clear();
        this.updater.consume(this.createRecord(4L, key, this.encodeValue(Collections.emptyList())));
        Assertions.assertTrue((boolean)this.disallowedNetworks.isEmpty());
        this.ensureNetworkDisallowed("nr1");
        this.ensureNetworkDisallowed("nr2");
    }

    @Test
    public void testConsumeRoutes() throws IOException {
        this.updater.state.set(TopicBasedTrafficNetworkIdRoutesUpdater.State.RUNNING);
        String key = "ne-uuid:pkc-uuid";
        Assertions.assertNull((Object)this.updater.getLastSeenSequenceId());
        this.updater.consume(this.createRecord(100L, key, this.encodeValueForNetworksAndDomains(Arrays.asList(1, 2))));
        this.ensureNetworkAndDomainSuffixAllowed(1);
        this.ensureNetworkAndDomainSuffixAllowed(2);
        this.updater.consume(this.createRecord(99L, key, this.encodeValueForNetworksAndDomains(Arrays.asList(3))));
        this.ensureNetworkAndDomainSuffixDisallowed(3);
        this.ensureNetworkAndDomainSuffixAllowed(1);
        this.ensureNetworkAndDomainSuffixAllowed(2);
        Assertions.assertEquals((long)100L, (Long)this.updater.getLastSeenSequenceId());
        Assertions.assertTrue((boolean)this.disallowedNetworks.isEmpty());
        this.updater.consume(this.createRecord(100L, key, this.encodeValueForNetworksAndDomains(Arrays.asList(3))));
        this.ensureNetworkAndDomainSuffixDisallowed(3);
        this.ensureNetworkAndDomainSuffixAllowed(1);
        this.ensureNetworkAndDomainSuffixAllowed(2);
        Assertions.assertEquals((long)100L, (Long)this.updater.getLastSeenSequenceId());
        Assertions.assertTrue((boolean)this.disallowedNetworks.isEmpty());
        this.updater.consume(this.createRecord(101L, key, this.encodeValueForNetworksAndDomains(Arrays.asList(11))));
        this.ensureNetworkAndDomainSuffixAllowed(11);
        Assertions.assertEquals((long)101L, (Long)this.updater.getLastSeenSequenceId());
        Assertions.assertEquals((int)2, (int)this.disallowedNetworks.size());
        Assertions.assertTrue((boolean)this.disallowedNetworks.contains("nr1"));
        Assertions.assertTrue((boolean)this.disallowedNetworks.contains("nr2"));
        this.disallowedNetworks.clear();
        this.updater.consume(this.createRecord(102L, key, null));
        this.ensureNetworkAndDomainSuffixDisallowed(11);
        this.ensureNetworkAndDomainSuffixDisallowed(1);
        this.ensureNetworkAndDomainSuffixDisallowed(2);
        Assertions.assertEquals((long)102L, (Long)this.updater.getLastSeenSequenceId());
        Assertions.assertEquals((int)1, (int)this.disallowedNetworks.size());
        Assertions.assertTrue((boolean)this.disallowedNetworks.contains("nr11"));
        this.disallowedNetworks.clear();
        this.updater.consume(this.createRecord(101L, key, this.encodeValueForNetworksAndDomains(Arrays.asList(21))));
        this.ensureNetworkAndDomainSuffixDisallowed(21);
        this.ensureNetworkAndDomainSuffixDisallowed(11);
        Assertions.assertEquals((long)102L, (Long)this.updater.getLastSeenSequenceId());
        this.updater.consume(this.createRecord(103L, key, this.encodeValueForNetworksAndDomains(Arrays.asList(31))));
        this.ensureNetworkAndDomainSuffixAllowed(31);
        Assertions.assertEquals((long)103L, (Long)this.updater.getLastSeenSequenceId());
        Assertions.assertTrue((boolean)this.disallowedNetworks.isEmpty());
        this.updater.consume(this.createRecord(104L, key, "badJson"));
        this.ensureNetworkAndDomainSuffixAllowed(31);
        Assertions.assertEquals((long)104L, (Long)this.updater.getLastSeenSequenceId());
        Assertions.assertTrue((boolean)this.disallowedNetworks.isEmpty());
        this.updater.consume(this.createRecord(105L, key, "{}"));
        this.ensureNetworkAndDomainSuffixAllowed(31);
        Assertions.assertEquals((long)105L, (Long)this.updater.getLastSeenSequenceId());
        this.updater.consume(this.createRecord(106L, key, this.encodeValueWithExtraFields(Arrays.asList(this.networkName(31), this.networkName(1), this.networkName(2)), Arrays.asList(this.dnsDomainSuffix(31), this.dnsDomainSuffix(1), this.dnsDomainSuffix(2)))));
        this.ensureNetworkAndDomainSuffixAllowed(31);
        this.ensureNetworkAndDomainSuffixAllowed(1);
        this.ensureNetworkAndDomainSuffixAllowed(2);
        Assertions.assertEquals((long)106L, (Long)this.updater.getLastSeenSequenceId());
        Assertions.assertTrue((boolean)this.disallowedNetworks.isEmpty());
    }

    private String encodeValueForNetworksAndDomains(List<Integer> networkNumbers) throws IOException {
        LinkedList<String> networkIds = new LinkedList<String>();
        LinkedList<String> dnsDomainSuffixes = new LinkedList<String>();
        for (Integer networkNum : networkNumbers) {
            networkIds.add(this.networkName(networkNum));
            dnsDomainSuffixes.add(this.dnsDomainSuffix(networkNum));
        }
        return this.encodeValue(networkIds, dnsDomainSuffixes);
    }

    private void ensureNetworkAndDomainSuffixAllowed(Integer networkNumber) {
        String networkId = this.networkName(networkNumber);
        String dnsDomainSuffix = "*." + this.dnsDomainSuffix(networkNumber);
        this.ensureNetworkAllowed(networkId);
        this.ensureDNSDomainAllowed(dnsDomainSuffix);
    }

    private void ensureNetworkAndDomainSuffixDisallowed(Integer networkNumber) {
        String networkId = this.networkName(networkNumber);
        String dnsDomainSuffix = "*." + this.dnsDomainSuffix(networkNumber);
        this.ensureNetworkDisallowed(networkId);
        this.ensureDNSDomainDisallowed(dnsDomainSuffix);
    }

    private void ensureNetworkAllowed(String networkId) {
        Assertions.assertTrue((boolean)TrafficNetworkIdRoutesStore.getRoutes((String)this.sessionUuid).allows(networkId));
    }

    private void ensureNetworkDisallowed(String networkId) {
        Assertions.assertFalse((boolean)TrafficNetworkIdRoutesStore.getRoutes((String)this.sessionUuid).allows(networkId));
    }

    private void ensureDNSDomainAllowed(String dnsDomainSuffix) {
        Assertions.assertTrue((boolean)TrafficNetworkIdRoutesStore.getRoutes((String)this.sessionUuid).allowsDNSDomainSuffix(dnsDomainSuffix));
    }

    private void ensureDNSDomainDisallowed(String dnsDomainSuffix) {
        Assertions.assertFalse((boolean)TrafficNetworkIdRoutesStore.getRoutes((String)this.sessionUuid).allowsDNSDomainSuffix(dnsDomainSuffix));
    }

    private String networkName(Integer networkNum) {
        return "nr" + networkNum;
    }

    private String dnsDomainSuffix(Integer networkNum) {
        return "nd" + networkNum + ".us-west-1.confluent.com";
    }

    private static class TestTrafficNetworkIdAllowedRoutes
    extends TrafficNetworkIdAllowedRoutes {
        public TestTrafficNetworkIdAllowedRoutes(List<String> allowedNetworkIds, List<String> allowedDNSDomainSuffixes) {
            super(allowedNetworkIds, allowedDNSDomainSuffixes);
        }

        @JsonProperty(value="fooProperty")
        public String fooProperty() {
            return "fooValue";
        }
    }
}

