/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.dataplane;

import io.confluent.kafka.server.plugins.auth.oauth.KafkaVerificationKeyResolver;
import io.confluent.kafka.server.plugins.auth.oauth.MockBasicAuthStore;
import io.confluent.kafka.server.plugins.auth.oauth.MockTrustCache;
import io.confluent.kafka.test.utils.KafkaTestUtils;
import io.confluent.security.authentication.oauthbearer.AlgorithmWhitelist;
import io.confluent.security.authentication.oauthbearer.ConstrainedVerificationKeyResolver;
import io.confluent.security.authentication.oauthbearer.JwksTestFixture;
import io.confluent.security.authentication.oauthbearer.JwtAuthenticationConfig;
import io.confluent.security.authentication.oauthbearer.KeyConstraintException;
import io.confluent.security.store.KeyValueStore;
import io.confluent.security.test.utils.JwtTestUtils;
import io.confluent.security.util.SecurityContext;
import java.security.Key;
import java.util.ArrayList;
import java.util.Collections;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.JoseException;
import org.jose4j.lang.UnresolvableKeyException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class KafkaVerificationKeyResolverTest {
    private ConstrainedVerificationKeyResolver keyResolver;
    private ConstrainedVerificationKeyResolver unionOfPoolsKeyResolver;
    private SecurityContext unionOfPoolsSecurityContext;
    private final String jwtIssuerA = "https://test-issuer-a.com";
    private final String jwtIssuerB = "https://test-issuer-b.com";
    private final String jwksEndpointA = "https://test-issuer-a.com/jwks.json";
    private final String jwksEndpointB = "https://test-issuer-b.com/jwks.json";
    private final String providerA = "op-a";
    private final String providerB = "op-b";
    private final String poolA = "pool-a";
    private final String orgA = "org-a";
    private final JsonWebKeySet jwks = JwtTestUtils.jsonWebKeySet();
    private final JsonWebKeySet dummyJwks = JwtTestUtils.dummyJsonWebKeySet();
    private MockBasicAuthStore authStore;
    private MockTrustCache authCache;

    @BeforeEach
    public void setUp() throws Exception {
        this.createAuthStore();
        JwtAuthenticationConfig jwtAuthenticationConfig = JwksTestFixture.getStaticConfig();
        AlgorithmWhitelist algorithmWhiteList = new AlgorithmWhitelist(jwtAuthenticationConfig.algorithmWhitelist());
        SecurityContext securityContext = new SecurityContext();
        securityContext.add("jwksEndpoint", (Object)"https://test-issuer-a.com/jwks.json");
        KafkaVerificationKeyResolver verificationKeyResolver = new KafkaVerificationKeyResolver("https://test-issuer-a.com", "uuid", securityContext);
        this.unionOfPoolsSecurityContext = new SecurityContext();
        this.unionOfPoolsSecurityContext.add("jwksEndpoint", (Object)"https://test-issuer-a.com/jwks.json");
        this.unionOfPoolsSecurityContext.add("unionOfPools", (Object)true);
        this.unionOfPoolsSecurityContext.add("orgId", (Object)"org-a");
        KafkaVerificationKeyResolver unionOfPoolsVerificationKeyResolver = new KafkaVerificationKeyResolver("https://test-issuer-a.com", "uuid", this.unionOfPoolsSecurityContext);
        this.keyResolver = new ConstrainedVerificationKeyResolver((VerificationKeyResolver)verificationKeyResolver, Collections.singleton(algorithmWhiteList));
        this.unionOfPoolsKeyResolver = new ConstrainedVerificationKeyResolver((VerificationKeyResolver)unionOfPoolsVerificationKeyResolver, Collections.singleton(algorithmWhiteList));
        JwtTestUtils.updateJwks((KeyValueStore)this.authCache, (String)"https://test-issuer-b.com", (String)"https://test-issuer-b.com/jwks.json", (JsonWebKeySet)this.dummyJwks);
        JwtTestUtils.updateJwks((KeyValueStore)this.authCache, (String)"https://test-issuer-a.com", (String)"https://test-issuer-a.com/jwks.json", (JsonWebKeySet)this.jwks);
        JwtTestUtils.updateIdentityProvider((KeyValueStore)this.authCache, (String)"org-a", (String)"op-b", (String)"sub", (String)"https://test-issuer-b.com", (String)"https://test-issuer-b.com/jwks.json");
        JwtTestUtils.updateIdentityProvider((KeyValueStore)this.authCache, (String)"org-a", (String)"op-a", (String)"sub", (String)"https://test-issuer-a.com", (String)"https://test-issuer-a.com/jwks.json");
        JwtTestUtils.updateIdentityPool((KeyValueStore)this.authCache, (String)"pool-a", (int)1, (String)"https://test-issuer-a.com", (String)"op-a", (String)"https://test-issuer-a.com/jwks.json", (String)"sub", (String)"pool-a", (String)"true", (String)"org-a");
    }

    @AfterEach
    public void tearDown() {
        if (this.authStore != null) {
            this.authStore.close();
        }
        KafkaTestUtils.verifyThreadCleanup();
    }

    private void createAuthStore() throws Exception {
        this.authStore = MockBasicAuthStore.create();
        this.authCache = (MockTrustCache)this.authStore.trustCache();
    }

    @Test
    public void testResolveKey() throws JoseException {
        JsonWebSignature jws = new JsonWebSignature();
        JwtClaims claims = new JwtClaims();
        claims.setIssuer("https://test-issuer-a.com");
        jws.setPayload(claims.toJson());
        jws.setAlgorithmHeaderValue("RS256");
        jws.setKeyIdHeaderValue("568ed7c4-e11a-64b2-5371-36c5b2ae2dcb");
        Key key = this.keyResolver.resolveKey(jws, new ArrayList());
        Assertions.assertNotNull((Object)key);
    }

    @Test
    public void testResolveKeyUnionOfPoolsBasic() throws JoseException {
        JsonWebSignature jws = new JsonWebSignature();
        JwtClaims claims = new JwtClaims();
        claims.setIssuer("https://test-issuer-a.com");
        jws.setPayload(claims.toJson());
        jws.setAlgorithmHeaderValue("RS256");
        jws.setKeyIdHeaderValue("568ed7c4-e11a-64b2-5371-36c5b2ae2dcb");
        Key key = this.unionOfPoolsKeyResolver.resolveKey(jws, new ArrayList());
        Assertions.assertNotNull((Object)key);
        Assertions.assertEquals((Object)"op-a", (Object)this.unionOfPoolsSecurityContext.strVal("providerId", null));
    }

    @Test
    public void testResolveKeyUnionOfPoolsFilter() throws JoseException {
        JsonWebSignature jws = new JsonWebSignature();
        JwtClaims claims = new JwtClaims();
        claims.setIssuer("https://test-issuer-a.com");
        jws.setPayload(claims.toJson());
        jws.setAlgorithmHeaderValue("RS256");
        jws.setKeyIdHeaderValue("568ed7c4-e11a-64b2-5371-36c5b2ae2dcb");
        this.unionOfPoolsSecurityContext.add("identityPoolId", (Object)"pool-a");
        Key key = this.unionOfPoolsKeyResolver.resolveKey(jws, new ArrayList());
        Assertions.assertNotNull((Object)key);
        Assertions.assertEquals((Object)"op-a", (Object)this.unionOfPoolsSecurityContext.strVal("providerId", null));
    }

    @Test
    public void testResolveKeyIssuerAbsentInCache() {
        JsonWebSignature jws = new JsonWebSignature();
        JwtClaims claims = new JwtClaims();
        claims.setIssuer("absent-issuer");
        jws.setPayload(claims.toJson());
        jws.setAlgorithmHeaderValue("RS256");
        jws.setKeyIdHeaderValue("568ed7c4-e11a-64b2-5371-36c5b2ae2dcb");
        Exception exe = (Exception)Assertions.assertThrows(UnresolvableKeyException.class, () -> this.keyResolver.resolveKey(jws, new ArrayList()));
        Assertions.assertTrue((boolean)exe.getMessage().contains("Cannot find key absent-issuer"));
    }

    @Test
    public void testUnResolveKeyInvalidKid() throws JoseException {
        JsonWebSignature jws = new JsonWebSignature();
        jws.setAlgorithmHeaderValue("RS256");
        jws.setKeyIdHeaderValue("k1");
        JwtClaims claims = new JwtClaims();
        claims.setIssuer("https://test-issuer-a.com");
        jws.setPayload(claims.toJson());
        Exception exception = (Exception)Assertions.assertThrows(UnresolvableKeyException.class, () -> this.keyResolver.resolveKey(jws, new ArrayList()));
        Assertions.assertTrue((boolean)exception.getMessage().contains("\"kid\":\"k1\""));
    }

    @Test
    public void testUnResolveKeyNoKid() throws JoseException {
        JsonWebSignature jws = new JsonWebSignature();
        jws.setAlgorithmHeaderValue("RS256");
        JwtClaims claims = new JwtClaims();
        claims.setIssuer("https://test-issuer-a.com");
        jws.setPayload(claims.toJson());
        Exception exception = (Exception)Assertions.assertThrows(UnresolvableKeyException.class, () -> this.keyResolver.resolveKey(jws, new ArrayList()));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Cannot find kid field in the token"));
    }

    @Test
    public void testResolveKeyAlgorithmNotWhiteListed() {
        JsonWebSignature jws = new JsonWebSignature();
        jws.setAlgorithmHeaderValue("ES256");
        jws.setKeyIdHeaderValue("43eeb8e1-6f06-551a-9017-92885575f0a1");
        Exception exception = (Exception)Assertions.assertThrows(UnresolvableKeyException.class, () -> this.keyResolver.resolveKey(jws, new ArrayList()));
        Assertions.assertTrue((boolean)(exception.getCause() instanceof KeyConstraintException));
        Assertions.assertTrue((boolean)exception.getCause().getMessage().contains("ES256"));
    }

    public void testResolveKeyInValidIssuer() throws JoseException {
        JsonWebSignature jws = new JsonWebSignature();
        jws.setAlgorithmHeaderValue("RS256");
        jws.setKeyIdHeaderValue("43eeb8e1-6f06-551a-9017-92885575f0a1");
        Exception exception = (Exception)Assertions.assertThrows(UnresolvableKeyException.class, () -> this.keyResolver.resolveKey(jws, new ArrayList()));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Invalid issuer"));
    }
}

