/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.oauth.mockserver.server;

import com.linkedin.kafka.cruisecontrol.analyzer.goals.RebalanceStep;
import io.confluent.security.auth.oauth.mockserver.common.HttpConnectionException;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.http.HttpServerRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public class CommonHttp {
    private static final ThreadLocal<Logger> CONTEXT_LOG = new ThreadLocal();

    public static void setContextLog(Logger log) {
        CONTEXT_LOG.set(log);
    }

    public static Logger getContextLog() {
        Logger log = CONTEXT_LOG.get();
        return log != null ? log : NOPLogger.NOP_LOGGER;
    }

    @SafeVarargs
    public static <T> boolean isOneOf(T mode, T ... modes) {
        for (T element : modes) {
            if (!element.equals(mode)) continue;
            return true;
        }
        return false;
    }

    public static void sendResponse(HttpServerRequest req, HttpResponseStatus status) {
        CommonHttp.sendResponse(req, status.code(), status.reasonPhrase());
    }

    public static void sendResponse(HttpServerRequest req, HttpResponseStatus status, String text) {
        CommonHttp.sendResponse(req, status.code(), status.reasonPhrase(), text);
    }

    public static void sendResponse(HttpServerRequest req, int statusCode, String statusMessage) {
        CommonHttp.getContextLog().info("< " + statusCode + " " + statusMessage);
        req.response().setStatusCode(statusCode).setStatusMessage(statusMessage).end();
    }

    public static void sendResponse(HttpServerRequest req, int statusCode, String statusMessage, String text) {
        CommonHttp.getContextLog().info("< " + statusCode + " " + statusMessage + "\n" + text);
        req.response().setStatusCode(statusCode).setStatusMessage(statusMessage).end(text);
    }

    static void handleFailure(HttpServerRequest req, Throwable t, Logger log) {
        log.error("An error during processing of request: " + String.valueOf(req), t);
        CommonHttp.sendResponse(req, HttpResponseStatus.INTERNAL_SERVER_ERROR);
    }

    public static String sendGET(String url) throws IOException, HttpConnectionException {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = (hostname, session) -> true;
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
            URL obj = new URL(url);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("User-Agent", "Mozilla/5.0");
            int responseCode = con.getResponseCode();
            if (responseCode == 200) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                return response.toString();
            }
            RebalanceStep.log.warn("HTTP request response code not successful");
            throw new HttpConnectionException("The HTTP connection failed. Returned response code = " + responseCode);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new SSLException("Unable to install an all-trusting host verifier: " + e.getMessage());
        }
    }
}

