/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.oauth.mockserver.server;

import io.confluent.security.auth.oauth.mockserver.common.OAuthAuthenticator;
import io.confluent.security.auth.oauth.mockserver.common.SupportedAlgorithms;
import io.confluent.security.auth.oauth.mockserver.server.MockOAuthServer;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class TokenBuilder {
    private MockOAuthServer mockOAuthServer;
    private String issuer;
    private String subject;
    private int expiry;
    private final List<String> audience;
    private final Map<String, Object> claims;
    private final String clientID;
    private final String clientSecret;
    private SupportedAlgorithms algorithm;

    public TokenBuilder(String clientSecret, String clientID, MockOAuthServer mockOAuthServerObject) {
        this.mockOAuthServer = mockOAuthServerObject;
        this.issuer = "Confluent";
        this.subject = UUID.randomUUID().toString();
        this.expiry = 36;
        this.audience = new ArrayList<String>();
        this.claims = new HashMap<String, Object>();
        this.clientID = clientID;
        this.clientSecret = clientSecret;
        this.algorithm = SupportedAlgorithms.RS256;
    }

    public TokenBuilder setIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public TokenBuilder setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public TokenBuilder setExpiry(int expiry) {
        this.expiry = expiry;
        return this;
    }

    public TokenBuilder addAudience(String audience) {
        this.audience.add(audience);
        return this;
    }

    public TokenBuilder addClaims(String claim, Object value) {
        this.claims.put(claim, value);
        return this;
    }

    public TokenBuilder setAlgo(SupportedAlgorithms supportedAlgorithms) {
        this.algorithm = supportedAlgorithms;
        return this;
    }

    public String build() throws IOException {
        this.claims.put("expiry", this.expiry);
        this.claims.put("audience", this.audience);
        this.claims.put("subject", this.subject);
        this.claims.put("issuer", this.issuer);
        this.claims.put("algorithm", (Object)this.algorithm);
        return OAuthAuthenticator.loginWithClientSecret(URI.create((String)this.mockOAuthServer.getConfig().get((Object)"token-url")), null, null, this.clientID, this.clientSecret, true, this.claims, null, null, null).token();
    }
}

