/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import kafka.admin.MirrorCommand;
import kafka.admin.MirrorCommandOptions;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.ClusterLinkTaskError;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DescribeMirrorsOptions;
import org.apache.kafka.clients.admin.ListMirrorsOptions;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.clients.admin.NewMirrorTopic;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.PartitionTruncationInformation;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.TruncateAndRestoreResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.TopicPlacement;
import org.apache.kafka.server.common.AdminCommandFailedException;
import org.apache.kafka.storage.internals.log.LogConfig;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.io.StdIn$;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

public final class MirrorCommand$
implements Logging {
    public static final MirrorCommand$ MODULE$ = new MirrorCommand$();
    private static final SimpleDateFormat formatter;
    private static int exitCode;
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
        formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        MODULE$.formatter().setTimeZone(TimeZone.getTimeZone("UTC"));
        exitCode = 0;
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        MirrorCommand$ mirrorCommand$ = this;
        synchronized (mirrorCommand$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    private SimpleDateFormat formatter() {
        return formatter;
    }

    private int exitCode() {
        return exitCode;
    }

    private void exitCode_$eq(int x$1) {
        exitCode = x$1;
    }

    public void main(String[] args) {
        try {
            try {
                this.run(args, this.run$default$2());
            }
            catch (Throwable e) {
                Predef$.MODULE$.println("Error while executing mirror command: " + e.getMessage());
                this.error((Function0<String> & Serializable)() -> Utils.stackTrace((Throwable)e));
                this.exitCode_$eq(1);
            }
        }
        finally {
            Exit.exit((int)this.exitCode());
        }
    }

    private ConfluentAdmin createAdminClient(MirrorCommandOptions opts) {
        Properties props = opts.options.has(opts.commandConfigOpt()) ? Utils.loadProps((String)opts.options.valueOf(opts.commandConfigOpt())) : new Properties();
        props.setProperty("bootstrap.servers", opts.options.valueOf(opts.bootstrapServer()));
        return (ConfluentAdmin)AdminClient.create((Properties)props);
    }

    public void run(String[] args, Option<ConfluentAdmin> clientOpt) {
        block33: {
            MirrorCommandOptions opts = new MirrorCommandOptions(args);
            opts.checkArgs();
            try (ConfluentAdmin client = (ConfluentAdmin)clientOpt.getOrElse((Function0<ConfluentAdmin> & Serializable)() -> MODULE$.createAdminClient(opts));){
                try {
                    if (opts.options.has(opts.listOpt())) {
                        this.listMirrors(opts, client);
                    } else if (opts.options.has(opts.describeOpt())) {
                        this.describeMirrors(opts, client);
                    } else if (opts.options.has(opts.listStateTransitionErrorsOpt())) {
                        this.listStateTransitionErrors(opts, client);
                    } else if (opts.options.has(opts.promoteOpt())) {
                        this.stopMirrors(opts, client, AlterMirrorOp.PROMOTE);
                    } else if (opts.options.has(opts.failoverOpt())) {
                        this.stopMirrors(opts, client, AlterMirrorOp.FAILOVER);
                    } else if (opts.options.has(opts.pauseOpt())) {
                        this.pauseMirrors(opts, client, AlterMirrorOp.PAUSE);
                    } else if (opts.options.has(opts.unpauseOpt())) {
                        this.pauseMirrors(opts, client, AlterMirrorOp.RESUME);
                    } else if (opts.options.has(opts.repairOpt())) {
                        this.repairMirrors(opts, client);
                    } else if (opts.options.has(opts.rollbackOpt())) {
                        this.rollbackMirrors(opts, client);
                    } else if (opts.options.has(opts.createOpt())) {
                        this.createMirror(opts, (Admin)client);
                    } else if (opts.options.has(opts.reverseAndStartOpt())) {
                        this.reverseAndSwapMirrors(opts, client, AlterMirrorOp.REVERSE_AND_START_REMOTE_MIRROR);
                    } else if (opts.options.has(opts.reverseAndPauseOpt())) {
                        this.reverseAndSwapMirrors(opts, client, AlterMirrorOp.REVERSE_AND_PAUSE_REMOTE_MIRROR);
                    } else if (opts.options.has(opts.truncateAndRestoreOpt())) {
                        this.truncateAndRestoreMirrors(opts, client);
                    }
                }
                catch (ExecutionException e) {
                    Throwable throwable = e.getCause();
                    if (throwable instanceof TimeoutException) {
                        TimeoutException timeoutException = (TimeoutException)throwable;
                        MirrorCommand$.throwAdminCommandFailedException$1("Timed out waiting for results", (Throwable)timeoutException);
                        break block33;
                    }
                    if (throwable instanceof ClusterAuthorizationException) {
                        ClusterAuthorizationException clusterAuthorizationException = (ClusterAuthorizationException)throwable;
                        MirrorCommand$.throwAdminCommandFailedException$1(clusterAuthorizationException.getMessage(), (Throwable)clusterAuthorizationException);
                        break block33;
                    }
                    throw e;
                }
                catch (Throwable e) {
                    throw e;
                }
            }
        }
    }

    public Option<ConfluentAdmin> run$default$2() {
        return None$.MODULE$;
    }

    private Seq<String> doListMirrors(MirrorCommandOptions opts, ConfluentAdmin client, boolean includeStopped, boolean listRemoteMirrors) {
        ListMirrorsOptions options = new ListMirrorsOptions().includeStopped(includeStopped || opts.includeStopped()).listRemoteMirrors(opts.remoteMirrors() || listRemoteMirrors);
        opts.linkName().foreach((Function1<String, ListMirrorsOptions> & Serializable)linkName -> options.linkName(Optional.of(linkName)));
        return CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)client.listMirrors(options).result().get()).asScala().toSeq();
    }

    private boolean doListMirrors$default$3() {
        return false;
    }

    private boolean doListMirrors$default$4() {
        return false;
    }

    private void listMirrors(MirrorCommandOptions opts, ConfluentAdmin client) {
        this.doListMirrors(opts, client, this.doListMirrors$default$3(), this.doListMirrors$default$4()).foreach((Function1<String, Object> & Serializable)topic -> {
            Predef$.MODULE$.println(topic);
            return BoxedUnit.UNIT;
        });
    }

    private void listStateTransitionErrors(MirrorCommandOptions opts, ConfluentAdmin client) {
        Seq<String> topics = this.resolveTopics(opts, client, this.resolveTopics$default$3(), this.resolveTopics$default$4());
        DescribeMirrorsOptions options = new DescribeMirrorsOptions();
        opts.linkNames().foreach((Function1<List, DescribeMirrorsOptions> & Serializable)l -> options.linkNames((Collection)l));
        opts.states().foreach((Function1<List, DescribeMirrorsOptions> & Serializable)s -> options.states((Collection)s));
        options.includeStateTransitionErrors(true);
        scala.collection.mutable.Map result = CollectionConverters$.MODULE$.MapHasAsScala(client.describeMirrors(CollectionConverters$.MODULE$.SeqHasAsJava(topics).asJava(), options).result()).asScala();
        if (result.nonEmpty()) {
            result.foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
                MirrorCommand$.$anonfun$listStateTransitionErrors$3(x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        Predef$.MODULE$.println("No mirrors found.");
    }

    private void describeMirrors(MirrorCommandOptions opts, ConfluentAdmin client) {
        Seq<String> topics = this.resolveTopics(opts, client, this.resolveTopics$default$3(), this.resolveTopics$default$4());
        DescribeMirrorsOptions options = new DescribeMirrorsOptions();
        opts.linkNames().foreach((Function1<List, DescribeMirrorsOptions> & Serializable)l -> options.linkNames((Collection)l));
        opts.states().foreach((Function1<List, DescribeMirrorsOptions> & Serializable)s -> options.states((Collection)s));
        options.describeRemoteMirrors(opts.remoteMirrors());
        scala.collection.mutable.Map result = CollectionConverters$.MODULE$.MapHasAsScala(client.describeMirrors(CollectionConverters$.MODULE$.SeqHasAsJava(topics).asJava(), options).result()).asScala();
        BooleanRef hasTopic = BooleanRef.create(false);
        if (result.nonEmpty()) {
            scala.collection.immutable.Set partitions = ((IterableOnceOps)result.flatMap((Function1<Tuple2, scala.collection.immutable.Set> & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    scala.collection.immutable.Set set;
                    String topic = (String)tuple2._1();
                    KafkaFuture future = (KafkaFuture)tuple2._2();
                    try {
                        MirrorTopicDescription desc = (MirrorTopicDescription)future.get();
                        set = desc != null ? package$.MODULE$.Range().apply(0, desc.numPartitions()).map((Function1<Object, TopicPartition> & Serializable)part -> MirrorCommand$.$anonfun$describeMirrors$4(topic, BoxesRunTime.unboxToInt(part))).toSet() : Predef$.MODULE$.Set().empty();
                    }
                    catch (Throwable e) {
                        Predef$.MODULE$.println("Unable to get mirror topic description for mirror topic " + topic + ": " + e);
                        set = Predef$.MODULE$.Set().empty();
                    }
                    return set;
                }
                throw new MatchError(tuple2);
            })).toSet();
            scala.collection.mutable.Map replicas = CollectionConverters$.MODULE$.MapHasAsScala(client.replicaStatus(CollectionConverters$.MODULE$.SetHasAsJava(partitions).asJava(), new ReplicaStatusOptions()).result()).asScala();
            result.foreach((Function1<Tuple2, Object> & Serializable)x0$2 -> {
                MirrorCommand$.$anonfun$describeMirrors$5(opts, hasTopic, replicas, x0$2);
                return BoxedUnit.UNIT;
            });
        }
        if (!hasTopic.elem) {
            Predef$.MODULE$.println("No mirror topics found.");
            return;
        }
    }

    public String getMirrorTopicInformation(String topic, MirrorTopicDescription desc) {
        StringBuilder builder = new StringBuilder();
        this.addMirrorTopicInformation(builder, topic, desc);
        return builder.toString();
    }

    public void addMirrorTopicInformation(StringBuilder builder, String topic, MirrorTopicDescription desc) {
        builder.append("Topic: " + topic + "\tLinkName: " + desc.linkName() + "\tLinkId: " + desc.clusterLinkId() + "\tSourceTopic: " + desc.sourceTopic() + "\tState: " + desc.state() + "\tSourceTopicId: " + desc.sourceTopicId() + "\tStoppedSequenceNumber: " + desc.stoppedSequenceNumber() + "\tStateTime: " + this.timeToDate(desc.stateTimeMs()) + "\tlocalTopicId: " + desc.localTopicId());
        MirrorTopicDescription.State state = desc.state();
        MirrorTopicDescription.State state2 = MirrorTopicDescription.State.FAILED;
        if (!(state != null ? !state.equals(state2) : state2 != null)) {
            builder.append("\tFailureReason: " + desc.mirrorTopicError());
            return;
        }
    }

    public String mirrorStateTransitionErrorsStr(String topic, MirrorTopicDescription desc) {
        StringBuilder builder = new StringBuilder();
        if (CollectionConverters$.MODULE$.ListHasAsScala(desc.mirrorStateTransitionErrors()).asScala().nonEmpty()) {
            builder.append("Topic: " + topic);
            builder.append("\tState: " + desc.state().name() + "\n");
            CollectionConverters$.MODULE$.ListHasAsScala(desc.mirrorStateTransitionErrors()).asScala().toSeq().foreach((Function1<ClusterLinkTaskError, StringBuilder> & Serializable)taskErr -> builder.append("Error Code: " + taskErr.errorCode() + "\tError Message: \"" + taskErr.errorMessage() + "\"\n"));
            v0 = BoxedUnit.UNIT;
        } else {
            v0 = builder.append("Topic " + topic + " has no state transition errors\n");
        }
        return builder.toString();
    }

    public String getMirrorPartitionInformation(ReplicaStatus.MirrorInfo mi, ReplicaStatus leader, int part, long stoppedLogEndOffset) {
        long lastSourceFetchHW = mi.lastFetchSourceHighWatermark() != -1L ? mi.lastFetchSourceHighWatermark() : stoppedLogEndOffset;
        long logEndOffset = leader.logEndOffset();
        long lag = lastSourceFetchHW < 0L ? -1L : lastSourceFetchHW - logEndOffset;
        long timeSinceLastFetchMs = leader.lastCaughtUpTimeMs() - mi.lastFetchTimeMs();
        long dataWrittenSinceStopped = logEndOffset - stoppedLogEndOffset;
        StringBuilder builder = new StringBuilder();
        builder.append("\tPartition: " + part + "\tState: " + mi.state().toString() + "\tLocalLogEndOffset: " + logEndOffset);
        ReplicaStatus.MirrorInfo.State state = mi.state();
        ReplicaStatus.MirrorInfo.State state2 = ReplicaStatus.MirrorInfo.State.STOPPED;
        if (state == null ? state2 != null : !state.equals(state2)) {
            v1 = builder.append("\tLastFetchSourceHighWatermark: " + lastSourceFetchHW + "\tLag: " + lag + "\tTimeSinceLastFetchMs: " + timeSinceLastFetchMs);
        } else {
            Serializable serializable = stoppedLogEndOffset >= 0L ? builder.append("\tStoppedLogEndOffset: " + stoppedLogEndOffset) : BoxedUnit.UNIT;
            v1 = dataWrittenSinceStopped >= 0L ? builder.append("\tDataWrittenSinceStopped: " + dataWrittenSinceStopped) : BoxedUnit.UNIT;
        }
        return builder.toString();
    }

    public long getMirrorPartitionInformation$default$4() {
        return -1L;
    }

    public String getMirrorPartitionError(int part, Throwable e) {
        String string;
        Throwable throwable = e;
        if (throwable instanceof ExecutionException) {
            ExecutionException executionException = (ExecutionException)throwable;
            string = executionException.getCause().getMessage();
        } else {
            string = throwable.getMessage();
        }
        String errorMessage = string;
        StringBuilder builder = new StringBuilder();
        builder.append("\tPartition: " + part + "\tFailed to get replica status: " + errorMessage);
        return builder.toString();
    }

    public String getMirrorPartitionUnknown(int part, MirrorTopicDescription desc, long stoppedLogEndOffset) {
        Tuple3<Integer, Integer, Integer> tuple3;
        ReplicaStatus.MirrorInfo.State unknown = ReplicaStatus.MirrorInfo.State.UNKNOWN;
        ReplicaStatus.MirrorInfo.State state = desc != null ? desc.state() : unknown;
        Long stoppedLogEndOffsetDisplay = stoppedLogEndOffset >= 0L ? BoxesRunTime.boxToLong(stoppedLogEndOffset) : unknown;
        ReplicaStatus.MirrorInfo.State state2 = state;
        Tuple3<Integer, Integer, Integer> tuple32 = tuple3 = ReplicaStatus.MirrorInfo.State.FAILED.equals(state2) ? new Tuple3<Integer, Integer, Integer>(BoxesRunTime.boxToInteger(-1), BoxesRunTime.boxToInteger(-1), BoxesRunTime.boxToInteger(-1)) : new Tuple3<ReplicaStatus.MirrorInfo.State, ReplicaStatus.MirrorInfo.State, ReplicaStatus.MirrorInfo.State>(unknown, (ReplicaStatus.MirrorInfo.State)stoppedLogEndOffsetDisplay, unknown);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Integer timeSinceLastFetchMs = tuple3._1();
        Integer lastSourceFetchHW = tuple3._2();
        Integer lag = tuple3._3();
        Tuple3<Integer, Integer, Integer> tuple33 = new Tuple3<Integer, Integer, Integer>(timeSinceLastFetchMs, lastSourceFetchHW, lag);
        Integer timeSinceLastFetchMs2 = tuple33._1();
        Integer lastSourceFetchHW2 = tuple33._2();
        Integer lag2 = tuple33._3();
        StringBuilder builder = new StringBuilder();
        builder.append("\tPartition: " + part + "\tState: " + (Enum)state + "\tLocalLogEndOffset: " + unknown);
        ReplicaStatus.MirrorInfo.State state3 = state;
        MirrorTopicDescription.State state4 = MirrorTopicDescription.State.STOPPED;
        if (state3 == null ? state4 != null : !state3.equals(state4)) {
            v2 = builder.append("\tLastFetchSourceHighWatermark: " + lastSourceFetchHW2 + "\tLag: " + lag2 + "\tTimeSinceLastFetchMs: " + timeSinceLastFetchMs2);
        } else {
            Long l = stoppedLogEndOffsetDisplay;
            ReplicaStatus.MirrorInfo.State state5 = unknown;
            Serializable serializable = (l == null ? state5 != null : !((Object)l).equals(state5)) ? builder.append("\tStoppedLogEndOffset: " + stoppedLogEndOffsetDisplay) : BoxedUnit.UNIT;
            v2 = builder.append("\tDataWrittenSinceStopped: " + unknown);
        }
        return builder.toString();
    }

    public long getMirrorPartitionUnknown$default$3() {
        return -1L;
    }

    private void confirmAction(MirrorCommandOptions opts, AlterMirrorOp alterMirrorOp) {
        String warningMessage = "WARNING: Since the --topics is not provided and only the --link option is provided, all mirror topics associated with this link will undergo the `" + alterMirrorOp + "` operation. Are you sure you want to do this? Please enter y for yes and n for no.";
        if (!this.confirmAction(opts, warningMessage)) {
            Predef$.MODULE$.println("Aborting " + alterMirrorOp + " operation");
            this.exitCode_$eq(1);
            Exit.exit((int)this.exitCode());
            return;
        }
    }

    private boolean confirmAction(MirrorCommandOptions opts, String msg) {
        if (opts.options.has(opts.forceOpt())) {
            return true;
        }
        Predef$.MODULE$.println(msg);
        return StdIn$.MODULE$.readLine().equalsIgnoreCase("y");
    }

    private void stopMirrors(MirrorCommandOptions opts, ConfluentAdmin client, AlterMirrorOp stopOp) {
        Seq<String> topics = this.resolveTopics(opts, client, this.resolveTopics$default$3(), this.resolveTopics$default$4());
        AlterMirrorOp alterMirrorOp = stopOp;
        AlterMirrorOp alterMirrorOp2 = AlterMirrorOp.FAILOVER;
        if (!(alterMirrorOp == null ? alterMirrorOp2 != null : !alterMirrorOp.equals(alterMirrorOp2)) || opts.validateOnly()) {
            if (opts.topics().isEmpty()) {
                this.confirmAction(opts, stopOp);
            }
            this.doStopMirrors(topics, opts, client, stopOp);
            return;
        }
        Predef$.MODULE$.println("Calculating max offset and ms lag for mirror topics: " + topics.mkString("[", ", ", "]"));
        scala.collection.mutable.Map topicToOffsetLag = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        scala.collection.mutable.Map topicToLagMs = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        DescribeMirrorsOptions describeOptions = new DescribeMirrorsOptions();
        scala.collection.mutable.Map result = CollectionConverters$.MODULE$.MapHasAsScala(client.describeMirrors(CollectionConverters$.MODULE$.SeqHasAsJava(topics).asJava(), describeOptions).result()).asScala();
        if (result.nonEmpty()) {
            scala.collection.immutable.Set partitions = ((IterableOnceOps)result.flatMap((Function1<Tuple2, scala.collection.immutable.Set> & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    scala.collection.immutable.Set set;
                    String topic = (String)tuple2._1();
                    KafkaFuture future = (KafkaFuture)tuple2._2();
                    try {
                        MirrorTopicDescription desc = (MirrorTopicDescription)future.get();
                        if (desc == null) {
                            throw new IllegalStateException("Unexpectedly did not get a description for " + topic + ".");
                        }
                        topicToOffsetLag.put(topic, BoxesRunTime.boxToLong(-1L));
                        topicToLagMs.put(topic, BoxesRunTime.boxToLong(-1L));
                        set = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), desc.numPartitions()).map((Function1<Object, TopicPartition> & Serializable)part -> MirrorCommand$.$anonfun$stopMirrors$2(topic, BoxesRunTime.unboxToInt(part))).toSet();
                    }
                    catch (Throwable e) {
                        Predef$.MODULE$.println("Unable to get mirror topic description for mirror topic " + topic + ": " + e);
                        set = Predef$.MODULE$.Set().empty();
                    }
                    return set;
                }
                throw new MatchError(tuple2);
            })).toSet();
            scala.collection.mutable.Map replicas = CollectionConverters$.MODULE$.MapHasAsScala(client.replicaStatus(CollectionConverters$.MODULE$.SetHasAsJava(partitions).asJava(), new ReplicaStatusOptions()).result()).asScala();
            result.foreach((Function1<Tuple2, Object> & Serializable)x0$2 -> {
                MirrorCommand$.$anonfun$stopMirrors$3(replicas, topicToOffsetLag, topicToLagMs, x0$2);
                return BoxedUnit.UNIT;
            });
        } else {
            Predef$.MODULE$.println("No mirror topics found to calculate lag and offset.");
            this.exitCode_$eq(1);
            Exit.exit((int)this.exitCode());
        }
        Predef$.MODULE$.println("Finished calculating max offset lag and max lag ms for mirror topics: " + topics.mkString("[", ", ", "]"));
        Set violatingTopics = (Set)Set$.MODULE$.apply(Nil$.MODULE$);
        topics.foreach((Function1<String, Object> & Serializable)t -> {
            if (topicToOffsetLag.contains(t) && topicToLagMs.contains(t)) {
                long topicOffsetLag = BoxesRunTime.unboxToLong(topicToOffsetLag.apply(t));
                long topicLagMs = BoxesRunTime.unboxToLong(topicToLagMs.apply(t));
                if (topicLagMs > 0L || topicOffsetLag > 0L) {
                    return violatingTopics.$plus$eq(t);
                }
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
        if (violatingTopics.nonEmpty()) {
            Predef$.MODULE$.println("Found following mirror topics with greater lag offset and/or lag ms than specified: " + violatingTopics.mkString("[", ", ", "]") + ". Not proceeding with promote. If you still wish to promote, use the failover command instead.");
            violatingTopics.foreach((Function1<String, Object> & Serializable)t -> {
                MirrorCommand$.$anonfun$stopMirrors$10(topicToLagMs, topicToOffsetLag, t);
                return BoxedUnit.UNIT;
            });
            this.exitCode_$eq(1);
            Exit.exit((int)this.exitCode());
        }
        if (opts.topics().isEmpty()) {
            this.confirmAction(opts, stopOp);
        }
        this.doStopMirrors(topics, opts, client, stopOp);
    }

    private void doStopMirrors(Seq<String> topics, MirrorCommandOptions opts, ConfluentAdmin client, AlterMirrorOp stopOp) {
        String action = opts.validateOnly() ? "validated" : "scheduled";
        scala.collection.immutable.Map ops = ((IterableOnceOps)topics.map((Function1<String, Tuple2> & Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$4), stopOp))).toMap($less$colon$less$.MODULE$.refl());
        AlterMirrorsOptions options = new AlterMirrorsOptions().validateOnly(opts.validateOnly());
        CollectionConverters$.MODULE$.MapHasAsScala(client.alterMirrors(CollectionConverters$.MODULE$.MapHasAsJava(ops).asJava(), options).values()).asScala().foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            MirrorCommand$.$anonfun$doStopMirrors$2(action, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void reverseAndSwapMirrors(MirrorCommandOptions opts, ConfluentAdmin client, AlterMirrorOp reverseAndSwapOp) {
        Seq<String> topics = this.resolveTopics(opts, client, this.resolveTopics$default$3(), this.resolveTopics$default$4());
        if (opts.topics().isEmpty()) {
            this.confirmAction(opts, reverseAndSwapOp);
        }
        AlterMirrorOp alterMirrorOp = reverseAndSwapOp;
        AlterMirrorOp alterMirrorOp2 = AlterMirrorOp.REVERSE_AND_START_REMOTE_MIRROR;
        String upperCommand = !(alterMirrorOp != null ? !alterMirrorOp.equals(alterMirrorOp2) : alterMirrorOp2 != null) ? "Request for reversing local mirror and starting remote mirror" : "Request for reversing local mirror and pausing remote mirror";
        String lowerCommand = upperCommand.toLowerCase(Locale.ROOT);
        String action = opts.validateOnly() ? "validated" : "scheduled";
        scala.collection.immutable.Map ops = ((IterableOnceOps)topics.map((Function1<String, Tuple2> & Serializable)x$5 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$5), reverseAndSwapOp))).toMap($less$colon$less$.MODULE$.refl());
        AlterMirrorsOptions options = new AlterMirrorsOptions().validateOnly(opts.validateOnly());
        CollectionConverters$.MODULE$.MapHasAsScala(client.alterMirrors(CollectionConverters$.MODULE$.MapHasAsJava(ops).asJava(), options).values()).asScala().foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            MirrorCommand$.$anonfun$reverseAndSwapMirrors$2(upperCommand, action, lowerCommand, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void truncateAndRestoreMirrors(MirrorCommandOptions opts, ConfluentAdmin client) {
        if (opts.topics().isEmpty()) {
            this.confirmAction(opts, AlterMirrorOp.TRUNCATE_AND_RESTORE);
        }
        Seq<String> topics = this.resolveTopics(opts, client, true, true);
        String action = opts.validateOnly() ? "validated" : "scheduled";
        scala.collection.immutable.Map ops = ((IterableOnceOps)topics.map((Function1<String, Tuple2> & Serializable)x$6 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$6), AlterMirrorOp.TRUNCATE_AND_RESTORE))).toMap($less$colon$less$.MODULE$.refl());
        AlterMirrorsOptions options = new AlterMirrorsOptions().validateOnly(opts.validateOnly()).includePartitionLevelTruncationData(opts.includePartitionData()).linkName((String)opts.linkName().getOrElse((Function0<Nothing$> & Serializable)() -> {
            throw new IllegalArgumentException("Link name must be provided for truncate and restore.");
        }));
        CollectionConverters$.MODULE$.MapHasAsScala(client.alterMirrors(CollectionConverters$.MODULE$.MapHasAsJava(ops).asJava(), options).truncateAndRestoreValues()).asScala().foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            MirrorCommand$.$anonfun$truncateAndRestoreMirrors$3(opts, action, x0$1);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println("Please use the describe command to monitor progress.");
    }

    private void pauseMirrors(MirrorCommandOptions opts, ConfluentAdmin client, AlterMirrorOp pauseOp) {
        Seq<String> topics = this.resolveTopics(opts, client, this.resolveTopics$default$3(), this.resolveTopics$default$4());
        if (opts.topics().isEmpty()) {
            this.confirmAction(opts, pauseOp);
        }
        AlterMirrorOp alterMirrorOp = pauseOp;
        AlterMirrorOp alterMirrorOp2 = AlterMirrorOp.PAUSE;
        String upperCommand = !(alterMirrorOp != null ? !alterMirrorOp.equals(alterMirrorOp2) : alterMirrorOp2 != null) ? "Pausing" : "Resuming";
        String lowerCommand = upperCommand.toLowerCase(Locale.ROOT);
        String action = opts.validateOnly() ? "validated" : "completed";
        scala.collection.immutable.Map ops = ((IterableOnceOps)topics.map((Function1<String, Tuple2> & Serializable)x$7 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$7), pauseOp))).toMap($less$colon$less$.MODULE$.refl());
        AlterMirrorsOptions options = new AlterMirrorsOptions().validateOnly(opts.validateOnly());
        CollectionConverters$.MODULE$.MapHasAsScala(client.alterMirrors(CollectionConverters$.MODULE$.MapHasAsJava(ops).asJava(), options).values()).asScala().foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            MirrorCommand$.$anonfun$pauseMirrors$2(upperCommand, action, lowerCommand, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void repairMirrors(MirrorCommandOptions opts, ConfluentAdmin client) {
        Seq<String> topics = this.resolveTopics(opts, client, this.resolveTopics$default$3(), this.resolveTopics$default$4());
        if (opts.topics().isEmpty()) {
            this.confirmAction(opts, AlterMirrorOp.REPAIR);
        }
        String action = opts.validateOnly() ? "validated" : "completed";
        scala.collection.immutable.Map ops = ((IterableOnceOps)topics.map((Function1<String, Tuple2> & Serializable)x$8 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$8), AlterMirrorOp.REPAIR))).toMap($less$colon$less$.MODULE$.refl());
        AlterMirrorsOptions options = new AlterMirrorsOptions().validateOnly(opts.validateOnly());
        CollectionConverters$.MODULE$.MapHasAsScala(client.alterMirrors(CollectionConverters$.MODULE$.MapHasAsJava(ops).asJava(), options).values()).asScala().foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            MirrorCommand$.$anonfun$repairMirrors$2(action, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void rollbackMirrors(MirrorCommandOptions opts, ConfluentAdmin client) {
        Seq<String> topics = this.resolveTopics(opts, client, this.resolveTopics$default$3(), this.resolveTopics$default$4());
        if (opts.topics().isEmpty()) {
            this.confirmAction(opts, AlterMirrorOp.ROLLBACK);
        }
        String action = opts.validateOnly() ? "validated" : "completed";
        scala.collection.immutable.Map ops = ((IterableOnceOps)topics.map((Function1<String, Tuple2> & Serializable)x$9 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$9), AlterMirrorOp.ROLLBACK))).toMap($less$colon$less$.MODULE$.refl());
        AlterMirrorsOptions options = new AlterMirrorsOptions().validateOnly(opts.validateOnly());
        CollectionConverters$.MODULE$.MapHasAsScala(client.alterMirrors(CollectionConverters$.MODULE$.MapHasAsJava(ops).asJava(), options).values()).asScala().foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            MirrorCommand$.$anonfun$rollbackMirrors$2(action, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void createMirror(MirrorCommandOptions opts, Admin client) {
        MirrorCommand.MirrorCommandTopicPartition topic = new MirrorCommand.MirrorCommandTopicPartition(opts);
        if (Topic.hasCollisionChars((String)topic.name().get())) {
            Predef$.MODULE$.println("WARNING: Due to limitations in metric names, topics with a period ('.') or underscore ('_') could collide. To avoid issues it is best to use either, but not both.");
        }
        if (topic.replicationFactor().exists((Function1<Integer, Object> & Serializable)rf -> BoxesRunTime.boxToBoolean(MirrorCommand$.$anonfun$createMirror$1(rf)))) {
            throw new IllegalArgumentException("The replication factor must be between 1 and " + Short.MAX_VALUE + " inclusive");
        }
        try {
            None$ partitions = None$.MODULE$;
            NewTopic newTopic = new NewTopic(topic.name().get(), OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(partitions)), OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(topic.replicationFactor().map((Function1<Integer, Object> & Serializable)x$10 -> BoxesRunTime.boxToShort(MirrorCommand$.$anonfun$createMirror$2(x$10))).map((Function1<Object, Short> & Serializable)x -> MirrorCommand$.$anonfun$createMirror$3(BoxesRunTime.unboxToShort(x))))));
            Map configsMap = CollectionConverters$.MODULE$.MapHasAsJava(((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(topic.configs().stringPropertyNames()).asScala().map((Function1<String, Tuple2> & Serializable)name -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), topic.configs().getProperty((String)name)))).toMap($less$colon$less$.MODULE$.refl())).asJava();
            newTopic.configs(configsMap);
            topic.mirrorTopic().foreach((Function1<String, NewTopic> & Serializable)mt -> newTopic.mirror(Optional.of(new NewMirrorTopic(topic.linkName().get(), mt, (OffsetSpec)topic.offsetSpec().orNull($less$colon$less$.MODULE$.refl())))));
            CreateTopicsResult createResult = client.createTopics(Collections.singleton(newTopic), new CreateTopicsOptions().retryOnQuotaViolation(false));
            createResult.all().get();
            Predef$.MODULE$.println("Created topic " + topic.name().get() + ".");
        }
        catch (ExecutionException e) {
            if (e.getCause() == null) {
                throw e;
            }
            throw e.getCause();
        }
    }

    private Seq<String> resolveTopics(MirrorCommandOptions opts, ConfluentAdmin client, boolean includeStopped, boolean listRemoteMirror) {
        Option<Seq<String>> option = opts.topics();
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq topics = (Seq)some.value();
            return topics;
        }
        if (None$.MODULE$.equals(option)) {
            return this.doListMirrors(opts, client, includeStopped, listRemoteMirror);
        }
        throw new MatchError(option);
    }

    private boolean resolveTopics$default$3() {
        return false;
    }

    private boolean resolveTopics$default$4() {
        return false;
    }

    public Properties parseTopicConfigsToBeAdded(MirrorCommandOptions opts) {
        Buffer configsToBeAdded = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala((List)opts.topicConfig().getOrElse((Function0<List> & Serializable)() -> Collections.emptyList())).asScala().map((Function1<String, String[]> & Serializable)x$11 -> x$11.split("\\s*=\\s*"));
        Predef$.MODULE$.require(configsToBeAdded.forall((Function1<String[], Object> & Serializable)config -> BoxesRunTime.boxToBoolean(MirrorCommand$.$anonfun$parseTopicConfigsToBeAdded$3(config))), (Function0<Object>)(Function0<String> & Serializable)() -> "Invalid topic config: all configs to be added must be in the format \"key=val\".");
        Properties props = new Properties();
        configsToBeAdded.foreach((Function1<String[], Object> & Serializable)pair -> props.setProperty(pair[0].trim(), pair[1].trim()));
        LogConfig.validate(props);
        if (props.containsKey("confluent.placement.constraints")) {
            throw new IllegalArgumentException("Configuration cannot contain 'confluent.placement.constraints' option. Use --replica-placement command line option instead.");
        }
        opts.replicaPlacement().map((Function1<String, String> & Serializable)path -> {
            String string;
            try {
                string = Utils.readFileAsString((String)path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return string;
        }).flatMap((Function1<String, Option> & Serializable)json -> OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(TopicPlacement.parse(json)))).foreach((Function1<TopicPlacement, Object> & Serializable)placement -> props.put("confluent.placement.constraints", placement.toJson()));
        return props;
    }

    public String timeToDate(long timeMs) {
        return this.formatter().format(new Date(timeMs));
    }

    private static final void throwAdminCommandFailedException$1(String message, Throwable cause) {
        throw new AdminCommandFailedException(message, cause);
    }

    public static final /* synthetic */ void $anonfun$listStateTransitionErrors$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Option topicDescOpt;
            Option option;
            String topic = (String)tuple2._1();
            KafkaFuture future = (KafkaFuture)tuple2._2();
            try {
                MirrorTopicDescription topicDesc = (MirrorTopicDescription)future.get();
                option = new Some<MirrorTopicDescription>(topicDesc);
            }
            catch (ExecutionException e) {
                MODULE$.warn((Function0<String> & Serializable)() -> "Failed to get the description for " + topic, (Function0<Throwable>)(Function0<ExecutionException> & Serializable)() -> e);
                option = None$.MODULE$;
            }
            Option option2 = topicDescOpt = option;
            if (option2 instanceof Some) {
                Option option3 = option2;
                MirrorTopicDescription td = (MirrorTopicDescription)((Some)option3).value();
                Predef$.MODULE$.print(MODULE$.mirrorStateTransitionErrorsStr(topic, td));
            } else if (None$.MODULE$.equals(option2)) {
                Predef$.MODULE$.println("Failed to get mirror topic description for mirror topic " + topic + ".");
            } else {
                throw new MatchError(option2);
            }
            Predef$.MODULE$.println();
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ TopicPartition $anonfun$describeMirrors$4(String topic$2, int part) {
        return new TopicPartition(topic$2, part);
    }

    public static final /* synthetic */ Object $anonfun$describeMirrors$6(Option stoppedLogEndOffsets$1, scala.collection.mutable.Map replicas$1, String topic$3, MirrorCommandOptions opts$2, MirrorTopicDescription desc$1, ArrayBuffer partitionErrors$1, int part) {
        Object object;
        block12: {
            long l;
            Option option = stoppedLogEndOffsets$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                Seq offsets = (Seq)some.value();
                try {
                    l = Predef$.MODULE$.Long2long((Long)offsets.apply(part));
                }
                catch (Throwable e) {
                    MODULE$.warn((Function0<String> & Serializable)() -> "Unable to get stoppedLogEndOffsets. " + e);
                    l = -1L;
                }
            } else if (None$.MODULE$.equals(option)) {
                l = -1L;
            } else {
                throw new MatchError(option);
            }
            long stoppedLogEndOffset = l;
            try {
                ReplicaStatus leader = (ReplicaStatus)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala((List)((KafkaFuture)replicas$1.apply(new TopicPartition(topic$3, part))).get()).asScala().filter((Function1<ReplicaStatus, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.isLeader()))).head();
                if (!leader.mirrorInfo().isPresent()) {
                    throw new ClusterLinkNotFoundException("Mirror state not associated with the partition");
                }
                ReplicaStatus.MirrorInfo mi = (ReplicaStatus.MirrorInfo)leader.mirrorInfo().get();
                if (opts$2.pendingStoppedOnly()) {
                    ReplicaStatus.MirrorInfo.State state = mi.state();
                    ReplicaStatus.MirrorInfo.State state2 = ReplicaStatus.MirrorInfo.State.PENDING_STOPPED;
                    if (!(state != null ? !state.equals(state2) : state2 != null)) {
                        Predef$.MODULE$.println(MODULE$.getMirrorPartitionInformation(mi, leader, part, MODULE$.getMirrorPartitionInformation$default$4()));
                        object = BoxedUnit.UNIT;
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    break block12;
                }
                Predef$.MODULE$.println(MODULE$.getMirrorPartitionInformation(mi, leader, part, stoppedLogEndOffset));
                object = BoxedUnit.UNIT;
            }
            catch (Throwable e) {
                Predef$.MODULE$.println(MODULE$.getMirrorPartitionUnknown(part, desc$1, stoppedLogEndOffset));
                object = partitionErrors$1.$plus$eq(MODULE$.getMirrorPartitionError(part, e));
            }
        }
        return object;
    }

    public static final /* synthetic */ void $anonfun$describeMirrors$10(String partError) {
        Predef$.MODULE$.println(partError);
        MODULE$.error((Function0<String> & Serializable)() -> String.valueOf(partError));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final /* synthetic */ void $anonfun$describeMirrors$5(MirrorCommandOptions opts$2, BooleanRef hasTopic$1, scala.collection.mutable.Map replicas$1, Tuple2 x0$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) throw new MatchError(tuple2);
        String topic = (String)tuple2._1();
        KafkaFuture future = (KafkaFuture)tuple2._2();
        try {
            block9: {
                MirrorTopicDescription desc;
                block8: {
                    desc = (MirrorTopicDescription)future.get();
                    if (desc == null) {
                        boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    if (!opts$2.pendingStoppedOnly()) break block8;
                    MirrorTopicDescription.State state = desc.state();
                    MirrorTopicDescription.State state2 = MirrorTopicDescription.State.PENDING_STOPPED;
                    if (state != null ? !state.equals(state2) : state2 != null) break block9;
                }
                Predef$.MODULE$.println(MODULE$.getMirrorTopicInformation(topic, desc));
                hasTopic$1.elem = true;
                MirrorTopicDescription.State state = desc.state();
                MirrorTopicDescription.State state3 = MirrorTopicDescription.State.STOPPED;
                None$ stoppedLogEndOffsets = !(state != null ? !state.equals(state3) : state3 != null) && desc.stoppedLogEndOffsets() != null ? new Some(CollectionConverters$.MODULE$.ListHasAsScala(desc.stoppedLogEndOffsets()).asScala().toSeq()) : None$.MODULE$;
                ArrayBuffer partitionErrors = new ArrayBuffer(desc.numPartitions());
                package$.MODULE$.Range().apply(0, desc.numPartitions()).foreach((Function1<Object, Object> & Serializable)part -> MirrorCommand$.$anonfun$describeMirrors$6(stoppedLogEndOffsets, replicas$1, topic, opts$2, desc, partitionErrors, BoxesRunTime.unboxToInt(part)));
                if (partitionErrors.nonEmpty()) {
                    String summaryMessage = "Partition errors for topic " + topic + ":";
                    Predef$.MODULE$.println(summaryMessage);
                    MODULE$.error((Function0<String> & Serializable)() -> summaryMessage);
                    partitionErrors.foreach((Function1<String, Object> & Serializable)partError -> {
                        MirrorCommand$.$anonfun$describeMirrors$10(partError);
                        return BoxedUnit.UNIT;
                    });
                    boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                boxedUnit = BoxedUnit.UNIT;
                return;
            }
            boxedUnit = BoxedUnit.UNIT;
            return;
        }
        catch (ExecutionException e) {
            Predef$.MODULE$.println("Topic: " + topic + "\tError: " + e.getCause());
            boxedUnit = BoxedUnit.UNIT;
            return;
        }
        catch (Throwable e) {
            Predef$.MODULE$.println("Topic: " + topic + "\tError: " + e);
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ TopicPartition $anonfun$stopMirrors$2(String topic$4, int part) {
        return new TopicPartition(topic$4, part);
    }

    public static final /* synthetic */ Object $anonfun$stopMirrors$4(scala.collection.mutable.Map replicas$2, String topic$5, scala.collection.mutable.Map topicToOffsetLag$1, scala.collection.mutable.Map topicToLagMs$1, int part) {
        Serializable serializable;
        block4: {
            try {
                ReplicaStatus leader = (ReplicaStatus)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala((List)((KafkaFuture)replicas$2.apply(new TopicPartition(topic$5, part))).get()).asScala().filter((Function1<ReplicaStatus, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(x$3.isLeader()))).head();
                if (leader.mirrorInfo().isPresent()) {
                    ReplicaStatus.MirrorInfo mi = (ReplicaStatus.MirrorInfo)leader.mirrorInfo().get();
                    long timeSinceLastFetchMs = leader.lastCaughtUpTimeMs() - mi.lastFetchTimeMs();
                    long lagOffset = mi.lastFetchSourceHighWatermark() - leader.logEndOffset();
                    Serializable serializable2 = BoxesRunTime.unboxToLong(topicToOffsetLag$1.getOrElse(topic$5, () -> -1L)) < lagOffset ? topicToOffsetLag$1.put(topic$5, BoxesRunTime.boxToLong(lagOffset)) : BoxedUnit.UNIT;
                    serializable = BoxesRunTime.unboxToLong(topicToLagMs$1.getOrElse(topic$5, () -> -1L)) < timeSinceLastFetchMs && BoxesRunTime.unboxToLong(topicToOffsetLag$1.getOrElse(topic$5, () -> -1L)) < lagOffset ? topicToLagMs$1.put(topic$5, BoxesRunTime.boxToLong(timeSinceLastFetchMs)) : BoxedUnit.UNIT;
                    break block4;
                }
                serializable = BoxedUnit.UNIT;
            }
            catch (ExecutionException e) {
                Predef$.MODULE$.println("Error while calculating lag for mirror topic " + topic$5 + " partition " + part + ": " + e.getCause());
                serializable = BoxedUnit.UNIT;
            }
            catch (Throwable throwable) {
                Predef$.MODULE$.println("Error while calculating lag for mirror topic " + topic$5 + " partition " + part + ". Mirror partition may have failed.");
                serializable = BoxedUnit.UNIT;
            }
        }
        return serializable;
    }

    public static final /* synthetic */ void $anonfun$stopMirrors$3(scala.collection.mutable.Map replicas$2, scala.collection.mutable.Map topicToOffsetLag$1, scala.collection.mutable.Map topicToLagMs$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            BoxedUnit boxedUnit;
            String topic = (String)tuple2._1();
            KafkaFuture future = (KafkaFuture)tuple2._2();
            try {
                MirrorTopicDescription desc = (MirrorTopicDescription)future.get();
                if (desc == null) {
                    throw new IllegalStateException("Unexpectedly did not get a description for " + topic + ".");
                }
                package$.MODULE$.Range().apply(0, desc.numPartitions()).foreach((Function1<Object, Object> & Serializable)part -> MirrorCommand$.$anonfun$stopMirrors$4(replicas$2, topic, topicToOffsetLag$1, topicToLagMs$1, BoxesRunTime.unboxToInt(part)));
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (ExecutionException e) {
                Predef$.MODULE$.println("Failed to get mirror description for topic mirror " + topic + ": " + e.getCause());
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable e) {
                Predef$.MODULE$.println("Failed to get mirror description for mirror topic " + topic + ": " + e);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$stopMirrors$10(scala.collection.mutable.Map topicToLagMs$1, scala.collection.mutable.Map topicToOffsetLag$1, String t) {
        Predef$.MODULE$.println("Max lag ms for mirror topic " + t + ": " + topicToLagMs$1.apply(t));
        Predef$.MODULE$.println("Max offset lag for mirror topic " + t + ": " + topicToOffsetLag$1.apply(t));
        Predef$.MODULE$.println();
    }

    public static final /* synthetic */ void $anonfun$doStopMirrors$2(String action$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            BoxedUnit boxedUnit;
            String topic = (String)tuple2._1();
            KafkaFuture future = (KafkaFuture)tuple2._2();
            try {
                future.get();
                Predef$.MODULE$.println("Request for stopping topic " + topic + "'s mirror was successfully " + action$1 + ". Please use the describe command with the --pending-stopped-only option to monitor progress.");
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable ex) {
                Predef$.MODULE$.println("Error encountered while stopping topic " + topic + "'s mirror: " + ex);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$reverseAndSwapMirrors$2(String upperCommand$1, String action$2, String lowerCommand$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            BoxedUnit boxedUnit;
            String topic = (String)tuple2._1();
            KafkaFuture future = (KafkaFuture)tuple2._2();
            try {
                future.get();
                Predef$.MODULE$.println(upperCommand$1 + " for topic " + topic + " was successfully " + action$2 + ", Please use the describe command to monitor progress.");
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable ex) {
                Predef$.MODULE$.println("Error encountered while " + lowerCommand$1 + " for topic " + topic + ": " + ex);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$truncateAndRestoreMirrors$4(PartitionTruncationInformation x0$2) {
        PartitionTruncationInformation partitionTruncationInformation = x0$2;
        Predef$.MODULE$.println("Partition " + partitionTruncationInformation.partitionId() + ": " + partitionTruncationInformation.messagesTruncated() + " messages truncated, resulting offset " + partitionTruncationInformation.offsetTruncatedTo());
    }

    public static final /* synthetic */ void $anonfun$truncateAndRestoreMirrors$3(MirrorCommandOptions opts$3, String action$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            BoxedUnit boxedUnit;
            String topic = (String)tuple2._1();
            KafkaFuture future = (KafkaFuture)tuple2._2();
            try {
                TruncateAndRestoreResult result = (TruncateAndRestoreResult)future.get();
                if (opts$3.includePartitionData()) {
                    Predef$.MODULE$.println("Request for truncate and restore for topic " + topic + " was successfully " + action$3 + ". " + result.messagesTruncated() + " messages will be truncated, from the following partitions: ");
                    CollectionConverters$.MODULE$.ListHasAsScala(result.partitionLevelTruncationData()).asScala().foreach((Function1<PartitionTruncationInformation, Object> & Serializable)x0$2 -> {
                        MirrorCommand$.$anonfun$truncateAndRestoreMirrors$4(x0$2);
                        return BoxedUnit.UNIT;
                    });
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    Predef$.MODULE$.println("Request for truncate and restore for topic " + topic + " was successfully " + action$3 + ". " + result.messagesTruncated() + " messages will be truncated.");
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (Throwable ex) {
                Predef$.MODULE$.println("Error encountered while requesting truncate and restore for topic " + topic + ": " + ex);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$pauseMirrors$2(String upperCommand$2, String action$4, String lowerCommand$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            BoxedUnit boxedUnit;
            String topic = (String)tuple2._1();
            KafkaFuture future = (KafkaFuture)tuple2._2();
            try {
                future.get();
                Predef$.MODULE$.println(upperCommand$2 + " topic '" + topic + "'s mirror was successfully " + action$4 + ".");
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable ex) {
                Predef$.MODULE$.println("Error encountered while " + lowerCommand$2 + " topic '" + topic + "'s mirror: " + ex);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$repairMirrors$2(String action$5, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            BoxedUnit boxedUnit;
            String topic = (String)tuple2._1();
            KafkaFuture future = (KafkaFuture)tuple2._2();
            try {
                future.get();
                Predef$.MODULE$.println("Request for repairing failed mirror topic '" + topic + "' was successfully " + action$5 + ".");
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable ex) {
                Predef$.MODULE$.println("Error encountered while repairing failed mirror topic '" + topic + "': " + ex);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$rollbackMirrors$2(String action$6, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            BoxedUnit boxedUnit;
            String topic = (String)tuple2._1();
            KafkaFuture future = (KafkaFuture)tuple2._2();
            try {
                future.get();
                Predef$.MODULE$.println("Request for rolling back mirror topic '" + topic + "' was successfully " + action$6 + ".");
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable ex) {
                Predef$.MODULE$.println("Error encountered while rolling back mirror topic '" + topic + "': " + ex);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$createMirror$1(Integer rf) {
        return Predef$.MODULE$.Integer2int(rf) > Short.MAX_VALUE || Predef$.MODULE$.Integer2int(rf) < 1;
    }

    public static final /* synthetic */ short $anonfun$createMirror$2(Integer x$10) {
        return (short)Predef$.MODULE$.Integer2int(x$10);
    }

    public static final /* synthetic */ Short $anonfun$createMirror$3(short x) {
        return BoxesRunTime.boxToShort(x);
    }

    public static final /* synthetic */ boolean $anonfun$parseTopicConfigsToBeAdded$3(String[] config) {
        return config.length == 2;
    }

    private MirrorCommand$() {
    }
}

