/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin.balancer;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import joptsimple.OptionSpec;
import kafka.admin.balancer.BalancerCommandOptions;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.admin.BalancerOperationError;
import org.apache.kafka.clients.admin.BrokerAdditionDescription;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeBrokerAdditionsResult;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.BalancerOfflineException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.AdminCommandFailedException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class BrokerAdditionCommand$
implements Logging {
    public static final BrokerAdditionCommand$ MODULE$ = new BrokerAdditionCommand$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        BrokerAdditionCommand$ brokerAdditionCommand$ = this;
        synchronized (brokerAdditionCommand$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public void main(String[] args) {
        int exitCode = 0;
        Option clientOpt = None$.MODULE$;
        try {
            try {
                BalancerCommandOptions opts = new BalancerCommandOptions(args);
                opts.checkArgs();
                clientOpt = new Some<ConfluentAdmin>(this.createAdminClient(opts));
                this.runAddition(opts, (ConfluentAdmin)clientOpt.get());
            }
            catch (Throwable e) {
                Predef$.MODULE$.println("Unexpected error while running the kafka-add-brokers command-line tool: " + e.getMessage());
                this.error((Function0<String> & Serializable)() -> Utils.stackTrace((Throwable)e));
                exitCode = 1;
            }
        }
        finally {
            clientOpt.foreach((Function1<ConfluentAdmin, Object> & Serializable)x$1 -> {
                x$1.close();
                return BoxedUnit.UNIT;
            });
            Exit.exit((int)exitCode);
        }
    }

    public void runAddition(BalancerCommandOptions opts, ConfluentAdmin client) {
        try {
            Option brokerIdOpt = opts.options.has(opts.brokerIdOpt()) ? new Some<Integer>(BoxesRunTime.boxToInteger(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(opts.valueOf(opts.brokerIdOpt()))))) : None$.MODULE$;
            this.describeBrokerAddition(brokerIdOpt, client);
        }
        catch (ApiException e) {
            ApiException apiException = e;
            if (apiException instanceof TimeoutException) {
                throw new AdminCommandFailedException("Timed out waiting for the broker addition results", e);
            }
            if (apiException instanceof ClusterAuthorizationException) {
                ClusterAuthorizationException clusterAuthorizationException = (ClusterAuthorizationException)apiException;
                throw new AdminCommandFailedException(clusterAuthorizationException.getMessage(), e);
            }
            if (apiException instanceof BalancerOfflineException) {
                BalancerOfflineException balancerOfflineException = (BalancerOfflineException)apiException;
                throw new AdminCommandFailedException(balancerOfflineException.getMessage(), (Throwable)balancerOfflineException);
            }
            throw e;
        }
        catch (Throwable e) {
            Predef$.MODULE$.println("Error while issuing the describe broker additions request");
            throw e;
        }
    }

    public void describeBrokerAddition(Option<Object> brokerIdOpt, ConfluentAdmin client) {
        List list;
        Object msgAnnex = "";
        DescribeBrokerAdditionsResult brokerAdditionsResult = client.describeBrokerAdditions();
        Option<Object> option = brokerIdOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            int brokerId = BoxesRunTime.unboxToInt(some.value());
            msgAnnex = " for broker " + brokerId;
            Option option2 = OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional((Optional)brokerAdditionsResult.description(brokerId).get()));
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                BrokerAdditionDescription additionDesc = (BrokerAdditionDescription)some2.value();
                list = new $colon$colon<Nothing$>((Nothing$)additionDesc, Nil$.MODULE$);
            } else {
                list = Nil$.MODULE$;
            }
        } else if (None$.MODULE$.equals(option)) {
            list = CollectionConverters$.MODULE$.CollectionHasAsScala(((Map)brokerAdditionsResult.descriptions().get()).values()).asScala();
        } else {
            throw new MatchError(option);
        }
        Nil$ additions = list;
        if (additions.isEmpty()) {
            Predef$.MODULE$.println("No broker additions in progress" + (String)msgAnnex);
            return;
        }
        additions.foreach((Function1<BrokerAdditionDescription, Object> & Serializable)desc -> {
            Predef$.MODULE$.println(BrokerAdditionCommand$.MODULE$.additionDescriptionString(desc));
            return BoxedUnit.UNIT;
        });
    }

    private String additionDescriptionString(BrokerAdditionDescription desc) {
        String lineSeparator = System.lineSeparator() + "  ";
        String baseStringDescription = "Broker " + desc.brokerId() + " addition status - " + desc.generalOperationStatus() + ". Sub-task statuses:" + lineSeparator + "Partition Reassignment: " + desc.partitionReassignmentsStatus();
        if (desc.additionError().isPresent()) {
            BalancerOperationError balancerOpError = (BalancerOperationError)desc.additionError().get();
            baseStringDescription = baseStringDescription + lineSeparator + balancerOpError.exception().getClass().getName() + ": " + balancerOpError.errorMessage();
        }
        baseStringDescription = baseStringDescription + lineSeparator + "Operation Creation Time: " + ClientUtils.utcDateFor((long)desc.createTimeMs());
        baseStringDescription = baseStringDescription + lineSeparator + "Operation Last Update Time: " + ClientUtils.utcDateFor((long)desc.lastUpdateTimeMs());
        return baseStringDescription;
    }

    public ConfluentAdmin createAdminClient(BalancerCommandOptions opts) {
        Properties props = opts.options.has(opts.commandConfigOpt()) ? Utils.loadProps((String)opts.options.valueOf(opts.commandConfigOpt())) : new Properties();
        props.setProperty("bootstrap.servers", opts.options.valueOf(opts.bootstrapServer()));
        return ConfluentAdmin.create((Properties)props);
    }

    public String flagName(OptionSpec<?> option) {
        return "--" + option.options().get(0);
    }

    private BrokerAdditionCommand$() {
    }
}

