/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin.balancer;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import kafka.admin.balancer.ClusterRebalanceCommandOptions;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.admin.BalancerOperationError;
import org.apache.kafka.clients.admin.BalancerSelfHealMode;
import org.apache.kafka.clients.admin.BalancerStatus;
import org.apache.kafka.clients.admin.BalancerStatusDescription;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.EvenClusterLoadPlan;
import org.apache.kafka.clients.admin.EvenClusterLoadStatus;
import org.apache.kafka.clients.admin.EvenClusterLoadStatusDescription;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.BalancerLoadError;
import org.apache.kafka.common.errors.BalancerOfflineException;
import org.apache.kafka.common.errors.BalancerOperationFailedException;
import org.apache.kafka.common.errors.BrokerAdditionInProgressException;
import org.apache.kafka.common.errors.BrokerFailureFixInProgressException;
import org.apache.kafka.common.errors.BrokerRemovalInProgressException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.EvenClusterLoadTaskInProgressException;
import org.apache.kafka.common.errors.RebalancePlanComputationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.AdminCommandFailedException;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;

public final class ClusterRebalanceCommand$
implements Logging {
    public static final ClusterRebalanceCommand$ MODULE$ = new ClusterRebalanceCommand$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ClusterRebalanceCommand$ clusterRebalanceCommand$ = this;
        synchronized (clusterRebalanceCommand$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public void main(String[] args) {
        int exitCode = 0;
        Option clientOpt = None$.MODULE$;
        try {
            try {
                ClusterRebalanceCommandOptions opts = new ClusterRebalanceCommandOptions(args);
                opts.checkArgs();
                clientOpt = new Some<ConfluentAdmin>(this.createAdminClient(opts));
                if (opts.options.has(opts.statusOpt())) {
                    this.runBalancerCommand(opts, (ConfluentAdmin)clientOpt.get(), (Function1<ConfluentAdmin, BoxedUnit>)(Function1<ConfluentAdmin, Object> & Serializable)client -> {
                        ClusterRebalanceCommand$.MODULE$.describeBalancerStatus(client);
                        return BoxedUnit.UNIT;
                    });
                } else if (opts.options.has(opts.describeOpt())) {
                    this.runBalancerCommand(opts, (ConfluentAdmin)clientOpt.get(), (Function1<ConfluentAdmin, BoxedUnit>)(Function1<ConfluentAdmin, Object> & Serializable)client -> {
                        ClusterRebalanceCommand$.MODULE$.describeAnyUnevenLoadTask(client);
                        return BoxedUnit.UNIT;
                    });
                } else if (opts.options.has(opts.rebalanceOpt())) {
                    List<String> list = this.createGoalList(opts);
                    this.runBalancerCommand(opts, (ConfluentAdmin)clientOpt.get(), (Function1<ConfluentAdmin, BoxedUnit>)(Function1<ConfluentAdmin, Object> & Serializable)client -> {
                        ClusterRebalanceCommand$.MODULE$.triggerEvenClusterLoad(list, client);
                        return BoxedUnit.UNIT;
                    });
                } else if (opts.options.has(opts.evenClusterLoadPlanOpt())) {
                    List<String> list = this.createGoalList(opts);
                    this.runBalancerCommand(opts, (ConfluentAdmin)clientOpt.get(), (Function1<ConfluentAdmin, BoxedUnit>)(Function1<ConfluentAdmin, Object> & Serializable)client -> {
                        ClusterRebalanceCommand$.MODULE$.computeEvenClusterLoadPlan(list, client);
                        return BoxedUnit.UNIT;
                    });
                }
            }
            catch (Throwable e) {
                Predef$.MODULE$.println("Unexpected error while running the kafka-rebalance-cluster command-line tool: " + e.getMessage());
                this.error((Function0<String> & Serializable)() -> Utils.stackTrace((Throwable)e));
                exitCode = 1;
            }
        }
        finally {
            clientOpt.foreach((Function1<ConfluentAdmin, Object> & Serializable)x$1 -> {
                x$1.close();
                return BoxedUnit.UNIT;
            });
            Exit.exit((int)exitCode);
        }
    }

    public void runBalancerCommand(ClusterRebalanceCommandOptions opts, ConfluentAdmin client, Function1<ConfluentAdmin, BoxedUnit> adminOperation) {
        try {
            adminOperation.apply(client);
        }
        catch (ApiException e) {
            ApiException apiException = e;
            if (apiException instanceof TimeoutException) {
                throw new AdminCommandFailedException("Timed out waiting for the balancer status", e);
            }
            if (apiException instanceof ClusterAuthorizationException) {
                ClusterAuthorizationException clusterAuthorizationException = (ClusterAuthorizationException)apiException;
                throw new AdminCommandFailedException(clusterAuthorizationException.getMessage(), e);
            }
            if (apiException instanceof BalancerOfflineException ? true : (apiException instanceof BalancerLoadError ? true : (apiException instanceof BrokerRemovalInProgressException ? true : (apiException instanceof BrokerAdditionInProgressException ? true : (apiException instanceof EvenClusterLoadTaskInProgressException ? true : (apiException instanceof BrokerFailureFixInProgressException ? true : (apiException instanceof RebalancePlanComputationException ? true : apiException instanceof BalancerOperationFailedException))))))) {
                throw new AdminCommandFailedException(apiException.getMessage(), apiException);
            }
            throw e;
        }
        catch (Throwable e) {
            Predef$.MODULE$.println("Error while issuing the balancer status request");
            throw e;
        }
    }

    public void describeBalancerStatus(ConfluentAdmin client) {
        String lineSeparator = System.lineSeparator() + "  ";
        BalancerStatusDescription balancerStatusDescription = (BalancerStatusDescription)client.describeBalancerStatus().description().get();
        BalancerStatus balancerStatus = balancerStatusDescription.balancerStatus();
        String balancerStatusString = "Balancer status: " + balancerStatus;
        balancerStatusString = balancerStatusString + System.lineSeparator();
        balancerStatusString = balancerStatusString + "Balancer is running on brokers: " + balancerStatusDescription.brokerIds();
        if (balancerStatusDescription.balancerOperationError().isPresent()) {
            balancerStatusString = balancerStatusString + lineSeparator;
            balancerStatusString = balancerStatusString + ((BalancerOperationError)balancerStatusDescription.balancerOperationError().get()).exception().getClass().getName() + ": " + ((BalancerOperationError)balancerStatusDescription.balancerOperationError().get()).errorMessage();
        }
        Predef$.MODULE$.println(balancerStatusString);
    }

    public void describeAnyUnevenLoadTask(ConfluentAdmin client) {
        String lineSeparator = System.lineSeparator() + "  ";
        EvenClusterLoadStatusDescription balancerUnevenLoadTaskDescription = (EvenClusterLoadStatusDescription)client.describeEvenClusterLoadStatus().description().get();
        BalancerSelfHealMode healUnevenLoadTrigger = balancerUnevenLoadTaskDescription.healUnevenLoadTrigger();
        EvenClusterLoadStatus currentBalancerUnevenLoadStatus = balancerUnevenLoadTaskDescription.currentEvenClusterLoadStatus();
        boolean processedError = false;
        String unevenLoadTaskDescriptionString = "Uneven load balance status:" + lineSeparator;
        unevenLoadTaskDescriptionString = unevenLoadTaskDescriptionString + "HealUnevenLoadTrigger: " + healUnevenLoadTrigger;
        if (currentBalancerUnevenLoadStatus != null) {
            unevenLoadTaskDescriptionString = unevenLoadTaskDescriptionString + lineSeparator + "Current: " + currentBalancerUnevenLoadStatus;
            if (this.eligibleToDisplayError(currentBalancerUnevenLoadStatus)) {
                unevenLoadTaskDescriptionString = unevenLoadTaskDescriptionString + lineSeparator + ((BalancerOperationError)balancerUnevenLoadTaskDescription.evenClusterLoadError().get()).exception().getClass().getName() + ": " + ((BalancerOperationError)balancerUnevenLoadTaskDescription.evenClusterLoadError().get()).errorMessage();
                processedError = true;
            }
            if (this.shouldDisplayUnevenLoadStatusUpdateTime(currentBalancerUnevenLoadStatus)) {
                unevenLoadTaskDescriptionString = unevenLoadTaskDescriptionString + lineSeparator + "Last Update Time: " + ClientUtils.utcDateFor((long)balancerUnevenLoadTaskDescription.currentStatusLastUpdatetimeMs());
            }
        } else {
            unevenLoadTaskDescriptionString = unevenLoadTaskDescriptionString + lineSeparator + " No current status.";
        }
        if (balancerUnevenLoadTaskDescription.previousEvenClusterLoadStatus() != null) {
            unevenLoadTaskDescriptionString = unevenLoadTaskDescriptionString + lineSeparator + "Previous: " + balancerUnevenLoadTaskDescription.previousEvenClusterLoadStatus();
            if (!processedError && this.eligibleToDisplayError(balancerUnevenLoadTaskDescription.previousEvenClusterLoadStatus())) {
                unevenLoadTaskDescriptionString = unevenLoadTaskDescriptionString + lineSeparator + ((BalancerOperationError)balancerUnevenLoadTaskDescription.evenClusterLoadError().get()).exception().getClass().getName() + ": " + ((BalancerOperationError)balancerUnevenLoadTaskDescription.evenClusterLoadError().get()).errorMessage();
            }
            if (this.shouldDisplayUnevenLoadStatusUpdateTime(balancerUnevenLoadTaskDescription.previousEvenClusterLoadStatus())) {
                unevenLoadTaskDescriptionString = unevenLoadTaskDescriptionString + lineSeparator + "Last Update Time: " + ClientUtils.utcDateFor((long)balancerUnevenLoadTaskDescription.previousStatusLastUpdatetimeMs());
            }
        }
        Predef$.MODULE$.println(unevenLoadTaskDescriptionString);
    }

    public void triggerEvenClusterLoad(List<String> goalList, ConfluentAdmin client) {
        Predef$.MODULE$.println("Triggering an even cluster load...");
        client.triggerEvenClusterLoad(goalList).result().get();
        Predef$.MODULE$.println("Triggered an even cluster load operation. You can check its status by calling this command again with the `--describe` option.");
    }

    public void computeEvenClusterLoadPlan(List<String> goalList, ConfluentAdmin client) {
        Predef$.MODULE$.println("Computing even cluster load plan...");
        String plan = ((EvenClusterLoadPlan)client.computeEvenClusterLoadPlan(goalList).result().get()).printableForm();
        Predef$.MODULE$.println(plan);
    }

    private boolean eligibleToDisplayError(EvenClusterLoadStatus evenClusterLoadStatus) {
        return evenClusterLoadStatus.equals((Object)EvenClusterLoadStatus.BALANCING_FAILED);
    }

    public boolean shouldDisplayPreviousUnevenLoadStatus(EvenClusterLoadStatus evenClusterLoadStatus) {
        return evenClusterLoadStatus != null && !evenClusterLoadStatus.equals((Object)EvenClusterLoadStatus.STARTING);
    }

    private boolean shouldDisplayUnevenLoadStatusUpdateTime(EvenClusterLoadStatus evenClusterLoadStatus) {
        return this.shouldDisplayPreviousUnevenLoadStatus(evenClusterLoadStatus);
    }

    private ConfluentAdmin createAdminClient(ClusterRebalanceCommandOptions opts) {
        Properties props = opts.options.has(opts.commandConfigOpt()) ? Utils.loadProps((String)opts.options.valueOf(opts.commandConfigOpt())) : new Properties();
        props.setProperty("bootstrap.servers", opts.options.valueOf(opts.bootstrapServer()));
        props.setProperty("request.timeout.ms", opts.options.valueOf(opts.requestTimeout()));
        return ConfluentAdmin.create((Properties)props);
    }

    private List<String> createGoalList(ClusterRebalanceCommandOptions opts) {
        if (opts.options.has(opts.goalListOpt())) {
            return Utils.createGoalList((String)opts.options.valueOf(opts.goalListOpt()));
        }
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().empty()).asJava();
    }

    private ClusterRebalanceCommand$() {
    }
}

