/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog;

import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.confluent.k2.kafka.K2TopicMetadata;
import io.confluent.k2.kafka.image.publisher.K2MetadataPublisher;
import io.confluent.k2.kafka.image.publisher.K2TopicsImage;
import io.confluent.k2.kafka.image.publisher.K2TopicsImageAndVersion;
import io.confluent.protobuf.events.catalog.v1.MetadataChange;
import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import io.confluent.telemetry.api.events.Event;
import io.confluent.telemetry.api.events.EventEmitter;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import kafka.catalog.CatalogMetrics;
import kafka.catalog.K2MetadataEventProvider;
import kafka.catalog.MetadataEventUtils;
import kafka.common.TenantHelpers;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.slf4j.Logger;

public final class K2MetadataCatalogUpdater
implements K2MetadataPublisher {
    private final Logger log;
    private final Metrics metrics;
    private final Supplier<EventEmitter> eventEmitterSupplier;
    private final Supplier<Boolean> isEligibleCatalogUpdater;
    private final boolean fullConfigsEnabled;
    private final long initDelayMs;
    private final long snapshotIntervalMs;
    private final long iterationIntervalMs;
    private final int maxBytesInSnapshot;
    private final String destTopic;
    private final Scheduler scheduler;
    private final Time time;
    private final MetricName activeCollectorMetricName;
    private K2TopicsImage previousImage;
    private long lastSnapshotEmissionMs;
    private final AtomicReference<State> state;
    private volatile K2TopicsImage latestImage = K2TopicsImage.EMPTY;
    private volatile ScheduledFuture<?> scheduledFuture;
    private volatile CatalogMetrics catalogMetrics;

    public static K2MetadataCatalogUpdater newInstance(Metrics metrics, Supplier<Boolean> isEligibleCatalogUpdater, boolean fullConfigsEnabled, int snapshotInitDelaySec, int snapshotIntervalSec, int maxBytesInSnapshot, String destTopic, Time time, int brokerId) {
        return new K2MetadataCatalogUpdater(metrics, () -> ((Metrics)metrics).eventEmitter(), isEligibleCatalogUpdater, fullConfigsEnabled, TimeUnit.SECONDS.toMillis(snapshotInitDelaySec), TimeUnit.SECONDS.toMillis(snapshotIntervalSec), maxBytesInSnapshot, destTopic, time, brokerId);
    }

    K2MetadataCatalogUpdater(Metrics metrics, Supplier<EventEmitter> eventEmitterSupplier, Supplier<Boolean> isEligibleCatalogUpdater, boolean fullConfigsEnabled, long initDelayMs, long snapshotIntervalMs, int maxBytesInSnapshot, String destTopic, Time time, int brokerId) {
        this.metrics = metrics;
        this.eventEmitterSupplier = eventEmitterSupplier;
        this.isEligibleCatalogUpdater = isEligibleCatalogUpdater;
        this.fullConfigsEnabled = fullConfigsEnabled;
        this.initDelayMs = initDelayMs;
        this.snapshotIntervalMs = snapshotIntervalMs;
        this.iterationIntervalMs = Math.max(1L, snapshotIntervalMs / 5L);
        this.maxBytesInSnapshot = maxBytesInSnapshot;
        this.destTopic = destTopic;
        this.time = time;
        this.state = new AtomicReference<State>(State.INACTIVE);
        this.log = new LogContext("[" + this.getClass().getSimpleName() + " id=" + brokerId + "] ").logger(this.getClass());
        this.log.info("Constructed, init delay {}ms, snapshot interval {}ms, iteration interval {}ms", new Object[]{initDelayMs, snapshotIntervalMs, this.iterationIntervalMs});
        this.activeCollectorMetricName = metrics.metricName("active-collector", "catalog-metrics", "Reports 1 if the catalog metadata collector is active, 0 otherwise.");
        metrics.addMetric(this.activeCollectorMetricName, (config, now) -> this.isActive() ? 1.0 : 0.0);
        this.scheduler = new KafkaScheduler(1, true, "k2-catalog-updater-", false);
    }

    public boolean isActive() {
        return this.state.get() == State.ACTIVE;
    }

    State getState() {
        return this.state.get();
    }

    public boolean start() {
        return this.start(this.getProcessTopicMetadataRunnable());
    }

    synchronized boolean start(Runnable scheduledTask) {
        this.log.debug("Received start request");
        if (!this.state.compareAndSet(State.INACTIVE, State.ACTIVE)) {
            this.log.info("Unable to start, current state is " + String.valueOf((Object)this.state.get()));
            return false;
        }
        this.log.info("State transitioned to " + String.valueOf((Object)State.ACTIVE));
        this.scheduler.startup();
        this.catalogMetrics = new CatalogMetrics(this.metrics, () -> 0);
        Runnable wrapped = () -> {
            boolean isEligible = false;
            try {
                isEligible = this.isEligibleCatalogUpdater.get();
            }
            catch (Exception e) {
                this.log.warn("Encountered exception while checking eligibility, considering ineligible", (Throwable)e);
            }
            if (!isEligible) {
                if (this.state.compareAndSet(State.ACTIVE, State.ACTIVE_INELIGIBLE)) {
                    this.log.info("State transitioned from {} to {}", (Object)State.ACTIVE, (Object)State.ACTIVE_INELIGIBLE);
                }
                return;
            }
            if (this.state.compareAndSet(State.ACTIVE_INELIGIBLE, State.ACTIVE)) {
                this.log.info("State transitioned from {} to {}", (Object)State.ACTIVE_INELIGIBLE, (Object)State.ACTIVE);
            }
            scheduledTask.run();
        };
        this.scheduledFuture = this.scheduler.schedule("K2MetadataSnapshotEmitter", wrapped, this.initDelayMs, this.iterationIntervalMs);
        return true;
    }

    public synchronized boolean stop() throws Exception {
        this.log.debug("Received stop request");
        State previousState = this.state.getAndSet(State.STOPPED);
        if (previousState == State.STOPPED) {
            this.log.info("Unable to stop, current state is already " + String.valueOf((Object)State.STOPPED));
            return false;
        }
        this.log.info("State transitioned from {} to {}", (Object)previousState, (Object)State.STOPPED);
        if (previousState != State.INACTIVE) {
            this.catalogMetrics.removeCatalogMetrics();
            this.scheduledFuture.cancel(true);
            this.metrics.removeMetric(this.activeCollectorMetricName);
            this.scheduler.shutdown();
        }
        return true;
    }

    Runnable getProcessTopicMetadataRunnable() {
        return () -> {
            block5: {
                try {
                    K2TopicsImage currentImage = this.latestImage;
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("Processing topic metadata.\n\tpreviousImage: {}\n\tlatestImage: {}", (Object)this.previousImage, (Object)currentImage);
                    }
                    if (!currentImage.equals(this.previousImage)) {
                        this.buildAndEmitTopicDeltas(this.previousImage, currentImage);
                    }
                    this.previousImage = currentImage;
                    long monotonicNowMs = this.time.hiResClockMs();
                    if (monotonicNowMs - this.snapshotIntervalMs > this.lastSnapshotEmissionMs) {
                        this.buildAndEmitTenantSnapshots(currentImage, monotonicNowMs);
                    }
                }
                catch (Exception e) {
                    this.log.error("Encountered exception while emitting K2 metadata events", (Throwable)e);
                    CatalogMetrics currCatalogMetrics = this.catalogMetrics;
                    if (currCatalogMetrics == null) break block5;
                    currCatalogMetrics.collectorEventHandleErrorSensor.record();
                }
            }
        };
    }

    private void buildAndEmitTopicDeltas(K2TopicsImage prev, K2TopicsImage curr) {
        this.log.debug("Emitting topic deltas");
        HashMap<Uuid, String> prevTopicIdToName = prev != null ? new HashMap<Uuid, String>(prev.topicIdToName()) : new HashMap();
        curr.topicIdToName().forEach((topicId, topicName) -> {
            if (!TenantHelpers.isTenantPrefixed(topicName)) {
                return;
            }
            String tenant = TenantHelpers.extractTenantPrefix(topicName, false);
            String prevName = (String)prevTopicIdToName.remove(topicId);
            K2TopicMetadata topicMetadata = (K2TopicMetadata)curr.topicNameToMetadata().get(topicName);
            if (prevName == null) {
                this.emitTopicCreateEvent(tenant, topicMetadata);
                return;
            }
            K2TopicMetadata prevTopicMetadata = (K2TopicMetadata)prev.topicNameToMetadata().get(prevName);
            if (prevTopicMetadata == null) {
                this.log.warn("Inconsistent previous image {}, metadata not found for topic with ID {} and name {}", new Object[]{prev, topicId, prevName});
                return;
            }
            if (!prevTopicMetadata.equals(topicMetadata)) {
                this.emitTopicUpdateEvent(tenant, prevTopicMetadata, topicMetadata);
            }
        });
        prevTopicIdToName.forEach((topicId, topicName) -> {
            if (!TenantHelpers.isTenantPrefixed(topicName)) {
                return;
            }
            String tenant = TenantHelpers.extractTenantPrefix(topicName, false);
            K2TopicMetadata prevTopicMetadata = (K2TopicMetadata)prev.topicNameToMetadata().get(topicName);
            if (prevTopicMetadata == null) {
                this.log.warn("Inconsistent previous image {}, metadata not found for topic with ID {} and name {}", new Object[]{prev, topicId, topicName});
                return;
            }
            this.emitTopicDeleteEvent(tenant, prevTopicMetadata);
        });
    }

    private void buildAndEmitTenantSnapshots(K2TopicsImage topicsImage, long monotonicNowMs) {
        this.lastSnapshotEmissionMs = monotonicNowMs;
        this.log.debug("Emitting tenant snapshots with monotonic timestamp {}", (Object)this.lastSnapshotEmissionMs);
        HashMap<String, Set> topicsByTenant = new HashMap<String, Set>();
        topicsImage.topicNameToMetadata().forEach((topicName, topicMetadata) -> {
            if (!TenantHelpers.isTenantPrefixed(topicName)) {
                return;
            }
            String tenant = TenantHelpers.extractTenantPrefix(topicName, false);
            Uuid topicId = (Uuid)topicsImage.topicNameToId().get(topicName);
            topicsByTenant.computeIfAbsent(tenant, t -> new TreeSet()).add(topicId);
        });
        topicsByTenant.forEach((tenant, topicIds) -> this.emitSnapshotEvent((String)tenant, (Set<Uuid>)topicIds, topicsImage));
    }

    private void emitTopicCreateEvent(String tenant, K2TopicMetadata topicMetadata) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Emitting topic create for tenant {} and topic metadata {}", (Object)tenant, (Object)topicMetadata);
        }
        MetadataEvent metadataEvent = this.newDeltaMetadataUpdateEvent(topicMetadata, false);
        MetadataChange change = MetadataEventUtils.entityCreateEvent(tenant, metadataEvent);
        this.emit(change);
    }

    private void emitTopicUpdateEvent(String tenant, K2TopicMetadata prevTopicMetadata, K2TopicMetadata topicMetadata) {
        MetadataEvent metadataEvent;
        MetadataEvent prevMetadataEvent;
        if (this.log.isTraceEnabled()) {
            this.log.trace("Emitting topic update for tenant {}, old topic metadata {}, and new topic metadata {}", new Object[]{tenant, prevTopicMetadata, topicMetadata});
        }
        if (!MetadataEventUtils.eventHasChanged(prevMetadataEvent = this.newDeltaMetadataUpdateEvent(prevTopicMetadata, true), metadataEvent = this.newDeltaMetadataUpdateEvent(topicMetadata, true))) {
            return;
        }
        MetadataChange change = MetadataEventUtils.entityUpdateEvent(tenant, metadataEvent);
        this.emit(change);
    }

    private void emitTopicDeleteEvent(String tenant, K2TopicMetadata topicMetadata) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Emitting topic delete for tenant {} and topic metadata {}", (Object)tenant, (Object)topicMetadata);
        }
        Timestamp now = Timestamps.fromMillis(this.time.milliseconds());
        MetadataEvent metadataEvent = MetadataEventUtils.topicMetadataEventForDeletion(TenantHelpers.extractLogicalName(topicMetadata.topicName()), Optional.of(topicMetadata.topicId().toString()), now);
        MetadataChange change = MetadataEventUtils.entityDeleteEvent(tenant, metadataEvent);
        this.emit(change);
    }

    private void emit(MetadataChange change) {
        Event toEmit = MetadataEventUtils.topicMetadataDeltaCloudEvent(change, 1, this.destTopic);
        MetadataEventUtils.emitAndLogError(this.eventEmitterSupplier.get(), toEmit, this.catalogMetrics, this.log);
    }

    private MetadataEvent newDeltaMetadataUpdateEvent(K2TopicMetadata topicMetadata, boolean isUpdate) {
        boolean isVirtual = topicMetadata.isVirtual();
        int numPartitions = isVirtual ? 1 : topicMetadata.numPartitions();
        int replicationFactor = isVirtual ? 0 : -1;
        Timestamp now = Timestamps.fromMillis(this.time.milliseconds());
        return MetadataEventUtils.topicMetadataEventFromLogConfig(K2MetadataCatalogUpdater.createLogConfigForK2Metadata(topicMetadata), TenantHelpers.extractLogicalName(topicMetadata.topicName()), topicMetadata.topicId(), numPartitions, replicationFactor, null, this.fullConfigsEnabled, isUpdate ? now : null, !isUpdate ? now : null);
    }

    static LogConfig createLogConfigForK2Metadata(K2TopicMetadata k2TopicMetadata) {
        return LogConfig.fromProps(k2TopicMetadata.topicConfigs(), new Properties());
    }

    private void emitSnapshotEvent(String tenant, Set<Uuid> topicIds, K2TopicsImage topicsImage) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Emitting snapshot for tenant {} with topic IDs {} and topics image {}", new Object[]{tenant, topicIds, topicsImage});
        }
        MetadataEventUtils.buildAndEmitSnapshot(tenant, new K2MetadataEventProvider(topicIds, topicsImage, this.fullConfigsEnabled), this.maxBytesInSnapshot, 1, this.destTopic, this.eventEmitterSupplier.get(), this.catalogMetrics, this.log);
    }

    @Override
    public void onK2MetadataUpdate(K2TopicsImageAndVersion currentK2TopicsImageAndVersion) {
        K2TopicsImage newImage = currentK2TopicsImageAndVersion.image();
        if (newImage == null) {
            throw new IllegalArgumentException("New K2TopicsImage cannot be null");
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Received K2 topic metadata update with image {}", (Object)newImage);
        } else {
            this.log.debug("Received K2 topic metadata update");
        }
        this.latestImage = newImage;
    }

    static enum State {
        INACTIVE,
        ACTIVE,
        ACTIVE_INELIGIBLE,
        STOPPED;

    }
}

