/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog;

import io.confluent.k2.kafka.K2TopicMetadata;
import io.confluent.k2.kafka.image.publisher.K2TopicsImage;
import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import java.util.Collections;
import java.util.Set;
import kafka.catalog.K2MetadataCatalogUpdater;
import kafka.catalog.MetadataEventProvider;
import kafka.catalog.MetadataEventUtils;
import kafka.common.TenantHelpers;
import org.apache.kafka.common.Uuid;

public class K2MetadataEventProvider
implements MetadataEventProvider<Uuid> {
    public static final int DEFAULT_CONTROLLER_EPOCH = 1;
    public static final int DEFAULT_REPLICATION_FACTOR = -1;
    private final Set<Uuid> topics;
    private final K2TopicsImage topicsImage;
    private final boolean fullConfigsEnabled;

    public K2MetadataEventProvider(Set<Uuid> topics, K2TopicsImage topicsImage, boolean fullConfigsEnabled) {
        this.topics = topics;
        this.topicsImage = topicsImage;
        this.fullConfigsEnabled = fullConfigsEnabled;
    }

    @Override
    public Iterable<Uuid> topicIterable() {
        return this.topics;
    }

    @Override
    public Iterable<Uuid> clusterLinkIterable() {
        return Collections.emptySet();
    }

    @Override
    public MetadataEvent getTopicMetadata(Uuid topicId) {
        String topicName = (String)this.topicsImage.topicIdToName().get(topicId);
        K2TopicMetadata topicMetadata = (K2TopicMetadata)this.topicsImage.topicNameToMetadata().get(topicName);
        return this.newSnapshotMetadataUpdateEvent(topicMetadata);
    }

    @Override
    public MetadataEvent getClusterLinkMetadata(Uuid clusterLink) {
        return null;
    }

    private MetadataEvent newSnapshotMetadataUpdateEvent(K2TopicMetadata topicMetadata) {
        boolean isVirtual = topicMetadata.isVirtual();
        int numPartitions = isVirtual ? 1 : topicMetadata.numPartitions();
        int replicationFactor = isVirtual ? 0 : -1;
        return MetadataEventUtils.topicMetadataEventFromLogConfig(K2MetadataCatalogUpdater.createLogConfigForK2Metadata(topicMetadata), TenantHelpers.extractLogicalName(topicMetadata.topicName()), topicMetadata.topicId(), numPartitions, replicationFactor, null, this.fullConfigsEnabled, null, null);
    }
}

