/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import kafka.coordinator.PartitionLoadScheduler;
import kafka.coordinator.transaction.InitProducerIdResult;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.coordinator.transaction.TransactionLoggingVerbosity$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMarkerChannelManager$;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.transaction.ProducerIdManager;
import org.apache.kafka.coordinator.transaction.TransactionLogConfig;
import org.apache.kafka.coordinator.transaction.TransactionStateManagerConfig;
import org.apache.kafka.coordinator.transaction.TxnTransitMetadata;
import org.apache.kafka.metadata.MetadataCache;
import org.apache.kafka.metadata.TopicPlacement;
import org.apache.kafka.server.util.Scheduler;
import scala.Function0;
import scala.Function1;
import scala.jdk.javaapi.OptionConverters$;

public final class TransactionCoordinator$ {
    public static final TransactionCoordinator$ MODULE$ = new TransactionCoordinator$();

    public TransactionCoordinator apply(KafkaConfig config, ReplicaManager replicaManager, Scheduler scheduler, Function0<ProducerIdManager> createProducerIdGenerator, Metrics metrics, MetadataCache metadataCache, Time time) {
        TransactionLogConfig transactionLogConfig = new TransactionLogConfig(config);
        TransactionStateManagerConfig transactionStateManagerConfig = new TransactionStateManagerConfig(config);
        TransactionConfig txnConfig = new TransactionConfig(transactionStateManagerConfig.transactionalIdExpirationMs(), transactionStateManagerConfig.transactionMaxTimeoutMs(), transactionLogConfig.transactionTopicPartitions(), transactionLogConfig.transactionTopicReplicationFactor(), transactionLogConfig.transactionTopicSegmentBytes(), transactionLogConfig.transactionLoadBufferSize(), transactionLogConfig.transactionTopicMinISR(), (String)OptionConverters$.MODULE$.toScala(transactionLogConfig.transactionTopicPlacementConstraints()).map((Function1<TopicPlacement, String> & Serializable)x$1 -> x$1.toJson()).getOrElse((Function0<String> & Serializable)() -> ""), transactionStateManagerConfig.transactionAbortTimedOutTransactionCleanupIntervalMs(), transactionStateManagerConfig.transactionRemoveExpiredTransactionalIdCleanupIntervalMs(), config.requestTimeoutMs(), transactionStateManagerConfig.transactionMetadataLoadThreads(), transactionStateManagerConfig.transaction2PCTimeoutMs(), transactionStateManagerConfig.transaction2PCEnabled(), TransactionLoggingVerbosity$.MODULE$.fromLevel(config.confluentConfig().transactionLoggingVerbosity()));
        PartitionLoadScheduler loadScheduler = new PartitionLoadScheduler(transactionStateManagerConfig.transactionMetadataLoadThreads(), "transaction-state-manager-loader", false);
        TransactionStateManager txnStateManager = new TransactionStateManager(config.brokerId(), scheduler, loadScheduler, replicaManager, metadataCache, txnConfig, time, metrics);
        LogContext logContext = new LogContext("[TransactionCoordinator id=" + config.brokerId() + "] ");
        TransactionMarkerChannelManager txnMarkerChannelManager = TransactionMarkerChannelManager$.MODULE$.apply(config, metrics, metadataCache, txnStateManager, time, logContext);
        return new TransactionCoordinator(txnConfig, scheduler, createProducerIdGenerator, txnStateManager, txnMarkerChannelManager, time, logContext);
    }

    public InitProducerIdResult kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors error) {
        return new InitProducerIdResult(-1L, -1, error);
    }

    public InitProducerIdResult kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(TxnTransitMetadata txnMetadata) {
        return new InitProducerIdResult(txnMetadata.producerId(), txnMetadata.producerEpoch(), Errors.NONE);
    }

    private TransactionCoordinator$() {
    }
}

