/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.InitProducerIdResult;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionCoordinator$;
import kafka.coordinator.transaction.TransactionLoggingVerbosity;
import kafka.coordinator.transaction.TransactionLoggingVerbosity$;
import kafka.coordinator.transaction.TransactionLoggingVerbosity$Off$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.AddPartitionsToTxnResponseData;
import org.apache.kafka.common.message.DescribeTransactionsResponseData;
import org.apache.kafka.common.message.ListTransactionsResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.ProducerIdAndEpoch;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.transaction.ProducerIdManager;
import org.apache.kafka.coordinator.transaction.TransactionState;
import org.apache.kafka.coordinator.transaction.TxnTransitMetadata;
import org.apache.kafka.metadata.MetadataCache;
import org.apache.kafka.server.common.RequestLocal;
import org.apache.kafka.server.common.TransactionVersion;
import org.apache.kafka.server.util.Scheduler;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ShortRef;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0011\u0015t!B\u001e=\u0011\u0003\u0019e!B#=\u0011\u00031\u0005\"B'\u0002\t\u0003q\u0005\"B(\u0002\t\u0003\u0001\u0006b\u0002C-\u0003\u0011%A1\f\u0005\b\t?\nA\u0011\u0002C1\r\u0011)E\b\u0001*\t\u0011e3!\u0011!Q\u0001\niC\u0001\"\u0018\u0004\u0003\u0002\u0003\u0006IA\u0018\u0005\tW\u001a\u0011\t\u0011)A\u0005Y\"AQO\u0002B\u0001B\u0003%a\u000f\u0003\u0005z\r\t\u0005\t\u0015!\u0003{\u0011!ihA!A!\u0002\u0013q\bBCA\u0006\r\t\u0005\t\u0015!\u0003\u0002\u000e!1QJ\u0002C\u0001\u0003')a!a\t\u0007\t\u0005\u0015RABA\u001c\r\u0011\tI$\u0002\u0004\u0002H\u0019!\u0011\u0011J\u0003\u0007\u0003o2A!!\u001f\u0006\r\u0005-e\u0001BAG\u0011%\t9L\u0002b\u0001\n\u0013\tI\f\u0003\u0005\u0002R\u001a\u0001\u000b\u0011BA^\u0011%\t\u0019N\u0002b\u0001\n\u0003\t)\u000eC\u0004\u0002X\u001a\u0001\u000b\u0011B8\t\u0013\u0005eg\u00011A\u0005\n\u0005m\u0007\"CAr\r\u0001\u0007I\u0011BAs\u0011!\tYO\u0002Q!\n\u0005u\u0007\"CA{\r\t\u0007I\u0011BA|\u0011!\tyP\u0002Q\u0001\n\u0005e\bb\u0002B\u0001\r\u0011\u0005!1\u0001\u0005\b\u0005\u00131A\u0011\u0001B\u0006\u0011%\u0011iFBI\u0001\n\u0003\u0011y\u0006C\u0004\u0003v\u0019!IAa\u001e\t\u000f\tue\u0001\"\u0001\u0003 \"I!\u0011\u0019\u0004\u0012\u0002\u0013\u0005!1\u0019\u0005\n\u0005\u000f4\u0011\u0013!C\u0001\u0005\u0013DqA!4\u0007\t\u0003\u0011y\rC\u0004\u0003b\u001a!\tAa9\t\u000f\r%a\u0001\"\u0001\u0004\f!I1Q\u0005\u0004\u0012\u0002\u0013\u0005!q\f\u0005\b\u0007O1A\u0011AB\u0015\u0011\u001d\u0019\tD\u0002C\u0001\u0007gAqaa\u000f\u0007\t\u0013\u0019i\u0004C\u0004\u0004B\u0019!Iaa\u0011\t\u000f\r%d\u0001\"\u0001\u0004l!I1q\u0010\u0004\u0012\u0002\u0013\u0005!q\f\u0005\b\u0007\u00033A\u0011BBB\u0011\u001d\u0019YI\u0002C\u0005\u0007\u001bCqaa'\u0007\t\u0013\u0019i\nC\u0004\u0004$\u001a!Ia!*\t\u000f\rUf\u0001\"\u0003\u00048\"91\u0011\u001a\u0004\u0005\u0002\r-\u0007bBBk\r\u0011\u00051q\u001b\u0005\b\u000734A\u0011ABn\u0011\u001d\u0019yN\u0002C\u0005\u0007CD\u0001ba?\u0007\t\u0003a4Q \u0005\b\t\u000b1A\u0011\u0001C\u0004\u0011%!\u0019BBI\u0001\n\u0003!)\u0002C\u0004\u0005\u001a\u0019!\t\u0001b\u0007\u0002-Q\u0013\u0018M\\:bGRLwN\\\"p_J$\u0017N\\1u_JT!!\u0010 \u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003\u007f\u0001\u000b1bY8pe\u0012Lg.\u0019;pe*\t\u0011)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005\u0011\u000bQ\"\u0001\u001f\u0003-Q\u0013\u0018M\\:bGRLwN\\\"p_J$\u0017N\\1u_J\u001c\"!A$\u0011\u0005![U\"A%\u000b\u0003)\u000bQa]2bY\u0006L!\u0001T%\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t1)A\u0003baBd\u0017\u0010F\bR\t;!Y\u0003\"\u000e\u00058\u0011mB\u0011\nC,!\t!eaE\u0002\u0007\u000fN\u0003\"\u0001V,\u000e\u0003US!A\u0016!\u0002\u000bU$\u0018\u000e\\:\n\u0005a+&a\u0002'pO\u001eLgnZ\u0001\nibt7i\u001c8gS\u001e\u0004\"\u0001R.\n\u0005qc$!\u0005+sC:\u001c\u0018m\u0019;j_:\u001cuN\u001c4jO\u0006I1o\u00195fIVdWM\u001d\t\u0003?&l\u0011\u0001\u0019\u0006\u0003C\n\fA!\u001e;jY*\u00111\rZ\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005\u0005+'B\u00014h\u0003\u0019\t\u0007/Y2iK*\t\u0001.A\u0002pe\u001eL!A\u001b1\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\u0018aF2sK\u0006$X\r\u0015:pIV\u001cWM]%e\u001b\u0006t\u0017mZ3s!\rAUn\\\u0005\u0003]&\u0013\u0011BR;oGRLwN\u001c\u0019\u0011\u0005A\u001cX\"A9\u000b\u0005u\u0012(BA e\u0013\t!\u0018OA\tQe>$WoY3s\u0013\u0012l\u0015M\\1hKJ\f!\u0002\u001e=o\u001b\u0006t\u0017mZ3s!\t!u/\u0003\u0002yy\t9BK]1og\u0006\u001cG/[8o'R\fG/Z'b]\u0006<WM]\u0001\u0018ibtW*\u0019:lKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ\u0004\"\u0001R>\n\u0005qd$a\b+sC:\u001c\u0018m\u0019;j_:l\u0015M]6fe\u000eC\u0017M\u001c8fY6\u000bg.Y4fe\u0006!A/[7f!\ry\u0018qA\u0007\u0003\u0003\u0003Q1AVA\u0002\u0015\r\t)\u0001Z\u0001\u0007G>lWn\u001c8\n\t\u0005%\u0011\u0011\u0001\u0002\u0005)&lW-\u0001\u0006m_\u001e\u001cuN\u001c;fqR\u00042a`A\b\u0013\u0011\t\t\"!\u0001\u0003\u00151{wmQ8oi\u0016DH\u000fF\bR\u0003+\t9\"!\u0007\u0002\u001c\u0005u\u0011qDA\u0011\u0011\u0015If\u00021\u0001[\u0011\u0015if\u00021\u0001_\u0011\u0015Yg\u00021\u0001m\u0011\u0015)h\u00021\u0001w\u0011\u0015Ih\u00021\u0001{\u0011\u0015ih\u00021\u0001\u007f\u0011\u001d\tYA\u0004a\u0001\u0003\u001b\u0011a#\u00138jiB\u0013x\u000eZ;dKJLEmQ1mY\n\f7m\u001b\t\b\u0011\u0006\u001d\u00121FA\u0019\u0013\r\tI#\u0013\u0002\n\rVt7\r^5p]F\u00022\u0001RA\u0017\u0013\r\ty\u0003\u0010\u0002\u0015\u0013:LG\u000f\u0015:pIV\u001cWM]%e%\u0016\u001cX\u000f\u001c;\u0011\u0007!\u000b\u0019$C\u0002\u00026%\u0013A!\u00168ji\n)\u0012\t\u001a3QCJ$\u0018\u000e^5p]N\u001c\u0015\r\u001c7cC\u000e\\\u0007c\u0002%\u0002(\u0005m\u0012\u0011\u0007\t\u0005\u0003{\t\u0019%\u0004\u0002\u0002@)!\u0011\u0011IA\u0002\u0003!\u0001(o\u001c;pG>d\u0017\u0002BA#\u0003\u007f\u0011a!\u0012:s_J\u001c(\u0001\u0007,fe&4\u0017\u0010U1si&$\u0018n\u001c8t\u0007\u0006dGNY1dWB9\u0001*a\n\u0002L\u0005E\u0002\u0003BA'\u0003crA!a\u0014\u0002l9!\u0011\u0011KA4\u001d\u0011\t\u0019&!\u001a\u000f\t\u0005U\u00131\r\b\u0005\u0003/\n\tG\u0004\u0003\u0002Z\u0005}SBAA.\u0015\r\tiFQ\u0001\u0007yI|w\u000e\u001e \n\u0003!L!AZ4\n\u0005\u0005+\u0017bAA\u0003I&!\u0011\u0011NA\u0002\u0003\u001diWm]:bO\u0016LA!!\u001c\u0002p\u0005q\u0012\t\u001a3QCJ$\u0018\u000e^5p]N$v\u000e\u0016=o%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0006\u0005\u0003S\n\u0019!\u0003\u0003\u0002t\u0005U$\u0001G!eIB\u000b'\u000f^5uS>t7\u000fV8Uq:\u0014Vm];mi*!\u0011QNA8\u00059)e\u000e\u001a+y]\u000e\u000bG\u000e\u001c2bG.\u00042\u0002SA>\u0003w\ty(!\"\u00022%\u0019\u0011QP%\u0003\u0013\u0019+hn\u0019;j_:\u001c\u0004c\u0001%\u0002\u0002&\u0019\u00111Q%\u0003\t1{gn\u001a\t\u0004\u0011\u0006\u001d\u0015bAAE\u0013\n)1\u000b[8si\nI\u0011\t]5SKN,H\u000e^\u000b\u0005\u0003\u001f\u000b)\u000b\u0005\u0005\u0002\u0012\u0006m\u00151HAQ\u001d\u0011\t\u0019*a&\u000f\t\u0005e\u0013QS\u0005\u0002\u0015&\u0019\u0011\u0011T%\u0002\u000fA\f7m[1hK&!\u0011QTAP\u0005\u0019)\u0015\u000e\u001e5fe*\u0019\u0011\u0011T%\u0011\t\u0005\r\u0016Q\u0015\u0007\u0001\t\u001d\t9k\u0005b\u0001\u0003S\u0013\u0011\u0001V\t\u0005\u0003W\u000b\t\fE\u0002I\u0003[K1!a,J\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001SAZ\u0013\r\t),\u0013\u0002\u0004\u0003:L\u0018\u0001C5t\u0003\u000e$\u0018N^3\u0016\u0005\u0005m\u0006\u0003BA_\u0003\u001bl!!a0\u000b\t\u0005\u0005\u00171Y\u0001\u0007CR|W.[2\u000b\t\u0005\u0015\u0017qY\u0001\u000bG>t7-\u001e:sK:$(bA1\u0002J*\u0011\u00111Z\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002P\u0006}&!D!u_6L7MQ8pY\u0016\fg.A\u0005jg\u0006\u001bG/\u001b<fA\u0005\t\u0002O]8ek\u000e,'/\u00133NC:\fw-\u001a:\u0016\u0003=\f!\u0003\u001d:pIV\u001cWM]%e\u001b\u0006t\u0017mZ3sA\u0005aAn\\4WKJ\u0014wn]5usV\u0011\u0011Q\u001c\t\u0004\t\u0006}\u0017bAAqy\tYBK]1og\u0006\u001cG/[8o\u0019><w-\u001b8h-\u0016\u0014(m\\:jif\f\u0001\u0003\\8h-\u0016\u0014(m\\:jif|F%Z9\u0015\t\u0005E\u0012q\u001d\u0005\n\u0003SL\u0012\u0011!a\u0001\u0003;\f1\u0001\u001f\u00132\u00035awn\u001a,fe\n|7/\u001b;zA!\u001a!$a<\u0011\u0007!\u000b\t0C\u0002\u0002t&\u0013\u0001B^8mCRLG.Z\u0001)iJ\fgn]1di&|gn\u0015;bi\u0016du.\u00193j]\u001edunZ4j]\u001eLe\u000e^3sm\u0006dWj]\u000b\u0003\u0003s\u00042\u0001SA~\u0013\r\ti0\u0013\u0002\u0004\u0013:$\u0018!\u000b;sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u0019>\fG-\u001b8h\u0019><w-\u001b8h\u0013:$XM\u001d<bY6\u001b\b%A\ntKRdunZ4j]\u001e4VM\u001d2pg&$\u0018\u0010\u0006\u0003\u00022\t\u0015\u0001b\u0002B\u0004;\u0001\u0007\u0011\u0011`\u0001\u0006Y\u00164X\r\\\u0001\u0015Q\u0006tG\r\\3J]&$\bK]8ek\u000e,'/\u00133\u0015%\u0005E\"Q\u0002B\u0011\u0005K\u0011yCa\r\u00038\t\u001d#q\n\u0005\b\u0005\u001fq\u0002\u0019\u0001B\t\u0003=!(/\u00198tC\u000e$\u0018n\u001c8bY&#\u0007\u0003\u0002B\n\u00057qAA!\u0006\u0003\u0018A\u0019\u0011\u0011L%\n\u0007\te\u0011*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005;\u0011yB\u0001\u0004TiJLgn\u001a\u0006\u0004\u00053I\u0005b\u0002B\u0012=\u0001\u0007\u0011\u0011`\u0001\u0015iJ\fgn]1di&|g\u000eV5nK>,H/T:\t\u000f\t\u001db\u00041\u0001\u0003*\u0005yQM\\1cY\u0016$vo\u001c)D\r2\fw\rE\u0002I\u0005WI1A!\fJ\u0005\u001d\u0011un\u001c7fC:DqA!\r\u001f\u0001\u0004\u0011I#A\blK\u0016\u0004\bK]3qCJ,G\r\u0016=o\u0011\u001d\u0011)D\ba\u0001\u0005S\ta\"[:DM2$h\t\\5oWJ\u00026\tC\u0004\u0003:y\u0001\rAa\u000f\u00025\u0015D\b/Z2uK\u0012\u0004&o\u001c3vG\u0016\u0014\u0018\nZ!oI\u0016\u0003xn\u00195\u0011\u000b!\u0013iD!\u0011\n\u0007\t}\u0012J\u0001\u0004PaRLwN\u001c\t\u0004\u007f\n\r\u0013\u0002\u0002B#\u0003\u0003\u0011!\u0003\u0015:pIV\u001cWM]%e\u0003:$W\t]8dQ\"9!\u0011\n\u0010A\u0002\t-\u0013\u0001\u0005:fgB|gn]3DC2d'-Y2l!\r\u0011ieD\u0007\u0002\r!I!\u0011\u000b\u0010\u0011\u0002\u0003\u0007!1K\u0001\re\u0016\fX/Z:u\u0019>\u001c\u0017\r\u001c\t\u0005\u0005+\u0012I&\u0004\u0002\u0003X)\u0019\u0011Q\u00012\n\t\tm#q\u000b\u0002\r%\u0016\fX/Z:u\u0019>\u001c\u0017\r\\\u0001\u001fQ\u0006tG\r\\3J]&$\bK]8ek\u000e,'/\u00133%I\u00164\u0017-\u001e7uIa*\"A!\u0019+\t\tM#1M\u0016\u0003\u0005K\u0002BAa\u001a\u0003r5\u0011!\u0011\u000e\u0006\u0005\u0005W\u0012i'A\u0005v]\u000eDWmY6fI*\u0019!qN%\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003t\t%$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006a\u0002O]3qCJ,\u0017J\\5u!J|G-^2fe&#GK]1og&$HC\u0004B=\u0005\u000f\u0013IIa#\u0003\u000e\nE%1\u0014\t\u0006\u0005\u001b\u001a\"1\u0010\t\b\u0011\nu\u0014\u0011 BA\u0013\r\u0011y(\u0013\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007A\u0014\u0019)C\u0002\u0003\u0006F\u0014!\u0003\u0016=o)J\fgn]5u\u001b\u0016$\u0018\rZ1uC\"9!q\u0002\u0011A\u0002\tE\u0001b\u0002B\u0012A\u0001\u0007\u0011\u0011 \u0005\b\u0005c\u0001\u0003\u0019\u0001B\u0015\u0011\u001d\u0011y\t\ta\u0001\u0003s\f\u0001cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195\t\u000f\tM\u0005\u00051\u0001\u0003\u0016\u0006YA\u000f\u001f8NKR\fG-\u0019;b!\r!%qS\u0005\u0004\u00053c$a\u0005+sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\f\u0007b\u0002B\u001dA\u0001\u0007!1H\u0001\u0017Q\u0006tG\r\\3MSN$HK]1og\u0006\u001cG/[8ogRQ!\u0011\u0015BU\u0005g\u0013IL!0\u0011\t\t\r&QU\u0007\u0003\u0003_JAAa*\u0002p\taB*[:u)J\fgn]1di&|gn\u001d*fgB|gn]3ECR\f\u0007b\u0002BVC\u0001\u0007!QV\u0001\u0014M&dG/\u001a:fIB\u0013x\u000eZ;dKJLEm\u001d\t\u0007\u0005'\u0011y+a \n\t\tE&q\u0004\u0002\u0004'\u0016$\bb\u0002B[C\u0001\u0007!qW\u0001\u000fM&dG/\u001a:fIN#\u0018\r^3t!\u0019\u0011\u0019Ba,\u0003\u0012!I!1X\u0011\u0011\u0002\u0003\u0007\u0011qP\u0001\u0011M&dG/\u001a:fI\u0012+(/\u0019;j_:D\u0011Ba0\"!\u0003\u0005\rA!\u0005\u0002=\u0019LG\u000e^3sK\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY&#\u0007+\u0019;uKJt\u0017\u0001\t5b]\u0012dW\rT5tiR\u0013\u0018M\\:bGRLwN\\:%I\u00164\u0017-\u001e7uIM*\"A!2+\t\u0005}$1M\u0001!Q\u0006tG\r\\3MSN$HK]1og\u0006\u001cG/[8og\u0012\"WMZ1vYR$C'\u0006\u0002\u0003L*\"!\u0011\u0003B2\u0003iA\u0017M\u001c3mK\u0012+7o\u0019:jE\u0016$&/\u00198tC\u000e$\u0018n\u001c8t)\u0011\u0011\tNa8\u0011\t\tM'\u0011\u001c\b\u0005\u0005G\u0013).\u0003\u0003\u0003X\u0006=\u0014\u0001\t#fg\u000e\u0014\u0018NY3Ue\u0006t7/Y2uS>t7OU3ta>t7/\u001a#bi\u0006LAAa7\u0003^\n\u0001BK]1og\u0006\u001cG/[8o'R\fG/\u001a\u0006\u0005\u0005/\fy\u0007C\u0004\u0003\u0010\u0011\u0002\rA!\u0005\u0002G!\fg\u000e\u001a7f-\u0016\u0014\u0018NZ=QCJ$\u0018\u000e^5p]NLe\u000e\u0016:b]N\f7\r^5p]Ra\u0011\u0011\u0007Bs\u0005O\u0014YOa<\u0004\u0006!9!qB\u0013A\u0002\tE\u0001b\u0002BuK\u0001\u0007\u0011qP\u0001\u000baJ|G-^2fe&#\u0007b\u0002BwK\u0001\u0007\u0011QQ\u0001\u000eaJ|G-^2fe\u0016\u0003xn\u00195\t\u000f\tEX\u00051\u0001\u0003t\u0006Q\u0001/\u0019:uSRLwN\\:\u0011\r\tU(1 B\u007f\u001b\t\u00119PC\u0002\u0003z&\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\tLa>\u0011\t\t}8\u0011A\u0007\u0003\u0003\u0007IAaa\u0001\u0002\u0004\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007b\u0002B%K\u0001\u00071q\u0001\t\u0004\u0005\u001b\n\u0012\u0001\t5b]\u0012dW-\u00113e!\u0006\u0014H/\u001b;j_:\u001cHk\u001c+sC:\u001c\u0018m\u0019;j_:$\u0002#!\r\u0004\u000e\r=1\u0011CB\n\u0007+\u0019Iba\t\t\u000f\t=a\u00051\u0001\u0003\u0012!9!\u0011\u001e\u0014A\u0002\u0005}\u0004b\u0002BwM\u0001\u0007\u0011Q\u0011\u0005\b\u0005c4\u0003\u0019\u0001Bz\u0011\u001d\u0011IE\na\u0001\u0007/\u00012A!\u0014\u0011\u0011\u001d\u0019YB\na\u0001\u0007;\t\u0001d\u00197jK:$HK]1og\u0006\u001cG/[8o-\u0016\u00148/[8o!\u0011\u0011)fa\b\n\t\r\u0005\"q\u000b\u0002\u0013)J\fgn]1di&|gNV3sg&|g\u000eC\u0005\u0003R\u0019\u0002\n\u00111\u0001\u0003T\u0005Q\u0003.\u00198eY\u0016\fE\r\u001a)beRLG/[8ogR{GK]1og\u0006\u001cG/[8oI\u0011,g-Y;mi\u0012:\u0014AC8o\u000b2,7\r^5p]R1\u0011\u0011GB\u0016\u0007_Aqa!\f)\u0001\u0004\tI0A\nuq:$v\u000e]5d!\u0006\u0014H/\u001b;j_:LE\rC\u0004\u0003\u0010\"\u0002\r!!?\u0002\u001b=t'+Z:jO:\fG/[8o)\u0019\t\td!\u000e\u00048!91QF\u0015A\u0002\u0005e\bb\u0002BHS\u0001\u00071\u0011\b\t\u0006\u0011\nu\u0012\u0011`\u0001\u0010SN\fE\rZ5oO>3gm]3ugR!!\u0011FB \u0011\u001d\u0011\tP\u000ba\u0001\u0005g\fq\u0005\\8h\u0013:4\u0018\r\\5e'R\fG/\u001a+sC:\u001c\u0018\u000e^5p]\u0006sGMU3ukJtWI\u001d:peRA1QIB(\u0007#\u001aI\u0006\u0005\u0005\u0004H\r-\u00131HAV\u001b\t\u0019IE\u0003\u0002b\u0013&!1QJB%\u0005\u0011aUM\u001a;\t\u000f\t=1\u00061\u0001\u0003\u0012!911K\u0016A\u0002\rU\u0013\u0001\u0005;sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f!\r\u00018qK\u0005\u0004\u00057\f\bbBB.W\u0001\u00071QL\u0001\u0012iJ\fgn]1di&|gNU3tk2$\b\u0003BB0\u0007Kj!a!\u0019\u000b\t\r\r\u00141A\u0001\te\u0016\fX/Z:ug&!1qMB1\u0005E!&/\u00198tC\u000e$\u0018n\u001c8SKN,H\u000e^\u0001\u0015Q\u0006tG\r\\3F]\u0012$&/\u00198tC\u000e$\u0018n\u001c8\u0015!\u0005E2QNB8\u0007c\u001a\u0019ha\u001e\u0004z\ru\u0004b\u0002B\bY\u0001\u0007!\u0011\u0003\u0005\b\u0005Sd\u0003\u0019AA@\u0011\u001d\u0011i\u000f\fa\u0001\u0003\u000bCqa!\u001e-\u0001\u0004\u0019i&A\buq:l\u0015M]6feJ+7/\u001e7u\u0011\u001d\u0019Y\u0002\fa\u0001\u0007;AqA!\u0013-\u0001\u0004\u0019Y\bE\u0002\u0003NIA\u0011B!\u0015-!\u0003\u0005\rAa\u0015\u0002=!\fg\u000e\u001a7f\u000b:$GK]1og\u0006\u001cG/[8oI\u0011,g-Y;mi\u0012:\u0014AF7bs\n,Gj\\4WKJ\u0014wn]3NKN\u001c\u0018mZ3\u0015\t\u0005E2Q\u0011\u0005\b\u0007\u000fs\u0003\u0019ABE\u00031\u0011W/\u001b7e\u001b\u0016\u001c8/Y4f!\u001dA\u0015qEAo\u0005#\tq\u0003\\8h)bt\u0007K]3qCJ,7i\\7qY\u0016$\u0018n\u001c8\u0015\u0011\u0005E2qRBJ\u0007/Cqa!%0\u0001\u0004\u0011)*\u0001\u0005nKR\fG-\u0019;b\u0011\u001d\u0019)j\fa\u0001\u0007;\naA]3tk2$\bbBBM_\u0001\u0007!\u0011F\u0001\rSN4%o\\7DY&,g\u000e^\u0001\u0011Y><G\u000b\u001f8D_6\u0004H.\u001a;j_:$b!!\r\u0004 \u000e\u0005\u0006bBBIa\u0001\u0007!Q\u0013\u0005\b\u0007+\u0003\u0004\u0019AB/\u0003U)g\u000e\u001a+sC:\u001c\u0018m\u0019;j_:<\u0016\u000e\u001e5U-F\"\u0002#!\r\u0004(\u000e%61VBW\u0007_\u001b\tla-\t\u000f\t=\u0011\u00071\u0001\u0003\u0012!9!\u0011^\u0019A\u0002\u0005}\u0004b\u0002Bwc\u0001\u0007\u0011Q\u0011\u0005\b\u0007k\n\u0004\u0019AB/\u0011\u001d\u0019I*\ra\u0001\u0005SAqA!\u00132\u0001\u0004\u0019Y\bC\u0004\u0003RE\u0002\rAa\u0015\u0002\u001d\u0015tG\r\u0016:b]N\f7\r^5p]R\u0011\u0012\u0011GB]\u0007w\u001bila0\u0004B\u000e\r7QYBd\u0011\u001d\u0011yA\ra\u0001\u0005#AqA!;3\u0001\u0004\ty\bC\u0004\u0003nJ\u0002\r!!\"\t\u000f\rU$\u00071\u0001\u0004^!91\u0011\u0014\u001aA\u0002\t%\u0002bBB\u000ee\u0001\u00071Q\u0004\u0005\b\u0005\u0013\u0012\u0004\u0019AB>\u0011\u001d\u0011\tF\ra\u0001\u0005'\nq\u0003\u001e:b]N\f7\r^5p]R{\u0007/[2D_:4\u0017nZ:\u0016\u0005\r5\u0007\u0003BBh\u0007#l!!a2\n\t\rM\u0017q\u0019\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018\u0001\u00069mC\u000e,W.\u001a8u\u0007>t7\u000f\u001e:bS:$8/\u0006\u0002\u0003\u0012\u0005a\u0001/\u0019:uSRLwN\u001c$peR!\u0011\u0011`Bo\u0011\u001d\u0011y!\u000ea\u0001\u0005#\t\u0001d\u001c8F]\u0012$&/\u00198tC\u000e$\u0018n\u001c8D_6\u0004H.\u001a;f)\u0011\u0019\u0019o!=\u0015\u0011\u0005E2Q]Bu\u0007[Dqaa:7\u0001\u0004\tY$A\u0003feJ|'\u000fC\u0004\u0004lZ\u0002\r!a \u0002\u001b9,w\u000f\u0015:pIV\u001cWM]%e\u0011\u001d\u0019yO\u000ea\u0001\u0003\u000b\u000b\u0001C\\3x!J|G-^2fe\u0016\u0003xn\u00195\t\u000f\rMh\u00071\u0001\u0004v\u0006\u0001B\u000f\u001f8JI\u0006sG\rU5e\u000bB|7\r\u001b\t\u0004\t\u000e]\u0018bAB}y\t\tCK]1og\u0006\u001cG/[8oC2LE-\u00118e!J|G-^2fe&#W\t]8dQ\u0006I\u0012MY8siRKW.\u001a3PkR$&/\u00198tC\u000e$\u0018n\u001c8t)\u0011\t\tda@\t\u000f\u0011\u0005q\u00071\u0001\u0005\u0004\u0005QqN\\\"p[BdW\r^3\u0011\u000f!\u000b9c!>\u0004|\u000591\u000f^1siV\u0004HCBA\u0019\t\u0013!y\u0001C\u0004\u0005\fa\u0002\r\u0001\"\u0004\u0002MI,GO]5fm\u0016$&/\u00198tC\u000e$\u0018n\u001c8U_BL7\rU1si&$\u0018n\u001c8D_VtG\u000f\u0005\u0003I[\u0006e\b\"\u0003C\tqA\u0005\t\u0019\u0001B\u0015\u0003})g.\u00192mKR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012,\u0005\u0010]5sCRLwN\\\u0001\u0012gR\f'\u000f^;qI\u0011,g-Y;mi\u0012\u0012TC\u0001C\fU\u0011\u0011ICa\u0019\u0002\u0011MDW\u000f\u001e3po:$\"!!\r\t\u000f\u0011}1\u00011\u0001\u0005\"\u000511m\u001c8gS\u001e\u0004B\u0001b\t\u0005(5\u0011AQ\u0005\u0006\u0003G\u0002KA\u0001\"\u000b\u0005&\tY1*\u00194lC\u000e{gNZ5h\u0011\u001d!ic\u0001a\u0001\t_\taB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0005\u0003\u0005$\u0011E\u0012\u0002\u0002C\u001a\tK\u0011aBU3qY&\u001c\u0017-T1oC\u001e,'\u000fC\u0003^\u0007\u0001\u0007a\f\u0003\u0004\u0005:\r\u0001\r\u0001\\\u0001\u001aGJ,\u0017\r^3Qe>$WoY3s\u0013\u0012<UM\\3sCR|'\u000fC\u0004\u0005>\r\u0001\r\u0001b\u0010\u0002\u000f5,GO]5dgB!A\u0011\tC#\u001b\t!\u0019E\u0003\u0003\u0005>\u0005\r\u0011\u0002\u0002C$\t\u0007\u0012q!T3ue&\u001c7\u000fC\u0004\u0005L\r\u0001\r\u0001\"\u0014\u0002\u001b5,G/\u00193bi\u0006\u001c\u0015m\u00195f!\u0011!y\u0005b\u0015\u000e\u0005\u0011E#bABII&!AQ\u000bC)\u00055iU\r^1eCR\f7)Y2iK\")Qp\u0001a\u0001}\u0006!\u0012N\\5u)J\fgn]1di&|g.\u0012:s_J$B!a\u000b\u0005^!91q\u001d\u0003A\u0002\u0005m\u0012aF5oSR$&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b)\u0011\tY\u0003b\u0019\t\u000f\tMU\u00011\u0001\u0003\u0002\u0002")
public class TransactionCoordinator
implements Logging {
    private final TransactionConfig txnConfig;
    private final Scheduler scheduler;
    private final TransactionStateManager txnManager;
    private final TransactionMarkerChannelManager txnMarkerChannelManager;
    private final Time time;
    private final AtomicBoolean isActive;
    private final ProducerIdManager producerIdManager;
    private volatile TransactionLoggingVerbosity logVerbosity;
    private final int transactionStateLoadingLoggingIntervalMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static TransactionCoordinator apply(KafkaConfig config, ReplicaManager replicaManager, Scheduler scheduler, Function0<ProducerIdManager> createProducerIdGenerator, Metrics metrics, MetadataCache metadataCache, Time time) {
        return TransactionCoordinator$.MODULE$.apply(config, replicaManager, scheduler, createProducerIdGenerator, metrics, metadataCache, time);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TransactionCoordinator transactionCoordinator = this;
        synchronized (transactionCoordinator) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean isActive() {
        return this.isActive;
    }

    public ProducerIdManager producerIdManager() {
        return this.producerIdManager;
    }

    private TransactionLoggingVerbosity logVerbosity() {
        return this.logVerbosity;
    }

    private void logVerbosity_$eq(TransactionLoggingVerbosity x$1) {
        this.logVerbosity = x$1;
    }

    private int transactionStateLoadingLoggingIntervalMs() {
        return this.transactionStateLoadingLoggingIntervalMs;
    }

    public void setLoggingVerbosity(int level) {
        this.logVerbosity_$eq(TransactionLoggingVerbosity$.MODULE$.fromLevel(level));
    }

    public void handleInitProducerId(String transactionalId, int transactionTimeoutMs, boolean enableTwoPCFlag, boolean keepPreparedTxn, boolean isCfltFlink2PC, Option<ProducerIdAndEpoch> expectedProducerIdAndEpoch, Function1<InitProducerIdResult, BoxedUnit> responseCallback, RequestLocal requestLocal) {
        Right right;
        Tuple2 tuple2;
        Either result;
        if (transactionalId == null) {
            try {
                responseCallback.apply(new InitProducerIdResult(this.producerIdManager().generateProducerId(), 0, Errors.NONE));
            }
            catch (Exception e) {
                responseCallback.apply(TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.forException((Throwable)e)));
            }
            return;
        }
        if (transactionalId.isEmpty()) {
            responseCallback.apply(TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.INVALID_REQUEST));
            return;
        }
        if (!isCfltFlink2PC && enableTwoPCFlag && !this.txnManager.isTransaction2pcEnabled()) {
            responseCallback.apply(TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED));
            return;
        }
        if (!isCfltFlink2PC && keepPreparedTxn) {
            responseCallback.apply(TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.UNSUPPORTED_VERSION));
            return;
        }
        if (!this.txnManager.validateTransactionTimeoutMs(enableTwoPCFlag, transactionTimeoutMs)) {
            responseCallback.apply(TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.INVALID_TRANSACTION_TIMEOUT));
            return;
        }
        int resolvedTxnTimeoutMs = enableTwoPCFlag ? (isCfltFlink2PC ? 0x7FFFFFFE : Integer.MAX_VALUE) : transactionTimeoutMs;
        Either coordinatorEpochAndMetadata = this.txnManager.getTransactionState(transactionalId).flatMap((Function1<Option, Either> & Serializable)x0$1 -> {
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                Either either;
                try {
                    String x$1 = transactionalId;
                    long x$2 = this.producerIdManager().generateProducerId();
                    long x$3 = -1L;
                    long x$4 = -1L;
                    int x$5 = -1;
                    int x$6 = -1;
                    int x$7 = resolvedTxnTimeoutMs;
                    TransactionState x$8 = TransactionState.EMPTY;
                    scala.collection.mutable.Set x$9 = (scala.collection.mutable.Set)Set$.MODULE$.empty();
                    long x$10 = $this.time.milliseconds();
                    TransactionVersion x$11 = TransactionVersion.TV_0;
                    long x$12 = TransactionMetadata$.MODULE$.$lessinit$greater$default$10();
                    TransactionMetadata createdMetadata = new TransactionMetadata(x$1, x$2, -1L, -1L, -1, -1, x$7, TransactionState.EMPTY, x$9, x$12, x$10, TransactionVersion.TV_0);
                    either = $this.txnManager.putTransactionStateIfNotExists(createdMetadata);
                }
                catch (Exception e) {
                    either = new Left(Errors.forException((Throwable)e));
                }
                return either;
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
                return new Right(epochAndTxnMetadata);
            }
            throw new MatchError(option);
        });
        Either either = result = coordinatorEpochAndMetadata.flatMap((Function1<CoordinatorEpochAndTxnMetadata, Either> & Serializable)existingEpochAndMetadata -> {
            int coordinatorEpoch = existingEpochAndMetadata.coordinatorEpoch();
            TransactionMetadata txnMetadata = existingEpochAndMetadata.transactionMetadata();
            return (Either)txnMetadata.inLock((Function0<Either> & Serializable)() -> this.prepareInitProducerIdTransit(transactionalId, resolvedTxnTimeoutMs, keepPreparedTxn, coordinatorEpoch, txnMetadata, expectedProducerIdAndEpoch));
        });
        if (either instanceof Left) {
            Left left = (Left)either;
            Errors error2 = (Errors)left.value();
            responseCallback.apply(TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error2));
            return;
        }
        if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            TransactionState transactionState = newMetadata.txnState();
            TransactionState transactionState2 = TransactionState.PREPARE_EPOCH_FENCE;
            if (!(transactionState != null ? !((Object)((Object)transactionState)).equals((Object)transactionState2) : transactionState2 != null)) {
                this.endTransaction(transactionalId, newMetadata.producerId(), newMetadata.producerEpoch(), TransactionResult.ABORT, false, this.txnManager.transactionVersionLevel(), (Function3<Errors, Object, Object, BoxedUnit>)(Function3<Errors, Object, Object, Object> & Serializable)(error, newProducerId, newProducerEpoch) -> {
                    TransactionCoordinator.sendRetriableErrorCallback$1(error, BoxesRunTime.unboxToLong(newProducerId), BoxesRunTime.unboxToShort(newProducerEpoch), responseCallback);
                    return BoxedUnit.UNIT;
                }, requestLocal);
                return;
            }
            String x$13 = transactionalId;
            int x$14 = coordinatorEpoch;
            TxnTransitMetadata x$15 = newMetadata;
            Function1<Errors, Object> & Serializable x$16 = (Function1<Errors, Object> & Serializable)error -> {
                this.sendPidResponseCallback$1(error, transactionalId, newMetadata, responseCallback);
                return BoxedUnit.UNIT;
            };
            RequestLocal x$17 = requestLocal;
            Function1<Errors, Object> x$18 = this.txnManager.appendTransactionToLog$default$5();
            this.txnManager.appendTransactionToLog(x$13, x$14, x$15, (Function1<Errors, BoxedUnit>)x$16, x$18, x$17);
            return;
        }
        throw new MatchError(either);
    }

    public RequestLocal handleInitProducerId$default$8() {
        return RequestLocal.noCaching();
    }

    private Either<Errors, Tuple2<Object, TxnTransitMetadata>> prepareInitProducerIdTransit(String transactionalId, int transactionTimeoutMs, boolean keepPreparedTxn, int coordinatorEpoch, TransactionMetadata txnMetadata, Option<ProducerIdAndEpoch> expectedProducerIdAndEpoch) {
        if (txnMetadata.pendingTransitionInProgress()) {
            return new Left<Errors, Tuple2<Object, TxnTransitMetadata>>(Errors.CONCURRENT_TRANSACTIONS);
        }
        if (!expectedProducerIdAndEpoch.forall((Function1<ProducerIdAndEpoch, Object> & Serializable)producerIdAndEpoch -> BoxesRunTime.boxToBoolean(TransactionCoordinator.isValidProducerId$1(producerIdAndEpoch, txnMetadata)))) {
            return new Left<Errors, Tuple2<Object, TxnTransitMetadata>>(Errors.PRODUCER_FENCED);
        }
        TransactionState transactionState = txnMetadata.state();
        if (((Object)((Object)TransactionState.PREPARE_ABORT)).equals((Object)transactionState) ? true : ((Object)((Object)TransactionState.PREPARE_COMMIT)).equals((Object)transactionState)) {
            return new Left<Errors, Tuple2<Object, TxnTransitMetadata>>(Errors.CONCURRENT_TRANSACTIONS);
        }
        if (((Object)((Object)TransactionState.COMPLETE_ABORT)).equals((Object)transactionState) ? true : (((Object)((Object)TransactionState.COMPLETE_COMMIT)).equals((Object)transactionState) ? true : ((Object)((Object)TransactionState.EMPTY)).equals((Object)transactionState))) {
            Either transitMetadataResult;
            Either either;
            Either either2;
            if (txnMetadata.isProducerEpochExhausted() && expectedProducerIdAndEpoch.forall((Function1<ProducerIdAndEpoch, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(TransactionCoordinator.$anonfun$prepareInitProducerIdTransit$2(txnMetadata, x$2)))) {
                try {
                    either2 = new Right(txnMetadata.prepareProducerIdRotation(this.producerIdManager().generateProducerId(), transactionTimeoutMs, this.time.milliseconds(), expectedProducerIdAndEpoch.isDefined()));
                }
                catch (Exception e) {
                    either2 = new Left(Errors.forException((Throwable)e));
                }
            } else {
                either2 = txnMetadata.prepareIncrementProducerEpoch(transactionTimeoutMs, expectedProducerIdAndEpoch.map((Function1<ProducerIdAndEpoch, Object> & Serializable)x$3 -> BoxesRunTime.boxToShort(x$3.epoch)), this.time.milliseconds());
            }
            if ((either = (transitMetadataResult = either2)) instanceof Right) {
                Either either3 = either;
                TxnTransitMetadata transitMetadata = (TxnTransitMetadata)((Right)either3).value();
                return new Right<Errors, Tuple2<Object, TxnTransitMetadata>>(new Tuple2<Integer, TxnTransitMetadata>(BoxesRunTime.boxToInteger(coordinatorEpoch), transitMetadata));
            }
            if (either instanceof Left) {
                Left left = (Left)either;
                Errors err = (Errors)left.value();
                return new Left<Errors, Tuple2<Object, TxnTransitMetadata>>(err);
            }
            throw new MatchError(either);
        }
        if (((Object)((Object)TransactionState.ONGOING)).equals((Object)transactionState)) {
            if (txnMetadata.isDistributedTwoPhaseCommitTxnCfltFlink() && keepPreparedTxn) {
                TxnTransitMetadata txnTransitMetadata = txnMetadata.prepareTransitionTo(txnMetadata.state(), txnMetadata.prepareTransitionTo$default$2(), txnMetadata.prepareTransitionTo$default$3(), txnMetadata.prepareTransitionTo$default$4(), txnMetadata.prepareTransitionTo$default$5(), txnMetadata.prepareTransitionTo$default$6(), txnMetadata.prepareTransitionTo$default$7(), txnMetadata.prepareTransitionTo$default$8(), txnMetadata.prepareTransitionTo$default$9(), txnMetadata.prepareTransitionTo$default$10());
                return new Right<Errors, Tuple2<Object, TxnTransitMetadata>>(new Tuple2<Integer, TxnTransitMetadata>(BoxesRunTime.boxToInteger(coordinatorEpoch), txnTransitMetadata));
            }
            return new Right<Errors, Tuple2<Object, TxnTransitMetadata>>(new Tuple2<Integer, TxnTransitMetadata>(BoxesRunTime.boxToInteger(coordinatorEpoch), txnMetadata.prepareFenceProducerEpoch()));
        }
        if (((Object)((Object)TransactionState.DEAD)).equals((Object)transactionState) ? true : ((Object)((Object)TransactionState.PREPARE_EPOCH_FENCE)).equals((Object)transactionState)) {
            String errorMsg = "Found transactionalId " + transactionalId + " with state " + txnMetadata.state() + ". This is illegal as we should never have transitioned to this state.";
            this.fatal((Function0<String> & Serializable)() -> errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        throw new MatchError((Object)transactionState);
    }

    public ListTransactionsResponseData handleListTransactions(scala.collection.immutable.Set<Object> filteredProducerIds, scala.collection.immutable.Set<String> filteredStates, long filteredDuration, String filteredTransactionalIdPattern) {
        if (!this.isActive().get()) {
            return new ListTransactionsResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code());
        }
        return this.txnManager.listTransactionStates(filteredProducerIds, filteredStates, filteredDuration, filteredTransactionalIdPattern);
    }

    public long handleListTransactions$default$3() {
        return -1L;
    }

    public String handleListTransactions$default$4() {
        return null;
    }

    public DescribeTransactionsResponseData.TransactionState handleDescribeTransactions(String transactionalId) {
        Option option;
        if (transactionalId == null) {
            throw new IllegalArgumentException("Invalid null transactionalId");
        }
        DescribeTransactionsResponseData.TransactionState transactionState = new DescribeTransactionsResponseData.TransactionState().setTransactionalId(transactionalId);
        if (!this.isActive().get()) {
            return transactionState.setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code());
        }
        if (transactionalId.isEmpty()) {
            return transactionState.setErrorCode(Errors.INVALID_REQUEST.code());
        }
        boolean bl = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = this.txnManager.getTransactionState(transactionalId);
        if (either instanceof Left) {
            Left left = (Left)either;
            Errors error = (Errors)left.value();
            return transactionState.setErrorCode(error.code());
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                return transactionState.setErrorCode(Errors.TRANSACTIONAL_ID_NOT_FOUND.code());
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            Some some = (Some)option;
            CoordinatorEpochAndTxnMetadata coordinatorEpochAndMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
            TransactionMetadata txnMetadata = coordinatorEpochAndMetadata.transactionMetadata();
            return (DescribeTransactionsResponseData.TransactionState)txnMetadata.inLock((Function0<DescribeTransactionsResponseData.TransactionState> & Serializable)() -> {
                TransactionState transactionState = txnMetadata.state();
                TransactionState transactionState2 = TransactionState.DEAD;
                if (!(transactionState != null ? !((Object)((Object)transactionState)).equals((Object)transactionState2) : transactionState2 != null)) {
                    return transactionState.setErrorCode(Errors.TRANSACTIONAL_ID_NOT_FOUND.code());
                }
                txnMetadata.topicPartitions().foreach((Function1<TopicPartition, Object> & Serializable)topicPartition -> BoxesRunTime.boxToBoolean(TransactionCoordinator.$anonfun$handleDescribeTransactions$2(transactionState, topicPartition)));
                return transactionState.setErrorCode(Errors.NONE.code()).setProducerId(txnMetadata.producerId()).setProducerEpoch(txnMetadata.producerEpoch()).setTransactionState(txnMetadata.state().stateName()).setTransactionTimeoutMs(txnMetadata.txnTimeoutMs()).setTransactionStartTimeMs(txnMetadata.txnStartTimestamp());
            });
        }
        throw new MatchError(either);
    }

    public void handleVerifyPartitionsInTransaction(String transactionalId, long producerId, short producerEpoch, Set<TopicPartition> partitions, Function1<AddPartitionsToTxnResponseData.AddPartitionsToTxnResult, BoxedUnit> responseCallback) {
        if (transactionalId == null || transactionalId.isEmpty()) {
            this.debug((Function0<String> & Serializable)() -> "Returning " + Errors.INVALID_REQUEST + " error code to client for " + transactionalId + "'s AddPartitions request for verification");
            responseCallback.apply(AddPartitionsToTxnResponse.resultForTransaction((String)transactionalId, CollectionConverters$.MODULE$.MapHasAsJava(((IterableOnceOps)partitions.map((Function1<TopicPartition, Tuple2> & Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$4), Errors.INVALID_REQUEST))).toMap($less$colon$less$.MODULE$.refl())).asJava()));
            return;
        }
        Either result = this.txnManager.getTransactionState(transactionalId).flatMap((Function1<Option, Either> & Serializable)x0$1 -> {
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                return new Left(Errors.INVALID_PRODUCER_ID_MAPPING);
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
                TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                return (Either)txnMetadata.inLock((Function0<Either> & Serializable)() -> {
                    block6: {
                        block5: {
                            if (txnMetadata.producerId() != producerId) {
                                return new Left(Errors.INVALID_PRODUCER_ID_MAPPING);
                            }
                            if (txnMetadata.producerEpoch() != producerEpoch) {
                                return new Left(Errors.PRODUCER_FENCED);
                            }
                            TransactionState transactionState = txnMetadata.state();
                            TransactionState transactionState2 = TransactionState.PREPARE_COMMIT;
                            if (!(transactionState == null ? transactionState2 != null : !((Object)((Object)transactionState)).equals((Object)transactionState2))) break block5;
                            TransactionState transactionState3 = txnMetadata.state();
                            TransactionState transactionState4 = TransactionState.PREPARE_ABORT;
                            if (transactionState3 != null ? !((Object)((Object)transactionState3)).equals((Object)transactionState4) : transactionState4 != null) break block6;
                        }
                        return new Left(Errors.CONCURRENT_TRANSACTIONS);
                    }
                    return new Right(((IterableOnceOps)partitions.map((Function1<TopicPartition, Tuple2> & Serializable)part -> {
                        if (txnMetadata.topicPartitions().contains((TopicPartition)part)) {
                            return new Tuple2<TopicPartition, Errors>((TopicPartition)part, Errors.NONE);
                        }
                        return new Tuple2<TopicPartition, Errors>((TopicPartition)part, Errors.TRANSACTION_ABORTABLE);
                    })).toMap($less$colon$less$.MODULE$.refl()));
                });
            }
            throw new MatchError(option);
        });
        Either either = result;
        if (either instanceof Left) {
            Left left = (Left)either;
            Errors err = (Errors)left.value();
            this.debug((Function0<String> & Serializable)() -> "Returning " + err + " error code to client for " + transactionalId + "'s AddPartitions request for verification");
            responseCallback.apply(AddPartitionsToTxnResponse.resultForTransaction((String)transactionalId, CollectionConverters$.MODULE$.MapHasAsJava(((IterableOnceOps)partitions.map((Function1<TopicPartition, Tuple2> & Serializable)x$5 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$5), err))).toMap($less$colon$less$.MODULE$.refl())).asJava()));
            return;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Map errors = (Map)right.value();
            responseCallback.apply(AddPartitionsToTxnResponse.resultForTransaction((String)transactionalId, CollectionConverters$.MODULE$.MapHasAsJava(errors).asJava()));
            return;
        }
        throw new MatchError(either);
    }

    public void handleAddPartitionsToTransaction(String transactionalId, long producerId, short producerEpoch, Set<TopicPartition> partitions, Function1<Errors, BoxedUnit> responseCallback, TransactionVersion clientTransactionVersion, RequestLocal requestLocal) {
        Right right;
        Tuple2 tuple2;
        if (transactionalId == null || transactionalId.isEmpty()) {
            this.debug((Function0<String> & Serializable)() -> "Returning " + Errors.INVALID_REQUEST + " error code to client for " + transactionalId + "'s AddPartitions request");
            responseCallback.apply(Errors.INVALID_REQUEST);
            return;
        }
        Either result = this.txnManager.getTransactionState(transactionalId).flatMap((Function1<Option, Either> & Serializable)x0$1 -> {
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                return new Left(Errors.INVALID_PRODUCER_ID_MAPPING);
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
                int coordinatorEpoch = epochAndMetadata.coordinatorEpoch();
                TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                return (Either)txnMetadata.inLock((Function0<Either> & Serializable)() -> {
                    block9: {
                        block8: {
                            if (txnMetadata.pendingTransitionInProgress()) {
                                return new Left(Errors.CONCURRENT_TRANSACTIONS);
                            }
                            if (txnMetadata.producerId() != producerId) {
                                return new Left(Errors.INVALID_PRODUCER_ID_MAPPING);
                            }
                            if (txnMetadata.producerEpoch() != producerEpoch) {
                                return new Left(Errors.PRODUCER_FENCED);
                            }
                            TransactionState transactionState = txnMetadata.state();
                            TransactionState transactionState2 = TransactionState.PREPARE_COMMIT;
                            if (!(transactionState == null ? transactionState2 != null : !((Object)((Object)transactionState)).equals((Object)transactionState2))) break block8;
                            TransactionState transactionState3 = txnMetadata.state();
                            TransactionState transactionState4 = TransactionState.PREPARE_ABORT;
                            if (transactionState3 != null ? !((Object)((Object)transactionState3)).equals((Object)transactionState4) : transactionState4 != null) break block9;
                        }
                        return new Left(Errors.CONCURRENT_TRANSACTIONS);
                    }
                    if (txnMetadata.isDistributedTwoPhaseCommitTxnCfltFlink() && this.isAddingOffsets(partitions)) {
                        return new Left(Errors.INVALID_REQUEST);
                    }
                    TransactionState transactionState = txnMetadata.state();
                    TransactionState transactionState5 = TransactionState.ONGOING;
                    if (!(transactionState != null ? !((Object)((Object)transactionState)).equals((Object)transactionState5) : transactionState5 != null) && partitions.subsetOf(txnMetadata.topicPartitions())) {
                        return new Left(Errors.NONE);
                    }
                    return new Right(new Tuple2<Integer, TxnTransitMetadata>(BoxesRunTime.boxToInteger(coordinatorEpoch), txnMetadata.prepareAddPartitions(partitions.toSet(), $this.time.milliseconds(), clientTransactionVersion)));
                });
            }
            throw new MatchError(option);
        });
        Either either = result;
        if (either instanceof Left) {
            Left left = (Left)either;
            Errors err = (Errors)left.value();
            this.debug((Function0<String> & Serializable)() -> "Returning " + err + " error code to client for " + transactionalId + "'s AddPartitions request");
            responseCallback.apply(err);
            return;
        }
        if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            String x$1 = transactionalId;
            int x$2 = coordinatorEpoch;
            TxnTransitMetadata x$3 = newMetadata;
            Function1<Errors, BoxedUnit> x$4 = responseCallback;
            RequestLocal x$5 = requestLocal;
            Function1<Errors, Object> x$6 = this.txnManager.appendTransactionToLog$default$5();
            this.txnManager.appendTransactionToLog(x$1, x$2, x$3, x$4, x$6, x$5);
            return;
        }
        throw new MatchError(either);
    }

    public RequestLocal handleAddPartitionsToTransaction$default$7() {
        return RequestLocal.noCaching();
    }

    public void onElection(int txnTopicPartitionId, int coordinatorEpoch2) {
        this.info((Function0<String> & Serializable)() -> "Elected as the txn coordinator for partition " + txnTopicPartitionId + " at epoch " + coordinatorEpoch2);
        this.txnMarkerChannelManager.removeMarkersForTxnTopicPartition(txnTopicPartitionId);
        this.txnManager.loadTransactionsForTxnTopicPartition(txnTopicPartitionId, coordinatorEpoch2, (Function4<Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit>)(Function4<Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, Object> & Serializable)(coordinatorEpoch, txnResult, txnMetadata, newMetadata) -> {
            this.txnMarkerChannelManager.addTxnMarkersToSend(BoxesRunTime.unboxToInt(coordinatorEpoch), txnResult, txnMetadata, newMetadata);
            return BoxedUnit.UNIT;
        });
    }

    public void onResignation(int txnTopicPartitionId, Option<Object> coordinatorEpoch) {
        this.info((Function0<String> & Serializable)() -> "Resigned as the txn coordinator for partition " + txnTopicPartitionId + " at epoch " + coordinatorEpoch);
        Option<Object> option = coordinatorEpoch;
        if (option instanceof Some) {
            Some some = (Some)option;
            int epoch = BoxesRunTime.unboxToInt(some.value());
            this.txnManager.removeTransactionsForTxnTopicPartition(txnTopicPartitionId, epoch);
        } else if (None$.MODULE$.equals(option)) {
            this.txnManager.removeTransactionsForTxnTopicPartition(txnTopicPartitionId);
        } else {
            throw new MatchError(option);
        }
        this.txnMarkerChannelManager.removeMarkersForTxnTopicPartition(txnTopicPartitionId);
    }

    private boolean isAddingOffsets(Set<TopicPartition> partitions) {
        return partitions.exists((Function1<TopicPartition, Object> & Serializable)tp -> BoxesRunTime.boxToBoolean(TransactionCoordinator.$anonfun$isAddingOffsets$1(tp)));
    }

    private Left<Errors, Nothing$> logInvalidStateTransitionAndReturnError(String transactionalId, TransactionState transactionState, TransactionResult transactionResult) {
        this.warn((Function0<String> & Serializable)() -> "TransactionalId: " + transactionalId + "'s state is " + transactionState + ", but received transaction marker result to send: " + transactionResult);
        return new Left<Errors, Nothing$>(Errors.INVALID_TXN_STATE);
    }

    public void handleEndTransaction(String transactionalId, long producerId, short producerEpoch, TransactionResult txnMarkerResult, TransactionVersion clientTransactionVersion, Function3<Errors, Object, Object, BoxedUnit> responseCallback, RequestLocal requestLocal) {
        this.endTransaction(transactionalId, producerId, producerEpoch, txnMarkerResult, true, clientTransactionVersion, responseCallback, requestLocal);
    }

    public RequestLocal handleEndTransaction$default$7() {
        return RequestLocal.noCaching();
    }

    private void maybeLogVerboseMessage(Function1<TransactionLoggingVerbosity, String> buildMessage) {
        TransactionLoggingVerbosity verbosity;
        TransactionLoggingVerbosity transactionLoggingVerbosity = verbosity = this.logVerbosity();
        TransactionLoggingVerbosity$Off$ transactionLoggingVerbosity$Off$ = TransactionLoggingVerbosity$Off$.MODULE$;
        if (!(transactionLoggingVerbosity != null ? !transactionLoggingVerbosity.equals(transactionLoggingVerbosity$Off$) : transactionLoggingVerbosity$Off$ != null)) {
            this.debug((Function0<String> & Serializable)() -> (String)buildMessage.apply(verbosity));
            return;
        }
        this.info((Function0<String> & Serializable)() -> (String)buildMessage.apply(verbosity));
    }

    private void logTxnPrepareCompletion(TransactionMetadata metadata, TransactionResult result, boolean isFromClient) {
        this.maybeLogVerboseMessage((Function1<TransactionLoggingVerbosity, String> & Serializable)verbosity -> {
            String reason = isFromClient ? "client EndTxn request" : "transaction timeout";
            return "Prepare " + result + " of transaction due to " + reason + ": " + metadata.toString((TransactionLoggingVerbosity)verbosity);
        });
    }

    private void logTxnCompletion(TransactionMetadata metadata, TransactionResult result) {
        this.maybeLogVerboseMessage((Function1<TransactionLoggingVerbosity, String> & Serializable)verbosity -> "Complete " + result + " of transaction: " + metadata.toString((TransactionLoggingVerbosity)verbosity));
    }

    private void endTransactionWithTV1(String transactionalId, long producerId, short producerEpoch, TransactionResult txnMarkerResult, boolean isFromClient, Function3<Errors, Object, Object, BoxedUnit> responseCallback, RequestLocal requestLocal) {
        Right right;
        Tuple2 tuple2;
        BooleanRef isEpochFence = BooleanRef.create(false);
        if (transactionalId == null || transactionalId.isEmpty()) {
            responseCallback.apply(Errors.INVALID_REQUEST, BoxesRunTime.boxToLong(-1L), BoxesRunTime.boxToShort((short)-1));
            return;
        }
        Either preAppendResult = this.txnManager.getTransactionState(transactionalId).flatMap((Function1<Option, Either> & Serializable)x0$1 -> {
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                return new Left(Errors.INVALID_PRODUCER_ID_MAPPING);
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
                TransactionMetadata txnMetadata = epochAndTxnMetadata.transactionMetadata();
                int coordinatorEpoch = epochAndTxnMetadata.coordinatorEpoch();
                return (Either)txnMetadata.inLock((Function0<Either> & Serializable)() -> {
                    TransactionState transactionState;
                    if (txnMetadata.producerId() != producerId) {
                        return new Left(Errors.INVALID_PRODUCER_ID_MAPPING);
                    }
                    if (isFromClient && producerEpoch != txnMetadata.producerEpoch() || producerEpoch < txnMetadata.producerEpoch()) {
                        return new Left(Errors.PRODUCER_FENCED);
                    }
                    if (txnMetadata.pendingTransitionInProgress()) {
                        TransactionState transactionState2 = txnMetadata.pendingState().get();
                        TransactionState transactionState3 = TransactionState.PREPARE_EPOCH_FENCE;
                        if (transactionState2 == null ? transactionState3 != null : !((Object)((Object)transactionState2)).equals((Object)transactionState3)) {
                            return new Left(Errors.CONCURRENT_TRANSACTIONS);
                        }
                    }
                    if (((Object)((Object)TransactionState.ONGOING)).equals((Object)(transactionState = txnMetadata.state()))) {
                        TransactionState nextState;
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult2 = TransactionResult.COMMIT;
                        TransactionState transactionState4 = nextState = !(transactionResult != null ? !transactionResult.equals(transactionResult2) : transactionResult2 != null) ? TransactionState.PREPARE_COMMIT : TransactionState.PREPARE_ABORT;
                        TransactionState transactionState5 = TransactionState.PREPARE_ABORT;
                        if (!(transactionState4 != null ? !((Object)((Object)transactionState4)).equals((Object)transactionState5) : transactionState5 != null) && txnMetadata.pendingState().contains(TransactionState.PREPARE_EPOCH_FENCE)) {
                            isEpochFence$1.elem = true;
                            txnMetadata.pendingState_$eq(None$.MODULE$);
                            txnMetadata.producerEpoch_$eq(producerEpoch);
                            txnMetadata.lastProducerEpoch_$eq((short)-1);
                        }
                        this.logTxnPrepareCompletion(txnMetadata, txnMarkerResult, isFromClient);
                        return new Right(new Tuple2<Integer, TxnTransitMetadata>(BoxesRunTime.boxToInteger(coordinatorEpoch), txnMetadata.prepareAbortOrCommit(nextState, TransactionVersion.fromFeatureLevel((short)0), -1L, $this.time.milliseconds(), false)));
                    }
                    if (((Object)((Object)TransactionState.COMPLETE_COMMIT)).equals((Object)transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult3 = TransactionResult.COMMIT;
                        if (!(transactionResult != null ? !transactionResult.equals(transactionResult3) : transactionResult3 != null)) {
                            this.logTxnCompletion(txnMetadata, TransactionResult.COMMIT);
                            return new Left(Errors.NONE);
                        }
                        return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    }
                    if (((Object)((Object)TransactionState.COMPLETE_ABORT)).equals((Object)transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult4 = TransactionResult.ABORT;
                        if (!(transactionResult != null ? !transactionResult.equals(transactionResult4) : transactionResult4 != null)) {
                            this.logTxnCompletion(txnMetadata, TransactionResult.ABORT);
                            return new Left(Errors.NONE);
                        }
                        return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    }
                    if (((Object)((Object)TransactionState.PREPARE_COMMIT)).equals((Object)transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult5 = TransactionResult.COMMIT;
                        if (!(transactionResult != null ? !transactionResult.equals(transactionResult5) : transactionResult5 != null)) {
                            return new Left(Errors.CONCURRENT_TRANSACTIONS);
                        }
                        return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    }
                    if (((Object)((Object)TransactionState.PREPARE_ABORT)).equals((Object)transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult6 = TransactionResult.ABORT;
                        if (!(transactionResult != null ? !transactionResult.equals(transactionResult6) : transactionResult6 != null)) {
                            return new Left(Errors.CONCURRENT_TRANSACTIONS);
                        }
                        return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    }
                    if (((Object)((Object)TransactionState.EMPTY)).equals((Object)transactionState)) {
                        return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    }
                    if (((Object)((Object)TransactionState.DEAD)).equals((Object)transactionState) ? true : ((Object)((Object)TransactionState.PREPARE_EPOCH_FENCE)).equals((Object)transactionState)) {
                        String errorMsg = "Found transactionalId " + transactionalId + " with state " + txnMetadata.state() + ". This is illegal as we should never have transitioned to this state.";
                        this.fatal((Function0<String> & Serializable)() -> errorMsg);
                        throw new IllegalStateException(errorMsg);
                    }
                    throw new MatchError((Object)transactionState);
                });
            }
            throw new MatchError(option);
        });
        Either either = preAppendResult;
        if (either instanceof Left) {
            Left left = (Left)either;
            Errors err = (Errors)left.value();
            this.debug((Function0<String> & Serializable)() -> "Aborting append of " + txnMarkerResult + " to transaction log with coordinator and returning " + err + " error to client for " + transactionalId + "'s EndTransaction request");
            responseCallback.apply(err, BoxesRunTime.boxToLong(-1L), BoxesRunTime.boxToShort((short)-1));
            return;
        }
        if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            String x$1 = transactionalId;
            int x$2 = coordinatorEpoch;
            TxnTransitMetadata x$3 = newMetadata;
            Function1<Errors, Object> & Serializable x$4 = (Function1<Errors, Object> & Serializable)error -> {
                this.sendTxnMarkersCallback$1(error, transactionalId, coordinatorEpoch, producerId, producerEpoch, txnMarkerResult, responseCallback, newMetadata, isEpochFence);
                return BoxedUnit.UNIT;
            };
            RequestLocal x$5 = requestLocal;
            Function1<Errors, Object> x$6 = this.txnManager.appendTransactionToLog$default$5();
            this.txnManager.appendTransactionToLog(x$1, x$2, x$3, (Function1<Errors, BoxedUnit>)x$4, x$6, x$5);
            return;
        }
        throw new MatchError(either);
    }

    private void endTransaction(String transactionalId, long producerId, short producerEpoch, TransactionResult txnMarkerResult, boolean isFromClient, TransactionVersion clientTransactionVersion, Function3<Errors, Object, Object, BoxedUnit> responseCallback, RequestLocal requestLocal) {
        Right right;
        Tuple2 tuple2;
        if (!clientTransactionVersion.supportsEpochBump()) {
            this.endTransactionWithTV1(transactionalId, producerId, producerEpoch, txnMarkerResult, isFromClient, responseCallback, requestLocal);
            return;
        }
        BooleanRef isEpochFence = BooleanRef.create(false);
        if (transactionalId == null || transactionalId.isEmpty()) {
            responseCallback.apply(Errors.INVALID_REQUEST, BoxesRunTime.boxToLong(-1L), BoxesRunTime.boxToShort((short)-1));
            return;
        }
        LongRef producerIdCopy = LongRef.create(-1L);
        ShortRef producerEpochCopy = ShortRef.create((short)-1);
        Either preAppendResult = this.txnManager.getTransactionState(transactionalId).flatMap((Function1<Option, Either> & Serializable)x0$1 -> {
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                return new Left(Errors.INVALID_PRODUCER_ID_MAPPING);
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
                TransactionMetadata txnMetadata = epochAndTxnMetadata.transactionMetadata();
                int coordinatorEpoch = epochAndTxnMetadata.coordinatorEpoch();
                return (Either)txnMetadata.inLock((Function0<Either> & Serializable)() -> {
                    boolean isRetry;
                    boolean bl;
                    boolean retryOnEpochBump;
                    producerIdCopy$1.elem = txnMetadata.producerId();
                    producerEpochCopy$1.elem = txnMetadata.producerEpoch();
                    isEpochFence$2.elem = txnMetadata.pendingState().contains(TransactionState.PREPARE_EPOCH_FENCE);
                    boolean retryOnOverflow = !isEpochFence$2.elem && txnMetadata.prevProducerId() == producerId && producerEpoch == 32766 && txnMetadata.producerEpoch() == 0;
                    boolean bl2 = retryOnEpochBump = !isEpochFence$2.elem && txnMetadata.producerEpoch() == producerEpoch + 1;
                    if (!isEpochFence$2.elem) {
                        TransactionState transactionState = txnMetadata.state();
                        if (((Object)((Object)TransactionState.ONGOING)).equals((Object)transactionState) ? true : (((Object)((Object)TransactionState.EMPTY)).equals((Object)transactionState) ? true : (((Object)((Object)TransactionState.DEAD)).equals((Object)transactionState) ? true : ((Object)((Object)TransactionState.PREPARE_EPOCH_FENCE)).equals((Object)transactionState)))) {
                            bl = producerEpoch == txnMetadata.producerEpoch();
                        } else if (((Object)((Object)TransactionState.PREPARE_COMMIT)).equals((Object)transactionState) ? true : ((Object)((Object)TransactionState.PREPARE_ABORT)).equals((Object)transactionState)) {
                            bl = retryOnEpochBump;
                        } else {
                            if (!(((Object)((Object)TransactionState.COMPLETE_COMMIT)).equals((Object)transactionState) ? true : ((Object)((Object)TransactionState.COMPLETE_ABORT)).equals((Object)transactionState))) throw new MatchError((Object)transactionState);
                            bl = retryOnEpochBump || retryOnOverflow || producerEpoch == txnMetadata.producerEpoch();
                        }
                    } else {
                        bl = (!isFromClient || producerEpoch == txnMetadata.producerEpoch()) && producerEpoch >= txnMetadata.producerEpoch();
                    }
                    boolean isValidEpoch = bl;
                    boolean bl3 = isRetry = retryOnEpochBump || retryOnOverflow;
                    if (txnMetadata.pendingTransitionInProgress()) {
                        TransactionState transactionState = txnMetadata.pendingState().get();
                        TransactionState transactionState2 = TransactionState.PREPARE_EPOCH_FENCE;
                        if (transactionState == null ? transactionState2 != null : !((Object)((Object)transactionState)).equals((Object)transactionState2)) {
                            return new Left(Errors.CONCURRENT_TRANSACTIONS);
                        }
                    }
                    if (txnMetadata.producerId() != producerId && !retryOnOverflow) {
                        return new Left(Errors.INVALID_PRODUCER_ID_MAPPING);
                    }
                    if (!isValidEpoch) {
                        return new Left(Errors.PRODUCER_FENCED);
                    }
                    TransactionState transactionState = txnMetadata.state();
                    if (((Object)((Object)TransactionState.ONGOING)).equals((Object)transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult2 = TransactionResult.COMMIT;
                        TransactionState nextState = !(transactionResult != null ? !transactionResult.equals(transactionResult2) : transactionResult2 != null) ? TransactionState.PREPARE_COMMIT : TransactionState.PREPARE_ABORT;
                        return this.generateTxnTransitMetadataForTxnCompletion$1(nextState, false, isEpochFence, txnMetadata, txnMarkerResult, isFromClient, coordinatorEpoch, clientTransactionVersion);
                    }
                    if (((Object)((Object)TransactionState.COMPLETE_COMMIT)).equals((Object)transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult3 = TransactionResult.COMMIT;
                        if (!(transactionResult != null ? !transactionResult.equals(transactionResult3) : transactionResult3 != null)) {
                            if (!isRetry) return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                            this.logTxnCompletion(txnMetadata, TransactionResult.COMMIT);
                            return new Left(Errors.NONE);
                        }
                        if (!isRetry) return this.generateTxnTransitMetadataForTxnCompletion$1(TransactionState.PREPARE_ABORT, true, isEpochFence, txnMetadata, txnMarkerResult, isFromClient, coordinatorEpoch, clientTransactionVersion);
                        return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    }
                    if (((Object)((Object)TransactionState.COMPLETE_ABORT)).equals((Object)transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult4 = TransactionResult.ABORT;
                        if (transactionResult != null ? !transactionResult.equals(transactionResult4) : transactionResult4 != null) return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                        if (!isRetry) return this.generateTxnTransitMetadataForTxnCompletion$1(TransactionState.PREPARE_ABORT, true, isEpochFence, txnMetadata, txnMarkerResult, isFromClient, coordinatorEpoch, clientTransactionVersion);
                        this.logTxnCompletion(txnMetadata, TransactionResult.ABORT);
                        return new Left(Errors.NONE);
                    }
                    if (((Object)((Object)TransactionState.PREPARE_COMMIT)).equals((Object)transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult5 = TransactionResult.COMMIT;
                        if (transactionResult != null ? !transactionResult.equals(transactionResult5) : transactionResult5 != null) return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                        return new Left(Errors.CONCURRENT_TRANSACTIONS);
                    }
                    if (((Object)((Object)TransactionState.PREPARE_ABORT)).equals((Object)transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult6 = TransactionResult.ABORT;
                        if (transactionResult != null ? !transactionResult.equals(transactionResult6) : transactionResult6 != null) return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                        return new Left(Errors.CONCURRENT_TRANSACTIONS);
                    }
                    if (((Object)((Object)TransactionState.EMPTY)).equals((Object)transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult7 = TransactionResult.ABORT;
                        if (transactionResult != null ? !transactionResult.equals(transactionResult7) : transactionResult7 != null) return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                        return this.generateTxnTransitMetadataForTxnCompletion$1(TransactionState.PREPARE_ABORT, true, isEpochFence, txnMetadata, txnMarkerResult, isFromClient, coordinatorEpoch, clientTransactionVersion);
                    }
                    if (!(((Object)((Object)TransactionState.DEAD)).equals((Object)transactionState) ? true : ((Object)((Object)TransactionState.PREPARE_EPOCH_FENCE)).equals((Object)transactionState))) throw new MatchError((Object)transactionState);
                    String errorMsg = "Found transactionalId " + transactionalId + " with state " + txnMetadata.state() + ". This is illegal as we should never have transitioned to this state.";
                    this.fatal((Function0<String> & Serializable)() -> errorMsg);
                    throw new IllegalStateException(errorMsg);
                });
            }
            throw new MatchError(option);
        });
        Either either = preAppendResult;
        if (either instanceof Left) {
            Errors err;
            Left left = (Left)either;
            Errors errors = err = (Errors)left.value();
            Errors errors2 = Errors.NONE;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                responseCallback.apply(err, BoxesRunTime.boxToLong(producerIdCopy.elem), BoxesRunTime.boxToShort(producerEpochCopy.elem));
                return;
            }
            this.debug((Function0<String> & Serializable)() -> "Aborting append of " + txnMarkerResult + " to transaction log with coordinator and returning " + err + " error to client for " + transactionalId + "'s EndTransaction request");
            responseCallback.apply(err, BoxesRunTime.boxToLong(-1L), BoxesRunTime.boxToShort((short)-1));
            return;
        }
        if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            String x$1 = transactionalId;
            int x$2 = coordinatorEpoch;
            TxnTransitMetadata x$3 = newMetadata;
            Function1<Errors, Object> & Serializable x$4 = (Function1<Errors, Object> & Serializable)error -> {
                this.sendTxnMarkersCallback$2(error, transactionalId, coordinatorEpoch, producerId, producerEpoch, txnMarkerResult, responseCallback, newMetadata, isEpochFence);
                return BoxedUnit.UNIT;
            };
            RequestLocal x$5 = requestLocal;
            Function1<Errors, Object> x$6 = this.txnManager.appendTransactionToLog$default$5();
            this.txnManager.appendTransactionToLog(x$1, x$2, x$3, (Function1<Errors, BoxedUnit>)x$4, x$6, x$5);
            return;
        }
        throw new MatchError(either);
    }

    public Properties transactionTopicConfigs() {
        return this.txnManager.transactionTopicConfigs();
    }

    public String placementConstraints() {
        return this.txnManager.placementConstraints();
    }

    public int partitionFor(String transactionalId) {
        return this.txnManager.partitionFor(transactionalId);
    }

    private void onEndTransactionComplete(TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch, Errors error, long newProducerId, short newProducerEpoch) {
        Errors errors = error;
        if (Errors.NONE.equals(errors)) {
            this.txnManager.transactionTimeoutSensor().record();
            this.info((Function0<String> & Serializable)() -> "Completed rollback of ongoing transaction for transactionalId " + txnIdAndPidEpoch.transactionalId() + " due to timeout");
            return;
        }
        if (Errors.INVALID_PRODUCER_ID_MAPPING.equals(errors) ? true : (Errors.PRODUCER_FENCED.equals(errors) ? true : Errors.CONCURRENT_TRANSACTIONS.equals(errors))) {
            this.debug((Function0<String> & Serializable)() -> "Rollback of ongoing transaction for transactionalId " + txnIdAndPidEpoch.transactionalId() + " has been cancelled due to error " + errors);
            return;
        }
        this.warn((Function0<String> & Serializable)() -> "Rollback of ongoing transaction for transactionalId " + txnIdAndPidEpoch.transactionalId() + " failed due to error " + errors);
    }

    public void abortTimedOutTransactions(Function1<TransactionalIdAndProducerIdEpoch, Function3<Errors, Object, Object, BoxedUnit>> onComplete) {
        this.txnManager.timedOutTransactions().foreach((Function1<TransactionalIdAndProducerIdEpoch, Object> & Serializable)txnIdAndPidEpoch -> {
            TransactionCoordinator.$anonfun$abortTimedOutTransactions$1(this, onComplete, txnIdAndPidEpoch);
            return BoxedUnit.UNIT;
        });
    }

    public void startup(Function0<Object> retrieveTransactionTopicPartitionCount, boolean enableTransactionalIdExpiration) {
        this.info((Function0<String> & Serializable)() -> "Starting up.");
        this.scheduler.startup();
        this.scheduler.schedule("transaction-abort", () -> this.abortTimedOutTransactions((Function1<TransactionalIdAndProducerIdEpoch, Function3<Errors, Object, Object, BoxedUnit>>)(Function1<TransactionalIdAndProducerIdEpoch, Function3> & Serializable)txnIdAndPidEpoch -> (Function3<Errors, Object, Object, Object> & Serializable)(error, newProducerId, newProducerEpoch) -> {
            this.onEndTransactionComplete(txnIdAndPidEpoch, error, BoxesRunTime.unboxToLong(newProducerId), BoxesRunTime.unboxToShort(newProducerEpoch));
            return BoxedUnit.UNIT;
        }), this.txnConfig.abortTimedOutTransactionsIntervalMs(), this.txnConfig.abortTimedOutTransactionsIntervalMs());
        this.txnManager.startup(retrieveTransactionTopicPartitionCount, enableTransactionalIdExpiration);
        this.scheduler.schedule("long-loading-state-partitions", () -> $this.txnManager.logLongestLoadingStatePartition(), this.transactionStateLoadingLoggingIntervalMs(), this.transactionStateLoadingLoggingIntervalMs());
        this.txnMarkerChannelManager.start();
        this.isActive().set(true);
        this.info((Function0<String> & Serializable)() -> "Startup complete.");
    }

    public boolean startup$default$2() {
        return true;
    }

    public void shutdown() {
        this.info((Function0<String> & Serializable)() -> "Shutting down.");
        this.isActive().set(false);
        this.scheduler.shutdown();
        this.txnManager.shutdown();
        this.txnMarkerChannelManager.shutdown();
        this.info((Function0<String> & Serializable)() -> "Shutdown complete.");
    }

    private static final void sendRetriableErrorCallback$1(Errors error, long newProducerId, short newProducerEpoch, Function1 responseCallback$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (errors == null ? errors2 != null : !errors.equals(errors2)) {
            responseCallback$1.apply(TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
            return;
        }
        responseCallback$1.apply(TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
    }

    private final void sendPidResponseCallback$1(Errors error, String transactionalId$1, TxnTransitMetadata newMetadata$1, Function1 responseCallback$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            this.info((Function0<String> & Serializable)() -> "Initialized transactionalId " + transactionalId$1 + " with producerId " + newMetadata$1.producerId() + " and producer epoch " + newMetadata$1.producerEpoch() + " on partition __transaction_state-" + $this.txnManager.partitionFor(transactionalId$1));
            responseCallback$1.apply(TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(newMetadata$1));
            return;
        }
        this.info((Function0<String> & Serializable)() -> "Returning " + error + " error code to client for " + transactionalId$1 + "'s InitProducerId request");
        responseCallback$1.apply(TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
    }

    private static final boolean isValidProducerId$1(ProducerIdAndEpoch producerIdAndEpoch, TransactionMetadata txnMetadata$2) {
        return txnMetadata$2.producerEpoch() == -1 || producerIdAndEpoch.producerId == txnMetadata$2.producerId() || producerIdAndEpoch.producerId == txnMetadata$2.prevProducerId() && TransactionMetadata$.MODULE$.isEpochExhausted(producerIdAndEpoch.epoch);
    }

    public static final /* synthetic */ boolean $anonfun$prepareInitProducerIdTransit$2(TransactionMetadata txnMetadata$2, ProducerIdAndEpoch x$2) {
        return x$2.epoch == txnMetadata$2.producerEpoch();
    }

    public static final /* synthetic */ boolean $anonfun$handleDescribeTransactions$2(DescribeTransactionsResponseData.TransactionState transactionState$1, TopicPartition topicPartition) {
        DescribeTransactionsResponseData.TopicData topicData = transactionState$1.topics().find(topicPartition.topic());
        if (topicData == null) {
            topicData = new DescribeTransactionsResponseData.TopicData().setTopic(topicPartition.topic());
            v0 = BoxesRunTime.boxToBoolean(transactionState$1.topics().add((ImplicitLinkedHashCollection.Element)topicData));
        } else {
            v0 = BoxedUnit.UNIT;
        }
        return topicData.partitions().add(Predef$.MODULE$.int2Integer(topicPartition.partition()));
    }

    public static final /* synthetic */ boolean $anonfun$isAddingOffsets$1(TopicPartition tp) {
        String string = tp.topic();
        String string2 = "__consumer_offsets";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$endTransactionWithTV1$12(TransactionCoordinator $this, String transactionalId$5, int coordinatorEpoch$6, Errors error$2, TxnTransitMetadata newMetadata$2, Option x0$2) {
        Option option = x0$2;
        if (None$.MODULE$.equals(option)) {
            $this.warn((Function0<String> & Serializable)() -> "The coordinator still owns the transaction partition for " + transactionalId$5 + ", but there is no metadata in the cache; this is not expected");
            return;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
            if (epochAndMetadata.coordinatorEpoch() == coordinatorEpoch$6) {
                epochAndMetadata.transactionMetadata().hasFailedEpochFence_$eq(true);
                $this.warn((Function0<String> & Serializable)() -> "The coordinator failed to write an epoch fence transition for producer " + transactionalId$5 + " to the transaction log with error " + error$2 + ". The epoch was increased to " + newMetadata$2.producerEpoch() + " but not returned to the client");
                return;
            }
            return;
        }
        throw new MatchError(option);
    }

    private final void sendTxnMarkersCallback$1(Errors error, String transactionalId$5, int coordinatorEpoch$6, long producerId$3, short producerEpoch$3, TransactionResult txnMarkerResult$1, Function3 responseCallback$2, TxnTransitMetadata newMetadata$2, BooleanRef isEpochFence$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            Right right;
            Tuple2 tuple2;
            Either preSendResult = this.txnManager.getTransactionState(transactionalId$5).flatMap((Function1<Option, Either> & Serializable)x0$1 -> {
                Option option = x0$1;
                if (None$.MODULE$.equals(option)) {
                    String errorMsg = "The coordinator still owns the transaction partition for " + transactionalId$5 + ", but there is no metadata in the cache; this is not expected";
                    this.fatal((Function0<String> & Serializable)() -> errorMsg);
                    throw new IllegalStateException(errorMsg);
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
                    if (epochAndMetadata.coordinatorEpoch() == coordinatorEpoch$6) {
                        TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                        return (Either)txnMetadata.inLock((Function0<Either> & Serializable)() -> {
                            if (txnMetadata.producerId() != producerId$3) {
                                return new Left(Errors.INVALID_PRODUCER_ID_MAPPING);
                            }
                            if (txnMetadata.producerEpoch() != producerEpoch$3) {
                                return new Left(Errors.PRODUCER_FENCED);
                            }
                            if (txnMetadata.pendingTransitionInProgress()) {
                                return new Left(Errors.CONCURRENT_TRANSACTIONS);
                            }
                            TransactionState transactionState = txnMetadata.state();
                            if (((Object)((Object)TransactionState.EMPTY)).equals((Object)transactionState) ? true : (((Object)((Object)TransactionState.ONGOING)).equals((Object)transactionState) ? true : (((Object)((Object)TransactionState.COMPLETE_COMMIT)).equals((Object)transactionState) ? true : ((Object)((Object)TransactionState.COMPLETE_ABORT)).equals((Object)transactionState)))) {
                                return this.logInvalidStateTransitionAndReturnError(transactionalId$5, txnMetadata.state(), txnMarkerResult$1);
                            }
                            if (((Object)((Object)TransactionState.PREPARE_COMMIT)).equals((Object)transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult$1;
                                TransactionResult transactionResult2 = TransactionResult.COMMIT;
                                if (transactionResult == null ? transactionResult2 != null : !transactionResult.equals(transactionResult2)) {
                                    return this.logInvalidStateTransitionAndReturnError(transactionalId$5, txnMetadata.state(), txnMarkerResult$1);
                                }
                                return new Right(new Tuple2<TransactionMetadata, TxnTransitMetadata>(txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds())));
                            }
                            if (((Object)((Object)TransactionState.PREPARE_ABORT)).equals((Object)transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult$1;
                                TransactionResult transactionResult3 = TransactionResult.ABORT;
                                if (transactionResult == null ? transactionResult3 != null : !transactionResult.equals(transactionResult3)) {
                                    return this.logInvalidStateTransitionAndReturnError(transactionalId$5, txnMetadata.state(), txnMarkerResult$1);
                                }
                                return new Right(new Tuple2<TransactionMetadata, TxnTransitMetadata>(txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds())));
                            }
                            if (((Object)((Object)TransactionState.DEAD)).equals((Object)transactionState) ? true : ((Object)((Object)TransactionState.PREPARE_EPOCH_FENCE)).equals((Object)transactionState)) {
                                String errorMsg = "Found transactionalId " + transactionalId$5 + " with state " + txnMetadata.state() + ". This is illegal as we should never have transitioned to this state.";
                                this.fatal((Function0<String> & Serializable)() -> errorMsg);
                                throw new IllegalStateException(errorMsg);
                            }
                            throw new MatchError((Object)transactionState);
                        });
                    }
                    this.debug((Function0<String> & Serializable)() -> "The transaction coordinator epoch has changed to " + epochAndMetadata.coordinatorEpoch() + " after " + txnMarkerResult$1 + " was successfully appended to the log for " + transactionalId$5 + " with old epoch " + coordinatorEpoch$6);
                    return new Left(Errors.NOT_COORDINATOR);
                }
                throw new MatchError(option);
            });
            Either either = preSendResult;
            if (either instanceof Left) {
                Left left = (Left)either;
                Errors err = (Errors)left.value();
                this.info((Function0<String> & Serializable)() -> "Aborting sending of transaction markers after appended " + txnMarkerResult$1 + " to transaction log and returning " + err + " error to client for " + transactionalId$5 + "'s EndTransaction request");
                BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$2.apply(err, BoxesRunTime.boxToLong(-1L), BoxesRunTime.boxToShort((short)-1));
                return;
            }
            if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
                TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._1();
                TxnTransitMetadata newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                responseCallback$2.apply(Errors.NONE, BoxesRunTime.boxToLong(-1L), BoxesRunTime.boxToShort((short)-1));
                this.txnMarkerChannelManager.addTxnMarkersToSend(coordinatorEpoch$6, txnMarkerResult$1, txnMetadata, newPreSendMetadata);
                return;
            }
            throw new MatchError(either);
        }
        this.info((Function0<String> & Serializable)() -> "Aborting sending of transaction markers and returning " + error + " error to client for " + transactionalId$5 + "'s EndTransaction request of " + txnMarkerResult$1 + ", since appending " + newMetadata$2 + " to transaction log with coordinator epoch " + coordinatorEpoch$6 + " failed");
        if (isEpochFence$1.elem) {
            this.txnManager.getTransactionState(transactionalId$5).foreach((Function1<Option, Object> & Serializable)x0$2 -> {
                TransactionCoordinator.$anonfun$endTransactionWithTV1$12(this, transactionalId$5, coordinatorEpoch$6, error, newMetadata$2, x0$2);
                return BoxedUnit.UNIT;
            });
        }
        responseCallback$2.apply(error, BoxesRunTime.boxToLong(-1L), BoxesRunTime.boxToShort((short)-1));
    }

    public static final /* synthetic */ Right $anonfun$endTransaction$3(TransactionCoordinator $this, int coordinatorEpoch$7, TransactionMetadata txnMetadata$8, TransactionState nextState$1, TransactionVersion clientTransactionVersion$2, boolean noPartitionAdded$1, long nextProducerId) {
        return new Right(new Tuple2<Integer, TxnTransitMetadata>(BoxesRunTime.boxToInteger(coordinatorEpoch$7), txnMetadata$8.prepareAbortOrCommit(nextState$1, clientTransactionVersion$2, nextProducerId, $this.time.milliseconds(), noPartitionAdded$1)));
    }

    private final Either generateTxnTransitMetadataForTxnCompletion$1(TransactionState nextState, boolean noPartitionAdded, BooleanRef isEpochFence$2, TransactionMetadata txnMetadata$8, TransactionResult txnMarkerResult$2, boolean isFromClient$3, int coordinatorEpoch$7, TransactionVersion clientTransactionVersion$2) {
        Either either;
        if (!isEpochFence$2.elem && txnMetadata$8.isProducerEpochExhausted()) {
            try {
                either = new Right(BoxesRunTime.boxToLong(this.producerIdManager().generateProducerId()));
            }
            catch (Exception e) {
                either = new Left(Errors.forException((Throwable)e));
            }
        } else {
            either = new Right(BoxesRunTime.boxToLong(-1L));
        }
        Right nextProducerIdOrErrors = either;
        TransactionState transactionState = nextState;
        TransactionState transactionState2 = TransactionState.PREPARE_ABORT;
        if (!(transactionState != null ? !((Object)((Object)transactionState)).equals((Object)transactionState2) : transactionState2 != null) && isEpochFence$2.elem) {
            txnMetadata$8.pendingState_$eq(None$.MODULE$);
        }
        this.logTxnPrepareCompletion(txnMetadata$8, txnMarkerResult$2, isFromClient$3);
        return nextProducerIdOrErrors.flatMap((Function1<Object, Right> & Serializable)nextProducerId -> TransactionCoordinator.$anonfun$endTransaction$3(this, coordinatorEpoch$7, txnMetadata$8, nextState, clientTransactionVersion$2, noPartitionAdded, BoxesRunTime.unboxToLong(nextProducerId)));
    }

    public static final /* synthetic */ void $anonfun$endTransaction$13(TransactionCoordinator $this, String transactionalId$6, int coordinatorEpoch$8, Errors error$3, Option x0$2) {
        Option option = x0$2;
        if (None$.MODULE$.equals(option)) {
            $this.warn((Function0<String> & Serializable)() -> "The coordinator still owns the transaction partition for " + transactionalId$6 + ", but there is no metadata in the cache; this is not expected");
            return;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
            if (epochAndMetadata.coordinatorEpoch() == coordinatorEpoch$8) {
                $this.warn((Function0<String> & Serializable)() -> "The coordinator failed to write an epoch fence transition for producer " + transactionalId$6 + " to the transaction log with error " + error$3);
                return;
            }
            return;
        }
        throw new MatchError(option);
    }

    private final void sendTxnMarkersCallback$2(Errors error, String transactionalId$6, int coordinatorEpoch$8, long producerId$4, short producerEpoch$4, TransactionResult txnMarkerResult$2, Function3 responseCallback$3, TxnTransitMetadata newMetadata$3, BooleanRef isEpochFence$2) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            Right right;
            Tuple2 tuple2;
            Either preSendResult = this.txnManager.getTransactionState(transactionalId$6).flatMap((Function1<Option, Either> & Serializable)x0$1 -> {
                Option option = x0$1;
                if (None$.MODULE$.equals(option)) {
                    String errorMsg = "The coordinator still owns the transaction partition for " + transactionalId$6 + ", but there is no metadata in the cache; this is not expected";
                    this.fatal((Function0<String> & Serializable)() -> errorMsg);
                    throw new IllegalStateException(errorMsg);
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
                    if (epochAndMetadata.coordinatorEpoch() == coordinatorEpoch$8) {
                        TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                        return (Either)txnMetadata.inLock((Function0<Either> & Serializable)() -> {
                            if (txnMetadata.producerId() != producerId$4) {
                                return new Left(Errors.INVALID_PRODUCER_ID_MAPPING);
                            }
                            if (txnMetadata.producerEpoch() != producerEpoch$4 && txnMetadata.producerEpoch() != producerEpoch$4 + 1) {
                                return new Left(Errors.PRODUCER_FENCED);
                            }
                            if (txnMetadata.pendingTransitionInProgress()) {
                                return new Left(Errors.CONCURRENT_TRANSACTIONS);
                            }
                            TransactionState transactionState = txnMetadata.state();
                            if (((Object)((Object)TransactionState.EMPTY)).equals((Object)transactionState) ? true : (((Object)((Object)TransactionState.ONGOING)).equals((Object)transactionState) ? true : (((Object)((Object)TransactionState.COMPLETE_COMMIT)).equals((Object)transactionState) ? true : ((Object)((Object)TransactionState.COMPLETE_ABORT)).equals((Object)transactionState)))) {
                                return this.logInvalidStateTransitionAndReturnError(transactionalId$6, txnMetadata.state(), txnMarkerResult$2);
                            }
                            if (((Object)((Object)TransactionState.PREPARE_COMMIT)).equals((Object)transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult$2;
                                TransactionResult transactionResult2 = TransactionResult.COMMIT;
                                if (transactionResult == null ? transactionResult2 != null : !transactionResult.equals(transactionResult2)) {
                                    return this.logInvalidStateTransitionAndReturnError(transactionalId$6, txnMetadata.state(), txnMarkerResult$2);
                                }
                                return new Right(new Tuple2<TransactionMetadata, TxnTransitMetadata>(txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds())));
                            }
                            if (((Object)((Object)TransactionState.PREPARE_ABORT)).equals((Object)transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult$2;
                                TransactionResult transactionResult3 = TransactionResult.ABORT;
                                if (transactionResult == null ? transactionResult3 != null : !transactionResult.equals(transactionResult3)) {
                                    return this.logInvalidStateTransitionAndReturnError(transactionalId$6, txnMetadata.state(), txnMarkerResult$2);
                                }
                                return new Right(new Tuple2<TransactionMetadata, TxnTransitMetadata>(txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds())));
                            }
                            if (((Object)((Object)TransactionState.DEAD)).equals((Object)transactionState) ? true : ((Object)((Object)TransactionState.PREPARE_EPOCH_FENCE)).equals((Object)transactionState)) {
                                String errorMsg = "Found transactionalId " + transactionalId$6 + " with state " + txnMetadata.state() + ". This is illegal as we should never have transitioned to this state.";
                                this.fatal((Function0<String> & Serializable)() -> errorMsg);
                                throw new IllegalStateException(errorMsg);
                            }
                            throw new MatchError((Object)transactionState);
                        });
                    }
                    this.debug((Function0<String> & Serializable)() -> "The transaction coordinator epoch has changed to " + epochAndMetadata.coordinatorEpoch() + " after " + txnMarkerResult$2 + " was successfully appended to the log for " + transactionalId$6 + " with old epoch " + coordinatorEpoch$8);
                    return new Left(Errors.NOT_COORDINATOR);
                }
                throw new MatchError(option);
            });
            Either either = preSendResult;
            if (either instanceof Left) {
                Left left = (Left)either;
                Errors err = (Errors)left.value();
                this.info((Function0<String> & Serializable)() -> "Aborting sending of transaction markers after appended " + txnMarkerResult$2 + " to transaction log and returning " + err + " error to client for " + transactionalId$6 + "'s EndTransaction request");
                BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$3.apply(err, BoxesRunTime.boxToLong(-1L), BoxesRunTime.boxToShort((short)-1));
                return;
            }
            if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
                TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._1();
                TxnTransitMetadata newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                responseCallback$3.apply(Errors.NONE, BoxesRunTime.boxToLong(newPreSendMetadata.producerId()), BoxesRunTime.boxToShort(newPreSendMetadata.producerEpoch()));
                this.txnMarkerChannelManager.addTxnMarkersToSend(coordinatorEpoch$8, txnMarkerResult$2, txnMetadata, newPreSendMetadata);
                return;
            }
            throw new MatchError(either);
        }
        this.info((Function0<String> & Serializable)() -> "Aborting sending of transaction markers and returning " + error + " error to client for " + transactionalId$6 + "'s EndTransaction request of " + txnMarkerResult$2 + ", since appending " + newMetadata$3 + " to transaction log with coordinator epoch " + coordinatorEpoch$8 + " failed");
        if (isEpochFence$2.elem) {
            this.txnManager.getTransactionState(transactionalId$6).foreach((Function1<Option, Object> & Serializable)x0$2 -> {
                TransactionCoordinator.$anonfun$endTransaction$13(this, transactionalId$6, coordinatorEpoch$8, error, x0$2);
                return BoxedUnit.UNIT;
            });
        }
        responseCallback$3.apply(error, BoxesRunTime.boxToLong(-1L), BoxesRunTime.boxToShort((short)-1));
    }

    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$2(TransactionCoordinator $this, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch$2, Function1 onComplete$1, Option x0$1) {
        Option option = x0$1;
        if (None$.MODULE$.equals(option)) {
            $this.error((Function0<String> & Serializable)() -> "Could not find transaction metadata when trying to timeout transaction for " + txnIdAndPidEpoch$2);
            return;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
            TransactionMetadata txnMetadata = epochAndTxnMetadata.transactionMetadata();
            Option transitMetadataOpt = (Option)txnMetadata.inLock((Function0<Option> & Serializable)() -> {
                if (txnMetadata.producerId() != txnIdAndPidEpoch$2.producerId()) {
                    $this.error((Function0<String> & Serializable)() -> "Found incorrect producerId when expiring transactionalId: " + txnIdAndPidEpoch$2.transactionalId() + ". Expected producerId: " + txnIdAndPidEpoch$2.producerId() + ". Found producerId: " + txnMetadata.producerId());
                    return None$.MODULE$;
                }
                if (txnMetadata.pendingTransitionInProgress()) {
                    $this.debug((Function0<String> & Serializable)() -> "Skipping abort of timed out transaction " + txnIdAndPidEpoch$2 + " since there is a pending state transition");
                    return None$.MODULE$;
                }
                if (txnMetadata.isDistributedTwoPhaseCommitTxnCfltFlink()) {
                    $this.info((Function0<String> & Serializable)() -> "Aborting 2PC flink transaction " + txnMetadata.transactionalId());
                }
                return new Some<TxnTransitMetadata>(txnMetadata.prepareFenceProducerEpoch());
            });
            transitMetadataOpt.foreach((Function1<TxnTransitMetadata, Object> & Serializable)txnTransitMetadata -> {
                $this.endTransaction(txnMetadata.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, false, $this.txnManager.transactionVersionLevel(), (Function3)onComplete$1.apply(txnIdAndPidEpoch$2), RequestLocal.noCaching());
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$1(TransactionCoordinator $this, Function1 onComplete$1, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch) {
        $this.txnManager.getTransactionState(txnIdAndPidEpoch.transactionalId()).foreach((Function1<Option, Object> & Serializable)x0$1 -> {
            TransactionCoordinator.$anonfun$abortTimedOutTransactions$2($this, txnIdAndPidEpoch, onComplete$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public TransactionCoordinator(TransactionConfig txnConfig, Scheduler scheduler, Function0<ProducerIdManager> createProducerIdManager, TransactionStateManager txnManager, TransactionMarkerChannelManager txnMarkerChannelManager, Time time, LogContext logContext) {
        this.txnConfig = txnConfig;
        this.scheduler = scheduler;
        this.txnManager = txnManager;
        this.txnMarkerChannelManager = txnMarkerChannelManager;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(logContext.logPrefix());
        this.isActive = new AtomicBoolean(false);
        this.producerIdManager = createProducerIdManager.apply();
        this.logVerbosity = txnConfig.transactionLoggingVerbosity();
        this.transactionStateLoadingLoggingIntervalMs = 300000;
    }
}

