/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.locks.ReentrantLock;
import kafka.coordinator.transaction.TransactionLoggingVerbosity;
import kafka.coordinator.transaction.TransactionLoggingVerbosity$All$;
import kafka.coordinator.transaction.TransactionLoggingVerbosity$Off$;
import kafka.coordinator.transaction.TransactionLoggingVerbosity$Sample$;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.coordinator.transaction.TransactionState;
import org.apache.kafka.coordinator.transaction.TxnTransitMetadata;
import org.apache.kafka.server.common.TransactionVersion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\reuAB+W\u0011\u00031FL\u0002\u0004_-\"\u0005ak\u0018\u0005\u0006M\u0006!\t\u0001\u001b\u0005\u0006S\u0006!\tA\u001b\u0005\bg\u0006\t\n\u0011\"\u0001u\r\u0019qf\u000b\u0001,\u0002\u0006!Q\u00111C\u0003\u0003\u0006\u0004%\t!!\u0006\t\u0015\u00055RA!A!\u0002\u0013\t9\u0002\u0003\u0006\u00020\u0015\u0011\t\u0019!C\u0001\u0003cA!\"a\r\u0006\u0005\u0003\u0007I\u0011AA\u001b\u0011%\t\t%\u0002B\u0001B\u0003&a\u000f\u0003\u0006\u0002D\u0015\u0011\t\u0019!C\u0001\u0003cA!\"!\u0012\u0006\u0005\u0003\u0007I\u0011AA$\u0011%\tY%\u0002B\u0001B\u0003&a\u000f\u0003\u0006\u0002N\u0015\u0011\t\u0019!C\u0001\u0003cA!\"a\u0014\u0006\u0005\u0003\u0007I\u0011AA)\u0011%\t)&\u0002B\u0001B\u0003&a\u000fC\u0005p\u000b\t\u0005\r\u0011\"\u0001\u0002X!Q\u0011\u0011L\u0003\u0003\u0002\u0004%\t!a\u0017\t\u0013\u0005}SA!A!B\u0013\u0001\bBCA1\u000b\t\u0005\r\u0011\"\u0001\u0002X!Q\u00111M\u0003\u0003\u0002\u0004%\t!!\u001a\t\u0013\u0005%TA!A!B\u0013\u0001\bBCA6\u000b\t\u0005\r\u0011\"\u0001\u0002n!Q\u0011QO\u0003\u0003\u0002\u0004%\t!a\u001e\t\u0015\u0005mTA!A!B\u0013\ty\u0007\u0003\u0006\u0002~\u0015\u0011\t\u0019!C\u0001\u0003\u007fB!\"a&\u0006\u0005\u0003\u0007I\u0011AAM\u0011)\ti*\u0002B\u0001B\u0003&\u0011\u0011\u0011\u0005\u000b\u0003O+!\u00111A\u0005\u0002\u0005%\u0006BCAd\u000b\t\u0005\r\u0011\"\u0001\u0002J\"Q\u0011QZ\u0003\u0003\u0002\u0003\u0006K!a+\t\u0015\u0005=WA!a\u0001\n\u0003\t\t\u0004\u0003\u0006\u0002R\u0016\u0011\t\u0019!C\u0001\u0003'D\u0011\"a6\u0006\u0005\u0003\u0005\u000b\u0015\u0002<\t\u0015\u0005mWA!a\u0001\n\u0003\t\t\u0004\u0003\u0006\u0002^\u0016\u0011\t\u0019!C\u0001\u0003?D\u0011\"a9\u0006\u0005\u0003\u0005\u000b\u0015\u0002<\t\u0015\u0005\u001dXA!a\u0001\n\u0003\tI\u000f\u0003\u0006\u0002z\u0016\u0011\t\u0019!C\u0001\u0003wD!\"a@\u0006\u0005\u0003\u0005\u000b\u0015BAv\u0011\u00191W\u0001\"\u0001\u0003\u0002!I!QD\u0003A\u0002\u0013\u0005!q\u0004\u0005\n\u0005O)\u0001\u0019!C\u0001\u0005SA\u0001B!\f\u0006A\u0003&!\u0011\u0005\u0005\n\u0005c)\u0001\u0019!C\u0001\u0005gA\u0011B!\u000e\u0006\u0001\u0004%\tAa\u000e\t\u000f\tmR\u0001)Q\u0005W\"Q!QH\u0003C\u0002\u0013\u0005aKa\u0010\t\u0011\teS\u0001)A\u0005\u0005\u0003BqAa\u0017\u0006\t\u0003\u0011i\u0006C\u0004\u0003\u0002\u0016!\tAa!\t\u000f\t=U\u0001\"\u0001\u0003\u0012\"9!qS\u0003\u0005\u0002\te\u0005b\u0002BQ\u000b\u0011\u0005!\u0011\u0014\u0005\b\u0005G+A\u0011\u0001BS\u0011\u001d\u0011\u0019.\u0002C\u0001\u0005+DqAa9\u0006\t\u0003\u0011)\u000fC\u0004\u0003z\u0016!\tAa?\t\u000f\r-Q\u0001\"\u0001\u0004\u000e!91\u0011C\u0003\u0005\u0002\te\u0005bBB\n\u000b\u0011\u0005!1\u0007\u0005\b\u0007+)A\u0011\u0001B\u001a\u0011\u001d\u00199\"\u0002C\u0001\u0005gAqa!\u0007\u0006\t\u0013\u0011\u0019\u0004C\u0004\u0004\u001c\u0015!\ta!\b\t\u0011\rMR!%A\u0005\u0002QD\u0001b!\u000e\u0006#\u0003%\t\u0001\u001e\u0005\n\u0007o)\u0011\u0013!C\u0001\u0007sA\u0011b!\u0010\u0006#\u0003%\ta!\u000f\t\u0013\r}R!%A\u0005\u0002\r\u0005\u0003\"CB#\u000bE\u0005I\u0011AB$\u0011!\u0019Y%BI\u0001\n\u0003!\b\u0002CB'\u000bE\u0005I\u0011\u0001;\t\u0013\r=S!%A\u0005\u0002\rE\u0003bBB+\u000b\u0011\u00051q\u000b\u0005\b\u0007;*A\u0011BB0\u0011\u001d\u0019\u0019'\u0002C\u0005\u0007KBqa!\u001b\u0006\t\u0013\u0019Y\u0007C\u0004\u0004r\u0015!\tAa\r\t\u000f\rMT\u0001\"\u0003\u00034!91QO\u0003\u0005\u0002\r]\u0004bBB;\u000b\u0011\u000531\u0011\u0005\b\u0007\u000b+A\u0011IBD\u0011\u001d\u0019i)\u0002C!\u0007\u001f\u000b1\u0003\u0016:b]N\f7\r^5p]6+G/\u00193bi\u0006T!a\u0016-\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u00033j\u000b1bY8pe\u0012Lg.\u0019;pe*\t1,A\u0003lC\u001a\\\u0017\r\u0005\u0002^\u00035\taKA\nUe\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018m\u0005\u0002\u0002AB\u0011\u0011\rZ\u0007\u0002E*\t1-A\u0003tG\u0006d\u0017-\u0003\u0002fE\n1\u0011I\\=SK\u001a\fa\u0001P5oSRt4\u0001\u0001\u000b\u00029\u0006\u0001\u0012n]#q_\u000eDW\t\u001f5bkN$X\r\u001a\u000b\u0003W:\u0004\"!\u00197\n\u00055\u0014'a\u0002\"p_2,\u0017M\u001c\u0005\u0006_\u000e\u0001\r\u0001]\u0001\u000eaJ|G-^2fe\u0016\u0003xn\u00195\u0011\u0005\u0005\f\u0018B\u0001:c\u0005\u0015\u0019\u0006n\u001c:u\u0003q!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cA*\u0012!\u001e\u0016\u0003mf\u0004\"!Y<\n\u0005a\u0014'\u0001\u0002'p]\u001e\\\u0013A\u001f\t\u0004w\u0006\u0005Q\"\u0001?\u000b\u0005ut\u0018!C;oG\",7m[3e\u0015\ty(-\u0001\u0006b]:|G/\u0019;j_:L1!a\u0001}\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\n\u0005\u000b\u0001\f9\u0001\u0005\u0003\u0002\n\u0005=QBAA\u0006\u0015\r\tiAW\u0001\u0006kRLGn]\u0005\u0005\u0003#\tYAA\u0004M_\u001e<\u0017N\\4\u0002\u001fQ\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012,\"!a\u0006\u0011\t\u0005e\u0011q\u0005\b\u0005\u00037\t\u0019\u0003E\u0002\u0002\u001e\tl!!a\b\u000b\u0007\u0005\u0005r-\u0001\u0004=e>|GOP\u0005\u0004\u0003K\u0011\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002*\u0005-\"AB*ue&twMC\u0002\u0002&\t\f\u0001\u0003\u001e:b]N\f7\r^5p]\u0006d\u0017\n\u001a\u0011\u0002\u0015A\u0014x\u000eZ;dKJLE-F\u0001w\u00039\u0001(o\u001c3vG\u0016\u0014\u0018\nZ0%KF$B!a\u000e\u0002>A\u0019\u0011-!\u000f\n\u0007\u0005m\"M\u0001\u0003V]&$\b\u0002CA \u0013\u0005\u0005\t\u0019\u0001<\u0002\u0007a$\u0013'A\u0006qe>$WoY3s\u0013\u0012\u0004\u0013A\u00049sKZ\u0004&o\u001c3vG\u0016\u0014\u0018\nZ\u0001\u0013aJ,g\u000f\u0015:pIV\u001cWM]%e?\u0012*\u0017\u000f\u0006\u0003\u00028\u0005%\u0003\u0002CA \u0019\u0005\u0005\t\u0019\u0001<\u0002\u001fA\u0014XM\u001e)s_\u0012,8-\u001a:JI\u0002\naB\\3yiB\u0013x\u000eZ;dKJLE-\u0001\noKb$\bK]8ek\u000e,'/\u00133`I\u0015\fH\u0003BA\u001c\u0003'B\u0001\"a\u0010\u0010\u0003\u0003\u0005\rA^\u0001\u0010]\u0016DH\u000f\u0015:pIV\u001cWM]%eAU\t\u0001/A\tqe>$WoY3s\u000bB|7\r[0%KF$B!a\u000e\u0002^!A\u0011q\b\n\u0002\u0002\u0003\u0007\u0001/\u0001\bqe>$WoY3s\u000bB|7\r\u001b\u0011\u0002#1\f7\u000f\u001e)s_\u0012,8-\u001a:Fa>\u001c\u0007.A\u000bmCN$\bK]8ek\u000e,'/\u00129pG\"|F%Z9\u0015\t\u0005]\u0012q\r\u0005\t\u0003\u007f)\u0012\u0011!a\u0001a\u0006\u0011B.Y:u!J|G-^2fe\u0016\u0003xn\u00195!\u00031!\bP\u001c+j[\u0016|W\u000f^'t+\t\ty\u0007E\u0002b\u0003cJ1!a\u001dc\u0005\rIe\u000e^\u0001\u0011ibtG+[7f_V$Xj]0%KF$B!a\u000e\u0002z!I\u0011q\b\r\u0002\u0002\u0003\u0007\u0011qN\u0001\u000eibtG+[7f_V$Xj\u001d\u0011\u0002\u000bM$\u0018\r^3\u0016\u0005\u0005\u0005\u0005\u0003BAB\u0003'k!!!\"\u000b\u0007]\u000b9IC\u0002Z\u0003\u0013S1aWAF\u0015\u0011\ti)a$\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t\t*A\u0002pe\u001eLA!!&\u0002\u0006\n\u0001BK]1og\u0006\u001cG/[8o'R\fG/Z\u0001\ngR\fG/Z0%KF$B!a\u000e\u0002\u001c\"I\u0011qH\u000e\u0002\u0002\u0003\u0007\u0011\u0011Q\u0001\u0007gR\fG/\u001a\u0011)\u0007q\t\t\u000bE\u0002b\u0003GK1!!*c\u0005!1x\u000e\\1uS2,\u0017a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0016\u0005\u0005-\u0006CBAW\u0003o\u000bY,\u0004\u0002\u00020*!\u0011\u0011WAZ\u0003\u001diW\u000f^1cY\u0016T1!!.c\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003s\u000byKA\u0002TKR\u0004B!!0\u0002D6\u0011\u0011q\u0018\u0006\u0005\u0003\u0003\fI)\u0001\u0004d_6lwN\\\u0005\u0005\u0003\u000b\fyL\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002'Q|\u0007/[2QCJ$\u0018\u000e^5p]N|F%Z9\u0015\t\u0005]\u00121\u001a\u0005\n\u0003\u007fq\u0012\u0011!a\u0001\u0003W\u000b\u0001\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002#QDhn\u0015;beR$\u0016.\\3ti\u0006l\u0007/A\u000buq:\u001cF/\u0019:u)&lWm\u001d;b[B|F%Z9\u0015\t\u0005]\u0012Q\u001b\u0005\t\u0003\u007f\t\u0013\u0011!a\u0001m\u0006\u0011B\u000f\u001f8Ti\u0006\u0014H\u000fV5nKN$\u0018-\u001c9!Q\r\u0011\u0013\u0011U\u0001\u0017ibtG*Y:u+B$\u0017\r^3US6,7\u000f^1na\u0006QB\u000f\u001f8MCN$X\u000b\u001d3bi\u0016$\u0016.\\3ti\u0006l\u0007o\u0018\u0013fcR!\u0011qGAq\u0011!\ty\u0004JA\u0001\u0002\u00041\u0018a\u0006;y]2\u000b7\u000f^+qI\u0006$X\rV5nKN$\u0018-\u001c9!Q\r)\u0013\u0011U\u0001\u0019G2LWM\u001c;Ue\u0006t7/Y2uS>tg+\u001a:tS>tWCAAv!\u0011\ti/!>\u000e\u0005\u0005=(\u0002BAa\u0003cTA!a=\u0002\n\u000611/\u001a:wKJLA!a>\u0002p\n\u0011BK]1og\u0006\u001cG/[8o-\u0016\u00148/[8o\u0003q\u0019G.[3oiR\u0013\u0018M\\:bGRLwN\u001c,feNLwN\\0%KF$B!a\u000e\u0002~\"I\u0011qH\u0014\u0002\u0002\u0003\u0007\u00111^\u0001\u001aG2LWM\u001c;Ue\u0006t7/Y2uS>tg+\u001a:tS>t\u0007\u0005\u0006\u000e\u0003\u0004\t\u0015!q\u0001B\u0005\u0005\u0017\u0011iAa\u0004\u0003\u0012\tM!Q\u0003B\f\u00053\u0011Y\u0002\u0005\u0002^\u000b!9\u00111C\u0015A\u0002\u0005]\u0001BBA\u0018S\u0001\u0007a\u000f\u0003\u0004\u0002D%\u0002\rA\u001e\u0005\u0007\u0003\u001bJ\u0003\u0019\u0001<\t\u000b=L\u0003\u0019\u00019\t\r\u0005\u0005\u0014\u00061\u0001q\u0011\u001d\tY'\u000ba\u0001\u0003_Bq!! *\u0001\u0004\t\t\tC\u0004\u0002(&\u0002\r!a+\t\u0011\u0005=\u0017\u0006%AA\u0002YDa!a7*\u0001\u00041\bbBAtS\u0001\u0007\u00111^\u0001\ra\u0016tG-\u001b8h'R\fG/Z\u000b\u0003\u0005C\u0001R!\u0019B\u0012\u0003\u0003K1A!\nc\u0005\u0019y\u0005\u000f^5p]\u0006\u0001\u0002/\u001a8eS:<7\u000b^1uK~#S-\u001d\u000b\u0005\u0003o\u0011Y\u0003C\u0005\u0002@-\n\t\u00111\u0001\u0003\"\u0005i\u0001/\u001a8eS:<7\u000b^1uK\u0002B3\u0001LAQ\u0003MA\u0017m\u001d$bS2,G-\u00129pG\"4UM\\2f+\u0005Y\u0017a\u00065bg\u001a\u000b\u0017\u000e\\3e\u000bB|7\r\u001b$f]\u000e,w\fJ3r)\u0011\t9D!\u000f\t\u0011\u0005}b&!AA\u0002-\fA\u0003[1t\r\u0006LG.\u001a3Fa>\u001c\u0007NR3oG\u0016\u0004\u0013\u0001\u00027pG.,\"A!\u0011\u0011\t\t\r#QK\u0007\u0003\u0005\u000bRAAa\u0012\u0003J\u0005)An\\2lg*!!1\nB'\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0005\u001f\u0012\t&\u0001\u0003vi&d'B\u0001B*\u0003\u0011Q\u0017M^1\n\t\t]#Q\t\u0002\u000e%\u0016,g\u000e\u001e:b]RdunY6\u0002\u000b1|7m\u001b\u0011\u0002\r%tGj\\2l+\u0011\u0011yF!\u001a\u0015\t\t\u0005$q\u000f\t\u0005\u0005G\u0012)\u0007\u0004\u0001\u0005\u000f\t\u001d$G1\u0001\u0003j\t\tA+\u0005\u0003\u0003l\tE\u0004cA1\u0003n%\u0019!q\u000e2\u0003\u000f9{G\u000f[5oOB\u0019\u0011Ma\u001d\n\u0007\tU$MA\u0002B]fD\u0001B!\u001f3\t\u0003\u0007!1P\u0001\u0004MVt\u0007#B1\u0003~\t\u0005\u0014b\u0001B@E\nAAHY=oC6,g(A\u0007bI\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u0003o\u0011)\tC\u0004\u0003\bN\u0002\rA!#\u0002\u0015A\f'\u000f^5uS>t7\u000f\u0005\u0004\u0003\f\n5\u00151X\u0007\u0003\u0003gKA!!/\u00024\u0006y!/Z7pm\u0016\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0003\u00028\tM\u0005b\u0002BKi\u0001\u0007\u00111X\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0003A\u0001(/\u001a9be\u0016tu\u000e\u0016:b]NLG\u000f\u0006\u0002\u0003\u001cB!\u00111\u0011BO\u0013\u0011\u0011y*!\"\u0003%QCh\u000e\u0016:b]NLG/T3uC\u0012\fG/Y\u0001\u001aaJ,\u0007/\u0019:f\r\u0016t7-\u001a)s_\u0012,8-\u001a:Fa>\u001c\u0007.A\u000fqe\u0016\u0004\u0018M]3J]\u000e\u0014X-\\3oiB\u0013x\u000eZ;dKJ,\u0005o\\2i)!\u00119K!2\u0003J\n=\u0007\u0003\u0003BU\u0005g\u0013ILa'\u000f\t\t-&q\u0016\b\u0005\u0003;\u0011i+C\u0001d\u0013\r\u0011\tLY\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011)La.\u0003\r\u0015KG\u000f[3s\u0015\r\u0011\tL\u0019\t\u0005\u0005w\u0013\t-\u0004\u0002\u0003>*!!qXA`\u0003!\u0001(o\u001c;pG>d\u0017\u0002\u0002Bb\u0005{\u0013a!\u0012:s_J\u001c\bb\u0002Bdo\u0001\u0007\u0011qN\u0001\u0010]\u0016<H\u000b\u001f8US6,w.\u001e;Ng\"9!1Z\u001cA\u0002\t5\u0017!F3ya\u0016\u001cG/\u001a3Qe>$WoY3s\u000bB|7\r\u001b\t\u0005C\n\r\u0002\u000f\u0003\u0004\u0003R^\u0002\rA^\u0001\u0010kB$\u0017\r^3US6,7\u000f^1na\u0006I\u0002O]3qCJ,\u0007K]8ek\u000e,'/\u00133S_R\fG/[8o))\u0011YJa6\u0003\\\nu'q\u001c\u0005\u0007\u00053D\u0004\u0019\u0001<\u0002\u001b9,w\u000f\u0015:pIV\u001cWM]%e\u0011\u001d\u00119\r\u000fa\u0001\u0003_BaA!59\u0001\u00041\bB\u0002Bqq\u0001\u00071.A\bsK\u000e|'\u000f\u001a'bgR,\u0005o\\2i\u0003Q\u0001(/\u001a9be\u0016\fE\r\u001a)beRLG/[8ogRA!1\u0014Bt\u0005k\u00149\u0010C\u0004\u0003jf\u0002\rAa;\u0002)\u0005$G-\u001a3U_BL7\rU1si&$\u0018n\u001c8t!\u0019\u0011iOa=\u0002<6\u0011!q\u001e\u0006\u0005\u0005c\f\u0019,A\u0005j[6,H/\u00192mK&!\u0011\u0011\u0018Bx\u0011\u0019\u0011\t.\u000fa\u0001m\"9\u0011q]\u001dA\u0002\u0005-\u0018\u0001\u00069sKB\f'/Z!c_J$xJ]\"p[6LG\u000f\u0006\u0007\u0003\u001c\nu8\u0011AB\u0002\u0007\u000b\u00199\u0001C\u0004\u0003\u0000j\u0002\r!!!\u0002\u00119,wo\u0015;bi\u0016Dq!a:;\u0001\u0004\tY\u000f\u0003\u0004\u0002Ni\u0002\rA\u001e\u0005\u0007\u0005#T\u0004\u0019\u0001<\t\r\r%!\b1\u0001l\u0003Aqw\u000eU1si&$\u0018n\u001c8BI\u0012,G-A\bqe\u0016\u0004\u0018M]3D_6\u0004H.\u001a;f)\u0011\u0011Yja\u0004\t\r\tE7\b1\u0001w\u0003-\u0001(/\u001a9be\u0016$U-\u00193\u00021%\u001c\bK]8ek\u000e,'/\u00129pG\",\u0005\u0010[1vgR,G-A\u0014jg\u0012K7\u000f\u001e:jEV$X\r\u001a+x_BC\u0017m]3D_6l\u0017\u000e\u001e+y]\u000e3G\u000e\u001e$mS:\\\u0017AH5t\t&\u001cHO]5ckR,G\rV<p!\"\f7/Z\"p[6LG\u000f\u0016=o\u0003UA\u0017m\u001d)f]\u0012Lgn\u001a+sC:\u001c\u0018m\u0019;j_:\f1\u0003\u001d:fa\u0006\u0014X\r\u0016:b]NLG/[8o)>$bCa'\u0004 \r\u000521EB\u0013\u0007O\u0019Ica\u000b\u0004.\r=2\u0011\u0007\u0005\b\u0003{\n\u0005\u0019AAA\u0011!\ty#\u0011I\u0001\u0002\u00041\b\u0002CA'\u0003B\u0005\t\u0019\u0001<\t\u000f=\f\u0005\u0013!a\u0001a\"A\u0011\u0011M!\u0011\u0002\u0003\u0007\u0001\u000fC\u0005\u0002l\u0005\u0003\n\u00111\u0001\u0002p!I\u0011qU!\u0011\u0002\u0003\u0007\u00111\u0016\u0005\t\u0003\u001f\f\u0005\u0013!a\u0001m\"A\u00111\\!\u0011\u0002\u0003\u0007a\u000fC\u0005\u0002h\u0006\u0003\n\u00111\u0001\u0002l\u0006i\u0002O]3qCJ,GK]1og&$\u0018n\u001c8U_\u0012\"WMZ1vYR$#'A\u000fqe\u0016\u0004\u0018M]3Ue\u0006t7/\u001b;j_:$v\u000e\n3fM\u0006,H\u000e\u001e\u00134\u0003u\u0001(/\u001a9be\u0016$&/\u00198tSRLwN\u001c+pI\u0011,g-Y;mi\u0012\"TCAB\u001eU\t\u0001\u00180A\u000fqe\u0016\u0004\u0018M]3Ue\u0006t7/\u001b;j_:$v\u000e\n3fM\u0006,H\u000e\u001e\u00136\u0003u\u0001(/\u001a9be\u0016$&/\u00198tSRLwN\u001c+pI\u0011,g-Y;mi\u00122TCAB\"U\r\ty'_\u0001\u001eaJ,\u0007/\u0019:f)J\fgn]5uS>tGk\u001c\u0013eK\u001a\fW\u000f\u001c;%oU\u00111\u0011\n\u0016\u0004\u0003WK\u0018!\b9sKB\f'/\u001a+sC:\u001c\u0018\u000e^5p]R{G\u0005Z3gCVdG\u000f\n\u001d\u0002;A\u0014X\r]1sKR\u0013\u0018M\\:ji&|g\u000eV8%I\u00164\u0017-\u001e7uIe\na\u0004\u001d:fa\u0006\u0014X\r\u0016:b]NLG/[8o)>$C-\u001a4bk2$H%\r\u0019\u0016\u0005\rM#fAAvs\u0006!2m\\7qY\u0016$X\r\u0016:b]NLG/[8o)>$B!a\u000e\u0004Z!911L&A\u0002\tm\u0015a\u0004;sC:\u001c\u0018\u000e^'fi\u0006$\u0017\r^1\u0002%Y\fG.\u001b3Qe>$WoY3s\u000bB|7\r\u001b\u000b\u0004W\u000e\u0005\u0004bBB.\u0019\u0002\u0007!1T\u0001\u0017m\u0006d\u0017\u000e\u001a)s_\u0012,8-\u001a:Fa>\u001c\u0007NQ;naR\u00191na\u001a\t\u000f\rmS\n1\u0001\u0003\u001c\u0006YB\u000f\u001b:poN#\u0018\r^3Ue\u0006t7/\u001b;j_:4\u0015-\u001b7ve\u0016$B!a\u000e\u0004n!91q\u000e(A\u0002\tm\u0015A\u0005;y]R\u0013\u0018M\\:ji6+G/\u00193bi\u0006\f1\u0004]3oI&tw\r\u0016:b]NLG/[8o\u0013:\u0004&o\\4sKN\u001c\u0018aD5oG2,H-Z:PM\u001a\u001cX\r^:\u0002\u0011Q|7\u000b\u001e:j]\u001e$B!a\u0006\u0004z!911P)A\u0002\ru\u0014!\u0003<fe\n|7/\u001b;z!\ri6qP\u0005\u0004\u0007\u00033&a\u0007+sC:\u001c\u0018m\u0019;j_:dunZ4j]\u001e4VM\u001d2pg&$\u0018\u0010\u0006\u0002\u0002\u0018\u00051Q-];bYN$2a[BE\u0011\u001d\u0019Yi\u0015a\u0001\u0005c\nA\u0001\u001e5bi\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002p!\u001aQaa%\u0011\t\u0005%1QS\u0005\u0005\u0007/\u000bYAA\u0007o_:$\bN]3bIN\fg-\u001a")
public class TransactionMetadata
implements Logging {
    private final String transactionalId;
    private long producerId;
    private long prevProducerId;
    private long nextProducerId;
    private short producerEpoch;
    private short lastProducerEpoch;
    private int txnTimeoutMs;
    private volatile TransactionState state;
    private scala.collection.mutable.Set<TopicPartition> topicPartitions;
    private volatile long txnStartTimestamp;
    private volatile long txnLastUpdateTimestamp;
    private TransactionVersion clientTransactionVersion;
    private volatile Option<TransactionState> pendingState;
    private boolean hasFailedEpochFence;
    private final ReentrantLock lock;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static long $lessinit$greater$default$10() {
        return TransactionMetadata$.MODULE$.$lessinit$greater$default$10();
    }

    public static boolean isEpochExhausted(short producerEpoch) {
        return TransactionMetadata$.MODULE$.isEpochExhausted(producerEpoch);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TransactionMetadata transactionMetadata = this;
        synchronized (transactionMetadata) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public long producerId() {
        return this.producerId;
    }

    public void producerId_$eq(long x$1) {
        this.producerId = x$1;
    }

    public long prevProducerId() {
        return this.prevProducerId;
    }

    public void prevProducerId_$eq(long x$1) {
        this.prevProducerId = x$1;
    }

    public long nextProducerId() {
        return this.nextProducerId;
    }

    public void nextProducerId_$eq(long x$1) {
        this.nextProducerId = x$1;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public void producerEpoch_$eq(short x$1) {
        this.producerEpoch = x$1;
    }

    public short lastProducerEpoch() {
        return this.lastProducerEpoch;
    }

    public void lastProducerEpoch_$eq(short x$1) {
        this.lastProducerEpoch = x$1;
    }

    public int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    public void txnTimeoutMs_$eq(int x$1) {
        this.txnTimeoutMs = x$1;
    }

    public TransactionState state() {
        return this.state;
    }

    public void state_$eq(TransactionState x$1) {
        this.state = x$1;
    }

    public scala.collection.mutable.Set<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    public void topicPartitions_$eq(scala.collection.mutable.Set<TopicPartition> x$1) {
        this.topicPartitions = x$1;
    }

    public long txnStartTimestamp() {
        return this.txnStartTimestamp;
    }

    public void txnStartTimestamp_$eq(long x$1) {
        this.txnStartTimestamp = x$1;
    }

    public long txnLastUpdateTimestamp() {
        return this.txnLastUpdateTimestamp;
    }

    public void txnLastUpdateTimestamp_$eq(long x$1) {
        this.txnLastUpdateTimestamp = x$1;
    }

    public TransactionVersion clientTransactionVersion() {
        return this.clientTransactionVersion;
    }

    public void clientTransactionVersion_$eq(TransactionVersion x$1) {
        this.clientTransactionVersion = x$1;
    }

    public Option<TransactionState> pendingState() {
        return this.pendingState;
    }

    public void pendingState_$eq(Option<TransactionState> x$1) {
        this.pendingState = x$1;
    }

    public boolean hasFailedEpochFence() {
        return this.hasFailedEpochFence;
    }

    public void hasFailedEpochFence_$eq(boolean x$1) {
        this.hasFailedEpochFence = x$1;
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    public <T> T inLock(Function0<T> fun) {
        return CoreUtils$.MODULE$.inLock(this.lock(), fun);
    }

    public void addPartitions(Set<TopicPartition> partitions) {
        this.topicPartitions().$plus$plus$eq(partitions);
    }

    public void removePartition(TopicPartition topicPartition) {
        TransactionState transactionState = this.state();
        TransactionState transactionState2 = TransactionState.PREPARE_COMMIT;
        if (transactionState == null ? transactionState2 != null : !((Object)((Object)transactionState)).equals((Object)transactionState2)) {
            TransactionState transactionState3 = this.state();
            TransactionState transactionState4 = TransactionState.PREPARE_ABORT;
            if (transactionState3 == null ? transactionState4 != null : !((Object)((Object)transactionState3)).equals((Object)transactionState4)) {
                throw new IllegalStateException("Transaction metadata's current state is " + this.state() + ", and its pending state is " + this.pendingState() + " while trying to remove partitions whose txn marker has been sent, this is not expected");
            }
        }
        this.topicPartitions().$minus$eq(topicPartition);
    }

    public TxnTransitMetadata prepareNoTransit() {
        return new TxnTransitMetadata(this.producerId(), this.prevProducerId(), this.nextProducerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), this.state(), CollectionConverters$.MODULE$.MutableSetHasAsJava((scala.collection.mutable.Set)this.topicPartitions().clone()).asJava(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp(), this.clientTransactionVersion());
    }

    public TxnTransitMetadata prepareFenceProducerEpoch() {
        if (this.producerEpoch() == Short.MAX_VALUE) {
            throw new IllegalStateException("Cannot fence producer with epoch equal to Short.MaxValue since this would overflow");
        }
        short bumpedEpoch = this.hasFailedEpochFence() ? this.producerEpoch() : (short)(this.producerEpoch() + 1);
        TransactionState x$1 = TransactionState.PREPARE_EPOCH_FENCE;
        short x$2 = bumpedEpoch;
        int x$3 = -1;
        long x$4 = this.prepareTransitionTo$default$2();
        long x$5 = this.prepareTransitionTo$default$3();
        int x$6 = this.prepareTransitionTo$default$6();
        scala.collection.mutable.Set<TopicPartition> x$7 = this.prepareTransitionTo$default$7();
        long x$8 = this.prepareTransitionTo$default$8();
        long x$9 = this.prepareTransitionTo$default$9();
        TransactionVersion x$10 = this.prepareTransitionTo$default$10();
        return this.prepareTransitionTo(TransactionState.PREPARE_EPOCH_FENCE, x$4, x$5, x$2, (short)-1, x$6, x$7, x$8, x$9, x$10);
    }

    public Either<Errors, TxnTransitMetadata> prepareIncrementProducerEpoch(int newTxnTimeoutMs, Option<Object> expectedProducerEpoch, long updateTimestamp) {
        Right right;
        Tuple2 tuple2;
        Right epochBumpResult;
        Either either;
        if (this.isProducerEpochExhausted()) {
            throw new IllegalStateException("Cannot allocate any more producer epochs for producerId " + this.producerId());
        }
        short bumpedEpoch = (short)(this.producerEpoch() + 1);
        Option<Object> option = expectedProducerEpoch;
        if (None$.MODULE$.equals(option)) {
            either = new Right(new Tuple2<Short, Short>(BoxesRunTime.boxToShort(bumpedEpoch), BoxesRunTime.boxToShort((short)-1)));
        } else if (option instanceof Some) {
            Some some = (Some)option;
            short expectedEpoch = BoxesRunTime.unboxToShort(some.value());
            if (this.producerEpoch() == -1 || expectedEpoch == this.producerEpoch()) {
                either = new Right(new Tuple2<Short, Short>(BoxesRunTime.boxToShort(bumpedEpoch), BoxesRunTime.boxToShort(this.producerEpoch())));
            } else if (expectedEpoch == this.lastProducerEpoch()) {
                either = new Right(new Tuple2<Short, Short>(BoxesRunTime.boxToShort(this.producerEpoch()), BoxesRunTime.boxToShort(this.lastProducerEpoch())));
            } else {
                this.info((Function0<String> & Serializable)() -> "Expected producer epoch " + expectedEpoch + " does not match current producer epoch " + this.producerEpoch() + " or previous producer epoch " + this.lastProducerEpoch());
                either = new Left(Errors.PRODUCER_FENCED);
            }
        } else {
            throw new MatchError(option);
        }
        Right right2 = epochBumpResult = either;
        if (right2 instanceof Right && (tuple2 = (Tuple2)(right = right2).value()) != null) {
            short nextEpoch = BoxesRunTime.unboxToShort(tuple2._1());
            short lastEpoch = BoxesRunTime.unboxToShort(tuple2._2());
            TransactionState x$1 = TransactionState.EMPTY;
            short x$2 = nextEpoch;
            short x$3 = lastEpoch;
            int x$4 = newTxnTimeoutMs;
            scala.collection.mutable.Set x$5 = (scala.collection.mutable.Set)Set$.MODULE$.empty();
            long x$6 = -1L;
            long x$7 = updateTimestamp;
            long x$8 = this.prepareTransitionTo$default$2();
            long x$9 = this.prepareTransitionTo$default$3();
            TransactionVersion x$10 = this.prepareTransitionTo$default$10();
            return new Right<Errors, TxnTransitMetadata>(this.prepareTransitionTo(TransactionState.EMPTY, x$8, x$9, x$2, x$3, x$4, x$5, -1L, x$7, x$10));
        }
        if (right2 instanceof Left) {
            Left left = (Left)((Object)right2);
            Errors err = (Errors)left.value();
            return new Left<Errors, TxnTransitMetadata>(err);
        }
        throw new MatchError(right2);
    }

    public TxnTransitMetadata prepareProducerIdRotation(long newProducerId, int newTxnTimeoutMs, long updateTimestamp, boolean recordLastEpoch) {
        if (this.hasPendingTransaction()) {
            throw new IllegalStateException("Cannot rotate producer ids while a transaction is still pending");
        }
        TransactionState x$1 = TransactionState.EMPTY;
        long x$2 = newProducerId;
        boolean x$3 = false;
        short x$4 = recordLastEpoch ? (short)this.producerEpoch() : (short)-1;
        int x$5 = newTxnTimeoutMs;
        scala.collection.mutable.Set x$6 = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        long x$7 = -1L;
        long x$8 = updateTimestamp;
        long x$9 = this.prepareTransitionTo$default$3();
        TransactionVersion x$10 = this.prepareTransitionTo$default$10();
        return this.prepareTransitionTo(TransactionState.EMPTY, x$2, x$9, (short)0, x$4, x$5, x$6, -1L, x$8, x$10);
    }

    public TxnTransitMetadata prepareAddPartitions(scala.collection.immutable.Set<TopicPartition> addedTopicPartitions, long updateTimestamp, TransactionVersion clientTransactionVersion) {
        TransactionState transactionState = this.state();
        long newTxnStartTimestamp = (((Object)((Object)TransactionState.EMPTY)).equals((Object)transactionState) ? true : (((Object)((Object)TransactionState.COMPLETE_ABORT)).equals((Object)transactionState) ? true : ((Object)((Object)TransactionState.COMPLETE_COMMIT)).equals((Object)transactionState))) ? updateTimestamp : this.txnStartTimestamp();
        TransactionState x$1 = TransactionState.ONGOING;
        scala.collection.mutable.Set x$2 = (scala.collection.mutable.Set)this.topicPartitions().$plus$plus(addedTopicPartitions);
        long x$3 = newTxnStartTimestamp;
        long x$4 = updateTimestamp;
        TransactionVersion x$5 = clientTransactionVersion;
        long x$6 = this.prepareTransitionTo$default$2();
        long x$7 = this.prepareTransitionTo$default$3();
        short x$8 = this.prepareTransitionTo$default$4();
        short x$9 = this.prepareTransitionTo$default$5();
        int x$10 = this.prepareTransitionTo$default$6();
        return this.prepareTransitionTo(TransactionState.ONGOING, x$6, x$7, x$8, x$9, x$10, x$2, x$3, x$4, x$5);
    }

    public TxnTransitMetadata prepareAbortOrCommit(TransactionState newState, TransactionVersion clientTransactionVersion, long nextProducerId, long updateTimestamp, boolean noPartitionAdded) {
        Tuple2<Short, Short> tuple2;
        Tuple2<Short, Short> tuple22 = tuple2 = clientTransactionVersion.supportsEpochBump() ? new Tuple2<Short, Short>(BoxesRunTime.boxToShort((short)(this.producerEpoch() + 1)), BoxesRunTime.boxToShort(this.producerEpoch())) : new Tuple2<Short, Short>(BoxesRunTime.boxToShort(this.producerEpoch()), BoxesRunTime.boxToShort(this.lastProducerEpoch()));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        short updatedProducerEpoch = BoxesRunTime.unboxToShort(tuple2._1());
        short updatedLastProducerEpoch = BoxesRunTime.unboxToShort(tuple2._2());
        Tuple2<Short, Short> tuple23 = new Tuple2<Short, Short>(BoxesRunTime.boxToShort(updatedProducerEpoch), BoxesRunTime.boxToShort(updatedLastProducerEpoch));
        short updatedProducerEpoch2 = BoxesRunTime.unboxToShort(tuple23._1());
        short updatedLastProducerEpoch2 = BoxesRunTime.unboxToShort(tuple23._2());
        long newTxnStartTimestamp = noPartitionAdded ? updateTimestamp : this.txnStartTimestamp();
        TransactionState x$1 = newState;
        long x$2 = nextProducerId;
        short x$3 = updatedProducerEpoch2;
        short x$4 = updatedLastProducerEpoch2;
        long x$5 = newTxnStartTimestamp;
        long x$6 = updateTimestamp;
        TransactionVersion x$7 = clientTransactionVersion;
        long x$8 = this.prepareTransitionTo$default$2();
        int x$9 = this.prepareTransitionTo$default$6();
        scala.collection.mutable.Set<TopicPartition> x$10 = this.prepareTransitionTo$default$7();
        return this.prepareTransitionTo(x$1, x$8, x$2, x$3, x$4, x$9, x$10, x$5, x$6, x$7);
    }

    public TxnTransitMetadata prepareComplete(long updateTimestamp) {
        Tuple2<Long, Short> tuple2;
        TransactionState transactionState = this.state();
        TransactionState transactionState2 = TransactionState.PREPARE_COMMIT;
        TransactionState newState = !(transactionState != null ? !((Object)((Object)transactionState)).equals((Object)transactionState2) : transactionState2 != null) ? TransactionState.COMPLETE_COMMIT : TransactionState.COMPLETE_ABORT;
        this.hasFailedEpochFence_$eq(false);
        Tuple2<Long, Short> tuple22 = tuple2 = this.clientTransactionVersion().supportsEpochBump() && this.nextProducerId() != -1L ? new Tuple2<Long, Short>(BoxesRunTime.boxToLong(this.nextProducerId()), BoxesRunTime.boxToShort((short)0)) : new Tuple2<Long, Short>(BoxesRunTime.boxToLong(this.producerId()), BoxesRunTime.boxToShort(this.producerEpoch()));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long updatedProducerId = tuple2._1$mcJ$sp();
        short updatedProducerEpoch = BoxesRunTime.unboxToShort(tuple2._2());
        Tuple2<Long, Short> tuple23 = new Tuple2<Long, Short>(BoxesRunTime.boxToLong(updatedProducerId), BoxesRunTime.boxToShort(updatedProducerEpoch));
        long updatedProducerId2 = tuple23._1$mcJ$sp();
        short updatedProducerEpoch2 = BoxesRunTime.unboxToShort(tuple23._2());
        TransactionState x$1 = newState;
        long x$2 = updatedProducerId2;
        long x$3 = -1L;
        short x$4 = updatedProducerEpoch2;
        scala.collection.mutable.Set x$5 = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        long x$6 = updateTimestamp;
        short x$7 = this.prepareTransitionTo$default$5();
        int x$8 = this.prepareTransitionTo$default$6();
        long x$9 = this.prepareTransitionTo$default$8();
        TransactionVersion x$10 = this.prepareTransitionTo$default$10();
        return this.prepareTransitionTo(x$1, x$2, -1L, x$4, x$7, x$8, x$5, x$9, x$6, x$10);
    }

    public TxnTransitMetadata prepareDead() {
        TransactionState x$1 = TransactionState.DEAD;
        scala.collection.mutable.Set x$2 = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        long x$3 = this.prepareTransitionTo$default$2();
        long x$4 = this.prepareTransitionTo$default$3();
        short x$5 = this.prepareTransitionTo$default$4();
        short x$6 = this.prepareTransitionTo$default$5();
        int x$7 = this.prepareTransitionTo$default$6();
        long x$8 = this.prepareTransitionTo$default$8();
        long x$9 = this.prepareTransitionTo$default$9();
        TransactionVersion x$10 = this.prepareTransitionTo$default$10();
        return this.prepareTransitionTo(TransactionState.DEAD, x$3, x$4, x$5, x$6, x$7, x$2, x$8, x$9, x$10);
    }

    public boolean isProducerEpochExhausted() {
        return TransactionMetadata$.MODULE$.isEpochExhausted(this.producerEpoch());
    }

    public boolean isDistributedTwoPhaseCommitTxnCfltFlink() {
        return this.txnTimeoutMs() == 0x7FFFFFFE;
    }

    public boolean isDistributedTwoPhaseCommitTxn() {
        return this.txnTimeoutMs() >= 0x7FFFFFFE;
    }

    private boolean hasPendingTransaction() {
        TransactionState transactionState = this.state();
        return ((Object)((Object)TransactionState.ONGOING)).equals((Object)transactionState) ? true : (((Object)((Object)TransactionState.PREPARE_ABORT)).equals((Object)transactionState) ? true : ((Object)((Object)TransactionState.PREPARE_COMMIT)).equals((Object)transactionState));
    }

    public TxnTransitMetadata prepareTransitionTo(TransactionState state, long producerId, long nextProducerId, short producerEpoch, short lastProducerEpoch, int txnTimeoutMs, scala.collection.mutable.Set<TopicPartition> topicPartitions, long txnStartTimestamp, long txnLastUpdateTimestamp, TransactionVersion clientTransactionVersion) {
        if (this.pendingState().isDefined()) {
            throw new IllegalStateException("Preparing transaction state transition to " + state + " while it already has pending state " + (Object)((Object)this.pendingState().get()));
        }
        if (producerId < 0L) {
            throw new IllegalArgumentException("Illegal new producer id " + producerId);
        }
        TransactionState transactionState = state;
        TransactionState transactionState2 = TransactionState.DEAD;
        if ((transactionState == null ? transactionState2 != null : !((Object)((Object)transactionState)).equals((Object)transactionState2)) && producerEpoch < 0) {
            throw new IllegalArgumentException("Illegal new producer epoch " + producerEpoch);
        }
        if (state.validPreviousStates().contains((Object)this.state())) {
            TxnTransitMetadata transitMetadata = new TxnTransitMetadata(producerId, this.producerId(), nextProducerId, producerEpoch, lastProducerEpoch, txnTimeoutMs, state, CollectionConverters$.MODULE$.MutableSetHasAsJava(topicPartitions).asJava(), txnStartTimestamp, txnLastUpdateTimestamp, clientTransactionVersion);
            this.debug((Function0<String> & Serializable)() -> "TransactionalId " + this.transactionalId() + " prepare transition from " + this.state() + " to " + transitMetadata);
            this.pendingState_$eq(new Some<TransactionState>(state));
            return transitMetadata;
        }
        throw new IllegalStateException("Preparing transaction state transition to " + state + " failed since the target state " + state + " is not a valid previous state of the current state " + this.state());
    }

    public long prepareTransitionTo$default$2() {
        return this.producerId();
    }

    public long prepareTransitionTo$default$3() {
        return this.nextProducerId();
    }

    public short prepareTransitionTo$default$4() {
        return this.producerEpoch();
    }

    public short prepareTransitionTo$default$5() {
        return this.lastProducerEpoch();
    }

    public int prepareTransitionTo$default$6() {
        return this.txnTimeoutMs();
    }

    public scala.collection.mutable.Set<TopicPartition> prepareTransitionTo$default$7() {
        return this.topicPartitions();
    }

    public long prepareTransitionTo$default$8() {
        return this.txnStartTimestamp();
    }

    public long prepareTransitionTo$default$9() {
        return this.txnLastUpdateTimestamp();
    }

    public TransactionVersion prepareTransitionTo$default$10() {
        return this.clientTransactionVersion();
    }

    /*
     * Unable to fully structure code
     */
    public void completeTransitionTo(TxnTransitMetadata transitMetadata) {
        block13: {
            block15: {
                block14: {
                    block12: {
                        v0 = toState = (TransactionState)this.pendingState().getOrElse((Function0<Nothing$> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$completeTransitionTo$1(kafka.coordinator.transaction.TransactionMetadata org.apache.kafka.coordinator.transaction.TxnTransitMetadata ), ()Lscala/runtime/Nothing$;)((TransactionMetadata)this, (TxnTransitMetadata)transitMetadata));
                        var6_3 = transitMetadata.txnState();
                        if (v0 == null ? var6_3 != null : v0.equals((Object)var6_3) == false) {
                            this.throwStateTransitionFailure(transitMetadata);
                            return;
                        }
                        var7_4 = toState;
                        if (!TransactionState.EMPTY.equals((Object)var7_4)) break block12;
                        if (this.producerEpoch() != transitMetadata.producerEpoch() && !this.validProducerEpochBump(transitMetadata) || !transitMetadata.topicPartitions().isEmpty() || transitMetadata.txnStartTimestamp() != -1L) {
                            this.throwStateTransitionFailure(transitMetadata);
                        }
                        break block13;
                    }
                    if (!TransactionState.ONGOING.equals((Object)var7_4)) break block14;
                    if (!this.validProducerEpoch(transitMetadata) || !this.topicPartitions().subsetOf(CollectionConverters$.MODULE$.SetHasAsScala(transitMetadata.topicPartitions()).asScala()) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs()) {
                        this.throwStateTransitionFailure(transitMetadata);
                    }
                    break block13;
                }
                if (!(TransactionState.PREPARE_ABORT.equals((Object)var7_4) != false ? true : TransactionState.PREPARE_COMMIT.equals((Object)var7_4) != false)) break block15;
                v1 = toState;
                var9_5 = TransactionState.PREPARE_ABORT;
                if ((v1 != null ? v1.equals((Object)var9_5) == false : var9_5 != null) || !transitMetadata.clientTransactionVersion().supportsEpochBump()) ** GOTO lbl-1000
                v2 = this.state();
                var10_6 = TransactionState.EMPTY;
                if (!(v2 == null ? var10_6 != null : v2.equals((Object)var10_6) == false)) ** GOTO lbl-1000
                v3 = this.state();
                var11_7 = TransactionState.COMPLETE_COMMIT;
                if (!(v3 == null ? var11_7 != null : v3.equals((Object)var11_7) == false)) ** GOTO lbl-1000
                v4 = this.state();
                var12_8 = TransactionState.COMPLETE_ABORT;
                if (!(v4 != null ? v4.equals((Object)var12_8) == false : var12_8 != null)) lbl-1000:
                // 3 sources

                {
                    v5 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v5 = false;
                }
                allowedEmptyAbort = v5;
                v6 = validTimestamp = this.txnStartTimestamp() == transitMetadata.txnStartTimestamp() || allowedEmptyAbort != false;
                if (!(this.validProducerEpoch(transitMetadata) && this.topicPartitions().equals(CollectionConverters$.MODULE$.SetHasAsScala(transitMetadata.topicPartitions()).asScala()) && this.txnTimeoutMs() == transitMetadata.txnTimeoutMs() && validTimestamp)) {
                    this.throwStateTransitionFailure(transitMetadata);
                }
                break block13;
            }
            if (TransactionState.COMPLETE_ABORT.equals((Object)var7_4) != false ? true : TransactionState.COMPLETE_COMMIT.equals((Object)var7_4) != false) {
                if (!this.validProducerEpoch(transitMetadata) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs() || transitMetadata.txnStartTimestamp() == -1L) {
                    this.throwStateTransitionFailure(transitMetadata);
                }
            } else if (TransactionState.PREPARE_EPOCH_FENCE.equals((Object)var7_4)) {
                this.throwStateTransitionFailure(transitMetadata);
            } else {
                if (TransactionState.DEAD.equals((Object)var7_4)) {
                    throw new IllegalStateException("TransactionalId " + this.transactionalId() + " is trying to complete a transition to " + toState + ". This means that the transactionalId was being expired, and the only acceptable completion of this operation is to remove the transaction metadata from the cache, not to persist the " + toState + " in the log.");
                }
                throw new MatchError((Object)var7_4);
            }
        }
        this.debug((Function0<String> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$completeTransitionTo$3(kafka.coordinator.transaction.TransactionMetadata org.apache.kafka.coordinator.transaction.TxnTransitMetadata ), ()Ljava/lang/String;)((TransactionMetadata)this, (TxnTransitMetadata)transitMetadata));
        this.producerId_$eq(transitMetadata.producerId());
        this.prevProducerId_$eq(transitMetadata.prevProducerId());
        this.nextProducerId_$eq(transitMetadata.nextProducerId());
        this.producerEpoch_$eq(transitMetadata.producerEpoch());
        this.lastProducerEpoch_$eq(transitMetadata.lastProducerEpoch());
        this.txnTimeoutMs_$eq(transitMetadata.txnTimeoutMs());
        this.topicPartitions_$eq(CollectionConverters$.MODULE$.SetHasAsScala(transitMetadata.topicPartitions()).asScala());
        this.txnStartTimestamp_$eq(transitMetadata.txnStartTimestamp());
        this.txnLastUpdateTimestamp_$eq(transitMetadata.txnLastUpdateTimestamp());
        this.clientTransactionVersion_$eq(transitMetadata.clientTransactionVersion());
        this.pendingState_$eq(None$.MODULE$);
        this.state_$eq(toState);
    }

    private boolean validProducerEpoch(TxnTransitMetadata transitMetadata) {
        boolean isAtLeastTransactionsV2 = transitMetadata.clientTransactionVersion().supportsEpochBump();
        TransactionState txnState = transitMetadata.txnState();
        short transitProducerEpoch = transitMetadata.producerEpoch();
        long transitProducerId = transitMetadata.producerId();
        short transitLastProducerEpoch = transitMetadata.lastProducerEpoch();
        Tuple3<Boolean, TransactionState, Short> tuple3 = new Tuple3<Boolean, TransactionState, Short>(BoxesRunTime.boxToBoolean(isAtLeastTransactionsV2), txnState, BoxesRunTime.boxToShort(transitProducerEpoch));
        if (tuple3 != null) {
            boolean bl = BoxesRunTime.unboxToBoolean(tuple3._1());
            TransactionState transactionState = tuple3._2();
            short epoch = BoxesRunTime.unboxToShort(tuple3._3());
            if (bl && (((Object)((Object)TransactionState.COMPLETE_COMMIT)).equals((Object)transactionState) ? true : ((Object)((Object)TransactionState.COMPLETE_ABORT)).equals((Object)transactionState)) && epoch == (short)0) {
                return transitLastProducerEpoch == this.lastProducerEpoch() && transitMetadata.prevProducerId() == this.producerId();
            }
        }
        if (tuple3 != null) {
            boolean bl = BoxesRunTime.unboxToBoolean(tuple3._1());
            TransactionState transactionState = tuple3._2();
            if (bl && (((Object)((Object)TransactionState.PREPARE_COMMIT)).equals((Object)transactionState) ? true : ((Object)((Object)TransactionState.PREPARE_ABORT)).equals((Object)transactionState))) {
                return transitLastProducerEpoch == this.producerEpoch() && transitProducerId == this.producerId();
            }
        }
        return transitProducerEpoch == this.producerEpoch() && transitProducerId == this.producerId();
    }

    private boolean validProducerEpochBump(TxnTransitMetadata transitMetadata) {
        short transitEpoch = transitMetadata.producerEpoch();
        long transitProducerId = transitMetadata.producerId();
        return transitEpoch == this.producerEpoch() + 1 || transitEpoch == 0 && transitProducerId != this.producerId();
    }

    private void throwStateTransitionFailure(TxnTransitMetadata txnTransitMetadata) {
        this.fatal((Function0<String> & Serializable)() -> this.toString() + "'s transition to " + txnTransitMetadata + " failed: this should not happen");
        throw new IllegalStateException("TransactionalId " + this.transactionalId() + " failed transition to state " + txnTransitMetadata + " due to unexpected metadata");
    }

    public boolean pendingTransitionInProgress() {
        return this.pendingState().isDefined();
    }

    private boolean includesOffsets() {
        return this.topicPartitions().exists((Function1<TopicPartition, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(TransactionMetadata.$anonfun$includesOffsets$1(x$3)));
    }

    public String toString(TransactionLoggingVerbosity verbosity) {
        StringBuilder res = new StringBuilder("TransactionMetadata(");
        res.append("transactionalId=").append(this.transactionalId());
        res.append(", producerId=").append(this.producerId());
        res.append(", prevProducerId=").append(this.prevProducerId());
        res.append(", nextProducerId=").append(this.nextProducerId());
        res.append(", producerEpoch=").append(this.producerEpoch());
        res.append(", lastProducerEpoch=").append(this.lastProducerEpoch());
        res.append(", txnTimeoutMs=").append(this.txnTimeoutMs());
        res.append(", state=").append((Object)this.state());
        res.append(", pendingState=").append(this.pendingState());
        res.append(", txnStartTimestamp=").append(this.txnStartTimestamp());
        res.append(", txnLastUpdateTimestamp=").append(this.txnLastUpdateTimestamp());
        res.append(", clientTransactionVersion=").append(this.clientTransactionVersion());
        TransactionLoggingVerbosity transactionLoggingVerbosity = verbosity;
        if (TransactionLoggingVerbosity$All$.MODULE$.equals(transactionLoggingVerbosity)) {
            res.append(", partitions=").append(TransactionMetadata.partitionsToString$1(this.topicPartitions()));
        } else if (TransactionLoggingVerbosity$Sample$.MODULE$.equals(transactionLoggingVerbosity)) {
            if (this.topicPartitions().size() > 20) {
                scala.collection.mutable.Set partitionsSample = (scala.collection.mutable.Set)this.topicPartitions().take(20);
                res.append(", samplePartitions=").append(TransactionMetadata.partitionsToString$1(partitionsSample));
                res.append(", includesOffsets=").append(this.includesOffsets());
            } else {
                res.append(", partitions=").append(TransactionMetadata.partitionsToString$1(this.topicPartitions()));
            }
        } else if (TransactionLoggingVerbosity$Off$.MODULE$.equals(transactionLoggingVerbosity)) {
            res.append(", numPartitions=").append(this.topicPartitions().size());
            res.append(", includesOffsets=").append(this.includesOffsets());
        } else {
            throw new MatchError(transactionLoggingVerbosity);
        }
        return res.append(")").toString();
    }

    public String toString() {
        return this.toString(TransactionLoggingVerbosity$Sample$.MODULE$);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof TransactionMetadata)) return false;
        TransactionMetadata transactionMetadata = (TransactionMetadata)object;
        String string = this.transactionalId();
        String string2 = transactionMetadata.transactionalId();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.producerId() != transactionMetadata.producerId()) return false;
        if (this.producerEpoch() != transactionMetadata.producerEpoch()) return false;
        if (this.lastProducerEpoch() != transactionMetadata.lastProducerEpoch()) return false;
        if (this.txnTimeoutMs() != transactionMetadata.txnTimeoutMs()) return false;
        if (!this.state().equals((Object)transactionMetadata.state())) return false;
        if (!this.topicPartitions().equals(transactionMetadata.topicPartitions())) return false;
        if (this.txnStartTimestamp() != transactionMetadata.txnStartTimestamp()) return false;
        if (this.txnLastUpdateTimestamp() != transactionMetadata.txnLastUpdateTimestamp()) return false;
        TransactionVersion transactionVersion = this.clientTransactionVersion();
        TransactionVersion transactionVersion2 = transactionMetadata.clientTransactionVersion();
        if (transactionVersion == null) {
            if (transactionVersion2 == null) return true;
            return false;
        } else {
            if (!transactionVersion.equals(transactionVersion2)) return false;
            return true;
        }
    }

    public int hashCode() {
        Seq fields = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{this.transactionalId(), BoxesRunTime.boxToLong(this.producerId()), BoxesRunTime.boxToShort(this.producerEpoch()), BoxesRunTime.boxToInteger(this.txnTimeoutMs()), this.state(), this.topicPartitions(), BoxesRunTime.boxToLong(this.txnStartTimestamp()), BoxesRunTime.boxToLong(this.txnLastUpdateTimestamp()), this.clientTransactionVersion()}));
        return BoxesRunTime.unboxToInt(((IterableOnceOps)fields.map((Function1<Object, Object> & Serializable)x$4 -> BoxesRunTime.boxToInteger(x$4.hashCode()))).foldLeft(BoxesRunTime.boxToInteger(0), (a, b) -> 31 * a + b));
    }

    public static final /* synthetic */ Nothing$ $anonfun$completeTransitionTo$1(TransactionMetadata $this, TxnTransitMetadata transitMetadata$2) {
        $this.fatal((Function0<String> & Serializable)() -> $this + "'s transition to " + transitMetadata$2 + " failed since pendingState is not defined: this should not happen");
        throw new IllegalStateException("TransactionalId " + $this.transactionalId() + " completing transaction state transition while it does not have a pending state");
    }

    public static final /* synthetic */ String $anonfun$completeTransitionTo$3(TransactionMetadata $this, TxnTransitMetadata transitMetadata$2) {
        return "TransactionalId " + $this.transactionalId() + " complete transition from " + $this.state() + " to " + transitMetadata$2;
    }

    public static final /* synthetic */ boolean $anonfun$includesOffsets$1(TopicPartition x$3) {
        String string = x$3.topic();
        String string2 = "__consumer_offsets";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final String partitionsToString$1(Iterable topicPartitions) {
        return topicPartitions.mkString("[", ",", "]");
    }

    public TransactionMetadata(String transactionalId, long producerId, long prevProducerId, long nextProducerId, short producerEpoch, short lastProducerEpoch, int txnTimeoutMs, TransactionState state, scala.collection.mutable.Set<TopicPartition> topicPartitions, long txnStartTimestamp, long txnLastUpdateTimestamp, TransactionVersion clientTransactionVersion) {
        this.transactionalId = transactionalId;
        this.producerId = producerId;
        this.prevProducerId = prevProducerId;
        this.nextProducerId = nextProducerId;
        this.producerEpoch = producerEpoch;
        this.lastProducerEpoch = lastProducerEpoch;
        this.txnTimeoutMs = txnTimeoutMs;
        this.state = state;
        this.topicPartitions = topicPartitions;
        this.txnStartTimestamp = txnStartTimestamp;
        this.txnLastUpdateTimestamp = txnLastUpdateTimestamp;
        this.clientTransactionVersion = clientTransactionVersion;
        Logging.$init$(this);
        this.pendingState = None$.MODULE$;
        this.hasFailedEpochFence = false;
        this.lock = new ReentrantLock();
    }
}

