/*
 * Decompiled with CFR 0.152.
 */
package kafka.docker;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import kafka.Kafka$;
import kafka.docker.Configuration;
import kafka.docker.Constants$;
import kafka.docker.Log4jConfiguration;
import kafka.docker.Logger;
import kafka.docker.Loggers;
import kafka.docker.Root;
import kafka.tools.StorageTool$;
import kafka.tools.TerseFailure;
import kafka.utils.Logging;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.utils.Exit;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.MapFactory$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.Map$;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class KafkaDockerWrapper$
implements Logging {
    public static final KafkaDockerWrapper$ MODULE$ = new KafkaDockerWrapper$();
    private static com.typesafe.scalalogging.Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private com.typesafe.scalalogging.Logger logger$lzycompute() {
        KafkaDockerWrapper$ kafkaDockerWrapper$ = this;
        synchronized (kafkaDockerWrapper$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public com.typesafe.scalalogging.Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public void main(String[] args) {
        block10: {
            Namespace namespace = this.parseArguments(args);
            String command = namespace.getString("command");
            String string = command;
            switch (string == null ? 0 : string.hashCode()) {
                case 109329021: {
                    if (!"setup".equals(string)) break;
                    Path defaultConfigsPath = Paths.get(namespace.getString("default_configs_dir"), new String[0]);
                    Path mountedConfigsPath = Paths.get(namespace.getString("mounted_configs_dir"), new String[0]);
                    Path finalConfigsPath = Paths.get(namespace.getString("final_configs_dir"), new String[0]);
                    try {
                        this.prepareConfigs(defaultConfigsPath, mountedConfigsPath, finalConfigsPath);
                    }
                    catch (Throwable e) {
                        String errMsg = "error while preparing configs: " + e.getMessage();
                        System.err.println(errMsg);
                        Exit.exit((int)1, (String)errMsg);
                    }
                    String[] formatCmd = this.formatStorageCmd(finalConfigsPath, this.envVars());
                    try {
                        StorageTool$.MODULE$.main(formatCmd);
                        break block10;
                    }
                    catch (TerseFailure terseFailure) {
                        if (terseFailure.getMessage().contains("controller.quorum.voters")) {
                            throw new TerseFailure("To maximize compatibility, the Docker image continues to use static voters, which are supported in 3.7 and later.", (Throwable)((Object)terseFailure));
                        }
                        throw terseFailure;
                    }
                    catch (Throwable e) {
                        throw e;
                    }
                }
                case 109757538: {
                    if (!"start".equals(string)) break;
                    String configFile = namespace.getString("config");
                    this.info((Function0<String> & Serializable)() -> "Starting Kafka server in the native mode.");
                    Kafka$.MODULE$.main((String[])((Object[])new String[]{configFile}));
                    break block10;
                }
            }
            throw new RuntimeException("Unknown operation " + command + ". Please provide a valid operation: 'setup'.");
        }
    }

    private Namespace parseArguments(String[] args) {
        ArgumentParser parser = ArgumentParsers.newArgumentParser("kafka-docker-wrapper", true, "-", "@").description("The Kafka docker wrapper.");
        Subparsers subparsers = parser.addSubparsers().dest("command");
        Subparser kafkaStartParser = subparsers.addParser("start").help("Start kafka server.");
        kafkaStartParser.addArgument("--config", "-C").action(Arguments.store()).required(true).help("The kafka server configuration file");
        Subparser setupParser = subparsers.addParser("setup").help("Setup property files and format storage.");
        setupParser.addArgument("--default-configs-dir", "-D").action(Arguments.store()).required(true).help(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Directory which holds default properties. It should contain the three file:-\n          |server.properties, log4j2.yaml and tools-log4j2.yaml.\n          |")));
        setupParser.addArgument("--mounted-configs-dir", "-M").action(Arguments.store()).required(true).help(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Directory which holds user mounted properties. It can contain none to all the three files:-\n          |server.properties, log4j2.yaml and tools-log4j2.yaml.")));
        setupParser.addArgument("--final-configs-dir", "-F").action(Arguments.store()).required(true).help(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Directory which holds final properties. It holds the final properties that will be used to boot kafka.\n          |")));
        return parser.parseArgsOrFail(args);
    }

    public String[] formatStorageCmd(Path configsPath, Map<String, String> env) {
        Option option = env.get("CLUSTER_ID");
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new RuntimeException("CLUSTER_ID environment variable is not set.");
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        String str = (String)some.value();
        String clusterId = str;
        return (String[])((Object[])new String[]{"format", "--cluster-id=" + clusterId, "-c", ((Object)configsPath).toString() + "/server.properties"});
    }

    private void prepareConfigs(Path defaultConfigsPath, Path mountedConfigsPath, Path finalConfigsPath) {
        this.prepareServerConfigs(defaultConfigsPath, mountedConfigsPath, finalConfigsPath, this.envVars());
        this.prepareLog4j2Configs(defaultConfigsPath, mountedConfigsPath, finalConfigsPath, this.envVars());
        this.prepareToolsLog4j2Configs(defaultConfigsPath, mountedConfigsPath, finalConfigsPath, this.envVars());
    }

    public void prepareServerConfigs(Path defaultConfigsPath, Path mountedConfigsPath, Path finalConfigsPath, Map<String, String> env) {
        String string;
        String propsToAdd = this.addNewlinePadding(this.getServerConfigsFromEnv(env).mkString(Constants$.MODULE$.NewlineChar()));
        Path defaultFilePath = defaultConfigsPath.resolve(String.valueOf(Constants$.MODULE$.ServerPropsFilename()));
        Path mountedFilePath = mountedConfigsPath.resolve(String.valueOf(Constants$.MODULE$.ServerPropsFilename()));
        Path finalFilePath = finalConfigsPath.resolve(String.valueOf(Constants$.MODULE$.ServerPropsFilename()));
        if (Files.exists(mountedFilePath, new LinkOption[0])) {
            this.copyFile(mountedFilePath, finalFilePath);
            this.addToFile(propsToAdd, finalFilePath, StandardOpenOption.APPEND);
        } else {
            this.addToFile(propsToAdd, finalFilePath, StandardOpenOption.TRUNCATE_EXISTING);
        }
        try (BufferedSource source = Source$.MODULE$.fromFile(((Object)finalFilePath).toString(), Codec$.MODULE$.fallbackSystemCodec());){
            string = source.mkString();
        }
        String data = string;
        if (data.trim().isEmpty()) {
            this.copyFile(defaultFilePath, finalFilePath);
            return;
        }
    }

    public void prepareLog4j2Configs(Path defaultConfigsPath, Path mountedConfigsPath, Path finalConfigsPath, Map<String, String> env) {
        Logger[] loggerFromEnv = this.getLog4j2ConfigsFromEnv(env);
        Option<Root> rootOption = this.getLog4j2RootConfigsFromEnv(env);
        Path defaultFilePath = defaultConfigsPath.resolve(String.valueOf(Constants$.MODULE$.Log4j2PropsFilename()));
        Path mountedFilePath = mountedConfigsPath.resolve(String.valueOf(Constants$.MODULE$.Log4j2PropsFilename()));
        Path finalFilePath = finalConfigsPath.resolve(String.valueOf(Constants$.MODULE$.Log4j2PropsFilename()));
        this.copyFile(defaultFilePath, finalFilePath);
        this.copyFile(mountedFilePath, finalFilePath);
        this.addToYaml(loggerFromEnv, rootOption, finalFilePath);
    }

    public void prepareToolsLog4j2Configs(Path defaultConfigsPath, Path mountedConfigsPath, Path finalConfigsPath, Map<String, String> env) {
        Path defaultFilePath = defaultConfigsPath.resolve(String.valueOf(Constants$.MODULE$.ToolsLog4j2Filename()));
        Path mountedFilePath = mountedConfigsPath.resolve(String.valueOf(Constants$.MODULE$.ToolsLog4j2Filename()));
        Path finalFilePath = finalConfigsPath.resolve(String.valueOf(Constants$.MODULE$.ToolsLog4j2Filename()));
        this.copyFile(defaultFilePath, finalFilePath);
        this.copyFile(mountedFilePath, finalFilePath);
        this.addToYaml((Logger[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Logger.class)), this.getToolsLog4j2ConfigsFromEnv(env), finalFilePath);
    }

    public List<String> getServerConfigsFromEnv(Map<String, String> env) {
        return ((IterableOnceOps)env.map((Function1<Tuple2, String> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                if (key.startsWith("KAFKA_") && !Constants$.MODULE$.ExcludeServerPropsEnv().contains(key)) {
                    String final_key = key.replaceFirst("KAFKA_", "").toLowerCase().replace("_", ".").replace("...", "-").replace("..", "_");
                    return final_key + "=" + value;
                }
                return "";
            }
            throw new MatchError(tuple2);
        })).toList().filterNot((Function1<String, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(KafkaDockerWrapper$.$anonfun$getServerConfigsFromEnv$2(x$1)));
    }

    public Option<Root> getLog4j2RootConfigsFromEnv(Map<String, String> env) {
        return (Option)env.get(Constants$.MODULE$.KafkaLog4jRootLoglevelEnv()).filter((Function1<String, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2)))).map((Function1<String, Option> & Serializable)level -> MODULE$.buildRootLogger((String)level)).getOrElse((Function0<Option> & Serializable)() -> Option$.MODULE$.empty());
    }

    public Option<Root> getToolsLog4j2ConfigsFromEnv(Map<String, String> env) {
        return (Option)env.get(Constants$.MODULE$.KafkaToolsLog4jLoglevelEnv()).filter((Function1<String, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$3)))).map((Function1<String, Option> & Serializable)level -> MODULE$.buildRootLogger((String)level)).getOrElse((Function0<Option> & Serializable)() -> Option$.MODULE$.empty());
    }

    private Option<Root> buildRootLogger(String level) {
        Root root = new Root();
        root.setLevel(level);
        return Option$.MODULE$.apply(root);
    }

    public Logger[] getLog4j2ConfigsFromEnv(Map<String, String> env) {
        return (Logger[])env.get(Constants$.MODULE$.KafkaLog4JLoggersEnv()).filter((Function1<String, Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$4)))).map((Function1<String, Logger[]> & Serializable)loggersString -> (Logger[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(loggersString.split(",")), (Function1<String, Logger> & Serializable)e -> {
            String[] parts = e.split("=");
            Logger logger = new Logger();
            logger.setName(parts[0].trim());
            logger.setLevel(parts[1].trim());
            return logger;
        }, ClassTag$.MODULE$.apply(Logger.class))).getOrElse((Function0<Logger[]> & Serializable)() -> (Logger[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Logger.class)));
    }

    private void addToFile(String properties, Path filepath, StandardOpenOption mode) {
        Path path = filepath;
        Object object = !Files.exists(path, new LinkOption[0]) ? Files.createFile(path, new FileAttribute[0]) : BoxedUnit.UNIT;
        Files.write(filepath, properties.getBytes(StandardCharsets.UTF_8), mode);
    }

    private void addToYaml(Logger[] loggerFromEnv, Option<Root> rootOption, Path filepath) {
        Log4jConfiguration log4jConfiguration;
        Path path = filepath;
        Object object = !Files.exists(path, new LinkOption[0]) ? Files.createFile(path, new FileAttribute[0]) : BoxedUnit.UNIT;
        ObjectMapper mapper = new ObjectMapper(new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER)).configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true).setSerializationInclusion(JsonInclude.Include.NON_EMPTY).findAndRegisterModules();
        try {
            log4jConfiguration = mapper.readValue(filepath.toFile(), Log4jConfiguration.class);
        }
        catch (MismatchedInputException mismatchedInputException) {
            log4jConfiguration = new Log4jConfiguration();
        }
        catch (RuntimeException e) {
            throw e;
        }
        Log4jConfiguration yaml = log4jConfiguration;
        Configuration config = yaml.getConfiguration();
        if (config == null) {
            this.generateDefaultLog4jConfig(loggerFromEnv, rootOption, filepath, mapper);
            return;
        }
        this.overrideLog4jConfigByEnv(loggerFromEnv, rootOption, filepath, mapper, yaml, config);
    }

    private void generateDefaultLog4jConfig(Logger[] loggerFromEnv, Option<Root> rootOption, Path filepath, ObjectMapper mapper) {
        Root root;
        Log4jConfiguration log4jYaml = new Log4jConfiguration();
        Configuration configuration = new Configuration();
        Loggers loggers = new Loggers();
        if (rootOption.isEmpty()) {
            Root root2 = new Root();
            root2.setLevel("ERROR");
            root = root2;
        } else {
            root = rootOption.get();
        }
        Root root3 = root;
        log4jYaml.setConfiguration(configuration);
        configuration.setLoggers(loggers);
        loggers.setRoot(root3);
        loggers.setLogger(CollectionConverters$.MODULE$.SeqHasAsJava(Predef$.MODULE$.wrapRefArray((Object[])loggerFromEnv).toList()).asJava());
        Files.write(filepath, mapper.writeValueAsString(log4jYaml).getBytes(StandardCharsets.UTF_8), StandardOpenOption.TRUNCATE_EXISTING);
    }

    private void overrideLog4jConfigByEnv(Logger[] loggerFromEnv, Option<Root> rootOption, Path filepath, ObjectMapper mapper, Log4jConfiguration yaml, Configuration config) {
        scala.collection.mutable.Map nameToLoggers = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(config.getLoggers().getLogger()).asScala().map((Function1<Logger, Tuple2> & Serializable)logger -> new Tuple2<String, Logger>(logger.getName(), (Logger)logger))).to(MapFactory$.MODULE$.toFactory(Map$.MODULE$));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(loggerFromEnv), (Function1<Logger, Option> & Serializable)logger -> nameToLoggers.put(logger.getName(), logger));
        config.getLoggers().setLogger(CollectionConverters$.MODULE$.SeqHasAsJava(nameToLoggers.values().toList()).asJava());
        if (rootOption.isDefined()) {
            config.getLoggers().setRoot(rootOption.get());
        }
        Files.write(filepath, mapper.writeValueAsString(yaml).getBytes(StandardCharsets.UTF_8), StandardOpenOption.TRUNCATE_EXISTING);
    }

    private Object copyFile(Path source, Path destination) {
        if (Files.exists(source, new LinkOption[0])) {
            return Files.copy(source, destination, StandardCopyOption.REPLACE_EXISTING);
        }
        return BoxedUnit.UNIT;
    }

    private String addNewlinePadding(String str) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(str))) {
            return Constants$.MODULE$.NewlineChar() + str;
        }
        return "";
    }

    private Map<String, String> envVars() {
        return package$.MODULE$.env();
    }

    public static final /* synthetic */ boolean $anonfun$getServerConfigsFromEnv$2(String x$1) {
        return x$1.trim().isEmpty();
    }

    private KafkaDockerWrapper$() {
    }
}

