/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability;

import io.confluent.kafka.storage.log.AbstractLog;
import io.confluent.kafka.storage.tier.state.SegmentState;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Optional;
import kafka.Kafka$;
import kafka.cluster.Partition;
import kafka.durability.DurabilityAuditMirrorState;
import kafka.durability.Utils;
import kafka.durability.audit.manager.DurabilityAuditCheck$;
import kafka.durability.events.DurabilityEventType$;
import kafka.server.HostedPartition;
import kafka.server.ReplicaManager;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.Csv;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public final class Utils$ {
    public static final Utils$ MODULE$ = new Utils$();

    public Option<Tuple4<Object, Object, Object, Set<Object>>> getLiveOffset(ReplicaManager replicaManager, TopicPartition topicPartition) {
        Option<AbstractLog> log = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        Option<AbstractLog> option = log;
        if (option instanceof Some) {
            Some some = (Some)option;
            AbstractLog l = (AbstractLog)some.value();
            Option<Set<Object>> option2 = this.getIsrIfLeaderPartition(replicaManager, topicPartition);
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                Set isr = (Set)some2.value();
                return new Some<Tuple4<Object, Object, Object, Set<Object>>>(new Tuple4<Long, Long, Integer, Set>(BoxesRunTime.boxToLong(l.highWatermark()), BoxesRunTime.boxToLong(l.logStartOffset()), BoxesRunTime.boxToInteger(Predef$.MODULE$.Integer2int(l.latestEpoch().orElse(Predef$.MODULE$.int2Integer(-1)))), isr));
            }
            return None$.MODULE$;
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    public Option<Set<Object>> getIsrIfLeaderPartition(ReplicaManager replicaManager, TopicPartition topicPartition) {
        HostedPartition hostedPartition = replicaManager.getPartition(topicPartition);
        if (hostedPartition instanceof HostedPartition.Online) {
            HostedPartition.Online online = (HostedPartition.Online)hostedPartition;
            Partition partition = online.partition();
            Option<AbstractLog> option = partition.leaderLogIfLocal();
            if (option instanceof Some) {
                return Option$.MODULE$.apply(partition.inSyncReplicaIds());
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public Option<Object> getLeaderEpochIfMirrorPartition(ReplicaManager replicaManager, TopicPartition topicPartition) {
        HostedPartition hostedPartition = replicaManager.getPartition(topicPartition);
        if (hostedPartition instanceof HostedPartition.Online) {
            HostedPartition.Online online = (HostedPartition.Online)hostedPartition;
            Partition partition = online.partition();
            if (partition.durabilityAuditMirrorState().isDefined()) {
                return Option$.MODULE$.apply(BoxesRunTime.boxToInteger(partition.getLeaderEpoch()));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public Option<Set<Object>> getIsrPartition(ReplicaManager replicaManager, TopicPartition topicPartition) {
        HostedPartition hostedPartition = replicaManager.getPartition(topicPartition);
        if (hostedPartition instanceof HostedPartition.Online) {
            HostedPartition.Online online = (HostedPartition.Online)hostedPartition;
            Partition partition = online.partition();
            return Option$.MODULE$.apply(partition.inSyncReplicaIds());
        }
        return None$.MODULE$;
    }

    public int getLocalReplicaEpochIfLeader(ReplicaManager replicaManager, TopicPartition topicPartition) {
        HostedPartition hostedPartition = replicaManager.getPartition(topicPartition);
        if (hostedPartition instanceof HostedPartition.Online) {
            HostedPartition.Online online = (HostedPartition.Online)hostedPartition;
            Partition partition = online.partition();
            Option<AbstractLog> option = partition.leaderLogIfLocal();
            if (option instanceof Some) {
                return partition.getLeaderEpoch();
            }
            return -1;
        }
        return -1;
    }

    public Option<DurabilityAuditMirrorState> getDurabilityAuditMirrorState(ReplicaManager replicaManager, TopicPartition topicPartition) {
        HostedPartition hostedPartition = replicaManager.getPartition(topicPartition);
        if (hostedPartition instanceof HostedPartition.Online) {
            HostedPartition.Online online = (HostedPartition.Online)hostedPartition;
            Partition partition = online.partition();
            return partition.durabilityAuditMirrorState();
        }
        return None$.MODULE$;
    }

    public Option<Object> getLogEndOffset(ReplicaManager replicaManager, TopicPartition topicPartition) {
        return replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2()).map((Function1<AbstractLog, Object> & Serializable)x$1 -> BoxesRunTime.boxToLong(x$1.logEndOffset()));
    }

    public Option<Object> getLatestEpoch(ReplicaManager replicaManager, TopicPartition topicPartition) {
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        if (option instanceof Some) {
            Some some = (Some)option;
            AbstractLog log = (AbstractLog)some.value();
            return OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(log.latestEpoch())).map((Function1<Integer, Object> & Serializable)x$2 -> BoxesRunTime.boxToInteger(Predef$.MODULE$.Integer2int(x$2)));
        }
        return None$.MODULE$;
    }

    public boolean isTieredLog(AbstractLog log) {
        return log.config().confluentLogConfig().tierEnable() && !log.config().compact() && !Topic.isInternal((String)log.topicPartition().topic());
    }

    public Option<SegmentState> getPreviousTierSegmentInfo(ReplicaManager replicaManager, TopicIdPartition topicIdPartition, long offset) {
        boolean bl = false;
        Some some = null;
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicIdPartition.topicPartition(), replicaManager.logManager().getLog$default$2());
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            AbstractLog log = (AbstractLog)some.value();
            if (!this.isTieredLog(log)) {
                return None$.MODULE$;
            }
        }
        if (bl) {
            AbstractLog log = (AbstractLog)some.value();
            if (this.isValidTopicId(OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(log.topicId())), topicIdPartition.topicId())) {
                Optional<SegmentState> state = log.tierPartitionState().previousMetadataBeforeOffset(offset);
                return OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(state));
            }
            Kafka$.MODULE$.warn((Function0<String> & Serializable)() -> "Not returning prev tier segment info, since the topic has changed from topicId: " + topicIdPartition.topicId() + " to topicId: " + log.topicId() + "This can happen if the topic has been recreated and Durability Audit is processing an event from the older topic");
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public Option<Utils.MaxTimestampWithSize> getTierSegmentInfoForRange(ReplicaManager replicaManager, TopicPartition topicPartition, long start, long end) {
        Some some;
        AbstractLog log;
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        if (option instanceof Some && this.isTieredLog(log = (AbstractLog)(some = (Some)option).value())) {
            Buffer<SegmentState> states = CollectionConverters$.MODULE$.ListHasAsScala(log.tierPartitionState().segmentInMemoryMetadataRange(start, end)).asScala();
            if (states.isEmpty()) {
                return None$.MODULE$;
            }
            return new Some<Utils.MaxTimestampWithSize>(new Utils.MaxTimestampWithSize(BoxesRunTime.unboxToLong(((IterableOnceOps)states.map((Function1<SegmentState, Object> & Serializable)x$3 -> BoxesRunTime.boxToLong(x$3.maxTimestamp()))).max(Ordering.Long$.MODULE$)), BoxesRunTime.unboxToInt(((IterableOnceOps)states.map((Function1<SegmentState, Object> & Serializable)x$4 -> BoxesRunTime.boxToInteger(x$4.size()))).sum(Numeric.IntIsIntegral$.MODULE$))));
        }
        return None$.MODULE$;
    }

    public Tuple2<Option<Object>, String> getEstimatedLogRangeSize(ReplicaManager replicaManager, TopicIdPartition topicIdPartition, long startOffset) {
        Object msg = "LogInfo: ";
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicIdPartition.topicPartition(), replicaManager.logManager().getLog$default$2());
        if (option instanceof Some) {
            Some some = (Some)option;
            AbstractLog log = (AbstractLog)some.value();
            if (this.isValidTopicId(OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(log.topicId())), topicIdPartition.topicId())) {
                Tuple2<AbstractLog, Option<SegmentState>> tuple2 = new Tuple2<AbstractLog, Option<SegmentState>>(log, this.getPreviousTierSegmentInfo(replicaManager, topicIdPartition, startOffset));
                if (tuple2 != null) {
                    AbstractLog log2 = tuple2._1();
                    Option<SegmentState> option2 = tuple2._2();
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        SegmentState prevSegmentState = (SegmentState)some2.value();
                        msg = (String)msg + "Log Start Offset: " + log2.logStartOffset() + " Log size: " + log2.size() + " Prev Segment State: " + prevSegmentState;
                        if (log2.logStartOffset() == startOffset) {
                            return new Tuple2<Some<Long>, Object>(new Some<Long>(BoxesRunTime.boxToLong(log2.size() + (long)prevSegmentState.size())), msg);
                        }
                        if (log2.logStartOffset() > startOffset) {
                            Option<Utils.MaxTimestampWithSize> gapSize = this.getTierSegmentInfoForRange(replicaManager, topicIdPartition.topicPartition(), startOffset, log2.logStartOffset() - 1L);
                            if (gapSize.isDefined()) {
                                return new Tuple2<Some<Long>, CallSite>(new Some<Long>(BoxesRunTime.boxToLong(log2.size() + (long)prevSegmentState.size() + gapSize.get().size())), (CallSite)((Object)((String)msg + " Gap Size: " + gapSize.get().size())));
                            }
                            return new Tuple2<None$, CallSite>(None$.MODULE$, (CallSite)((Object)((String)msg + "Gap Size: Not Available")));
                        }
                        Option<Utils.MaxTimestampWithSize> extraSize = this.getTierSegmentInfoForRange(replicaManager, topicIdPartition.topicPartition(), log2.logStartOffset(), startOffset - 1L);
                        if (extraSize.isDefined()) {
                            return new Tuple2<Some<Long>, CallSite>(new Some<Long>(BoxesRunTime.boxToLong(log2.size() - extraSize.get().size() + (long)prevSegmentState.size())), (CallSite)((Object)((String)msg + " Extra Size: " + extraSize.get().size())));
                        }
                        return new Tuple2<None$, CallSite>(None$.MODULE$, (CallSite)((Object)((String)msg + "Extra Size: Not Available")));
                    }
                }
                return new Tuple2<None$, CallSite>(None$.MODULE$, (CallSite)((Object)((String)msg + "Previous Segment State: Not Available")));
            }
            Kafka$.MODULE$.warn((Function0<String> & Serializable)() -> "Not returning estimated log size, since the topic has changed from topicId: " + topicIdPartition.topicId() + " to topicId: " + log.topicId() + "This can happen if the topic has been recreated and Durability Audit is processing an event from the older topic");
            return new Tuple2<None$, CallSite>(None$.MODULE$, (CallSite)((Object)((String)msg + " Topic ID Mismatch")));
        }
        return new Tuple2<None$, CallSite>(None$.MODULE$, (CallSite)((Object)((String)msg + " Log Not Found")));
    }

    public int getBrokerId(ReplicaManager replicaManager) {
        return replicaManager.config().brokerId();
    }

    public Option<Object> getLocalLogRetentionSize(ReplicaManager replicaManager, TopicPartition topicPartition) {
        Some some;
        AbstractLog log;
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        if (option instanceof Some && (log = (AbstractLog)(some = (Some)option).value()) != null) {
            AbstractLog abstractLog = log;
            return new Some<Object>(BoxesRunTime.boxToLong(abstractLog.config().retentionSize));
        }
        return None$.MODULE$;
    }

    public Option<Object> getLocalLogRetentionMs(ReplicaManager replicaManager, TopicPartition topicPartition) {
        Some some;
        AbstractLog log;
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        if (option instanceof Some && (log = (AbstractLog)(some = (Some)option).value()) != null) {
            AbstractLog abstractLog = log;
            return new Some<Object>(BoxesRunTime.boxToLong(abstractLog.config().retentionMs));
        }
        return None$.MODULE$;
    }

    public Option<Object> getLocalStartOffsetForEpoch(ReplicaManager replicaManager, TopicPartition topicPartition, int epoch) {
        return replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2()).map((Function1<AbstractLog, Object> & Serializable)x$5 -> BoxesRunTime.boxToLong(Utils$.$anonfun$getLocalStartOffsetForEpoch$1(epoch, x$5))).orElse((Function0<None$> & Serializable)() -> None$.MODULE$);
    }

    public boolean isCompacted(ReplicaManager replicaManager, TopicPartition topicPartition) {
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        if (option instanceof Some) {
            Some some = (Some)option;
            AbstractLog log = (AbstractLog)some.value();
            return log.config().compact();
        }
        return false;
    }

    public String consumerRecordMetadata(ConsumerRecord<byte[], byte[]> record) {
        Date timestampFormatted = new Date(record.timestamp());
        return "Timestamp: " + timestampFormatted + ", Partition: " + record.partition() + ", Offset: " + record.offset();
    }

    public Set<Enumeration.Value> parseDurabilityEventCsvLists(String events) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(Csv.parseCsvList(events)).asScala().flatMap((Function1<String, Option> & Serializable)evt -> DurabilityEventType$.MODULE$.withNameOpt((String)evt))).toSet();
    }

    public Set<Enumeration.Value> parseDurabilityAuditsCsvLists(String audits) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(Csv.parseCsvList(audits)).asScala().flatMap((Function1<String, Option> & Serializable)evt -> DurabilityAuditCheck$.MODULE$.withNameOpt((String)evt))).toSet();
    }

    public int toPartition(TopicPartition topicPartition, int numPartitions) {
        return Math.abs(topicPartition.hashCode()) % numPartitions;
    }

    public int getDayOfYear(Time time) {
        Instant now = Instant.ofEpochMilli(time.milliseconds());
        GregorianCalendar calendar = GregorianCalendar.from(now.atZone(ZoneOffset.UTC));
        return calendar.get(6);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isValidTopicId(Option<Uuid> currTopicId, Uuid oldTopicId) {
        if (currTopicId.isEmpty()) return true;
        Object b = currTopicId.getOrElse((Function0<Uuid> & Serializable)() -> Uuid.ZERO_UUID);
        Uuid uuid = oldTopicId;
        if (b != null) {
            if (!b.equals(uuid)) return false;
            return true;
        }
        if (uuid == null) return true;
        return false;
    }

    public static final /* synthetic */ long $anonfun$getLocalStartOffsetForEpoch$1(int epoch$1, AbstractLog x$5) {
        return x$5.leaderEpochCache().offsetForEpoch(epoch$1);
    }

    private Utils$() {
    }
}

