/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.materialization;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import kafka.durability.DurabilityAuditMirrorState;
import kafka.durability.Utils$;
import kafka.durability.audit.AuditReporter;
import kafka.durability.db.ConfigFlag$;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.PartitionState;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.Deserializer$;
import kafka.durability.events.HealthCheckEvent;
import kafka.durability.events.broker.ClusterLinkTruncationEvent;
import kafka.durability.events.broker.ClusterLinkTruncationEvent$TruncationType$;
import kafka.durability.events.broker.DeletePartitionEvent;
import kafka.durability.events.broker.DeleteRecordsEvent;
import kafka.durability.events.broker.DestLogEpochChangeEvent;
import kafka.durability.events.broker.EpochChangeEvent;
import kafka.durability.events.broker.InjectStateEvent;
import kafka.durability.events.broker.IsrExpandEvent;
import kafka.durability.events.broker.MirrorStateChangeEvent;
import kafka.durability.events.broker.OffsetChangeEvent;
import kafka.durability.events.broker.RetentionChangeEvent;
import kafka.durability.events.broker.RetentionType$;
import kafka.durability.events.broker.StartOffsetChangeEvent;
import kafka.durability.events.broker.StartOffsetChangeEvent$;
import kafka.durability.events.controller.AbstractControllerDurabilityEvent;
import kafka.durability.materialization.AbstractDurabilityEventsMaterialize;
import kafka.durability.materialization.BrokerDurabilityEventsMaterialize$;
import kafka.durability.materialization.validation.BrokerValidator;
import kafka.server.ReplicaManager;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;
import org.slf4j.LoggerFactory;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcIJ$sp;
import scala.collection.BufferedIterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r]c\u0001\u0002\u001b6\u0001qB\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\u0011\u0002\u0011)\u0019!C!\u0013\"Iq\n\u0001B\u0001B\u0003%!\n\u0015\u0005\t#\u0002\u0011\t\u0011)A\u0005%\"A\u0001\f\u0001B\u0001B\u0003%\u0011\f\u0003\u0005g\u0001\t\u0005\t\u0015!\u0003h\u0011\u001d\ty\u0001\u0001C\u0001\u0003#A!\"a\b\u0001\u0005\u0004%\t%NA\u0011\u0011!\ty\u0003\u0001Q\u0001\n\u0005\r\u0002bBA\u0019\u0001\u0011\u0005\u00131\u0007\u0005\u000b\u0003w\u0001\u0001R1A\u0005B\u0005u\u0002bBA*\u0001\u0011\u0005\u0013Q\u000b\u0005\b\u0003{\u0002A\u0011BA@\u0011\u001d\t9\n\u0001C\u0005\u00033C\u0001\"a-\u0001\t\u0003)\u0014Q\u0017\u0005\u000b\u0003\u0013\u0004\u0011\u0013!C\u0001k\u0005-\u0007BCAq\u0001E\u0005I\u0011A\u001b\u0002d\"A\u0011q\u001d\u0001\u0005\u0002U\nI\u000f\u0003\u0006\u0003\"\u0001\t\n\u0011\"\u00016\u0003\u0017D!Ba\t\u0001#\u0003%\t!NAr\u0011)\u0011)\u0003AI\u0001\n\u0003)\u00141\u001d\u0005\u000b\u0005O\u0001\u0011\u0013!C\u0001k\u0005-\u0007\u0002\u0003B\u0015\u0001\u0011\u0005QGa\u000b\t\u000f\t\r\u0003\u0001\"\u0003\u0003F!I!Q\r\u0001\u0012\u0002\u0013%!q\r\u0005\t\u0005W\u0002A\u0011A\u001b\u0003n!Q!1\u0010\u0001\u0012\u0002\u0013\u0005Q'a3\t\u0015\tu\u0004!%A\u0005\u0002U\n\u0019\u000f\u0003\u0005\u0003\u0000\u0001!\t!\u000eBA\u0011)\u0011\t\nAI\u0001\n\u0003)\u00141\u001a\u0005\t\u0005'\u0003A\u0011A\u001b\u0003\u0016\"Q!Q\u0015\u0001\u0012\u0002\u0013\u0005Q'a3\t\u0011\t\u001d\u0006\u0001\"\u00016\u0005SC\u0001B!,\u0001\t\u0003)$q\u0016\u0005\t\u0005o\u0003A\u0011A\u001b\u0003:\"Q!\u0011\u001a\u0001\u0012\u0002\u0013\u0005Q'a3\t\u0011\t-\u0007\u0001\"\u00016\u0005\u001bD\u0001Ba7\u0001\t\u0003)$Q\u001c\u0005\t\u0005S\u0004A\u0011A\u001b\u0003l\"Q!1 \u0001\u0012\u0002\u0013\u0005Q'a3\t\u0011\tu\b\u0001\"\u00016\u0005\u007fD!ba\u0004\u0001#\u0003%\t!NAf\u0011\u001d\u0019\t\u0002\u0001C\u0005\u0007'Aqa!\b\u0001\t\u0003\u0019y\u0002C\u0004\u00040\u0001!\ta!\r\t\u000f\r]\u0002\u0001\"\u0001\u0004:!I1\u0011\t\u0001\u0012\u0002\u0013\u0005\u00111Z\u0004\n\u0007\u0007*\u0014\u0011!E\u0001\u0007\u000b2\u0001\u0002N\u001b\u0002\u0002#\u00051q\t\u0005\b\u0003\u001f\tD\u0011AB(\u0011%\u0019\t&MI\u0001\n\u0003\u0019\u0019FA\u0011Ce>\\WM\u001d#ve\u0006\u0014\u0017\u000e\\5us\u00163XM\u001c;t\u001b\u0006$XM]5bY&TXM\u0003\u00027o\u0005yQ.\u0019;fe&\fG.\u001b>bi&|gN\u0003\u00029s\u0005QA-\u001e:bE&d\u0017\u000e^=\u000b\u0003i\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001{A\u0011ahP\u0007\u0002k%\u0011\u0001)\u000e\u0002$\u0003\n\u001cHO]1di\u0012+(/\u00192jY&$\u00180\u0012<f]R\u001cX*\u0019;fe&\fG.\u001b>f\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\"a\u0011$\u000e\u0003\u0011S!!R\u001d\u0002\rM,'O^3s\u0013\t9EI\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002\u0005\u0011\u0014W#\u0001&\u0011\u0005-kU\"\u0001'\u000b\u0005!;\u0014B\u0001(M\u00051!UO]1cS2LG/\u001f#C\u0003\r!'\rI\u0005\u0003\u0011~\n\u0001B]3q_J$XM\u001d\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+^\nQ!Y;eSRL!a\u0016+\u0003\u001b\u0005+H-\u001b;SKB|'\u000f^3s\u0003\u0011!\u0018.\\3\u0011\u0005i#W\"A.\u000b\u0005qk\u0016!B;uS2\u001c(B\u00010`\u0003\u0019\u0019w.\\7p]*\u0011!\b\u0019\u0006\u0003C\n\fa!\u00199bG\",'\"A2\u0002\u0007=\u0014x-\u0003\u0002f7\n!A+[7f\u0003mIwM\\8sK\u0012,e/\u001a8u)f\u0004Xm\u001d+pE\u0016dunZ4fIB\u0019\u0001n[7\u000e\u0003%T\u0011A[\u0001\u0006g\u000e\fG.Y\u0005\u0003Y&\u0014aa\u00149uS>t\u0007c\u00018vq:\u0011qn\u001d\t\u0003a&l\u0011!\u001d\u0006\u0003en\na\u0001\u0010:p_Rt\u0014B\u0001;j\u0003\u0019\u0001&/\u001a3fM&\u0011ao\u001e\u0002\u0004'\u0016$(B\u0001;j!\rI\u0018\u0011\u0002\b\u0004u\u0006\raBA>\u0000\u001d\tahP\u0004\u0002q{&\t!(\u0003\u00029s%\u0019\u0011\u0011A\u001c\u0002\r\u00154XM\u001c;t\u0013\u0011\t)!a\u0002\u0002'\u0011+(/\u00192jY&$\u00180\u0012<f]R$\u0016\u0010]3\u000b\u0007\u0005\u0005q'\u0003\u0003\u0002\f\u00055!a\u0005#ve\u0006\u0014\u0017\u000e\\5us\u00163XM\u001c;UsB,'\u0002BA\u0003\u0003\u000f\ta\u0001P5oSRtD\u0003DA\n\u0003+\t9\"!\u0007\u0002\u001c\u0005u\u0001C\u0001 \u0001\u0011\u0015\tu\u00011\u0001C\u0011\u0015Au\u00011\u0001K\u0011\u0015\tv\u00011\u0001S\u0011\u0015Av\u00011\u0001Z\u0011\u001d1w\u0001%AA\u0002\u001d\f\u0011B^1mS\u0012\fGo\u001c:\u0016\u0005\u0005\r\u0002\u0003BA\u0013\u0003Wi!!a\n\u000b\u0007\u0005%R'\u0001\u0006wC2LG-\u0019;j_:LA!!\f\u0002(\ty!I]8lKJ4\u0016\r\\5eCR|'/\u0001\u0006wC2LG-\u0019;pe\u0002\n!\u0002\\8hO\u0016\u0014h*Y7f+\t\t)\u0004E\u0002o\u0003oI1!!\u000fx\u0005\u0019\u0019FO]5oO\u00061An\\4hKJ,\"!a\u0010\u0011\t\u0005\u0005\u0013qJ\u0007\u0003\u0003\u0007RA!!\u0012\u0002H\u0005a1oY1mC2|wmZ5oO*!\u0011\u0011JA&\u0003!!\u0018\u0010]3tC\u001a,'BAA'\u0003\r\u0019w.\\\u0005\u0005\u0003#\n\u0019E\u0001\u0004M_\u001e<WM]\u0001\f[\u0006$XM]5bY&TX\r\u0006\u0003\u0002X\u0005u\u0003c\u00015\u0002Z%\u0019\u00111L5\u0003\u000f\t{w\u000e\\3b]\"9\u0011q\f\u0007A\u0002\u0005\u0005\u0014A\u0002:fG>\u0014H\r\u0005\u0005\u0002d\u00055\u0014\u0011OA9\u001b\t\t)G\u0003\u0003\u0002h\u0005%\u0014\u0001C2p]N,X.\u001a:\u000b\u0007\u0005-t,A\u0004dY&,g\u000e^:\n\t\u0005=\u0014Q\r\u0002\u000f\u0007>t7/^7feJ+7m\u001c:e!\u0015A\u00171OA<\u0013\r\t)(\u001b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004Q\u0006e\u0014bAA>S\n!!)\u001f;f\u0003ai\u0017\r^3sS\u0006d\u0017N_3J]*,7\r^3e'R\fG/\u001a\u000b\u0005\u0003\u0003\u000b9\tE\u0002i\u0003\u0007K1!!\"j\u0005\u0011)f.\u001b;\t\u000f\u0005%U\u00021\u0001\u0002\f\u0006\u0001\u0012N\u001c6fGR\u001cF/\u0019;f\u000bZ,g\u000e\u001e\t\u0005\u0003\u001b\u000b\u0019*\u0004\u0002\u0002\u0010*!\u0011\u0011SA\u0004\u0003\u0019\u0011'o\\6fe&!\u0011QSAH\u0005AIeN[3diN#\u0018\r^3Fm\u0016tG/\u0001\u000fnCR,'/[1mSj,wJ\u001a4tKR\u001c\u0005.\u00198hK\u00163XM\u001c;\u0015\u0011\u0005\u0005\u00151TAS\u0003_Cq!!(\u000f\u0001\u0004\ty*A\tpM\u001a\u001cX\r^\"iC:<W-\u0012<f]R\u0004B!!$\u0002\"&!\u00111UAH\u0005EyeMZ:fi\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\u0005\b\u0003Os\u0001\u0019AAU\u0003\u0015\u0019H/\u0019;f!\rY\u00151V\u0005\u0004\u0003[c%A\u0004)beRLG/[8o'R\fG/\u001a\u0005\b\u0003cs\u0001\u0019AA\u001b\u0003!iW\r^1eCR\f\u0017\u0001H7bi\u0016\u0014\u0018.\u00197ju\u0016$U\r\\3uKJ+7m\u001c:e\u000bZ,g\u000e\u001e\u000b\u000b\u0003\u0003\u000b9,!1\u0002D\u0006\u0015\u0007bBA]\u001f\u0001\u0007\u00111X\u0001\u0013I\u0016dW\r^3SK\u000e|'\u000fZ:Fm\u0016tG\u000f\u0005\u0003\u0002\u000e\u0006u\u0016\u0002BA`\u0003\u001f\u0013!\u0003R3mKR,'+Z2pe\u0012\u001cXI^3oi\"9\u0011qU\bA\u0002\u0005%\u0006\"CAY\u001fA\u0005\t\u0019AA\u001b\u0011%\t9m\u0004I\u0001\u0002\u0004\t9&A\u000eva\u0012\fG/Z(oYf\u001cu.\\7jiN#\u0018M\u001d;PM\u001a\u001cX\r^\u0001'[\u0006$XM]5bY&TX\rR3mKR,'+Z2pe\u0012,e/\u001a8uI\u0011,g-Y;mi\u0012\u001aTCAAgU\u0011\t)$a4,\u0005\u0005E\u0007\u0003BAj\u0003;l!!!6\u000b\t\u0005]\u0017\u0011\\\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a7j\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003?\f)NA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fa%\\1uKJL\u0017\r\\5{K\u0012+G.\u001a;f%\u0016\u001cwN\u001d3Fm\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\t)O\u000b\u0003\u0002X\u0005=\u0017aH7bi\u0016\u0014\u0018.\u00197ju\u0016D\u0015n\u001a5XCR,'/\\1sW\u000eC\u0017M\\4fgR!\u0012\u0011QAv\u0003o\u0014\tAa\u0003\u0003\u0012\tM!Q\u0003B\r\u0005;Aq!!<\u0013\u0001\u0004\ty/\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0005E\u00181_\u0007\u0002;&\u0019\u0011Q_/\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"9\u0011\u0011 \nA\u0002\u0005m\u0018!B3q_\u000eD\u0007c\u00015\u0002~&\u0019\u0011q`5\u0003\u0007%sG\u000fC\u0004\u0003\u0004I\u0001\rA!\u0002\u0002\u0007!<X\u000eE\u0002i\u0005\u000fI1A!\u0003j\u0005\u0011auN\\4\t\u000f\t5!\u00031\u0001\u0003\u0010\u0005\u0019\u0011n\u001d:\u0011\t9,\u00181 \u0005\b\u0003O\u0013\u0002\u0019AAU\u0011%\t\tL\u0005I\u0001\u0002\u0004\t)\u0004C\u0005\u0003\u0018I\u0001\n\u00111\u0001\u0002X\u00051BO]5hO\u0016\u0014X\r\u001a\"z\u000bB|7\r[\"iC:<W\rC\u0005\u0003\u001cI\u0001\n\u00111\u0001\u0002X\u0005aBO]5hO\u0016\u0014X\r\u001a\"z\u001b&\u0014(o\u001c:Ti\u0006$Xm\u00115b]\u001e,\u0007\"\u0003B\u0010%A\u0005\t\u0019AA\u001b\u0003Qi\u0017N\u001d:peN#\u0018\r^3Ge>lWI^3oi\u0006IS.\u0019;fe&\fG.\u001b>f\u0011&<\u0007nV1uKJl\u0017M]6DQ\u0006tw-Z:%I\u00164\u0017-\u001e7uIY\n\u0011&\\1uKJL\u0017\r\\5{K\"Kw\r[,bi\u0016\u0014X.\u0019:l\u0007\"\fgnZ3tI\u0011,g-Y;mi\u0012:\u0014!K7bi\u0016\u0014\u0018.\u00197ju\u0016D\u0015n\u001a5XCR,'/\\1sW\u000eC\u0017M\\4fg\u0012\"WMZ1vYR$\u0003(A\u0015nCR,'/[1mSj,\u0007*[4i/\u0006$XM]7be.\u001c\u0005.\u00198hKN$C-\u001a4bk2$H%O\u0001\u0010iJ,hnY1uK\u001a\u0013x.\\#oIR1\u0011\u0011\u0011B\u0017\u0005_AqAa\u0001\u0018\u0001\u0004\u0011)\u0001C\u0004\u00032]\u0001\rAa\r\u0002+5L'O]8s\u0007\u0006\u001c\u0007.Z#q_\u000eD7\t[1j]BA!Q\u0007B \u0003w\u0014)!\u0004\u0002\u00038)!!\u0011\bB\u001e\u0003\u001diW\u000f^1cY\u0016T1A!\u0010j\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u0003\u00129DA\u0004ICNDW*\u00199\u0002C5\f7.Z$f]\u0016\u0014\u0018nY*uCJ$xJ\u001a4tKR\u001c\u0005.\u00198hK\u00163XM\u001c;\u0015\u001d\t\u001d#Q\nB,\u00053\u0012iFa\u0018\u0003dA!\u0011Q\u0012B%\u0013\u0011\u0011Y%a$\u0003-M#\u0018M\u001d;PM\u001a\u001cX\r^\"iC:<W-\u0012<f]RDqAa\u0014\u0019\u0001\u0004\u0011\t&\u0001\u0002jIB!\u0011\u0011\u001fB*\u0013\r\u0011)&\u0018\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:Dq!!?\u0019\u0001\u0004\tY\u0010C\u0004\u0003\\a\u0001\rA!\u0002\u0002\u0017M$\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0005\b\u0005\u0007A\u0002\u0019\u0001B\u0003\u0011\u001d\u0011\t\u0007\u0007a\u0001\u0003w\faA\\8eK&#\u0007\"\u0003B\u00071A\u0005\t\u0019\u0001B\b\u0003-j\u0017m[3HK:,'/[2Ti\u0006\u0014Ho\u00144gg\u0016$8\t[1oO\u0016,e/\u001a8uI\u0011,g-Y;mi\u00122TC\u0001B5U\u0011\u0011y!a4\u0002-5\fG/\u001a:jC2L'0Z*uCJ$xJ\u001a4tKR$\"\"!!\u0003p\tM$Q\u000fB<\u0011\u001d\u0011\tH\u0007a\u0001\u0005\u000f\nac\u001d;beR|eMZ:fi\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\u0005\b\u0003OS\u0002\u0019AAU\u0011%\t\tL\u0007I\u0001\u0002\u0004\t)\u0004C\u0005\u0003zi\u0001\n\u00111\u0001\u0002X\u0005Ya/\u00197jI\u0006$X\rS,N\u0003\u0001j\u0017\r^3sS\u0006d\u0017N_3Ti\u0006\u0014Ho\u00144gg\u0016$H\u0005Z3gCVdG\u000fJ\u001a\u0002A5\fG/\u001a:jC2L'0Z*uCJ$xJ\u001a4tKR$C-\u001a4bk2$H\u0005N\u0001\u001c[\u0006$XM]5bY&TX-\u00129pG\"\u001c\u0005.\u00198hK\u00163XM\u001c;\u0015\u0011\u0005\u0005%1\u0011BG\u0005\u001fCqA!\"\u001e\u0001\u0004\u00119)\u0001\tfa>\u001c\u0007n\u00115b]\u001e,WI^3oiB!\u0011Q\u0012BE\u0013\u0011\u0011Y)a$\u0003!\u0015\u0003xn\u00195DQ\u0006tw-Z#wK:$\bbBAT;\u0001\u0007\u0011\u0011\u0016\u0005\n\u0003ck\u0002\u0013!a\u0001\u0003k\tQ%\\1uKJL\u0017\r\\5{K\u0016\u0003xn\u00195DQ\u0006tw-Z#wK:$H\u0005Z3gCVdG\u000fJ\u001a\u0002E5\fG/\u001a:jC2L'0\u001a#fgRdunZ#q_\u000eD7\t[1oO\u0016,e/\u001a8u)!\t\tIa&\u0003\"\n\r\u0006b\u0002BM?\u0001\u0007!1T\u0001\u0018I\u0016\u001cH\u000fT8h\u000bB|7\r[\"iC:<W-\u0012<f]R\u0004B!!$\u0003\u001e&!!qTAH\u0005]!Um\u001d;M_\u001e,\u0005o\\2i\u0007\"\fgnZ3Fm\u0016tG\u000fC\u0004\u0002(~\u0001\r!!+\t\u0013\u0005Ev\u0004%AA\u0002\u0005U\u0012\u0001L7bi\u0016\u0014\u0018.\u00197ju\u0016$Um\u001d;M_\u001e,\u0005o\\2i\u0007\"\fgnZ3Fm\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003I!(/\u001e8dCR,W\t]8dQ\u000eC\u0017-\u001b8\u0015\t\u0005\u0005%1\u0016\u0005\b\u0003O\u000b\u0003\u0019AAU\u0003Q!w\u000e\u0016:v]\u000e\fG/Z#q_\u000eD7\t[1j]R1\u0011\u0011\u0011BY\u0005gCqAa\u0017#\u0001\u0004\u0011)\u0001C\u0004\u00036\n\u0002\rAa\r\u0002\u0015\u0015\u0004xn\u00195DQ\u0006Lg.A\rnCR,'/[1mSj,\u0017j\u0015*FqB\fg\u000eZ#wK:$H\u0003CAA\u0005w\u0013)Ma2\t\u000f\tu6\u00051\u0001\u0003@\u0006q\u0011n\u001d:FqB\fg\u000eZ#wK:$\b\u0003BAG\u0005\u0003LAAa1\u0002\u0010\nq\u0011j\u001d:FqB\fg\u000eZ#wK:$\bbBATG\u0001\u0007\u0011\u0011\u0016\u0005\n\u0003c\u001b\u0003\u0013!a\u0001\u0003k\t1%\\1uKJL\u0017\r\\5{K&\u001b&+\u0012=qC:$WI^3oi\u0012\"WMZ1vYR$3'A\u0010nCR,'/[1mSj,'+\u001a;f]RLwN\\\"iC:<W-\u0012<f]R$b!!!\u0003P\ne\u0007b\u0002BiK\u0001\u0007!1[\u0001\u0015e\u0016$XM\u001c;j_:\u001c\u0005.\u00198hK\u00163XM\u001c;\u0011\t\u00055%Q[\u0005\u0005\u0005/\fyI\u0001\u000bSKR,g\u000e^5p]\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\u0005\b\u0003O+\u0003\u0019AAU\u0003ii\u0017\r^3sS\u0006d\u0017N_3EK2,G/\u001a)beRLG/[8o)\u0011\t\tIa8\t\u000f\t\u0005h\u00051\u0001\u0003d\u0006!B-\u001a7fi\u0016\u0004\u0016M\u001d;ji&|g.\u0012<f]R\u0004B!!$\u0003f&!!q]AH\u0005Q!U\r\\3uKB\u000b'\u000f^5uS>tWI^3oi\u0006)S.\u0019;fe&\fG.\u001b>f\u00072,8\u000f^3s\u0019&t7\u000e\u0016:v]\u000e\fG/[8o\u000bZ,g\u000e\u001e\u000b\t\u0003\u0003\u0013iOa>\u0003z\"9!q^\u0014A\u0002\tE\u0018AG2mkN$XM\u001d'j].$&/\u001e8dCRLwN\\#wK:$\b\u0003BAG\u0005gLAA!>\u0002\u0010\nQ2\t\\;ti\u0016\u0014H*\u001b8l)J,hnY1uS>tWI^3oi\"9\u0011qU\u0014A\u0002\u0005%\u0006\"CAYOA\u0005\t\u0019AA\u001b\u0003=j\u0017\r^3sS\u0006d\u0017N_3DYV\u001cH/\u001a:MS:\\GK];oG\u0006$\u0018n\u001c8Fm\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003\u0005j\u0017\r^3sS\u0006d\u0017N_3NSJ\u0014xN]*uCR,7\t[1oO\u0016,e/\u001a8u)!\t\ti!\u0001\u0004\f\r5\u0001bBB\u0002S\u0001\u00071QA\u0001\u0017[&\u0014(o\u001c:Ti\u0006$Xm\u00115b]\u001e,WI^3oiB!\u0011QRB\u0004\u0013\u0011\u0019I!a$\u0003-5K'O]8s'R\fG/Z\"iC:<W-\u0012<f]RDq!a**\u0001\u0004\tI\u000bC\u0005\u00022&\u0002\n\u00111\u0001\u00026\u0005YS.\u0019;fe&\fG.\u001b>f\u001b&\u0014(o\u001c:Ti\u0006$Xm\u00115b]\u001e,WI^3oi\u0012\"WMZ1vYR$3'\u0001\tnCR,'/[1mSj,7\u000b^1uKRA\u0011\u0011QB\u000b\u0007/\u0019I\u0002C\u0004\u0002(.\u0002\r!!+\t\u000f\u0005e8\u00061\u0001\u0002|\"911D\u0016A\u0002\tE\u0013\u0001\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8o\u0003I\u0019H/\u00197f)>\u0004\u0018nY%e\u000bZ,g\u000e^:\u0015\r\u0005]3\u0011EB\u0017\u0011\u001d\u0019\u0019\u0003\fa\u0001\u0007K\tQ!\u001a<f]R\u0004Baa\n\u0004*5\u0011\u0011qA\u0005\u0005\u0007W\t9AA\fBEN$(/Y2u\tV\u0014\u0018MY5mSRLXI^3oi\"9\u0011q\u0015\u0017A\u0002\u0005%\u0016!G2iK\u000e\\W*[:tS:<Gk\u001c9jG\u0012+G.\u001a;j_:$b!!!\u00044\rU\u0002bBB\u0012[\u0001\u00071Q\u0005\u0005\b\u0003Ok\u0003\u0019AAU\u0003EA\u0017M\u001c3mKN#\u0018\r\\3Fm\u0016tGo\u001d\u000b\t\u0003/\u001aYd!\u0010\u0004@!911\u0005\u0018A\u0002\r\u0015\u0002bBAT]\u0001\u0007\u0011\u0011\u0016\u0005\n\u0003cs\u0003\u0013!a\u0001\u0003k\t1\u0004[1oI2,7\u000b^1mK\u00163XM\u001c;tI\u0011,g-Y;mi\u0012\u001a\u0014!\t\"s_.,'\u000fR;sC\nLG.\u001b;z\u000bZ,g\u000e^:NCR,'/[1mSj,\u0007C\u0001 2'\r\t4\u0011\n\t\u0004Q\u000e-\u0013bAB'S\n1\u0011I\\=SK\u001a$\"a!\u0012\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\u0019)FK\u0002h\u0003\u001f\u0004")
public class BrokerDurabilityEventsMaterialize
extends AbstractDurabilityEventsMaterialize {
    private Logger logger;
    private final ReplicaManager replicaManager;
    private final AuditReporter reporter;
    private final Option<Set<Enumeration.Value>> ignoredEventTypesTobeLogged;
    private final BrokerValidator validator;
    private volatile boolean bitmap$0;

    public static Option<Set<Enumeration.Value>> $lessinit$greater$default$5() {
        return BrokerDurabilityEventsMaterialize$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public DurabilityDB db() {
        return super.db();
    }

    @Override
    public BrokerValidator validator() {
        return this.validator;
    }

    @Override
    public String loggerName() {
        return BrokerDurabilityEventsMaterialize.class.getName();
    }

    private Logger logger$lzycompute() {
        BrokerDurabilityEventsMaterialize brokerDurabilityEventsMaterialize = this;
        synchronized (brokerDurabilityEventsMaterialize) {
            if (!this.bitmap$0) {
                this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)this.getClass().getName()));
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public synchronized boolean materialize(ConsumerRecord<byte[], byte[]> record) {
        AbstractDurabilityEvent event = Deserializer$.MODULE$.deserialize((byte[])((byte[])record.key()).clone(), (byte[])((byte[])record.value()).clone());
        String metadata = "Durability audits topic " + Utils$.MODULE$.consumerRecordMetadata(record);
        this.reporter.addDAConsumerProcessedRecords(1L);
        AbstractDurabilityEvent abstractDurabilityEvent = event;
        if (abstractDurabilityEvent instanceof HealthCheckEvent) {
            HealthCheckEvent healthCheckEvent = (HealthCheckEvent)abstractDurabilityEvent;
            this.debug((Function0<String> & Serializable)() -> "DurabilityMaterialization: Materialization request for " + event.eventType() + " " + event);
            if (healthCheckEvent.nodeId() == Utils$.MODULE$.getBrokerId(this.replicaManager)) {
                this.materializeHealthCheck(healthCheckEvent);
            }
            return true;
        }
        if (abstractDurabilityEvent instanceof InjectStateEvent) {
            InjectStateEvent injectStateEvent = (InjectStateEvent)abstractDurabilityEvent;
            this.materializeInjectedState(injectStateEvent);
            return true;
        }
        Option<PartitionState> stateOpt = this.db().fetchPartitionState(event.topicIdPartition().topicPartition());
        if (stateOpt.isEmpty()) {
            if (this.ignoredEventTypesTobeLogged.exists((Function1<Set<Enumeration.Value>, Object>)(Function1<Set, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.contains(event.eventType())))) {
                this.info((Function0<String> & Serializable)() -> "Ignoring event " + event + ", since the local db state of the topic partition: " + event.topicIdPartition().topicPartition() + " is empty");
            }
            return false;
        }
        PartitionState state = stateOpt.get();
        if (event.epoch() == state.latestEpoch() && record.timestamp() < state.latestTimestamp()) {
            if (this.ignoredEventTypesTobeLogged.exists((Function1<Set<Enumeration.Value>, Object>)(Function1<Set, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(x$2.contains(event.eventType())))) {
                this.info((Function0<String> & Serializable)() -> "Ignoring event " + event + " with epoch " + event.epoch() + " as it's from retry and duplicate.Current state is: " + state + ", state ts: " + state.latestTimestamp() + ", record ts: " + record.timestamp());
            }
            this.debug((Function0<String> & Serializable)() -> "Ignoring event " + event + " with epoch " + event.epoch() + " as it's from retry and duplicate.Current epoch is " + state.latestEpoch() + " and state ts: " + state.latestTimestamp() + ", record ts: " + record.timestamp());
            return false;
        }
        this.checkMissingTopicDeletion(event, state);
        if (event.epoch() < state.latestEpoch() || this.staleTopicIdEvents(event, state)) {
            if (this.ignoredEventTypesTobeLogged.exists((Function1<Set<Enumeration.Value>, Object>)(Function1<Set, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(x$3.contains(event.eventType())))) {
                this.info((Function0<String> & Serializable)() -> "Ignoring event " + event + ". Current state is " + state);
            }
            this.debug((Function0<String> & Serializable)() -> "Ignoring event " + event + ". Current state is " + state);
            return this.handleStaleEvents(event, state, metadata);
        }
        state.latestTimestamp_$eq(record.timestamp());
        this.debug((Function0<String> & Serializable)() -> "DurabilityMaterialization: Materialization request for " + event.eventType() + " " + event + " for state: " + state);
        AbstractDurabilityEvent abstractDurabilityEvent2 = event;
        if (abstractDurabilityEvent2 instanceof OffsetChangeEvent) {
            OffsetChangeEvent offsetChangeEvent = (OffsetChangeEvent)abstractDurabilityEvent2;
            this.materializeOffsetChangeEvent(offsetChangeEvent, state, metadata);
        } else if (abstractDurabilityEvent2 instanceof DeleteRecordsEvent) {
            DeleteRecordsEvent deleteRecordsEvent = (DeleteRecordsEvent)abstractDurabilityEvent2;
            this.materializeDeleteRecordEvent(deleteRecordsEvent, state, metadata, false);
        } else if (abstractDurabilityEvent2 instanceof EpochChangeEvent) {
            EpochChangeEvent epochChangeEvent = (EpochChangeEvent)abstractDurabilityEvent2;
            this.materializeEpochChangeEvent(epochChangeEvent, state, metadata);
        } else if (abstractDurabilityEvent2 instanceof IsrExpandEvent) {
            IsrExpandEvent isrExpandEvent = (IsrExpandEvent)abstractDurabilityEvent2;
            this.materializeISRExpandEvent(isrExpandEvent, state, metadata);
        } else if (abstractDurabilityEvent2 instanceof RetentionChangeEvent) {
            RetentionChangeEvent retentionChangeEvent = (RetentionChangeEvent)abstractDurabilityEvent2;
            this.materializeRetentionChangeEvent(retentionChangeEvent, state);
        } else if (abstractDurabilityEvent2 instanceof StartOffsetChangeEvent) {
            StartOffsetChangeEvent startOffsetChangeEvent = (StartOffsetChangeEvent)abstractDurabilityEvent2;
            this.materializeStartOffset(startOffsetChangeEvent, state, metadata, true);
        } else {
            if (abstractDurabilityEvent2 instanceof DeletePartitionEvent) {
                DeletePartitionEvent deletePartitionEvent = (DeletePartitionEvent)abstractDurabilityEvent2;
                this.materializeDeletePartition(deletePartitionEvent);
                this.debug((Function0<String> & Serializable)() -> "DurabilityMaterialization: Materialization done for " + event + " " + state + " " + metadata);
                return true;
            }
            if (abstractDurabilityEvent2 instanceof AbstractControllerDurabilityEvent) {
                this.debug((Function0<String> & Serializable)() -> "Broker materialization rejected for ControllerDurabilityEvent " + event);
                return false;
            }
            if (abstractDurabilityEvent2 instanceof ClusterLinkTruncationEvent) {
                ClusterLinkTruncationEvent clusterLinkTruncationEvent = (ClusterLinkTruncationEvent)abstractDurabilityEvent2;
                this.materializeClusterLinkTruncationEvent(clusterLinkTruncationEvent, state, this.materializeClusterLinkTruncationEvent$default$3());
            } else if (abstractDurabilityEvent2 instanceof MirrorStateChangeEvent) {
                MirrorStateChangeEvent mirrorStateChangeEvent = (MirrorStateChangeEvent)abstractDurabilityEvent2;
                this.materializeMirrorStateChangeEvent(mirrorStateChangeEvent, state, metadata);
            } else if (abstractDurabilityEvent2 instanceof DestLogEpochChangeEvent) {
                DestLogEpochChangeEvent destLogEpochChangeEvent = (DestLogEpochChangeEvent)abstractDurabilityEvent2;
                this.materializeDestLogEpochChangeEvent(destLogEpochChangeEvent, state, metadata);
            } else {
                this.warn((Function0<String> & Serializable)() -> "DurabilityMaterialization: Ignoring unexpected durability event type " + event.eventType() + ": " + event + ", " + metadata);
                return false;
            }
        }
        this.materializeState(state, event.epoch(), event.topicIdPartition());
        this.db().addPartition(event.topicIdPartition().topicPartition(), state);
        if (this.ignoredEventTypesTobeLogged.exists((Function1<Set<Enumeration.Value>, Object>)(Function1<Set, Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(x$4.contains(event.eventType())))) {
            this.info((Function0<String> & Serializable)() -> "DurabilityMaterialization: Materialization done for " + event + " " + state);
        }
        this.debug((Function0<String> & Serializable)() -> "DurabilityMaterialization: Materialization done for " + event + " " + state);
        return true;
    }

    private void materializeInjectedState(InjectStateEvent injectStateEvent) {
        Option<PartitionState> stateOpt = this.db().fetchPartitionState(injectStateEvent.topicIdPartition().topicPartition());
        if (stateOpt.isEmpty()) {
            return;
        }
        PartitionState state = stateOpt.get();
        if (injectStateEvent.removePartition()) {
            this.db().deletePartition(injectStateEvent.topicIdPartition().topicPartition());
            v0 = BoxedUnit.UNIT;
        } else {
            if (injectStateEvent.epoch() != -1) {
                state.latestEpoch_$eq(injectStateEvent.epoch());
            }
            if (injectStateEvent.highWatermark() != -1L) {
                state.highWatermark_$eq(injectStateEvent.highWatermark());
            }
            if (injectStateEvent.logStartOffset() != -1L) {
                state.committedStartOffset_$eq(injectStateEvent.logStartOffset());
                state.startOffset_$eq(injectStateEvent.logStartOffset());
            }
            if (injectStateEvent.config() != -1L) {
                state.config_$eq(injectStateEvent.config());
            }
            v0 = this.db().addPartition(injectStateEvent.topicIdPartition().topicPartition(), state);
        }
        this.info((Function0<String> & Serializable)() -> "Updated the durabilityDB due to injected Event " + injectStateEvent + " with new state " + state);
    }

    private void materializeOffsetChangeEvent(OffsetChangeEvent offsetChangeEvent, PartitionState state, String metadata) {
        this.materializeHighWatermarkChanges(offsetChangeEvent.topicIdPartition().topicPartition(), offsetChangeEvent.epoch(), offsetChangeEvent.highWatermark(), offsetChangeEvent.isr(), state, metadata, this.materializeHighWatermarkChanges$default$7(), this.materializeHighWatermarkChanges$default$8(), this.materializeHighWatermarkChanges$default$9());
        this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(offsetChangeEvent.topicIdPartition(), offsetChangeEvent.epoch(), offsetChangeEvent.logStartOffset(), offsetChangeEvent.highWatermark(), offsetChangeEvent.nodeId(), offsetChangeEvent.isr()), state, metadata, this.materializeStartOffset$default$4());
    }

    public void materializeDeleteRecordEvent(DeleteRecordsEvent deleteRecordsEvent, PartitionState state, String metadata, boolean updateOnlyCommitStartOffset) {
        state.committedStartOffset_$eq(Math.max(state.committedStartOffset(), deleteRecordsEvent.trimOffset()));
        state.lapseWatchStartTime_$eq(0L);
        if (updateOnlyCommitStartOffset) {
            return;
        }
        this.materializeHighWatermarkChanges(deleteRecordsEvent.topicIdPartition().topicPartition(), deleteRecordsEvent.epoch(), deleteRecordsEvent.highWatermark(), deleteRecordsEvent.isr(), state, metadata, this.materializeHighWatermarkChanges$default$7(), this.materializeHighWatermarkChanges$default$8(), this.materializeHighWatermarkChanges$default$9());
        this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(deleteRecordsEvent.topicIdPartition(), deleteRecordsEvent.epoch(), deleteRecordsEvent.logStartOffset(), deleteRecordsEvent.highWatermark(), deleteRecordsEvent.nodeId(), this.makeGenericStartOffsetChangeEvent$default$6()), state, metadata, this.materializeStartOffset$default$4());
    }

    public String materializeDeleteRecordEvent$default$3() {
        return "";
    }

    public boolean materializeDeleteRecordEvent$default$4() {
        return false;
    }

    public void materializeHighWatermarkChanges(TopicPartition topicPartition, int epoch, long hwm, Set<Object> isr, PartitionState state, String metadata, boolean triggeredByEpochChange, boolean triggeredByMirrorStateChange, String mirrorStateFromEvent) {
        this.validator().validateDBHighWatermark(topicPartition, epoch, hwm, state, metadata, triggeredByEpochChange, triggeredByMirrorStateChange, mirrorStateFromEvent);
        if (this.validator().isInISR(topicPartition)) {
            this.validator().validateLocalLogEndOffset(topicPartition, epoch, hwm, isr, state, metadata);
        }
        if (hwm < state.highWatermark() && !state.mirrorCacheEpochChain().isEmpty()) {
            this.truncateFromEnd(hwm, state.mirrorCacheEpochChain());
        }
        state.highWatermark_$eq(hwm);
    }

    public String materializeHighWatermarkChanges$default$6() {
        return "";
    }

    public boolean materializeHighWatermarkChanges$default$7() {
        return false;
    }

    public boolean materializeHighWatermarkChanges$default$8() {
        return false;
    }

    public String materializeHighWatermarkChanges$default$9() {
        return "";
    }

    public void truncateFromEnd(long hwm, HashMap<Object, Object> mirrorCacheEpochChain) {
        if (mirrorCacheEpochChain.size() > 0 && ((Tuple2)mirrorCacheEpochChain.max(Ordering$.MODULE$.Tuple2(Ordering.Int$.MODULE$, Ordering.Long$.MODULE$)))._2$mcJ$sp() >= hwm) {
            List sortedEpochChainList = (List)mirrorCacheEpochChain.toList().sortWith((Function2<Tuple2, Tuple2, Object> & Serializable)(cur, next) -> BoxesRunTime.boxToBoolean(BrokerDurabilityEventsMaterialize.$anonfun$truncateFromEnd$1(cur, next)));
            BufferedIterator iterator = sortedEpochChainList.iterator().buffered();
            boolean continueLoop = true;
            while (iterator.hasNext() && continueLoop) {
                Serializable serializable;
                Tuple2 tuple2 = (Tuple2)iterator.next();
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                int curEpoch = tuple2._1$mcI$sp();
                long curFirstOffset = tuple2._2$mcJ$sp();
                Tuple2$mcIJ$sp tuple2$mcIJ$sp = new Tuple2$mcIJ$sp(curEpoch, curFirstOffset);
                int curEpoch2 = ((Tuple2)tuple2$mcIJ$sp)._1$mcI$sp();
                long curFirstOffset2 = ((Tuple2)tuple2$mcIJ$sp)._2$mcJ$sp();
                if (curFirstOffset2 >= hwm) {
                    serializable = mirrorCacheEpochChain.remove(BoxesRunTime.boxToInteger(curEpoch2));
                    continue;
                }
                continueLoop = false;
                serializable = BoxedUnit.UNIT;
            }
            return;
        }
    }

    private StartOffsetChangeEvent makeGenericStartOffsetChangeEvent(TopicIdPartition id, int epoch, long startOffset, long hwm, int nodeId, Set<Object> isr) {
        return StartOffsetChangeEvent$.MODULE$.apply(id, epoch, hwm, startOffset, (byte)RetentionType$.MODULE$.Other().id(), -1L, isr, nodeId);
    }

    private Set<Object> makeGenericStartOffsetChangeEvent$default$6() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-1}));
    }

    public void materializeStartOffset(StartOffsetChangeEvent startOffsetChangeEvent, PartitionState state, String metadata, boolean validateHWM) {
        if (this.validator().isInSync(startOffsetChangeEvent.isr()) && state.committedStartOffset() < startOffsetChangeEvent.logStartOffset() && this.validator().validateDBLogStartOffset(startOffsetChangeEvent, state, metadata)) {
            this.validator().validateLocalLogStartOffset(startOffsetChangeEvent.topicIdPartition(), state.mirrorState(), startOffsetChangeEvent.logStartOffset(), metadata);
            state.committedStartOffset_$eq(startOffsetChangeEvent.logStartOffset());
            state.lapseWatchStartTime_$eq(0L);
        }
        if (state.startOffset() <= 0L) {
            state.committedStartOffset_$eq(Math.max(startOffsetChangeEvent.logStartOffset(), state.committedStartOffset()));
            state.lapseWatchStartTime_$eq(0L);
        }
        if (validateHWM) {
            this.materializeHighWatermarkChanges(startOffsetChangeEvent.topicIdPartition().topicPartition(), startOffsetChangeEvent.epoch(), startOffsetChangeEvent.highWatermark(), startOffsetChangeEvent.isr(), state, metadata, this.materializeHighWatermarkChanges$default$7(), this.materializeHighWatermarkChanges$default$8(), this.materializeHighWatermarkChanges$default$9());
        }
        state.startOffset_$eq(startOffsetChangeEvent.logStartOffset());
        Enumeration.Value value = RetentionType$.MODULE$.apply(startOffsetChangeEvent.retentionType());
        Enumeration.Value value2 = RetentionType$.MODULE$.SizeBasedRetention();
        if (!(value != null ? !((Object)value).equals(value2) : value2 != null)) {
            state.retentionSz_$eq(startOffsetChangeEvent.retentionValue());
            return;
        }
        Enumeration.Value value3 = RetentionType$.MODULE$.apply(startOffsetChangeEvent.retentionType());
        Enumeration.Value value4 = RetentionType$.MODULE$.TimeBasedRetention();
        if (!(value3 != null ? !((Object)value3).equals(value4) : value4 != null)) {
            state.retentionMs_$eq(startOffsetChangeEvent.retentionValue());
            return;
        }
    }

    public String materializeStartOffset$default$3() {
        return "";
    }

    public boolean materializeStartOffset$default$4() {
        return false;
    }

    public void materializeEpochChangeEvent(EpochChangeEvent epochChangeEvent, PartitionState state, String metadata) {
        this.validator().validateDBEpochChange(epochChangeEvent, state, metadata);
        this.materializeHighWatermarkChanges(epochChangeEvent.topicIdPartition().topicPartition(), epochChangeEvent.epoch(), epochChangeEvent.highWatermark(), epochChangeEvent.isr(), state, metadata, true, this.materializeHighWatermarkChanges$default$8(), this.materializeHighWatermarkChanges$default$9());
        this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(epochChangeEvent.topicIdPartition(), epochChangeEvent.epoch(), epochChangeEvent.logStartOffset(), epochChangeEvent.highWatermark(), epochChangeEvent.nodeId(), epochChangeEvent.isr()), state, metadata, this.materializeStartOffset$default$4());
        this.validator().validateEpochChangeWithLocal(epochChangeEvent, state.mirrorState(), metadata);
        state.epochChain().put(BoxesRunTime.boxToInteger(epochChangeEvent.epoch()), BoxesRunTime.boxToLong(epochChangeEvent.firstOffset()));
        Serializable serializable = state.clusterLinkMirrorState().exists((Function1<DurabilityAuditMirrorState, Object> & Serializable)x$6 -> BoxesRunTime.boxToBoolean(BrokerDurabilityEventsMaterialize.$anonfun$materializeEpochChangeEvent$1(x$6))) && !state.mirrorCacheEpochChain().contains(BoxesRunTime.boxToInteger(epochChangeEvent.epoch())) ? state.mirrorCacheEpochChain().put(BoxesRunTime.boxToInteger(epochChangeEvent.epoch()), BoxesRunTime.boxToLong(epochChangeEvent.firstOffset())) : BoxedUnit.UNIT;
        this.truncateEpochChain(state);
    }

    public String materializeEpochChangeEvent$default$3() {
        return "";
    }

    public void materializeDestLogEpochChangeEvent(DestLogEpochChangeEvent destLogEpochChangeEvent, PartitionState state, String metadata) {
        this.materializeHighWatermarkChanges(destLogEpochChangeEvent.topicIdPartition().topicPartition(), destLogEpochChangeEvent.epoch(), destLogEpochChangeEvent.highWatermark(), destLogEpochChangeEvent.isr(), state, metadata, this.materializeHighWatermarkChanges$default$7(), this.materializeHighWatermarkChanges$default$8(), this.materializeHighWatermarkChanges$default$9());
        this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(destLogEpochChangeEvent.topicIdPartition(), destLogEpochChangeEvent.epoch(), destLogEpochChangeEvent.logStartOffset(), destLogEpochChangeEvent.highWatermark(), destLogEpochChangeEvent.nodeId(), destLogEpochChangeEvent.isr()), state, metadata, this.materializeStartOffset$default$4());
        this.validator().validateDestLogEpochChangeWithLocal(destLogEpochChangeEvent, state, metadata);
        Serializable serializable = !state.mirrorCacheEpochChain().contains(BoxesRunTime.boxToInteger(destLogEpochChangeEvent.destLogEpoch())) ? state.mirrorCacheEpochChain().put(BoxesRunTime.boxToInteger(destLogEpochChangeEvent.destLogEpoch()), BoxesRunTime.boxToLong(destLogEpochChangeEvent.firstOffset())) : BoxedUnit.UNIT;
        this.truncateEpochChain(state);
    }

    public String materializeDestLogEpochChangeEvent$default$3() {
        return "";
    }

    public void truncateEpochChain(PartitionState state) {
        this.doTruncateEpochChain(state.startOffset(), state.epochChain());
        if (state.mirrorState().isDefined()) {
            this.doTruncateEpochChain(state.startOffset(), state.mirrorCacheEpochChain());
            return;
        }
    }

    public void doTruncateEpochChain(long startOffset, HashMap<Object, Object> epochChain) {
        if (epochChain.size() > 2 && ((Tuple2)epochChain.min(Ordering$.MODULE$.Tuple2(Ordering.Int$.MODULE$, Ordering.Long$.MODULE$)))._2$mcJ$sp() < startOffset) {
            List sortedEpochChainList = (List)epochChain.toList().sortWith((Function2<Tuple2, Tuple2, Object> & Serializable)(cur, next) -> BoxesRunTime.boxToBoolean(BrokerDurabilityEventsMaterialize.$anonfun$doTruncateEpochChain$1(cur, next)));
            BufferedIterator iterator = sortedEpochChainList.iterator().buffered();
            boolean continueLoop = true;
            while (iterator.hasNext() && continueLoop) {
                Serializable serializable;
                Tuple2 tuple2 = (Tuple2)iterator.next();
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                int curEpoch = tuple2._1$mcI$sp();
                long curFirstOffset = tuple2._2$mcJ$sp();
                Tuple2$mcIJ$sp tuple2$mcIJ$sp = new Tuple2$mcIJ$sp(curEpoch, curFirstOffset);
                int curEpoch2 = ((Tuple2)tuple2$mcIJ$sp)._1$mcI$sp();
                long curFirstOffset2 = ((Tuple2)tuple2$mcIJ$sp)._2$mcJ$sp();
                if (iterator.hasNext()) {
                    Tuple2 tuple22 = (Tuple2)iterator.head();
                    if (tuple22 == null) {
                        throw new MatchError(tuple22);
                    }
                    int nextEpoch = tuple22._1$mcI$sp();
                    long nextFirstOffset = tuple22._2$mcJ$sp();
                    Tuple2$mcIJ$sp tuple2$mcIJ$sp2 = new Tuple2$mcIJ$sp(nextEpoch, nextFirstOffset);
                    int nextEpoch2 = ((Tuple2)tuple2$mcIJ$sp2)._1$mcI$sp();
                    long nextFirstOffset2 = ((Tuple2)tuple2$mcIJ$sp2)._2$mcJ$sp();
                    if (curEpoch2 < nextEpoch2 && curFirstOffset2 <= nextFirstOffset2) {
                        if (curFirstOffset2 < startOffset && nextFirstOffset2 < startOffset) {
                            serializable = epochChain.remove(BoxesRunTime.boxToInteger(curEpoch2));
                            continue;
                        }
                        continueLoop = false;
                        serializable = BoxedUnit.UNIT;
                        continue;
                    }
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Epoch chain map is not in the sorted order: \ncurrent (Epoch, firstOffset) are (" + curEpoch2 + ", " + curFirstOffset2 + ")\nnext (Epoch, firstOffset) are (" + nextEpoch2 + ", " + nextFirstOffset2 + ")");
                        v1 = BoxedUnit.UNIT;
                    } else {
                        v1 = BoxedUnit.UNIT;
                    }
                    continueLoop = false;
                    serializable = BoxedUnit.UNIT;
                    continue;
                }
                serializable = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void materializeISRExpandEvent(IsrExpandEvent isrExpandEvent, PartitionState state, String metadata) {
        if (Utils$.MODULE$.getBrokerId(this.replicaManager) != isrExpandEvent.expandBrokerId()) {
            return;
        }
        this.validator().validateEpochChainWithLocal(isrExpandEvent.topicIdPartition().topicPartition(), state, metadata);
    }

    public String materializeISRExpandEvent$default$3() {
        return "";
    }

    public void materializeRetentionChangeEvent(RetentionChangeEvent retentionChangeEvent, PartitionState state) {
        if (retentionChangeEvent.timeMs() != state.retentionMs() || retentionChangeEvent.size() != state.retentionSz()) {
            state.committedStartOffset_$eq(Math.max(state.committedStartOffset(), state.startOffset()));
            state.lapseWatchStartTime_$eq(0L);
            state.retentionSz_$eq(retentionChangeEvent.size());
            state.retentionMs_$eq(retentionChangeEvent.timeMs());
        }
        if (retentionChangeEvent.isCompacted()) {
            state.config_$eq(state.config() | (long)ConfigFlag$.MODULE$.OnceCompacted().id());
        }
        if (retentionChangeEvent.isIndependentRetentionMirror()) {
            state.config_$eq(state.config() | (long)ConfigFlag$.MODULE$.OnceIndependentRetentionMirror().id());
            return;
        }
    }

    public void materializeDeletePartition(DeletePartitionEvent deletePartitionEvent) {
        this.db().deletePartition(deletePartitionEvent.topicIdPartition().topicPartition());
    }

    public void materializeClusterLinkTruncationEvent(ClusterLinkTruncationEvent clusterLinkTruncationEvent, PartitionState state2, String metadata) {
        boolean bl = false;
        Some some = null;
        Option<Enumeration.Value> option = Option$.MODULE$.apply(ClusterLinkTruncationEvent$TruncationType$.MODULE$.apply(clusterLinkTruncationEvent.truncationType()));
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Enumeration.Value value = (Enumeration.Value)some.value();
            Enumeration.Value value2 = ClusterLinkTruncationEvent$TruncationType$.MODULE$.TruncateHWM();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !((Object)value2).equals(value3) : value3 != null)) {
                long truncateOffsetTo;
                if (state2.clusterLinkMirrorState().exists((Function1<DurabilityAuditMirrorState, Object> & Serializable)state -> BoxesRunTime.boxToBoolean(state.isTruncationBelowHighWatermarkAllowed())) && (truncateOffsetTo = clusterLinkTruncationEvent.truncateOffsetTo()) < state2.highWatermark()) {
                    state2.highWatermark_$eq(truncateOffsetTo);
                }
                this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(clusterLinkTruncationEvent.topicIdPartition(), clusterLinkTruncationEvent.epoch(), clusterLinkTruncationEvent.logStartOffset(), clusterLinkTruncationEvent.highWatermark(), clusterLinkTruncationEvent.nodeId(), clusterLinkTruncationEvent.isr()), state2, metadata, this.materializeStartOffset$default$4());
                return;
            }
        }
        if (bl) {
            Enumeration.Value value = (Enumeration.Value)some.value();
            Enumeration.Value value4 = ClusterLinkTruncationEvent$TruncationType$.MODULE$.TruncateLSO();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !((Object)value4).equals(value5) : value5 != null)) {
                state2.committedStartOffset_$eq(package$.MODULE$.max(state2.committedStartOffset(), clusterLinkTruncationEvent.truncateOffsetTo()));
                state2.lapseWatchStartTime_$eq(0L);
                this.materializeHighWatermarkChanges(clusterLinkTruncationEvent.topicIdPartition().topicPartition(), clusterLinkTruncationEvent.epoch(), clusterLinkTruncationEvent.highWatermark(), clusterLinkTruncationEvent.isr(), state2, metadata, this.materializeHighWatermarkChanges$default$7(), this.materializeHighWatermarkChanges$default$8(), this.materializeHighWatermarkChanges$default$9());
                this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(clusterLinkTruncationEvent.topicIdPartition(), clusterLinkTruncationEvent.epoch(), clusterLinkTruncationEvent.logStartOffset(), clusterLinkTruncationEvent.highWatermark(), clusterLinkTruncationEvent.nodeId(), this.makeGenericStartOffsetChangeEvent$default$6()), state2, metadata, this.materializeStartOffset$default$4());
                return;
            }
        }
    }

    public String materializeClusterLinkTruncationEvent$default$3() {
        return "";
    }

    public void materializeMirrorStateChangeEvent(MirrorStateChangeEvent mirrorStateChangeEvent, PartitionState state, String metadata) {
        TopicPartition x$1 = mirrorStateChangeEvent.topicIdPartition().topicPartition();
        int x$2 = mirrorStateChangeEvent.epoch();
        long x$3 = mirrorStateChangeEvent.highWatermark();
        Set<Object> x$4 = mirrorStateChangeEvent.isr();
        PartitionState x$5 = state;
        String x$6 = metadata;
        boolean x$7 = true;
        String x$8 = (String)mirrorStateChangeEvent.mirrorState().getOrElse((Function0<String> & Serializable)() -> "");
        boolean x$9 = this.materializeHighWatermarkChanges$default$7();
        this.materializeHighWatermarkChanges(x$1, x$2, x$3, x$4, x$5, x$6, x$9, true, x$8);
        this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(mirrorStateChangeEvent.topicIdPartition(), mirrorStateChangeEvent.epoch(), mirrorStateChangeEvent.logStartOffset(), mirrorStateChangeEvent.highWatermark(), mirrorStateChangeEvent.nodeId(), mirrorStateChangeEvent.isr()), state, metadata, this.materializeStartOffset$default$4());
        state.mirrorState_$eq(mirrorStateChangeEvent.mirrorState());
    }

    public String materializeMirrorStateChangeEvent$default$3() {
        return "";
    }

    private void materializeState(PartitionState state, int epoch, TopicIdPartition topicIdPartition) {
        if (epoch != -1) {
            state.latestEpoch_$eq(epoch);
        }
        state.topicId_$eq(topicIdPartition.topicId());
    }

    public boolean staleTopicIdEvents(AbstractDurabilityEvent event, PartitionState state) {
        Uuid uuid = state.topicId();
        Uuid uuid2 = Uuid.ZERO_UUID;
        if (uuid == null ? uuid2 != null : !uuid.equals(uuid2)) {
            Uuid uuid3 = event.topicIdPartition().topicId();
            Uuid uuid4 = Uuid.ZERO_UUID;
            if (!(uuid3 != null ? !uuid3.equals(uuid4) : uuid4 != null)) {
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public void checkMissingTopicDeletion(AbstractDurabilityEvent event, PartitionState state) {
        reset = false;
        v0 = state.topicId();
        var5_4 = Uuid.ZERO_UUID;
        if (!(v0 == null ? var5_4 != null : v0.equals(var5_4) == false)) ** GOTO lbl-1000
        v1 = event.topicIdPartition().topicId();
        var6_5 = Uuid.ZERO_UUID;
        if (!(v1 == null ? var6_5 != null : v1.equals(var6_5) == false)) ** GOTO lbl-1000
        v2 = event.topicIdPartition().topicId();
        var7_6 = state.topicId();
        if (v2 == null ? var7_6 != null : v2.equals(var7_6) == false) {
            reset = true;
        } else lbl-1000:
        // 3 sources

        {
            v3 = (var8_7 = event) instanceof EpochChangeEvent ? (var9_8 = (EpochChangeEvent)var8_7).epoch() == 0 && var9_8.firstOffset() == 0L && var9_8.highWatermark() <= 0L : (reset = false);
        }
        if (reset) {
            this.info((Function0<String> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$checkMissingTopicDeletion$1(kafka.durability.events.AbstractDurabilityEvent kafka.durability.db.PartitionState ), ()Ljava/lang/String;)((AbstractDurabilityEvent)event, (PartitionState)state));
            state.reset();
            state.topicId_$eq(event.topicIdPartition().topicId());
            this.reporter.resetTopicPartition(event.topicIdPartition().topicPartition());
            return;
        }
    }

    public boolean handleStaleEvents(AbstractDurabilityEvent event, PartitionState state, String metadata) {
        AbstractDurabilityEvent abstractDurabilityEvent = event;
        if (abstractDurabilityEvent instanceof DeleteRecordsEvent) {
            DeleteRecordsEvent deleteRecordsEvent = (DeleteRecordsEvent)abstractDurabilityEvent;
            this.materializeDeleteRecordEvent(deleteRecordsEvent, state, metadata, true);
            return true;
        }
        return false;
    }

    public String handleStaleEvents$default$3() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$truncateFromEnd$1(Tuple2 cur, Tuple2 next) {
        return cur._1$mcI$sp() > next._1$mcI$sp();
    }

    public static final /* synthetic */ boolean $anonfun$materializeEpochChangeEvent$1(DurabilityAuditMirrorState x$6) {
        return !x$6.isReadOnly();
    }

    public static final /* synthetic */ boolean $anonfun$doTruncateEpochChain$1(Tuple2 cur, Tuple2 next) {
        return cur._1$mcI$sp() < next._1$mcI$sp();
    }

    public static final /* synthetic */ String $anonfun$checkMissingTopicDeletion$1(AbstractDurabilityEvent event$2, PartitionState state$3) {
        return "Durability partition reset for " + event$2 + " old topicID " + state$3.topicId();
    }

    public BrokerDurabilityEventsMaterialize(ReplicaManager replicaManager, DurabilityDB db, AuditReporter reporter, Time time, Option<Set<Enumeration.Value>> ignoredEventTypesTobeLogged) {
        this.replicaManager = replicaManager;
        this.reporter = reporter;
        this.ignoredEventTypesTobeLogged = ignoredEventTypesTobeLogged;
        super(db, reporter, time);
        this.validator = new BrokerValidator(replicaManager, reporter, time);
    }
}

