/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.materialization;

import java.io.Serializable;
import kafka.durability.Utils$;
import kafka.durability.audit.AuditReporter;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.kraft.KRaftPartitionState;
import kafka.durability.db.kraft.KRaftPartitionState$;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.Deserializer$;
import kafka.durability.events.HealthCheckEvent;
import kafka.durability.events.broker.AbstractBrokerDurabilityEvent;
import kafka.durability.events.controller.kraft.AbstractKRaftDurabilityEvent;
import kafka.durability.events.controller.kraft.KRaftHWMChangeEvent;
import kafka.durability.events.controller.kraft.KRaftLeaderChangeEvent;
import kafka.durability.events.controller.kraft.KRaftLogSnapshotGenerationEvent;
import kafka.durability.events.controller.kraft.KRaftLogStartOffsetChangeEvent;
import kafka.durability.events.controller.kraft.KRaftNodeStartUpEvent;
import kafka.durability.materialization.AbstractDurabilityEventsMaterialize;
import kafka.durability.materialization.validation.ControllerValidator;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.OffsetAndEpoch;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005ef\u0001B\n\u0015\u0001mA\u0001\u0002\t\u0001\u0003\u0006\u0004%\t%\t\u0005\nO\u0001\u0011\t\u0011)A\u0005E!B\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005c!)a\b\u0001C\u0001\u007f!AA\t\u0001b\u0001\n\u0003\"R\t\u0003\u0004M\u0001\u0001\u0006IA\u0012\u0005\u0006\u001b\u0002!\tE\u0014\u0005\u00069\u0002!\t%\u0018\u0005\u0006e\u0002!Ia\u001d\u0005\b\u0003K\u0001A\u0011BA\u0014\u0011\u001d\ti\u0004\u0001C\u0005\u0003\u007fAq!!\u0016\u0001\t\u0013\t9\u0006C\u0004\u0002n\u0001!I!a\u001c\t\u000f\u0005\u0015\u0005\u0001\"\u0003\u0002\b\"9\u0011Q\u0013\u0001\u0005\u0002\u0005]\u0005bBAS\u0001\u0011%\u0011q\u0015\u0005\b\u0003W\u0003A\u0011BAW\u0005\u0015\u001auN\u001c;s_2dWM\u001d#ve\u0006\u0014\u0017\u000e\\5us\u00163XM\u001c;t\u001b\u0006$XM]5bY&TXM\u0003\u0002\u0016-\u0005yQ.\u0019;fe&\fG.\u001b>bi&|gN\u0003\u0002\u00181\u0005QA-\u001e:bE&d\u0017\u000e^=\u000b\u0003e\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00019A\u0011QDH\u0007\u0002)%\u0011q\u0004\u0006\u0002$\u0003\n\u001cHO]1di\u0012+(/\u00192jY&$\u00180\u0012<f]R\u001cX*\u0019;fe&\fG.\u001b>f\u0003\t!'-F\u0001#!\t\u0019S%D\u0001%\u0015\t\u0001c#\u0003\u0002'I\taA)\u001e:bE&d\u0017\u000e^=E\u0005\u0006\u0019AM\u0019\u0011\n\u0005\u0001r\u0012\u0001\u0003:fa>\u0014H/\u001a:\u0011\u0005-rS\"\u0001\u0017\u000b\u000552\u0012!B1vI&$\u0018BA\u0018-\u00055\tU\u000fZ5u%\u0016\u0004xN\u001d;fe\u0006!A/[7f!\t\u0011D(D\u00014\u0015\t!T'A\u0003vi&d7O\u0003\u00027o\u000511m\\7n_:T!!\u0007\u001d\u000b\u0005eR\u0014AB1qC\u000eDWMC\u0001<\u0003\ry'oZ\u0005\u0003{M\u0012A\u0001V5nK\u00061A(\u001b8jiz\"B\u0001Q!C\u0007B\u0011Q\u0004\u0001\u0005\u0006A\u0015\u0001\rA\t\u0005\u0006S\u0015\u0001\rA\u000b\u0005\u0006a\u0015\u0001\r!M\u0001\nm\u0006d\u0017\u000eZ1u_J,\u0012A\u0012\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013R\t!B^1mS\u0012\fG/[8o\u0013\tY\u0005JA\nD_:$(o\u001c7mKJ4\u0016\r\\5eCR|'/\u0001\u0006wC2LG-\u0019;pe\u0002\n!\u0002\\8hO\u0016\u0014h*Y7f+\u0005y\u0005C\u0001)Z\u001d\t\tv\u000b\u0005\u0002S+6\t1K\u0003\u0002U5\u00051AH]8pizR\u0011AV\u0001\u0006g\u000e\fG.Y\u0005\u00031V\u000ba\u0001\u0015:fI\u00164\u0017B\u0001.\\\u0005\u0019\u0019FO]5oO*\u0011\u0001,V\u0001\f[\u0006$XM]5bY&TX\r\u0006\u0002_EB\u0011q\fY\u0007\u0002+&\u0011\u0011-\u0016\u0002\b\u0005>|G.Z1o\u0011\u0015\u0019\u0017\u00021\u0001e\u0003\u0019\u0011XmY8sIB!QM\u001b7m\u001b\u00051'BA4i\u0003!\u0019wN\\:v[\u0016\u0014(BA58\u0003\u001d\u0019G.[3oiNL!a\u001b4\u0003\u001d\r{gn];nKJ\u0014VmY8sIB\u0019q,\\8\n\u00059,&!B!se\u0006L\bCA0q\u0013\t\tXK\u0001\u0003CsR,\u0017!I7bi\u0016\u0014\u0018.\u00197ju\u0016\\%+\u00194u\u0019\u0016\fG-\u001a:DQ\u0006tw-Z#wK:$H\u0003\u0004;x\u0003\u000f\t)\"!\u0007\u0002\u001e\u0005\u0005\u0002CA0v\u0013\t1XK\u0001\u0003V]&$\b\"\u0002=\u000b\u0001\u0004I\u0018!\u00057fC\u0012,'o\u00115b]\u001e,WI^3oiB\u0019!0a\u0001\u000e\u0003mT!\u0001`?\u0002\u000b-\u0014\u0018M\u001a;\u000b\u0005y|\u0018AC2p]R\u0014x\u000e\u001c7fe*\u0019\u0011\u0011\u0001\f\u0002\r\u00154XM\u001c;t\u0013\r\t)a\u001f\u0002\u0017\u0017J\u000bg\r\u001e'fC\u0012,'o\u00115b]\u001e,WI^3oi\"9\u0011\u0011\u0002\u0006A\u0002\u0005-\u0011aF6SC\u001a$\b+\u0019:uSRLwN\\*uCR,\u0017J\u001c#C!\u0011\ti!!\u0005\u000e\u0005\u0005=!B\u0001?%\u0013\u0011\t\u0019\"a\u0004\u0003'-\u0013\u0016M\u001a;QCJ$\u0018\u000e^5p]N#\u0018\r^3\t\r\u0005]!\u00021\u0001_\u0003I)g/\u001a8u\rJ|W\u000eT8dC2tu\u000eZ3\t\r\u0005m!\u00021\u0001_\u0003YI7O\u0012:p[6{7\u000f\u001e*fG\u0016tG\u000fT3bI\u0016\u0014\bBBA\u0010\u0015\u0001\u0007q*\u0001\u0005nKR\fG-\u0019;b\u0011\u0019\t\u0019C\u0003a\u0001=\u00069\u0011n]*uC2,\u0017AH7bi\u0016\u0014\u0018.\u00197ju\u0016\\%+\u00194u\u0011^k5\t[1oO\u0016,e/\u001a8u)5!\u0018\u0011FA\u001a\u0003k\t9$!\u000f\u0002<!9\u00111F\u0006A\u0002\u00055\u0012A\u00045X\u001b\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\t\u0004u\u0006=\u0012bAA\u0019w\n\u00192JU1gi\";Vj\u00115b]\u001e,WI^3oi\"9\u0011\u0011B\u0006A\u0002\u0005-\u0001BBA\f\u0017\u0001\u0007a\f\u0003\u0004\u0002\u001c-\u0001\rA\u0018\u0005\u0007\u0003?Y\u0001\u0019A(\t\r\u0005\r2\u00021\u0001_\u0003%j\u0017\r^3sS\u0006d\u0017N_3L%\u00064G\u000fT8h'R\f'\u000f^(gMN,Go\u00115b]\u001e,WI^3oiRiA/!\u0011\u0002L\u00055\u0013qJA)\u0003'Bq!a\u0011\r\u0001\u0004\t)%A\tpM\u001a\u001cX\r^\"iC:<W-\u0012<f]R\u00042A_A$\u0013\r\tIe\u001f\u0002\u001f\u0017J\u000bg\r\u001e'pON#\u0018M\u001d;PM\u001a\u001cX\r^\"iC:<W-\u0012<f]RDq!!\u0003\r\u0001\u0004\tY\u0001\u0003\u0004\u0002\u00181\u0001\rA\u0018\u0005\u0007\u00037a\u0001\u0019\u00010\t\r\u0005}A\u00021\u0001P\u0011\u0019\t\u0019\u0003\u0004a\u0001=\u0006QS.\u0019;fe&\fG.\u001b>f\u0017J\u000bg\r\u001e'pONs\u0017\r]:i_R<UM\\3sCRLwN\\#wK:$H#\u0004;\u0002Z\u0005\r\u0014QMA4\u0003S\nY\u0007C\u0004\u0002\\5\u0001\r!!\u0018\u0002!1|wm\u00158baNDw\u000e^#wK:$\bc\u0001>\u0002`%\u0019\u0011\u0011M>\u0003?-\u0013\u0016M\u001a;M_\u001e\u001cf.\u00199tQ>$x)\u001a8fe\u0006$\u0018n\u001c8Fm\u0016tG\u000fC\u0004\u0002\n5\u0001\r!a\u0003\t\r\u0005]Q\u00021\u0001_\u0011\u0019\tY\"\u0004a\u0001=\"1\u0011qD\u0007A\u0002=Ca!a\t\u000e\u0001\u0004q\u0016\u0001I7bi\u0016\u0014\u0018.\u00197ju\u0016\\%+\u00194u\u001d>$Wm\u0015;beR,\u0006/\u0012<f]R$R\u0002^A9\u0003w\ni(a \u0002\u0002\u0006\r\u0005bBA:\u001d\u0001\u0007\u0011QO\u0001\u0011]>$Wm\u0015;beR,\u0006/\u0012<f]R\u00042A_A<\u0013\r\tIh\u001f\u0002\u0016\u0017J\u000bg\r\u001e(pI\u0016\u001cF/\u0019:u+B,e/\u001a8u\u0011\u001d\tIA\u0004a\u0001\u0003\u0017Aa!a\u0006\u000f\u0001\u0004q\u0006BBA\u000e\u001d\u0001\u0007a\f\u0003\u0004\u0002 9\u0001\ra\u0014\u0005\u0007\u0003Gq\u0001\u0019\u00010\u00027%\u001cXI^3oi\u001a\u0013x.\\'pgR\u0014VmY3oi2+\u0017\rZ3s)\u0015q\u0016\u0011RAJ\u0011\u001d\tYi\u0004a\u0001\u0003\u001b\u000bQ!\u001a<f]R\u00042A_AH\u0013\r\t\tj\u001f\u0002\u001d\u0003\n\u001cHO]1di.\u0013\u0016M\u001a;EkJ\f'-\u001b7jif,e/\u001a8u\u0011\u0019\t\u0019c\u0004a\u0001=\u0006A\"/Z:fi.\u0013\u0016M\u001a;QCJ$\u0018\u000e^5p]N#\u0018\r^3\u0015\u000bQ\fI*a)\t\u000f\u0005-\u0005\u00031\u0001\u0002\u001cB!\u0011QTAP\u001b\u0005y\u0018bAAQ\u007f\n9\u0012IY:ue\u0006\u001cG\u000fR;sC\nLG.\u001b;z\u000bZ,g\u000e\u001e\u0005\u0006GB\u0001\r\u0001Z\u0001\u001fC\u0012$7JU1gi\u0016\u0003xn\u00195MK\u0006$WM],ji\"dunZ4j]\u001e$2\u0001^AU\u0011\u001d\tY)\u0005a\u0001\u0003\u001b\u000b\u0001#\\1zE\u0016dun\u001a+iK\u00163XM\u001c;\u0015\u000fQ\fy+!-\u00026\"9\u00111\u0012\nA\u0002\u00055\u0005bBAZ%\u0001\u0007\u00111B\u0001\u0012_2$\u0007+\u0019:uSRLwN\\*uCR,\u0007bBA\\%\u0001\u0007\u00111B\u0001\u0012]\u0016<\b+\u0019:uSRLwN\\*uCR,\u0007")
public class ControllerDurabilityEventsMaterialize
extends AbstractDurabilityEventsMaterialize {
    private final ControllerValidator validator;

    @Override
    public DurabilityDB db() {
        return super.db();
    }

    @Override
    public ControllerValidator validator() {
        return this.validator;
    }

    @Override
    public String loggerName() {
        return ControllerDurabilityEventsMaterialize.class.getName();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public synchronized boolean materialize(ConsumerRecord<byte[], byte[]> record) {
        AbstractDurabilityEvent event = Deserializer$.MODULE$.deserialize((byte[])((byte[])record.key()).clone(), (byte[])((byte[])record.value()).clone());
        String metadata = "Controller Durability audits topic " + Utils$.MODULE$.consumerRecordMetadata(record);
        AbstractDurabilityEvent abstractDurabilityEvent = event;
        if (abstractDurabilityEvent instanceof HealthCheckEvent) {
            HealthCheckEvent healthCheckEvent = (HealthCheckEvent)abstractDurabilityEvent;
            this.debug((Function0<String> & Serializable)() -> "ControllerDurabilityMaterialization: Materialization request for " + event.eventType() + " " + event);
            if (!this.db().getKRaftLocalNodeId().contains(BoxesRunTime.boxToInteger(healthCheckEvent.nodeId()))) return true;
            this.materializeHealthCheck(healthCheckEvent);
            return true;
        }
        if (this.db().fetchKRaftPartitionState(event.topicIdPartition()).isEmpty()) {
            return false;
        }
        if (record.offset() < BoxesRunTime.unboxToLong(this.db().getDurabilityTopicPartitionOffsets().apply(record.partition()))) {
            this.resetKRaftPartitionState(event, record);
        }
        KRaftPartitionState kRaftPartitionStateInDB = this.db().fetchKRaftPartitionState(event.topicIdPartition()).get();
        Option<Object> currentEpoch = this.db().getKRaftLocalEpoch();
        boolean isStale = currentEpoch.isDefined() && BoxesRunTime.unboxToInt(currentEpoch.get()) > event.epoch();
        this.debug((Function0<String> & Serializable)() -> "ControllerDurabilityMaterialization: Materialization request for " + event.eventType() + " " + event + " for state: " + this.db().kraftQuorumState());
        AbstractDurabilityEvent abstractDurabilityEvent2 = event;
        if (abstractDurabilityEvent2 instanceof AbstractKRaftDurabilityEvent) {
            AbstractKRaftDurabilityEvent abstractKRaftDurabilityEvent = (AbstractKRaftDurabilityEvent)abstractDurabilityEvent2;
            boolean eventFromLocalNode = this.db().getKRaftLocalNodeId().contains(BoxesRunTime.boxToInteger(abstractKRaftDurabilityEvent.nodeId()));
            boolean isFromMostRecentLeader = this.isEventFromMostRecentLeader(abstractKRaftDurabilityEvent, isStale);
            AbstractKRaftDurabilityEvent abstractKRaftDurabilityEvent2 = abstractKRaftDurabilityEvent;
            if (abstractKRaftDurabilityEvent2 instanceof KRaftLeaderChangeEvent) {
                KRaftLeaderChangeEvent kRaftLeaderChangeEvent = (KRaftLeaderChangeEvent)abstractKRaftDurabilityEvent2;
                this.materializeKRaftLeaderChangeEvent(kRaftLeaderChangeEvent, kRaftPartitionStateInDB, eventFromLocalNode, isFromMostRecentLeader, metadata, isStale);
                return true;
            }
            if (abstractKRaftDurabilityEvent2 instanceof KRaftHWMChangeEvent) {
                KRaftHWMChangeEvent kRaftHWMChangeEvent = (KRaftHWMChangeEvent)abstractKRaftDurabilityEvent2;
                this.materializeKRaftHWMChangeEvent(kRaftHWMChangeEvent, kRaftPartitionStateInDB, eventFromLocalNode, isFromMostRecentLeader, metadata, isStale);
                return true;
            }
            if (abstractKRaftDurabilityEvent2 instanceof KRaftLogStartOffsetChangeEvent) {
                KRaftLogStartOffsetChangeEvent kRaftLogStartOffsetChangeEvent = (KRaftLogStartOffsetChangeEvent)abstractKRaftDurabilityEvent2;
                this.materializeKRaftLogStartOffsetChangeEvent(kRaftLogStartOffsetChangeEvent, kRaftPartitionStateInDB, eventFromLocalNode, isFromMostRecentLeader, metadata, isStale);
                return true;
            }
            if (abstractKRaftDurabilityEvent2 instanceof KRaftLogSnapshotGenerationEvent) {
                KRaftLogSnapshotGenerationEvent kRaftLogSnapshotGenerationEvent = (KRaftLogSnapshotGenerationEvent)abstractKRaftDurabilityEvent2;
                this.materializeKRaftLogSnapshotGenerationEvent(kRaftLogSnapshotGenerationEvent, kRaftPartitionStateInDB, eventFromLocalNode, isFromMostRecentLeader, metadata, isStale);
                return true;
            }
            if (abstractKRaftDurabilityEvent2 instanceof KRaftNodeStartUpEvent) {
                KRaftNodeStartUpEvent kRaftNodeStartUpEvent = (KRaftNodeStartUpEvent)abstractKRaftDurabilityEvent2;
                this.materializeKRaftNodeStartUpEvent(kRaftNodeStartUpEvent, kRaftPartitionStateInDB, eventFromLocalNode, isFromMostRecentLeader, metadata, isStale);
                return true;
            }
            this.warn((Function0<String> & Serializable)() -> "ControllerDurabilityMaterialization: Ignoring unexpected KRaft durability event of type " + event.eventType() + ": " + event + ", " + metadata);
            return false;
        }
        if (abstractDurabilityEvent2 instanceof AbstractBrokerDurabilityEvent) {
            this.debug((Function0<String> & Serializable)() -> "Controller materialization rejected for BrokerDurabilityEvent " + event);
            return false;
        }
        this.warn((Function0<String> & Serializable)() -> "ControllerDurabilityMaterialization: Ignoring unexpected durability event of type " + event.eventType() + ": " + event + ", " + metadata);
        return false;
    }

    private void materializeKRaftLeaderChangeEvent(KRaftLeaderChangeEvent leaderChangeEvent, KRaftPartitionState kRaftPartitionStateInDB, boolean eventFromLocalNode, boolean isFromMostRecentLeader, String metadata, boolean isStale) {
        if (isStale) {
            return;
        }
        int localNodeId = BoxesRunTime.unboxToInt(this.db().getKRaftLocalNodeId().getOrElse(() -> -1));
        Option<Object> currentLocalEpoch = this.db().getKRaftLocalEpoch();
        if (eventFromLocalNode && isFromMostRecentLeader) {
            this.validator().validateKRaftLeaderChangeEventFromLeader(leaderChangeEvent, kRaftPartitionStateInDB, metadata);
        } else if (!eventFromLocalNode) {
            this.validator().validateKRaftLeaderChangeEventFromNonLeader(leaderChangeEvent, kRaftPartitionStateInDB, metadata);
        }
        this.addKRaftEpochLeaderWithLogging(leaderChangeEvent);
        this.db().truncateKRaftEpochLeaders(leaderChangeEvent.epoch() - 100);
        Serializable serializable = leaderChangeEvent.epochChainOpt().isDefined() && BoxesRunTime.unboxToLong(leaderChangeEvent.highWatermarkOpt().getOrElse(() -> -1L)) < BoxesRunTime.unboxToLong(((MapOps)leaderChangeEvent.epochChainOpt().get()).apply(BoxesRunTime.boxToInteger(leaderChangeEvent.epoch()))) ? ((scala.collection.mutable.MapOps)leaderChangeEvent.epochChainOpt().get()).remove(BoxesRunTime.boxToInteger(leaderChangeEvent.epoch())) : BoxedUnit.UNIT;
        boolean hasLogEndOffsetIncreasedInCurrentEpoch = currentLocalEpoch.contains(BoxesRunTime.boxToInteger(leaderChangeEvent.epoch())) && (kRaftPartitionStateInDB.hasFetchOffsetIncreasedInCurrentEpoch() || leaderChangeEvent.logEndOffset() > kRaftPartitionStateInDB.lastKnownFetchOffset());
        boolean dbLocalEpochSet = false;
        if (eventFromLocalNode || leaderChangeEvent.yesVoters().contains(BoxesRunTime.boxToInteger(localNodeId)) && leaderChangeEvent.epoch() > BoxesRunTime.unboxToInt(currentLocalEpoch.getOrElse(() -> -1))) {
            dbLocalEpochSet = true;
            v1 = this.db().setKRaftLocalEpoch(leaderChangeEvent.epoch());
        } else {
            v1 = BoxedUnit.UNIT;
        }
        HashMap<Object, Object> mergedEpochChain = (HashMap<Object, Object>)kRaftPartitionStateInDB.epochChain().filter((Function1<Tuple2, Object> & Serializable)epochAndStartOffset -> BoxesRunTime.boxToBoolean(ControllerDurabilityEventsMaterialize.$anonfun$materializeKRaftLeaderChangeEvent$4(leaderChangeEvent, epochAndStartOffset)));
        if (isFromMostRecentLeader && leaderChangeEvent.epochChainOpt().isDefined()) {
            ((IterableOnceOps)((IterableOps)leaderChangeEvent.epochChainOpt().get()).filter((Function1<Tuple2, Object> & Serializable)epochAndStartOffset -> BoxesRunTime.boxToBoolean(ControllerDurabilityEventsMaterialize.$anonfun$materializeKRaftLeaderChangeEvent$5(leaderChangeEvent, epochAndStartOffset)))).foreach((Function1<Tuple2, Option> & Serializable)epochAndStartOffset -> mergedEpochChain.put(BoxesRunTime.boxToInteger(epochAndStartOffset._1$mcI$sp()), BoxesRunTime.boxToLong(epochAndStartOffset._2$mcJ$sp())));
        }
        KRaftPartitionState newKRaftPartitionState = KRaftPartitionState$.MODULE$.apply(leaderChangeEvent.topicIdPartition(), kRaftPartitionStateInDB.leaderHighWatermark(), eventFromLocalNode && leaderChangeEvent.highWatermarkOpt().isDefined() ? leaderChangeEvent.highWatermarkOpt() : kRaftPartitionStateInDB.localHighWatermark(), isFromMostRecentLeader ? mergedEpochChain : kRaftPartitionStateInDB.epochChain(), this.db().kraftQuorumState().epochLeaderIds(), eventFromLocalNode ? leaderChangeEvent.logStartOffset() : kRaftPartitionStateInDB.localLogStartOffset(), eventFromLocalNode ? leaderChangeEvent.logEndOffset() : kRaftPartitionStateInDB.lastKnownFetchOffset(), eventFromLocalNode ? hasLogEndOffsetIncreasedInCurrentEpoch : kRaftPartitionStateInDB.hasFetchOffsetIncreasedInCurrentEpoch() && !dbLocalEpochSet, kRaftPartitionStateInDB.localLatestSnapshotId());
        this.db().addKRaftPartitionState(newKRaftPartitionState);
        this.maybeLogTheEvent(leaderChangeEvent, kRaftPartitionStateInDB, newKRaftPartitionState);
    }

    private void materializeKRaftHWMChangeEvent(KRaftHWMChangeEvent hWMChangeEvent, KRaftPartitionState kRaftPartitionStateInDB, boolean eventFromLocalNode, boolean isFromMostRecentLeader, String metadata, boolean isStale) {
        if (isStale) {
            return;
        }
        int localNodeId = BoxesRunTime.unboxToInt(this.db().getKRaftLocalNodeId().getOrElse(() -> -1));
        Option<Object> currentLocalEpoch = this.db().getKRaftLocalEpoch();
        if (eventFromLocalNode && isFromMostRecentLeader) {
            this.validator().validateKRaftHWMChangeEventFromLeader(hWMChangeEvent, kRaftPartitionStateInDB, metadata);
        } else if (!eventFromLocalNode) {
            this.validator().validateKRaftHWMChangeEventFromNonLeader(hWMChangeEvent, kRaftPartitionStateInDB, metadata);
        }
        this.addKRaftEpochLeaderWithLogging(hWMChangeEvent);
        boolean hasFetchOffsetIncreasedInCurrentEpoch = currentLocalEpoch.contains(BoxesRunTime.boxToInteger(hWMChangeEvent.epoch())) && (kRaftPartitionStateInDB.hasFetchOffsetIncreasedInCurrentEpoch() || BoxesRunTime.unboxToLong(hWMChangeEvent.quorumFetchOffsets().getOrElse(BoxesRunTime.boxToInteger(localNodeId), () -> -1L)) > kRaftPartitionStateInDB.lastKnownFetchOffset());
        Serializable serializable = eventFromLocalNode || BoxesRunTime.unboxToLong(hWMChangeEvent.quorumFetchOffsets().getOrElse(BoxesRunTime.boxToInteger(localNodeId), () -> -1L)) > -1L && hWMChangeEvent.epoch() > BoxesRunTime.unboxToInt(currentLocalEpoch.getOrElse(() -> -1)) ? this.db().setKRaftLocalEpoch(hWMChangeEvent.epoch()) : BoxedUnit.UNIT;
        KRaftPartitionState newKRaftPartitionState = KRaftPartitionState$.MODULE$.apply(hWMChangeEvent.topicIdPartition(), isFromMostRecentLeader ? new Some<Long>(BoxesRunTime.boxToLong(hWMChangeEvent.highWatermark())) : kRaftPartitionStateInDB.leaderHighWatermark(), eventFromLocalNode ? new Some<Long>(BoxesRunTime.boxToLong(hWMChangeEvent.highWatermark())) : kRaftPartitionStateInDB.localHighWatermark(), kRaftPartitionStateInDB.epochChain(), this.db().kraftQuorumState().epochLeaderIds(), eventFromLocalNode ? hWMChangeEvent.logStartOffset() : kRaftPartitionStateInDB.localLogStartOffset(), BoxesRunTime.unboxToLong(hWMChangeEvent.quorumFetchOffsets().getOrElse(BoxesRunTime.boxToInteger(localNodeId), () -> -1L)) != -1L ? BoxesRunTime.unboxToLong(hWMChangeEvent.quorumFetchOffsets().getOrElse(BoxesRunTime.boxToInteger(localNodeId), () -> -1L)) : kRaftPartitionStateInDB.lastKnownFetchOffset(), hasFetchOffsetIncreasedInCurrentEpoch, kRaftPartitionStateInDB.localLatestSnapshotId());
        this.db().addKRaftPartitionState(newKRaftPartitionState);
        this.maybeLogTheEvent(hWMChangeEvent, kRaftPartitionStateInDB, newKRaftPartitionState);
    }

    private void materializeKRaftLogStartOffsetChangeEvent(KRaftLogStartOffsetChangeEvent offsetChangeEvent, KRaftPartitionState kRaftPartitionStateInDB, boolean eventFromLocalNode, boolean isFromMostRecentLeader, String metadata, boolean isStale) {
        if (eventFromLocalNode) {
            this.validator().validateKRaftLogStartOffsetChangeEvent(offsetChangeEvent, kRaftPartitionStateInDB, metadata, isStale);
        }
        Option<Object> currentLocalEpoch = this.db().getKRaftLocalEpoch();
        if (isFromMostRecentLeader && this.db().fetchKRaftEpochLeader(offsetChangeEvent.epoch()).isEmpty()) {
            this.addKRaftEpochLeaderWithLogging(offsetChangeEvent);
        }
        boolean hasFetchOffsetIncreasedInCurrentEpoch = currentLocalEpoch.contains(BoxesRunTime.boxToInteger(offsetChangeEvent.epoch())) && isFromMostRecentLeader && (kRaftPartitionStateInDB.hasFetchOffsetIncreasedInCurrentEpoch() || offsetChangeEvent.logEndOffset() > kRaftPartitionStateInDB.lastKnownFetchOffset());
        Serializable serializable = eventFromLocalNode && !isStale ? this.db().setKRaftLocalEpoch(offsetChangeEvent.epoch()) : BoxedUnit.UNIT;
        KRaftPartitionState newKRaftPartitionState = KRaftPartitionState$.MODULE$.apply(offsetChangeEvent.topicIdPartition(), isFromMostRecentLeader ? offsetChangeEvent.highWatermarkOpt() : kRaftPartitionStateInDB.leaderHighWatermark(), eventFromLocalNode && offsetChangeEvent.highWatermarkOpt().isDefined() ? offsetChangeEvent.highWatermarkOpt() : kRaftPartitionStateInDB.localHighWatermark(), kRaftPartitionStateInDB.epochChain(), this.db().kraftQuorumState().epochLeaderIds(), eventFromLocalNode ? offsetChangeEvent.logStartOffset() : kRaftPartitionStateInDB.localLogStartOffset(), isFromMostRecentLeader && eventFromLocalNode ? offsetChangeEvent.logEndOffset() : kRaftPartitionStateInDB.lastKnownFetchOffset(), eventFromLocalNode ? hasFetchOffsetIncreasedInCurrentEpoch : kRaftPartitionStateInDB.hasFetchOffsetIncreasedInCurrentEpoch(), eventFromLocalNode ? offsetChangeEvent.latestSnapshotId() : kRaftPartitionStateInDB.localLatestSnapshotId());
        this.db().addKRaftPartitionState(newKRaftPartitionState);
        this.maybeLogTheEvent(offsetChangeEvent, kRaftPartitionStateInDB, newKRaftPartitionState);
    }

    private void materializeKRaftLogSnapshotGenerationEvent(KRaftLogSnapshotGenerationEvent logSnapshotEvent, KRaftPartitionState kRaftPartitionStateInDB, boolean eventFromLocalNode, boolean isFromMostRecentLeader, String metadata, boolean isStale) {
        if (eventFromLocalNode) {
            this.validator().validateKRaftLogSnapshotGenerationEvent(logSnapshotEvent, kRaftPartitionStateInDB, metadata, isStale);
        }
        Option<Object> currentLocalEpoch = this.db().getKRaftLocalEpoch();
        if (isFromMostRecentLeader && this.db().fetchKRaftEpochLeader(logSnapshotEvent.epoch()).isEmpty()) {
            this.addKRaftEpochLeaderWithLogging(logSnapshotEvent);
        }
        boolean hasFetchOffsetIncreasedInCurrentEpoch = currentLocalEpoch.contains(BoxesRunTime.boxToInteger(logSnapshotEvent.epoch())) && isFromMostRecentLeader && (kRaftPartitionStateInDB.hasFetchOffsetIncreasedInCurrentEpoch() || logSnapshotEvent.logEndOffset() > kRaftPartitionStateInDB.lastKnownFetchOffset());
        Serializable serializable = eventFromLocalNode && !isStale ? this.db().setKRaftLocalEpoch(logSnapshotEvent.epoch()) : BoxedUnit.UNIT;
        KRaftPartitionState newKRaftPartitionState = KRaftPartitionState$.MODULE$.apply(logSnapshotEvent.topicIdPartition(), isFromMostRecentLeader ? logSnapshotEvent.highWatermarkOpt() : kRaftPartitionStateInDB.leaderHighWatermark(), eventFromLocalNode && logSnapshotEvent.highWatermarkOpt().isDefined() ? logSnapshotEvent.highWatermarkOpt() : kRaftPartitionStateInDB.localHighWatermark(), kRaftPartitionStateInDB.epochChain(), this.db().kraftQuorumState().epochLeaderIds(), eventFromLocalNode ? logSnapshotEvent.logStartOffset() : kRaftPartitionStateInDB.localLogStartOffset(), isFromMostRecentLeader && eventFromLocalNode ? logSnapshotEvent.logEndOffset() : kRaftPartitionStateInDB.lastKnownFetchOffset(), eventFromLocalNode ? hasFetchOffsetIncreasedInCurrentEpoch : kRaftPartitionStateInDB.hasFetchOffsetIncreasedInCurrentEpoch(), eventFromLocalNode ? new Some<OffsetAndEpoch>(logSnapshotEvent.newSnapshotId()) : kRaftPartitionStateInDB.localLatestSnapshotId());
        this.db().addKRaftPartitionState(newKRaftPartitionState);
        this.maybeLogTheEvent(logSnapshotEvent, kRaftPartitionStateInDB, newKRaftPartitionState);
    }

    private void materializeKRaftNodeStartUpEvent(KRaftNodeStartUpEvent nodeStartUpEvent, KRaftPartitionState kRaftPartitionStateInDB, boolean eventFromLocalNode, boolean isFromMostRecentLeader, String metadata, boolean isStale) {
        if (eventFromLocalNode) {
            this.validator().validateKRaftNodeStartUpEvent(nodeStartUpEvent, kRaftPartitionStateInDB, metadata, isStale);
        }
        Option<Object> currentLocalEpoch = this.db().getKRaftLocalEpoch();
        if (isFromMostRecentLeader && this.db().fetchKRaftEpochLeader(nodeStartUpEvent.epoch()).isEmpty()) {
            this.addKRaftEpochLeaderWithLogging(nodeStartUpEvent);
        }
        boolean hasFetchOffsetIncreasedInCurrentEpoch = currentLocalEpoch.contains(BoxesRunTime.boxToInteger(nodeStartUpEvent.epoch())) && isFromMostRecentLeader && (kRaftPartitionStateInDB.hasFetchOffsetIncreasedInCurrentEpoch() || nodeStartUpEvent.logEndOffset() > kRaftPartitionStateInDB.lastKnownFetchOffset());
        Serializable serializable = eventFromLocalNode && !isStale ? this.db().setKRaftLocalEpoch(nodeStartUpEvent.epoch()) : BoxedUnit.UNIT;
        KRaftPartitionState newKRaftPartitionState = KRaftPartitionState$.MODULE$.apply(nodeStartUpEvent.topicIdPartition(), isFromMostRecentLeader ? nodeStartUpEvent.highWatermarkOpt() : kRaftPartitionStateInDB.leaderHighWatermark(), eventFromLocalNode && nodeStartUpEvent.highWatermarkOpt().isDefined() ? nodeStartUpEvent.highWatermarkOpt() : kRaftPartitionStateInDB.localHighWatermark(), kRaftPartitionStateInDB.epochChain(), this.db().kraftQuorumState().epochLeaderIds(), eventFromLocalNode ? nodeStartUpEvent.logStartOffset() : kRaftPartitionStateInDB.localLogStartOffset(), isFromMostRecentLeader && eventFromLocalNode ? nodeStartUpEvent.logEndOffset() : kRaftPartitionStateInDB.lastKnownFetchOffset(), eventFromLocalNode ? hasFetchOffsetIncreasedInCurrentEpoch : kRaftPartitionStateInDB.hasFetchOffsetIncreasedInCurrentEpoch(), eventFromLocalNode ? nodeStartUpEvent.latestSnapshotId() : kRaftPartitionStateInDB.localLatestSnapshotId());
        this.db().addKRaftPartitionState(newKRaftPartitionState);
        this.maybeLogTheEvent(nodeStartUpEvent, kRaftPartitionStateInDB, newKRaftPartitionState);
    }

    private boolean isEventFromMostRecentLeader(AbstractKRaftDurabilityEvent event, boolean isStale) {
        return event.isFromLeader() && !isStale && (this.db().kraftQuorumState().epochLeaderIds().isEmpty() || event.epoch() >= BoxesRunTime.unboxToInt(this.db().kraftQuorumState().epochLeaderIds().keys().max(Ordering.Int$.MODULE$)));
    }

    public void resetKRaftPartitionState(AbstractDurabilityEvent event, ConsumerRecord<byte[], byte[]> record) {
        KRaftPartitionState partitionState = KRaftPartitionState$.MODULE$.apply(event.topicIdPartition(), None$.MODULE$, None$.MODULE$, (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$), this.db().kraftQuorumState().epochLeaderIds(), 0L, -1L, false, None$.MODULE$);
        this.info((Function0<String> & Serializable)() -> "KRaftPartitionState reset in DB for TopicIdPartition " + event.topicIdPartition() + ". The DA record offset " + record.offset() + " was less than the DB TopicPartition offset " + this.db().getDurabilityTopicPartitionOffsets().apply(record.partition()));
        this.db().addKRaftPartitionState(partitionState);
    }

    private void addKRaftEpochLeaderWithLogging(AbstractKRaftDurabilityEvent event) {
        if (BoxesRunTime.unboxToInt(this.db().addKRaftEpochLeader(event.epoch(), BoxesRunTime.unboxToInt(event.leaderIdOpt().get())).getOrElse(() -> -1)) != BoxesRunTime.unboxToInt(event.leaderIdOpt().get())) {
            this.info((Function0<String> & Serializable)() -> "Epoch Leader added: \nEpoch: " + event.epoch() + ", LeaderId: " + event.leaderIdOpt().get() + " \nEvent: " + event);
            return;
        }
    }

    private void maybeLogTheEvent(AbstractKRaftDurabilityEvent event, KRaftPartitionState oldPartitionState, KRaftPartitionState newPartitionState) {
        if (oldPartitionState.leaderHighWatermark().nonEmpty()) {
            long newLeaderHwm = BoxesRunTime.unboxToLong(newPartitionState.leaderHighWatermark().getOrElse(() -> 0L));
            long oldLeaderHwm = BoxesRunTime.unboxToLong(oldPartitionState.leaderHighWatermark().getOrElse(() -> 0L));
            if (oldLeaderHwm == 0L && newLeaderHwm != 0L || oldLeaderHwm > 0L && newLeaderHwm - oldLeaderHwm >= 5000000L && (newLeaderHwm - oldLeaderHwm) / oldLeaderHwm * 100L >= 30L) {
                this.info((Function0<String> & Serializable)() -> "New HWM: " + newPartitionState.leaderHighWatermark() + " is substantially greater than old HWM: " + oldPartitionState.leaderHighWatermark() + " \nEvent: " + event);
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$materializeKRaftLeaderChangeEvent$4(KRaftLeaderChangeEvent leaderChangeEvent$1, Tuple2 epochAndStartOffset) {
        return epochAndStartOffset._1$mcI$sp() >= leaderChangeEvent$1.epoch() - 100;
    }

    public static final /* synthetic */ boolean $anonfun$materializeKRaftLeaderChangeEvent$5(KRaftLeaderChangeEvent leaderChangeEvent$1, Tuple2 epochAndStartOffset) {
        return epochAndStartOffset._1$mcI$sp() >= leaderChangeEvent$1.epoch() - 100;
    }

    public ControllerDurabilityEventsMaterialize(DurabilityDB db, AuditReporter reporter, Time time) {
        super(db, reporter, time);
        this.validator = new ControllerValidator(reporter, db, time);
    }
}

