/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.tools;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.confluent.kafka.storage.tier.store.objects.ObjectType;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import kafka.durability.tools.DACompactionDebuggerOptions;
import kafka.durability.tools.OffsetInfo;
import kafka.durability.utils.DurabilityOffsetMapUtils$;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.fetcher.TierAbortedTxnReader;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.kafka.storage.internals.log.CleanedTransactionMetadata;
import org.apache.kafka.storage.internals.utils.Throttler;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.SortedMap$;
import scala.collection.SortedSet;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.SortedMap;
import scala.jdk.CollectionConverters$;
import scala.math.Ordered$;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong;

public final class DACompactionDebugger$ {
    public static final DACompactionDebugger$ MODULE$ = new DACompactionDebugger$();
    private static String outputDirectory;
    private static volatile boolean bitmap$0;

    private String outputDirectory$lzycompute() {
        DACompactionDebugger$ dACompactionDebugger$ = this;
        synchronized (dACompactionDebugger$) {
            if (!bitmap$0) {
                outputDirectory = "/tmp/da-compaction-debug/" + UUID.randomUUID().toString() + "/";
                bitmap$0 = true;
            }
        }
        return outputDirectory;
    }

    private String outputDirectory() {
        if (!bitmap$0) {
            return this.outputDirectory$lzycompute();
        }
        return outputDirectory;
    }

    public void main(String[] args) {
        DACompactionDebuggerOptions opts = this.parseCommandLineOptions(args);
        if (opts.fileType().equals("logFile")) {
            this.generateAndCompareOffsetMapsUsingCustomCode(opts);
            this.generateAndCompareOffsetMapsProductionCode(opts);
        }
        if (opts.fileType().equals("offsetMap")) {
            this.generateAndCompareOffsetMapFiles(opts);
            return;
        }
    }

    private void compareInMemoryOffsetMap(scala.collection.SortedMap<ByteBuffer, kafka.durability.utils.OffsetInfo> sourceOffsetMap, scala.collection.SortedMap<ByteBuffer, kafka.durability.utils.OffsetInfo> destinationOffsetMap) {
        if (sourceOffsetMap.size() != destinationOffsetMap.size()) {
            Predef$.MODULE$.println("CHECK FAILED: Number of elements in both the offset maps are different , source size : " + sourceOffsetMap.size() + "  destination size : " + destinationOffsetMap.size());
        }
        SortedSet allKeys = (SortedSet)sourceOffsetMap.keySet().$plus$plus(destinationOffsetMap.keySet());
        allKeys.foreach((Function1<ByteBuffer, Object> & Serializable)key -> {
            DACompactionDebugger$.$anonfun$compareInMemoryOffsetMap$1(sourceOffsetMap, destinationOffsetMap, key);
            return BoxedUnit.UNIT;
        });
    }

    private void generateAndCompareOffsetMapFiles(DACompactionDebuggerOptions opts) {
        scala.collection.SortedMap<ByteBuffer, kafka.durability.utils.OffsetInfo> destOffsetMap;
        File inputDir = new File(opts.inputDir());
        String sourceOffsetMapFileName = (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps(opts.sources()));
        String destOffsetMapFileName = (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps(opts.destinations()));
        scala.collection.SortedMap<ByteBuffer, kafka.durability.utils.OffsetInfo> sourceOffsetMap = DurabilityOffsetMapUtils$.MODULE$.retrieveOffsetMapInFile(inputDir, sourceOffsetMapFileName);
        if (sourceOffsetMap.nonEmpty()) {
            this.writeSortedMapToFile(sourceOffsetMap, "merged_source_offset_map.json", opts.sortBy());
        }
        if ((destOffsetMap = DurabilityOffsetMapUtils$.MODULE$.retrieveOffsetMapInFile(inputDir, destOffsetMapFileName)).nonEmpty()) {
            this.writeSortedMapToFile(destOffsetMap, "merged_destination_offset_map.json", opts.sortBy());
        }
        this.compareInMemoryOffsetMap(sourceOffsetMap, destOffsetMap);
    }

    private void generateAndCompareOffsetMapsUsingCustomCode(DACompactionDebuggerOptions opts) {
        Predef$.MODULE$.println("Starting to process files using custom code................");
        HashMap<ByteBuffer, java.util.List<OffsetInfo>> sourceOffsetMap = new HashMap<ByteBuffer, java.util.List<OffsetInfo>>();
        HashMap<ByteBuffer, java.util.List<OffsetInfo>> destinationOffsetMap = new HashMap<ByteBuffer, java.util.List<OffsetInfo>>();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(opts.sources()), (Function1<String, Object> & Serializable)source -> {
            DACompactionDebugger$.MODULE$.populateOffsetMapUsingCustomCode(opts.inputDir(), source, sourceOffsetMap);
            return BoxedUnit.UNIT;
        });
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(opts.destinations()), (Function1<String, Object> & Serializable)destination -> {
            DACompactionDebugger$.MODULE$.populateOffsetMapUsingCustomCode(opts.inputDir(), destination, destinationOffsetMap);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println("total number of keys in source map generated by custom code : " + sourceOffsetMap.size());
        if (destinationOffsetMap.size() != 0) {
            Predef$.MODULE$.println("total number of keys in destination map generated by custom code : " + destinationOffsetMap.size());
        }
        this.sortMapValues(sourceOffsetMap);
        this.sortMapValues(destinationOffsetMap);
        if (destinationOffsetMap.size() != 0) {
            Predef$.MODULE$.println("comparing source and destination offset maps generated by custom code");
            this.compareOffsetMaps(sourceOffsetMap, destinationOffsetMap);
        }
        this.writeOffsetMapToFile(sourceOffsetMap, "source_offset_map_custom_code_generated.json", opts.sortBy());
        if (destinationOffsetMap.size() != 0) {
            this.writeOffsetMapToFile(destinationOffsetMap, "destination_offset_map_custom_code_generated.json", opts.sortBy());
            return;
        }
    }

    private void writeOffsetMapToFile(HashMap<ByteBuffer, java.util.List<OffsetInfo>> map, String fileName, String sortBy) {
        File file = new File(this.outputDirectory() + fileName);
        Serializable serializable = !file.getParentFile().exists() ? BoxesRunTime.boxToBoolean(file.getParentFile().mkdirs()) : BoxedUnit.UNIT;
        Serializable serializable2 = !file.exists() ? BoxesRunTime.boxToBoolean(file.createNewFile()) : BoxedUnit.UNIT;
        ObjectWriter mapper = new ObjectMapper().writerWithDefaultPrettyPrinter();
        Object sortedSeq = null;
        sortedSeq = "offset".equals(sortBy) ? ((List)CollectionConverters$.MODULE$.MapHasAsScala(map).asScala().toList().sortWith((Function2<Tuple2, Tuple2, Object> & Serializable)(entry1, entry2) -> BoxesRunTime.boxToBoolean(DACompactionDebugger$.$anonfun$writeOffsetMapToFile$1(entry1, entry2)))).map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                ByteBuffer k = (ByteBuffer)tuple2._1();
                java.util.List v = (java.util.List)tuple2._2();
                return new Tuple2<String, java.util.List>(MODULE$.base64(k), v);
            }
            throw new MatchError(tuple2);
        }) : ((List)CollectionConverters$.MODULE$.MapHasAsScala(map).asScala().toList().sortWith((Function2<Tuple2, Tuple2, Object> & Serializable)(entry1, entry2) -> BoxesRunTime.boxToBoolean(DACompactionDebugger$.$anonfun$writeOffsetMapToFile$3(entry1, entry2)))).map((Function1<Tuple2, Tuple2> & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                ByteBuffer k = (ByteBuffer)tuple2._1();
                java.util.List v = (java.util.List)tuple2._2();
                return new Tuple2<String, java.util.List>(MODULE$.base64(k), v);
            }
            throw new MatchError(tuple2);
        });
        mapper.writeValue(file, CollectionConverters$.MODULE$.SeqHasAsJava(sortedSeq).asJava());
        Predef$.MODULE$.println("Successfully Generated File : " + file.getAbsolutePath());
    }

    private void sortMapValues(HashMap<ByteBuffer, java.util.List<OffsetInfo>> map) {
        CollectionConverters$.MODULE$.MapHasAsScala(map).asScala().withFilter((Function1<Tuple2<ByteBuffer, java.util.List<OffsetInfo>>, Object>)(Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(DACompactionDebugger$.$anonfun$sortMapValues$1(check$ifrefutable$1))).foreach((Function1<Tuple2, Buffer> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                java.util.List value = (java.util.List)tuple2._2();
                Collections.sort(value, (a, b) -> new RichLong(Predef$.MODULE$.longWrapper(b.offset())).compare(BoxesRunTime.boxToLong(a.offset())));
                return (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(value).asScala().sortWith((Function2<OffsetInfo, OffsetInfo, Object> & Serializable)(p1, p2) -> BoxesRunTime.boxToBoolean(DACompactionDebugger$.$anonfun$sortMapValues$4(p1, p2)));
            }
            throw new MatchError(tuple2);
        });
    }

    private void populateOffsetMapUsingCustomCode(String directory, String fileName, HashMap<ByteBuffer, java.util.List<OffsetInfo>> offsetMap) {
        Predef$.MODULE$.println("processing file : " + fileName + " by custom code");
        File file = new File(directory, fileName);
        FileRecords fileRecords = FileRecords.open((File)file, (boolean)false).slice(0, Integer.MAX_VALUE);
        try {
            CollectionConverters$.MODULE$.IterableHasAsScala(fileRecords.batches()).asScala().foreach((Function1<FileLogInputStream.FileChannelRecordBatch, Object> & Serializable)batch -> {
                DACompactionDebugger$.$anonfun$populateOffsetMapUsingCustomCode$1(offsetMap, batch);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            fileRecords.closeHandlers();
        }
    }

    private void compareOffsetMaps(HashMap<ByteBuffer, java.util.List<OffsetInfo>> sourceOffsetMap, HashMap<ByteBuffer, java.util.List<OffsetInfo>> destinationOffsetMap) {
        if (sourceOffsetMap.size() != destinationOffsetMap.size()) {
            Predef$.MODULE$.println("CHECK FAILED: Number of elements in both the offset maps are different , source size : " + sourceOffsetMap.size() + "  destination size : " + destinationOffsetMap.size());
        }
        HashSet<ByteBuffer> allKeys = new HashSet<ByteBuffer>(sourceOffsetMap.keySet());
        allKeys.addAll(destinationOffsetMap.keySet());
        allKeys.forEach(key -> {
            String hashedKey = MODULE$.base64((ByteBuffer)key);
            if (sourceOffsetMap.containsKey(key) && !destinationOffsetMap.containsKey(key)) {
                if (!((OffsetInfo)((java.util.List)sourceOffsetMap.get(key)).get(0)).isTombstone()) {
                    Predef$.MODULE$.println("CHECK FAILED: Entry is missing for key : " + hashedKey + " in destination offset map , source offset : " + sourceOffsetMap.get(key));
                    return;
                }
                return;
            }
            if (!sourceOffsetMap.containsKey(key) && destinationOffsetMap.containsKey(key)) {
                Predef$.MODULE$.println("Check failed : Entry is missing for key : " + hashedKey + " in source offset map , destination offset : " + destinationOffsetMap.get(key));
                return;
            }
            if (!MODULE$.isOffsetInfoEqual((java.util.List)sourceOffsetMap.get(key), (java.util.List)destinationOffsetMap.get(key))) {
                Predef$.MODULE$.println("Check failed : Offset values are not equal for key : " + hashedKey + " , source offset : " + sourceOffsetMap.get(key) + " , destination offset : " + destinationOffsetMap.get(key));
                return;
            }
        });
        Predef$.MODULE$.println("All checks completed!!!");
    }

    private boolean isOffsetInfoEqual(java.util.List<OffsetInfo> source, java.util.List<OffsetInfo> destination) {
        OffsetInfo sourceOffset = source.get(0);
        OffsetInfo destinationOffset = destination.get(0);
        return ((Object)BoxesRunTime.boxToLong(sourceOffset.offset())).equals(BoxesRunTime.boxToLong(destinationOffset.offset())) && sourceOffset.isTombstone() == destinationOffset.isTombstone();
    }

    private String base64(ByteBuffer key) {
        return Base64.getEncoder().encodeToString(key.array());
    }

    private DACompactionDebuggerOptions parseCommandLineOptions(String[] args) {
        DACompactionDebuggerOptions opts = new DACompactionDebuggerOptions(args);
        opts.parseArgs();
        CommandLineUtils.maybePrintHelpOrVersion(opts, "Helps to compare the offset maps of two sets of segments, useful for debugging a seemingly corrupt compaction.");
        opts.checkArgs();
        opts.printArgs();
        return opts;
    }

    private void generateAndCompareOffsetMapsProductionCode(DACompactionDebuggerOptions opts) {
        Predef$.MODULE$.println("---------------------------------------------------------------");
        Predef$.MODULE$.println("Starting to process files using production code................");
        ObjectRef<Object> mergedSourceFile = ObjectRef.create(null);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(opts.sources()), (Function1<String, Object> & Serializable)source -> {
            mergedSourceFile.elem = DACompactionDebugger$.MODULE$.generateOffsetMapUsingProductionCode(opts.inputDir(), source, (File)mergedSourceFile.elem, "source_merged");
            return BoxedUnit.UNIT;
        });
        scala.collection.SortedMap<ByteBuffer, kafka.durability.utils.OffsetInfo> sourceOffsetMap = DurabilityOffsetMapUtils$.MODULE$.retrieveOffsetMapInFile(((File)mergedSourceFile.elem).getParentFile(), ((File)mergedSourceFile.elem).getName());
        ObjectRef<Object> mergedDestinationFile = ObjectRef.create(null);
        scala.collection.SortedMap<ByteBuffer, kafka.durability.utils.OffsetInfo> destinationOffsetMap = (scala.collection.SortedMap<ByteBuffer, kafka.durability.utils.OffsetInfo>)SortedMap$.MODULE$.empty(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(opts.destinations()), (Function1<String, Object> & Serializable)destination -> {
            mergedDestinationFile.elem = DACompactionDebugger$.MODULE$.generateOffsetMapUsingProductionCode(opts.inputDir(), destination, (File)mergedDestinationFile.elem, "destination_merged");
            return BoxedUnit.UNIT;
        });
        if (opts.destinations().length != 0) {
            destinationOffsetMap = DurabilityOffsetMapUtils$.MODULE$.retrieveOffsetMapInFile(((File)mergedDestinationFile.elem).getParentFile(), ((File)mergedDestinationFile.elem).getName());
        }
        Predef$.MODULE$.println("total number of keys in source map generated by production code : " + CollectionConverters$.MODULE$.MapHasAsJava(sourceOffsetMap).asJava().size());
        if (destinationOffsetMap.nonEmpty()) {
            Predef$.MODULE$.println("total number of keys in destination map generated by production code : " + CollectionConverters$.MODULE$.MapHasAsJava(destinationOffsetMap).asJava().size());
        }
        if (destinationOffsetMap.nonEmpty()) {
            Predef$.MODULE$.println("comparing source and destination offset maps generated by production code");
            int mismatches = DurabilityOffsetMapUtils$.MODULE$.checkCongruentOffsetMapFile(null, (File)mergedSourceFile.elem, (File)mergedDestinationFile.elem);
            Predef$.MODULE$.println("Number of mismatches found using production code :  " + mismatches);
        }
        this.writeSortedMapToFile(sourceOffsetMap, "source_offset_map_production_code_generated.json", opts.sortBy());
        Files.deleteIfExists(Paths.get(((File)mergedSourceFile.elem).getPath(), new String[0]));
        if (destinationOffsetMap.nonEmpty()) {
            this.writeSortedMapToFile(destinationOffsetMap, "destination_offset_map_production_code_generated.json", opts.sortBy());
            Files.deleteIfExists(Paths.get(((File)mergedDestinationFile.elem).getPath(), new String[0]));
            return;
        }
    }

    private File generateOffsetMapUsingProductionCode(String directory, String fileName, File currentMergedFile, String offsetMapSuffix) {
        Predef$.MODULE$.println("processing file : " + fileName + " by production code");
        File file = new File(directory, fileName);
        FileInputStream inputStream = new FileInputStream(file);
        CleanedTransactionMetadata transactionMetadata = this.getTransactionMetadata(file.getAbsolutePath());
        ByteBuffer readBuffer = ByteBuffer.allocate(0xA00000);
        Throttler throttler = new Throttler(1.048576E7, 100L);
        SortedMap<ByteBuffer, kafka.durability.utils.OffsetInfo> offsetMap = DurabilityOffsetMapUtils$.MODULE$.filterKeysAndOffset(throttler, inputStream, readBuffer, transactionMetadata, Long.MIN_VALUE, Long.MAX_VALUE, DurabilityOffsetMapUtils$.MODULE$.filterKeysAndOffset$default$7());
        File newOffsetMap = new File(this.outputDirectory() + "offset_map_intermediate");
        DurabilityOffsetMapUtils$.MODULE$.storeOffsetMapInFile(offsetMap, newOffsetMap, false);
        File newMergedFile = null;
        if (currentMergedFile != null) {
            newMergedFile = new File(this.outputDirectory() + currentMergedFile.getName() + offsetMapSuffix);
            DurabilityOffsetMapUtils$.MODULE$.mergeOffsetMapFile(newOffsetMap, currentMergedFile, newMergedFile, Long.MIN_VALUE, Long.MAX_VALUE);
            v0 = BoxesRunTime.boxToBoolean(Files.deleteIfExists(Paths.get(currentMergedFile.getPath(), new String[0])));
        } else {
            newMergedFile = new File(this.outputDirectory() + offsetMapSuffix);
            newMergedFile = Files.copy(Paths.get(newOffsetMap.getPath(), new String[0]), Paths.get(newMergedFile.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING).toFile();
            v0 = BoxedUnit.UNIT;
        }
        Files.deleteIfExists(Paths.get(newOffsetMap.getPath(), new String[0]));
        return newMergedFile;
    }

    private CleanedTransactionMetadata getTransactionMetadata(String fileName) {
        String transactionIndexFileName = fileName.replace(".segment", "." + ObjectType.TRANSACTION_INDEX.suffix()).replace(".log", ".txnindex");
        File transactionIndexFile = new File(transactionIndexFileName);
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        if (transactionIndexFile.exists()) {
            FileInputStream trIdxInputStream = new FileInputStream(transactionIndexFile);
            List abortedTransactions = CollectionConverters$.MODULE$.ListHasAsScala(TierAbortedTxnReader.readInto(CancellationContext.newContext(), trIdxInputStream, 0L, Long.MAX_VALUE)).asScala().toList();
            transactionMetadata.addAbortedTransactions(CollectionConverters$.MODULE$.SeqHasAsJava(abortedTransactions).asJava());
        } else {
            Predef$.MODULE$.println("Transaction Index file not found for : " + fileName + ". Skipping aborted transactions of this segment, if any");
        }
        return transactionMetadata;
    }

    private void writeSortedMapToFile(scala.collection.SortedMap<ByteBuffer, kafka.durability.utils.OffsetInfo> offsetMap, String fileName, String sortBy) {
        File file = new File(this.outputDirectory() + fileName);
        Serializable serializable = !file.getParentFile().exists() ? BoxesRunTime.boxToBoolean(file.getParentFile().mkdirs()) : BoxedUnit.UNIT;
        Serializable serializable2 = !file.exists() ? BoxesRunTime.boxToBoolean(file.createNewFile()) : BoxedUnit.UNIT;
        ObjectWriter mapper = new ObjectMapper().setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY).writerWithDefaultPrettyPrinter();
        Object sortedList = null;
        sortedList = "offset".equals(sortBy) ? ((List)offsetMap.toList().sortWith((Function2<Tuple2, Tuple2, Object> & Serializable)(entry1, entry2) -> BoxesRunTime.boxToBoolean(DACompactionDebugger$.$anonfun$writeSortedMapToFile$1(entry1, entry2)))).map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                ByteBuffer k = (ByteBuffer)tuple2._1();
                kafka.durability.utils.OffsetInfo v = (kafka.durability.utils.OffsetInfo)tuple2._2();
                return new Tuple2<String, kafka.durability.utils.OffsetInfo>(MODULE$.base64(k), v);
            }
            throw new MatchError(tuple2);
        }) : offsetMap.toList().map((Function1<Tuple2, Tuple2> & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                ByteBuffer k = (ByteBuffer)tuple2._1();
                kafka.durability.utils.OffsetInfo v = (kafka.durability.utils.OffsetInfo)tuple2._2();
                return new Tuple2<String, kafka.durability.utils.OffsetInfo>(MODULE$.base64(k), v);
            }
            throw new MatchError(tuple2);
        });
        mapper.writeValue(file, CollectionConverters$.MODULE$.SeqHasAsJava(sortedList).asJava());
        Predef$.MODULE$.println("Successfully Generated File : " + file.getAbsolutePath());
    }

    public static final /* synthetic */ void $anonfun$compareInMemoryOffsetMap$1(scala.collection.SortedMap sourceOffsetMap$1, scala.collection.SortedMap destinationOffsetMap$1, ByteBuffer key) {
        String hashedKey = MODULE$.base64(key);
        if (sourceOffsetMap$1.contains(key) && !destinationOffsetMap$1.contains(key)) {
            if (!((kafka.durability.utils.OffsetInfo)sourceOffsetMap$1.apply(key)).isTombstone()) {
                Predef$.MODULE$.println("CHECK FAILED: Entry is missing for key : " + hashedKey + " in destination offset map , source offset : " + sourceOffsetMap$1.get(key));
                return;
            }
            return;
        }
        if (!sourceOffsetMap$1.contains(key) && destinationOffsetMap$1.contains(key)) {
            Predef$.MODULE$.println("Check failed : Entry is missing for key : " + hashedKey + " in source offset map , destination offset : " + destinationOffsetMap$1.get(key));
            return;
        }
        if (((kafka.durability.utils.OffsetInfo)sourceOffsetMap$1.apply(key)).offset() != ((kafka.durability.utils.OffsetInfo)destinationOffsetMap$1.apply(key)).offset()) {
            Predef$.MODULE$.println("Check failed : Offset values are not equal for key : " + hashedKey + " , source offset : " + sourceOffsetMap$1.get(key) + " , destination offset : " + destinationOffsetMap$1.get(key));
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$writeOffsetMapToFile$1(Tuple2 entry1, Tuple2 entry2) {
        return ((OffsetInfo)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)entry1._2()).asScala().head()).offset() < ((OffsetInfo)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)entry2._2()).asScala().head()).offset();
    }

    public static final /* synthetic */ boolean $anonfun$writeOffsetMapToFile$3(Tuple2 entry1, Tuple2 entry2) {
        return Ordered$.MODULE$.orderingToOrdered(entry1._1(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())).$less(entry2._1());
    }

    public static final /* synthetic */ boolean $anonfun$sortMapValues$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$sortMapValues$4(OffsetInfo p1, OffsetInfo p2) {
        return p2.offset() > p1.offset();
    }

    public static final /* synthetic */ boolean $anonfun$populateOffsetMapUsingCustomCode$2(HashMap offsetMap$1, FileLogInputStream.FileChannelRecordBatch batch$1, Record record) {
        ByteBuffer key = DurabilityOffsetMapUtils$.MODULE$.getHashedBuffer(record.key());
        offsetMap$1.putIfAbsent(key, new ArrayList());
        return ((java.util.List)offsetMap$1.get(key)).add(new OffsetInfo(record.offset(), !record.hasValue(), batch$1.isTransactional()));
    }

    public static final /* synthetic */ void $anonfun$populateOffsetMapUsingCustomCode$1(HashMap offsetMap$1, FileLogInputStream.FileChannelRecordBatch batch) {
        CollectionConverters$.MODULE$.IterableHasAsScala(batch).asScala().foreach((Function1<Record, Object> & Serializable)record -> BoxesRunTime.boxToBoolean(DACompactionDebugger$.$anonfun$populateOffsetMapUsingCustomCode$2(offsetMap$1, batch, record)));
    }

    public static final /* synthetic */ boolean $anonfun$writeSortedMapToFile$1(Tuple2 entry1, Tuple2 entry2) {
        return ((kafka.durability.utils.OffsetInfo)entry1._2()).offset() < ((kafka.durability.utils.OffsetInfo)entry2._2()).offset();
    }

    private DACompactionDebugger$() {
    }
}

