/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.utils;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.storage.tier.TopicIdPartition;
import io.confluent.kafka.storage.tier.store.DataTypePathPrefix;
import io.confluent.kafka.storage.tier.store.objects.FragmentType;
import io.confluent.kafka.storage.tier.store.objects.ObjectType;
import io.confluent.kafka.storage.tier.store.objects.metadata.ObjectStoreMetadata;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kafka.durability.utils.KeyAndVersionInfo;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.S3VersionInformation;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.VersionInformation;
import kafka.tier.store.objects.metadata.DurabilityAuditsOffsetMapMetadata;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;

public final class DurabilityObjectStoreUtils$
implements Logging {
    public static final DurabilityObjectStoreUtils$ MODULE$ = new DurabilityObjectStoreUtils$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        DurabilityObjectStoreUtils$ durabilityObjectStoreUtils$ = this;
        synchronized (durabilityObjectStoreUtils$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public Set<String> stringFormatUUID(Set<UUID> segments) {
        Set UUIDStringFormat = (Set)segments.map((Function1<UUID, String> & Serializable)x -> Utils.uuidToBase64((UUID)x));
        return UUIDStringFormat;
    }

    public void putOffsetMapFile(TierObjectStore tierStore, UUID objectId, TopicIdPartition topicIdPartition, File file) {
        DurabilityAuditsOffsetMapMetadata metadata = new DurabilityAuditsOffsetMapMetadata(topicIdPartition, objectId);
        tierStore.putObject(metadata, file, ObjectType.DA_OFFSET_MAP);
    }

    public TierObjectStoreResponse getOffsetMapFile(TierObjectStore tierStore, UUID objectId, TopicIdPartition topicIdPartition, Option<KeyAndVersionInfo> offsetMapVersionInfo) {
        DurabilityAuditsOffsetMapMetadata metadata = new DurabilityAuditsOffsetMapMetadata(topicIdPartition, objectId);
        return tierStore.getObjectStoreFragment(metadata, FragmentType.DA_OFFSET_MAP, null, null, offsetMapVersionInfo.get().versionInfo());
    }

    public void deleteOffsetMapFile(TierObjectStore tierStore, TopicIdPartition topicIdPartition) {
        this.debug((Function0<String> & Serializable)() -> "Deleting Tier Store Objects for " + topicIdPartition);
        String keyPrefix = DataTypePathPrefix.DA_OFFSET_MAP.prefix + "/" + topicIdPartition.topicIdAsBase64() + "/" + topicIdPartition.partition();
        Map<String, List<VersionInformation>> allBlobsWithVersions = tierStore.listObject(keyPrefix, true);
        allBlobsWithVersions.forEach((x0$1, x1$1) -> {
            Tuple2<String, List> tuple2 = new Tuple2<String, List>((String)x0$1, (List)x1$1);
            if (tuple2 != null) {
                String blobKey = tuple2._1();
                List versionList = tuple2._2();
                ArrayList<TierObjectStore.KeyAndVersion> deletionList = new ArrayList<TierObjectStore.KeyAndVersion>();
                versionList.forEach(versionInfo -> deletionList.add(new TierObjectStore.KeyAndVersion(blobKey, versionInfo.getVersionId())));
                if (!deletionList.isEmpty()) {
                    tierStore.deleteVersions(deletionList);
                    return;
                }
                return;
            }
            throw new MatchError(tuple2);
        });
    }

    public Map<String, List<VersionInformation>> listObjectWithRetries(TierObjectStore tierStore, TopicIdPartition topicIdPartition, String keyPrefix, boolean getVersionInfo, int count, int maxRetries) {
        Map<String, List<VersionInformation>> map;
        while (true) {
            try {
                Map<String, List<VersionInformation>> allBlobsWithVersions;
                map = allBlobsWithVersions = tierStore.listObject(keyPrefix, true);
            }
            catch (TierObjectStoreRetriableException e) {
                this.warn((Function0<String> & Serializable)() -> "Running into " + e + " get list for keyPrefix " + keyPrefix + " for " + topicIdPartition);
                if (count < maxRetries) {
                    ++count;
                    continue;
                }
                this.error((Function0<String> & Serializable)() -> "Retries failed,  into " + e + " get list for keyPrefix " + keyPrefix + " for " + topicIdPartition);
                throw e;
            }
            catch (Exception e) {
                this.error((Function0<String> & Serializable)() -> "Running into " + e + " get list for keyPrefix " + keyPrefix + " for " + topicIdPartition);
                throw e;
            }
            break;
        }
        return map;
    }

    public Option<KeyAndVersionInfo> getVersion(TierObjectStore tierStore, UUID objectId, TopicIdPartition topicIdPartition, FragmentType fragmentType, ObjectStoreMetadata metadata) {
        Option option;
        Object object = new Object();
        try {
            ObjectRef<String> keyPrefix = ObjectRef.create("");
            FragmentType fragmentType2 = fragmentType;
            if (((Object)((Object)FragmentType.DA_OFFSET_MAP)).equals((Object)fragmentType2)) {
                DurabilityAuditsOffsetMapMetadata metadata2 = new DurabilityAuditsOffsetMapMetadata(topicIdPartition, objectId);
                keyPrefix.elem = metadata2.toFragmentLocation("", FragmentType.DA_OFFSET_MAP).get().objectPath();
            } else if (((Object)((Object)FragmentType.SEGMENT)).equals((Object)fragmentType2) ? true : ((Object)((Object)FragmentType.TRANSACTION_INDEX)).equals((Object)fragmentType2)) {
                keyPrefix.elem = DataTypePathPrefix.TOPIC.prefix + "/" + Utils.uuidToBase64((UUID)objectId) + "/" + topicIdPartition.topicIdAsBase64() + "/" + topicIdPartition.partition();
            } else {
                throw new IllegalArgumentException("Unsupported fragment type " + fragmentType);
            }
            String objectSuffix = metadata.toFragmentLocation("", fragmentType).map(x$1 -> x$1.objectType()).orElse(ObjectType.getDefaultObjectTypeForFragmentType(fragmentType).get()).suffix();
            Map<String, List<VersionInformation>> allBlobsWithVersions = this.listObjectWithRetries(tierStore, topicIdPartition, (String)keyPrefix.elem, true, 0, 3);
            this.debug((Function0<String> & Serializable)() -> "got version map for " + (String)keyPrefix$2.elem + ": \n " + MODULE$.versionListMapToString(allBlobsWithVersions));
            allBlobsWithVersions.forEach((x0$1, x1$1) -> {
                Tuple2<String, List> tuple2 = new Tuple2<String, List>((String)x0$1, (List)x1$1);
                if (tuple2 != null) {
                    String blobKey = tuple2._1();
                    List versionList = tuple2._2();
                    if (blobKey.contains(objectSuffix)) {
                        versionList.forEach(versionInfo -> {
                            MODULE$.debug((Function0<String> & Serializable)() -> "Checking blob found with key " + blobKey + " version " + versionInfo + " for topicIdPartition " + topicIdPartition);
                            TierObjectStore.Backend backend = tierStore.getBackend();
                            TierObjectStore.Backend backend2 = TierObjectStore.Backend.S3;
                            if (!(backend != null ? !((Object)((Object)backend)).equals((Object)backend2) : backend2 != null)) {
                                S3VersionInformation vInfo = (S3VersionInformation)versionInfo;
                                if (!vInfo.isDeleteMarker()) {
                                    throw new NonLocalReturnControl<Option<KeyAndVersionInfo>>(object, Option$.MODULE$.apply(new KeyAndVersionInfo(blobKey, (VersionInformation)versionInfo)));
                                }
                                return;
                            }
                            TierObjectStore.Backend backend3 = tierStore.getBackend();
                            TierObjectStore.Backend backend4 = TierObjectStore.Backend.Mock;
                            if (!(backend3 != null ? !((Object)((Object)backend3)).equals((Object)backend4) : backend4 != null)) {
                                if (!versionInfo.getVersionId().equals("delete-marker")) {
                                    throw new NonLocalReturnControl<Option<KeyAndVersionInfo>>(object, Option$.MODULE$.apply(new KeyAndVersionInfo(blobKey, (VersionInformation)versionInfo)));
                                }
                                return;
                            }
                            throw new NonLocalReturnControl<Option<KeyAndVersionInfo>>(object, Option$.MODULE$.apply(new KeyAndVersionInfo(blobKey, (VersionInformation)versionInfo)));
                        });
                        return;
                    }
                    MODULE$.debug((Function0<String> & Serializable)() -> "File suffix not matching, found object: pattern = " + (String)keyPrefix$2.elem + ", topicIdPartition = " + topicIdPartition + ", key = " + blobKey + "; expected file type: " + objectSuffix);
                    return;
                }
                throw new MatchError(tuple2);
            });
            this.info((Function0<String> & Serializable)() -> "No versioned objects for pattern " + (String)keyPrefix$2.elem + " for topicIdPartition " + topicIdPartition);
            option = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public String versionListMapToString(Map<String, List<VersionInformation>> versionListMap) {
        StringBuilder sb = new StringBuilder();
        versionListMap.forEach((k, vList) -> DurabilityObjectStoreUtils$.keyVersions$1(k, vList, sb));
        return sb.toString();
    }

    private static final StringBuilder versions$1(VersionInformation v, StringBuilder sb$1, String k$1) {
        sb$1.append(k$1).append(": ").append(v.getVersionId());
        if (v instanceof S3VersionInformation) {
            S3VersionInformation s3v = (S3VersionInformation)v;
            v0 = sb$1.append("(isDeleteMarker: ").append(s3v.isDeleteMarker()).append(")");
        } else {
            v0 = BoxedUnit.UNIT;
        }
        return sb$1.append("\n");
    }

    private static final void keyVersions$1(String k, List vList, StringBuilder sb$1) {
        vList.stream().forEach(v -> DurabilityObjectStoreUtils$.versions$1(v, sb$1, k));
    }

    private DurabilityObjectStoreUtils$() {
    }
}

