/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.utils;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.storage.tier.TopicIdPartition;
import io.confluent.kafka.storage.tier.domain.AbstractTierMetadata;
import io.confluent.kafka.storage.tier.domain.TierCompactionCommitAndSwap;
import io.confluent.kafka.storage.tier.domain.TierRecordType;
import io.confluent.kafka.storage.tier.domain.TierSegmentUploadComplete;
import io.confluent.kafka.storage.tier.domain.TierSegmentUploadInitiate;
import io.confluent.kafka.storage.tier.domain.TierTopicInitLeader;
import io.confluent.kafka.storage.tier.state.CompactStats;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import kafka.durability.audit.DurabilityAuditConfig;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.utils.CommitAndSwapEvent;
import kafka.durability.utils.DurabilityTierTopicReader$;
import kafka.durability.utils.DurabilityTierTopicReaderClient$;
import kafka.durability.utils.DurabilityTierTopicReaderConfig;
import kafka.durability.utils.TierTopicEvents;
import kafka.durability.utils.TierTopicReaderMetricReporter;
import kafka.durability.utils.UploadCompleteEvent;
import kafka.durability.utils.UploadInitiateEvent;
import kafka.tier.topic.TierTopicPartitioner;
import kafka.utils.Logging;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.NonLocalReturnControl$mcZ$sp;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\t-a\u0001B\u0015+\u0001EB\u0001\"\u0010\u0001\u0003\u0006\u0004%\tA\u0010\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\u007f!Aa\t\u0001BC\u0002\u0013\u0005q\t\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003I\u0011!\u0019\u0006A!b\u0001\n\u0003!\u0006\u0002\u00039\u0001\u0005\u0003\u0005\u000b\u0011B+\t\u000bE\u0004A\u0011\u0002:\t\u000fa\u0004!\u0019!C\u0005s\"9\u0011\u0011\u0001\u0001!\u0002\u0013Q\b\"CA\u0002\u0001\t\u0007I\u0011BA\u0003\u0011!\tY\u0001\u0001Q\u0001\n\u0005\u001d\u0001\"CA\u0007\u0001\t\u0007I\u0011BA\b\u0011!\t9\u0002\u0001Q\u0001\n\u0005E\u0001\"CA\r\u0001\t\u0007I\u0011BA\u000e\u0011!\t\t\u0005\u0001Q\u0001\n\u0005u\u0001\"CA\"\u0001\t\u0007I\u0011BA#\u0011!\ti\u0005\u0001Q\u0001\n\u0005\u001d\u0003\"CA(\u0001\t\u0007I\u0011BA)\u0011!\t\t\u0007\u0001Q\u0001\n\u0005M\u0003\"CA2\u0001\t\u0007I\u0011BA3\u0011!\tY\b\u0001Q\u0001\n\u0005\u001d\u0004\"CA?\u0001\u0001\u0007I\u0011AA@\u0011%\tI\t\u0001a\u0001\n\u0003\tY\t\u0003\u0005\u0002\u0018\u0002\u0001\u000b\u0015BAA\u0011%\tI\n\u0001b\u0001\n\u0003\tY\n\u0003\u0005\u0002$\u0002\u0001\u000b\u0011BAO\u0011\u001d\t)\u000b\u0001C!\u0003\u000bAq!a*\u0001\t\u0013\t)\u0007C\u0004\u0002*\u0002!I!a+\t\u000f\u00055\u0006\u0001\"\u0003\u0002,\"9\u0011q\u0016\u0001\u0005\n\u0005E\u0006bBA]\u0001\u0011%\u00111\u0018\u0005\b\u0003/\u0004A\u0011AAm\u0011\u001d\ty\u000f\u0001C\u0001\u00037Aq!!=\u0001\t\u0003\t)\u0007C\u0004\u0002t\u0002!\t!!>\b\u000f\u0005](\u0006#\u0001\u0002z\u001a1\u0011F\u000bE\u0001\u0003wDa!\u001d\u0014\u0005\u0002\u0005u\bbBA\u0000M\u0011\u0005!\u0011\u0001\u0002\u001a\tV\u0014\u0018MY5mSRLH+[3s)>\u0004\u0018n\u0019*fC\u0012,'O\u0003\u0002,Y\u0005)Q\u000f^5mg*\u0011QFL\u0001\u000bIV\u0014\u0018MY5mSRL(\"A\u0018\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001A\r\u001d\u0011\u0005M2T\"\u0001\u001b\u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0003\r\u0005s\u0017PU3g!\tI4(D\u0001;\u0015\tYc&\u0003\u0002=u\t9Aj\\4hS:<\u0017AB2p]\u001aLw-F\u0001@!\t\u00015)D\u0001B\u0015\t\u0011E&A\u0003bk\u0012LG/\u0003\u0002E\u0003\n)B)\u001e:bE&d\u0017\u000e^=Bk\u0012LGoQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\u0014_:\u001cu.\u001c9mKR,7+[4oC2dWM]\u000b\u0002\u0011B\u0011\u0011\nU\u0007\u0002\u0015*\u00111\nT\u0001\u000bG>t7-\u001e:sK:$(BA'O\u0003\u0011)H/\u001b7\u000b\u0003=\u000bAA[1wC&\u0011\u0011K\u0013\u0002\u000f\u0007>,h\u000e\u001e#po:d\u0015\r^2i\u0003QygnQ8na2,G/Z*jO:\fG\u000e\\3sA\u0005\tBo\u001c9jGB\u000b'\u000f^5uS>tW*\u00199\u0016\u0003U\u0003BAV/a[:\u0011qk\u0017\t\u00031Rj\u0011!\u0017\u0006\u00035B\na\u0001\u0010:p_Rt\u0014B\u0001/5\u0003\u0019\u0001&/\u001a3fM&\u0011al\u0018\u0002\u0004\u001b\u0006\u0004(B\u0001/5!\t\t7.D\u0001c\u0015\t\u0019G-\u0001\u0003uS\u0016\u0014(BA3g\u0003\u001d\u0019Ho\u001c:bO\u0016T!aL4\u000b\u0005!L\u0017!C2p]\u001adW/\u001a8u\u0015\u0005Q\u0017AA5p\u0013\ta'M\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]B\u00111G\\\u0005\u0003_R\u0012A\u0001T8oO\u0006\u0011Bo\u001c9jGB\u000b'\u000f^5uS>tW*\u00199!\u0003\u0019a\u0014N\\5u}Q!1/\u001e<x!\t!\b!D\u0001+\u0011\u0015it\u00011\u0001@\u0011\u00151u\u00011\u0001I\u0011\u0015\u0019v\u00011\u0001V\u0003)\u0019G.[3oiRK\b/Z\u000b\u0002uB\u00111P`\u0007\u0002y*\u0011QPT\u0001\u0005Y\u0006tw-\u0003\u0002\u0000y\n11\u000b\u001e:j]\u001e\f1b\u00197jK:$H+\u001f9fA\u0005A1\r\\5f]RLE-\u0006\u0002\u0002\bA\u0019a+!\u0003\n\u0005}|\u0016!C2mS\u0016tG/\u00133!\u00039\u0019wN\\:v[\u0016\u00148i\u001c8gS\u001e,\"!!\u0005\u0011\u0007Q\f\u0019\"C\u0002\u0002\u0016)\u0012q\u0004R;sC\nLG.\u001b;z)&,'\u000fV8qS\u000e\u0014V-\u00193fe\u000e{gNZ5h\u0003=\u0019wN\\:v[\u0016\u00148i\u001c8gS\u001e\u0004\u0013\u0001C2p]N,X.\u001a:\u0016\u0005\u0005u\u0001\u0003CA\u0010\u0003c\t)$!\u000e\u000e\u0005\u0005\u0005\"\u0002BA\r\u0003GQA!!\n\u0002(\u000591\r\\5f]R\u001c(bA\u0018\u0002*)!\u00111FA\u0017\u0003\u0019\t\u0007/Y2iK*\u0011\u0011qF\u0001\u0004_J<\u0017\u0002BA\u001a\u0003C\u0011\u0001bQ8ogVlWM\u001d\t\u0006g\u0005]\u00121H\u0005\u0004\u0003s!$!B!se\u0006L\bcA\u001a\u0002>%\u0019\u0011q\b\u001b\u0003\t\tKH/Z\u0001\nG>t7/^7fe\u0002\nA\u0002\\8pW\n\u000b7m\u001b+j[\u0016,\"!a\u0012\u0011\u0007M\nI%C\u0002\u0002LQ\u00121!\u00138u\u00035awn\\6CC\u000e\\G+[7fA\u0005!B/[3s)>\u0004\u0018n\u0019)beRLG/[8oKJ,\"!a\u0015\u0011\t\u0005U\u0013QL\u0007\u0003\u0003/RA!!\u0017\u0002\\\u0005)Ao\u001c9jG*\u00111ML\u0005\u0005\u0003?\n9F\u0001\u000bUS\u0016\u0014Hk\u001c9jGB\u000b'\u000f^5uS>tWM]\u0001\u0016i&,'\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g.\u001a:!\u0003M!\u0018.\u001a:U_BL7\rU1si&$\u0018n\u001c8t+\t\t9\u0007\u0005\u0004\u0002j\u0005-\u0014qN\u0007\u0002\u0019&\u0019\u0011Q\u000e'\u0003\u0007M+G\u000f\u0005\u0003\u0002r\u0005]TBAA:\u0015\u0011\t)(a\n\u0002\r\r|W.\\8o\u0013\u0011\tI(a\u001d\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006!B/[3s)>\u0004\u0018n\u0019)beRLG/[8og\u0002\n!\"\u001a8e\u001f\u001a47/\u001a;t+\t\t\t\t\u0005\u0005\u0002j\u0005\r\u0015qNAC\u0013\tqF\nE\u0002|\u0003\u000fK!a\u001c?\u0002\u001d\u0015tGm\u00144gg\u0016$8o\u0018\u0013fcR!\u0011QRAJ!\r\u0019\u0014qR\u0005\u0004\u0003##$\u0001B+oSRD\u0011\"!&\u0018\u0003\u0003\u0005\r!!!\u0002\u0007a$\u0013'A\u0006f]\u0012|eMZ:fiN\u0004\u0013aD7fiJL7m\u001d*fa>\u0014H/\u001a:\u0016\u0005\u0005u\u0005c\u0001;\u0002 &\u0019\u0011\u0011\u0015\u0016\u0003;QKWM\u001d+pa&\u001c'+Z1eKJlU\r\u001e:jGJ+\u0007o\u001c:uKJ\f\u0001#\\3ue&\u001c7OU3q_J$XM\u001d\u0011\u0002\u00151|wmZ3s\u001d\u0006lW-A\u000bhKR$\u0016.\u001a:U_BL7\rU1si&$\u0018n\u001c8\u0002+%t\u0017\u000e\u001e+jKJ$v\u000e]5d\u0007>t7/^7feR\u0011\u0011QR\u0001\u0017G2|7/\u001a+jKJ$v\u000e]5d\u0007>t7/^7fe\u00069\u0002.Y:N_J,W*Z:tC\u001e,Gk\\\"p]N,X.Z\u000b\u0003\u0003g\u00032aMA[\u0013\r\t9\f\u000e\u0002\b\u0005>|G.Z1o\u0003M\u0019\bn\\;mI\u0006\u0003\b/\u001a8e\u001b\u0016\u001c8/Y4f)!\t\u0019,!0\u0002B\u0006M\u0007BBA`A\u0001\u0007\u0001-\u0001\tu_BL7-\u00133QCJ$\u0018\u000e^5p]\"9\u00111\u0019\u0011A\u0002\u0005\u0015\u0017\u0001\u0004;jKJ,\u0005o\\2i\u001b\u0006\u0004\bcBAd\u0003#\u0004\u0017qI\u0007\u0003\u0003\u0013TA!a3\u0002N\u00069Q.\u001e;bE2,'bAAhi\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0007y\u000bI\rC\u0004\u0002V\u0002\u0002\r!a\u0012\u0002\u00195,7o]1hK\u0016\u0003xn\u00195\u0002/\u0019LG\u000e^3s\u0007>l\u0007/Y2uS>tW*Z:tC\u001e,GCBAn\u0003G\fi\u000fE\u0004\u0002H\u0006E\u0007-!8\u0011\u0007Q\fy.C\u0002\u0002b*\u0012q\u0002V5feR{\u0007/[2Fm\u0016tGo\u001d\u0005\b\u0003K\f\u0003\u0019AAt\u0003\u001d\u0011XmY8sIN\u0004\u0002\"a\b\u0002j\u0006U\u0012QG\u0005\u0005\u0003W\f\tCA\bD_:\u001cX/\\3s%\u0016\u001cwN\u001d3t\u0011\u001d\t\u0019-\ta\u0001\u0003\u000b\f1bZ3u\u0007>t7/^7fe\u00061r-\u001a;US\u0016\u0014Hk\u001c9jGB\u000b'\u000f^5uS>t7/A\nsKR\u0014\u0018.\u001a<f)&,'OU3d_J$7\u000f\u0006\u0002\u0002\\\u0006IB)\u001e:bE&d\u0017\u000e^=US\u0016\u0014Hk\u001c9jGJ+\u0017\rZ3s!\t!he\u0005\u0002'eQ\u0011\u0011\u0011`\u0001\u0006CB\u0004H.\u001f\u000b\bg\n\r!Q\u0001B\u0004\u0011\u0015i\u0004\u00061\u0001@\u0011\u00151\u0005\u00061\u0001I\u0011\u0019\u0011I\u0001\u000ba\u0001+\u0006\u0011Bo\u001c9jGB\u000b'\u000f^5uS>t7/T1q\u0001")
public class DurabilityTierTopicReader
implements Logging {
    private final DurabilityAuditConfig config;
    private final CountDownLatch onCompleteSignaller;
    private final scala.collection.immutable.Map<TopicIdPartition, Object> topicPartitionMap;
    private final String clientType;
    private final String clientId;
    private final DurabilityTierTopicReaderConfig consumerConfig;
    private final Consumer<byte[], byte[]> consumer;
    private final int lookBackTime;
    private final TierTopicPartitioner tierTopicPartitioner;
    private final Set<TopicPartition> tierTopicPartitions;
    private Map<TopicPartition, Long> endOffsets;
    private final TierTopicReaderMetricReporter metricsReporter;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static DurabilityTierTopicReader apply(DurabilityAuditConfig config, CountDownLatch onCompleteSignaller, scala.collection.immutable.Map<TopicIdPartition, Object> topicPartitionsMap) {
        return DurabilityTierTopicReader$.MODULE$.apply(config, onCompleteSignaller, topicPartitionsMap);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        DurabilityTierTopicReader durabilityTierTopicReader = this;
        synchronized (durabilityTierTopicReader) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public DurabilityAuditConfig config() {
        return this.config;
    }

    public CountDownLatch onCompleteSignaller() {
        return this.onCompleteSignaller;
    }

    public scala.collection.immutable.Map<TopicIdPartition, Object> topicPartitionMap() {
        return this.topicPartitionMap;
    }

    private String clientType() {
        return this.clientType;
    }

    private String clientId() {
        return this.clientId;
    }

    private DurabilityTierTopicReaderConfig consumerConfig() {
        return this.consumerConfig;
    }

    private Consumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    private int lookBackTime() {
        return this.lookBackTime;
    }

    private TierTopicPartitioner tierTopicPartitioner() {
        return this.tierTopicPartitioner;
    }

    private Set<TopicPartition> tierTopicPartitions() {
        return this.tierTopicPartitions;
    }

    public Map<TopicPartition, Long> endOffsets() {
        return this.endOffsets;
    }

    public void endOffsets_$eq(Map<TopicPartition, Long> x$1) {
        this.endOffsets = x$1;
    }

    public TierTopicReaderMetricReporter metricsReporter() {
        return this.metricsReporter;
    }

    @Override
    public String loggerName() {
        return DurabilityTierTopicReader.class.getName();
    }

    private Set<TopicPartition> getTierTopicPartition() {
        HashSet<TopicPartition> tierTopic = new HashSet<TopicPartition>();
        this.topicPartitionMap().foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(DurabilityTierTopicReader.$anonfun$getTierTopicPartition$1(this, tierTopic, x0$1)));
        return tierTopic;
    }

    private void initTierTopicConsumer() {
        this.consumer().assign(this.tierTopicPartitions());
        long lookBackTimeInMs = Time.SYSTEM.milliseconds() - (long)this.lookBackTime();
        HashMap timeStampToSearch = new HashMap();
        scala.collection.mutable.Map validOffsetMap = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        this.topicPartitionMap().foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicIdPartition k = (TopicIdPartition)tuple2._1();
                long v = tuple2._2$mcJ$sp();
                TopicPartition tierTopicPartition = new TopicPartition("_confluent-tier-state", this.tierTopicPartitioner().partitionId(k));
                timeStampToSearch.put(tierTopicPartition, BoxesRunTime.boxToLong(lookBackTimeInMs));
                if (v != DurabilityAuditConstants$.MODULE$.TIER_TOPIC_INITIAL_SEEK()) {
                    return validOffsetMap.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tierTopicPartition), BoxesRunTime.boxToLong(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong(validOffsetMap.getOrElse(tierTopicPartition, () -> v))), v))));
                }
                return BoxedUnit.UNIT;
            }
            this.error((Function0<String> & Serializable)() -> "Empty Map give by user");
            throw new RuntimeException("Empty Map provided");
        });
        ObjectRef<$anon$1> timestampOffsets = ObjectRef.create(new HashMap<TopicPartition, OffsetAndTimestamp>(null){});
        if (!timeStampToSearch.isEmpty()) {
            timestampOffsets.elem = this.consumer().offsetsForTimes(timeStampToSearch);
        }
        this.tierTopicPartitions().forEach(tierTopicPartition -> {
            Option option;
            Tuple2 tuple2 = new Tuple2(((Map)timestampOffsets$1.elem).get(tierTopicPartition), validOffsetMap.get(tierTopicPartition));
            if (tuple2 != null) {
                OffsetAndTimestamp timeOffset = (OffsetAndTimestamp)tuple2._1();
                Option option2 = tuple2._2();
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    long explicitOffset = BoxesRunTime.unboxToLong(some.value());
                    if (timeOffset != null) {
                        this.consumer().seek(tierTopicPartition, RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(timeOffset.offset()), explicitOffset));
                        this.info((Function0<String> & Serializable)() -> "explicit offset " + explicitOffset + " timed offset " + timeOffset.offset() + " for topicPartition " + tierTopicPartition);
                        return;
                    }
                }
            }
            if (tuple2 != null) {
                OffsetAndTimestamp timeOffset = (OffsetAndTimestamp)tuple2._1();
                Option option3 = tuple2._2();
                if (None$.MODULE$.equals(option3) && timeOffset != null) {
                    this.consumer().seek(tierTopicPartition, timeOffset.offset());
                    this.info((Function0<String> & Serializable)() -> "timed offset " + timeOffset.offset() + " for topicPartition " + tierTopicPartition);
                    return;
                }
            }
            if (tuple2 != null && (option = tuple2._2()) instanceof Some) {
                Some some = (Some)option;
                long explicitOffset = BoxesRunTime.unboxToLong(some.value());
                this.consumer().seek(tierTopicPartition, explicitOffset);
                this.info((Function0<String> & Serializable)() -> "explicit offset " + explicitOffset + " for topicPartition " + tierTopicPartition);
                return;
            }
            this.consumer().seekToBeginning(Collections.singletonList(tierTopicPartition));
            this.info((Function0<String> & Serializable)() -> "Not able to find in timestamp for topicPartition " + tierTopicPartition);
        });
        this.endOffsets_$eq(this.consumer().endOffsets(this.tierTopicPartitions()));
    }

    private void closeTierTopicConsumer() {
        if (this.consumer() != null) {
            this.consumer().close();
            return;
        }
    }

    private boolean hasMoreMessageToConsume() {
        boolean bl;
        Object object = new Object();
        try {
            this.tierTopicPartitions().forEach(tierTopicPartition -> {
                Long l = this.endOffsets().get(tierTopicPartition);
                if (l != null && this.consumer().position(tierTopicPartition) < Predef$.MODULE$.Long2long(l)) {
                    throw new NonLocalReturnControl$mcZ$sp(object, true);
                }
                this.debug((Function0<String> & Serializable)() -> "Invalid offset for " + tierTopicPartition);
            });
            bl = false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    private boolean shouldAppendMessage(TopicIdPartition topicIdPartition, scala.collection.mutable.Map<TopicIdPartition, Object> tierEpochMap, int messageEpoch) {
        int tierEpoch = BoxesRunTime.unboxToInt(tierEpochMap.getOrElse(topicIdPartition, () -> messageEpoch));
        if (messageEpoch >= tierEpoch) {
            tierEpochMap.put(topicIdPartition, BoxesRunTime.boxToInteger(messageEpoch));
            return true;
        }
        return false;
    }

    public scala.collection.mutable.Map<TopicIdPartition, TierTopicEvents> filterCompactionMessage(ConsumerRecords<byte[], byte[]> records, scala.collection.mutable.Map<TopicIdPartition, Object> tierEpochMap) {
        scala.collection.mutable.Map messages = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        DoubleRef bytesRead = DoubleRef.create(0.0);
        records.forEach(record -> {
            block11: {
                block12: {
                    Some some;
                    boolean bl;
                    AbstractTierMetadata abstractTierMetadata;
                    block13: {
                        TierRecordType tierRecordType;
                        block16: {
                            block15: {
                                block14: {
                                    Some some2;
                                    AbstractTierMetadata tierMetadata;
                                    bytesRead$1.elem += (double)(record.serializedKeySize() + record.serializedValueSize());
                                    Option<AbstractTierMetadata> metadataEntryOpt = OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(AbstractTierMetadata.deserialize((byte[])record.key(), (byte[])record.value(), record.timestamp())));
                                    Option<AbstractTierMetadata> option = metadataEntryOpt;
                                    if (!(option instanceof Some) || (tierMetadata = (AbstractTierMetadata)(some2 = (Some)option).value()) == null) break block12;
                                    abstractTierMetadata = tierMetadata;
                                    bl = false;
                                    some = null;
                                    Option option2 = this.topicPartitionMap().get(abstractTierMetadata.topicIdPartition());
                                    if (!(option2 instanceof Some)) break block13;
                                    bl = true;
                                    some = (Some)option2;
                                    long value = BoxesRunTime.unboxToLong(some.value());
                                    if (record.offset() <= value && DurabilityAuditConstants$.MODULE$.TIER_TOPIC_INITIAL_SEEK() != value) break block13;
                                    tierRecordType = abstractTierMetadata.type();
                                    if (!((Object)((Object)TierRecordType.CompactionCommitAndSwap)).equals((Object)tierRecordType)) break block14;
                                    TierCompactionCommitAndSwap message = (TierCompactionCommitAndSwap)abstractTierMetadata;
                                    ObjectRef<scala.collection.immutable.Set> destObjectIds = ObjectRef.create((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                                    ObjectRef<scala.collection.immutable.Set> sourceObjectIds = ObjectRef.create((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                                    RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), message.destinationObjectIdsLength()).foreach$mVc$sp(ii -> {
                                        destObjectIds$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)destObjectIds$1.elem).$plus(message.destinationObjectIdsGet(ii));
                                    });
                                    RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), message.sourceObjectIdsLength()).foreach$mVc$sp(ii -> {
                                        sourceObjectIds$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)sourceObjectIds$1.elem).$plus(message.sourceObjectIdsGet(ii));
                                    });
                                    if (this.shouldAppendMessage(message.topicIdPartition(), tierEpochMap, message.tierEpoch())) {
                                        CompactStats compactStats = message.compactStats();
                                        CompactStats compactStats2 = CompactStats.EMPTY;
                                        messages.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(abstractTierMetadata.topicIdPartition()), ((TierTopicEvents)messages.getOrElse(abstractTierMetadata.topicIdPartition(), (Function0<TierTopicEvents> & Serializable)() -> new TierTopicEvents((Seq)package$.MODULE$.Seq().empty(), (Seq)package$.MODULE$.Seq().empty(), (Seq)package$.MODULE$.Seq().empty()))).$plus(new TierTopicEvents(new $colon$colon<Nothing$>((Nothing$)((Object)new CommitAndSwapEvent((scala.collection.immutable.Set)sourceObjectIds.elem, (scala.collection.immutable.Set)destObjectIds.elem, record.offset(), message.firstCleanOffset(), message.lastCleanOffset(), compactStats != null ? !((Object)compactStats).equals(compactStats2) : compactStats2 != null)), Nil$.MODULE$), (Seq)package$.MODULE$.Seq().empty(), (Seq)package$.MODULE$.Seq().empty()))));
                                        break block11;
                                    } else {
                                        this.info((Function0<String> & Serializable)() -> "Fenced message: " + message + " with tierEpoch " + tierEpochMap.getOrElse(message.topicIdPartition(), () -> -1));
                                    }
                                    break block11;
                                }
                                if (!((Object)((Object)TierRecordType.SegmentUploadInitiate)).equals((Object)tierRecordType)) break block15;
                                TierSegmentUploadInitiate message = (TierSegmentUploadInitiate)abstractTierMetadata;
                                if (this.shouldAppendMessage(message.topicIdPartition(), tierEpochMap, message.tierEpoch())) {
                                    messages.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(abstractTierMetadata.topicIdPartition()), ((TierTopicEvents)messages.getOrElse(abstractTierMetadata.topicIdPartition(), (Function0<TierTopicEvents> & Serializable)() -> new TierTopicEvents((Seq)package$.MODULE$.Seq().empty(), (Seq)package$.MODULE$.Seq().empty(), (Seq)package$.MODULE$.Seq().empty()))).$plus(new TierTopicEvents((Seq)package$.MODULE$.Seq().empty(), new $colon$colon<Nothing$>((Nothing$)((Object)new UploadInitiateEvent(message.objectId(), message)), Nil$.MODULE$), (Seq)package$.MODULE$.Seq().empty()))));
                                    break block11;
                                } else {
                                    this.info((Function0<String> & Serializable)() -> "Fenced message: " + message + " with tierEpoch " + tierEpochMap.getOrElse(message.topicIdPartition(), () -> -1));
                                }
                                break block11;
                            }
                            if (!((Object)((Object)TierRecordType.SegmentUploadComplete)).equals((Object)tierRecordType)) break block16;
                            TierSegmentUploadComplete message = (TierSegmentUploadComplete)abstractTierMetadata;
                            if (this.shouldAppendMessage(message.topicIdPartition(), tierEpochMap, message.tierEpoch())) {
                                messages.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(abstractTierMetadata.topicIdPartition()), ((TierTopicEvents)messages.getOrElse(abstractTierMetadata.topicIdPartition(), (Function0<TierTopicEvents> & Serializable)() -> new TierTopicEvents((Seq)package$.MODULE$.Seq().empty(), (Seq)package$.MODULE$.Seq().empty(), (Seq)package$.MODULE$.Seq().empty()))).$plus(new TierTopicEvents((Seq)package$.MODULE$.Seq().empty(), (Seq)package$.MODULE$.Seq().empty(), new $colon$colon<Nothing$>((Nothing$)((Object)new UploadCompleteEvent(message.objectId())), Nil$.MODULE$)))));
                                break block11;
                            } else {
                                this.info((Function0<String> & Serializable)() -> "Fenced message: " + message + " with tierEpoch " + tierEpochMap.getOrElse(message.topicIdPartition(), () -> -1));
                            }
                            break block11;
                        }
                        if (((Object)((Object)TierRecordType.InitLeader)).equals((Object)tierRecordType)) {
                            TierTopicInitLeader message = (TierTopicInitLeader)abstractTierMetadata;
                            int tierEpoch = BoxesRunTime.unboxToInt(tierEpochMap.getOrElse(message.topicIdPartition(), () -> message.tierEpoch()));
                            if (message.tierEpoch() >= tierEpoch) {
                                tierEpochMap.put(message.topicIdPartition(), BoxesRunTime.boxToInteger(message.tierEpoch()));
                            }
                            break block11;
                        } else {
                            this.debug((Function0<String> & Serializable)() -> "Events skipped");
                        }
                        break block11;
                    }
                    if (bl) {
                        long value = BoxesRunTime.unboxToLong(some.value());
                        this.debug((Function0<String> & Serializable)() -> "TopicIdPartition skipped " + abstractTierMetadata.topicIdPartition() + " as offset read " + record.offset() + " is  lower than given " + value);
                        break block11;
                    } else {
                        this.debug((Function0<String> & Serializable)() -> "TopicIdPartition skipped  " + abstractTierMetadata.topicIdPartition() + " as not given in input");
                    }
                    break block11;
                }
                this.error((Function0<String> & Serializable)() -> "Cannot deserialize the record correctly");
            }
            this.metricsReporter().updateAuditTierTopicReadBytes(bytesRead$1.elem);
        });
        return messages;
    }

    public Consumer<byte[], byte[]> getConsumer() {
        return this.consumer();
    }

    public Set<TopicPartition> getTierTopicPartitions() {
        return this.tierTopicPartitions();
    }

    public scala.collection.mutable.Map<TopicIdPartition, TierTopicEvents> retrieveTierRecords() {
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        scala.collection.mutable.Map tierEpochMap = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        IntRef count = IntRef.create(0);
        try {
            try {
                this.initTierTopicConsumer();
                while (this.hasMoreMessageToConsume() && this.onCompleteSignaller().getCount() != 0L && count.elem < this.config().tierBatchRecordsToConsume()) {
                    ConsumerRecords records = this.consumer().poll(Duration.ofMillis(this.config().tierPollDurationMs()));
                    scala.collection.mutable.Map<TopicIdPartition, TierTopicEvents> tierMessages = this.filterCompactionMessage((ConsumerRecords<byte[], byte[]>)records, tierEpochMap);
                    tierMessages.foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
                        DurabilityTierTopicReader.$anonfun$retrieveTierRecords$1(result, count, x0$1);
                        return BoxedUnit.UNIT;
                    });
                }
                this.debug((Function0<String> & Serializable)() -> "DurabilityTierTopicReader retrieved number of topicPartition " + result + ".size");
            }
            catch (Exception e) {
                this.error((Function0<String> & Serializable)() -> "Received error while executing", (Function0<Throwable>)(Function0<Exception> & Serializable)() -> e);
                throw e;
            }
        }
        finally {
            this.closeTierTopicConsumer();
        }
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$getTierTopicPartition$1(DurabilityTierTopicReader $this, Set tierTopic$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TopicIdPartition topicIdPartition = (TopicIdPartition)tuple2._1();
            return tierTopic$1.add(new TopicPartition("_confluent-tier-state", $this.tierTopicPartitioner().partitionId(topicIdPartition)));
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$retrieveTierRecords$1(scala.collection.mutable.Map result$1, IntRef count$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TopicIdPartition partition = (TopicIdPartition)tuple2._1();
            TierTopicEvents events = (TierTopicEvents)tuple2._2();
            result$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), ((TierTopicEvents)result$1.getOrElse(partition, (Function0<TierTopicEvents> & Serializable)() -> new TierTopicEvents((Seq)package$.MODULE$.Seq().empty(), (Seq)package$.MODULE$.Seq().empty(), (Seq)package$.MODULE$.Seq().empty()))).$plus(events)));
            count$1.elem += events.commitAndSwapMessages().size();
            return;
        }
        throw new MatchError(tuple2);
    }

    public DurabilityTierTopicReader(DurabilityAuditConfig config, CountDownLatch onCompleteSignaller, scala.collection.immutable.Map<TopicIdPartition, Object> topicPartitionMap) {
        this.config = config;
        this.onCompleteSignaller = onCompleteSignaller;
        this.topicPartitionMap = topicPartitionMap;
        Logging.$init$(this);
        this.clientType = "consumer";
        this.clientId = DurabilityTierTopicReaderClient$.MODULE$.clientId(this.clientType(), config.clusterId(), config.brokerId(), 0);
        this.consumerConfig = new DurabilityTierTopicReaderConfig(config);
        this.consumer = new KafkaConsumer(this.consumerConfig().consumerProperties(this.clientId()));
        this.lookBackTime = config.maxLookBackInDays() * 24 * 60 * 60 * 1000;
        this.tierTopicPartitioner = new TierTopicPartitioner(config.tierTopicPartitionNum());
        this.tierTopicPartitions = this.getTierTopicPartition();
        this.endOffsets = new HashMap<TopicPartition, Long>();
        this.metricsReporter = new TierTopicReaderMetricReporter(config.metrics());
    }
}

