/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Histogram;
import io.confluent.kafka.availability.FilesWrapper;
import io.confluent.kafka.storage.checksum.ChecksumParams;
import io.confluent.kafka.storage.tier.state.TierPartitionState;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import kafka.log.InterceptorStats;
import kafka.log.MergedLog;
import kafka.log.TierLogComponents;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.topic.TierTopic;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.CheckpointFileConfig;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.LoadedLogOffsets;
import org.apache.kafka.storage.internals.log.LocalLog;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogLoader;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.LogSegments;
import org.apache.kafka.storage.internals.log.LogValidator;
import org.apache.kafka.storage.internals.log.MergedLogUtils;
import org.apache.kafka.storage.internals.log.ProducerIdQuotaRecorder;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.log.metrics.BrokerTopicMetrics;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;

public final class MergedLog$
implements Logging {
    public static final MergedLog$ MODULE$ = new MergedLog$();
    private static final long LogDivergenceDetectionLoggingWindowMillis;
    private static final long LogDivergenceDetectionWindowMillis;
    private static final Pattern DeleteDirPattern;
    private static final Pattern FutureDirPattern;
    private static final Pattern StrayDirPattern;
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
        LogDivergenceDetectionLoggingWindowMillis = new package.DurationLong(package$.MODULE$.DurationLong(10L)).minute().toMillis();
        LogDivergenceDetectionWindowMillis = new package.DurationLong(package$.MODULE$.DurationLong(15L)).minute().toMillis();
        DeleteDirPattern = LocalLog.DELETE_DIR_PATTERN;
        FutureDirPattern = LocalLog.FUTURE_DIR_PATTERN;
        StrayDirPattern = LocalLog.STRAY_DIR_PATTERN;
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        MergedLog$ mergedLog$ = this;
        synchronized (mergedLog$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public Option<Histogram> $lessinit$greater$default$11() {
        return None$.MODULE$;
    }

    public CheckpointFileConfig $lessinit$greater$default$13() {
        return CheckpointFileConfig.DEFAULT;
    }

    public ServerLogConfigs.CleanupPolicyEmptyValidation $lessinit$greater$default$14() {
        return ServerLogConfigs.LOG_CLEANUP_POLICY_EMPTY_VALIDATION_DEFAULT;
    }

    public MergedLog apply(File dir, LogConfig config, LogSegments segments, long logStartOffset, long recoveryPoint, Scheduler scheduler, BrokerTopicStats brokerTopicStats, Metrics metrics, Time time, int producerIdExpirationCheckIntervalMs, TopicPartition topicPartition, LeaderEpochFileCache leaderEpochCache, ProducerStateManager producerStateManager, LogDirFailureChannel logDirFailureChannel, TierLogComponents tierLogComponents, boolean hadCleanShutdown, Option<Uuid> topicId, LogOffsetsListener logOffsetsListener, Option<Histogram> messageBatchSizeHistogram, ConcurrentMap<String, Integer> numRemainingSegments, ChecksumParams checksumParams, CheckpointFileConfig checkpointFileConfig, ServerLogConfigs.CleanupPolicyEmptyValidation cleanupPolicyEmptyValidation) {
        TierPartitionState tierPartitionState = this.initTierPartitionState(dir, topicPartition, tierLogComponents.partitionStateFactory(), config, logDirFailureChannel, scheduler, time);
        LoadedLogOffsets offsets = new LogLoader(dir, topicPartition, config, scheduler, time, logDirFailureChannel, hadCleanShutdown, segments, logStartOffset, recoveryPoint, leaderEpochCache, producerStateManager, numRemainingSegments, checksumParams).load();
        LocalLog localLog = new LocalLog(dir, config, segments, offsets.recoveryPoint, offsets.nextOffsetMetadata, scheduler, time, topicPartition, logDirFailureChannel, brokerTopicStats, logOffsetsListener, checksumParams);
        return new MergedLog(localLog, logStartOffset, hadCleanShutdown, metrics, leaderEpochCache, producerIdExpirationCheckIntervalMs, producerStateManager, topicId, tierPartitionState, tierLogComponents, messageBatchSizeHistogram, checksumParams, checkpointFileConfig, cleanupPolicyEmptyValidation);
    }

    public MergedLog apply(File dir, LogConfig config, long logStartOffset, long recoveryPoint, Scheduler scheduler, BrokerTopicStats brokerTopicStats, Metrics metrics, Time time, int maxTransactionTimeoutMs, ProducerStateManagerConfig producerStateManagerConfig, int producerIdExpirationCheckIntervalMs, Option<ProducerIdQuotaRecorder> producerIdQuotaManager, LogDirFailureChannel logDirFailureChannel, TierLogComponents tierLogComponents, boolean lastShutdownClean, Option<Uuid> topicId, LogOffsetsListener logOffsetsListener, Option<Histogram> messageBatchSizeHistogram, ConcurrentMap<String, Integer> numRemainingSegments, ChecksumParams checksumParams, CheckpointFileConfig checkpointFileConfig, ServerLogConfigs.CleanupPolicyEmptyValidation cleanupPolicyEmptyValidation) {
        FilesWrapper.createDirectories((Path)dir.toPath(), (FileAttribute[])new FileAttribute[0]);
        TopicPartition topicPartition = MergedLogUtils.parseTopicPartitionName(dir);
        LogSegments segments = new LogSegments(topicPartition);
        LeaderEpochFileCache leaderEpochCache = MergedLogUtils.createLeaderEpochCache(dir, topicPartition, logDirFailureChannel, checkpointFileConfig, Optional.empty(), scheduler);
        ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition, dir, maxTransactionTimeoutMs, producerStateManagerConfig, time, OptionConverters.RichOption$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOption(producerIdQuotaManager)), checksumParams);
        return this.apply(dir, config, segments, logStartOffset, recoveryPoint, scheduler, brokerTopicStats, metrics, time, producerIdExpirationCheckIntervalMs, topicPartition, leaderEpochCache, producerStateManager, logDirFailureChannel, tierLogComponents, lastShutdownClean, topicId, logOffsetsListener, messageBatchSizeHistogram, numRemainingSegments, checksumParams, checkpointFileConfig, cleanupPolicyEmptyValidation);
    }

    public Time apply$default$8() {
        return Time.SYSTEM;
    }

    public Option<ProducerIdQuotaRecorder> apply$default$12() {
        return None$.MODULE$;
    }

    public LogOffsetsListener apply$default$17() {
        return LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
    }

    public Option<Histogram> apply$default$18() {
        return None$.MODULE$;
    }

    public ConcurrentMap<String, Integer> apply$default$19() {
        return new ConcurrentHashMap<String, Integer>();
    }

    public CheckpointFileConfig apply$default$21() {
        return CheckpointFileConfig.DEFAULT;
    }

    public ServerLogConfigs.CleanupPolicyEmptyValidation apply$default$22() {
        return ServerLogConfigs.LOG_CLEANUP_POLICY_EMPTY_VALIDATION_DEFAULT;
    }

    private TierPartitionState initTierPartitionState(File dir, TopicPartition topicPartition, TierPartitionStateFactory tierPartitionStateFactory, LogConfig config, LogDirFailureChannel logDirFailureChannel, Scheduler scheduler, Time time) {
        return tierPartitionStateFactory.initState(dir, topicPartition, config, logDirFailureChannel, scheduler, time);
    }

    public boolean kafka$log$MergedLog$$isConfigValid(TopicPartition topicPartition, LogConfig config, ServerLogConfigs.CleanupPolicyEmptyValidation cleanupPolicyEmptyValidation) {
        if (!config.delete() && !config.compact()) {
            ServerLogConfigs.CleanupPolicyEmptyValidation cleanupPolicyEmptyValidation2 = cleanupPolicyEmptyValidation;
            if (((Object)((Object)ServerLogConfigs.CleanupPolicyEmptyValidation.LOG)).equals((Object)cleanupPolicyEmptyValidation2)) {
                this.error((Function0<String> & Serializable)() -> "Found empty value for cleanup.policy property for topic " + topicPartition.topic());
            }
        }
        if (topicPartition.topic().startsWith("_confluent-tier-state")) {
            return TierTopic.isConfigValid(this.logger().underlying(), topicPartition.topic(), config);
        }
        return true;
    }

    public long LogDivergenceDetectionLoggingWindowMillis() {
        return LogDivergenceDetectionLoggingWindowMillis;
    }

    public long LogDivergenceDetectionWindowMillis() {
        return LogDivergenceDetectionWindowMillis;
    }

    public Pattern DeleteDirPattern() {
        return DeleteDirPattern;
    }

    public Pattern FutureDirPattern() {
        return FutureDirPattern;
    }

    public Pattern StrayDirPattern() {
        return StrayDirPattern;
    }

    public long kafka$log$MergedLog$$firstUntieredOffset(TierPartitionState tierPartitionState) {
        return tierPartitionState.endOffset() + 1L;
    }

    public LogValidator.MetricsRecorder newValidatorMetricsRecorder(BrokerTopicMetrics allTopicsStats, InterceptorStats interceptorStats) {
        return new LogValidator.MetricsRecorder(allTopicsStats, interceptorStats){
            private final BrokerTopicMetrics allTopicsStats$1;
            private final InterceptorStats interceptorStats$1;

            public void recordInvalidMagic() {
                this.allTopicsStats$1.invalidMagicNumberRecordsPerSec().mark();
            }

            public void recordInvalidOffset() {
                this.allTopicsStats$1.invalidOffsetOrSequenceRecordsPerSec().mark();
            }

            public void recordInvalidSequence() {
                this.allTopicsStats$1.invalidOffsetOrSequenceRecordsPerSec().mark();
            }

            public void recordInvalidChecksums() {
                this.allTopicsStats$1.invalidMessageCrcRecordsPerSec().mark();
            }

            public void recordNoKeyCompactedTopic() {
                this.allTopicsStats$1.noKeyCompactedTopicRecordsPerSec().mark();
            }

            public void recordPastTimeDiffMoreThanOneHour() {
                this.allTopicsStats$1.pastMessagesWithTimeDiffMoreThanOneHourPerSec().get().mark();
            }

            public void recordPastTimeDiffMoreThanOneDay() {
                this.allTopicsStats$1.pastMessagesWithTimeDiffMoreThanOneDayPerSec().get().mark();
            }

            public void recordPastTimeDiffMoreThanOneYear() {
                this.allTopicsStats$1.pastMessagesWithTimeDiffMoreThanOneYearPerSec().get().mark();
            }

            public void recordFutureTimeDiffMoreThanOneHour() {
                this.allTopicsStats$1.futureMessagesWithTimeDiffMoreThanOneHourPerSec().get().mark();
            }

            public void recordFutureTimeDiffMoreThanOneDay() {
                this.allTopicsStats$1.futureMessagesWithTimeDiffMoreThanOneDayPerSec().get().mark();
            }

            public void recordFutureTimeDiffMoreThanOneYear() {
                this.allTopicsStats$1.futureMessagesWithTimeDiffMoreThanOneYearPerSec().get().mark();
            }

            public void recordRejectedRecords(String topicName, String interceptorClassName) {
                this.interceptorStats$1.logRejectedRecords(topicName, interceptorClassName);
            }

            public void recordRetriedRecords(String topicName, String interceptorClassName) {
                this.interceptorStats$1.logRetriedRecords(topicName, interceptorClassName);
            }
            {
                this.allTopicsStats$1 = allTopicsStats$1;
                this.interceptorStats$1 = interceptorStats$1;
            }
        };
    }

    private MergedLog$() {
    }
}

