/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.metrics.KafkaMetricsConfig;
import kafka.metrics.KafkaMetricsReporter;
import kafka.metrics.KafkaMetricsReporterMBean;
import kafka.utils.CoreUtils$;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.common.utils.Utils;
import scala.Function1;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class KafkaMetricsReporter$ {
    public static final KafkaMetricsReporter$ MODULE$ = new KafkaMetricsReporter$();
    private static final AtomicBoolean ReporterStarted = new AtomicBoolean(false);
    private static ArrayBuffer<KafkaMetricsReporter> reporters;

    private AtomicBoolean ReporterStarted() {
        return ReporterStarted;
    }

    private ArrayBuffer<KafkaMetricsReporter> reporters() {
        return reporters;
    }

    private void reporters_$eq(ArrayBuffer<KafkaMetricsReporter> x$1) {
        reporters = x$1;
    }

    public Seq<KafkaMetricsReporter> startReporters(VerifiableProperties verifiableProps) {
        AtomicBoolean atomicBoolean = this.ReporterStarted();
        synchronized (atomicBoolean) {
            if (!this.ReporterStarted().get()) {
                this.reporters_$eq((ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$));
                KafkaMetricsConfig metricsConfig = new KafkaMetricsConfig(verifiableProps);
                if (metricsConfig.reporters().nonEmpty()) {
                    metricsConfig.reporters().foreach((Function1<String, Object> & Serializable)reporterType -> {
                        KafkaMetricsReporter reporter = (KafkaMetricsReporter)Utils.newInstance((String)reporterType, KafkaMetricsReporter.class);
                        reporter.init(verifiableProps);
                        MODULE$.reporters().$plus$eq(reporter);
                        KafkaMetricsReporter kafkaMetricsReporter = reporter;
                        if (kafkaMetricsReporter instanceof KafkaMetricsReporterMBean) {
                            KafkaMetricsReporter kafkaMetricsReporter2 = kafkaMetricsReporter;
                            return BoxesRunTime.boxToBoolean(CoreUtils$.MODULE$.registerMBean(reporter, ((KafkaMetricsReporterMBean)((Object)kafkaMetricsReporter2)).getMBeanName()));
                        }
                        return BoxedUnit.UNIT;
                    });
                    this.ReporterStarted().set(true);
                }
            }
        }
        return this.reporters();
    }

    private KafkaMetricsReporter$() {
    }
}

