/*
 * Decompiled with CFR 0.152.
 */
package kafka.migration;

import io.confluent.kafka.storage.tier.TopicIdPartition;
import io.confluent.kafka.storage.tier.domain.AbstractTierMetadata;
import io.confluent.kafka.storage.tier.domain.TierPartitionDeleteInitiate;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kafka.server.KafkaConfig;
import kafka.tier.client.TierTopicProducerSupplier;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicManagerConfig;
import kafka.utils.CoreUtils$;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t-d\u0001B\u001a5\u0001eB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\"A!\f\u0001B\u0001B\u0003%1\fC\u0003i\u0001\u0011\u0005\u0011\u000eC\u0004p\u0001\t\u0007I\u0011\u00019\t\rU\u0004\u0001\u0015!\u0003r\u0011\u001d1\bA1A\u0005\n]Daa\u001f\u0001!\u0002\u0013A\bb\u0002?\u0001\u0005\u0004%I! \u0005\b\u0003\u0013\u0001\u0001\u0015!\u0003\u007f\u0011%\tY\u0001\u0001b\u0001\n\u0013\ti\u0001\u0003\u0005\u0002$\u0001\u0001\u000b\u0011BA\b\u0011%\t)\u0003\u0001b\u0001\n\u0013\ti\u0001\u0003\u0005\u0002(\u0001\u0001\u000b\u0011BA\b\u0011%\tI\u0003\u0001b\u0001\n\u0013\ti\u0001\u0003\u0005\u0002,\u0001\u0001\u000b\u0011BA\b\u0011%\ti\u0003\u0001b\u0001\n\u0013\ty\u0003\u0003\u0005\u00028\u0001\u0001\u000b\u0011BA\u0019\u0011%\tI\u0004\u0001b\u0001\n\u0013\tY\u0004\u0003\u0005\u0002j\u0001\u0001\u000b\u0011BA\u001f\u0011!\tY\u0007\u0001a\u0001\n\u00139\b\"CA7\u0001\u0001\u0007I\u0011BA8\u0011\u001d\tY\b\u0001Q!\naD1\"! \u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0000!Y\u0011q\u0012\u0001A\u0002\u0003\u0007I\u0011BAI\u0011-\t)\n\u0001a\u0001\u0002\u0003\u0006K!!!\t\u0017\u0005]\u0005\u00011AA\u0002\u0013%\u0011\u0011\u0014\u0005\f\u0003O\u0003\u0001\u0019!a\u0001\n\u0013\tI\u000bC\u0006\u0002.\u0002\u0001\r\u0011!Q!\n\u0005m\u0005bCAX\u0001\u0001\u0007\t\u0019!C\u0005\u0003cC1\"a4\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002R\"Y\u0011Q\u001b\u0001A\u0002\u0003\u0005\u000b\u0015BAZ\u0011-\t9\u000e\u0001a\u0001\u0002\u0004%I!!7\t\u0017\u0005\u0005\b\u00011AA\u0002\u0013%\u00111\u001d\u0005\f\u0003O\u0004\u0001\u0019!A!B\u0013\tY\u000eC\u0005\u0002j\u0002\u0011\r\u0011\"\u0003\u0002l\"A\u00111 \u0001!\u0002\u0013\ti\u000fC\u0004\u0002~\u0002!\t%a@\t\u000f\t\u0005\u0001\u0001\"\u0001\u0003\u0004!9!1\u0002\u0001\u0005\u0002\t\r\u0001b\u0002B\u0007\u0001\u0011\u0005!1\u0001\u0005\u0007\u0005\u001f\u0001A\u0011A<\t\u000f\tE\u0001\u0001\"\u0001\u0002\u0000\"9!1\u0003\u0001\u0005\u0002\tU\u0001b\u0002B\u0013\u0001\u0011\u0005\u0011q \u0005\b\u0005O\u0001A\u0011\u0002B\u0015\u0011\u001d\u0011I\u0005\u0001C\u0001\u0005\u0017BqA!\u001a\u0001\t\u0003\ty\u0010C\u0004\u0003h\u0001!I!a@\t\u000f\t%\u0004\u0001\"\u0003\u0002\u0000\nQR*[4sCRLwN\u001c+jKJ$v\u000e]5d!J|G-^2fe*\u0011QGN\u0001\n[&<'/\u0019;j_:T\u0011aN\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001!H\u0011\t\u0003w\u0001k\u0011\u0001\u0010\u0006\u0003{y\nA\u0001\\1oO*\tq(\u0001\u0003kCZ\f\u0017BA!=\u0005\u0019y%M[3diB\u00111hQ\u0005\u0003\tr\u0012\u0001BU;o]\u0006\u0014G.Z\u0001\u0007G>tg-[4\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%3\u0014AB:feZ,'/\u0003\u0002L\u0011\nY1*\u00194lC\u000e{gNZ5h\u0003%\u0019G.^:uKJLE\r\u0005\u0002O/:\u0011q*\u0016\t\u0003!Nk\u0011!\u0015\u0006\u0003%b\na\u0001\u0010:p_Rt$\"\u0001+\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001b\u0016A\u0002)sK\u0012,g-\u0003\u0002Y3\n11\u000b\u001e:j]\u001eT!AV*\u0002\tQLW.\u001a\t\u00039\u001al\u0011!\u0018\u0006\u0003=~\u000bQ!\u001e;jYNT!\u0001Y1\u0002\r\r|W.\\8o\u0015\t9$M\u0003\u0002dI\u00061\u0011\r]1dQ\u0016T\u0011!Z\u0001\u0004_J<\u0017BA4^\u0005\u0011!\u0016.\\3\u0002\rqJg.\u001b;?)\u0011QG.\u001c8\u0011\u0005-\u0004Q\"\u0001\u001b\t\u000b\u0015#\u0001\u0019\u0001$\t\u000b1#\u0001\u0019A'\t\u000bi#\u0001\u0019A.\u0002'5\u000b\u0005l\u0018)P\u00192{F+S'F\u001fV#v,T*\u0016\u0003E\u0004\"A]:\u000e\u0003MK!\u0001^*\u0003\t1{gnZ\u0001\u0015\u001b\u0006Cv\fU(M\u0019~#\u0016*T#P+R{Vj\u0015\u0011\u0002\u00135\u000b\u0005l\u0018*F)JKV#\u0001=\u0011\u0005IL\u0018B\u0001>T\u0005\rIe\u000e^\u0001\u000b\u001b\u0006CvLU#U%f\u0003\u0013a\u00017pOV\ta\u0010E\u0002\u0000\u0003\u000bi!!!\u0001\u000b\u0007\u0005\rA-A\u0003tY\u001a$$.\u0003\u0003\u0002\b\u0005\u0005!A\u0002'pO\u001e,'/\u0001\u0003m_\u001e\u0004\u0013aC5oSRL\u0017\r\\5{K\u0012,\"!a\u0004\u0011\t\u0005E\u0011qD\u0007\u0003\u0003'QA!!\u0006\u0002\u0018\u00051\u0011\r^8nS\u000eTA!!\u0007\u0002\u001c\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007\u0005ua(\u0001\u0003vi&d\u0017\u0002BA\u0011\u0003'\u0011Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017\u0001D5oSRL\u0017\r\\5{K\u0012\u0004\u0013aB:uCJ$X\rZ\u0001\tgR\f'\u000f^3eA\u000511\r\\8tK\u0012\fqa\u00197pg\u0016$\u0007%\u0001\bqe>$WoY3s)\"\u0014X-\u00193\u0016\u0005\u0005E\u0002c\u0001/\u00024%\u0019\u0011QG/\u0003\u0017-\u000bgm[1UQJ,\u0017\rZ\u0001\u0010aJ|G-^2feRC'/Z1eA\u0005q\u0011/^3vK\u0012lU\r^1eCR\fWCAA\u001f!\u0019\ty$!\u0011\u0002F5\u0011\u0011qC\u0005\u0005\u0003\u0007\n9BA\nMS:\\W\r\u001a\"m_\u000e\\\u0017N\\4Rk\u0016,X\r\u0005\u0004s\u0003\u000f\nY\u0005_\u0005\u0004\u0003\u0013\u001a&A\u0002+va2,'\u0007\u0005\u0003\u0002N\u0005\u0015TBAA(\u0015\u0011\t\t&a\u0015\u0002\r\u0011|W.Y5o\u0015\u0011\t)&a\u0016\u0002\tQLWM\u001d\u0006\u0005\u00033\nY&A\u0004ti>\u0014\u0018mZ3\u000b\u0007]\niF\u0003\u0003\u0002`\u0005\u0005\u0014!C2p]\u001adW/\u001a8u\u0015\t\t\u0019'\u0001\u0002j_&!\u0011qMA(\u0005Q\t%m\u001d;sC\u000e$H+[3s\u001b\u0016$\u0018\rZ1uC\u0006y\u0011/^3vK\u0012lU\r^1eCR\f\u0007%A\ngC&dW\rZ'fi\u0006$\u0017\r^1D_VtG/A\fgC&dW\rZ'fi\u0006$\u0017\r^1D_VtGo\u0018\u0013fcR!\u0011\u0011OA<!\r\u0011\u00181O\u0005\u0004\u0003k\u001a&\u0001B+oSRD\u0001\"!\u001f\u0017\u0003\u0003\u0005\r\u0001_\u0001\u0004q\u0012\n\u0014\u0001\u00064bS2,G-T3uC\u0012\fG/Y\"pk:$\b%\u0001\fuS\u0016\u0014Hk\u001c9jG6\u000bg.Y4fe\u000e{gNZ5h+\t\t\t\t\u0005\u0003\u0002\u0004\u0006-UBAAC\u0015\u0011\t9)!#\u0002\u000bQ|\u0007/[2\u000b\u0007\u0005Uc'\u0003\u0003\u0002\u000e\u0006\u0015%A\u0006+jKJ$v\u000e]5d\u001b\u0006t\u0017mZ3s\u0007>tg-[4\u00025QLWM\u001d+pa&\u001cW*\u00198bO\u0016\u00148i\u001c8gS\u001e|F%Z9\u0015\t\u0005E\u00141\u0013\u0005\n\u0003sJ\u0012\u0011!a\u0001\u0003\u0003\u000bq\u0003^5feR{\u0007/[2NC:\fw-\u001a:D_:4\u0017n\u001a\u0011\u00023QLWM\u001d+pa&\u001c\u0007K]8ek\u000e,'oU;qa2LWM]\u000b\u0003\u00037\u0003B!!(\u0002$6\u0011\u0011q\u0014\u0006\u0005\u0003C\u000bI)\u0001\u0004dY&,g\u000e^\u0005\u0005\u0003K\u000byJA\rUS\u0016\u0014Hk\u001c9jGB\u0013x\u000eZ;dKJ\u001cV\u000f\u001d9mS\u0016\u0014\u0018!\b;jKJ$v\u000e]5d!J|G-^2feN+\b\u000f\u001d7jKJ|F%Z9\u0015\t\u0005E\u00141\u0016\u0005\n\u0003sb\u0012\u0011!a\u0001\u00037\u000b!\u0004^5feR{\u0007/[2Qe>$WoY3s'V\u0004\b\u000f\\5fe\u0002\n\u0011\u0003^5feR{\u0007/[2Qe>$WoY3s+\t\t\u0019\f\u0005\u0005\u00026\u0006}\u00161YAb\u001b\t\t9L\u0003\u0003\u0002:\u0006m\u0016\u0001\u00039s_\u0012,8-\u001a:\u000b\u0007\u0005u\u0016-A\u0004dY&,g\u000e^:\n\t\u0005\u0005\u0017q\u0017\u0002\t!J|G-^2feB)!/!2\u0002J&\u0019\u0011qY*\u0003\u000b\u0005\u0013(/Y=\u0011\u0007I\fY-C\u0002\u0002NN\u0013AAQ=uK\u0006)B/[3s)>\u0004\u0018n\u0019)s_\u0012,8-\u001a:`I\u0015\fH\u0003BA9\u0003'D\u0011\"!\u001f \u0003\u0003\u0005\r!a-\u0002%QLWM\u001d+pa&\u001c\u0007K]8ek\u000e,'\u000fI\u0001\ni&,'\u000fV8qS\u000e,\"!a7\u0011\t\u0005\r\u0015Q\\\u0005\u0005\u0003?\f)IA\u0005US\u0016\u0014Hk\u001c9jG\u0006iA/[3s)>\u0004\u0018nY0%KF$B!!\u001d\u0002f\"I\u0011\u0011\u0010\u0012\u0002\u0002\u0003\u0007\u00111\\\u0001\u000bi&,'\u000fV8qS\u000e\u0004\u0013\u0001D7fiJL7m]$s_V\u0004XCAAw!\u0011\ty/a>\u000e\u0005\u0005E(\u0002BAz\u0003k\fq!\\3ue&\u001c7O\u0003\u0002JC&!\u0011\u0011`Ay\u0005EY\u0015MZ6b\u001b\u0016$(/[2t\u000fJ|W\u000f]\u0001\u000e[\u0016$(/[2t\u000fJ|W\u000f\u001d\u0011\u0002\u0007I,h\u000e\u0006\u0002\u0002r\u0005i\u0011n]%oSRL\u0017\r\\5{K\u0012,\"A!\u0002\u0011\u0007I\u00149!C\u0002\u0003\nM\u0013qAQ8pY\u0016\fg.A\u0005jgN#\u0018M\u001d;fI\u0006Q\u0011n]*ikR$wn\u001e8\u0002'E,X-^3e\u001b\u0016$\u0018\rZ1uC\u000e{WO\u001c;\u0002\u000bM$\u0018M\u001d;\u0002\u0015%t\u0017\u000e^5bY&TX\r\u0006\u0003\u0002r\t]\u0001b\u0002B\rY\u0001\u0007!1D\u0001\u0006S6\fw-\u001a\t\u0005\u0005;\u0011\t#\u0004\u0002\u0003 )\u0019!\u0011D1\n\t\t\r\"q\u0004\u0002\u000e\u001b\u0016$\u0018\rZ1uC&k\u0017mZ3\u0002\r\u0011|wk\u001c:l\u0003%\u0011X\r\u001e:z'\u0016tG\r\u0006\u0005\u0002r\t-\"q\u0006B\u001a\u0011\u001d\u0011iC\fa\u0001\u0003\u0017\n\u0001\"\\3uC\u0012\fG/\u0019\u0005\u0007\u0005cq\u0003\u0019\u0001=\u0002\u000bI,GO]=\t\u000f\tUb\u00061\u0001\u00038\u0005\tQ\r\u0005\u0003\u0003:\t\rc\u0002\u0002B\u001e\u0005\u007fq1\u0001\u0015B\u001f\u0013\u0005!\u0016b\u0001B!'\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B#\u0005\u000f\u0012\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\u0007\t\u00053+\u0001\u000frk\u0016,X\rU1si&$\u0018n\u001c8EK2,G/Z%oSRL\u0017\r^3\u0015\u0015\u0005E$Q\nB)\u0005;\u0012\t\u0007\u0003\u0004\u0003P=\u0002\r!T\u0001\u0011I\u0016dW\r^3e)>\u0004\u0018n\u0019(b[\u0016DqAa\u00150\u0001\u0004\u0011)&\u0001\beK2,G/\u001a3U_BL7-\u00133\u0011\t\t]#\u0011L\u0007\u0002?&\u0019!1L0\u0003\tU+\u0018\u000e\u001a\u0005\u0007\u0005?z\u0003\u0019\u0001=\u0002\u0013A\f'\u000f^5uS>t\u0007B\u0002B2_\u0001\u0007\u00010A\t{W\u000e{g\u000e\u001e:pY2,'/\u00129pG\"\f\u0001b\u001d5vi\u0012|wO\\\u0001\bG2,\u0017M\\;q\u00035\u0011X-\\8wK6+GO]5dg\u0002")
public class MigrationTierTopicProducer
implements Runnable {
    private final KafkaConfig config;
    private final String clusterId;
    private final Time time;
    private final long MAX_POLL_TIMEOUT_MS;
    private final int MAX_RETRY;
    private final Logger log;
    private final AtomicBoolean initialized;
    private final AtomicBoolean started;
    private final AtomicBoolean closed;
    private final KafkaThread producerThread;
    private final LinkedBlockingQueue<Tuple2<AbstractTierMetadata, Object>> queuedMetadata;
    private int failedMetadataCount;
    private TierTopicManagerConfig tierTopicManagerConfig;
    private TierTopicProducerSupplier tierTopicProducerSupplier;
    private Producer<byte[], byte[]> tierTopicProducer;
    private TierTopic tierTopic;
    private final KafkaMetricsGroup metricsGroup;

    public long MAX_POLL_TIMEOUT_MS() {
        return this.MAX_POLL_TIMEOUT_MS;
    }

    private int MAX_RETRY() {
        return this.MAX_RETRY;
    }

    private Logger log() {
        return this.log;
    }

    private AtomicBoolean initialized() {
        return this.initialized;
    }

    private AtomicBoolean started() {
        return this.started;
    }

    private AtomicBoolean closed() {
        return this.closed;
    }

    private KafkaThread producerThread() {
        return this.producerThread;
    }

    private LinkedBlockingQueue<Tuple2<AbstractTierMetadata, Object>> queuedMetadata() {
        return this.queuedMetadata;
    }

    private int failedMetadataCount() {
        return this.failedMetadataCount;
    }

    private void failedMetadataCount_$eq(int x$1) {
        this.failedMetadataCount = x$1;
    }

    private TierTopicManagerConfig tierTopicManagerConfig() {
        return this.tierTopicManagerConfig;
    }

    private void tierTopicManagerConfig_$eq(TierTopicManagerConfig x$1) {
        this.tierTopicManagerConfig = x$1;
    }

    private TierTopicProducerSupplier tierTopicProducerSupplier() {
        return this.tierTopicProducerSupplier;
    }

    private void tierTopicProducerSupplier_$eq(TierTopicProducerSupplier x$1) {
        this.tierTopicProducerSupplier = x$1;
    }

    private Producer<byte[], byte[]> tierTopicProducer() {
        return this.tierTopicProducer;
    }

    private void tierTopicProducer_$eq(Producer<byte[], byte[]> x$1) {
        this.tierTopicProducer = x$1;
    }

    private TierTopic tierTopic() {
        return this.tierTopic;
    }

    private void tierTopic_$eq(TierTopic x$1) {
        this.tierTopic = x$1;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    @Override
    public void run() {
        try {
            while (!this.closed().get()) {
                this.doWork();
            }
        }
        catch (Exception e) {
            if (this.closed().get()) {
                this.log().debug("Exception caught during shutdown", (Throwable)e);
            } else {
                this.log().error("Fatal exception in MigrationTierTopicProducer", (Throwable)e);
            }
        }
    }

    public boolean isInitialized() {
        return this.initialized().get();
    }

    public boolean isStarted() {
        return this.started().get();
    }

    public boolean isShutdown() {
        return this.closed().get();
    }

    public int queuedMetadataCount() {
        return this.queuedMetadata().size();
    }

    public void start() {
        if (this.initialized().get() && !this.closed().get()) {
            this.started().set(true);
            this.producerThread().start();
            return;
        }
    }

    public void initialize(MetadataImage image) {
        if (!this.initialized().get() && !this.closed().get()) {
            try {
                this.tierTopicManagerConfig_$eq(new TierTopicManagerConfig(this.config, this.tieredStorageInterBrokerClientConfigsSupplier$1(image), this.clusterId));
                this.tierTopicProducerSupplier_$eq(new TierTopicProducerSupplier(this.tierTopicManagerConfig(), this.time));
                this.tierTopic_$eq(new TierTopic(this.tierTopicManagerConfig().tierNamespace));
                this.tierTopic().initialize(this.tierTopicManagerConfig().configuredNumPartitions);
                this.tierTopicProducer_$eq(this.tierTopicProducerSupplier().get());
                this.initialized().set(true);
                this.log().info("Successfully initialized tier topic producer for ZK migration.");
            }
            catch (Exception e) {
                this.log().error("Error to initialize tier topic producer for ZK migration.", (Throwable)e);
            }
            return;
        }
    }

    public void doWork() {
        if (this.initialized().get()) {
            Tuple2<AbstractTierMetadata, Object> metadataNode = null;
            metadataNode = this.queuedMetadata().poll(this.MAX_POLL_TIMEOUT_MS(), TimeUnit.MILLISECONDS);
            if (metadataNode != null) {
                Tuple2<AbstractTierMetadata, Object> tuple2 = metadataNode;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                AbstractTierMetadata metadata = tuple2._1();
                int retryCount = tuple2._2$mcI$sp();
                Tuple2<AbstractTierMetadata, Integer> tuple22 = new Tuple2<AbstractTierMetadata, Integer>(metadata, BoxesRunTime.boxToInteger(retryCount));
                AbstractTierMetadata metadata2 = tuple22._1();
                int retryCount2 = tuple22._2$mcI$sp();
                if (new Tuple2<AbstractTierMetadata, Integer>(metadata2, BoxesRunTime.boxToInteger(retryCount2)) != null) {
                    TopicPartition tierTopicPartition = this.tierTopic().toTierTopicPartition(metadata2.topicIdPartition());
                    ProducerRecord producerRecord = new ProducerRecord(tierTopicPartition.topic(), Predef$.MODULE$.int2Integer(tierTopicPartition.partition()), (Object)metadata2.serializeKey(), (Object)metadata2.serializeValue());
                    try {
                        this.tierTopicProducer().send(producerRecord, (x$9, exception) -> {
                            if (exception != null) {
                                if (exception instanceof RetriableException) {
                                    this.retrySend(metadata2, retryCount2, exception);
                                    return;
                                }
                                this.failedMetadataCount_$eq(this.failedMetadataCount() + 1);
                                this.log().error("Caught exception when sending " + metadata2 + " to tier topic partition.", (Throwable)exception);
                                return;
                            }
                        });
                    }
                    catch (RetriableException e) {
                        this.retrySend(metadata2, retryCount2, (Exception)((Object)e));
                    }
                    catch (Throwable t) {
                        this.failedMetadataCount_$eq(this.failedMetadataCount() + 1);
                        this.log().error("Caught exception when sending " + metadata2 + " to tier topic partition.", t);
                    }
                    return;
                }
                return;
            }
            return;
        }
    }

    private void retrySend(AbstractTierMetadata metadata, int retry, Exception e) {
        int newRetryCount = retry + 1;
        if (newRetryCount < this.MAX_RETRY()) {
            this.queuedMetadata().add(new Tuple2<AbstractTierMetadata, Integer>(metadata, BoxesRunTime.boxToInteger(newRetryCount)));
            this.log().warn("Caught retriable exception when sending " + metadata + " to tier topic partition. Will try again, retry count: " + newRetryCount, (Throwable)e);
            return;
        }
        this.failedMetadataCount_$eq(this.failedMetadataCount() + 1);
        this.log().error("Caught retriable exception when sending " + metadata + " to tier topic partition. No more retry left.", (Throwable)e);
    }

    public void queuePartitionDeleteInitiate(String deletedTopicName, Uuid deletedTopicId, int partition, int zkControllerEpoch) {
        TopicIdPartition deletedPartition = new TopicIdPartition(deletedTopicName, CoreUtils$.MODULE$.toJavaUUID(deletedTopicId), partition);
        TierPartitionDeleteInitiate deleteInitiate = new TierPartitionDeleteInitiate(deletedPartition, zkControllerEpoch, UUID.randomUUID());
        this.queuedMetadata().add(new Tuple2<TierPartitionDeleteInitiate, Integer>(deleteInitiate, BoxesRunTime.boxToInteger(0)));
    }

    public void shutdown() {
        this.closed().set(true);
        this.removeMetrics();
        try {
            try {
                if (this.started().get()) {
                    this.producerThread().join();
                }
            }
            catch (InterruptedException e) {
                this.log().error("Shutdown interrupted", (Throwable)e);
            }
        }
        finally {
            this.cleanup();
        }
    }

    private void cleanup() {
        try {
            this.initialized().set(false);
            if (this.tierTopicProducer() != null) {
                this.tierTopicProducer().close(Duration.ofSeconds(1L));
            }
        }
        catch (Exception e) {
            this.log().error("Caught exception when closing tierTopicProducer.", (Throwable)e);
        }
    }

    private void removeMetrics() {
        this.metricsGroup().removeMetric("FailedMetadataCount");
        this.metricsGroup().removeMetric("QueuedMetadataCount");
    }

    private final Supplier tieredStorageInterBrokerClientConfigsSupplier$1(MetadataImage image$1) {
        return () -> {
            if ($this.config.confluentConfig().tierMetadataBootstrapServers() != null) {
                return Collections.singletonMap("bootstrap.servers", $this.config.confluentConfig().tierMetadataBootstrapServers());
            }
            ListenerName listenerName = $this.config.interBrokerListenerName();
            SecurityProtocol securityProtocol = $this.config.interBrokerSecurityProtocol();
            List brokerNodes = image$1.cluster().brokers().values().stream().map(x$5 -> x$5.node(listenerName.value())).filter(x$6 -> x$6.isPresent()).limit(3L).map(x$7 -> (Node)x$7.get()).collect(Collectors.toList());
            if (brokerNodes.size() > 0) {
                Node node = (Node)brokerNodes.get(0);
                Endpoint endpoint = new Endpoint(listenerName.value(), securityProtocol, node.host(), node.port());
                Map clientConfig = ConfluentConfigs.clientConfigsForEndpoint((AbstractConfig)$this.config, (Endpoint)endpoint);
                String servers = brokerNodes.stream().map(n -> n.host() + ":" + n.port()).collect(Collectors.joining(","));
                clientConfig.put("bootstrap.servers", servers);
                return clientConfig;
            }
            return Collections.emptyMap();
        };
    }

    public MigrationTierTopicProducer(KafkaConfig config, String clusterId, Time time) {
        this.config = config;
        this.clusterId = clusterId;
        this.time = time;
        this.MAX_POLL_TIMEOUT_MS = 100L;
        this.MAX_RETRY = 5;
        this.log = LoggerFactory.getLogger(MigrationTierTopicProducer.class);
        this.initialized = new AtomicBoolean(false);
        this.started = new AtomicBoolean(false);
        this.closed = new AtomicBoolean(false);
        this.producerThread = new KafkaThread("MigrationTierTopicProducer", (Runnable)this, false);
        this.queuedMetadata = new LinkedBlockingQueue();
        this.failedMetadataCount = 0;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.metricsGroup().newGauge("FailedMetadataCount", () -> BoxesRunTime.boxToInteger(this.failedMetadataCount()));
        this.metricsGroup().newGauge("QueuedMetadataCount", () -> BoxesRunTime.boxToInteger(this.queuedMetadataCount()));
    }
}

