/*
 * Decompiled with CFR 0.152.
 */
package kafka.network.netty;

import io.confluent.kafka.multitenant.InetAddressToTenantContext;
import io.confluent.kafka.multitenant.InetAddressToTenantMapping;
import io.netty.channel.ChannelOption;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.ssl.SslContext;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import kafka.network.ConnectionQuotas;
import kafka.network.KafkaListener;
import kafka.network.RequestChannel;
import kafka.network.netty.BrokerKafkaRequestHandler;
import kafka.network.netty.BrokerServerStreamHandler;
import kafka.network.netty.ConnectionMaxAgeManager;
import kafka.network.netty.KafkaAuthContext;
import kafka.server.KafkaConfig;
import kafka.server.QuotaFactory;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ProduceConsumeAuditLogTracker;
import org.apache.kafka.common.network.PublicCredential;
import org.apache.kafka.common.network.RequestCallback;
import org.apache.kafka.common.network.ReverseChannel;
import org.apache.kafka.common.network.netty.Http2AuthenticationContext;
import org.apache.kafka.common.network.netty.K2PStreamMetadata;
import org.apache.kafka.common.network.netty.NettyServer;
import org.apache.kafka.common.network.netty.NettyStream;
import org.apache.kafka.common.network.netty.ssl.Http2SslContext;
import org.apache.kafka.common.network.netty.ssl.ReconfigurableSslContext;
import org.apache.kafka.common.requests.RequestLogFilter;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipalBuilder;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.UniqueIdGenerator;
import org.apache.kafka.network.TooManyConnectionsException;
import org.apache.kafka.security.CredentialProvider;
import org.apache.kafka.server.ApiVersionManager;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.server.interceptor.BrokerInterceptor;
import org.slf4j.Logger;

public class NettyKafkaListener
extends KafkaListener {
    private final LogContext logContext;
    private final Logger log;
    private final int nodeId;
    private final KafkaConfig brokerConfig;
    private final Time time;
    private final RequestChannel requestChannel;
    private final Metrics metrics;
    private final String metricsGroup;
    private final Map<String, String> metricsTags;
    private final MemoryPool memoryPool;
    private final ApiVersionManager apiVersionManager;
    private final AuditLogProvider auditLogProvider;
    private final RequestLogFilter requestLogFilter;
    private final RequestCallback requestCallback;
    private final CredentialProvider credentialProvider;
    private final ConnectionQuotas connectionQuotas;
    private final QuotaFactory.QuotaManagers quotaManagers;
    private final ProduceConsumeAuditLogTracker produceConsumeAuditLogTracker;
    private final UniqueIdGenerator uniqueIdGenerator;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private NettyServer nettyServer;
    private volatile int boundPort;
    private ReconfigurableSslContext sslContext;
    private ConnectionMaxAgeManager connectionMaxAgeManager;
    private final AtomicLong sequenceIdGenerator = new AtomicLong(0L);
    private final ListenerName listenerName;
    private final InetAddressToTenantContext inetAddressToTenantContext;

    public NettyKafkaListener(int nodeId, Endpoint endpoint, KafkaConfig brokerConfig, Time time, RequestChannel requestChannel, Metrics metrics, CredentialProvider credentialProvider, MemoryPool memoryPool, ApiVersionManager apiVersionManager, ConnectionQuotas connectionQuotas, QuotaFactory.QuotaManagers quotaManagers, AuditLogProvider auditLogProvider, RequestCallback requestCallback) {
        this(nodeId, endpoint, brokerConfig, time, requestChannel, metrics, credentialProvider, new LogContext(String.format("[NettyServer listenerType=%s, nodeId=%d]", apiVersionManager.listenerType(), nodeId)), memoryPool, apiVersionManager, connectionQuotas, quotaManagers, auditLogProvider, requestCallback);
    }

    NettyKafkaListener(int nodeId, Endpoint endPoint, KafkaConfig brokerConfig, Time time, RequestChannel requestChannel, Metrics metrics, CredentialProvider credentialProvider, LogContext logContext, MemoryPool memoryPool, ApiVersionManager apiVersionManager, ConnectionQuotas connectionQuotas, QuotaFactory.QuotaManagers quotaManagers, AuditLogProvider auditLogProvider, RequestCallback requestCallback) {
        super(endPoint);
        this.boundPort = endPoint.port();
        this.logContext = logContext;
        this.log = logContext.logger(NettyKafkaListener.class);
        this.nodeId = nodeId;
        this.brokerConfig = brokerConfig;
        this.time = time;
        this.requestChannel = requestChannel;
        this.metrics = metrics;
        this.credentialProvider = credentialProvider;
        this.memoryPool = memoryPool;
        this.apiVersionManager = apiVersionManager;
        this.connectionQuotas = connectionQuotas;
        this.quotaManagers = quotaManagers;
        this.auditLogProvider = auditLogProvider;
        this.requestLogFilter = brokerConfig.newDetailedRequestAuditLogFilter();
        this.requestCallback = requestCallback;
        this.produceConsumeAuditLogTracker = new ProduceConsumeAuditLogTracker();
        this.uniqueIdGenerator = new UniqueIdGenerator();
        this.metricsGroup = "http2-listener-metrics";
        this.metricsTags = new LinkedHashMap<String, String>();
        this.metricsTags.put("listener", endPoint.listener());
        this.listenerName = ListenerName.normalised((String)endPoint.listener());
        this.inetAddressToTenantContext = new InetAddressToTenantContext(brokerConfig::trackTenantIDPerIP, brokerConfig::trackAPIKeyPerIP, brokerConfig::trackIpMappingMaxSize);
    }

    @Override
    public void start() {
        if (this.started.compareAndSet(false, true)) {
            if (this.nettyServer == null) {
                IllegalStateException exception = new IllegalStateException("NettyServer is not configured yet");
                this.startedFuture.completeExceptionally(exception);
                throw exception;
            }
            try {
                this.boundPort = (Integer)this.nettyServer.start(this.endpoint.port()).get();
                this.log.info("Started netty server on port {}", (Object)this.boundPort);
                this.startedFuture.complete(null);
            }
            catch (Throwable e) {
                this.log.error("Failed to start netty server", e);
                this.startedFuture.completeExceptionally(e);
            }
        } else {
            this.log.warn("Netty server is already started, ignoring");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void beginShutdown() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                if (this.nettyServer != null) {
                    this.nettyServer.shutdown();
                }
                if (this.sslContext != null) {
                    this.sslContext.close();
                }
                if (this.connectionMaxAgeManager == null) return;
                this.connectionMaxAgeManager.close();
                this.connectionMaxAgeManager = null;
                return;
            }
            catch (Exception e) {
                this.log.error("Error shutting down netty server", (Throwable)e);
                throw new RuntimeException(e);
            }
        } else {
            this.log.warn("Netty server is already shutting down, ignoring");
        }
    }

    @Override
    public void close() {
        this.beginShutdown();
    }

    @Override
    public void closeConnectionsWithCredential(PublicCredential credential) {
    }

    @Override
    protected int localPort() {
        if (this.boundPort <= 0) {
            this.start();
        }
        return this.boundPort;
    }

    @Override
    protected void reverseAndAdd(ReverseChannel reverseChannel) {
    }

    public ListenerName listenerName() {
        return ListenerName.normalised((String)this.endpoint.listener());
    }

    public Set<String> reconfigurableConfigs() {
        return Collections.emptySet();
    }

    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
    }

    public void reconfigure(Map<String, ?> configs) {
    }

    public void configure(Map<String, ?> configs) {
        if (this.isSslListener()) {
            this.sslContext = Http2SslContext.forServer();
            this.sslContext.configure(configs);
        }
        this.nettyServer = this.newNettyServer(configs);
        this.setupConnectionMaxAgeManager(configs);
    }

    private boolean isSslListener() {
        return this.endpoint.securityProtocol() == SecurityProtocol.SSL || this.endpoint.securityProtocol() == SecurityProtocol.SASL_SSL;
    }

    NettyServer newNettyServer(Map<String, ?> configs) {
        int numBossThreads = ConfluentConfigs.getIntValueOrDefault(configs, (String)"confluent.protocol.netty.num.boss.threads", (int)1);
        int numWorkerThreads = ConfluentConfigs.getIntValueOrDefault(configs, (String)"confluent.protocol.netty.num.worker.threads", (int)4);
        boolean http2FlowControlEnabled = ConfluentConfigs.getBooleanValueOrDefault(configs, (String)"confluent.protocol.netty.http2.flow.control.enabled", (boolean)true);
        int http2ConnectionWindowSize = ConfluentConfigs.getIntValueOrDefault(configs, (String)"confluent.protocol.netty.http2.connection.window.size", (int)0x1E00000);
        return NettyServer.Builder.newServerBuilder((LogContext)this.logContext, (String)this.endpoint.listener(), (SslContext)this.sslContext, this.buildStreamHandlerCreator(configs), (NettyServer.NettyServerProtocol)NettyServer.NettyServerProtocol.HTTP2, (boolean)false).withBossThreads(numBossThreads).withWorkerThreads(numWorkerThreads).withHttp2Settings(NettyKafkaListener.createHttp2Settings(configs)).withFlowControlEnabled(http2FlowControlEnabled).withHttp2ConnectionWindowSize(http2ConnectionWindowSize).withOption(ChannelOption.SO_BACKLOG, (Object)1024).build();
    }

    BiFunction<NettyStream, Http2Headers, NettyStream.StreamHandler> buildStreamHandlerCreator(Map<String, ?> configs) {
        Optional<KafkaPrincipalSerde> principalSerde = NettyKafkaListener.createKafkaPrincipalSerde(configs);
        BrokerInterceptor brokerInterceptor = ConfluentConfigs.buildBrokerInterceptor((ConnectionMode)ConnectionMode.SERVER, configs);
        int gracefulCloseTimeoutMs = ConfluentConfigs.getIntValueOrDefault(configs, (String)"confluent.protocol.netty.http2.stream.graceful.close.timeout.ms", (int)ConfluentConfigs.HTTP2_STREAM_GRACEFUL_CLOSE_TIMEOUT_MS_DEFAULT);
        return (stream, headers) -> {
            KafkaAuthContext authContext = this.buildAuthContext((NettyStream)stream, (Http2Headers)headers, principalSerde);
            final InetAddress clientAddress = authContext.authenticationContext().clientAddress();
            if (this.connectionQuotas.violateConnectionCountQuota(this.listenerName, clientAddress)) {
                this.log.warn("Stream from {} rejected due to connection quota", (Object)clientAddress);
                throw new TooManyConnectionsException(clientAddress.toString());
            }
            long throttleTimeMs = this.connectionQuotas.incrementAndGetConnectionRateThrottleTime(this.listenerName, clientAddress, (InetAddressToTenantMapping)this.inetAddressToTenantContext);
            if (throttleTimeMs > 0L) {
                this.log.warn("Stream from {} throttled for {} ms due to connection quota", (Object)clientAddress, (Object)throttleTimeMs);
                stream.scheduleWithDelayOnEventLoop(() -> ((NettyStream)stream).closeStream(), throttleTimeMs, TimeUnit.MILLISECONDS);
                return new NettyStream.NoOpStreamHandler(this){
                    final /* synthetic */ NettyKafkaListener this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void handleClose() {
                        this.this$0.connectionQuotas.dec(this.this$0.listenerName, clientAddress, (InetAddressToTenantMapping)this.this$0.inetAddressToTenantContext);
                    }
                };
            }
            BrokerKafkaRequestHandler kafkaRequestHandler = this.buildKafkaRequestHandler(brokerInterceptor);
            long creationTimeMs = this.time.milliseconds();
            long seqId = this.sequenceIdGenerator.getAndIncrement();
            BrokerServerStreamHandler streamHandler = new BrokerServerStreamHandler((NettyStream)stream, kafkaRequestHandler, principalSerde.orElse(null), authContext, this.brokerConfig.socketRequestMaxBytes(), this.brokerConfig.requestPipeliningMaxInFlightRequestsPerConnection(), gracefulCloseTimeoutMs, () -> {
                this.connectionQuotas.dec(this.listenerName, clientAddress, (InetAddressToTenantMapping)this.inetAddressToTenantContext);
                if (this.connectionMaxAgeManager != null) {
                    this.connectionMaxAgeManager.untrackConnectionAsync(stream.streamId(), creationTimeMs, seqId);
                }
            });
            if (this.connectionMaxAgeManager != null) {
                this.connectionMaxAgeManager.trackConnectionAsync(stream.streamId(), creationTimeMs, seqId, streamHandler::closeGracefully);
            }
            return streamHandler;
        };
    }

    private KafkaAuthContext buildAuthContext(NettyStream stream, Http2Headers headers, Optional<KafkaPrincipalSerde> principalSerde) {
        try {
            int streamId = Integer.parseInt(stream.streamId());
            if (streamId <= 0) {
                throw new IllegalStateException("Received invalid stream id " + stream.streamId());
            }
            K2PStreamMetadata streamMetadata = new K2PStreamMetadata(headers, principalSerde);
            ListenerName listenerName = ListenerName.normalised((String)this.endpoint.listener());
            Http2AuthenticationContext http2AuthContext = new Http2AuthenticationContext(streamMetadata, this.endpoint.securityProtocol(), listenerName, (long)streamId);
            return new KafkaAuthContext(streamMetadata.principal(), (AuthenticationContext)http2AuthContext, streamMetadata.clientPort(), streamMetadata.clientInformation());
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Stream id is not integer: " + stream.streamId(), e);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Failed to create authentication context", e);
        }
    }

    private BrokerKafkaRequestHandler buildKafkaRequestHandler(BrokerInterceptor brokerInterceptor) {
        return new BrokerKafkaRequestHandler(this.nodeId, this.time, () -> this.uniqueIdGenerator.generate(this.time.milliseconds()), brokerInterceptor, this.metrics, this.apiVersionManager, this.produceConsumeAuditLogTracker, this.memoryPool, this.requestChannel, this.requestCallback, this.auditLogProvider, this.requestLogFilter);
    }

    private void setupConnectionMaxAgeManager(Map<String, ?> configs) {
        long connectionMaxAgeMs = ConfluentConfigs.getLongValueOrDefault(configs, (String)"connections.max.age.ms", (long)ConfluentConfigs.CONNECTIONS_MAX_AGE_MS_DEFAULT);
        long connectionMinExpireIntervalMs = ConfluentConfigs.getLongValueOrDefault(configs, (String)"connection.min.expire.interval.ms", (long)ConfluentConfigs.CONNECTIONS_MIN_EXPIRE_INTERVAL_DEFAULT);
        if (this.connectionMaxAgeManager == null) {
            this.connectionMaxAgeManager = new ConnectionMaxAgeManager(this.metrics, this.metricsGroup, this.metricsTags, this.time, connectionMaxAgeMs, connectionMinExpireIntervalMs);
        } else {
            this.connectionMaxAgeManager.setConnectionMaxAgeTime(connectionMaxAgeMs);
        }
    }

    static Optional<KafkaPrincipalSerde> createKafkaPrincipalSerde(Map<String, ?> configs) {
        Optional<KafkaPrincipalSerde> optional;
        KafkaPrincipalBuilder builder = ChannelBuilders.createPrincipalBuilder(configs, null, null);
        if (builder instanceof KafkaPrincipalSerde) {
            KafkaPrincipalSerde serde = (KafkaPrincipalSerde)builder;
            optional = Optional.of(serde);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    static Http2Settings createHttp2Settings(Map<String, ?> configs) {
        int initialWindowSize = ConfluentConfigs.getIntValueOrDefault(configs, (String)"confluent.protocol.netty.http2.initial.window.size", (int)153600);
        int maxFrameSize = ConfluentConfigs.getIntValueOrDefault(configs, (String)"confluent.protocol.netty.http2.max.frame.size", (int)16384);
        return Http2Settings.defaultSettings().initialWindowSize(initialWindowSize).maxFrameSize(maxFrameSize);
    }
}

