/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.configmap;

import java.io.FileWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import kafka.restore.RestoreTierPartitionState;
import kafka.restore.configmap.ConfigmapUtil;
import kafka.restore.configmap.RestoreTopicListConfig;
import kafka.tier.tools.RecoveryUtils;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.clients.admin.AdminClient;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class TopicPartitionConfigMapGenerator {
    private static final String BOOTSTRAP_SERVER_CONFIG = "bootstrap-server";
    private static final String BOOTSTRAP_SERVER_DOC = "The Kafka server to connect to";
    private static final String OUTPUT_FILE_CONFIG = "output-file";
    private static final String OUTPUT_FILE_DOC = "The file to output the PartitionConfigMap";
    private static final String FROM_TIMESTAMP_CONFIG = "from-timestamp";
    private static final String FROM_TIMESTAMP_DOC = "Restore from timestamp, unix epoch in millisecond";
    private static final String REVERT_COMPACTION_SINCE_TIMESTAMP_CONFIG = "revert-compaction-since-timestamp";
    private static final String REVERT_COMPACTION_SINCE_TIMESTAMP_DOC = "Revert compaction since timestamp, unix epoch in millisecond";
    private static final String TOPICS_CONFIG = "topics";
    private static final String TOPICS_DOC = "Topics to be restored, empty for all eligible topics";
    private static final String DEFAULT_BOOTSTRAP_SERVER = "localhost:9071";
    private static final String DEFAULT_OUTPUT_FILE = "restoreTopicPartitions.yaml";

    public static void main(String[] args) throws Exception {
        System.out.println("Received cmdline args: " + Arrays.toString(args));
        ArgumentParser cliParser = TopicPartitionConfigMapGenerator.createComparatorParser();
        Namespace res = cliParser.parseArgs(args);
        String bootstrapServer = res.getString(BOOTSTRAP_SERVER_CONFIG);
        String outputFile = res.getString(OUTPUT_FILE_CONFIG);
        String strFromTimestamp = res.getString(FROM_TIMESTAMP_CONFIG);
        long fromTimestamp = 0L;
        if (strFromTimestamp != null && strFromTimestamp.length() > 0) {
            fromTimestamp = Long.parseLong(strFromTimestamp);
        }
        String strRevertCompactionSinceTimestamp = res.getString(REVERT_COMPACTION_SINCE_TIMESTAMP_CONFIG);
        long revertCompactionSinceTimestamp = fromTimestamp;
        if (strRevertCompactionSinceTimestamp != null && strRevertCompactionSinceTimestamp.length() > 0) {
            revertCompactionSinceTimestamp = Long.parseLong(strRevertCompactionSinceTimestamp);
        }
        if (revertCompactionSinceTimestamp != fromTimestamp) {
            throw new IllegalArgumentException("revert-compaction-since-timestamp(" + revertCompactionSinceTimestamp + ") is not equal to from-timestamp(" + fromTimestamp + ")");
        }
        String topics = res.getString(TOPICS_CONFIG);
        Properties properties = new Properties();
        properties.put("bootstrap.servers", bootstrapServer != null ? bootstrapServer : DEFAULT_BOOTSTRAP_SERVER);
        properties.put("connections.max.idle.ms", (Object)10000);
        properties.put("request.timeout.ms", (Object)5000);
        AdminClient kafkaAdminClient = AdminClient.create((Properties)properties);
        RestoreTopicListConfig restoreTopicListConfig = ConfigmapUtil.buildRestorePartitionConfig(kafkaAdminClient, fromTimestamp, revertCompactionSinceTimestamp, TopicPartitionConfigMapGenerator.toSet(topics));
        FileWriter outputFileWriter = new FileWriter(outputFile != null ? outputFile : DEFAULT_OUTPUT_FILE);
        LoaderOptions options = new LoaderOptions();
        options.setAllowRecursiveKeys(false);
        Yaml yaml = new Yaml(new SafeConstructor(options));
        String restoreTopicListConfigString = yaml.dumpAsMap(restoreTopicListConfig);
        outputFileWriter.write(restoreTopicListConfigString);
        outputFileWriter.close();
    }

    private static ArgumentParser createComparatorParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser(RestoreTierPartitionState.class.getName()).defaultHelp(true).description("Restore the tier-state file from given timestamp");
        parser.addArgument(RecoveryUtils.makeArgument(BOOTSTRAP_SERVER_CONFIG)).dest(BOOTSTRAP_SERVER_CONFIG).type(String.class).required(false).help(BOOTSTRAP_SERVER_DOC);
        parser.addArgument(RecoveryUtils.makeArgument(OUTPUT_FILE_CONFIG)).dest(OUTPUT_FILE_CONFIG).type(String.class).required(false).help(OUTPUT_FILE_DOC);
        parser.addArgument(RecoveryUtils.makeArgument(TOPICS_CONFIG)).dest(TOPICS_CONFIG).type(String.class).required(false).help(TOPICS_DOC);
        parser.addArgument(RecoveryUtils.makeArgument(FROM_TIMESTAMP_CONFIG)).dest(FROM_TIMESTAMP_CONFIG).type(String.class).required(false).help(FROM_TIMESTAMP_DOC);
        parser.addArgument(RecoveryUtils.makeArgument(REVERT_COMPACTION_SINCE_TIMESTAMP_CONFIG)).dest(REVERT_COMPACTION_SINCE_TIMESTAMP_CONFIG).type(String.class).required(false).help(REVERT_COMPACTION_SINCE_TIMESTAMP_DOC);
        return parser;
    }

    private static Set<String> toSet(String topics) {
        if (topics == null || topics.trim().length() == 0) {
            return new HashSet<String>();
        }
        return Arrays.stream(topics.trim().split(",")).collect(Collectors.toSet());
    }
}

