/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.rest.ResponseContainer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kafka.restore.RestoreConfig;
import kafka.restore.RestoreMetricsManager;
import kafka.restore.RestoreOrchestrator;
import kafka.restore.db.FileRestoreDB;
import kafka.restore.db.Job;
import kafka.restore.db.PartitionRestoreContext;
import kafka.restore.db.RestoreDB;
import kafka.restore.db.Utils;
import kafka.restore.rest.PartitionStatusResponse;
import kafka.restore.rest.RestoreRestServer;
import kafka.restore.rest.StatusResponse;
import kafka.restore.statemachine.RestoreFiniteStateMachine;
import kafka.restore.statemachine.StateMachineController;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreHandler
extends Handler.Abstract {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestoreHandler.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private RestoreRestServer restoreRestServer;
    private RestoreDB restoreDB = this.loadRestoreDB();
    private RestoreMetricsManager restoreMetricsManager;
    private RestoreOrchestrator restoreOrchestrator;
    private Time time;

    public RestoreHandler(RestoreMetricsManager restoreMetricsManager, RestoreRestServer restoreRestServer, Time time) {
        this.restoreMetricsManager = restoreMetricsManager;
        this.restoreOrchestrator = new RestoreOrchestrator(restoreMetricsManager, time);
        this.restoreRestServer = restoreRestServer;
        this.time = time;
    }

    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        String target = request.getHttpURI().getPath();
        if (target.endsWith("/start")) {
            LOGGER.info("Handling restore start command");
            this.handleStartCommand(request, response);
        } else if (target.endsWith("/status")) {
            LOGGER.info("Handling restore status query");
            this.handleStatusQuery(response);
        } else if (target.endsWith("/partition-status")) {
            LOGGER.info("Handling restore partition status query");
            this.handlePartitionStatusQuery(request, response);
        } else if (target.endsWith("/pause")) {
            LOGGER.info("Handling restore pause command");
            this.handlePauseCommand(response);
        } else if (target.endsWith("/resume")) {
            LOGGER.info("Handling restore resume command");
            this.handleResumeCommand(response);
        } else if (target.endsWith("/shutdown")) {
            LOGGER.info("Handling restore shutdown request");
            this.handleShutdownCommand(response);
        } else {
            LOGGER.warn("Unknown target");
            this.handleUnknownTarget(response);
            return false;
        }
        return true;
    }

    private void handleStartCommand(Request request, Response response) throws IOException {
        try (InputStream inputStream = Content.Source.asInputStream(request);){
            StartRequest startRequest = OBJECT_MAPPER.readValue(inputStream, StartRequest.class);
            RestoreConfig.setDryRun(startRequest.dryRun);
            RestoreConfig.setLocalMode(startRequest.localMode);
            HashSet<String> topicSet = null;
            if (startRequest.topics != null && startRequest.topics.length() != 0) {
                if (this.restoreDB.currentJob() != null && !this.restoreDB.currentJob().isDone()) {
                    RestoreHandler.generateErrorResponse("Start restore failed, previous job has not completed yet.", response);
                    return;
                }
                String[] topicArray = startRequest.topics.split(",");
                topicSet = new HashSet<String>(Arrays.asList(topicArray));
                Utils.loadPartitionsIntoRestoreDB(new File(RestoreConfig.getProperty("partition-file")), this.restoreDB, topicSet);
            }
            if (this.restoreOrchestrator.startUp()) {
                if (this.restoreDB.currentJob() != null) {
                    this.restoreOrchestrator.runRestoreJob(this.restoreDB.currentJob());
                } else {
                    RestoreHandler.generateErrorResponse("Start restore failed, no job to run.", response);
                }
            } else {
                RestoreHandler.generateErrorResponse("Start restore failed, Orchestrator is not running.", response);
            }
            RestoreHandler.generateOKResponse(response);
        }
        catch (Exception e) {
            LOGGER.error("start restore failed", (Throwable)e);
            RestoreHandler.generateErrorResponse("Start restore failed: " + e.getMessage(), response);
        }
    }

    private void handleStatusQuery(Response response) throws IOException {
        try {
            ArrayList<StatusResponse> jobs = new ArrayList<StatusResponse>();
            for (Job job : this.restoreDB.getJobs()) {
                Map<PartitionRestoreContext.RestoreStatus, Integer> statusMap = job.partitionRestoreStatusMap();
                StatusResponse statusResponse = new StatusResponse(job.id, job.status.toString(), statusMap.getOrDefault((Object)PartitionRestoreContext.RestoreStatus.NOT_STARTED, 0), statusMap.getOrDefault((Object)PartitionRestoreContext.RestoreStatus.IN_PROGRESS, 0), statusMap.getOrDefault((Object)PartitionRestoreContext.RestoreStatus.FAILED, 0), statusMap.getOrDefault((Object)PartitionRestoreContext.RestoreStatus.COMPLETED, 0));
                jobs.add(statusResponse);
            }
            ResponseContainer.dataResponse(jobs).write(OBJECT_MAPPER, response);
        }
        catch (Exception e) {
            LOGGER.error("get status failed", (Throwable)e);
            RestoreHandler.generateErrorResponse("Get status failed", response);
        }
    }

    private void handlePartitionStatusQuery(Request request, Response response) throws IOException {
        try (InputStream inputStream = Content.Source.asInputStream(request);){
            PartitionStateRequest partitionStateRequest = OBJECT_MAPPER.readValue(inputStream, PartitionStateRequest.class);
            String type = partitionStateRequest.type;
            ArrayList<PartitionStatusResponse> partitionStatusResponseList = new ArrayList<PartitionStatusResponse>();
            StateMachineController stateMachineController = this.restoreOrchestrator.stateMachineController();
            Job currentJob = this.restoreDB.getJobs().get(this.restoreDB.getJobs().size() - 1);
            for (TopicPartition tp : currentJob.partitionRestoreContextMap.keySet()) {
                RestoreFiniteStateMachine fsm = (RestoreFiniteStateMachine)stateMachineController.getFiniteStateMachineByTopicPartition(tp);
                PartitionRestoreContext partitionRestoreContext = (PartitionRestoreContext)fsm.getMetadata("partition_restore_context");
                if (!type.equals("ALL") && !partitionRestoreContext.status.toString().equals(type)) continue;
                int segmentCountToBeRestored = -1;
                if (fsm.getMetadata("restore_segment_map_size") != null) {
                    segmentCountToBeRestored = (Integer)fsm.getMetadata("restore_segment_map_size");
                }
                int segmentCountReconciled = -1;
                if (fsm.getMetadata("segment_count_reconciled") != null) {
                    segmentCountReconciled = (Integer)fsm.getMetadata("segment_count_reconciled");
                }
                PartitionStatusResponse statusResponse = new PartitionStatusResponse((String)fsm.getMetadata("topic"), (Integer)fsm.getMetadata("partition"), fsm.currentState().toString(), segmentCountToBeRestored, segmentCountReconciled, (List)fsm.getMetadata("state_transition_logs"));
                partitionStatusResponseList.add(statusResponse);
            }
            ResponseContainer.dataResponse(partitionStatusResponseList).write(OBJECT_MAPPER, response);
        }
        catch (Exception e) {
            LOGGER.error("get partition status failed", (Throwable)e);
            RestoreHandler.generateErrorResponse("Get partition status failed", response);
        }
    }

    private void handlePauseCommand(Response response) throws IOException {
        try {
            boolean result = this.restoreOrchestrator.pause();
            if (result) {
                RestoreHandler.generateOKResponse(response);
            } else {
                RestoreHandler.generateErrorResponse("Pause failed", response);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void handleResumeCommand(Response response) throws IOException {
        boolean result = this.restoreOrchestrator.resume();
        if (result) {
            RestoreHandler.generateOKResponse(response);
        } else {
            RestoreHandler.generateErrorResponse("Resume failed", response);
        }
    }

    private void handleShutdownCommand(Response response) throws IOException {
        boolean result = this.restoreOrchestrator.shutdown();
        if (result) {
            LOGGER.info("RestoreOrchestrator shutdown successfully");
            RestoreHandler.generateOKResponse(response);
        } else {
            RestoreHandler.generateErrorResponse("RestoreOrchestrator shutdown failed", response);
        }
    }

    private void handleUnknownTarget(Response response) throws IOException {
        RestoreHandler.generateErrorResponse("Unknown command", response);
    }

    private static void generateErrorResponse(String message, Response response) throws IOException {
        LOGGER.error("send error message to rest client: " + message);
        ResponseContainer.ErrorResponse errResponse = new ResponseContainer.ErrorResponse(0, 500, message);
        ResponseContainer<?> responseContainer = ResponseContainer.errorResponse(Collections.singletonList(errResponse));
        responseContainer.write(OBJECT_MAPPER, response);
    }

    private static void generateOKResponse(Response response) throws IOException {
        LOGGER.info("send ok response to rest client");
        response.getHeaders().put(HttpHeader.CONTENT_ENCODING, "UTF-8");
        response.setStatus(200);
        try (OutputStream outputStream = Content.Sink.asOutputStream(response);){
            outputStream.flush();
        }
    }

    private RestoreDB loadRestoreDB() {
        FileRestoreDB db = new FileRestoreDB();
        if (Utils.isRestoreDBEmpty(db)) {
            LOGGER.info("New job, loading partitions from input file");
            Utils.loadPartitionsIntoRestoreDB(new File(RestoreConfig.getProperty("partition-file")), db);
        } else {
            LOGGER.info("Resume an existing job, loading partitions from RestoreDB");
        }
        return db;
    }

    public void setRestoreDB(RestoreDB db) {
        this.restoreDB = db;
    }

    static final class StartRequest {
        @JsonProperty(value="dry_run")
        final boolean dryRun;
        @JsonProperty(value="local_mode")
        final boolean localMode;
        @JsonProperty(value="topics")
        final String topics;

        @JsonCreator
        public StartRequest(@JsonProperty(value="dry_run") boolean dryRun, @JsonProperty(value="local_mode") boolean localMode, @JsonProperty(value="topics") String topics) {
            this.dryRun = dryRun;
            this.localMode = localMode;
            this.topics = topics;
        }

        public String toString() {
            return "StartRequest { dryRun=" + this.dryRun + ", topics=" + this.topics + " }";
        }
    }

    static final class PartitionStateRequest {
        @JsonProperty(value="type")
        final String type;

        @JsonCreator
        public PartitionStateRequest(@JsonProperty(value="type") String type) {
            this.type = type;
        }

        public String toString() {
            return "PartitionStateRequest { type=" + this.type + " }";
        }
    }
}

