/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.snapshot;

import io.confluent.kafka.storage.checksum.Algorithm;
import io.confluent.kafka.storage.checksum.CheckedFileIO;
import io.confluent.kafka.storage.tier.state.Header;
import io.confluent.kafka.storage.tier.state.StateFileType;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.exceptions.TierMetadataFatalException;
import kafka.tier.exceptions.TierSnapshotChecksumValidationFailedException;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.MergedLogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpsSnapshotMaterializer {
    private static final Logger log = LoggerFactory.getLogger(FtpsSnapshotMaterializer.class);
    private Path ftpsSnapshotsDir;
    private FileTierPartitionState ftps;

    public FtpsSnapshotMaterializer(String ftpsSnapshotsRootDir) {
        this.ftpsSnapshotsDir = Paths.get(ftpsSnapshotsRootDir, UUID.randomUUID().toString());
    }

    public FileTierPartitionState materializeFtpsFromSnapshot(TopicPartition topicPartition, Algorithm checksumAlgorithm, ByteBuffer snapshotBuffer, LogDirFailureChannel logDirFailureChannel, Scheduler scheduler, Time time) throws IOException {
        if (this.ftps != null) {
            throw new IllegalStateException("Attempt to use snapshot materialization util that already has ftps initialized:" + String.valueOf(this.ftps));
        }
        if (this.ftpsSnapshotsDir == null) {
            throw new IllegalStateException("Attempt to use snapshot materialization with null ftpsSnapshotsDir");
        }
        boolean tieringEnabled = true;
        boolean compactFeatureFlag = true;
        boolean cleanupEnabled = true;
        TierPartitionStateCleanupConfig cleanupConfig = new TierPartitionStateCleanupConfig(true, Duration.ofDays(30L).toMillis(), Duration.ofDays(30L).toMillis());
        boolean tierPartitionStateSnapshotFeatureFlag = true;
        int brokerId = -1;
        String basePath = MergedLogUtils.tierStateFile(this.ftpsSnapshotsDir.toFile(), 0L, checksumAlgorithm.suffix).getAbsolutePath();
        Path materializationPath = StateFileType.flushedFilePath(basePath, checksumAlgorithm);
        if (!materializationPath.toFile().getParentFile().mkdirs()) {
            throw new TierMetadataFatalException(String.format("Failed to make directories at path %s", materializationPath));
        }
        try (FileChannel materializationChannel = FileChannel.open(materializationPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.READ, StandardOpenOption.WRITE);){
            Utils.writeFully((FileChannel)materializationChannel, (ByteBuffer)snapshotBuffer);
            log.info("Persist source FTPS file from object store to {} with size {}", (Object)materializationPath, (Object)materializationChannel.size());
        }
        catch (IOException ioe) {
            String rootDir = this.ftpsSnapshotsDir.getParent().getParent().toString();
            logDirFailureChannel.maybeAddOfflineLogDir(rootDir, "IOException encountered when trying to open FTPS snapshot file at " + String.valueOf(this.ftpsSnapshotsDir), ioe);
            throw new KafkaStorageException((Throwable)ioe);
        }
        try (CheckedFileIO checkedIOChannel = CheckedFileIO.open(materializationPath, StandardOpenOption.READ);){
            boolean isChecksumValid = checkedIOChannel.validate();
            if (!isChecksumValid) {
                throw new TierSnapshotChecksumValidationFailedException("Checksum validation failed on newly downloaded FTPS file during snapshot materialization", null);
            }
            Optional<Header> initialHeaderOpt = FileTierPartitionState.readHeader(checkedIOChannel);
            if (!initialHeaderOpt.isPresent()) {
                throw new TierMetadataFatalException(String.format("TierPartitionState being opened does not contain a valid header. Topic-Partition %s with checksum algorithm %s", new Object[]{topicPartition, checksumAlgorithm}));
            }
        }
        catch (IOException ioe) {
            String rootDir = this.ftpsSnapshotsDir.getParent().getParent().toString();
            logDirFailureChannel.maybeAddOfflineLogDir(rootDir, "IOException encountered when trying to read FTPS header at " + String.valueOf(this.ftpsSnapshotsDir), ioe);
            throw new KafkaStorageException((Throwable)ioe);
        }
        catch (ReflectiveOperationException | TierSnapshotChecksumValidationFailedException e) {
            throw new TierMetadataFatalException("Encountered exception when opening snapshot file at " + String.valueOf(this.ftpsSnapshotsDir), e);
        }
        this.ftps = new FileTierPartitionState(this.ftpsSnapshotsDir.toFile(), logDirFailureChannel, topicPartition, true, scheduler, checksumAlgorithm != Algorithm.NO_CHECKSUM, true, time, cleanupConfig, true, -1);
        return this.ftps;
    }

    public void cleanup() throws IOException {
        if (this.ftps != null) {
            this.ftps.close();
            this.ftps = null;
        }
        if (this.ftpsSnapshotsDir != null) {
            Utils.delete((File)this.ftpsSnapshotsDir.toFile());
            this.ftpsSnapshotsDir = null;
        }
    }
}

