/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.snapshot;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.tier.domain.TierTopicPartitionSnapshot;
import kafka.tier.exceptions.TierMetadataFatalException;
import kafka.tier.store.objects.metadata.TierTopicSnapshotMetadata;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.utils.AbstractIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TierRecordsIterator
extends AbstractIterator<ConsumerRecord<byte[], byte[]>> {
    private static final Logger log = LoggerFactory.getLogger(TierRecordsIterator.class);
    private final Iterator<Future<Path>> tierTopicSnapshotPathIterator;
    private Iterator<ConsumerRecord<byte[], byte[]>> recordIterator = null;
    private long recordCount;
    private final Map<Integer, Long> tierPartitionStartOffsets;

    public TierRecordsIterator(List<Future<Path>> snapshotPathFutures) {
        this.tierTopicSnapshotPathIterator = snapshotPathFutures.iterator();
        this.recordCount = 0L;
        this.tierPartitionStartOffsets = new HashMap<Integer, Long>();
    }

    public Map<Integer, Long> tierPartitionStartOffsets() {
        return this.tierPartitionStartOffsets;
    }

    private Iterator<ConsumerRecord<byte[], byte[]>> advanceToNextFile() {
        if (!this.tierTopicSnapshotPathIterator.hasNext()) {
            return null;
        }
        try {
            Path snapshotPath = this.tierTopicSnapshotPathIterator.next().get();
            TierTopicSnapshotMetadata metadata = TierTopicSnapshotMetadata.fromPath(snapshotPath.toString());
            FileChannel channel = FileChannel.open(snapshotPath, StandardOpenOption.READ);
            TierTopicPartitionSnapshot ttps = TierTopicPartitionSnapshot.read(channel, (Long)metadata.snapshotObject().startTimestampMs(), (Long)metadata.snapshotObject().endTimestampMs());
            channel.close();
            return ttps.entries().iterator();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("Cannot safely proceed with tier topic snapshot processing: download of tier topic snapshot file was interrupted", (Throwable)e);
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            log.error("Cannot proceed with tier topic snapshot processing: unable to open/read tier topic snapshot file", (Throwable)e);
            throw new TierMetadataFatalException(e);
        }
    }

    protected ConsumerRecord<byte[], byte[]> makeNext() {
        while (this.recordIterator == null || !this.recordIterator.hasNext()) {
            this.recordIterator = this.advanceToNextFile();
            if (this.recordIterator != null) continue;
            this.printDebugInfo();
            return (ConsumerRecord)this.allDone();
        }
        ++this.recordCount;
        ConsumerRecord<byte[], byte[]> record = this.recordIterator.next();
        if (log.isDebugEnabled()) {
            this.tierPartitionStartOffsets.putIfAbsent(record.partition(), record.offset());
        }
        return record;
    }

    private void printDebugInfo() {
        log.debug(String.format("TierRecordsIterator: total records %s", this.recordCount));
        this.tierPartitionStartOffsets.forEach((p, o) -> log.debug(String.format("TierRecordsIterator start offset: partition %s : %s", p, o)));
    }
}

