/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.snapshot;

import io.confluent.kafka.storage.tier.TopicIdPartition;
import io.confluent.kafka.storage.tier.domain.AbstractTierMetadata;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;
import kafka.restore.snapshot.SnapshotObjectStoreUtils;
import kafka.tier.client.TierTopicConsumerSupplier;
import kafka.tier.exceptions.TierMetadataFatalException;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.KafkaThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TierTopicConsumerForRestore
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(TierTopicConsumerForRestore.class);
    protected static final String TIER_TOPIC_NAME = "_confluent-tier-state";
    private static final Duration POLL_DURATION_MS = Duration.ofMillis(100L);
    private final Supplier<Consumer<byte[], byte[]>> consumerSupplier;
    private final Thread consumerThread;
    private volatile Consumer<byte[], byte[]> consumer;
    private final Map<Integer, Long> lastMaterializedOffsetTierTopicPartition;
    private final Set<TopicIdPartition> partitionsToRestore;
    private final Map<TopicIdPartition, ConcurrentLinkedQueue<ConsumerRecord<byte[], byte[]>>> bufferedRecords;
    private boolean initialized = false;
    private volatile boolean shutdown = false;

    public TierTopicConsumerForRestore(Map<Integer, Long> lastMaterializedOffsetTierTopicPartition, Set<TopicIdPartition> partitionsToRestore, Supplier<Consumer<byte[], byte[]>> consumerSupplier) {
        this.consumerSupplier = consumerSupplier;
        this.consumerThread = new KafkaThread("TierTopicConsumer", (Runnable)this, false);
        this.lastMaterializedOffsetTierTopicPartition = lastMaterializedOffsetTierTopicPartition;
        this.partitionsToRestore = partitionsToRestore;
        this.bufferedRecords = new HashMap<TopicIdPartition, ConcurrentLinkedQueue<ConsumerRecord<byte[], byte[]>>>();
    }

    public TierTopicConsumerForRestore(String brokerConnectionString, Map<Integer, Long> lastMaterializedOffsetTierTopicPartition, Set<TopicIdPartition> partitionsToRestore) {
        this(lastMaterializedOffsetTierTopicPartition, partitionsToRestore, new TierTopicConsumerSupplier(() -> Collections.singletonMap("bootstrap.servers", brokerConnectionString), UUID.randomUUID().toString(), 0, "restore"));
    }

    public void initialize() {
        this.consumer = this.consumerSupplier.get();
        HashSet<TopicPartition> tierTopicPartitions = new HashSet<TopicPartition>();
        for (Integer partition : this.lastMaterializedOffsetTierTopicPartition.keySet()) {
            tierTopicPartitions.add(new TopicPartition(TIER_TOPIC_NAME, partition.intValue()));
        }
        this.consumer.assign(tierTopicPartitions);
        for (TopicPartition topicPartition : tierTopicPartitions) {
            int partition = topicPartition.partition();
            long offset = this.lastMaterializedOffsetTierTopicPartition.get(topicPartition.partition());
            log.info("seeking restore consumer to offset {} for partition {}", (Object)offset, (Object)partition);
            this.consumer.seek(topicPartition, offset);
        }
        for (TopicIdPartition tpid : this.partitionsToRestore) {
            this.bufferedRecords.put(tpid, new ConcurrentLinkedQueue());
        }
        this.initialized = true;
    }

    public void start() {
        if (!this.initialized) {
            throw new IllegalStateException("TierTopicConsumerForRestore was started without first calling initialize.");
        }
        this.consumerThread.start();
    }

    public void shutdown() {
        this.shutdown = true;
        if (this.consumer != null) {
            this.consumer.wakeup();
        }
        try {
            this.consumerThread.join();
        }
        catch (InterruptedException e) {
            log.error("Shutdown interrupted", (Throwable)e);
        }
    }

    public void cleanup() {
        if (this.consumer != null) {
            this.consumer.close();
        }
    }

    @Override
    public void run() {
        log.info("TierTopicConsumerForRestore started");
        try {
            while (!this.shutdown) {
                this.doWork();
            }
        }
        catch (Exception e) {
            if (this.shutdown) {
                log.debug("Exception caught during shutdown", (Throwable)e);
            }
            log.error("Fatal exception in TierTopicConsumer", (Throwable)e);
        }
    }

    public void doWork() {
        this.processRecords((ConsumerRecords<byte[], byte[]>)this.consumer.poll(POLL_DURATION_MS));
    }

    private void processRecords(ConsumerRecords<byte[], byte[]> records) {
        if (records == null) {
            return;
        }
        for (ConsumerRecord record : records) {
            try {
                AbstractTierMetadata event = SnapshotObjectStoreUtils.deserializeRecord((ConsumerRecord<byte[], byte[]>)record);
                TopicIdPartition tpid = event.topicIdPartition();
                if (!this.bufferedRecords.containsKey(tpid)) continue;
                log.debug(String.format("[%s]: receive (location in tier topic partition: %s:%s) event: %s", tpid.topicPartition(), record.partition(), record.offset(), event));
                this.bufferedRecords.get(tpid).offer((ConsumerRecord<byte[], byte[]>)record);
            }
            catch (Exception e) {
                throw new TierMetadataFatalException(String.format("Unable to process message at offset %d of partition %d", record.offset(), record.partition()), e);
            }
        }
    }

    public Consumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    public Queue<ConsumerRecord<byte[], byte[]>> getRecords(TopicIdPartition tpid) {
        return this.bufferedRecords.get(tpid);
    }
}

