/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.statemachine.events;

import java.util.HashMap;
import java.util.Map;
import kafka.restore.messages.MessageResponse;
import kafka.restore.statemachine.api.Event;

public class KafkaRestoreEvent
implements Event {
    public static final String MESSAGE_RESPONSE = "message_response";
    protected String name;
    protected long timestamp;
    Map<String, Object> extraDataMap = new HashMap<String, Object>();

    public KafkaRestoreEvent(MessageResponse response) {
        this.name = response.getTopic() + "-" + response.getPartition() + "-" + response.getUuid();
        this.extraDataMap.put(MESSAGE_RESPONSE, response);
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Object getData(String key) {
        return this.extraDataMap.get(key);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Event {name: ").append(this.name);
        if (!this.extraDataMap.containsKey(MESSAGE_RESPONSE)) {
            sb.append(", response: null");
        } else {
            sb.append(", ").append(((MessageResponse)this.extraDataMap.get(MESSAGE_RESPONSE)).name());
        }
        return sb.toString();
    }
}

