/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.statemachine.transitions;

import java.util.List;
import kafka.restore.MessageEmitter;
import kafka.restore.configmap.NodeConfig;
import kafka.restore.messages.KafkaForceRestoreResponse;
import kafka.restore.messages.KafkaValidateLogRangeRequest;
import kafka.restore.statemachine.api.Event;
import kafka.restore.statemachine.api.FiniteStateMachine;
import kafka.restore.statemachine.api.State;
import kafka.restore.statemachine.transitions.AbstractTransition;

public class FtpsUploadedToForceRestoreEventSentTransition
extends AbstractTransition {
    public FtpsUploadedToForceRestoreEventSentTransition(MessageEmitter messageEmitter) {
        super(messageEmitter);
    }

    @Override
    public State getSourceState() {
        return State.FTPS_UPLOADED;
    }

    @Override
    public State getTargetState() {
        return State.FORCE_RESTORE_EVENT_SENT;
    }

    @Override
    public boolean handleEvent(FiniteStateMachine fsm, Event event) {
        Object responseObject = event.getData("message_response");
        if (!(responseObject instanceof KafkaForceRestoreResponse)) {
            return false;
        }
        String topic = (String)fsm.getMetadata("topic");
        int partition = (Integer)fsm.getMetadata("partition");
        NodeConfig broker = (NodeConfig)fsm.getMetadata("partition_leader");
        List replicas = (List)fsm.getMetadata("partition_replicas");
        long logStartOffset = (Long)fsm.getMetadata("ftps_log_start_offset");
        long logEndOffset = (Long)fsm.getMetadata("ftps_log_end_offset");
        KafkaValidateLogRangeRequest statusRequest = new KafkaValidateLogRangeRequest(0, topic, partition, broker, replicas, logStartOffset, logEndOffset);
        this.messageEmitter.submitRequest(statusRequest);
        return true;
    }
}

