/*
 * Decompiled with CFR 0.152.
 */
package kafka.rm;

import io.confluent.resourcemanager.api.client.Client;
import io.confluent.rm.RmClientFactory;
import java.util.Locale;
import kafka.rm.RmMTlsClientFactory;
import kafka.rm.RmPlaintextClientFactory;
import kafka.server.KafkaConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmKafkaConfigClientFactory
implements RmClientFactory {
    private static final Logger log = LoggerFactory.getLogger(RmKafkaConfigClientFactory.class);
    private final RmClientFactory rmClientFactory;

    public RmKafkaConfigClientFactory(KafkaConfig brokerConfig) {
        String httpEndpoint = brokerConfig.regionalResourceManagerEndpointUrl();
        if (httpEndpoint == null) {
            log.error("No RM endpoint set");
            throw new IllegalArgumentException("No RM endpoint set");
        }
        if (httpEndpoint.toLowerCase(Locale.ROOT).contains("https")) {
            log.info("Creating RmMTlsClientFactory for endpoint {}", (Object)httpEndpoint);
            this.rmClientFactory = new RmMTlsClientFactory(brokerConfig);
        } else {
            log.info("Creating RmPlaintextClientFactory for endpoint {}", (Object)httpEndpoint);
            this.rmClientFactory = new RmPlaintextClientFactory(brokerConfig.regionalResourceManagerEndpointUrl(), brokerConfig.regionalResourceManagerGrpcEndpointUrl());
        }
    }

    @Override
    public Client buildClient() {
        return this.rmClientFactory.buildClient();
    }

    @Override
    public void close() {
        this.rmClientFactory.close();
    }
}

