/*
 * Decompiled with CFR 0.152.
 */
package kafka.rm;

import io.grpc.ChannelCredentials;
import io.grpc.Grpc;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.TlsChannelCredentials;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kafka.server.KafkaConfig;
import kafka.server.ssl.MtlsWithServerCertConfigs;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.security.auth.SslEngineFactory;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactory;
import org.apache.kafka.common.security.ssl.SslFactory;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmMTls {
    private static final Logger log = LoggerFactory.getLogger(RmMTls.class);

    public static Map<String, ?> getSslClientConfig(KafkaConfig config) {
        MtlsWithServerCertConfigs mtlsWithServerCertConfigs = new MtlsWithServerCertConfigs(config);
        ConfigDef sslConfigDef = new ConfigDef();
        sslConfigDef.withClientSslSupport();
        Map<String, Object> mtlsConfigs = mtlsWithServerCertConfigs.mtlsConfigOverrides();
        log.info("mtlsConfigs= {}", mtlsConfigs.keySet());
        AbstractConfig sslClientConfig = new AbstractConfig(sslConfigDef, mtlsConfigs);
        return sslClientConfig.values();
    }

    public static DefaultSslEngineFactory defaultSslEngineFactory(SslFactory sslFactory) {
        return DefaultSslEngineFactory.castOrThrow((SslEngineFactory)sslFactory.sslEngineFactory());
    }

    public static SSLSocketFactory sslSocketFactory(DefaultSslEngineFactory defaultSslEngineFactory) {
        return defaultSslEngineFactory.sslContext().getSocketFactory();
    }

    public static X509TrustManager trustManager(DefaultSslEngineFactory defaultSslEngineFactory) {
        TrustManager[] trustManagers = DefaultSslEngineFactory.trustManagers((SslEngineFactory)defaultSslEngineFactory);
        Optional<X509TrustManager> trustManagerOpt = Arrays.stream(trustManagers).filter(t -> t instanceof X509TrustManager).map(t -> (X509TrustManager)t).findFirst();
        if (trustManagerOpt.isEmpty()) {
            throw new IllegalStateException("Unexpected trust managers, expected to find a X509TrustManager, but saw none");
        }
        return trustManagerOpt.get();
    }

    public static ManagedChannel managedChannel(KafkaConfig brokerConfig, DefaultSslEngineFactory defaultSslEngineFactory) {
        TrustManager[] trustManagers = DefaultSslEngineFactory.trustManagers((SslEngineFactory)defaultSslEngineFactory);
        Optional<X509TrustManager> trustManagerOpt = Arrays.stream(trustManagers).filter(t -> t instanceof X509TrustManager).map(t -> (X509TrustManager)t).findFirst();
        if (trustManagerOpt.isEmpty()) {
            throw new IllegalStateException("Unexpected trust managers, expected to find a X509TrustManager, but saw none");
        }
        KeyManager[] keyManagers = DefaultSslEngineFactory.keyManagers((SslEngineFactory)defaultSslEngineFactory);
        ChannelCredentials tlsCredentials = TlsChannelCredentials.newBuilder().keyManager(keyManagers).trustManager(trustManagers).build();
        String grpcEndpoint = brokerConfig.regionalResourceManagerGrpcEndpointUrl();
        if (grpcEndpoint == null) {
            throw new IllegalStateException("Resource manager GRPC endpoint URL is not configured.");
        }
        ManagedChannel channel = ((ManagedChannelBuilder)((ManagedChannelBuilder)((ManagedChannelBuilder)((ManagedChannelBuilder)Grpc.newChannelBuilderForAddress(Utils.getHost((String)grpcEndpoint), Utils.getPort((String)grpcEndpoint), tlsCredentials).defaultLoadBalancingPolicy("round_robin")).keepAliveTime(500L, TimeUnit.MILLISECONDS)).keepAliveTimeout(10L, TimeUnit.SECONDS)).keepAliveWithoutCalls(true)).build();
        log.info("Created channel {}", (Object)channel);
        return channel;
    }
}

