/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.function.Supplier;
import kafka.server.AbstractFetcherManager$;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerAndFetcherId;
import kafka.server.FailedPartitions;
import kafka.server.FetchConnectionsMode;
import kafka.server.FetchConnectionsMode$Isolated$;
import kafka.server.FetcherLagMetrics;
import kafka.server.FetcherPool;
import kafka.server.FetcherPool$;
import kafka.server.FetcherPool$Default$;
import kafka.server.FetcherPool$InSync$;
import kafka.server.FetcherTag;
import kafka.server.InitialFetchState;
import kafka.server.PausedPartitions;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.PartitionFetchState;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.network.BrokerEndPoint;
import org.apache.kafka.server.util.Scheduler;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r\u0015c!B\u001f?\u0003\u0003\u0019\u0005\u0002C)\u0001\u0005\u000b\u0007I\u0011\u0001*\t\u0011y\u0003!\u0011!Q\u0001\nMC\u0001b\u0018\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\tA\u0002\u0011\t\u0011)A\u0005C\"AA\r\u0001B\u0001B\u0003%Q\r\u0003\u0005j\u0001\t\u0005\t\u0015!\u0003k\u0011!I\bA!A!\u0002\u0013Q\bBCA\u0001\u0001\t\u0005\t\u0015!\u0003\u0002\u0004!9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0001\"CA\u001a\u0001\t\u0007I\u0011BA\u001b\u0011!\t\u0019\u0005\u0001Q\u0001\n\u0005]\u0002BCA#\u0001\t\u0007I\u0011\u0001 \u0002H!A\u00111\f\u0001!\u0002\u0013\tI\u0005C\u0005\u0002^\u0001\u0011\r\u0011\"\u0005\u0002`!A\u0011\u0011\u000f\u0001!\u0002\u0013\t\t\u0007C\u0005\u0002t\u0001\u0011\r\u0011\"\u0005\u0002v!A\u0011Q\u0010\u0001!\u0002\u0013\t9\bC\u0005\u0002\u0000\u0001\u0011\r\u0011\"\u0005\u0002\u0002\"9\u00111\u0011\u0001!\u0002\u0013)\u0007\"CAC\u0001\t\u0007I\u0011AAD\u0011!\ty\t\u0001Q\u0001\n\u0005%\u0005\"CAI\u0001\t\u0007I\u0011AAJ\u0011!\tY\n\u0001Q\u0001\n\u0005U\u0005\"CAO\u0001\t\u0007I\u0011BAP\u0011!\t9\u000b\u0001Q\u0001\n\u0005\u0005\u0006\"CAU\u0001\t\u0007I\u0011BAV\u0011!\tI\r\u0001Q\u0001\n\u00055\u0006\"CAf\u0001\t\u0007I\u0011BAg\u0011!\t\t\u000e\u0001Q\u0001\n\u0005=\u0007\"CAj\u0001\t\u0007I\u0011BAV\u0011!\t)\u000e\u0001Q\u0001\n\u00055\u0006\u0002CAl\u0001\u0011\u0005a(!7\t\u000f\u0005\u0005\b\u0001\"\u0003\u0002d\"9\u0011\u0011\u001f\u0001\u0005\n\u0005M\b\u0002\u0003B\u000e\u0001\u0011\u0005aH!\b\t\u0011\t}\u0001\u0001\"\u0001?\u0005CAqA!\n\u0001\t\u0003\u00119\u0003C\u0005\u0003:\u0001\t\n\u0011\"\u0001\u0003<!A!\u0011\u000b\u0001\u0005\u0002y\u0012\u0019\u0006\u0003\u0005\u0003h\u0001!\tA\u0010B5\u0011\u001d\u0011y\u0007\u0001C\u0001\u0005cBqAa!\u0001\r\u0003\u0011)\tC\u0004\u0003\u001e\u0002!\tAa(\t\u0013\te\u0006!%A\u0005\u0002\tm\u0006b\u0002B`\u0001\u0011\u0005!\u0011\u0019\u0005\b\u0005\u000b\u0004A\u0011\u0003Bd\u0011\u001d\u0011\t\u000e\u0001C\u0001\u0005'D\u0011Ba6\u0001#\u0003%\tAa/\t\u000f\te\u0007\u0001\"\u0005\u0003\\\"9!q\u001e\u0001\u0005\u0002\tE\bbBB\u0006\u0001\u0011\u00051Q\u0002\u0005\b\u00073\u0001A\u0011AAm\u0011\u001d\u0019Y\u0002\u0001C\u0001\u00033Dqa!\b\u0001\t\u0003\tInB\u0005\u0004 y\n\t\u0011#\u0001\u0004\"\u0019AQHPA\u0001\u0012\u0003\u0019\u0019\u0003C\u0004\u0002\na\"\ta!\n\t\u0013\r\u001d\u0002(%A\u0005\u0002\r%\u0002\"CB\u0019qE\u0005I\u0011AB\u001a\u0011%\u0019Y\u0004OI\u0001\n\u0003\u0019iD\u0001\fBEN$(/Y2u\r\u0016$8\r[3s\u001b\u0006t\u0017mZ3s\u0015\ty\u0004)\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0003\u0006)1.\u00194lC\u000e\u0001Qc\u0001#\u0002\u0014M\u0019\u0001!R&\u0011\u0005\u0019KU\"A$\u000b\u0003!\u000bQa]2bY\u0006L!AS$\u0003\r\u0005s\u0017PU3g!\tau*D\u0001N\u0015\tq\u0005)A\u0003vi&d7/\u0003\u0002Q\u001b\n9Aj\\4hS:<\u0017\u0001\u00028b[\u0016,\u0012a\u0015\t\u0003)ns!!V-\u0011\u0005Y;U\"A,\u000b\u0005a\u0013\u0015A\u0002\u001fs_>$h(\u0003\u0002[\u000f\u00061\u0001K]3eK\u001aL!\u0001X/\u0003\rM#(/\u001b8h\u0015\tQv)A\u0003oC6,\u0007%\u0001\u0005dY&,g\u000e^%e\u0003-qW/\u001c$fi\u000eDWM]:\u0011\u0005\u0019\u0013\u0017BA2H\u0005\rIe\u000e^\u0001\nM\u0016$8\r['pI\u0016\u0004\"AZ4\u000e\u0003yJ!\u0001\u001b \u0003)\u0019+Go\u00195D_:tWm\u0019;j_:\u001cXj\u001c3f\u0003%\u00198\r[3ek2,'\u000fE\u0002GW6L!\u0001\\$\u0003\r=\u0003H/[8o!\tqw/D\u0001p\u0015\t\u0001\u0018/\u0001\u0003vi&d'BA s\u0015\t\t5O\u0003\u0002uk\u00061\u0011\r]1dQ\u0016T\u0011A^\u0001\u0004_J<\u0017B\u0001=p\u0005%\u00196\r[3ek2,'/A\bfqR\u0014\u0018-T3ue&\u001cG+Y4t!\u0011YhpU*\u000e\u0003qT!!`$\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002\u0000y\n\u0019Q*\u00199\u0002\u0011%\u001c8i\u00117pk\u0012\u00042ARA\u0003\u0013\r\t9a\u0012\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q\u0001\u0012QBA\u0013\u0003O\tI#a\u000b\u0002.\u0005=\u0012\u0011\u0007\t\u0005M\u0002\ty\u0001\u0005\u0003\u0002\u0012\u0005MA\u0002\u0001\u0003\b\u0003+\u0001!\u0019AA\f\u0005\u0005!\u0016\u0003BA\r\u0003?\u00012ARA\u000e\u0013\r\tib\u0012\u0002\b\u001d>$\b.\u001b8h!\r1\u0017\u0011E\u0005\u0004\u0003Gq$!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\u0005\u0006#&\u0001\ra\u0015\u0005\u0006?&\u0001\ra\u0015\u0005\u0006A&\u0001\r!\u0019\u0005\u0006I&\u0001\r!\u001a\u0005\bS&\u0001\n\u00111\u0001k\u0011\u001dI\u0018\u0002%AA\u0002iD\u0011\"!\u0001\n!\u0003\u0005\r!a\u0001\u0002\u00195,GO]5dg\u001e\u0013x.\u001e9\u0016\u0005\u0005]\u0002\u0003BA\u001d\u0003\u007fi!!a\u000f\u000b\u0007\u0005u\u0012/A\u0004nKR\u0014\u0018nY:\n\t\u0005\u0005\u00131\b\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\u0018!D7fiJL7m]$s_V\u0004\b%\u0001\tgKR\u001c\u0007.\u001a:UQJ,\u0017\rZ'baV\u0011\u0011\u0011\n\t\t\u0003\u0017\n\t&!\u0016\u0002\u00105\u0011\u0011Q\n\u0006\u0004\u0003\u001fb\u0018aB7vi\u0006\u0014G.Z\u0005\u0005\u0003'\niEA\u0004ICNDW*\u00199\u0011\u0007\u0019\f9&C\u0002\u0002Zy\u0012!BR3uG\",'\u000fV1h\u0003E1W\r^2iKJ$\u0006N]3bI6\u000b\u0007\u000fI\u0001\u0005Y>\u001c7.\u0006\u0002\u0002bA!\u00111MA7\u001b\t\t)G\u0003\u0003\u0002h\u0005%\u0014\u0001\u00027b]\u001eT!!a\u001b\u0002\t)\fg/Y\u0005\u0005\u0003_\n)G\u0001\u0004PE*,7\r^\u0001\u0006Y>\u001c7\u000eI\u0001\u0015]Vlg)\u001a;dQ\u0016\u00148\u000fU3s\u0005J|7.\u001a:\u0016\u0005\u0005]\u0004\u0003\u0002$\u0002z\u0005L1!a\u001fH\u0005\u0015\t%O]1z\u0003UqW/\u001c$fi\u000eDWM]:QKJ\u0014%o\\6fe\u0002\n1D]3qY&\u001c\u0017MR3uG\"\u001cuN\u001c8fGRLwN\\:N_\u0012,W#A3\u00029I,\u0007\u000f\\5dC\u001a+Go\u00195D_:tWm\u0019;j_:\u001cXj\u001c3fA\u0005\u0001b-Y5mK\u0012\u0004\u0016M\u001d;ji&|gn]\u000b\u0003\u0003\u0013\u00032AZAF\u0013\r\tiI\u0010\u0002\u0011\r\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N\f\u0011CZ1jY\u0016$\u0007+\u0019:uSRLwN\\:!\u0003A\u0001\u0018-^:fIB\u000b'\u000f^5uS>t7/\u0006\u0002\u0002\u0016B\u0019a-a&\n\u0007\u0005eeH\u0001\tQCV\u001cX\r\u001a)beRLG/[8og\u0006\t\u0002/Y;tK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002\tQ\fwm]\u000b\u0003\u0003C\u0003Ra\u001f@\u0002$N\u0003B!a\u0019\u0002&&\u0019A,!\u001a\u0002\u000bQ\fwm\u001d\u0011\u0002\u0019\u0005$G-\u001a3NKR\u0014\u0018nY:\u0016\u0005\u00055\u0006CBA&\u0003_\u000b\u0019,\u0003\u0003\u00022\u00065#A\u0002\"vM\u001a,'\u000f\u0005\u0003\u00026\u0006\u0015WBAA\\\u0015\u0011\tI,a/\u0002\t\r|'/\u001a\u0006\u0005\u0003{\tiL\u0003\u0003\u0002@\u0006\u0005\u0017AB=b[6,'O\u0003\u0002\u0002D\u0006\u00191m\\7\n\t\u0005\u001d\u0017q\u0017\u0002\u000b\u001b\u0016$(/[2OC6,\u0017!D1eI\u0016$W*\u001a;sS\u000e\u001c\b%\u0001\u0012j]R,G\u000e\\5hK:$(+\u001a9mS\u000e\fG/[8o\u001b\u0016$(/[2t\u000fJ|W\u000f]\u000b\u0003\u0003\u001f\u0004BAR6\u00028\u0005\u0019\u0013N\u001c;fY2Lw-\u001a8u%\u0016\u0004H.[2bi&|g.T3ue&\u001c7o\u0012:pkB\u0004\u0013AI1eI\u0016$\u0017J\u001c;fY2Lw-\u001a8u%\u0016\u0004H.[2bi&|g.T3ue&\u001c7/A\u0012bI\u0012,G-\u00138uK2d\u0017nZ3oiJ+\u0007\u000f\\5dCRLwN\\'fiJL7m\u001d\u0011\u00029\r\u0014X-\u0019;f'\u0016\u0004\u0018M]1uK\u001a+Go\u00195fe6+GO]5dgR\u0011\u00111\u001c\t\u0004\r\u0006u\u0017bAAp\u000f\n!QK\\5u\u00031i\u0017N\u001c$fi\u000eD'+\u0019;f)\u0011\t)/a;\u0011\u0007\u0019\u000b9/C\u0002\u0002j\u001e\u0013a\u0001R8vE2,\u0007bBAwC\u0001\u0007\u0011q^\u0001\u000bM\u0016$8\r[3s\u001b\u0006\u0004\bCB>\u007f\u0003+\ny!\u0001\bde\u0016\fG/\u001a(fo\u001e\u000bWoZ3\u0016\t\u0005U(Q\u0002\u000b\t\u00037\f90!?\u0003\u001a!)\u0011K\ta\u0001'\"9\u00111 \u0012A\u0002\u0005u\u0018AB7fiJL7\r\u0005\u0004\u0002\u0000\n\u001d!1B\u0007\u0003\u0005\u0003QAAa\u0001\u0003\u0006\u0005Aa-\u001e8di&|gNC\u0002q\u0003SJAA!\u0003\u0003\u0002\tA1+\u001e9qY&,'\u000f\u0005\u0003\u0002\u0012\t5Aa\u0002B\bE\t\u0007!\u0011\u0003\u0002\u0002-F!\u0011\u0011\u0004B\n!\r1%QC\u0005\u0004\u0005/9%aA!os\"1\u0011Q\u0014\u0012A\u0002i\fq\u0002Z3bIRC'/Z1e\u0007>,h\u000e^\u000b\u0002C\u0006\u0019B-Z1e)\"\u0014X-\u00193D_VtG\u000fV1hgR\u0019!Pa\t\t\r\u0005uE\u00051\u0001{\u0003A\u0011Xm]5{KRC'/Z1e!>|G\u000e\u0006\u0004\u0002\\\n%\"Q\u0006\u0005\u0007\u0005W)\u0003\u0019A1\u0002\u000f9,woU5{K\"I!qF\u0013\u0011\u0002\u0003\u0007!\u0011G\u0001\fM\u0016$8\r[3s!>|G\u000e\u0005\u0003GW\nM\u0002c\u00014\u00036%\u0019!q\u0007 \u0003\u0017\u0019+Go\u00195feB{w\u000e\\\u0001\u001be\u0016\u001c\u0018N_3UQJ,\u0017\r\u001a)p_2$C-\u001a4bk2$HEM\u000b\u0003\u0005{QCA!\r\u0003@-\u0012!\u0011\t\t\u0005\u0005\u0007\u0012i%\u0004\u0002\u0003F)!!q\tB%\u0003%)hn\u00195fG.,GMC\u0002\u0003L\u001d\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011yE!\u0012\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0006hKR4U\r^2iKJ$BA!\u0016\u0003XA!ai[A\b\u0011\u001d\u0011If\na\u0001\u00057\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0003^\t\rTB\u0001B0\u0015\r\u0011\tG]\u0001\u0007G>lWn\u001c8\n\t\t\u0015$q\f\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u000319W\r\u001e$fi\u000eDWM]%e)\u0015\t'1\u000eB7\u0011\u001d\u0011I\u0006\u000ba\u0001\u00057BqAa\f)\u0001\u0004\u0011\u0019$A\u000enCJ\\\u0007+\u0019:uSRLwN\\:G_J$&/\u001e8dCRLwN\u001c\u000b\t\u00037\u0014\u0019Ha\u001e\u0003z!1!QO\u0015A\u0002\u0005\f\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\u0005\b\u00053J\u0003\u0019\u0001B.\u0011\u001d\u0011Y(\u000ba\u0001\u0005{\n\u0001\u0003\u001e:v]\u000e\fG/[8o\u001f\u001a47/\u001a;\u0011\u0007\u0019\u0013y(C\u0002\u0003\u0002\u001e\u0013A\u0001T8oO\u0006\u00192M]3bi\u00164U\r^2iKJ$\u0006N]3bIRA\u0011q\u0002BD\u0005\u0017\u0013Y\n\u0003\u0004\u0003\n*\u0002\r!Y\u0001\nM\u0016$8\r[3s\u0013\u0012DqA!$+\u0001\u0004\u0011y)\u0001\u0007t_V\u00148-\u001a\"s_.,'\u000f\u0005\u0003\u0003\u0012\n]UB\u0001BJ\u0015\r\u0011)*]\u0001\b]\u0016$xo\u001c:l\u0013\u0011\u0011IJa%\u0003\u001d\t\u0013xn[3s\u000b:$\u0007k\\5oi\"9!q\u0006\u0016A\u0002\tM\u0012aF1eI\u001a+Go\u00195fe\u001a{'\u000fU1si&$\u0018n\u001c8t)!\tYN!)\u0003.\n=\u0006b\u0002BRW\u0001\u0007!QU\u0001\u0014a\u0006\u0014H/\u001b;j_:\fe\u000eZ(gMN,Go\u001d\t\u0007wz\u0014YFa*\u0011\u0007\u0019\u0014I+C\u0002\u0003,z\u0012\u0011#\u00138ji&\fGNR3uG\"\u001cF/\u0019;f\u0011\u001d\u0011yc\u000ba\u0001\u0005gA\u0011B!-,!\u0003\u0005\rAa-\u0002\u0011\r\fG\u000e\u001c2bG.\u0004\u0012B\u0012B[\u00057\ny!a7\n\u0007\t]vIA\u0005Gk:\u001cG/[8oe\u0005\t\u0013\r\u001a3GKR\u001c\u0007.\u001a:G_J\u0004\u0016M\u001d;ji&|gn\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!Q\u0018\u0016\u0005\u0005g\u0013y$\u0001\nbI\u00124\u0015-\u001b7fIB\u000b'\u000f^5uS>tG\u0003BAn\u0005\u0007DqA!\u0017.\u0001\u0004\u0011Y&\u0001\u000fbI\u0012\u0004\u0016M\u001d;ji&|gn\u001d+p\r\u0016$8\r[3s)\"\u0014X-\u00193\u0015\r\u0005m'\u0011\u001aBg\u0011\u001d\u0011YM\fa\u0001\u0003\u001f\tQBZ3uG\",'\u000f\u00165sK\u0006$\u0007b\u0002Bh]\u0001\u0007!QU\u0001\u0017S:LG/[1m\u001f\u001a47/\u001a;B]\u0012,\u0005o\\2ig\u0006aR.Y=cK6KwM]1uK&s7+\u001f8d!\u0006\u0014H/\u001b;j_:\u001cH\u0003BAn\u0005+D\u0011B!-0!\u0003\u0005\rAa-\u0002M5\f\u0017PY3NS\u001e\u0014\u0018\r^3J]NKhn\u0019)beRLG/[8og\u0012\"WMZ1vYR$\u0013'A\nu_&s\u0017\u000e^5bY\u001a+Go\u00195Ti\u0006$X\r\u0006\u0004\u0003&\nu'\u0011\u001d\u0005\b\u0005?\f\u0004\u0019AA\u0010\u0003\u001d1W\r^2iKJDqAa92\u0001\u0004\u0011)/A\bqCJ$\u0018\u000e^5p]N#\u0018\r^3t!\u0019YhPa\u0017\u0003hB!!\u0011\u001eBv\u001b\u0005\t\u0018b\u0001Bwc\n\u0019\u0002+\u0019:uSRLwN\u001c$fi\u000eD7\u000b^1uK\u0006\u0019R.Y=cKV\u0003H-\u0019;f)>\u0004\u0018nY%egR1\u00111\u001cBz\u0005sDqA!>3\u0001\u0004\u001190\u0001\nqCJ$\u0018\u000e^5p]N$v.\u00169eCR,\u0007#B>\u007f\u00057\n\u0007b\u0002B~e\u0001\u0007!Q`\u0001\ti>\u0004\u0018nY%egB1aIa@T\u0007\u0007I1a!\u0001H\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003GW\u000e\u0015\u0001\u0003\u0002B/\u0007\u000fIAa!\u0003\u0003`\t!Q+^5e\u0003i\u0011X-\\8wK\u001a+Go\u00195fe\u001a{'\u000fU1si&$\u0018n\u001c8t)\u0011\u0011)oa\u0004\t\u000f\rE1\u00071\u0001\u0004\u0014\u0005Q\u0001/\u0019:uSRLwN\\:\u0011\u000bm\u001c)Ba\u0017\n\u0007\r]APA\u0002TKR\f!d\u001d5vi\u0012|wO\\%eY\u00164U\r^2iKJ$\u0006N]3bIN\f\u0001c\u00197pg\u0016\fE\u000e\u001c$fi\u000eDWM]:\u0002\u0011MDW\u000f\u001e3po:\fa#\u00112tiJ\f7\r\u001e$fi\u000eDWM]'b]\u0006<WM\u001d\t\u0003Mb\u001a\"\u0001O#\u0015\u0005\r\u0005\u0012a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0006\u0003\u0004,\r=RCAB\u0017U\rQ'q\b\u0003\b\u0003+Q$\u0019AA\f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%mU!1QGB\u001d+\t\u00199DK\u0002{\u0005\u007f!q!!\u0006<\u0005\u0004\t9\"A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeN\u000b\u0005\u0007\u007f\u0019\u0019%\u0006\u0002\u0004B)\"\u00111\u0001B \t\u001d\t)\u0002\u0010b\u0001\u0003/\u0001")
public abstract class AbstractFetcherManager<T extends AbstractFetcherThread>
implements Logging {
    private final String name;
    private final int numFetchers;
    private final KafkaMetricsGroup metricsGroup;
    private final HashMap<FetcherTag, T> fetcherThreadMap;
    private final Object lock;
    private final int[] numFetchersPerBroker;
    private final FetchConnectionsMode replicaFetchConnectionsMode;
    private final FailedPartitions failedPartitions;
    private final PausedPartitions pausedPartitions;
    private final Map<String, String> tags;
    private final Buffer<MetricName> addedMetrics;
    private final Option<KafkaMetricsGroup> intelligentReplicationMetricsGroup;
    private final Buffer<MetricName> addedIntelligentReplicationMetrics;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static <T extends AbstractFetcherThread> boolean $lessinit$greater$default$7() {
        return AbstractFetcherManager$.MODULE$.$lessinit$greater$default$7();
    }

    public static <T extends AbstractFetcherThread> Map<String, String> $lessinit$greater$default$6() {
        return AbstractFetcherManager$.MODULE$.$lessinit$greater$default$6();
    }

    public static <T extends AbstractFetcherThread> Option<Scheduler> $lessinit$greater$default$5() {
        return AbstractFetcherManager$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        AbstractFetcherManager abstractFetcherManager = this;
        synchronized (abstractFetcherManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String name() {
        return this.name;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public HashMap<FetcherTag, T> fetcherThreadMap() {
        return this.fetcherThreadMap;
    }

    public Object lock() {
        return this.lock;
    }

    public int[] numFetchersPerBroker() {
        return this.numFetchersPerBroker;
    }

    public FetchConnectionsMode replicaFetchConnectionsMode() {
        return this.replicaFetchConnectionsMode;
    }

    public FailedPartitions failedPartitions() {
        return this.failedPartitions;
    }

    public PausedPartitions pausedPartitions() {
        return this.pausedPartitions;
    }

    private Map<String, String> tags() {
        return this.tags;
    }

    private Buffer<MetricName> addedMetrics() {
        return this.addedMetrics;
    }

    private Option<KafkaMetricsGroup> intelligentReplicationMetricsGroup() {
        return this.intelligentReplicationMetricsGroup;
    }

    private Buffer<MetricName> addedIntelligentReplicationMetrics() {
        return this.addedIntelligentReplicationMetrics;
    }

    public void createSeparateFetcherMetrics() {
        FetcherPool$.MODULE$.values().foreach((Function1<FetcherPool, Object> & Serializable)fetcherPool -> {
            this.createNewGauge("MinFetchRate", () -> BoxesRunTime.boxToDouble($this.minFetchRate((Map)$this.fetcherThreadMap().filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(AbstractFetcherManager.$anonfun$createSeparateFetcherMetrics$3(fetcherPool$1, x0$1))))), (Map)this.tags().$plus$plus((IterableOnce)scala.collection.Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("FetcherPool"), fetcherPool.name())}))));
            return BoxedUnit.UNIT;
        });
    }

    private double minFetchRate(Map<FetcherTag, T> fetcherMap) {
        double headRate = BoxesRunTime.unboxToDouble(fetcherMap.values().headOption().map((Function1<AbstractFetcherThread, Object> & Serializable)x$4 -> BoxesRunTime.boxToDouble(AbstractFetcherManager.$anonfun$minFetchRate$1(x$4))).getOrElse(() -> 0.0));
        return BoxesRunTime.unboxToDouble(fetcherMap.values().foldLeft(BoxesRunTime.boxToDouble(headRate), (Function2<Object, AbstractFetcherThread, Object> & Serializable)(curMinAll, fetcherThread) -> BoxesRunTime.boxToDouble(package$.MODULE$.min(BoxesRunTime.unboxToDouble(curMinAll), fetcherThread.fetcherStats().requestRate().oneMinuteRate()))));
    }

    private <V> void createNewGauge(String name, Supplier<V> metric, Map<String, String> tags) {
        MetricName metricName = this.metricsGroup().metricName(name, CollectionConverters$.MODULE$.MapHasAsJava(tags).asJava());
        this.metricsGroup().newGauge(metricName, metric);
        this.addedMetrics().$plus$eq(metricName);
    }

    public int deadThreadCount() {
        int n;
        Object object = this.lock();
        synchronized (object) {
            n = this.fetcherThreadMap().values().count((Function1<AbstractFetcherThread, Object> & Serializable)x$5 -> BoxesRunTime.boxToBoolean(x$5.isThreadFailed()));
        }
        return n;
    }

    public Map<String, String> deadThreadCountTags(Map<String, String> tags) {
        return tags;
    }

    public void resizeThreadPool(int newSize, Option<FetcherPool> fetcherPool) {
        Object object = this.lock();
        synchronized (object) {
            if (fetcherPool.isEmpty()) {
                FetcherPool$.MODULE$.values().foreach((Function1<FetcherPool, Object> & Serializable)pool -> {
                    this.maybeMigratePartitions$1(pool, newSize);
                    return BoxedUnit.UNIT;
                });
            } else {
                this.maybeMigratePartitions$1(fetcherPool.get(), newSize);
            }
            this.shutdownIdleFetcherThreads();
        }
    }

    public Option<FetcherPool> resizeThreadPool$default$2() {
        return None$.MODULE$;
    }

    public Option<T> getFetcher(TopicPartition topicPartition) {
        Option option;
        Object object = this.lock();
        synchronized (object) {
            option = this.fetcherThreadMap().values().find((Function1<AbstractFetcherThread, Object> & Serializable)fetcherThread -> BoxesRunTime.boxToBoolean(AbstractFetcherManager.$anonfun$getFetcher$1(topicPartition, fetcherThread)));
        }
        return option;
    }

    public int getFetcherId(TopicPartition topicPartition, FetcherPool fetcherPool) {
        int n;
        Object object = this.lock();
        synchronized (object) {
            n = Utils.abs((int)(31 * topicPartition.topic().hashCode() + topicPartition.partition())) % this.numFetchersPerBroker()[fetcherPool.index()];
        }
        return n;
    }

    public void markPartitionsForTruncation(int brokerId, TopicPartition topicPartition, long truncationOffset) {
        Object object = this.lock();
        synchronized (object) {
            FetcherPool$.MODULE$.values().foreach((Function1<FetcherPool, Object> & Serializable)fetcherPool -> {
                AbstractFetcherManager.$anonfun$markPartitionsForTruncation$1(this, topicPartition, brokerId, truncationOffset, fetcherPool);
                return BoxedUnit.UNIT;
            });
        }
    }

    public abstract T createFetcherThread(int var1, BrokerEndPoint var2, FetcherPool var3);

    public void addFetcherForPartitions(Map<TopicPartition, InitialFetchState> partitionAndOffsets, FetcherPool fetcherPool, Function2<TopicPartition, T, BoxedUnit> callback) {
        Object object = this.lock();
        synchronized (object) {
            scala.collection.immutable.Map partitionsPerFetcher = partitionAndOffsets.groupBy((Function1<Tuple2, BrokerAndFetcherId> & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    InitialFetchState brokerAndInitialFetchOffset = (InitialFetchState)tuple2._2();
                    return new BrokerAndFetcherId(brokerAndInitialFetchOffset.leader(), this.getFetcherId(topicPartition, fetcherPool));
                }
                throw new MatchError(tuple2);
            });
            partitionsPerFetcher.withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(AbstractFetcherManager.$anonfun$addFetcherForPartitions$2(check$ifrefutable$1))).foreach((Function1<Tuple2, Object> & Serializable)x$9 -> {
                AbstractFetcherManager.$anonfun$addFetcherForPartitions$3(this, fetcherPool, callback, x$9);
                return BoxedUnit.UNIT;
            });
        }
    }

    public Function2<TopicPartition, T, BoxedUnit> addFetcherForPartitions$default$3() {
        return (Function2<TopicPartition, AbstractFetcherThread, Object> & Serializable)(x$7, x$8) -> {
            AbstractFetcherManager.$anonfun$addFetcherForPartitions$default$3$1(x$7, x$8);
            return BoxedUnit.UNIT;
        };
    }

    public void addFailedPartition(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            this.failedPartitions().add(topicPartition);
        }
    }

    public void addPartitionsToFetcherThread(T fetcherThread, Map<TopicPartition, InitialFetchState> initialOffsetAndEpochs) {
        ((AbstractFetcherThread)fetcherThread).addPartitions(initialOffsetAndEpochs);
        this.info((Function0<String> & Serializable)() -> "Added fetcher " + fetcherThread.getName() + " to broker " + fetcherThread.leader().brokerEndPoint().id() + " for partitions " + initialOffsetAndEpochs);
    }

    public void maybeMigrateInSyncPartitions(Function2<TopicPartition, T, BoxedUnit> callback) {
        Object object = this.lock();
        synchronized (object) {
            ((IterableOps.WithFilter)this.fetcherThreadMap().withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean(AbstractFetcherManager.$anonfun$maybeMigrateInSyncPartitions$1(check$ifrefutable$2)))).foreach((Function1<Tuple2, Object> & Serializable)x$12 -> {
                AbstractFetcherManager.$anonfun$maybeMigrateInSyncPartitions$2(this, callback, x$12);
                return BoxedUnit.UNIT;
            });
            this.shutdownIdleFetcherThreads();
        }
    }

    public Function2<TopicPartition, T, BoxedUnit> maybeMigrateInSyncPartitions$default$1() {
        return (Function2<TopicPartition, AbstractFetcherThread, Object> & Serializable)(x$10, x$11) -> {
            AbstractFetcherManager.$anonfun$maybeMigrateInSyncPartitions$default$1$1(x$10, x$11);
            return BoxedUnit.UNIT;
        };
    }

    public Map<TopicPartition, InitialFetchState> toInitialFetchState(AbstractFetcherThread fetcher, Map<TopicPartition, PartitionFetchState> partitionStates) {
        return (Map)partitionStates.map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                PartitionFetchState fetchState = (PartitionFetchState)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicPartition), new InitialFetchState(OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(fetchState.topicId())), fetcher.leader().brokerEndPoint(), fetchState.currentLeaderEpoch(), fetchState.fetchOffset(), OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(fetchState.replicationSessionId())).map((Function1<Long, Object> & Serializable)x$13 -> BoxesRunTime.boxToLong(Predef$.MODULE$.Long2long(x$13)))));
            }
            throw new MatchError(tuple2);
        });
    }

    public void maybeUpdateTopicIds(Map<TopicPartition, Object> partitionsToUpdate, Function1<String, Option<Uuid>> topicIds) {
        Object object = this.lock();
        synchronized (object) {
            scala.collection.immutable.Map partitionsPerFetcher = (scala.collection.immutable.Map)partitionsToUpdate.groupBy((Function1<Tuple2, Seq> & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    int leaderId = tuple2._2$mcI$sp();
                    return (Seq)FetcherPool$.MODULE$.values().map((Function1<FetcherPool, FetcherTag> & Serializable)poolType -> new FetcherTag(leaderId, this.getFetcherId(topicPartition, (FetcherPool)poolType), (FetcherPool)poolType));
                }
                throw new MatchError(tuple2);
            }).map((Function1<Tuple2, Tuple2> & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    Seq brokerAndFetcherId = (Seq)tuple2._1();
                    Map partitionsToUpdate = (Map)tuple2._2();
                    return new Tuple2(brokerAndFetcherId, partitionsToUpdate.keySet());
                }
                throw new MatchError(tuple2);
            });
            partitionsPerFetcher.withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean(AbstractFetcherManager.$anonfun$maybeUpdateTopicIds$4(check$ifrefutable$3))).foreach((Function1<Tuple2, Object> & Serializable)x$15 -> {
                AbstractFetcherManager.$anonfun$maybeUpdateTopicIds$5(this, topicIds, x$15);
                return BoxedUnit.UNIT;
            });
        }
    }

    public Map<TopicPartition, PartitionFetchState> removeFetcherForPartitions(Set<TopicPartition> partitions) {
        scala.collection.mutable.Map fetchStates;
        block3: {
            fetchStates = (scala.collection.mutable.Map)Map$.MODULE$.empty();
            Object object = this.lock();
            synchronized (object) {
                this.fetcherThreadMap().values().foreach((Function1<AbstractFetcherThread, scala.collection.mutable.Map> & Serializable)fetcher -> (scala.collection.mutable.Map)fetchStates.$plus$plus$eq(fetcher.removePartitions(partitions)));
                this.failedPartitions().removeAll(partitions);
                this.pausedPartitions().removeAll(partitions);
            }
            if (!partitions.nonEmpty()) break block3;
            this.info((Function0<String> & Serializable)() -> "Removed fetcher for partitions " + partitions);
        }
        return fetchStates;
    }

    public void shutdownIdleFetcherThreads() {
        Object object = this.lock();
        synchronized (object) {
            HashSet keysToBeRemoved = new HashSet();
            ((IterableOps.WithFilter)this.fetcherThreadMap().withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean(AbstractFetcherManager.$anonfun$shutdownIdleFetcherThreads$1(check$ifrefutable$4)))).foreach((Function1<Tuple2, Object> & Serializable)x$16 -> {
                Tuple2 tuple2 = x$16;
                if (tuple2 != null) {
                    FetcherTag key = (FetcherTag)tuple2._1();
                    AbstractFetcherThread fetcher = (AbstractFetcherThread)tuple2._2();
                    if (fetcher.partitionCount() <= 0) {
                        fetcher.shutdown();
                        return keysToBeRemoved.$plus$eq(key);
                    }
                    return BoxedUnit.UNIT;
                }
                throw new MatchError(tuple2);
            });
            HashMap cfr_ignored_0 = (HashMap)this.fetcherThreadMap().$minus$minus$eq(keysToBeRemoved);
        }
    }

    public void closeAllFetchers() {
        Object object = this.lock();
        synchronized (object) {
            ((IterableOps.WithFilter)this.fetcherThreadMap().withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean(AbstractFetcherManager.$anonfun$closeAllFetchers$1(check$ifrefutable$5)))).foreach((Function1<Tuple2, Object> & Serializable)x$17 -> BoxesRunTime.boxToBoolean(AbstractFetcherManager.$anonfun$closeAllFetchers$2(x$17)));
            ((IterableOps.WithFilter)this.fetcherThreadMap().withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$6 -> BoxesRunTime.boxToBoolean(AbstractFetcherManager.$anonfun$closeAllFetchers$3(check$ifrefutable$6)))).foreach((Function1<Tuple2, Object> & Serializable)x$18 -> {
                AbstractFetcherManager.$anonfun$closeAllFetchers$4(x$18);
                return BoxedUnit.UNIT;
            });
            this.fetcherThreadMap().clear();
        }
    }

    public void shutdown() {
        this.closeAllFetchers();
        this.addedMetrics().foreach((Function1<MetricName, Object> & Serializable)metricName -> {
            AbstractFetcherManager.$anonfun$shutdown$1(this, metricName);
            return BoxedUnit.UNIT;
        });
        this.intelligentReplicationMetricsGroup().foreach((Function1<KafkaMetricsGroup, Object> & Serializable)intelligentMetricsGroup -> {
            AbstractFetcherManager.$anonfun$shutdown$2(this, intelligentMetricsGroup);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ long $anonfun$new$2(long curMaxLagAll, AbstractFetcherThread fetcherThread) {
        long maxLagThread = fetcherThread.fetcherLagStats().stats().values().stream().mapToLong(v -> v.lag()).max().orElse(0L);
        return package$.MODULE$.max(curMaxLagAll, maxLagThread);
    }

    public static final /* synthetic */ long $anonfun$new$1(AbstractFetcherManager $this) {
        return BoxesRunTime.unboxToLong($this.fetcherThreadMap().values().foldLeft(BoxesRunTime.boxToLong(0L), (Function2<Object, AbstractFetcherThread, Object> & Serializable)(curMaxLagAll, fetcherThread) -> BoxesRunTime.boxToLong(AbstractFetcherManager.$anonfun$new$2(BoxesRunTime.unboxToLong(curMaxLagAll), fetcherThread))));
    }

    public static final /* synthetic */ long $anonfun$new$5(AbstractFetcherThread x$1) {
        return BoxesRunTime.unboxToLong(CollectionConverters$.MODULE$.CollectionHasAsScala(x$1.fetcherLagStats().stats().values()).asScala().iterator().map((Function1<FetcherLagMetrics, Object> & Serializable)x$2 -> BoxesRunTime.boxToLong(x$2.lag())).sum(Numeric.LongIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$new$4(AbstractFetcherManager $this) {
        return BoxesRunTime.unboxToLong($this.fetcherThreadMap().valuesIterator().map((Function1<AbstractFetcherThread, Object> & Serializable)x$1 -> BoxesRunTime.boxToLong(AbstractFetcherManager.$anonfun$new$5(x$1))).sum(Numeric.LongIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ double $anonfun$new$9(AbstractFetcherThread x$3) {
        return x$3.fetcherStats().requestRate().oneMinuteRate();
    }

    public static final /* synthetic */ double $anonfun$new$8(AbstractFetcherManager $this) {
        return BoxesRunTime.unboxToDouble($this.fetcherThreadMap().valuesIterator().map((Function1<AbstractFetcherThread, Object> & Serializable)x$3 -> BoxesRunTime.boxToDouble(AbstractFetcherManager.$anonfun$new$9(x$3))).sum(Numeric.DoubleIsFractional$.MODULE$));
    }

    public static final /* synthetic */ int $anonfun$new$10(AbstractFetcherManager $this) {
        return $this.failedPartitions().size();
    }

    public static final /* synthetic */ int $anonfun$new$11(AbstractFetcherManager $this) {
        return $this.pausedPartitions().size();
    }

    public static final /* synthetic */ int $anonfun$new$13(AbstractFetcherManager $this) {
        return $this.pausedPartitions().size();
    }

    public static final /* synthetic */ void $anonfun$new$15(AbstractFetcherManager $this, Scheduler s) {
        s.schedule("migrate-in-sync-partitions-thread", () -> $this.maybeMigrateInSyncPartitions($this.maybeMigrateInSyncPartitions$default$1()), 0L, 1000L);
        $this.createSeparateFetcherMetrics();
    }

    public static final /* synthetic */ boolean $anonfun$createSeparateFetcherMetrics$3(FetcherPool fetcherPool$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            FetcherTag ft = (FetcherTag)tuple2._1();
            FetcherPool fetcherPool = ft.fetcherPool();
            FetcherPool fetcherPool2 = fetcherPool$1;
            return !(fetcherPool != null ? !fetcherPool.equals(fetcherPool2) : fetcherPool2 != null);
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ double $anonfun$minFetchRate$1(AbstractFetcherThread x$4) {
        return x$4.fetcherStats().requestRate().oneMinuteRate();
    }

    private final void maybeMigratePartitions$1(FetcherPool fetcherPool, int newSize$1) {
        int currentSize = this.numFetchersPerBroker()[fetcherPool.index()];
        if (newSize$1 != currentSize) {
            this.numFetchersPerBroker()[fetcherPool.index()] = newSize$1;
            this.info((Function0<String> & Serializable)() -> "Resizing fetcher thread in " + fetcherPool.name() + " size from " + currentSize + " to " + newSize$1);
            this.migratePartitions$1(newSize$1, fetcherPool);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$resizeThreadPool$2(FetcherPool fetcherPool$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            FetcherTag fetcherTag = (FetcherTag)tuple2._1();
            FetcherPool fetcherPool = fetcherTag.fetcherPool();
            FetcherPool fetcherPool2 = fetcherPool$3;
            return !(fetcherPool != null ? !fetcherPool.equals(fetcherPool2) : fetcherPool2 != null);
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$resizeThreadPool$4(AbstractFetcherThread thread$1, scala.collection.mutable.Map allRemovedPartitionsMapByFetcherPool$1, FetcherTag id$1, TopicPartition topicPartition, PartitionFetchState currentFetchState) {
        InitialFetchState initialFetchState = new InitialFetchState(OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(currentFetchState.topicId())), thread$1.leader().brokerEndPoint(), currentFetchState.currentLeaderEpoch(), currentFetchState.fetchOffset(), OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(currentFetchState.replicationSessionId())).map((Function1<Long, Object> & Serializable)x$6 -> BoxesRunTime.boxToLong(Predef$.MODULE$.Long2long(x$6))));
        scala.collection.mutable.Map allRemovedPartitionsMap = (scala.collection.mutable.Map)allRemovedPartitionsMapByFetcherPool$1.getOrElseUpdate(id$1.fetcherPool(), (Function0<scala.collection.mutable.Map> & Serializable)() -> (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$));
        allRemovedPartitionsMap.update(topicPartition, initialFetchState);
    }

    public static final /* synthetic */ void $anonfun$resizeThreadPool$3(int newSize$2, scala.collection.mutable.Map allRemovedPartitionsMapByFetcherPool$1, FetcherTag id, AbstractFetcherThread thread) {
        Map<TopicPartition, PartitionFetchState> partitionStates = thread.removeAllPartitions();
        if (id.fetcherId() >= newSize$2) {
            thread.shutdown();
        }
        partitionStates.foreachEntry((Function2<TopicPartition, PartitionFetchState, Object> & Serializable)(topicPartition, currentFetchState) -> {
            AbstractFetcherManager.$anonfun$resizeThreadPool$4(thread, allRemovedPartitionsMapByFetcherPool$1, id, topicPartition, currentFetchState);
            return BoxedUnit.UNIT;
        });
    }

    private final void migratePartitions$1(int newSize, FetcherPool fetcherPool2) {
        scala.collection.mutable.Map allRemovedPartitionsMapByFetcherPool = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        HashMap filteredFetcherThreads = (HashMap)this.fetcherThreadMap().filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(AbstractFetcherManager.$anonfun$resizeThreadPool$2(fetcherPool2, x0$1)));
        filteredFetcherThreads.foreachEntry((Function2<FetcherTag, AbstractFetcherThread, Object> & Serializable)(id, thread) -> {
            AbstractFetcherManager.$anonfun$resizeThreadPool$3(newSize, allRemovedPartitionsMapByFetcherPool, id, thread);
            return BoxedUnit.UNIT;
        });
        allRemovedPartitionsMapByFetcherPool.foreachEntry((Function2<FetcherPool, scala.collection.mutable.Map, Object> & Serializable)(fetcherPool, allRemovedPartitionsMap) -> {
            this.addFetcherForPartitions(allRemovedPartitionsMap, fetcherPool, this.addFetcherForPartitions$default$3());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getFetcher$1(TopicPartition topicPartition$1, AbstractFetcherThread fetcherThread) {
        return fetcherThread.fetchState(topicPartition$1).isDefined();
    }

    public static final /* synthetic */ void $anonfun$markPartitionsForTruncation$1(AbstractFetcherManager $this, TopicPartition topicPartition$2, int brokerId$1, long truncationOffset$1, FetcherPool fetcherPool) {
        int fetcherId = $this.getFetcherId(topicPartition$2, fetcherPool);
        FetcherTag fetcherTag = new FetcherTag(brokerId$1, fetcherId, fetcherPool);
        $this.fetcherThreadMap().get(fetcherTag).foreach((Function1<AbstractFetcherThread, Object> & Serializable)thread -> {
            thread.markPartitionsForTruncation(topicPartition$2, truncationOffset$1);
            return BoxedUnit.UNIT;
        });
    }

    private final AbstractFetcherThread addAndStartFetcherThread$1(BrokerAndFetcherId brokerAndFetcherId, FetcherTag fetcherTag) {
        T fetcherThread = this.createFetcherThread(brokerAndFetcherId.fetcherId(), brokerAndFetcherId.broker(), fetcherTag.fetcherPool());
        this.fetcherThreadMap().put(fetcherTag, fetcherThread);
        ((AbstractFetcherThread)fetcherThread).start();
        return fetcherThread;
    }

    public static final /* synthetic */ boolean $anonfun$addFetcherForPartitions$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$addFetcherForPartitions$3(AbstractFetcherManager $this, FetcherPool fetcherPool$4, Function2 callback$1, Tuple2 x$9) {
        block6: {
            var6_4 = x$9;
            if (var6_4 == null) break block6;
            brokerAndFetcherId = (BrokerAndFetcherId)var6_4._1();
            initialFetchOffsets = (Map)var6_4._2();
            fetcherTag = new FetcherTag(brokerAndFetcherId.broker().id(), brokerAndFetcherId.fetcherId(), fetcherPool$4);
            var11_8 = false;
            var12_9 = null;
            var13_10 = $this.fetcherThreadMap().get(fetcherTag);
            if (!(var13_10 instanceof Some)) ** GOTO lbl-1000
            var11_8 = true;
            var12_9 = (Some)var13_10;
            currentFetcherThread = (AbstractFetcherThread)var12_9.value();
            v0 = currentFetcherThread.leader().brokerEndPoint();
            var15_12 = brokerAndFetcherId.broker();
            if (!(v0 != null ? v0.equals(var15_12) == false : var15_12 != null)) {
                v1 = currentFetcherThread;
            } else if (var11_8) {
                f = (AbstractFetcherThread)var12_9.value();
                f.shutdown();
                v1 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, fetcherTag);
            } else if (None$.MODULE$.equals(var13_10)) {
                v1 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, fetcherTag);
            } else {
                throw new MatchError(var13_10);
            }
            fetcherThread = v1;
            $this.addPartitionsToFetcherThread(fetcherThread, initialFetchOffsets);
            initialFetchOffsets.keys().foreach((Function1<TopicPartition, Object> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$addFetcherForPartitions$4$adapted(scala.Function2 kafka.server.AbstractFetcherThread org.apache.kafka.common.TopicPartition ), (Lorg/apache/kafka/common/TopicPartition;)Ljava/lang/Object;)((Function2)callback$1, (AbstractFetcherThread)fetcherThread));
            return;
        }
        throw new MatchError(var6_4);
    }

    public static final /* synthetic */ void $anonfun$addFetcherForPartitions$default$3$1(TopicPartition x$7, AbstractFetcherThread x$8) {
    }

    public static final /* synthetic */ boolean $anonfun$maybeMigrateInSyncPartitions$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$maybeMigrateInSyncPartitions$3(Tuple2 x0$1) {
        FetcherLagMetrics lagMetrics;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null && (lagMetrics = (FetcherLagMetrics)tuple2._2()) != null) {
            FetcherLagMetrics fetcherLagMetrics = lagMetrics;
            return fetcherLagMetrics.lag() == 0L;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$maybeMigrateInSyncPartitions$2(AbstractFetcherManager $this, Function2 callback$2, Tuple2 x$12) {
        Tuple2 tuple2 = x$12;
        if (tuple2 != null) {
            FetcherTag tag = (FetcherTag)tuple2._1();
            AbstractFetcherThread fetcher = (AbstractFetcherThread)tuple2._2();
            FetcherPool fetcherPool = tag.fetcherPool();
            FetcherPool$Default$ fetcherPool$Default$ = FetcherPool$Default$.MODULE$;
            if (!(fetcherPool != null ? !fetcherPool.equals(fetcherPool$Default$) : fetcherPool$Default$ != null)) {
                scala.collection.immutable.Set<TopicPartition> inSyncPartitions = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(fetcher.fetcherLagStats().stats()).asScala().filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(AbstractFetcherManager.$anonfun$maybeMigrateInSyncPartitions$3(x0$1)))).map((Function1<Tuple2, TopicPartition> & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        TopicPartition topicPartition = (TopicPartition)tuple2._1();
                        return topicPartition;
                    }
                    throw new MatchError(tuple2);
                })).toSet();
                Map<TopicPartition, PartitionFetchState> partitionStates = fetcher.removePartitions(inSyncPartitions);
                Map<TopicPartition, InitialFetchState> fetchStates = $this.toInitialFetchState(fetcher, partitionStates);
                $this.addFetcherForPartitions(fetchStates, FetcherPool$InSync$.MODULE$, callback$2);
                if (partitionStates.nonEmpty()) {
                    $this.info((Function0<String> & Serializable)() -> "Moved " + partitionStates.keys() + " partitions from " + FetcherPool$Default$.MODULE$ + " to " + FetcherPool$InSync$.MODULE$ + " for " + tag);
                    return;
                }
                return;
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$maybeMigrateInSyncPartitions$default$1$1(TopicPartition x$10, AbstractFetcherThread x$11) {
    }

    public static final /* synthetic */ boolean $anonfun$maybeUpdateTopicIds$4(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$maybeUpdateTopicIds$6(AbstractFetcherManager $this, Set partitions$1, Function1 topicIds$1, FetcherTag fetcherTag) {
        $this.fetcherThreadMap().get(fetcherTag).foreach((Function1<AbstractFetcherThread, Object> & Serializable)x$14 -> {
            x$14.maybeUpdateTopicIds(partitions$1, topicIds$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$maybeUpdateTopicIds$5(AbstractFetcherManager $this, Function1 topicIds$1, Tuple2 x$15) {
        Tuple2 tuple2 = x$15;
        if (tuple2 != null) {
            Seq fetcherTags = (Seq)tuple2._1();
            Set partitions = (Set)tuple2._2();
            fetcherTags.foreach((Function1<FetcherTag, Object> & Serializable)fetcherTag -> {
                AbstractFetcherManager.$anonfun$maybeUpdateTopicIds$6($this, partitions, topicIds$1, fetcherTag);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$shutdownIdleFetcherThreads$1(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$1(Tuple2 check$ifrefutable$5) {
        Tuple2 tuple2 = check$ifrefutable$5;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$2(Tuple2 x$17) {
        Tuple2 tuple2 = x$17;
        if (tuple2 != null) {
            AbstractFetcherThread fetcher = (AbstractFetcherThread)tuple2._2();
            return fetcher.initiateShutdown();
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$3(Tuple2 check$ifrefutable$6) {
        Tuple2 tuple2 = check$ifrefutable$6;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$closeAllFetchers$4(Tuple2 x$18) {
        Tuple2 tuple2 = x$18;
        if (tuple2 != null) {
            AbstractFetcherThread fetcher = (AbstractFetcherThread)tuple2._2();
            fetcher.shutdown();
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$shutdown$1(AbstractFetcherManager $this, MetricName metricName) {
        $this.metricsGroup().removeMetric(metricName);
    }

    public static final /* synthetic */ void $anonfun$shutdown$2(AbstractFetcherManager $this, KafkaMetricsGroup intelligentMetricsGroup) {
        $this.addedIntelligentReplicationMetrics().foreach((Function1<MetricName, Object> & Serializable)metricName -> {
            intelligentMetricsGroup.removeMetric(metricName);
            return BoxedUnit.UNIT;
        });
    }

    public AbstractFetcherManager(String name, String clientId, int numFetchers, FetchConnectionsMode fetchMode, Option<Scheduler> scheduler, Map<String, String> extraMetricTags, boolean isCCloud) {
        BoxedUnit boxedUnit;
        this.name = name;
        this.numFetchers = numFetchers;
        Logging.$init$(this);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.fetcherThreadMap = new HashMap();
        this.lock = new Object();
        this.numFetchersPerBroker = (int[])Array$.MODULE$.fill(FetcherPool$.MODULE$.values().size(), () -> $this.numFetchers, ClassTag$.MODULE$.Int());
        this.replicaFetchConnectionsMode = fetchMode;
        this.failedPartitions = new FailedPartitions();
        this.pausedPartitions = new PausedPartitions();
        this.logIdent_$eq("[" + name + "] ");
        this.tags = (Map)((MapOps)scala.collection.Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("clientId"), clientId)}))).$plus$plus(extraMetricTags);
        this.addedMetrics = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.intelligentReplicationMetricsGroup = !isCCloud ? new Some<KafkaMetricsGroup>(new KafkaMetricsGroup("kafka.server", "IntelligentReplication")) : None$.MODULE$;
        this.addedIntelligentReplicationMetrics = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.createNewGauge("MaxLag", () -> BoxesRunTime.boxToLong(AbstractFetcherManager.$anonfun$new$1(this)), this.tags());
        this.createNewGauge("TotalLag", () -> BoxesRunTime.boxToLong(AbstractFetcherManager.$anonfun$new$4(this)), this.tags());
        this.createNewGauge("MinFetchRate", () -> BoxesRunTime.boxToDouble(this.minFetchRate(this.fetcherThreadMap())), this.tags());
        this.createNewGauge("TotalFetchRate", () -> BoxesRunTime.boxToDouble(AbstractFetcherManager.$anonfun$new$8(this)), this.tags());
        this.createNewGauge("FailedPartitionsCount", () -> BoxesRunTime.boxToInteger(AbstractFetcherManager.$anonfun$new$10(this)), this.tags());
        if (isCCloud) {
            this.createNewGauge("PausedPartitionsCount", () -> BoxesRunTime.boxToInteger(AbstractFetcherManager.$anonfun$new$11(this)), this.tags());
        } else {
            this.intelligentReplicationMetricsGroup().foreach((Function1<KafkaMetricsGroup, Buffer> & Serializable)intelligentMetricsGroup -> {
                MetricName pushPartitionsCountMetricName = intelligentMetricsGroup.metricName("PushPartitionsCount", CollectionConverters$.MODULE$.MapHasAsJava(this.tags()).asJava());
                intelligentMetricsGroup.newGauge(pushPartitionsCountMetricName, () -> BoxesRunTime.boxToInteger(AbstractFetcherManager.$anonfun$new$13(this)));
                return (Buffer)this.addedIntelligentReplicationMetrics().$plus$eq(pushPartitionsCountMetricName);
            });
        }
        this.createNewGauge("DeadThreadCount", () -> BoxesRunTime.boxToInteger(this.deadThreadCount()), this.deadThreadCountTags(this.tags()));
        FetchConnectionsMode fetchConnectionsMode = this.replicaFetchConnectionsMode();
        FetchConnectionsMode$Isolated$ fetchConnectionsMode$Isolated$ = FetchConnectionsMode$Isolated$.MODULE$;
        if (!(fetchConnectionsMode != null ? !fetchConnectionsMode.equals(fetchConnectionsMode$Isolated$) : fetchConnectionsMode$Isolated$ != null)) {
            scheduler.foreach((Function1<Scheduler, Object> & Serializable)s -> {
                AbstractFetcherManager.$anonfun$new$15(this, s);
                return BoxedUnit.UNIT;
            });
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.locally(boxedUnit);
    }

    public static final /* synthetic */ Object $anonfun$addFetcherForPartitions$4$adapted(Function2 callback$1, AbstractFetcherThread fetcherThread$1, TopicPartition tp) {
        callback$1.apply(tp, fetcherThread$1);
        return BoxedUnit.UNIT;
    }
}

