/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import kafka.server.InternalAdmin;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.config.BrokerTypeTopicClient;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.KafkaThread;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005\u0005mc\u0001\u0002\u000f\u001e\u0001\tB\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!A!\t\u0001B\u0001B\u0003%1\t\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003I\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011\u001d\t\u0007A1A\u0005\n\tDaA\u001a\u0001!\u0002\u0013\u0019\u0007bB4\u0001\u0005\u0004%I\u0001\u001b\u0005\u0007Y\u0002\u0001\u000b\u0011B5\t\u000f5\u0004!\u0019!C\u0005]\"1!\u000f\u0001Q\u0001\n=Dqa\u001d\u0001C\u0002\u0013%!\r\u0003\u0004u\u0001\u0001\u0006Ia\u0019\u0005\bk\u0002\u0011\r\u0011\"\u0003w\u0011\u0019I\b\u0001)A\u0005o\"9!\u0010\u0001b\u0001\n\u00131\bBB>\u0001A\u0003%q\u000fC\u0004}\u0001\t\u0007I\u0011B?\t\u000f\u00055\u0001\u0001)A\u0005}\"I\u0011q\u0002\u0001C\u0002\u0013%\u0011\u0011\u0003\u0005\t\u0003W\u0001\u0001\u0015!\u0003\u0002\u0014!9\u0011Q\u0006\u0001\u0005\n\u0005=\u0002bBA\u001c\u0001\u0011%\u0011\u0011\b\u0005\b\u0003\u0003\u0002A\u0011BA\u0018\u0011\u001d\t\u0019\u0005\u0001C\u0005\u0003\u000bBq!a\u0016\u0001\t\u0003\ty\u0003C\u0004\u0002Z\u0001!\t!a\f\u0003-\t\u0013xn[3s)f\u0004X\rV8qS\u000e\u001c%/Z1u_JT!AH\u0010\u0002\rM,'O^3s\u0015\u0005\u0001\u0013!B6bM.\f7\u0001A\n\u0004\u0001\rJ\u0003C\u0001\u0013(\u001b\u0005)#\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!*#AB!osJ+g\r\u0005\u0002+[5\t1F\u0003\u0002-?\u0005)Q\u000f^5mg&\u0011af\u000b\u0002\b\u0019><w-\u001b8h\u0003Yy\u0016N\u001c;fe:\fG.\u00113nS:\u001cV\u000f\u001d9mS\u0016\u0014\bcA\u00199u5\t!G\u0003\u00024i\u0005Aa-\u001e8di&|gN\u0003\u00026m\u0005!Q\u000f^5m\u0015\u00059\u0014\u0001\u00026bm\u0006L!!\u000f\u001a\u0003\u0011M+\b\u000f\u001d7jKJ\u0004\"a\u000f\u001f\u000e\u0003uI!!P\u000f\u0003\u001b%sG/\u001a:oC2\fE-\\5o\u0003\u001dy6m\u001c8gS\u001e\u0004\"a\u000f!\n\u0005\u0005k\"aC&bM.\f7i\u001c8gS\u001e\f\u0011dX5oi\u0016\u0014(I]8lKJ\u001cE.[3oi\u000e{gNZ5hgB\u0019\u0011\u0007\u000f#\u0011\t\u00153\u0005jU\u0007\u0002i%\u0011q\t\u000e\u0002\u0004\u001b\u0006\u0004\bCA%Q\u001d\tQe\n\u0005\u0002LK5\tAJ\u0003\u0002NC\u00051AH]8pizJ!aT\u0013\u0002\rA\u0013X\rZ3g\u0013\t\t&K\u0001\u0004TiJLgn\u001a\u0006\u0003\u001f\u0016\u0002\"\u0001V,\u000e\u0003US!A\u0016\u001c\u0002\t1\fgnZ\u0005\u00031V\u0013aa\u00142kK\u000e$\u0018AC0dYV\u001cH/\u001a:JI\u00061A(\u001b8jiz\"R\u0001X/_?\u0002\u0004\"a\u000f\u0001\t\u000b=*\u0001\u0019\u0001\u0019\t\u000by*\u0001\u0019A \t\u000b\t+\u0001\u0019A\"\t\u000be+\u0001\u0019\u0001%\u0002%Q|\u0007/[2Ok6\u0004\u0016M\u001d;ji&|gn]\u000b\u0002GB\u0011A\u0005Z\u0005\u0003K\u0016\u00121!\u00138u\u0003M!x\u000e]5d\u001dVl\u0007+\u0019:uSRLwN\\:!\u0003Y!x\u000e]5d%\u0016\u0004H.[2bi&|gNR1di>\u0014X#A5\u0011\u0005\u0011R\u0017BA6&\u0005\u0015\u0019\u0006n\u001c:u\u0003]!x\u000e]5d%\u0016\u0004H.[2bi&|gNR1di>\u0014\b%A\u0006u_BL7mQ8oM&<W#A8\u0011\u0005\u0015\u0003\u0018BA95\u0005)\u0001&o\u001c9feRLWm]\u0001\ri>\u0004\u0018nY\"p]\u001aLw\rI\u0001\u0017i>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8CC\u000e\\wN\u001a4Ng\u00069Bo\u001c9jG\u000e\u0013X-\u0019;j_:\u0014\u0015mY6pM\u001al5\u000fI\u0001\u000eEJ|7.\u001a:UsB,7*Z=\u0016\u0003]\u0004\"\u0001\u0016=\n\u0005E+\u0016A\u00042s_.,'\u000fV=qK.+\u0017\u0010I\u0001\tG2LWM\u001c;JI\u0006I1\r\\5f]RLE\rI\u0001\u0005gR|\u0007/F\u0001\u007f!\ry\u0018\u0011B\u0007\u0003\u0003\u0003QA!a\u0001\u0002\u0006\u00051\u0011\r^8nS\u000eT1!a\u00025\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003\u0017\t\tAA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\u0006gR|\u0007\u000fI\u0001\u000eGJ,\u0017\r^8s)\"\u0014X-\u00193\u0016\u0005\u0005M\u0001\u0003BA\u000b\u0003Oi!!a\u0006\u000b\u00071\nIB\u0003\u0003\u0002\u001c\u0005u\u0011AB2p[6|gNC\u0002!\u0003?QA!!\t\u0002$\u00051\u0011\r]1dQ\u0016T!!!\n\u0002\u0007=\u0014x-\u0003\u0003\u0002*\u0005]!aC&bM.\fG\u000b\u001b:fC\u0012\fab\u0019:fCR|'\u000f\u00165sK\u0006$\u0007%\u0001\nf]N,(/\u001a+pa&\u001c7I]3bi\u0016$GCAA\u0019!\r!\u00131G\u0005\u0004\u0003k)#\u0001B+oSR\f\u0001#\\1zE\u0016\u001c%/Z1uKR{\u0007/[2\u0015\u0005\u0005m\u0002c\u0001\u0013\u0002>%\u0019\u0011qH\u0013\u0003\u000f\t{w\u000e\\3b]\u0006)RM\\:ve\u0016\u0014VmY8sIB+(\r\\5tQ\u0016$\u0017a\u00038foB\u0013x\u000eZ;dKJ$\"!a\u0012\u0011\r\u0005%\u00131\u000b%I\u001b\t\tYE\u0003\u0003\u0002N\u0005=\u0013\u0001\u00039s_\u0012,8-\u001a:\u000b\t\u0005E\u0013QD\u0001\bG2LWM\u001c;t\u0013\u0011\t)&a\u0013\u0003\u0011A\u0013x\u000eZ;dKJ\fQa\u001d;beR\f\u0001b\u001d5vi\u0012|wO\u001c")
public class BrokerTypeTopicCreator
implements Logging {
    private final Supplier<InternalAdmin> _internalAdminSupplier;
    private final KafkaConfig _config;
    private final Supplier<Map<String, Object>> _interBrokerClientConfigs;
    private final int topicNumPartitions;
    private final short topicReplicationFactor;
    private final Properties topicConfig;
    private final int topicCreationBackoffMs;
    private final String brokerTypeKey;
    private final String clientId;
    private final AtomicBoolean stop;
    private final KafkaThread creatorThread;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        BrokerTypeTopicCreator brokerTypeTopicCreator = this;
        synchronized (brokerTypeTopicCreator) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private int topicNumPartitions() {
        return this.topicNumPartitions;
    }

    private short topicReplicationFactor() {
        return this.topicReplicationFactor;
    }

    private Properties topicConfig() {
        return this.topicConfig;
    }

    private int topicCreationBackoffMs() {
        return this.topicCreationBackoffMs;
    }

    private String brokerTypeKey() {
        return this.brokerTypeKey;
    }

    private String clientId() {
        return this.clientId;
    }

    private AtomicBoolean stop() {
        return this.stop;
    }

    private KafkaThread creatorThread() {
        return this.creatorThread;
    }

    private void ensureTopicCreated() {
        while (!this.maybeCreateTopic() && !this.stop().get()) {
            this.warn((Function0<String> & Serializable)() -> "Failed to create __internal_confluent_only_broker_info, will retry in " + this.topicCreationBackoffMs());
            Thread.sleep(this.topicCreationBackoffMs());
        }
    }

    private boolean maybeCreateTopic() {
        if (this._interBrokerClientConfigs.get().isEmpty()) {
            this.info((Function0<String> & Serializable)() -> "Could not resolve bootstrap server. Will retry.");
            return false;
        }
        try {
            this.info((Function0<String> & Serializable)() -> "Try creating topic __internal_confluent_only_broker_info");
            this._internalAdminSupplier.get().ensureTopic("__internal_confluent_only_broker_info", this.topicNumPartitions(), this.topicReplicationFactor(), this.topicConfig());
        }
        catch (Exception e) {
            this.warn((Function0<String> & Serializable)() -> "Error creating topic", (Function0<Throwable>)(Function0<Exception> & Serializable)() -> e);
            return false;
        }
        return true;
    }

    private void ensureRecordPublished() {
        String brokerTypeValue = this._config.confluentConfig().brokerType();
        ProducerRecord record = new ProducerRecord("__internal_confluent_only_broker_info", (Object)this.brokerTypeKey(), (Object)brokerTypeValue);
        AtomicBoolean recordPublished = new AtomicBoolean(false);
        Using$.MODULE$.resource(this.newProducer(), (Function1<Producer, Object> & Serializable)producer -> {
            BrokerTypeTopicCreator.$anonfun$ensureRecordPublished$4(this, recordPublished, record, producer);
            return BoxedUnit.UNIT;
        }, Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private Producer<String, String> newProducer() {
        Properties properties = new Properties();
        this._interBrokerClientConfigs.get().forEach((key, value) -> properties.put(key, value));
        properties.put("acks", "all");
        properties.put("retries", BoxesRunTime.boxToInteger(5));
        properties.put("client.id", this.clientId());
        properties.put("max.in.flight.requests.per.connection", BoxesRunTime.boxToInteger(1));
        properties.put("enable.metrics.push", "false");
        properties.remove("metric.reporters");
        return new KafkaProducer(properties, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
    }

    public void start() {
        if (Predef$.MODULE$.Boolean2boolean(this._config.confluentConfig().brokerTypeTopicEnabled())) {
            this.creatorThread().start();
            return;
        }
    }

    public void shutdown() {
        if (this.creatorThread().isAlive()) {
            this.stop().set(true);
            this.creatorThread().interrupt();
            this.creatorThread().join();
            return;
        }
    }

    private final void produceCallback$1(RecordMetadata metadata, Exception e, AtomicBoolean recordPublished$1) {
        if (e == null) {
            this.info((Function0<String> & Serializable)() -> "Record has been added successfully at " + metadata + ".");
            recordPublished$1.set(true);
            return;
        }
        this.warn((Function0<String> & Serializable)() -> "Record produce failed", (Function0<Throwable>)(Function0<Exception> & Serializable)() -> e);
    }

    public static final /* synthetic */ void $anonfun$ensureRecordPublished$4(BrokerTypeTopicCreator $this, AtomicBoolean recordPublished$1, ProducerRecord record$1, Producer producer) {
        while (!recordPublished$1.get() && !$this.stop().get()) {
            $this.info((Function0<String> & Serializable)() -> "Producing record " + record$1);
            Future future = producer.send(record$1, (metadata, e) -> $this.produceCallback$1(metadata, e, recordPublished$1));
            future.get();
        }
    }

    public BrokerTypeTopicCreator(Supplier<InternalAdmin> _internalAdminSupplier, KafkaConfig _config, Supplier<Map<String, Object>> _interBrokerClientConfigs, String _clusterId) {
        this._internalAdminSupplier = _internalAdminSupplier;
        this._config = _config;
        this._interBrokerClientConfigs = _interBrokerClientConfigs;
        Logging.$init$(this);
        this.topicNumPartitions = 1;
        this.topicReplicationFactor = (short)Math.min(3, _config.defaultReplicationFactor());
        this.topicConfig = new Properties();
        this.topicConfig().put("cleanup.policy", "compact");
        this.topicCreationBackoffMs = 60000;
        this.brokerTypeKey = "broker_type";
        this.clientId = BrokerTypeTopicClient.clientId((String)_clusterId, (int)_config.brokerId());
        this.stop = new AtomicBoolean(false);
        this.creatorThread = KafkaThread.daemon((String)this.getClass().getSimpleName(), () -> {
            this.ensureTopicCreated();
            this.ensureRecordPublished();
            this.info((Function0<String> & Serializable)() -> "Ending the " + this.getClass().getSimpleName() + " thread.");
        });
    }
}

