/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.kafka.multitenant.ClusterLinkPrincipal;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import java.io.Serializable;
import java.net.InetAddress;
import kafka.server.ClusterLinkQuotaManagerConfig;
import kafka.server.ClusterLinkQuotas;
import kafka.server.ClusterLinkReplicaQuota;
import kafka.server.ClusterLinkTenantContext;
import kafka.server.ClusterLinkTenantRequestQuota;
import kafka.server.UnboundedClusterLinkReplicaQuota$;
import kafka.server.UnboundedClusterLinkTenantRequestQuota$;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.network.Session;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.runtime.ModuleSerializationProxy;

public final class ClusterLinkQuotas$
implements Serializable {
    public static final ClusterLinkQuotas$ MODULE$ = new ClusterLinkQuotas$();
    private static final String ClusterLinkClientId = "cluster-link-user";
    private static final InetAddress ClusterLinkClientAddress = InetAddress.getLocalHost();

    public String ClusterLinkClientId() {
        return ClusterLinkClientId;
    }

    private InetAddress ClusterLinkClientAddress() {
        return ClusterLinkClientAddress;
    }

    public Session session(MultiTenantPrincipal p) {
        return new Session((KafkaPrincipal)p, this.ClusterLinkClientAddress());
    }

    public Option<ClusterLinkPrincipal> clusterLinkReplicationQuotaPrincipal(ClusterLinkQuotaManagerConfig cfg, ClusterLinkTenantContext linkTenantContext, Function1<String, ConfluentConfigs.ClusterLinkQuotaMode> tenantQuotaMode) {
        if (cfg.clusterLinkTenantQuotaEnable().apply$mcZ$sp()) {
            return linkTenantContext.tenant().map((Function1<String, ClusterLinkPrincipal> & Serializable)tenant -> MODULE$.clusterLinkReplicationQuotaPrincipal((String)tenant, (ConfluentConfigs.ClusterLinkQuotaMode)tenantQuotaMode.apply((String)tenant)));
        }
        return None$.MODULE$;
    }

    public ClusterLinkPrincipal clusterLinkReplicationQuotaPrincipal(String tenant, ConfluentConfigs.ClusterLinkQuotaMode tenantQuotaMode) {
        ConfluentConfigs.ClusterLinkQuotaMode clusterLinkQuotaMode = tenantQuotaMode;
        ConfluentConfigs.ClusterLinkQuotaMode clusterLinkQuotaMode2 = ConfluentConfigs.ClusterLinkQuotaMode.CLUSTER_LINK_ONLY;
        String userResourceId = !(clusterLinkQuotaMode != null ? !clusterLinkQuotaMode.equals(clusterLinkQuotaMode2) : clusterLinkQuotaMode2 != null) ? "cluster-link-user-link-only" : "cluster-link-user";
        return new ClusterLinkPrincipal(tenant, userResourceId);
    }

    public Option<ClusterLinkPrincipal> clusterLinkRequestQuotaPrincipal(ClusterLinkQuotaManagerConfig cfg, ClusterLinkTenantContext linkTenantContext) {
        if (cfg.clusterLinkTenantQuotaEnable().apply$mcZ$sp()) {
            return linkTenantContext.tenant().map((Function1<String, ClusterLinkPrincipal> & Serializable)tenant -> new ClusterLinkPrincipal(tenant));
        }
        return None$.MODULE$;
    }

    public ClusterLinkQuotas unboundedClusterLinkQuotas() {
        return new ClusterLinkQuotas(UnboundedClusterLinkReplicaQuota$.MODULE$, UnboundedClusterLinkTenantRequestQuota$.MODULE$);
    }

    public ClusterLinkQuotas apply(ClusterLinkReplicaQuota produce, ClusterLinkTenantRequestQuota request) {
        return new ClusterLinkQuotas(produce, request);
    }

    public Option<Tuple2<ClusterLinkReplicaQuota, ClusterLinkTenantRequestQuota>> unapply(ClusterLinkQuotas x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some<Tuple2<ClusterLinkReplicaQuota, ClusterLinkTenantRequestQuota>>(new Tuple2<ClusterLinkReplicaQuota, ClusterLinkTenantRequestQuota>(x$0.produce(), x$0.request()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ClusterLinkQuotas$.class);
    }

    private ClusterLinkQuotas$() {
    }
}

