/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.kafka.multitenant.ClusterLinkPrincipal;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.server.ActiveTenantsManager;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ClientSensors;
import kafka.server.ClusterLinkQuotas$;
import kafka.server.ClusterLinkRequestQuotaManagerConfig;
import kafka.server.ClusterLinkTenantContext;
import kafka.server.ClusterLinkTenantRequestQuota;
import kafka.server.LinkRequestQuotaUsageType;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.internals.Plugin;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import org.apache.kafka.server.quota.QuotaType;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00055d\u0001\u0002\u000b\u0016\u0001iA\u0001B\t\u0001\u0003\u0006\u0004%Ia\t\u0005\tO\u0001\u0011\t\u0011)A\u0005I!A\u0001\u0006\u0001BC\u0002\u0013%\u0011\u0006\u0003\u00057\u0001\t\u0005\t\u0015!\u0003+\u0011%9\u0004A!A!\u0002\u0013Ad\b\u0003\u0005@\u0001\t\u0015\r\u0011\"\u0003A\u0011!q\u0005A!A!\u0002\u0013\t\u0005\u0002C(\u0001\u0005\u000b\u0007I\u0011\u0002)\t\u0011\t\u0004!\u0011!Q\u0001\nEC\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\u0006Q\u0002!\t!\u001b\u0005\u0006c\u0002!\tE\u001d\u0005\u0006y\u0002!\t% \u0005\t\u0003\u0007\u0001A\u0011A\u000b\u0002\u0006!A\u0011Q\u0002\u0001\u0005\u0002U\ty\u0001C\u0004\u00024\u0001!\t%!\u000e\t\u000f\u0005M\u0003\u0001\"\u0011\u0002V!9\u0011\u0011\f\u0001\u0005B\u0005m\u0003\"DA5\u0001A\u0005\u0019\u0011!A\u0005\n\u0005-dH\u0001\u0010DYV\u001cH/\u001a:MS:\\'+Z9vKN$\u0018+^8uC6\u000bg.Y4fe*\u0011acF\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003a\tQa[1gW\u0006\u001c\u0001aE\u0002\u00017}\u0001\"\u0001H\u000f\u000e\u0003UI!AH\u000b\u0003%\rc\u0017.\u001a8u#V|G/Y'b]\u0006<WM\u001d\t\u00039\u0001J!!I\u000b\u0003;\rcWo\u001d;fe2Kgn\u001b+f]\u0006tGOU3rk\u0016\u001cH/U;pi\u0006\f1a\u00194h+\u0005!\u0003C\u0001\u000f&\u0013\t1SC\u0001\u0013DYV\u001cH/\u001a:MS:\\'+Z9vKN$\u0018+^8uC6\u000bg.Y4fe\u000e{gNZ5h\u0003\u0011\u0019gm\u001a\u0011\u0002\u000f5,GO]5dgV\t!\u0006\u0005\u0002,i5\tAF\u0003\u0002)[)\u0011afL\u0001\u0007G>lWn\u001c8\u000b\u0005a\u0001$BA\u00193\u0003\u0019\t\u0007/Y2iK*\t1'A\u0002pe\u001eL!!\u000e\u0017\u0003\u000f5+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%\u0001\u0003uS6,\u0007CA\u001d=\u001b\u0005Q$BA\u001e.\u0003\u0015)H/\u001b7t\u0013\ti$H\u0001\u0003US6,\u0017BA\u001c\u001e\u0003A!\bN]3bI:\u000bW.\u001a)sK\u001aL\u00070F\u0001B!\t\u00115J\u0004\u0002D\u0013B\u0011AiR\u0007\u0002\u000b*\u0011a)G\u0001\u0007yI|w\u000e\u001e \u000b\u0003!\u000bQa]2bY\u0006L!AS$\u0002\rA\u0013X\rZ3g\u0013\taUJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0015\u001e\u000b\u0011\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=!\u0003M\u0019G.[3oiF+x\u000e^1DC2d'-Y2l+\u0005\t\u0006c\u0001*T+6\tq)\u0003\u0002U\u000f\n1q\n\u001d;j_:\u00042AV-\\\u001b\u00059&B\u0001-.\u0003%Ig\u000e^3s]\u0006d7/\u0003\u0002[/\n1\u0001\u000b\\;hS:\u0004\"\u0001\u00181\u000e\u0003uS!AX0\u0002\u000bE,x\u000e^1\u000b\u0005Yy\u0013BA1^\u0005M\u0019E.[3oiF+x\u000e^1DC2d'-Y2l\u0003Q\u0019G.[3oiF+x\u000e^1DC2d'-Y2lA\u0005!\u0012m\u0019;jm\u0016$VM\\1oiNl\u0015M\\1hKJ\u00042AU*f!\tab-\u0003\u0002h+\t!\u0012i\u0019;jm\u0016$VM\\1oiNl\u0015M\\1hKJ\fa\u0001P5oSRtDc\u00026lY6tw\u000e\u001d\t\u00039\u0001AQAI\u0006A\u0002\u0011BQ\u0001K\u0006A\u0002)BQaN\u0006A\u0002aBQaP\u0006A\u0002\u0005CQaT\u0006A\u0002ECQaY\u0006A\u0002\u0011\fAc\u00197jK:$(+\u0019;f\u001b\u0016$(/[2OC6,GCA:x!\t!X/D\u0001.\u0013\t1XF\u0001\u0006NKR\u0014\u0018n\u0019(b[\u0016DQ\u0001\u001f\u0007A\u0002e\fq\"];pi\u0006lU\r\u001e:jGR\u000bwm\u001d\t\u0005\u0005j\f\u0015)\u0003\u0002|\u001b\n\u0019Q*\u00199\u0002'\u001d,GO\u0011:pW\u0016\u0014\u0018+^8uC2KW.\u001b;\u0016\u0003y\u0004\"AU@\n\u0007\u0005\u0005qI\u0001\u0004E_V\u0014G.Z\u0001\u0015e\u0016\fX/Z:u#V|G/Y:F]\u0006\u0014G.\u001a3\u0016\u0005\u0005\u001d\u0001c\u0001*\u0002\n%\u0019\u00111B$\u0003\u000f\t{w\u000e\\3b]\u0006!2\r\\;ti\u0016\u0014H*\u001b8l!JLgnY5qC2$B!!\u0005\u0002*A!!kUA\n!\u0011\t)\"!\n\u000e\u0005\u0005]!\u0002BA\r\u00037\t1\"\\;mi&$XM\\1oi*\u0019\u0001$!\b\u000b\t\u0005}\u0011\u0011E\u0001\nG>tg\r\\;f]RT!!a\t\u0002\u0005%|\u0017\u0002BA\u0014\u0003/\u0011Ac\u00117vgR,'\u000fT5oWB\u0013\u0018N\\2ja\u0006d\u0007bBA\u0016\u001f\u0001\u0007\u0011QF\u0001\u0012Y&t7\u000eV3oC:$8i\u001c8uKb$\bc\u0001\u000f\u00020%\u0019\u0011\u0011G\u000b\u00031\rcWo\u001d;fe2Kgn\u001b+f]\u0006tGoQ8oi\u0016DH/\u0001\u0004sK\u000e|'\u000f\u001a\u000b\t\u0003o\ti$a\u0010\u0002JA\u0019!+!\u000f\n\u0007\u0005mrI\u0001\u0003V]&$\bbBA\u0016!\u0001\u0007\u0011Q\u0006\u0005\b\u0003\u0003\u0002\u0002\u0019AA\"\u0003\u001d1\u0018\r\\;f\u001dN\u00042AUA#\u0013\r\t9e\u0012\u0002\u0005\u0019>tw\rC\u0004\u0002LA\u0001\r!!\u0014\u0002\u0013U\u001c\u0018mZ3UsB,\u0007c\u0001\u000f\u0002P%\u0019\u0011\u0011K\u000b\u000331Kgn\u001b*fcV,7\u000f^)v_R\fWk]1hKRK\b/Z\u0001\u0010SN\fVo\u001c;b\u000bb\u001cW-\u001a3fIR!\u0011qAA,\u0011\u001d\tY#\u0005a\u0001\u0003[\t\u0011cZ3u)\"\u0014x\u000e\u001e;mKRKW.Z't)\u0019\ti&a\u0019\u0002fA\u0019!+a\u0018\n\u0007\u0005\u0005tIA\u0002J]RDq!a\u000b\u0013\u0001\u0004\ti\u0003C\u0004\u0002hI\u0001\r!a\u0011\u0002\u000bY\fG.^3\u0002\u0015M,\b/\u001a:%i&lW-F\u00019\u0001")
public class ClusterLinkRequestQuotaManager
extends ClientQuotaManager
implements ClusterLinkTenantRequestQuota {
    private final ClusterLinkRequestQuotaManagerConfig cfg;
    private final Metrics metrics;
    private final String threadNamePrefix;
    private final Option<Plugin<ClientQuotaCallback>> clientQuotaCallback;

    private /* synthetic */ Time super$time() {
        return super.time();
    }

    private ClusterLinkRequestQuotaManagerConfig cfg() {
        return this.cfg;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private Option<Plugin<ClientQuotaCallback>> clientQuotaCallback() {
        return this.clientQuotaCallback;
    }

    @Override
    public MetricName clientRateMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("request-time", QuotaType.CLUSTER_LINK_REQUEST.toString(), "Tracking request-time per tenant", CollectionConverters$.MODULE$.MapHasAsJava(quotaMetricTags).asJava());
    }

    @Override
    public double getBrokerQuotaLimit() {
        if (this.requestQuotasEnabled()) {
            return this.cfg().clusterLinkRequestQuotaCapacity().apply$mcI$sp();
        }
        return Double.MAX_VALUE;
    }

    public boolean requestQuotasEnabled() {
        return this.quotasEnabled() && this.cfg().clusterLinkEnable().apply$mcZ$sp() && this.cfg().clusterLinkTenantQuotaEnable().apply$mcZ$sp();
    }

    public Option<ClusterLinkPrincipal> clusterLinkPrincipal(ClusterLinkTenantContext linkTenantContext) {
        return ClusterLinkQuotas$.MODULE$.clusterLinkRequestQuotaPrincipal(this.cfg(), linkTenantContext);
    }

    @Override
    public void record(ClusterLinkTenantContext linkTenantContext, long valueNs, LinkRequestQuotaUsageType usageType) {
        if (this.requestQuotasEnabled()) {
            double timeInPercentage = ClientRequestQuotaManager.nanosToPercentage(valueNs);
            this.clusterLinkPrincipal(linkTenantContext).foreach((Function1<ClusterLinkPrincipal, Object> & Serializable)p -> BoxesRunTime.boxToInteger(ClusterLinkRequestQuotaManager.$anonfun$record$1(this, timeInPercentage, p)));
            return;
        }
    }

    @Override
    public boolean isQuotaExceeded(ClusterLinkTenantContext linkTenantContext) {
        return this.getThrottleTimeMs(linkTenantContext, super.time().milliseconds()) > 0;
    }

    @Override
    public int getThrottleTimeMs(ClusterLinkTenantContext linkTenantContext, long value) {
        if (this.requestQuotasEnabled()) {
            return BoxesRunTime.unboxToInt(this.clusterLinkPrincipal(linkTenantContext).map((Function1<ClusterLinkPrincipal, Object> & Serializable)p -> BoxesRunTime.boxToInteger(this.getThrottleTimeMs(ClusterLinkQuotas$.MODULE$.session((MultiTenantPrincipal)p), ClusterLinkQuotas$.MODULE$.ClusterLinkClientId(), this.super$time().milliseconds()))).getOrElse(() -> 0));
        }
        return 0;
    }

    public static final /* synthetic */ int $anonfun$record$1(ClusterLinkRequestQuotaManager $this, double timeInPercentage$1, ClusterLinkPrincipal p) {
        ClientSensors clientSensors = $this.getOrCreateQuotaSensors(ClusterLinkQuotas$.MODULE$.session((MultiTenantPrincipal)p), ClusterLinkQuotas$.MODULE$.ClusterLinkClientId());
        return $this.recordAndGetThrottleTimeMs(clientSensors, timeInPercentage$1, $this.super$time().milliseconds());
    }

    public ClusterLinkRequestQuotaManager(ClusterLinkRequestQuotaManagerConfig cfg, Metrics metrics, Time time, String threadNamePrefix, Option<Plugin<ClientQuotaCallback>> clientQuotaCallback, Option<ActiveTenantsManager> activeTenantsManager) {
        this.cfg = cfg;
        this.metrics = metrics;
        this.threadNamePrefix = threadNamePrefix;
        this.clientQuotaCallback = clientQuotaCallback;
        super(cfg.clientQuotaManagerConfig(), metrics, QuotaType.CLUSTER_LINK_REQUEST, time, threadNamePrefix, clientQuotaCallback, activeTenantsManager);
        super.updateClientQuotaMaxThrottleTimeMs(TimeUnit.SECONDS.toMillis(cfg.clientQuotaManagerConfig().quotaWindowSizeSeconds));
    }
}

