/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.server.TierMaterializationRequirements;
import io.confluent.kafka.server.TierOffsetInfo;
import io.confluent.kafka.storage.TierState;
import io.confluent.kafka.storage.log.AbstractLog;
import io.confluent.kafka.storage.log.TierLogSegment;
import java.io.Serializable;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.cluster.Partition;
import kafka.server.ReplicaManager;
import kafka.server.TierStateMachine;
import kafka.tier.exceptions.TierPartitionStateClosedException;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.LeaderEndPoint;
import org.apache.kafka.server.PartitionFetchState;
import org.apache.kafka.server.ReplicaState;
import scala.Function0;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r%d\u0001B&M\u0001EC\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006I!\u0018\u0005\tO\u0002\u0011\t\u0011)A\u0005Q\"A1\u000e\u0001B\u0001B\u0003%A\u000eC\u0003t\u0001\u0011\u0005A\u000fC\u0003z\u0001\u0011\u0005#\u0010C\u0004\u0002>\u0001!\t%a\u0010\t\u0011\u0005]\u0003\u0001\"\u0001M\u00033B\u0001\"a%\u0001\t\u0003a\u0015Q\u0013\u0005\b\u0003_\u0003A\u0011BAY\u0011\u001d\u0019\u0019\u0005\u0001C\u0005\u0007\u000bB\u0001ba\u0014\u0001\t\u0003a5\u0011\u000b\u0005\t\u0007C\u0002A\u0011\u0001'\u0004d\u001d9\u0011q\u0019'\t\u0002\u0005%gAB&M\u0011\u0003\tY\r\u0003\u0004t\u001d\u0011\u0005\u00111\u001b\u0004\u0007\u0003+t\u0001)a6\t\u0015\t\r\u0001C!f\u0001\n\u0003\u0011)\u0001\u0003\u0006\u0003\bA\u0011\t\u0012)A\u0005\u00037B!B!\u0003\u0011\u0005+\u0007I\u0011\u0001B\u0006\u0011)\u0011i\u0001\u0005B\tB\u0003%\u0011q\u0011\u0005\u000b\u0005\u001f\u0001\"Q3A\u0005\u0002\tE\u0001B\u0003B\n!\tE\t\u0015!\u0003\u0002f\"11\u000f\u0005C\u0001\u0005+A\u0011B!\t\u0011\u0003\u0003%\tAa\t\t\u0013\t-\u0002#%A\u0005\u0002\t5\u0002\"\u0003B\"!E\u0005I\u0011\u0001B#\u0011%\u0011I\u0005EI\u0001\n\u0003\u0011Y\u0005C\u0005\u0003PA\t\t\u0011\"\u0011\u0003R!I!\u0011\f\t\u0002\u0002\u0013\u0005!1\f\u0005\n\u0005;\u0002\u0012\u0011!C\u0001\u0005?B\u0011Ba\u001b\u0011\u0003\u0003%\tE!\u001c\t\u0013\tm\u0004#!A\u0005\u0002\tu\u0004\"\u0003BD!\u0005\u0005I\u0011\tBE\u0011%\u0011i\tEA\u0001\n\u0003\u0012y\tC\u0005\u0003\u0012B\t\t\u0011\"\u0011\u0003\u0014\"I!Q\u0013\t\u0002\u0002\u0013\u0005#qS\u0004\n\u00057s\u0011\u0011!E\u0001\u0005;3\u0011\"!6\u000f\u0003\u0003E\tAa(\t\rM4C\u0011\u0001B[\u0011%\u0011\tJJA\u0001\n\u000b\u0012\u0019\nC\u0005\u00038\u001a\n\t\u0011\"!\u0003:\"I!\u0011\u0019\u0014\u0002\u0002\u0013\u0005%1\u0019\u0005\n\u0005+4\u0013\u0011!C\u0005\u0005/4aA!7\u000f\u0001\nm\u0007B\u0003B\u0002Y\tU\r\u0011\"\u0001\u0003^\"Q!q\u0001\u0017\u0003\u0012\u0003\u0006IAa8\t\u0015\t%HF!f\u0001\n\u0003\u0011Y\u000f\u0003\u0006\u0003n2\u0012\t\u0012)A\u0005\u0003OB!B!\u0003-\u0005+\u0007I\u0011\u0001B\u0006\u0011)\u0011i\u0001\fB\tB\u0003%\u0011q\u0011\u0005\u000b\u0005\u001fa#Q3A\u0005\u0002\tE\u0001B\u0003B\nY\tE\t\u0015!\u0003\u0002f\"11\u000f\fC\u0001\u0005_D\u0011B!\t-\u0003\u0003%\tAa?\t\u0013\t-B&%A\u0005\u0002\r\u0015\u0001\"\u0003B\"YE\u0005I\u0011AB\u0005\u0011%\u0011I\u0005LI\u0001\n\u0003\u0011)\u0005C\u0005\u0004\u000e1\n\n\u0011\"\u0001\u0003L!I!q\n\u0017\u0002\u0002\u0013\u0005#\u0011\u000b\u0005\n\u00053b\u0013\u0011!C\u0001\u00057B\u0011B!\u0018-\u0003\u0003%\taa\u0004\t\u0013\t-D&!A\u0005B\t5\u0004\"\u0003B>Y\u0005\u0005I\u0011AB\n\u0011%\u00119\tLA\u0001\n\u0003\u001a9\u0002C\u0005\u0003\u000e2\n\t\u0011\"\u0011\u0003\u0010\"I!\u0011\u0013\u0017\u0002\u0002\u0013\u0005#1\u0013\u0005\n\u0005+c\u0013\u0011!C!\u000779\u0011ba\b\u000f\u0003\u0003E\ta!\t\u0007\u0013\teg\"!A\t\u0002\r\r\u0002BB:F\t\u0003\u0019Y\u0003C\u0005\u0003\u0012\u0016\u000b\t\u0011\"\u0012\u0003\u0014\"I!qW#\u0002\u0002\u0013\u00055Q\u0006\u0005\n\u0005\u0003,\u0015\u0011!CA\u0007oA\u0011B!6F\u0003\u0003%IAa6\u0003O\r{gN\u001a7vK:$(+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014H+[3s'R\fG/Z'bG\"Lg.\u001a\u0006\u0003\u001b:\u000baa]3sm\u0016\u0014(\"A(\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001A\u0015,\u0011\u0005M#V\"\u0001'\n\u0005Uc%\u0001\u0005+jKJ\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f!\t9&,D\u0001Y\u0015\tIf*A\u0003vi&d7/\u0003\u0002\\1\n9Aj\\4hS:<\u0017A\u00027fC\u0012,'\u000f\u0005\u0002_K6\tqL\u0003\u0002NA*\u0011q*\u0019\u0006\u0003E\u000e\fa!\u00199bG\",'\"\u00013\u0002\u0007=\u0014x-\u0003\u0002g?\nqA*Z1eKJ,e\u000e\u001a)pS:$\u0018A\u0003:fa2L7-Y'heB\u00111+[\u0005\u0003U2\u0013aBU3qY&\u001c\u0017-T1oC\u001e,'/\u0001\nfqB|g.\u001a8uS\u0006d')Y2l_\u001a4\u0007CA7r\u001b\u0005q'BA-p\u0015\t\u0001\b-\u0001\u0004d_6lwN\\\u0005\u0003e:\u0014!#\u0012=q_:,g\u000e^5bY\n\u000b7m[8gM\u00061A(\u001b8jiz\"B!\u001e<xqB\u00111\u000b\u0001\u0005\u00069\u0012\u0001\r!\u0018\u0005\u0006O\u0012\u0001\r\u0001\u001b\u0005\u0006W\u0012\u0001\r\u0001\\\u0001\u0006gR\f'\u000f\u001e\u000b\u0007wz\fI!!\u0004\u0011\u0005yc\u0018BA?`\u0005M\u0001\u0016M\u001d;ji&|gNR3uG\"\u001cF/\u0019;f\u0011\u0019yX\u00011\u0001\u0002\u0002\u0005qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0003BA\u0002\u0003\u000bi\u0011a\\\u0005\u0004\u0003\u000fy'A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007\u0003\u0017)\u0001\u0019A>\u0002#\r,(O]3oi\u001a+Go\u00195Ti\u0006$X\rC\u0004\u0002\u0010\u0015\u0001\r!!\u0005\u0002%\u0019,Go\u00195QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\t\u0005\u0003'\t9D\u0004\u0003\u0002\u0016\u0005Eb\u0002BA\f\u0003[qA!!\u0007\u0002,9!\u00111DA\u0015\u001d\u0011\ti\"a\n\u000f\t\u0005}\u0011QE\u0007\u0003\u0003CQ1!a\tQ\u0003\u0019a$o\\8u}%\tA-\u0003\u0002cG&\u0011q*Y\u0005\u0003a\u0002L1!a\fp\u0003\u001diWm]:bO\u0016LA!a\r\u00026\u0005\tb)\u001a;dQJ+7\u000f]8og\u0016$\u0015\r^1\u000b\u0007\u0005=r.\u0003\u0003\u0002:\u0005m\"!\u0004)beRLG/[8o\t\u0006$\u0018M\u0003\u0003\u00024\u0005U\u0012!E7bs\n,\u0017\t\u001a<b]\u000e,7\u000b^1uKR1\u0011\u0011IA)\u0003+\u0002R!a\u0011\u0002Nml!!!\u0012\u000b\t\u0005\u001d\u0013\u0011J\u0001\u0005kRLGN\u0003\u0002\u0002L\u0005!!.\u0019<b\u0013\u0011\ty%!\u0012\u0003\u0011=\u0003H/[8oC2Dq!a\u0015\u0007\u0001\u0004\t\t!\u0001\u0002ua\"1\u00111\u0002\u0004A\u0002m\fq$\\1uKJL\u0017\r\\5{KRKWM]*uCR,WK\u001c;jY>3gm]3u)\u0019\tY&!!\u0002\u0004B1\u0011QLA2\u0003Oj!!a\u0018\u000b\t\u0005\u0005\u0014QI\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA3\u0003?\u0012aAR;ukJ,\u0007\u0003BA5\u0003{j!!a\u001b\u000b\t\u00055\u0014qN\u0001\u0004Y><'\u0002BA9\u0003g\nqa\u001d;pe\u0006<WMC\u0002P\u0003kRA!a\u001e\u0002z\u0005I1m\u001c8gYV,g\u000e\u001e\u0006\u0003\u0003w\n!![8\n\t\u0005}\u00141\u000e\u0002\u000f)&,'\u000fT8h'\u0016<W.\u001a8u\u0011\u0019yx\u00011\u0001\u0002\u0002!9\u0011QQ\u0004A\u0002\u0005\u001d\u0015\u0001\u0004;be\u001e,Go\u00144gg\u0016$\b\u0003BAE\u0003\u001fk!!a#\u000b\u0005\u00055\u0015!B:dC2\f\u0017\u0002BAI\u0003\u0017\u0013A\u0001T8oO\u0006\tS.\u0019;fe&\fG.\u001b>f)&,'o\u0015;bi\u0016,f\u000e^5m\u001f\nTWm\u0019;JIRQ\u00111LAL\u00033\u000bY*!*\t\r}D\u0001\u0019AA\u0001\u0011\u001d\t)\t\u0003a\u0001\u0003\u000fCq!!(\t\u0001\u0004\ty*\u0001\buCJ<W\r^(cU\u0016\u001cG/\u00133\u0011\t\u0005\r\u0013\u0011U\u0005\u0005\u0003G\u000b)E\u0001\u0003V+&#\u0005bBAT\u0011\u0001\u0007\u0011\u0011V\u0001\u0013i\u0006\u0014x-\u001a;SKN$xN]3Fa>\u001c\u0007\u000e\u0005\u0003\u0002\n\u0006-\u0016\u0002BAW\u0003\u0017\u00131!\u00138u\u0003m!(/\u00198tSRLwN\u001c$fi\u000eD\u0017N\\4US\u0016\u00148\u000b^1uKR910a-\u00026\u0006]\u0006BB@\n\u0001\u0004\t\t\u0001\u0003\u0004\u0002\f%\u0001\ra\u001f\u0005\b\u0003sK\u0001\u0019AA^\u0003%!\u0018.\u001a:Ti\u0006$X\rE\u0002\u0002>2r1!a0\u000e\u001d\u0011\t\t-!2\u000f\t\u0005}\u00111Y\u0005\u0002\u001f&\u0011QJT\u0001(\u0007>tg\r\\;f]R\u0014V\r\u001d7jG\u00064U\r^2iKJ$\u0016.\u001a:Ti\u0006$X-T1dQ&tW\r\u0005\u0002T\u001dM\u0019a\"!4\u0011\t\u0005%\u0015qZ\u0005\u0005\u0003#\fYI\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003\u0013\u0014\u0011$T1uKJL\u0017\r\\5{S:<G+[3s\u001b\u0016$\u0018\rZ1uCNI\u0001#!7\u0002f\u0006-\u0018\u0011\u001f\t\u0005\u00037\f\t/\u0004\u0002\u0002^*!\u0011q\\A%\u0003\u0011a\u0017M\\4\n\t\u0005\r\u0018Q\u001c\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007y\u000b9/C\u0002\u0002j~\u0013ABU3qY&\u001c\u0017m\u0015;bi\u0016\u0004B!!#\u0002n&!\u0011q^AF\u0005\u001d\u0001&o\u001c3vGR\u0004B!a=\u0002~:!\u0011Q_A}\u001d\u0011\ty\"a>\n\u0005\u00055\u0015\u0002BA~\u0003\u0017\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0000\n\u0005!\u0001D*fe&\fG.\u001b>bE2,'\u0002BA~\u0003\u0017\u000b\u0001cY8na2,G/[8o'R\fG/^:\u0016\u0005\u0005m\u0013!E2p[BdW\r^5p]N#\u0018\r^;tA\u0005\tB.Z1eKJ\u001cF/\u0019:u\u001f\u001a47/\u001a;\u0016\u0005\u0005\u001d\u0015A\u00057fC\u0012,'o\u0015;beR|eMZ:fi\u0002\nQ\u0002\u001d:fm&|Wo]*uCR,WCAAs\u00039\u0001(/\u001a<j_V\u001c8\u000b^1uK\u0002\"\u0002Ba\u0006\u0003\u001c\tu!q\u0004\t\u0004\u00053\u0001R\"\u0001\b\t\u000f\t\rq\u00031\u0001\u0002\\!9!\u0011B\fA\u0002\u0005\u001d\u0005b\u0002B\b/\u0001\u0007\u0011Q]\u0001\u0005G>\u0004\u0018\u0010\u0006\u0005\u0003\u0018\t\u0015\"q\u0005B\u0015\u0011%\u0011\u0019\u0001\u0007I\u0001\u0002\u0004\tY\u0006C\u0005\u0003\na\u0001\n\u00111\u0001\u0002\b\"I!q\u0002\r\u0011\u0002\u0003\u0007\u0011Q]\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011yC\u000b\u0003\u0002\\\tE2F\u0001B\u001a!\u0011\u0011)Da\u0010\u000e\u0005\t]\"\u0002\u0002B\u001d\u0005w\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\t\tu\u00121R\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B!\u0005o\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"Aa\u0012+\t\u0005\u001d%\u0011G\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011iE\u000b\u0003\u0002f\nE\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003TA!\u00111\u001cB+\u0013\u0011\u00119&!8\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tI+\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\t\u0005$q\r\t\u0005\u0003\u0013\u0013\u0019'\u0003\u0003\u0003f\u0005-%aA!os\"I!\u0011\u000e\u0010\u0002\u0002\u0003\u0007\u0011\u0011V\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t=\u0004C\u0002B9\u0005o\u0012\t'\u0004\u0002\u0003t)!!QOAF\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005s\u0012\u0019H\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B@\u0005\u000b\u0003B!!#\u0003\u0002&!!1QAF\u0005\u001d\u0011un\u001c7fC:D\u0011B!\u001b!\u0003\u0003\u0005\rA!\u0019\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0005'\u0012Y\tC\u0005\u0003j\u0005\n\t\u00111\u0001\u0002*\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002*\u0006AAo\\*ue&tw\r\u0006\u0002\u0003T\u00051Q-];bYN$BAa \u0003\u001a\"I!\u0011\u000e\u0013\u0002\u0002\u0003\u0007!\u0011M\u0001\u001a\u001b\u0006$XM]5bY&T\u0018N\\4US\u0016\u0014X*\u001a;bI\u0006$\u0018\rE\u0002\u0003\u001a\u0019\u001aRA\nBQ\u0005[\u0003BBa)\u0003*\u0006m\u0013qQAs\u0005/i!A!*\u000b\t\t\u001d\u00161R\u0001\beVtG/[7f\u0013\u0011\u0011YK!*\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0005\u0003\u00030\nMVB\u0001BY\u0015\u0011\tY(!\u0013\n\t\u0005}(\u0011\u0017\u000b\u0003\u0005;\u000bQ!\u00199qYf$\u0002Ba\u0006\u0003<\nu&q\u0018\u0005\b\u0005\u0007I\u0003\u0019AA.\u0011\u001d\u0011I!\u000ba\u0001\u0003\u000fCqAa\u0004*\u0001\u0004\t)/A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t\u0015'\u0011\u001b\t\u0007\u0003\u0013\u00139Ma3\n\t\t%\u00171\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0015\u0005%%QZA.\u0003\u000f\u000b)/\u0003\u0003\u0003P\u0006-%A\u0002+va2,7\u0007C\u0005\u0003T*\n\t\u00111\u0001\u0003\u0018\u0005\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005e'!\u0005$fi\u000eD\u0017N\\4US\u0016\u00148\u000b^1uKNIA&!7\u0002f\u0006-\u0018\u0011_\u000b\u0003\u0005?\u0004b!!\u0018\u0002d\t\u0005\b\u0003\u0002Br\u0005Kl!!a\u001c\n\t\t\u001d\u0018q\u000e\u0002\n)&,'o\u0015;bi\u0016\f1\u0002^5feN+w-\\3oiV\u0011\u0011qM\u0001\ri&,'oU3h[\u0016tG\u000f\t\u000b\u000b\u0005c\u0014\u0019P!>\u0003x\ne\bc\u0001B\rY!9!1A\u001bA\u0002\t}\u0007b\u0002Buk\u0001\u0007\u0011q\r\u0005\b\u0005\u0013)\u0004\u0019AAD\u0011\u001d\u0011y!\u000ea\u0001\u0003K$\"B!=\u0003~\n}8\u0011AB\u0002\u0011%\u0011\u0019A\u000eI\u0001\u0002\u0004\u0011y\u000eC\u0005\u0003jZ\u0002\n\u00111\u0001\u0002h!I!\u0011\u0002\u001c\u0011\u0002\u0003\u0007\u0011q\u0011\u0005\n\u0005\u001f1\u0004\u0013!a\u0001\u0003K,\"aa\u0002+\t\t}'\u0011G\u000b\u0003\u0007\u0017QC!a\u001a\u00032\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"D\u0003\u0002B1\u0007#A\u0011B!\u001b>\u0003\u0003\u0005\r!!+\u0015\t\t}4Q\u0003\u0005\n\u0005Sz\u0014\u0011!a\u0001\u0005C\"BAa\u0015\u0004\u001a!I!\u0011\u000e!\u0002\u0002\u0003\u0007\u0011\u0011\u0016\u000b\u0005\u0005\u007f\u001ai\u0002C\u0005\u0003j\r\u000b\t\u00111\u0001\u0003b\u0005\tb)\u001a;dQ&tw\rV5feN#\u0018\r^3\u0011\u0007\teQiE\u0003F\u0007K\u0011i\u000b\u0005\b\u0003$\u000e\u001d\"q\\A4\u0003\u000f\u000b)O!=\n\t\r%\"Q\u0015\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$DCAB\u0011))\u0011\tpa\f\u00042\rM2Q\u0007\u0005\b\u0005\u0007A\u0005\u0019\u0001Bp\u0011\u001d\u0011I\u000f\u0013a\u0001\u0003OBqA!\u0003I\u0001\u0004\t9\tC\u0004\u0003\u0010!\u0003\r!!:\u0015\t\re2\u0011\t\t\u0007\u0003\u0013\u00139ma\u000f\u0011\u0019\u0005%5Q\bBp\u0003O\n9)!:\n\t\r}\u00121\u0012\u0002\u0007)V\u0004H.\u001a\u001b\t\u0013\tM\u0017*!AA\u0002\tE\u0018a\t;sC:\u001c\u0018\u000e^5p]6\u000bG/\u001a:jC2L'0\u001b8h)&,'/T3uC\u0012\fG/\u0019\u000b\bw\u000e\u001d3\u0011JB&\u0011\u0019y(\u00021\u0001\u0002\u0002!1\u00111\u0002\u0006A\u0002mDq!!/\u000b\u0001\u0004\u0019i\u0005E\u0002\u0002>B\t!c\u001c8SKN$xN]3US\u0016\u00148\u000b^1uKRA11KB-\u00077\u001ay\u0006\u0005\u0003\u0002\n\u000eU\u0013\u0002BB,\u0003\u0017\u0013A!\u00168ji\"1qp\u0003a\u0001\u0003\u0003Aqa!\u0018\f\u0001\u0004\t9)A\u000bqe>\u0004xn]3e\u0019>\u001c\u0017\r\u001c'pON#\u0018M\u001d;\t\u000f\u0005e6\u00021\u0001\u0003b\u0006qa-\u001a;dQRKWM]*uCR,GC\u0002Bp\u0007K\u001a9\u0007\u0003\u0004\u0000\u0019\u0001\u0007\u0011\u0011\u0001\u0005\b\u0005Sd\u0001\u0019AA4\u0001")
public class ConfluentReplicaFetcherTierStateMachine
extends TierStateMachine
implements Logging {
    private final LeaderEndPoint leader;
    private final ReplicaManager replicaMgr;
    private final ExponentialBackoff exponentialBackoff;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ConfluentReplicaFetcherTierStateMachine confluentReplicaFetcherTierStateMachine = this;
        synchronized (confluentReplicaFetcherTierStateMachine) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public PartitionFetchState start(TopicPartition topicPartition, PartitionFetchState currentFetchState, FetchResponseData.PartitionData fetchPartitionData) {
        Future<TierLogSegment> future;
        TierOffsetInfo tierOffsetInfo = this.leader.fetchTierMaterializationTarget(topicPartition, currentFetchState.currentLeaderEpoch());
        long leaderStartOffset = tierOffsetInfo.localLogStartOffset();
        if (tierOffsetInfo.tierRestorePoint().isPresent()) {
            TierMaterializationRequirements tierRestorePoint = tierOffsetInfo.tierRestorePoint().get();
            UUID objectId = tierRestorePoint.objectId();
            int restoreEpoch = tierRestorePoint.restoreEpoch();
            Future<TierLogSegment> status = this.materializeTierStateUntilObjectId(topicPartition, leaderStartOffset, objectId, restoreEpoch);
            this.info((Function0<String> & Serializable)() -> "Processed OFFSET_TIERED exception for " + topicPartition + ". Waiting until tier partition state is materialized until objectId " + Utils.uuidToBase64((UUID)objectId));
            future = status;
        } else {
            Future<TierLogSegment> status = this.materializeTierStateUntilOffset(topicPartition, leaderStartOffset - 1L);
            this.info((Function0<String> & Serializable)() -> "Processed OFFSET_TIERED exception for " + topicPartition + ". Waiting until tier partition state is materialized until " + (leaderStartOffset - 1L));
            future = status;
        }
        Future<TierLogSegment> completionStatus = future;
        return new PartitionFetchState(currentFetchState.topicId(), currentFetchState.fetchOffset(), currentFetchState.lag(), currentFetchState.currentLeaderEpoch(), currentFetchState.delay(), new MaterializingTierMetadata(completionStatus, leaderStartOffset, currentFetchState.state()), currentFetchState.lastFetchedEpoch(), currentFetchState.replicationSessionId(), currentFetchState.failedAttempts());
    }

    @Override
    public Optional<PartitionFetchState> maybeAdvanceState(TopicPartition tp, PartitionFetchState currentFetchState) {
        MaterializingTierMetadata materializingTierMetadata;
        FetchingTierState fetchingTierState;
        ReplicaState replicaState = currentFetchState.state();
        if (replicaState instanceof FetchingTierState && (fetchingTierState = (FetchingTierState)replicaState).completionStatus().isDone()) {
            return Optional.of(this.transitionFetchingTierState(tp, currentFetchState, fetchingTierState));
        }
        if (replicaState instanceof MaterializingTierMetadata && (materializingTierMetadata = (MaterializingTierMetadata)replicaState).completionStatus().isDone()) {
            return Optional.of(this.transitionMaterializingTierMetadata(tp, currentFetchState, materializingTierMetadata));
        }
        return Optional.empty();
    }

    public Future<TierLogSegment> materializeTierStateUntilOffset(TopicPartition topicPartition, long targetOffset) {
        AbstractLog log = this.replicaMgr.localLogOrException(topicPartition);
        return log.materializeTierStateUntilOffset(targetOffset);
    }

    public Future<TierLogSegment> materializeTierStateUntilObjectId(TopicPartition topicPartition, long targetOffset, UUID targetObjectId, int targetRestoreEpoch) {
        AbstractLog log = this.replicaMgr.localLogOrException(topicPartition);
        return log.materializeTierStateUntilObjectId(targetOffset, targetObjectId, targetRestoreEpoch);
    }

    private PartitionFetchState transitionFetchingTierState(TopicPartition topicPartition, PartitionFetchState currentFetchState, FetchingTierState tierState) {
        PartitionFetchState partitionFetchState;
        try {
            long leaderStartOffset = tierState.leaderStartOffset();
            long proposedLocalLogStart = tierState.tierSegment().endOffset() + 1L;
            long replicationOffset = package$.MODULE$.max(leaderStartOffset, proposedLocalLogStart);
            this.onRestoreTierState(topicPartition, replicationOffset, tierState.completionStatus().get());
            if (leaderStartOffset > proposedLocalLogStart) {
                this.info((Function0<String> & Serializable)() -> "Tier state " + tierState.tierSegment() + " restored. Resuming replicating from leader's local log start offset " + leaderStartOffset + ".");
            } else {
                this.info((Function0<String> & Serializable)() -> "Tier state " + tierState.tierSegment() + " restored. Resuming replicating from one offset past the materialized end offset " + proposedLocalLogStart);
            }
            partitionFetchState = new PartitionFetchState(currentFetchState.topicId(), replicationOffset, currentFetchState.lag(), currentFetchState.currentLeaderEpoch(), currentFetchState.delay(), ReplicaState.FETCHING, Optional.of(Predef$.MODULE$.int2Integer(tierState.tierSegment().metadata().tierEpoch())), currentFetchState.replicationSessionId(), currentFetchState.failedAttempts());
        }
        catch (ExecutionException ee) {
            this.error((Function0<String> & Serializable)() -> "Exception fetching tier state.", (Function0<Throwable> & Serializable)() -> ee.getCause());
            partitionFetchState = new PartitionFetchState(currentFetchState.topicId(), currentFetchState.fetchOffset(), currentFetchState.lag(), currentFetchState.currentLeaderEpoch(), Optional.of(Predef$.MODULE$.long2Long(this.exponentialBackoff.backoff((long)currentFetchState.failedAttempts()))), ReplicaState.FETCHING, currentFetchState.lastFetchedEpoch(), currentFetchState.replicationSessionId(), currentFetchState.failedAttempts() + 1);
        }
        return partitionFetchState;
    }

    private PartitionFetchState transitionMaterializingTierMetadata(TopicPartition topicPartition, PartitionFetchState currentFetchState, MaterializingTierMetadata tierState) {
        PartitionFetchState partitionFetchState;
        try {
            TierLogSegment tierSegment = tierState.completionStatus().get();
            long leaderStartOffset = tierState.leaderStartOffset();
            Future<TierState> completionStatus = this.fetchTierState(topicPartition, tierSegment);
            this.info((Function0<String> & Serializable)() -> "Restoring tiered state corresponding to " + tierSegment + " for partition " + topicPartition);
            partitionFetchState = new PartitionFetchState(currentFetchState.topicId(), currentFetchState.fetchOffset(), currentFetchState.lag(), currentFetchState.currentLeaderEpoch(), currentFetchState.delay(), new FetchingTierState(completionStatus, tierSegment, leaderStartOffset, currentFetchState.state()), currentFetchState.lastFetchedEpoch(), currentFetchState.replicationSessionId(), currentFetchState.failedAttempts());
        }
        catch (ExecutionException ee) {
            if (ee.getCause() != null && ee.getCause() instanceof TierPartitionStateClosedException) {
                this.info((Function0<String> & Serializable)() -> "Exception completing tier materialization. Retrying initial fetch.", (Function0<Throwable> & Serializable)() -> ee.getCause());
            } else {
                this.warn((Function0<String> & Serializable)() -> "Exception completing tier materialization. Retrying initial fetch.", (Function0<Throwable> & Serializable)() -> ee.getCause());
            }
            partitionFetchState = new PartitionFetchState(currentFetchState.topicId(), currentFetchState.fetchOffset(), currentFetchState.lag(), currentFetchState.currentLeaderEpoch(), Optional.of(Predef$.MODULE$.long2Long(this.exponentialBackoff.backoff((long)currentFetchState.failedAttempts()))), ReplicaState.FETCHING, currentFetchState.lastFetchedEpoch(), currentFetchState.replicationSessionId(), currentFetchState.failedAttempts() + 1);
        }
        return partitionFetchState;
    }

    public void onRestoreTierState(TopicPartition topicPartition, long proposedLocalLogStart, TierState tierState) {
        AbstractLog log = this.replicaMgr.localLogOrException(topicPartition);
        this.debug((Function0<String> & Serializable)() -> "Restoring tier state " + topicPartition + ": " + tierState);
        log.truncateAndRestoreTierState(proposedLocalLogStart, tierState);
    }

    public Future<TierState> fetchTierState(TopicPartition topicPartition, TierLogSegment tierSegment) {
        Partition partition = this.replicaMgr.onlinePartition(topicPartition).get();
        return partition.fetchTierState(tierSegment);
    }

    public ConfluentReplicaFetcherTierStateMachine(LeaderEndPoint leader, ReplicaManager replicaMgr, ExponentialBackoff exponentialBackoff) {
        this.leader = leader;
        this.replicaMgr = replicaMgr;
        this.exponentialBackoff = exponentialBackoff;
        super(leader, replicaMgr, false);
        Logging.$init$(this);
    }

    public static class FetchingTierState
    implements ReplicaState,
    Product,
    Serializable {
        private final Future<TierState> completionStatus;
        private final TierLogSegment tierSegment;
        private final long leaderStartOffset;
        private final ReplicaState previousState;

        @Override
        public Iterator<String> productElementNames() {
            return Product.productElementNames$(this);
        }

        public Future<TierState> completionStatus() {
            return this.completionStatus;
        }

        public TierLogSegment tierSegment() {
            return this.tierSegment;
        }

        public long leaderStartOffset() {
            return this.leaderStartOffset;
        }

        public ReplicaState previousState() {
            return this.previousState;
        }

        public FetchingTierState copy(Future<TierState> completionStatus, TierLogSegment tierSegment, long leaderStartOffset, ReplicaState previousState) {
            return new FetchingTierState(completionStatus, tierSegment, leaderStartOffset, previousState);
        }

        public Future<TierState> copy$default$1() {
            return this.completionStatus();
        }

        public TierLogSegment copy$default$2() {
            return this.tierSegment();
        }

        public long copy$default$3() {
            return this.leaderStartOffset();
        }

        public ReplicaState copy$default$4() {
            return this.previousState();
        }

        @Override
        public String productPrefix() {
            return "FetchingTierState";
        }

        @Override
        public int productArity() {
            return 4;
        }

        @Override
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.completionStatus();
                }
                case 1: {
                    return this.tierSegment();
                }
                case 2: {
                    return BoxesRunTime.boxToLong(this.leaderStartOffset());
                }
                case 3: {
                    return this.previousState();
                }
            }
            return Statics.ioobe(x$1);
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof FetchingTierState;
        }

        @Override
        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "completionStatus";
                }
                case 1: {
                    return "tierSegment";
                }
                case 2: {
                    return "leaderStartOffset";
                }
                case 3: {
                    return "previousState";
                }
            }
            return (String)Statics.ioobe(x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.completionStatus()));
            n = Statics.mix(n, Statics.anyHash(this.tierSegment()));
            n = Statics.mix(n, Statics.longHash(this.leaderStartOffset()));
            n = Statics.mix(n, Statics.anyHash(this.previousState()));
            return Statics.finalizeHash(n, 4);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FetchingTierState)) return false;
            boolean bl = true;
            if (!bl) return false;
            FetchingTierState fetchingTierState = (FetchingTierState)x$1;
            if (this.leaderStartOffset() != fetchingTierState.leaderStartOffset()) return false;
            Future<TierState> future = this.completionStatus();
            Future<TierState> future2 = fetchingTierState.completionStatus();
            if (future == null) {
                if (future2 != null) {
                    return false;
                }
            } else if (!future.equals(future2)) return false;
            TierLogSegment tierLogSegment = this.tierSegment();
            TierLogSegment tierLogSegment2 = fetchingTierState.tierSegment();
            if (tierLogSegment == null) {
                if (tierLogSegment2 != null) {
                    return false;
                }
            } else if (!((Object)tierLogSegment).equals(tierLogSegment2)) return false;
            ReplicaState replicaState = this.previousState();
            ReplicaState replicaState2 = fetchingTierState.previousState();
            if (replicaState == null) {
                if (replicaState2 != null) {
                    return false;
                }
            } else if (!replicaState.equals(replicaState2)) return false;
            if (!fetchingTierState.canEqual(this)) return false;
            return true;
        }

        public FetchingTierState(Future<TierState> completionStatus, TierLogSegment tierSegment, long leaderStartOffset, ReplicaState previousState) {
            this.completionStatus = completionStatus;
            this.tierSegment = tierSegment;
            this.leaderStartOffset = leaderStartOffset;
            this.previousState = previousState;
            Product.$init$(this);
        }
    }

    public static class MaterializingTierMetadata
    implements ReplicaState,
    Product,
    Serializable {
        private final Future<TierLogSegment> completionStatus;
        private final long leaderStartOffset;
        private final ReplicaState previousState;

        @Override
        public Iterator<String> productElementNames() {
            return Product.productElementNames$(this);
        }

        public Future<TierLogSegment> completionStatus() {
            return this.completionStatus;
        }

        public long leaderStartOffset() {
            return this.leaderStartOffset;
        }

        public ReplicaState previousState() {
            return this.previousState;
        }

        public MaterializingTierMetadata copy(Future<TierLogSegment> completionStatus, long leaderStartOffset, ReplicaState previousState) {
            return new MaterializingTierMetadata(completionStatus, leaderStartOffset, previousState);
        }

        public Future<TierLogSegment> copy$default$1() {
            return this.completionStatus();
        }

        public long copy$default$2() {
            return this.leaderStartOffset();
        }

        public ReplicaState copy$default$3() {
            return this.previousState();
        }

        @Override
        public String productPrefix() {
            return "MaterializingTierMetadata";
        }

        @Override
        public int productArity() {
            return 3;
        }

        @Override
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.completionStatus();
                }
                case 1: {
                    return BoxesRunTime.boxToLong(this.leaderStartOffset());
                }
                case 2: {
                    return this.previousState();
                }
            }
            return Statics.ioobe(x$1);
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof MaterializingTierMetadata;
        }

        @Override
        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "completionStatus";
                }
                case 1: {
                    return "leaderStartOffset";
                }
                case 2: {
                    return "previousState";
                }
            }
            return (String)Statics.ioobe(x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.completionStatus()));
            n = Statics.mix(n, Statics.longHash(this.leaderStartOffset()));
            n = Statics.mix(n, Statics.anyHash(this.previousState()));
            return Statics.finalizeHash(n, 3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MaterializingTierMetadata)) return false;
            boolean bl = true;
            if (!bl) return false;
            MaterializingTierMetadata materializingTierMetadata = (MaterializingTierMetadata)x$1;
            if (this.leaderStartOffset() != materializingTierMetadata.leaderStartOffset()) return false;
            Future<TierLogSegment> future = this.completionStatus();
            Future<TierLogSegment> future2 = materializingTierMetadata.completionStatus();
            if (future == null) {
                if (future2 != null) {
                    return false;
                }
            } else if (!future.equals(future2)) return false;
            ReplicaState replicaState = this.previousState();
            ReplicaState replicaState2 = materializingTierMetadata.previousState();
            if (replicaState == null) {
                if (replicaState2 != null) {
                    return false;
                }
            } else if (!replicaState.equals(replicaState2)) return false;
            if (!materializingTierMetadata.canEqual(this)) return false;
            return true;
        }

        public MaterializingTierMetadata(Future<TierLogSegment> completionStatus, long leaderStartOffset, ReplicaState previousState) {
            this.completionStatus = completionStatus;
            this.leaderStartOffset = leaderStartOffset;
            this.previousState = previousState;
            Product.$init$(this);
        }
    }
}

