/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.server.AutoTopicCreationManager;
import kafka.server.AutoTopicCreationManager$;
import kafka.server.ControllerMutationQuota;
import kafka.server.ForwardingManager$;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.coordinator.share.ShareCoordinator;
import org.apache.kafka.coordinator.transaction.TransactionLogConfig;
import org.apache.kafka.server.common.ControllerRequestCompletionHandler;
import org.apache.kafka.server.common.NodeToControllerChannelManager;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0005\u0005Ee\u0001\u0002\t\u0012\u0001YA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!A\u0001\b\u0001B\u0001B\u0003%\u0011\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011!I\u0005A!A!\u0002\u0013Q\u0005\"\u0002)\u0001\t\u0003\t\u0006b\u0002-\u0001\u0005\u0004%I!\u0017\u0005\u0007[\u0002\u0001\u000b\u0011\u0002.\t\u000b9\u0004A\u0011I8\t\u000f\u0005u\u0002\u0001\"\u0011\u0002@!9\u0011\u0011\r\u0001\u0005\n\u0005\r\u0004bBA6\u0001\u0011%\u0011Q\u000e\u0005\b\u0003c\u0002A\u0011BA:\u0011\u001d\tI\b\u0001C\u0005\u0003wBq!!\"\u0001\t\u0013\t9IA\u0010EK\u001a\fW\u000f\u001c;BkR|Gk\u001c9jG\u000e\u0013X-\u0019;j_:l\u0015M\\1hKJT!AE\n\u0002\rM,'O^3s\u0015\u0005!\u0012!B6bM.\f7\u0001A\n\u0005\u0001]i\u0012\u0005\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VM\u001a\t\u0003=}i\u0011!E\u0005\u0003AE\u0011\u0001$Q;u_R{\u0007/[2De\u0016\fG/[8o\u001b\u0006t\u0017mZ3s!\t\u0011S%D\u0001$\u0015\t!3#A\u0003vi&d7/\u0003\u0002'G\t9Aj\\4hS:<\u0017AB2p]\u001aLw\r\u0005\u0002\u001fS%\u0011!&\u0005\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\bdQ\u0006tg.\u001a7NC:\fw-\u001a:\u0011\u000552T\"\u0001\u0018\u000b\u0005=\u0002\u0014AB2p[6|gN\u0003\u0002\u0013c)\u0011AC\r\u0006\u0003gQ\na!\u00199bG\",'\"A\u001b\u0002\u0007=\u0014x-\u0003\u00028]\tqbj\u001c3f)>\u001cuN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM]\u0001\u0011OJ|W\u000f]\"p_J$\u0017N\\1u_J\u0004\"AO \u000e\u0003mR!\u0001P\u001f\u0002\u000b\u001d\u0014x.\u001e9\u000b\u0005y\n\u0014aC2p_J$\u0017N\\1u_JL!\u0001Q\u001e\u0003!\u001d\u0013x.\u001e9D_>\u0014H-\u001b8bi>\u0014\u0018A\u0004;y]\u000e{wN\u001d3j]\u0006$xN\u001d\t\u0003\u0007\u001ek\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000b1\u0002\u001e:b]N\f7\r^5p]*\u0011ahE\u0005\u0003\u0011\u0012\u0013a\u0003\u0016:b]N\f7\r^5p]\u000e{wN\u001d3j]\u0006$xN]\u0001\u0011g\"\f'/Z\"p_J$\u0017N\\1u_J\u0004\"a\u0013(\u000e\u00031S!!T\u001f\u0002\u000bMD\u0017M]3\n\u0005=c%\u0001E*iCJ,7i\\8sI&t\u0017\r^8s\u0003\u0019a\u0014N\\5u}Q1!k\u0015+V-^\u0003\"A\b\u0001\t\u000b\u001d2\u0001\u0019\u0001\u0015\t\u000b-2\u0001\u0019\u0001\u0017\t\u000ba2\u0001\u0019A\u001d\t\u000b\u00053\u0001\u0019\u0001\"\t\u000b%3\u0001\u0019\u0001&\u0002\u001d%tg\r\\5hQR$v\u000e]5dgV\t!\fE\u0002\\A\nl\u0011\u0001\u0018\u0006\u0003;z\u000bA!\u001e;jY*\tq,\u0001\u0003kCZ\f\u0017BA1]\u0005\r\u0019V\r\u001e\t\u0003G*t!\u0001\u001a5\u0011\u0005\u0015LR\"\u00014\u000b\u0005\u001d,\u0012A\u0002\u001fs_>$h(\u0003\u0002j3\u00051\u0001K]3eK\u001aL!a\u001b7\u0003\rM#(/\u001b8h\u0015\tI\u0017$A\bj]\u001ad\u0017n\u001a5u)>\u0004\u0018nY:!\u00031\u0019'/Z1uKR{\u0007/[2t)\u001d\u0001\u0018QCA\u000f\u0003O\u00012!\u001d;w\u001b\u0005\u0011(BA:\u001a\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003kJ\u00141aU3r!\r9\u0018q\u0002\b\u0004q\u0006%abA=\u0002\u00049\u0019!0!\u0001\u000f\u0005m|hB\u0001?\u007f\u001d\t)W0C\u00016\u0013\t\u0019D'\u0003\u0002\u0015e%\u0011q&M\u0005\u0005\u0003\u000b\t9!A\u0004nKN\u001c\u0018mZ3\u000b\u0005=\n\u0014\u0002BA\u0006\u0003\u001b\tA#T3uC\u0012\fG/\u0019*fgB|gn]3ECR\f'\u0002BA\u0003\u0003\u000fIA!!\u0005\u0002\u0014\t)R*\u001a;bI\u0006$\u0018MU3ta>t7/\u001a+pa&\u001c'\u0002BA\u0006\u0003\u001bAq!a\u0006\n\u0001\u0004\tI\"\u0001\u0004u_BL7m\u001d\t\u0005c\u0006m!-\u0003\u0002be\"9\u0011qD\u0005A\u0002\u0005\u0005\u0012aF2p]R\u0014x\u000e\u001c7fe6+H/\u0019;j_:\fVo\u001c;b!\rq\u00121E\u0005\u0004\u0003K\t\"aF\"p]R\u0014x\u000e\u001c7fe6+H/\u0019;j_:\fVo\u001c;b\u0011\u001d\tI#\u0003a\u0001\u0003W\ta#\\3uC\u0012\fG/\u0019*fcV,7\u000f^\"p]R,\u0007\u0010\u001e\t\u00061\u00055\u0012\u0011G\u0005\u0004\u0003_I\"AB(qi&|g\u000e\u0005\u0003\u00024\u0005eRBAA\u001b\u0015\u0011\t9$a\u0002\u0002\u0011I,\u0017/^3tiNLA!a\u000f\u00026\tq!+Z9vKN$8i\u001c8uKb$\u0018aG2sK\u0006$Xm\u0015;sK\u0006l7/\u00138uKJt\u0017\r\u001c+pa&\u001c7\u000f\u0006\u0004\u0002B\u0005\u001d\u0013Q\f\t\u00041\u0005\r\u0013bAA#3\t!QK\\5u\u0011\u001d\t9B\u0003a\u0001\u0003\u0013\u0002b!]A&E\u0006=\u0013bAA'e\n\u0019Q*\u00199\u0011\t\u0005E\u0013q\u000b\b\u0004q\u0006M\u0013\u0002BA+\u0003\u001b\tqc\u0011:fCR,Gk\u001c9jGN\u0014V-];fgR$\u0015\r^1\n\t\u0005e\u00131\f\u0002\u000f\u0007J,\u0017\r^1cY\u0016$v\u000e]5d\u0015\u0011\t)&!\u0004\t\u000f\u0005}#\u00021\u0001\u00022\u0005q!/Z9vKN$8i\u001c8uKb$\u0018AF:f]\u0012\u001c%/Z1uKR{\u0007/[2SKF,Xm\u001d;\u0015\u000bA\f)'!\u001b\t\u000f\u0005\u001d4\u00021\u0001\u0002J\u0005y1M]3bi\u0006\u0014G.\u001a+pa&\u001c7\u000fC\u0004\u0002`-\u0001\r!a\u000b\u0002+\rdW-\u0019:J]\u001ad\u0017n\u001a5u%\u0016\fX/Z:ugR!\u0011\u0011IA8\u0011\u001d\t9\u0007\u0004a\u0001\u0003\u0013\nab\u0019:fCR\f'\r\\3U_BL7\r\u0006\u0003\u0002P\u0005U\u0004BBA<\u001b\u0001\u0007!-A\u0003u_BL7-\u0001\tjgZ\u000bG.\u001b3U_BL7MT1nKR!\u0011QPAB!\rA\u0012qP\u0005\u0004\u0003\u0003K\"a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003or\u0001\u0019\u00012\u0002+\u0019LG\u000e^3s\u0007J,\u0017\r^1cY\u0016$v\u000e]5dgR!\u0011\u0011RAH!\u0019A\u00121RA%a&\u0019\u0011QR\r\u0003\rQ+\b\u000f\\33\u0011\u001d\t9b\u0004a\u0001\u00033\u0001")
public class DefaultAutoTopicCreationManager
implements AutoTopicCreationManager,
Logging {
    private final KafkaConfig config;
    private final NodeToControllerChannelManager channelManager;
    private final GroupCoordinator groupCoordinator;
    private final TransactionCoordinator txnCoordinator;
    private final ShareCoordinator shareCoordinator;
    private final java.util.Set<String> inflightTopics;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        DefaultAutoTopicCreationManager defaultAutoTopicCreationManager = this;
        synchronized (defaultAutoTopicCreationManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private java.util.Set<String> inflightTopics() {
        return this.inflightTopics;
    }

    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> createTopics(Set<String> topics, ControllerMutationQuota controllerMutationQuota, Option<RequestContext> metadataRequestContext) {
        Tuple2<Map<String, CreateTopicsRequestData.CreatableTopic>, Seq<MetadataResponseData.MetadataResponseTopic>> tuple2 = this.filterCreatableTopics(topics);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics = tuple2._1();
        Seq<MetadataResponseData.MetadataResponseTopic> uncreatableTopicResponses = tuple2._2();
        Tuple2<Map<String, CreateTopicsRequestData.CreatableTopic>, Seq<MetadataResponseData.MetadataResponseTopic>> tuple22 = new Tuple2<Map<String, CreateTopicsRequestData.CreatableTopic>, Seq<MetadataResponseData.MetadataResponseTopic>>(creatableTopics, uncreatableTopicResponses);
        Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics2 = tuple22._1();
        Seq<MetadataResponseData.MetadataResponseTopic> uncreatableTopicResponses2 = tuple22._2();
        Seq<MetadataResponseData.MetadataResponseTopic> creatableTopicResponses = creatableTopics2.isEmpty() ? (Seq<MetadataResponseData.MetadataResponseTopic>)Seq$.MODULE$.empty() : this.sendCreateTopicRequest(creatableTopics2, metadataRequestContext);
        return (Seq)uncreatableTopicResponses2.$plus$plus(creatableTopicResponses);
    }

    @Override
    public void createStreamsInternalTopics(Map<String, CreateTopicsRequestData.CreatableTopic> topics, RequestContext requestContext) {
        topics.withFilter((Function1<Tuple2<String, CreateTopicsRequestData.CreatableTopic>, Object>)(Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(DefaultAutoTopicCreationManager.$anonfun$createStreamsInternalTopics$1(check$ifrefutable$1))).foreach((Function1<Tuple2, Object> & Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 != null) {
                CreateTopicsRequestData.CreatableTopic creatableTopic = (CreateTopicsRequestData.CreatableTopic)tuple2._2();
                BoxedUnit boxedUnit = creatableTopic.numPartitions() == -1 ? creatableTopic.setNumPartitions(Predef$.MODULE$.Integer2int($this.config.numPartitions())) : BoxedUnit.UNIT;
                if (creatableTopic.replicationFactor() == -1) {
                    return creatableTopic.setReplicationFactor((short)$this.config.defaultReplicationFactor());
                }
                return BoxedUnit.UNIT;
            }
            throw new MatchError(tuple2);
        });
        if (topics.nonEmpty()) {
            this.sendCreateTopicRequest(topics, new Some<RequestContext>(requestContext));
            return;
        }
    }

    private Seq<MetadataResponseData.MetadataResponseTopic> sendCreateTopicRequest(Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics, Option<RequestContext> requestContext) {
        CreateTopicsRequestData.CreatableTopicCollection topicsToCreate = new CreateTopicsRequestData.CreatableTopicCollection(creatableTopics.size());
        topicsToCreate.addAll(CollectionConverters$.MODULE$.IterableHasAsJava(creatableTopics.values()).asJavaCollection());
        CreateTopicsRequest.Builder createTopicsRequest = new CreateTopicsRequest.Builder(new CreateTopicsRequestData().setTimeoutMs(this.config.requestTimeoutMs()).setTopics(topicsToCreate));
        ControllerRequestCompletionHandler requestCompletionHandler = new ControllerRequestCompletionHandler(this, creatableTopics){
            private final /* synthetic */ DefaultAutoTopicCreationManager $outer;
            private final Map creatableTopics$1;

            public void onTimeout() {
                this.$outer.kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests(this.creatableTopics$1);
                this.$outer.debug((Function0<String> & Serializable)() -> "Auto topic creation timed out for " + $this.creatableTopics$1.keys() + ".");
            }

            public void onComplete(ClientResponse response) {
                this.$outer.kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests(this.creatableTopics$1);
                if (response.authenticationException() != null) {
                    this.$outer.warn((Function0<String> & Serializable)() -> "Auto topic creation failed for " + $this.creatableTopics$1.keys() + " with authentication exception");
                    return;
                }
                if (response.versionMismatch() != null) {
                    this.$outer.warn((Function0<String> & Serializable)() -> "Auto topic creation failed for " + $this.creatableTopics$1.keys() + " with invalid version exception");
                    return;
                }
                this.$outer.debug((Function0<String> & Serializable)() -> "Auto topic creation completed for " + $this.creatableTopics$1.keys() + " with response " + response.responseBody() + ".");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.creatableTopics$1 = creatableTopics$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$1(kafka.server.DefaultAutoTopicCreationManager$$anon$1 ), $anonfun$onComplete$2(kafka.server.DefaultAutoTopicCreationManager$$anon$1 ), $anonfun$onComplete$3(kafka.server.DefaultAutoTopicCreationManager$$anon$1 org.apache.kafka.clients.ClientResponse ), $anonfun$onTimeout$1(kafka.server.DefaultAutoTopicCreationManager$$anon$1 )}, serializedLambda);
            }
        };
        AbstractRequest.Builder request = (AbstractRequest.Builder)requestContext.map((Function1<RequestContext, EnvelopeRequest.Builder> & Serializable)context -> {
            short s;
            Option<NodeApiVersions> option = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional($this.channelManager.controllerApiVersions()));
            if (None$.MODULE$.equals(option)) {
                s = ApiKeys.CREATE_TOPICS.latestVersion();
            } else if (option instanceof Some) {
                Some some = (Some)option;
                NodeApiVersions nodeApiVersions = (NodeApiVersions)some.value();
                s = nodeApiVersions.latestUsableVersion(ApiKeys.CREATE_TOPICS);
            } else {
                throw new MatchError(option);
            }
            short requestVersion = s;
            RequestHeader requestHeader = new RequestHeader(ApiKeys.CREATE_TOPICS, requestVersion, context.clientId(), context.correlationId());
            return ForwardingManager$.MODULE$.buildEnvelopeRequest((RequestContext)context, createTopicsRequest.build(requestVersion).serializeWithHeader(requestHeader));
        }).getOrElse((Function0<CreateTopicsRequest.Builder> & Serializable)() -> createTopicsRequest);
        this.channelManager.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)request, requestCompletionHandler);
        scala.collection.immutable.Seq creatableTopicResponses = (scala.collection.immutable.Seq)creatableTopics.keySet().toSeq().map((Function1<String, MetadataResponseData.MetadataResponseTopic> & Serializable)topic -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic)));
        this.info((Function0<String> & Serializable)() -> "Sent auto-creation request for " + creatableTopics.keys() + " to the active controller.");
        return creatableTopicResponses;
    }

    public void kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests(Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics) {
        creatableTopics.keySet().foreach((Function1<Object, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(DefaultAutoTopicCreationManager.$anonfun$clearInflightRequests$1(this, x$1)));
        this.debug((Function0<String> & Serializable)() -> "Cleared inflight topic creation state for " + creatableTopics);
    }

    private CreateTopicsRequestData.CreatableTopic creatableTopic(String topic) {
        String string = topic;
        switch (string == null ? 0 : string.hashCode()) {
            case -970371369: {
                if (!"__consumer_offsets".equals(string)) break;
                Properties groupMetadataTopicConfigs = this.groupCoordinator.groupMetadataTopicConfigs();
                String topicPlacementConstraints = groupMetadataTopicConfigs.getProperty("confluent.placement.constraints", "");
                short replicationFactor = topicPlacementConstraints.isEmpty() ? (short)this.config.groupCoordinatorConfig().offsetsTopicReplicationFactor() : (short)-1;
                return new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(this.config.groupCoordinatorConfig().offsetsTopicPartitions()).setReplicationFactor(replicationFactor).setConfigs(AutoTopicCreationManager$.MODULE$.convertToTopicConfigCollections(this.groupCoordinator.groupMetadataTopicConfigs()));
            }
            case -253293552: {
                if (!"__transaction_state".equals(string)) break;
                TransactionLogConfig transactionLogConfig = new TransactionLogConfig(this.config);
                String topicPlacementConstraints = this.txnCoordinator.placementConstraints();
                short replicationFactor = topicPlacementConstraints == null || topicPlacementConstraints.isEmpty() ? transactionLogConfig.transactionTopicReplicationFactor() : (short)-1;
                return new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(transactionLogConfig.transactionTopicPartitions()).setReplicationFactor(replicationFactor).setConfigs(AutoTopicCreationManager$.MODULE$.convertToTopicConfigCollections(this.txnCoordinator.transactionTopicConfigs()));
            }
            case -81655151: {
                if (!"__share_group_state".equals(string)) break;
                return new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(this.config.shareCoordinatorConfig().shareCoordinatorStateTopicNumPartitions()).setReplicationFactor(this.config.shareCoordinatorConfig().shareCoordinatorStateTopicReplicationFactor()).setConfigs(AutoTopicCreationManager$.MODULE$.convertToTopicConfigCollections(this.shareCoordinator.shareGroupStateTopicConfigs()));
            }
        }
        return new CreateTopicsRequestData.CreatableTopic().setName(string).setNumPartitions(Predef$.MODULE$.Integer2int(this.config.numPartitions())).setReplicationFactor((short)this.config.defaultReplicationFactor());
    }

    private boolean isValidTopicName(String topic) {
        boolean bl;
        try {
            Topic.validate((String)topic);
            bl = true;
        }
        catch (InvalidTopicException invalidTopicException) {
            bl = false;
        }
        return bl;
    }

    private Tuple2<Map<String, CreateTopicsRequestData.CreatableTopic>, Seq<MetadataResponseData.MetadataResponseTopic>> filterCreatableTopics(Set<String> topics) {
        scala.collection.mutable.Map creatableTopics = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        Buffer uncreatableTopics = (Buffer)Buffer$.MODULE$.empty();
        topics.foreach((Function1<String, Object> & Serializable)topic -> {
            Option validationError = !this.isValidTopicName((String)topic) ? new Some<Errors>(Errors.INVALID_TOPIC_EXCEPTION) : (!this.inflightTopics().add((String)topic) ? new Some<Errors>(Errors.UNKNOWN_TOPIC_OR_PARTITION) : None$.MODULE$);
            Some<Errors> some = validationError;
            if (some instanceof Some) {
                Some<Errors> some2 = some;
                Errors error = some2.value();
                return uncreatableTopics.$plus$eq(new MetadataResponseData.MetadataResponseTopic().setErrorCode(error.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic)));
            }
            if (None$.MODULE$.equals(some)) {
                return creatableTopics.put(topic, this.creatableTopic((String)topic));
            }
            throw new MatchError(some);
        });
        return new Tuple2<Map<String, CreateTopicsRequestData.CreatableTopic>, Seq<MetadataResponseData.MetadataResponseTopic>>(creatableTopics, uncreatableTopics);
    }

    public static final /* synthetic */ boolean $anonfun$createStreamsInternalTopics$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$clearInflightRequests$1(DefaultAutoTopicCreationManager $this, Object x$1) {
        return $this.inflightTopics().remove(x$1);
    }

    public DefaultAutoTopicCreationManager(KafkaConfig config, NodeToControllerChannelManager channelManager, GroupCoordinator groupCoordinator, TransactionCoordinator txnCoordinator, ShareCoordinator shareCoordinator) {
        this.config = config;
        this.channelManager = channelManager;
        this.groupCoordinator = groupCoordinator;
        this.txnCoordinator = txnCoordinator;
        this.shareCoordinator = shareCoordinator;
        Logging.$init$(this);
        this.inflightTopics = Collections.newSetFromMap(new ConcurrentHashMap());
    }
}

