/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import kafka.cluster.Partition;
import kafka.server.DelayedProduce$;
import kafka.server.DelayedProduceMetrics$;
import kafka.server.ProduceMetadata;
import kafka.server.ProducePartitionStatus;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.server.purgatory.DelayedOperation;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u00055r!\u0002\t\u0012\u0011\u00031b!\u0002\r\u0012\u0011\u0003I\u0002\"\u0002\u0011\u0002\t\u0003\t\u0003b\u0002\u0012\u0002\u0005\u0004%ia\t\u0005\u0007]\u0005\u0001\u000bQ\u0002\u0013\u0007\ta\t\u0002a\f\u0005\t\u0005\u0016\u0011\t\u0011)A\u0005\u0007\"Aa)\u0002B\u0001B\u0003%q\t\u0003\u0005K\u000b\t\u0005\t\u0015!\u0003L\u0011!qUA!A!\u0002\u0013y\u0005\u0002C<\u0006\u0005\u0003\u0005\u000b\u0011\u0002=\t\r\u0001*A\u0011AA\b\u0011!\u0011S\u0001#b\u0001\n\u0003\u001a\u0003bBA\u000f\u000b\u0011\u0005\u0013q\u0004\u0005\b\u0003O)A\u0011IA\u0015\u0011\u001d\tY#\u0002C!\u0003S\ta\u0002R3mCf,G\r\u0015:pIV\u001cWM\u0003\u0002\u0013'\u000511/\u001a:wKJT\u0011\u0001F\u0001\u0006W\u000647.Y\u0002\u0001!\t9\u0012!D\u0001\u0012\u00059!U\r\\1zK\u0012\u0004&o\u001c3vG\u0016\u001c\"!\u0001\u000e\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta#\u0001\u0004m_\u001e<WM]\u000b\u0002IA\u0011Q\u0005L\u0007\u0002M)\u0011q\u0005K\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003S)\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002W\u0005\u00191m\\7\n\u000552#A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0014\u0007\u0015\u0001D\b\u0005\u00022u5\t!G\u0003\u00024i\u0005I\u0001/\u001e:hCR|'/\u001f\u0006\u0003%UR!\u0001\u0006\u001c\u000b\u0005]B\u0014AB1qC\u000eDWMC\u0001:\u0003\ry'oZ\u0005\u0003wI\u0012\u0001\u0003R3mCf,Gm\u00149fe\u0006$\u0018n\u001c8\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}\u001a\u0012!B;uS2\u001c\u0018BA!?\u0005\u001daunZ4j]\u001e\fq\u0001Z3mCfl5\u000f\u0005\u0002\u001c\t&\u0011Q\t\b\u0002\u0005\u0019>tw-A\bqe>$WoY3NKR\fG-\u0019;b!\t9\u0002*\u0003\u0002J#\ty\u0001K]8ek\u000e,W*\u001a;bI\u0006$\u0018-\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\u0005]a\u0015BA'\u0012\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\f\u0001C]3ta>t7/Z\"bY2\u0014\u0017mY6\u0011\tm\u0001&\u000b^\u0005\u0003#r\u0011\u0011BR;oGRLwN\\\u0019\u0011\tM3\u0006LX\u0007\u0002)*\u0011Q\u000bH\u0001\u000bG>dG.Z2uS>t\u0017BA,U\u0005\ri\u0015\r\u001d\t\u00033rk\u0011A\u0017\u0006\u00037V\naaY8n[>t\u0017BA/[\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002`c:\u0011\u0001M\u001c\b\u0003C2t!AY6\u000f\u0005\rTgB\u00013j\u001d\t)\u0007.D\u0001g\u0015\t9W#\u0001\u0004=e>|GOP\u0005\u0002s%\u0011q\u0007O\u0005\u0003)YJ!aW\u001b\n\u00055T\u0016\u0001\u0003:fcV,7\u000f^:\n\u0005=\u0004\u0018a\u0004)s_\u0012,8-\u001a*fgB|gn]3\u000b\u00055T\u0016B\u0001:t\u0005E\u0001\u0016M\u001d;ji&|gNU3ta>t7/\u001a\u0006\u0003_B\u0004\"aG;\n\u0005Yd\"\u0001B+oSR\fq\u0001\\8dW>\u0003H\u000fE\u0002\u001csnL!A\u001f\u000f\u0003\r=\u0003H/[8o!\ra\u00181B\u0007\u0002{*\u0011ap`\u0001\u0006Y>\u001c7n\u001d\u0006\u0005\u0003\u0003\t\u0019!\u0001\u0006d_:\u001cWO\u001d:f]RTA!!\u0002\u0002\b\u0005!Q\u000f^5m\u0015\t\tI!\u0001\u0003kCZ\f\u0017bAA\u0007{\n!Aj\\2l)1\t\t\"a\u0005\u0002\u0016\u0005]\u0011\u0011DA\u000e!\t9R\u0001C\u0003C\u0017\u0001\u00071\tC\u0003G\u0017\u0001\u0007q\tC\u0003K\u0017\u0001\u00071\nC\u0003O\u0017\u0001\u0007q\nC\u0003x\u0017\u0001\u0007\u00010A\u0006uef\u001cu.\u001c9mKR,GCAA\u0011!\rY\u00121E\u0005\u0004\u0003Ka\"a\u0002\"p_2,\u0017M\\\u0001\r_:,\u0005\u0010]5sCRLwN\u001c\u000b\u0002i\u0006QqN\\\"p[BdW\r^3")
public class DelayedProduce
extends DelayedOperation
implements Logging {
    private Logger logger;
    private final ProduceMetadata produceMetadata;
    private final ReplicaManager replicaManager;
    private final Function1<Map<TopicIdPartition, ProduceResponse.PartitionResponse>, BoxedUnit> responseCallback;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Logger logger$lzycompute() {
        DelayedProduce delayedProduce = this;
        synchronized (delayedProduce) {
            if (!this.bitmap$0) {
                this.logger = DelayedProduce$.MODULE$.kafka$server$DelayedProduce$$logger();
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public boolean tryComplete() {
        this.produceMetadata.produceStatus().foreachEntry((Function2<TopicIdPartition, ProducePartitionStatus, Object> & Serializable)(topicIdPartition, status) -> {
            DelayedProduce.$anonfun$tryComplete$1(this, topicIdPartition, status);
            return BoxedUnit.UNIT;
        });
        if (!this.produceMetadata.produceStatus().values().exists((Function1<ProducePartitionStatus, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(x$2.acksPending()))) {
            return this.forceComplete();
        }
        return false;
    }

    @Override
    public void onExpiration() {
        this.produceMetadata.produceStatus().foreachEntry((Function2<TopicIdPartition, ProducePartitionStatus, Object> & Serializable)(topicIdPartition, status) -> {
            DelayedProduce.$anonfun$onExpiration$1(this, topicIdPartition, status);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void onComplete() {
        Map responseStatus = (Map)this.produceMetadata.produceStatus().map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicIdPartition k = (TopicIdPartition)tuple2._1();
                ProducePartitionStatus status = (ProducePartitionStatus)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(k), status.responseStatus());
            }
            throw new MatchError(tuple2);
        });
        this.responseCallback.apply(responseStatus);
    }

    public static final /* synthetic */ void $anonfun$new$1(DelayedProduce $this, TopicIdPartition topicPartition, ProducePartitionStatus status) {
        Errors errors = status.responseStatus().error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            status.acksPending_$eq(true);
            status.responseStatus().error = Errors.REQUEST_TIMED_OUT;
        } else {
            status.acksPending_$eq(false);
        }
        $this.trace((Function0<String> & Serializable)() -> "Initial partition status for " + topicPartition + " is " + status);
    }

    public static final /* synthetic */ void $anonfun$tryComplete$1(DelayedProduce $this, TopicIdPartition topicIdPartition, ProducePartitionStatus status) {
        $this.trace((Function0<String> & Serializable)() -> "Checking produce satisfaction for " + topicIdPartition + ", current status " + status);
        if (status.acksPending()) {
            Errors error;
            Tuple2<Object, Errors> tuple2;
            Either<Errors, Partition> either = $this.replicaManager.getPartitionOrError(topicIdPartition.topicPartition());
            if (either instanceof Left) {
                Left left = (Left)either;
                Errors err = (Errors)left.value();
                tuple2 = new Tuple2<Boolean, Errors>(BoxesRunTime.boxToBoolean(false), err);
            } else if (either instanceof Right) {
                Right right = (Right)either;
                Partition partition = (Partition)right.value();
                boolean checkAcksEqualToOneReplication = $this.replicaManager.isAcksEqualToOneRequestReplicationFeatureEnabled() && $this.produceMetadata.produceRequiredAcks() == 1;
                tuple2 = partition.checkEnoughReplicasReachOffset(status.requiredOffset(), checkAcksEqualToOneReplication);
            } else {
                throw new MatchError(either);
            }
            Tuple2<Boolean, Errors> tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            boolean hasEnough = tuple22._1$mcZ$sp();
            Errors error2 = tuple22._2();
            Tuple2<Boolean, Errors> tuple23 = new Tuple2<Boolean, Errors>(BoxesRunTime.boxToBoolean(hasEnough), error2);
            boolean hasEnough2 = tuple23._1$mcZ$sp();
            Errors errors = error = tuple23._2();
            Errors errors2 = Errors.NONE;
            if ((errors != null ? !errors.equals(errors2) : errors2 != null) || hasEnough2) {
                status.acksPending_$eq(false);
                status.responseStatus().error = error;
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$onExpiration$1(DelayedProduce $this, TopicIdPartition topicIdPartition, ProducePartitionStatus status) {
        if (status.acksPending()) {
            $this.debug((Function0<String> & Serializable)() -> "Expiring produce request for partition " + topicIdPartition + " with status " + status);
            DelayedProduceMetrics$.MODULE$.recordExpiration(topicIdPartition.topicPartition());
            return;
        }
    }

    public DelayedProduce(long delayMs, ProduceMetadata produceMetadata, ReplicaManager replicaManager, Function1<Map<TopicIdPartition, ProduceResponse.PartitionResponse>, BoxedUnit> responseCallback, Option<Lock> lockOpt) {
        this.produceMetadata = produceMetadata;
        this.replicaManager = replicaManager;
        this.responseCallback = responseCallback;
        super(delayMs, OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(lockOpt)));
        Logging.$init$(this);
        produceMetadata.produceStatus().foreachEntry((Function2<TopicIdPartition, ProducePartitionStatus, Object> & Serializable)(topicPartition, status) -> {
            DelayedProduce.$anonfun$new$1(this, topicPartition, status);
            return BoxedUnit.UNIT;
        });
    }
}

