/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.BrokerReconfigurable;
import kafka.server.DynamicBackpressure$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.QuotaFactory;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.server.quota.QuotaType;
import scala.Option$;
import scala.Predef$;
import scala.collection.Set;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005Q;Qa\u0003\u0007\t\u0002E1Qa\u0005\u0007\t\u0002QAQaG\u0001\u0005\u0002qAq!H\u0001C\u0002\u0013\u0005a\u0004\u0003\u0004.\u0003\u0001\u0006Ia\b\u0004\u0005'1\u0001a\u0006\u0003\u0005\u000e\u000b\t\u0005\t\u0015!\u00033\u0011\u0015YR\u0001\"\u00016\u0011\u0015AT\u0001\"\u0011:\u0011\u0015)U\u0001\"\u0011G\u0011\u0015yU\u0001\"\u0011Q\u0003M!\u0015P\\1nS\u000e\u0014\u0015mY6qe\u0016\u001c8/\u001e:f\u0015\tia\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u001f\u0005)1.\u00194lC\u000e\u0001\u0001C\u0001\n\u0002\u001b\u0005a!a\u0005#z]\u0006l\u0017n\u0019\"bG.\u0004(/Z:tkJ,7CA\u0001\u0016!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!E\u0001\u0016%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t+\u0005y\u0002c\u0001\u0011$K5\t\u0011E\u0003\u0002#/\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0011\n#aA*fiB\u0011aeK\u0007\u0002O)\u0011\u0001&K\u0001\u0005Y\u0006twMC\u0001+\u0003\u0011Q\u0017M^1\n\u00051:#AB*ue&tw-\u0001\fSK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:!'\r)Qc\f\t\u0003%AJ!!\r\u0007\u0003)\t\u0013xn[3s%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f!\t\u00112'\u0003\u00025\u0019\tY1*\u00194lC\n\u0013xn[3s)\t1t\u0007\u0005\u0002\u0013\u000b!)Qb\u0002a\u0001e\u0005)\"/Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001cX#\u0001\u001e\u0011\u0007\u0001\u001a3\b\u0005\u0002=\u0007:\u0011Q(\u0011\t\u0003}]i\u0011a\u0010\u0006\u0003\u0001B\ta\u0001\u0010:p_Rt\u0014B\u0001\"\u0018\u0003\u0019\u0001&/\u001a3fM&\u0011A\u0006\u0012\u0006\u0003\u0005^\tqC^1mS\u0012\fG/\u001a*fG>tg-[4ve\u0006$\u0018n\u001c8\u0015\u0005\u001dS\u0005C\u0001\fI\u0013\tIuC\u0001\u0003V]&$\b\"B&\n\u0001\u0004a\u0015!\u00038fo\u000e{gNZ5h!\t\u0011R*\u0003\u0002O\u0019\tY1*\u00194lC\u000e{gNZ5h\u0003-\u0011XmY8oM&<WO]3\u0015\u0007\u001d\u000b6\u000bC\u0003S\u0015\u0001\u0007A*A\u0005pY\u0012\u001cuN\u001c4jO\")1J\u0003a\u0001\u0019\u0002")
public class DynamicBackpressure
implements BrokerReconfigurable {
    private final KafkaBroker server;

    public static Set<String> ReconfigurableConfigs() {
        return DynamicBackpressure$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return DynamicBackpressure$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        if (Option$.MODULE$.apply(newConfig.getString("confluent.backpressure.types")).isDefined() && !QuotaFactory.isMultiTenant(newConfig)) {
            throw new ConfigException("Enabling backpressure requires 'client.quota.callback.class' to be set to 'io.confluent.kafka.multitenant.quota.TenantQuotaCallback'.");
        }
        if (QuotaFactory.backpressureEnabledInConfig(newConfig, QuotaType.REQUEST) && QuotaFactory.brokerBackpressureConfig((KafkaConfig)newConfig, (QuotaType)QuotaType.REQUEST).tenantEndpointListenerNames.isEmpty()) {
            throw new ConfigException("'confluent.multitenant.listener.names' must be set for request backpressure to be enabled.");
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.server.quotaManagers().fetch().updateBackpressureConfig(QuotaFactory.brokerBackpressureConfig(newConfig, QuotaType.FETCH));
        this.server.quotaManagers().produce().updateBackpressureConfig(QuotaFactory.brokerBackpressureConfig(newConfig, QuotaType.PRODUCE));
        this.server.quotaManagers().produce().updateDiskThrottlingConfig(QuotaFactory.diskThrottleConfig(newConfig));
        this.server.logManager().segmentDeletionThrottlerConfig().maybeUpdateDiskFreeThresholdBytes(Predef$.MODULE$.Boolean2boolean(newConfig.enableDiskBasedThrottling()), Predef$.MODULE$.Long2long(newConfig.backPressureDiskThresholdBytes()));
        this.server.quotaManagers().request().updateBackpressureConfig(QuotaFactory.brokerBackpressureConfig(newConfig, QuotaType.REQUEST));
        this.server.quotaManagers().clusterLinkRequest().updateBackpressureConfig(QuotaFactory.brokerBackpressureConfig(newConfig, QuotaType.CLUSTER_LINK_REQUEST));
    }

    public DynamicBackpressure(KafkaBroker server) {
        this.server = server;
    }
}

