/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicMetricsReporters;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicMetricsReportersScheduler {
    private static final Logger log = LoggerFactory.getLogger(DynamicMetricsReportersScheduler.class);
    private final Supplier<DynamicMetricsReporters> dynamicMetricsReportersFactory;
    private final DynamicBrokerConfig dynamicBrokerConfig;
    private final ExponentialBackoff exponentialBackoff = new ExponentialBackoff(500L, 2, 60000L, 0.0);
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(ThreadUtils.createThreadFactory((String)"DynamicMetricsReportersScheduler", (boolean)true));
    private final CompletableFuture<Void> future = new CompletableFuture();
    private final KafkaMetricsGroup metricsGroup = new KafkaMetricsGroup(this.getClass());
    private final String metricName = "DynamicMetricsReportersElapsedTimeMS";
    private final Time time;
    private final long checkIntervalMs;
    private long startTimeHiResClockMs;
    private long nextAttemptTime = Long.MIN_VALUE;
    private int attempt = 0;

    public DynamicMetricsReportersScheduler(Supplier<DynamicMetricsReporters> dynamicMetricsReportersFactory, DynamicBrokerConfig dynamicBrokerConfig, Time time, long checkIntervalMs) {
        this.dynamicMetricsReportersFactory = Objects.requireNonNull(dynamicMetricsReportersFactory);
        this.dynamicBrokerConfig = Objects.requireNonNull(dynamicBrokerConfig);
        this.time = Objects.requireNonNull(time);
        this.checkIntervalMs = checkIntervalMs;
    }

    public long elapsedTimeMs() {
        return this.time.hiResClockMs() - this.startTimeHiResClockMs;
    }

    public CompletableFuture<Void> start() {
        log.info("Starting DynamicMetricsReportersScheduler.");
        this.initializeStartTime();
        this.metricsGroup.newGauge("DynamicMetricsReportersElapsedTimeMS", this::elapsedTimeMs);
        this.executor.scheduleWithFixedDelay(this::check, 0L, this.checkIntervalMs, TimeUnit.MILLISECONDS);
        return this.future;
    }

    void check() {
        long nowHiResClockMs = this.time.hiResClockMs();
        if (nowHiResClockMs >= this.getNextAttemptHiResClockMs()) {
            ++this.attempt;
            log.info("Attempting to initiate DynamicMetricsReporters. Attempt: {}", (Object)this.attempt);
            try {
                this.dynamicBrokerConfig.addReconfigurable(this.dynamicMetricsReportersFactory.get());
                this.future.complete(null);
                log.info("DynamicMetricsReporters initiated successfully.");
                this.stop();
                return;
            }
            catch (Exception e) {
                nowHiResClockMs = this.time.hiResClockMs();
                this.nextAttemptTime = nowHiResClockMs + this.getNextBackoffAmountMs();
                log.error("Failed to initiate DynamicMetricsReporters. Elapsed time: {} ms, retrying in {} ms (Attempt {}).", new Object[]{this.elapsedTimeMs(), this.nextAttemptTime - nowHiResClockMs, this.attempt, e});
            }
        }
    }

    public void stop() {
        log.info("Stopping DynamicMetricsReportersScheduler.");
        this.executor.shutdown();
    }

    void initializeStartTime() {
        this.startTimeHiResClockMs = this.time.hiResClockMs();
    }

    long getNextBackoffAmountMs() {
        return this.exponentialBackoff.backoff((long)(this.getAttempt() - 1));
    }

    int getAttempt() {
        return this.attempt;
    }

    long getNextAttemptHiResClockMs() {
        return this.nextAttemptTime;
    }

    CompletableFuture<Void> getFuture() {
        return this.future;
    }
}

