/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kafka.coordinator.quota.QuotaCoordinator;
import kafka.coordinator.quota.QuotaDescription;
import kafka.coordinator.quota.QuotaEntity;
import kafka.server.AbstractRequestThread;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.message.PublishQuotaTargetRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.PublishQuotaTargetRequest;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.MetadataCache;
import org.apache.kafka.server.util.KafkaScheduler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005=c\u0001B\u0007\u000f\u0001MA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t[\u0001\u0011\t\u0011)A\u0005]!A1\u0007\u0001B\u0001B\u0003%A\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0011!\t\u0005A!A!\u0002\u0013\u0011\u0005\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\t\u000bA\u0003A\u0011A)\t\u000be\u0003A\u0011\t.\t\u000b)\u0004A\u0011I6\t\u000f\u0005\r\u0002\u0001\"\u0011\u0002&!9\u00111\u0007\u0001\u0005\n\u0005U\u0002bBA\u001c\u0001\u0011%\u0011\u0011\b\u0002$\tft\u0017-\\5d#V|G/\u0019)vE2L7\u000f[5oOJ+\u0017/^3tiRC'/Z1e\u0015\ty\u0001#\u0001\u0004tKJ4XM\u001d\u0006\u0002#\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0015!\r)b\u0003G\u0007\u0002\u001d%\u0011qC\u0004\u0002\u0016\u0003\n\u001cHO]1diJ+\u0017/^3tiRC'/Z1e!\tIbE\u0004\u0002\u001bI5\t1D\u0003\u0002\u001d;\u00059Q.Z:tC\u001e,'B\u0001\u0010 \u0003\u0019\u0019w.\\7p]*\u0011\u0011\u0003\t\u0006\u0003C\t\na!\u00199bG\",'\"A\u0012\u0002\u0007=\u0014x-\u0003\u0002&7\u0005i\u0002+\u001e2mSND\u0017+^8uCR\u000b'oZ3u%\u0016\fX/Z:u\t\u0006$\u0018-\u0003\u0002(Q\tIQI\u001c;ss\u0012\u000bG/\u0019\u0006\u0003Km\taaY8oM&<\u0007CA\u000b,\u0013\tacBA\u0006LC\u001a\\\u0017mQ8oM&<\u0017aB7fiJL7m\u001d\t\u0003_Ej\u0011\u0001\r\u0006\u0003[uI!A\r\u0019\u0003\u000f5+GO]5dg\u0006iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004\"!\u000e\u001d\u000e\u0003YR!aN\u0010\u0002\u00115,G/\u00193bi\u0006L!!\u000f\u001c\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u00035qW\r^<pe.\u001cE.[3oiB\u0011AhP\u0007\u0002{)\u0011ahH\u0001\bG2LWM\u001c;t\u0013\t\u0001UHA\u0007OKR<xN]6DY&,g\u000e^\u0001\u000fW\u000647.Y*dQ\u0016$W\u000f\\3s!\t\u0019u)D\u0001E\u0015\t)e)\u0001\u0003vi&d'BA\b \u0013\tAEI\u0001\bLC\u001a\\\u0017mU2iK\u0012,H.\u001a:\u0002\tQLW.\u001a\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001bv\tQ!\u001e;jYNL!a\u0014'\u0003\tQKW.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000fI\u001bF+\u0016,X1B\u0011Q\u0003\u0001\u0005\u0006S\u001d\u0001\rA\u000b\u0005\u0006[\u001d\u0001\rA\f\u0005\u0006g\u001d\u0001\r\u0001\u000e\u0005\u0006u\u001d\u0001\ra\u000f\u0005\u0006\u0003\u001e\u0001\rA\u0011\u0005\u0006\u0013\u001e\u0001\rAS\u0001\u0006gR\f'\u000f\u001e\u000b\u00037\u0006\u0004\"\u0001X0\u000e\u0003uS\u0011AX\u0001\u0006g\u000e\fG.Y\u0005\u0003Av\u0013A!\u00168ji\")!\r\u0003a\u0001G\u0006Y1m\\8sI&t\u0017\r^8s!\t!\u0007.D\u0001f\u0015\t1w-A\u0003rk>$\u0018M\u0003\u0002c!%\u0011\u0011.\u001a\u0002\u0011#V|G/Y\"p_J$\u0017N\\1u_J\fQb\u0019:fCR,'+Z9vKN$H#\u00027\u0002\u0006\u0005E\u0001GA7z!\rqGo\u001e\b\u0003_Jl\u0011\u0001\u001d\u0006\u0003cv\t\u0001B]3rk\u0016\u001cHo]\u0005\u0003gB\fq\"\u00112tiJ\f7\r\u001e*fcV,7\u000f^\u0005\u0003kZ\u0014qAQ;jY\u0012,'O\u0003\u0002taB\u0011\u00010\u001f\u0007\u0001\t%Q\u0018\"!A\u0001\u0002\u000b\u00051PA\u0002`IM\n\"\u0001`@\u0011\u0005qk\u0018B\u0001@^\u0005\u001dqu\u000e\u001e5j]\u001e\u00042a\\A\u0001\u0013\r\t\u0019\u0001\u001d\u0002\u0010\u0003\n\u001cHO]1diJ+\u0017/^3ti\"9\u0011qA\u0005A\u0002\u0005%\u0011\u0001\u00028pI\u0016\u0004B!a\u0003\u0002\u000e5\tQ$C\u0002\u0002\u0010u\u0011AAT8eK\"9\u00111C\u0005A\u0002\u0005U\u0011aB3oiJLWm\u001d\t\u0006\u0003/\ty\u0002G\u0007\u0003\u00033Q1!RA\u000e\u0015\t\ti\"\u0001\u0003kCZ\f\u0017\u0002BA\u0011\u00033\u0011\u0011\"\u0011:sCfd\u0015n\u001d;\u0002\u000f\u001d,GOT8eKR1\u0011qEA\u0017\u0003c\u0001R\u0001XA\u0015\u0003\u0013I1!a\u000b^\u0005\u0019y\u0005\u000f^5p]\"1\u0011q\u0006\u0006A\u0002a\tQ!\u001a8uefD\u0011\"a\u0002\u000b!\u0003\u0005\r!a\n\u0002;E,x\u000e^1UCJ<W\r\u001e)vE2L7\u000f[5oO\u000e\u000bG\u000e\u001c2bG.$\u0012aW\u0001\u0014GJ,\u0017\r^3F]R\u0014\u0018PR8s#V,W/\u001a\u000b\u00067\u0006m\u0012Q\t\u0005\b\u0003{a\u0001\u0019AA \u0003-\tXo\u001c;b\u000b:$\u0018\u000e^=\u0011\u0007\u0011\f\t%C\u0002\u0002D\u0015\u00141\"U;pi\u0006,e\u000e^5us\"9\u0011q\t\u0007A\u0002\u0005%\u0013\u0001E9v_R\fG)Z:de&\u0004H/[8o!\r!\u00171J\u0005\u0004\u0003\u001b*'\u0001E)v_R\fG)Z:de&\u0004H/[8o\u0001")
public class DynamicQuotaPublishingRequestThread
extends AbstractRequestThread<PublishQuotaTargetRequestData.EntryData> {
    private final KafkaConfig config;
    private final MetadataCache metadataCache;

    @Override
    public void start(QuotaCoordinator coordinator) {
        super.start(coordinator);
        this.schedule("publish-quota-target", () -> this.quotaTargetPublishingCallback(), Predef$.MODULE$.Long2long(this.config.confluentConfig().quotaDynamicPublishingIntervalMs()));
    }

    @Override
    public AbstractRequest.Builder<? extends AbstractRequest> createRequest(Node node, ArrayList<PublishQuotaTargetRequestData.EntryData> entries) {
        PublishQuotaTargetRequestData data = new PublishQuotaTargetRequestData().setEntries(entries);
        return new PublishQuotaTargetRequest.Builder(data);
    }

    @Override
    public Option<Node> getNode(PublishQuotaTargetRequestData.EntryData entry, Option<Node> node) {
        return node.flatMap((Function1<Node, Option> & Serializable)n -> OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional($this.metadataCache.getAliveBrokerNode(n.id(), $this.config.interBrokerListenerName()))));
    }

    private void quotaTargetPublishingCallback() {
        if (this.quotaCoordinator().isActive().get()) {
            Iterable<QuotaEntity> quotaEntities = this.quotaCoordinator().quotaStateManager().recomputedQuotaEntities();
            quotaEntities.foreach((Function1<QuotaEntity, Object> & Serializable)quotaEntity -> {
                DynamicQuotaPublishingRequestThread.$anonfun$quotaTargetPublishingCallback$1(this, quotaEntity);
                return BoxedUnit.UNIT;
            });
            this.wakeup();
            return;
        }
    }

    private void createEntryForQueue(QuotaEntity quotaEntity, QuotaDescription quotaDescription) {
        ArrayList entity = new ArrayList();
        quotaEntity.entityTypes().foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(DynamicQuotaPublishingRequestThread.$anonfun$createEntryForQueue$1(entity, x0$1)));
        quotaDescription.brokerQuotas().foreach((Function1<Tuple2, Object> & Serializable)x0$2 -> {
            DynamicQuotaPublishingRequestThread.$anonfun$createEntryForQueue$2(this, entity, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$quotaTargetPublishingCallback$1(DynamicQuotaPublishingRequestThread $this, QuotaEntity quotaEntity) {
        if (!$this.quotaCoordinator().isDynamicQuotaComputedByFlexFanout(quotaEntity)) {
            Tuple2<Errors, QuotaDescription> tuple2 = $this.quotaCoordinator().describeQuota(quotaEntity);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Errors error = tuple2._1();
            QuotaDescription quotaDescription = tuple2._2();
            Tuple2<Errors, QuotaDescription> tuple22 = new Tuple2<Errors, QuotaDescription>(error, quotaDescription);
            Errors error2 = tuple22._1();
            QuotaDescription quotaDescription2 = tuple22._2();
            Errors errors = error2;
            if (Errors.NONE.equals(errors)) {
                $this.createEntryForQueue(quotaEntity, quotaDescription2);
                return;
            }
            $this.warn((Function0<String> & Serializable)() -> "Failed to describe quota for entity " + quotaEntity + " due to " + error2);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$createEntryForQueue$1(ArrayList entity$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String entityType = (String)tuple2._1();
            String entityName = (String)tuple2._2();
            return entity$1.add(new PublishQuotaTargetRequestData.EntityData().setEntityType(entityType).setEntityName(entityName));
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$createEntryForQueue$3(ArrayList quotas$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            String quotaType = (String)tuple2._1();
            double quotaValue = tuple2._2$mcD$sp();
            return quotas$1.add(new PublishQuotaTargetRequestData.QuotaData().setQuotaType(quotaType).setQuota(quotaValue));
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$createEntryForQueue$2(DynamicQuotaPublishingRequestThread $this, ArrayList entity$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            int brokerId = tuple2._1$mcI$sp();
            Map perBrokerQuota = (Map)tuple2._2();
            ArrayList quotas = new ArrayList();
            perBrokerQuota.foreach((Function1<Tuple2, Object> & Serializable)x0$3 -> BoxesRunTime.boxToBoolean(DynamicQuotaPublishingRequestThread.$anonfun$createEntryForQueue$3(quotas, x0$3)));
            PublishQuotaTargetRequestData.EntryData entry = new PublishQuotaTargetRequestData.EntryData().setEntity((List)entity$1).setQuotas(quotas);
            Option<Node> destination = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional($this.metadataCache.getAliveBrokerNode(brokerId, $this.config.interBrokerListenerName())));
            $this.addEntryForNode(entry, destination);
            return;
        }
        throw new MatchError(tuple2);
    }

    public DynamicQuotaPublishingRequestThread(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, NetworkClient networkClient, KafkaScheduler kafkaScheduler, Time time) {
        this.config = config;
        this.metadataCache = metadataCache;
        super(config, metrics, networkClient, kafkaScheduler, time, "Quota Publishing");
    }
}

