/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.replication.push.ReplicationConfig;
import java.io.Serializable;
import kafka.server.BrokerReconfigurable;
import kafka.server.BrokerServer;
import kafka.server.DynamicReplicationModeConfig$;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.message.ApiMessageType;
import scala.Function0;
import scala.Predef$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005i;Qa\u0003\u0007\t\u0002E1Qa\u0005\u0007\t\u0002QAQaG\u0001\u0005\u0002qAq!H\u0001C\u0002\u0013\u0005a\u0004\u0003\u0004.\u0003\u0001\u0006Ia\b\u0004\u0005'1\u0001a\u0006\u0003\u0005\u000e\u000b\t\u0005\t\u0015!\u00039\u0011\u0015YR\u0001\"\u0001<\u0011\u0015qT\u0001\"\u0011@\u0011\u0015YU\u0001\"\u0011M\u0011\u0015)V\u0001\"\u0011W\u0003q!\u0015P\\1nS\u000e\u0014V\r\u001d7jG\u0006$\u0018n\u001c8N_\u0012,7i\u001c8gS\u001eT!!\u0004\b\u0002\rM,'O^3s\u0015\u0005y\u0011!B6bM.\f7\u0001\u0001\t\u0003%\u0005i\u0011\u0001\u0004\u0002\u001d\tft\u0017-\\5d%\u0016\u0004H.[2bi&|g.T8eK\u000e{gNZ5h'\t\tQ\u0003\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrC\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\tQCU3d_:4\u0017nZ;sC\ndWmQ8oM&<7/F\u0001 !\r\u00013%J\u0007\u0002C)\u0011!eF\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u0013\"\u0005\r\u0019V\r\u001e\t\u0003M-j\u0011a\n\u0006\u0003Q%\nA\u0001\\1oO*\t!&\u0001\u0003kCZ\f\u0017B\u0001\u0017(\u0005\u0019\u0019FO]5oO\u00061\"+Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001c\be\u0005\u0003\u0006+=\u0012\u0004C\u0001\n1\u0013\t\tDB\u0001\u000bCe>\\WM\u001d*fG>tg-[4ve\u0006\u0014G.\u001a\t\u0003gYj\u0011\u0001\u000e\u0006\u0003k9\tQ!\u001e;jYNL!a\u000e\u001b\u0003\u000f1{wmZ5oOB\u0011!#O\u0005\u0003u1\u0011AB\u0011:pW\u0016\u00148+\u001a:wKJ$\"\u0001P\u001f\u0011\u0005I)\u0001\"B\u0007\b\u0001\u0004A\u0014!\u0006:fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm]\u000b\u0002\u0001B\u0019\u0001eI!\u0011\u0005\tKeBA\"H!\t!u#D\u0001F\u0015\t1\u0005#\u0001\u0004=e>|GOP\u0005\u0003\u0011^\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0017K\u0015\tAu#A\fwC2LG-\u0019;f%\u0016\u001cwN\u001c4jOV\u0014\u0018\r^5p]R\u0011Q\n\u0015\t\u0003-9K!aT\f\u0003\tUs\u0017\u000e\u001e\u0005\u0006#&\u0001\rAU\u0001\n]\u0016<8i\u001c8gS\u001e\u0004\"AE*\n\u0005Qc!aC&bM.\f7i\u001c8gS\u001e\f1B]3d_:4\u0017nZ;sKR\u0019QjV-\t\u000baS\u0001\u0019\u0001*\u0002\u0013=dGmQ8oM&<\u0007\"B)\u000b\u0001\u0004\u0011\u0006")
public class DynamicReplicationModeConfig
implements BrokerReconfigurable,
Logging {
    private final BrokerServer server;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Set<String> ReconfigurableConfigs() {
        return DynamicReplicationModeConfig$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        DynamicReplicationModeConfig dynamicReplicationModeConfig = this;
        synchronized (dynamicReplicationModeConfig) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        ApiMessageType.ApiVisibility apiVisibility = this.server.config().apiVisibility();
        ApiMessageType.ApiVisibility apiVisibility2 = ApiMessageType.ApiVisibility.CONFLUENT_CLOUD;
        if (!(apiVisibility != null ? !apiVisibility.equals(apiVisibility2) : apiVisibility2 != null)) {
            return (Set)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.replication.mode"}));
        }
        return (Set)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.intelligent.replication.enable"}));
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        ApiMessageType.ApiVisibility apiVisibility = newConfig.apiVisibility();
        ApiMessageType.ApiVisibility apiVisibility2 = ApiMessageType.ApiVisibility.CONFLUENT_CLOUD;
        boolean isCCloud = !(apiVisibility != null ? !apiVisibility.equals(apiVisibility2) : apiVisibility2 != null);
        boolean hasReplicationMode = newConfig.originals().containsKey("confluent.replication.mode");
        boolean hasIntelligentReplication = newConfig.originals().containsKey("confluent.intelligent.replication.enable");
        if (isCCloud && hasIntelligentReplication) {
            throw new ConfigException("confluent.intelligent.replication.enable is not valid for CCloud environments. Use confluent.replication.mode instead.");
        }
        if (!isCCloud && hasReplicationMode) {
            throw new ConfigException("confluent.replication.mode is not valid. Use confluent.intelligent.replication.enable instead.");
        }
        if (isCCloud && !Predef$.MODULE$.Boolean2boolean(newConfig.isPushReplicationFeatureEnabled())) {
            throw new ConfigException("Unable to dynamically configure replication mode since the feature is unsupported or disabled");
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        boolean isNewConfigDisablingPush;
        ReplicationConfig.Mode configuredMode;
        ApiMessageType.ApiVisibility apiVisibility = newConfig.apiVisibility();
        ApiMessageType.ApiVisibility apiVisibility2 = ApiMessageType.ApiVisibility.CONFLUENT_CLOUD;
        boolean bl = !(apiVisibility != null ? !apiVisibility.equals(apiVisibility2) : apiVisibility2 != null) ? !ReplicationConfig.pushReplicationModeEnabled(configuredMode = ReplicationConfig.Mode.valueOf(newConfig.getString("confluent.replication.mode"))) : (isNewConfigDisablingPush = !Predef$.MODULE$.Boolean2boolean(newConfig.isPushReplicationFeatureEnabled()));
        if (this.server.replicaManager().isPushReplicationModeEnabled() && isNewConfigDisablingPush) {
            this.info((Function0<String> & Serializable)() -> "Restarting replica fetchers for all follower partitions to disable push replication");
            this.server.replicaManager().disablePushReplicationModeAndRestartReplicaFetchers();
            return;
        }
        this.warn((Function0<String> & Serializable)() -> "No-op with dynamic configuration of intelligent replication since we only allow dynamic disablement");
    }

    public DynamicReplicationModeConfig(BrokerServer server) {
        this.server = server;
        Logging.$init$(this);
    }
}

