/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.telemetry.api.events.EventEmitter;
import io.opentelemetry.context.Context;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Optional;
import kafka.network.RequestChannel;
import kafka.network.RequestChannel$Request$;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.PrincipalDeserializationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestLogFilter;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.network.metrics.RequestChannelMetrics;
import org.apache.kafka.server.audit.AuditLogProvider;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class EnvelopeUtils$ {
    public static final EnvelopeUtils$ MODULE$ = new EnvelopeUtils$();

    public void handleEnvelopeRequest(RequestChannel.Request request, RequestChannelMetrics requestChannelMetrics, Function1<RequestChannel.Request, BoxedUnit> handler) {
        EnvelopeRequest envelope = (EnvelopeRequest)request.body(ClassTag$.MODULE$.apply(EnvelopeRequest.class));
        KafkaPrincipal forwardedPrincipal = this.parseForwardedPrincipal(request.context(), envelope.requestPrincipal());
        InetAddress forwardedClientAddress = this.parseForwardedClientAddress(envelope.clientAddress());
        ByteBuffer forwardedRequestBuffer = envelope.requestData().duplicate();
        RequestHeader forwardedRequestHeader = this.parseForwardedRequestHeader(forwardedRequestBuffer);
        ApiKeys forwardedApi = forwardedRequestHeader.apiKey();
        if (!forwardedApi.forwardable) {
            throw new InvalidRequestException("API " + forwardedApi + " is not enabled or is not eligible for forwarding");
        }
        RequestContext forwardedContext = new RequestContext(forwardedRequestHeader, request.context().connectionId, Predef$.MODULE$.long2Long(request.context().kafkaRequestId()), forwardedClientAddress, Optional.empty(), forwardedPrincipal, request.context().listenerName, request.context().securityProtocol, ClientInformation.EMPTY, request.context().sniHostName, request.context().fromPrivilegedListener, Optional.empty(), null, null, request.context().isProxyModeLocal(), request.context().fqdnPropertiesFromPpv2(), request.context().shouldLogForConnection, request.context().confluentMetricsContextProvider);
        RequestChannel.Request forwardedRequest = this.parseForwardedRequest(request, forwardedContext, forwardedRequestBuffer, requestChannelMetrics);
        handler.apply(forwardedRequest);
    }

    private InetAddress parseForwardedClientAddress(byte[] address) {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByAddress(address);
        }
        catch (UnknownHostException e) {
            throw new InvalidRequestException("Failed to parse client address from envelope", (Throwable)e);
        }
        return inetAddress;
    }

    private RequestChannel.Request parseForwardedRequest(RequestChannel.Request envelope, RequestContext forwardedContext, ByteBuffer buffer, RequestChannelMetrics requestChannelMetrics) {
        RequestChannel.Request request;
        try {
            int x$1 = envelope.processor();
            RequestContext x$2 = forwardedContext;
            long x$3 = envelope.startTimeNanos();
            MemoryPool x$4 = envelope.memoryPool();
            ByteBuffer x$5 = buffer;
            RequestChannelMetrics x$6 = requestChannelMetrics;
            Some<RequestChannel.Request> x$7 = new Some<RequestChannel.Request>(envelope);
            long x$8 = envelope.sequenceId();
            Context x$9 = RequestChannel$Request$.MODULE$.$lessinit$greater$default$8();
            EventEmitter x$10 = RequestChannel$Request$.MODULE$.$lessinit$greater$default$9();
            AuditLogProvider x$11 = RequestChannel$Request$.MODULE$.$lessinit$greater$default$10();
            RequestLogFilter x$12 = RequestChannel$Request$.MODULE$.$lessinit$greater$default$11();
            RequestChannel.ProxyChannel x$13 = RequestChannel$Request$.MODULE$.$lessinit$greater$default$13();
            RequestChannel.Request forwardedRequest = new RequestChannel.Request(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$9, x$10, x$11, x$12, x$8, x$13);
            forwardedRequest.requestDequeueTimeNanos_$eq(envelope.requestDequeueTimeNanos());
            request = forwardedRequest;
        }
        catch (InvalidRequestException e) {
            throw new UnsupportedVersionException("Failed to parse forwarded request with header " + forwardedContext.header, (Throwable)e);
        }
        return request;
    }

    private RequestHeader parseForwardedRequestHeader(ByteBuffer buffer) {
        RequestHeader requestHeader;
        try {
            requestHeader = RequestHeader.parse((ByteBuffer)buffer);
        }
        catch (InvalidRequestException e) {
            throw new UnsupportedVersionException("Failed to parse request header from envelope", (Throwable)e);
        }
        return requestHeader;
    }

    private KafkaPrincipal parseForwardedPrincipal(RequestContext envelopeContext, byte[] principalBytes) {
        Option option = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(envelopeContext.principalSerde));
        if (option instanceof Some) {
            KafkaPrincipal kafkaPrincipal;
            Some some = (Some)option;
            KafkaPrincipalSerde serde = (KafkaPrincipalSerde)some.value();
            try {
                kafkaPrincipal = serde.deserialize(principalBytes);
            }
            catch (Exception e) {
                throw new PrincipalDeserializationException("Failed to deserialize client principal from envelope", (Throwable)e);
            }
            return kafkaPrincipal;
        }
        if (None$.MODULE$.equals(option)) {
            throw new PrincipalDeserializationException("Could not deserialize principal since no `KafkaPrincipalSerde` has been defined");
        }
        throw new MatchError(option);
    }

    private EnvelopeUtils$() {
    }
}

