/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import kafka.server.EvictableKey;
import kafka.server.FetchSession;
import kafka.server.FetchSession$;
import kafka.server.FetchSessionCache$;
import kafka.server.IncrementalPartitionFetchMetadata;
import kafka.utils.Logging;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015e\u0001\u0002\u0013&\u0001)B\u0001b\u000e\u0001\u0003\u0006\u0004%I\u0001\u000f\u0005\ty\u0001\u0011\t\u0011)A\u0005s!AQ\b\u0001BC\u0002\u0013%a\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003@\u0011!\u0019\u0005A!b\u0001\n\u0003A\u0004\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u0011\u0015\u0003!Q1A\u0005\naB\u0001B\u0012\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\u0006\u000f\u0002!\t\u0001\u0013\u0005\u0006\u000f\u0002!\ta\u0014\u0005\b%\u0002\u0001\r\u0011\"\u0003?\u0011\u001d\u0019\u0006\u00011A\u0005\nQCaA\u0017\u0001!B\u0013y\u0004bB0\u0001\u0005\u0004%I\u0001\u0019\u0005\u0007Y\u0002\u0001\u000b\u0011B1\t\u000f5\u0004\u0001\u0019!C\u0001q!9a\u000e\u0001a\u0001\n\u0003y\u0007BB9\u0001A\u0003&\u0011\bC\u0004t\u0001\t\u0007I\u0011\u0002;\t\rm\u0004\u0001\u0015!\u0003v\u0011\u001da\bA1A\u0005\nQDa! \u0001!\u0002\u0013)\b\u0002\u0003@\u0001\u0005\u0004%\t!J@\t\u0011\u0005e\u0001\u0001)A\u0005\u0003\u0003A\u0011\"a\u0007\u0001\u0005\u0004%\t!J@\t\u0011\u0005u\u0001\u0001)A\u0005\u0003\u0003Aq!a\b\u0001\t\u0003\t\t\u0003\u0003\u0004\u0002.\u0001!\t\u0001\u000f\u0005\u0007\u0003_\u0001A\u0011\u0001 \t\u000f\u0005E\u0002\u0001\"\u0001\u00024!9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0002bBA3\u0001\u0011%\u0011q\r\u0005\b\u0003c\u0002A\u0011AA:\u0011\u001d\t\t\b\u0001C\u0001\u0003oBq!! \u0001\t\u0003\tyH\u0001\fGKR\u001c\u0007nU3tg&|gnQ1dQ\u0016\u001c\u0006.\u0019:e\u0015\t1s%\u0001\u0004tKJ4XM\u001d\u0006\u0002Q\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001,cA\u0011AfL\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\t1\u0011I\\=SK\u001a\u0004\"AM\u001b\u000e\u0003MR!\u0001N\u0014\u0002\u000bU$\u0018\u000e\\:\n\u0005Y\u001a$a\u0002'pO\u001eLgnZ\u0001\u000b[\u0006DXI\u001c;sS\u0016\u001cX#A\u001d\u0011\u00051R\u0014BA\u001e.\u0005\rIe\u000e^\u0001\f[\u0006DXI\u001c;sS\u0016\u001c\b%\u0001\u0006fm&\u001cG/[8o\u001bN,\u0012a\u0010\t\u0003Y\u0001K!!Q\u0017\u0003\t1{gnZ\u0001\fKZL7\r^5p]6\u001b\b%\u0001\btKN\u001c\u0018n\u001c8JIJ\u000bgnZ3\u0002\u001fM,7o]5p]&#'+\u00198hK\u0002\n\u0001b\u001d5be\u0012tU/\\\u0001\ng\"\f'\u000f\u001a(v[\u0002\na\u0001P5oSRtD#B%L\u00196s\u0005C\u0001&\u0001\u001b\u0005)\u0003\"B\u001c\n\u0001\u0004I\u0004\"B\u001f\n\u0001\u0004y\u0004\"B\"\n\u0001\u0004I\u0004\"B#\n\u0001\u0004IDcA%Q#\")qG\u0003a\u0001s!)QH\u0003a\u0001\u007f\u0005ia.^7QCJ$\u0018\u000e^5p]N\f\u0011C\\;n!\u0006\u0014H/\u001b;j_:\u001cx\fJ3r)\t)\u0006\f\u0005\u0002--&\u0011q+\f\u0002\u0005+:LG\u000fC\u0004Z\u0019\u0005\u0005\t\u0019A \u0002\u0007a$\u0013'\u0001\bok6\u0004\u0016M\u001d;ji&|gn\u001d\u0011)\u00055a\u0006C\u0001\u0017^\u0013\tqVF\u0001\u0005w_2\fG/\u001b7f\u0003!\u0019Xm]:j_:\u001cX#A1\u0011\t\t<\u0017([\u0007\u0002G*\u0011A-Z\u0001\u0005kRLGNC\u0001g\u0003\u0011Q\u0017M^1\n\u0005!\u001c'!\u0004'j].,G\rS1tQ6\u000b\u0007\u000f\u0005\u0002KU&\u00111.\n\u0002\r\r\u0016$8\r[*fgNLwN\\\u0001\ng\u0016\u001c8/[8og\u0002\nAb]3tg&|gn]*ju\u0016\f\u0001c]3tg&|gn]*ju\u0016|F%Z9\u0015\u0005U\u0003\bbB-\u0012\u0003\u0003\u0005\r!O\u0001\u000eg\u0016\u001c8/[8ogNK'0\u001a\u0011)\u0005Ia\u0016AD3wS\u000e$\u0018M\u00197f\u0005f\fE\u000e\\\u000b\u0002kB!!M\u001e=j\u0013\t98MA\u0004Ue\u0016,W*\u00199\u0011\u0005)K\u0018B\u0001>&\u00051)e/[2uC\ndWmS3z\u0003=)g/[2uC\ndWMQ=BY2\u0004\u0013!F3wS\u000e$\u0018M\u00197f\u0005f\u0004&/\u001b<jY\u0016<W\rZ\u0001\u0017KZL7\r^1cY\u0016\u0014\u0015\u0010\u0015:jm&dWmZ3eA\u0005qQM^5di&|gn]'fi\u0016\u0014XCAA\u0001!\u0011\t\u0019!!\u0006\u000e\u0005\u0005\u0015!\u0002BA\u0004\u0003\u0013\tAaY8sK*!\u00111BA\u0007\u0003\u001diW\r\u001e:jGNTA!a\u0004\u0002\u0012\u00051\u00110Y7nKJT!!a\u0005\u0002\u0007\r|W.\u0003\u0003\u0002\u0018\u0005\u0015!!B'fi\u0016\u0014\u0018aD3wS\u000e$\u0018n\u001c8t\u001b\u0016$XM\u001d\u0011\u00027\u0005\u001cG/\u001b<f'\u0016\u001c8/[8o\u000bZL7\r^5p]NlU\r^3s\u0003q\t7\r^5wKN+7o]5p]\u00163\u0018n\u0019;j_:\u001cX*\u001a;fe\u0002\n1aZ3u)\u0011\t\u0019#!\u000b\u0011\t1\n)#[\u0005\u0004\u0003Oi#AB(qi&|g\u000e\u0003\u0004\u0002,m\u0001\r!O\u0001\ng\u0016\u001c8/[8o\u0013\u0012\fAa]5{K\u0006yAo\u001c;bYB\u000b'\u000f^5uS>t7/\u0001\u0007oK^\u001cVm]:j_:LE\rF\u0001:\u0003Ii\u0017-\u001f2f\u0007J,\u0017\r^3TKN\u001c\u0018n\u001c8\u0015\u0017e\nI$!\u0010\u0002H\u0005%\u0013Q\n\u0005\u0007\u0003wy\u0002\u0019A \u0002\u00079|w\u000fC\u0004\u0002@}\u0001\r!!\u0011\u0002\u0015A\u0014\u0018N^5mK\u001e,G\rE\u0002-\u0003\u0007J1!!\u0012.\u0005\u001d\u0011un\u001c7fC:Da!!\f \u0001\u0004I\u0004bBA&?\u0001\u0007\u0011\u0011I\u0001\rkN,7\u000fV8qS\u000eLEm\u001d\u0005\b\u0003\u001fz\u0002\u0019AA)\u0003A\u0019'/Z1uKB\u000b'\u000f^5uS>t7\u000fE\u0003-\u0003'\n9&C\u0002\u0002V5\u0012\u0011BR;oGRLwN\u001c\u0019\u0011\t\u0005e\u0013q\f\b\u0004\u0015\u0006m\u0013bAA/K\u0005aa)\u001a;dQN+7o]5p]&!\u0011\u0011MA2\u0005%\u0019\u0015i\u0011%F?6\u000b\u0005KC\u0002\u0002^\u0015\n\u0001\u0002\u001e:z\u000bZL7\r\u001e\u000b\t\u0003\u0003\nI'a\u001b\u0002p!9\u0011q\b\u0011A\u0002\u0005\u0005\u0003BBA7A\u0001\u0007\u00010A\u0002lKfDa!a\u000f!\u0001\u0004y\u0014A\u0002:f[>4X\r\u0006\u0003\u0002$\u0005U\u0004BBA\u0016C\u0001\u0007\u0011\b\u0006\u0003\u0002$\u0005e\u0004BBA>E\u0001\u0007\u0011.A\u0004tKN\u001c\u0018n\u001c8\u0002\u000bQ|Wo\u00195\u0015\u000bU\u000b\t)a!\t\r\u0005m4\u00051\u0001j\u0011\u0019\tYd\ta\u0001\u007f\u0001")
public class FetchSessionCacheShard
implements Logging {
    private final int maxEntries;
    private final long evictionMs;
    private final int sessionIdRange;
    private final int shardNum;
    private volatile long numPartitions;
    private final LinkedHashMap<Object, FetchSession> sessions;
    private volatile int sessionsSize;
    private final TreeMap<EvictableKey, FetchSession> evictableByAll;
    private final TreeMap<EvictableKey, FetchSession> evictableByPrivileged;
    private final Meter evictionsMeter;
    private final Meter activeSessionEvictionsMeter;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        FetchSessionCacheShard fetchSessionCacheShard = this;
        synchronized (fetchSessionCacheShard) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private int maxEntries() {
        return this.maxEntries;
    }

    private long evictionMs() {
        return this.evictionMs;
    }

    public int sessionIdRange() {
        return this.sessionIdRange;
    }

    private int shardNum() {
        return this.shardNum;
    }

    private long numPartitions() {
        return this.numPartitions;
    }

    private void numPartitions_$eq(long x$1) {
        this.numPartitions = x$1;
    }

    private LinkedHashMap<Object, FetchSession> sessions() {
        return this.sessions;
    }

    public int sessionsSize() {
        return this.sessionsSize;
    }

    public void sessionsSize_$eq(int x$1) {
        this.sessionsSize = x$1;
    }

    private TreeMap<EvictableKey, FetchSession> evictableByAll() {
        return this.evictableByAll;
    }

    private TreeMap<EvictableKey, FetchSession> evictableByPrivileged() {
        return this.evictableByPrivileged;
    }

    public Meter evictionsMeter() {
        return this.evictionsMeter;
    }

    public Meter activeSessionEvictionsMeter() {
        return this.activeSessionEvictionsMeter;
    }

    public synchronized Option<FetchSession> get(int sessionId) {
        return Option$.MODULE$.apply(this.sessions().get(BoxesRunTime.boxToInteger(sessionId)));
    }

    public int size() {
        return this.sessionsSize();
    }

    public long totalPartitions() {
        return this.numPartitions();
    }

    public synchronized int newSessionId() {
        int id = 0;
        do {
            id = ThreadLocalRandom.current().nextInt(Math.max(1, this.shardNum() * this.sessionIdRange()), (this.shardNum() + 1) * this.sessionIdRange());
        } while (this.sessions().containsKey(BoxesRunTime.boxToInteger(id)) || id == 0);
        return id;
    }

    public synchronized int maybeCreateSession(long now, boolean privileged, int size, boolean usesTopicIds, Function0<ImplicitLinkedHashCollection<IncrementalPartitionFetchMetadata>> createPartitions) {
        if (this.sessionsSize() < this.maxEntries() || this.tryEvict(privileged, new EvictableKey(privileged, size, 0), now)) {
            ImplicitLinkedHashCollection<IncrementalPartitionFetchMetadata> partitionMap = createPartitions.apply();
            FetchSession session = new FetchSession(this.newSessionId(), privileged, partitionMap, usesTopicIds, now, now, FetchMetadata.nextEpoch((int)0));
            this.debug((Function0<String> & Serializable)() -> "Created fetch session " + session.toString());
            this.touch(session, now);
            return session.id();
        }
        this.debug((Function0<String> & Serializable)() -> "No fetch session created for privileged=" + privileged + ", size=" + size + ".");
        return 0;
    }

    private synchronized boolean tryEvict(boolean privileged, EvictableKey key, long now) {
        Iterator<Map.Entry<Object, FetchSession>> sessionIterator = this.sessions().entrySet().iterator();
        if (!sessionIterator.hasNext()) {
            this.trace((Function0<String> & Serializable)() -> "There are no cache entries to evict.");
            return false;
        }
        FetchSession lastUsedSession = sessionIterator.next().getValue();
        if (now - lastUsedSession.lastUsedMs() > this.evictionMs()) {
            this.trace((Function0<String> & Serializable)() -> "Evicting stale FetchSession " + lastUsedSession.id() + ".");
            this.remove(lastUsedSession);
            this.evictionsMeter().mark();
            return true;
        }
        if (privileged) {
            return this.evictEntry$1(key, this.evictableByPrivileged());
        }
        return this.evictEntry$1(key, this.evictableByAll());
    }

    public synchronized Option<FetchSession> remove(int sessionId) {
        Option<FetchSession> option = this.get(sessionId);
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            FetchSession session = (FetchSession)some.value();
            return this.remove(session);
        }
        throw new MatchError(option);
    }

    public synchronized Option<FetchSession> remove(FetchSession session) {
        Option result = None$.MODULE$;
        FetchSession fetchSession = session;
        synchronized (fetchSession) {
            EvictableKey evictableKey = session.evictableKey();
            Object object = !session.privileged() ? this.evictableByAll().remove(evictableKey) : BoxedUnit.UNIT;
            this.evictableByPrivileged().remove(evictableKey);
            result = Option$.MODULE$.apply(this.sessions().remove(BoxesRunTime.boxToInteger(session.id())));
            if (result.isDefined()) {
                session.close();
                this.numPartitions_$eq(this.numPartitions() - (long)session.cachedSize());
            }
        }
        this.sessionsSize_$eq(this.sessions().size());
        return result;
    }

    public synchronized void touch(FetchSession session, long now) {
        FetchSession fetchSession = session;
        synchronized (fetchSession) {
            this.sessions().remove(BoxesRunTime.boxToInteger(session.id()));
            session.lastUsedMs_$eq(now);
            this.sessions().put(BoxesRunTime.boxToInteger(session.id()), session);
            int oldSize = session.cachedSize();
            if (oldSize != -1) {
                EvictableKey oldEvictableKey = session.evictableKey();
                this.evictableByPrivileged().remove(oldEvictableKey);
                this.evictableByAll().remove(oldEvictableKey);
                this.numPartitions_$eq(this.numPartitions() - (long)oldSize);
            }
            session.cachedSize_$eq(session.size());
            EvictableKey newEvictableKey = session.evictableKey();
            Object object = !session.privileged() || now - session.creationMs() > this.evictionMs() ? this.evictableByPrivileged().put(newEvictableKey, session) : BoxedUnit.UNIT;
            Object object2 = !session.privileged() && now - session.creationMs() > this.evictionMs() ? this.evictableByAll().put(newEvictableKey, session) : BoxedUnit.UNIT;
            this.numPartitions_$eq(this.numPartitions() + (long)session.cachedSize());
        }
        this.sessionsSize_$eq(this.sessions().size());
    }

    private final boolean evictEntry$1(EvictableKey key, TreeMap map) {
        Map.Entry evictableEntry = map.firstEntry();
        if (evictableEntry == null) {
            this.trace((Function0<String> & Serializable)() -> "No evictable entries found.");
            return false;
        }
        if (key.compareTo((EvictableKey)evictableEntry.getKey()) < 0) {
            this.trace((Function0<String> & Serializable)() -> "Can't evict " + evictableEntry.getKey() + " with " + key.toString());
            return false;
        }
        this.trace((Function0<String> & Serializable)() -> "Evicting " + evictableEntry.getKey() + " with " + key.toString() + ".");
        this.remove((FetchSession)evictableEntry.getValue());
        this.evictionsMeter().mark();
        this.activeSessionEvictionsMeter().mark();
        return true;
    }

    public FetchSessionCacheShard(int maxEntries, long evictionMs, int sessionIdRange, int shardNum) {
        this.maxEntries = maxEntries;
        this.evictionMs = evictionMs;
        this.sessionIdRange = sessionIdRange;
        this.shardNum = shardNum;
        Logging.$init$(this);
        this.logIdent_$eq("[Shard " + shardNum + "] ");
        this.numPartitions = 0L;
        this.sessions = new LinkedHashMap();
        this.sessionsSize = 0;
        this.evictableByAll = new TreeMap();
        this.evictableByPrivileged = new TreeMap();
        this.evictionsMeter = FetchSessionCache$.MODULE$.metricsGroup().newMeter(FetchSession$.MODULE$.INCREMENTAL_FETCH_SESSIONS_EVICTIONS_PER_SEC(), FetchSession$.MODULE$.EVICTIONS(), TimeUnit.SECONDS);
        this.activeSessionEvictionsMeter = FetchSessionCache$.MODULE$.metricsGroup().newMeter(FetchSession$.MODULE$.INCREMENTAL_FETCH_SESSIONS_ACTIVE_SESSION_EVICTIONS_PER_SEC(), FetchSession$.MODULE$.EVICTIONS(), TimeUnit.SECONDS);
    }

    public FetchSessionCacheShard(int maxEntries, long evictionMs) {
        this(maxEntries, evictionMs, Integer.MAX_VALUE, 0);
    }
}

