/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import kafka.network.RequestChannel;
import kafka.server.ForwardingManager;
import kafka.server.ForwardingManager$;
import kafka.server.ForwardingManagerImpl;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.EnvelopeResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.server.common.ControllerRequestCompletionHandler;
import org.apache.kafka.server.common.NodeToControllerChannelManager;
import org.apache.kafka.server.metrics.ForwardingManagerMetrics;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0005\u0005}b\u0001\u0002\u0006\f\u0001AA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\tm\u0001\u0011\t\u0011)A\u0005o!)Q\b\u0001C\u0001}!9!\t\u0001b\u0001\n\u0003\u0019\u0005BB%\u0001A\u0003%A\tC\u0003K\u0001\u0011\u00053\nC\u0004\u0002\n\u0001!\t%a\u0003\t\u000f\u00055\u0001\u0001\"\u0011\u0002\u0010!9\u0011\u0011\u0006\u0001\u0005\n\u0005-\"!\u0006$pe^\f'\u000fZ5oO6\u000bg.Y4fe&k\u0007\u000f\u001c\u0006\u0003\u00195\taa]3sm\u0016\u0014(\"\u0001\b\u0002\u000b-\fgm[1\u0004\u0001M)\u0001!E\f\u001cGA\u0011!#F\u0007\u0002')\tA#A\u0003tG\u0006d\u0017-\u0003\u0002\u0017'\t1\u0011I\\=SK\u001a\u0004\"\u0001G\r\u000e\u0003-I!AG\u0006\u0003#\u0019{'o^1sI&tw-T1oC\u001e,'\u000f\u0005\u0002\u001dC5\tQD\u0003\u0002\u001f?\u0005!A.\u00198h\u0015\u0005\u0001\u0013\u0001\u00026bm\u0006L!AI\u000f\u0003\u001b\u0005+Ho\\\"m_N,\u0017M\u00197f!\t!s%D\u0001&\u0015\t1S\"A\u0003vi&d7/\u0003\u0002)K\t9Aj\\4hS:<\u0017AD2iC:tW\r\\'b]\u0006<WM\u001d\t\u0003WQj\u0011\u0001\f\u0006\u0003[9\naaY8n[>t'B\u0001\u00070\u0015\tq\u0001G\u0003\u00022e\u00051\u0011\r]1dQ\u0016T\u0011aM\u0001\u0004_J<\u0017BA\u001b-\u0005yqu\u000eZ3U_\u000e{g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'/A\u0004nKR\u0014\u0018nY:\u0011\u0005aZT\"A\u001d\u000b\u0005YR$BA\u00170\u0013\ta\u0014HA\u0004NKR\u0014\u0018nY:\u0002\rqJg.\u001b;?)\ry\u0004)\u0011\t\u00031\u0001AQ!K\u0002A\u0002)BQAN\u0002A\u0002]\n\u0001DZ8so\u0006\u0014H-\u001b8h\u001b\u0006t\u0017mZ3s\u001b\u0016$(/[2t+\u0005!\u0005CA#H\u001b\u00051%B\u0001\u001c/\u0013\tAeI\u0001\rG_J<\u0018M\u001d3j]\u001el\u0015M\\1hKJlU\r\u001e:jGN\f\u0011DZ8so\u0006\u0014H-\u001b8h\u001b\u0006t\u0017mZ3s\u001b\u0016$(/[2tA\u0005qam\u001c:xCJ$'+Z9vKN$Hc\u0002'P/~#\u0017.\u001f\t\u0003%5K!AT\n\u0003\tUs\u0017\u000e\u001e\u0005\u0006!\u001a\u0001\r!U\u0001\u000fe\u0016\fX/Z:u\u0007>tG/\u001a=u!\t\u0011V+D\u0001T\u0015\t!&(\u0001\u0005sKF,Xm\u001d;t\u0013\t16K\u0001\bSKF,Xm\u001d;D_:$X\r\u001f;\t\u000ba3\u0001\u0019A-\u0002#I,\u0017/^3ti\n+hMZ3s\u0007>\u0004\u0018\u0010\u0005\u0002[;6\t1L\u0003\u0002]?\u0005\u0019a.[8\n\u0005y[&A\u0003\"zi\u0016\u0014UO\u001a4fe\")\u0001M\u0002a\u0001C\u0006\t\"/Z9vKN$8I]3bi&|gNT:\u0011\u0005I\u0011\u0017BA2\u0014\u0005\u0011auN\\4\t\u000b\u00154\u0001\u0019\u00014\u0002\u0017I,\u0017/^3ti\n{G-\u001f\t\u0003%\u001eL!\u0001[*\u0003\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgRDQA\u001b\u0004A\u0002-\fqB]3rk\u0016\u001cH\u000fV8TiJLgn\u001a\t\u0004%1t\u0017BA7\u0014\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0002pm:\u0011\u0001\u000f\u001e\t\u0003cNi\u0011A\u001d\u0006\u0003g>\ta\u0001\u0010:p_Rt\u0014BA;\u0014\u0003\u0019\u0001&/\u001a3fM&\u0011q\u000f\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005U\u001c\u0002\"\u0002>\u0007\u0001\u0004Y\u0018\u0001\u0005:fgB|gn]3DC2d'-Y2l!\u0011\u0011BP '\n\u0005u\u001c\"!\u0003$v]\u000e$\u0018n\u001c82!\u0011\u0011r0a\u0001\n\u0007\u0005\u00051C\u0001\u0004PaRLwN\u001c\t\u0004%\u0006\u0015\u0011bAA\u0004'\n\u0001\u0012IY:ue\u0006\u001cGOU3ta>t7/Z\u0001\u0006G2|7/\u001a\u000b\u0002\u0019\u0006)2m\u001c8ue>dG.\u001a:Ba&4VM]:j_:\u001cXCAA\t!\u0019\t\u0019\"!\u0007\u0002\u001e5\u0011\u0011Q\u0003\u0006\u0004\u0003/y\u0012\u0001B;uS2LA!a\u0007\u0002\u0016\tAq\n\u001d;j_:\fG\u000e\u0005\u0003\u0002 \u0005\u0015RBAA\u0011\u0015\r\t\u0019cL\u0001\bG2LWM\u001c;t\u0013\u0011\t9#!\t\u0003\u001f9{G-Z!qSZ+'o]5p]N\fQ\u0002]1sg\u0016\u0014Vm\u001d9p]N,G\u0003CA\u0002\u0003[\t\t$!\u000e\t\r\u0005=\u0012\u00021\u0001Z\u0003\u0019\u0011WO\u001a4fe\"1\u00111G\u0005A\u0002\u0019\fqA]3rk\u0016\u001cH\u000fC\u0004\u00028%\u0001\r!!\u000f\u0002\r!,\u0017\rZ3s!\r\u0011\u00161H\u0005\u0004\u0003{\u0019&!\u0004*fcV,7\u000f\u001e%fC\u0012,'\u000f")
public class ForwardingManagerImpl
implements ForwardingManager,
AutoCloseable,
Logging {
    public final NodeToControllerChannelManager kafka$server$ForwardingManagerImpl$$channelManager;
    private final ForwardingManagerMetrics forwardingManagerMetrics;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public void forwardRequest(RequestChannel.Request originalRequest, Function1<Option<AbstractResponse>, BoxedUnit> responseCallback) {
        ForwardingManager.forwardRequest$(this, originalRequest, responseCallback);
    }

    @Override
    public void forwardRequest(RequestChannel.Request originalRequest, AbstractRequest newRequestBody, Function1<Option<AbstractResponse>, BoxedUnit> responseCallback) {
        ForwardingManager.forwardRequest$(this, originalRequest, newRequestBody, responseCallback);
    }

    private Logger logger$lzycompute() {
        ForwardingManagerImpl forwardingManagerImpl = this;
        synchronized (forwardingManagerImpl) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ForwardingManagerMetrics forwardingManagerMetrics() {
        return this.forwardingManagerMetrics;
    }

    @Override
    public void forwardRequest(RequestContext requestContext, ByteBuffer requestBufferCopy, long requestCreationNs, AbstractRequest requestBody, Function0<String> requestToString, Function1<Option<AbstractResponse>, BoxedUnit> responseCallback) {
        EnvelopeRequest.Builder envelopeRequest = ForwardingManager$.MODULE$.buildEnvelopeRequest(requestContext, requestBufferCopy);
        long requestCreationTimeMs = TimeUnit.NANOSECONDS.toMillis(requestCreationNs);
        this.forwardingManagerMetrics().incrementQueueLength();
        public class Kafka_server_ForwardingManagerImpl$ForwardingResponseHandler$1
        implements ControllerRequestCompletionHandler {
            private final /* synthetic */ ForwardingManagerImpl $outer;
            private final long requestCreationTimeMs$1;
            private final Function0 requestToString$1;
            private final Function1 responseCallback$1;
            private final AbstractRequest requestBody$1;
            private final RequestContext requestContext$1;

            public void onComplete(ClientResponse clientResponse) {
                AbstractResponse abstractResponse;
                Errors envelopeError;
                this.$outer.forwardingManagerMetrics().decrementQueueLength();
                this.$outer.forwardingManagerMetrics().remoteTimeMsHist().record(clientResponse.requestLatencyMs());
                this.$outer.forwardingManagerMetrics().queueTimeMsHist().record(clientResponse.receivedTimeMs() - clientResponse.requestLatencyMs() - this.requestCreationTimeMs$1);
                if (clientResponse.versionMismatch() != null) {
                    this.$outer.debug((Function0<String> & Serializable)() -> "Returning `UNKNOWN_SERVER_ERROR` in response to " + $this.requestToString$1.apply() + " due to unexpected version error", (Function0<Throwable>)(Function0<UnsupportedVersionException> & Serializable)() -> clientResponse.versionMismatch());
                    this.responseCallback$1.apply(new Some<AbstractResponse>(this.requestBody$1.getErrorResponse((Throwable)Errors.UNKNOWN_SERVER_ERROR.exception())));
                    return;
                }
                if (clientResponse.authenticationException() != null) {
                    this.$outer.debug((Function0<String> & Serializable)() -> "Returning `UNKNOWN_SERVER_ERROR` in response to " + $this.requestToString$1.apply() + " due to authentication error", (Function0<Throwable>)(Function0<AuthenticationException> & Serializable)() -> clientResponse.authenticationException());
                    this.responseCallback$1.apply(new Some<AbstractResponse>(this.requestBody$1.getErrorResponse((Throwable)Errors.UNKNOWN_SERVER_ERROR.exception())));
                    return;
                }
                EnvelopeResponse envelopeResponse = (EnvelopeResponse)clientResponse.responseBody();
                Errors errors = envelopeError = envelopeResponse.error();
                Errors errors2 = Errors.UNSUPPORTED_VERSION;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    this.responseCallback$1.apply(None$.MODULE$);
                    return;
                }
                Errors errors3 = envelopeError;
                Errors errors4 = Errors.NONE;
                if (errors3 == null ? errors4 != null : !errors3.equals(errors4)) {
                    this.$outer.debug((Function0<String> & Serializable)() -> "Forwarded request " + $this.requestToString$1.apply() + " failed with an error in the envelope response " + envelopeError);
                    abstractResponse = this.requestBody$1.getErrorResponse((Throwable)Errors.UNKNOWN_SERVER_ERROR.exception());
                } else {
                    abstractResponse = this.$outer.kafka$server$ForwardingManagerImpl$$parseResponse(envelopeResponse.responseData(), this.requestBody$1, this.requestContext$1.header);
                }
                AbstractResponse response = abstractResponse;
                this.responseCallback$1.apply(Option$.MODULE$.apply(response));
            }

            public void onTimeout() {
                this.$outer.debug((Function0<String> & Serializable)() -> "Forwarding of the request " + $this.requestToString$1.apply() + " failed due to timeout exception");
                this.$outer.forwardingManagerMetrics().decrementQueueLength();
                this.$outer.forwardingManagerMetrics().queueTimeMsHist().record(this.$outer.kafka$server$ForwardingManagerImpl$$channelManager.getTimeoutMs());
                AbstractResponse response = this.requestBody$1.getErrorResponse((Throwable)new TimeoutException());
                this.responseCallback$1.apply(Option$.MODULE$.apply(response));
            }

            public Kafka_server_ForwardingManagerImpl$ForwardingResponseHandler$1(ForwardingManagerImpl $outer, long requestCreationTimeMs$1, Function0 requestToString$1, Function1 responseCallback$1, AbstractRequest requestBody$1, RequestContext requestContext$1) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.requestCreationTimeMs$1 = requestCreationTimeMs$1;
                this.requestToString$1 = requestToString$1;
                this.responseCallback$1 = responseCallback$1;
                this.requestBody$1 = requestBody$1;
                this.requestContext$1 = requestContext$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$1(kafka.server.ForwardingManagerImpl$ForwardingResponseHandler$1 ), $anonfun$onComplete$2(org.apache.kafka.clients.ClientResponse ), $anonfun$onComplete$3(kafka.server.ForwardingManagerImpl$ForwardingResponseHandler$1 ), $anonfun$onComplete$4(org.apache.kafka.clients.ClientResponse ), $anonfun$onComplete$5(kafka.server.ForwardingManagerImpl$ForwardingResponseHandler$1 org.apache.kafka.common.protocol.Errors ), $anonfun$onTimeout$1(kafka.server.ForwardingManagerImpl$ForwardingResponseHandler$1 )}, serializedLambda);
            }
        }
        this.kafka$server$ForwardingManagerImpl$$channelManager.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)envelopeRequest, new Kafka_server_ForwardingManagerImpl$ForwardingResponseHandler$1(this, requestCreationTimeMs, requestToString, responseCallback, requestBody, requestContext));
    }

    @Override
    public void close() {
        this.forwardingManagerMetrics().close();
    }

    @Override
    public Optional<NodeApiVersions> controllerApiVersions() {
        return this.kafka$server$ForwardingManagerImpl$$channelManager.controllerApiVersions();
    }

    public AbstractResponse kafka$server$ForwardingManagerImpl$$parseResponse(ByteBuffer buffer, AbstractRequest request, RequestHeader header) {
        AbstractResponse abstractResponse;
        try {
            abstractResponse = AbstractResponse.parseResponse((ByteBuffer)buffer, (RequestHeader)header, (MessageContext)MessageContext.IDENTITY);
        }
        catch (Exception e) {
            this.error((Function0<String> & Serializable)() -> "Failed to parse response from envelope for request with header " + header, (Function0<Throwable>)(Function0<Exception> & Serializable)() -> e);
            abstractResponse = request.getErrorResponse((Throwable)Errors.UNKNOWN_SERVER_ERROR.exception());
        }
        return abstractResponse;
    }

    public ForwardingManagerImpl(NodeToControllerChannelManager channelManager, Metrics metrics) {
        this.kafka$server$ForwardingManagerImpl$$channelManager = channelManager;
        ForwardingManager.$init$(this);
        Logging.$init$(this);
        this.forwardingManagerMetrics = new ForwardingManagerMetrics(metrics, channelManager.getTimeoutMs());
    }
}

