/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.kafka.replication.push.ReplicationStateMetadata;
import java.util.Map;
import java.util.Optional;
import kafka.cluster.DefaultPartitionListener;
import kafka.server.PartitionFetchMetadata;
import kafka.server.ReplicaManager;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\teh\u0001\u0002&L\u0001AC\u0001B\u001c\u0001\u0003\u0002\u0004%\ta\u001c\u0005\t{\u0002\u0011\t\u0019!C\u0001}\"I\u00111\u0002\u0001\u0003\u0002\u0003\u0006K\u0001\u001d\u0005\u000b\u0003\u001b\u0001!Q1A\u0005\u0002\u0005=\u0001BCA\r\u0001\t\u0005\t\u0015!\u0003\u0002\u0012!Q\u00111\u0004\u0001\u0003\u0006\u0004%\t!!\b\t\u0015\u0005\u0015\u0002A!A!\u0002\u0013\ty\u0002C\u0004\u0002(\u0001!\t!!\u000b\t\u0013\u0005M\u0002\u00011A\u0005\u0002\u0005u\u0001\"CA\u001b\u0001\u0001\u0007I\u0011AA\u001c\u0011!\tY\u0004\u0001Q!\n\u0005}\u0001\"CA\u001f\u0001\u0001\u0007I\u0011AA \u0011%\t9\u0005\u0001a\u0001\n\u0003\tI\u0005\u0003\u0005\u0002N\u0001\u0001\u000b\u0015BA!\u0011%\ty\u0005\u0001a\u0001\n\u0003\ty\u0004C\u0005\u0002R\u0001\u0001\r\u0011\"\u0001\u0002T!A\u0011q\u000b\u0001!B\u0013\t\t\u0005C\u0005\u0002Z\u0001\u0001\r\u0011\"\u0001\u0002\u001e!I\u00111\f\u0001A\u0002\u0013\u0005\u0011Q\f\u0005\t\u0003C\u0002\u0001\u0015)\u0003\u0002 !I\u00111\r\u0001A\u0002\u0013\u0005\u0011Q\r\u0005\n\u0003s\u0002\u0001\u0019!C\u0001\u0003wB\u0001\"a \u0001A\u0003&\u0011q\r\u0005\n\u0003\u0003\u0003\u0001\u0019!C\u0001\u0003KB\u0011\"a!\u0001\u0001\u0004%\t!!\"\t\u0011\u0005%\u0005\u0001)Q\u0005\u0003OB\u0011\"a#\u0001\u0001\u0004%\t!a\u0010\t\u0013\u00055\u0005\u00011A\u0005\u0002\u0005=\u0005\u0002CAJ\u0001\u0001\u0006K!!\u0011\t\u0013\u0005U\u0005\u00011A\u0005\u0002\u0005]\u0005\"CAP\u0001\u0001\u0007I\u0011AAQ\u0011!\t)\u000b\u0001Q!\n\u0005e\u0005\"CAT\u0001\u0001\u0007I\u0011AAL\u0011%\tI\u000b\u0001a\u0001\n\u0003\tY\u000b\u0003\u0005\u00020\u0002\u0001\u000b\u0015BAM\u0011%\t\t\f\u0001a\u0001\n\u0013\ty\u0004C\u0005\u00024\u0002\u0001\r\u0011\"\u0003\u00026\"A\u0011\u0011\u0018\u0001!B\u0013\t\t\u0005C\u0005\u0002<\u0002\u0001\r\u0011\"\u0003\u0002@!I\u0011Q\u0018\u0001A\u0002\u0013%\u0011q\u0018\u0005\t\u0003\u0007\u0004\u0001\u0015)\u0003\u0002B!I\u0011Q\u0019\u0001A\u0002\u0013\u0005\u0011q\u0019\u0005\n\u0003+\u0004\u0001\u0019!C\u0001\u0003/D\u0001\"a7\u0001A\u0003&\u0011\u0011\u001a\u0005\n\u0003K\u0004\u0001\u0019!C\u0001\u0003OD\u0011\"!@\u0001\u0001\u0004%\t!a@\t\u0011\t\r\u0001\u0001)Q\u0005\u0003SD\u0011Ba\u0002\u0001\u0001\u0004%I!!\b\t\u0013\t%\u0001\u00011A\u0005\n\t-\u0001\u0002\u0003B\b\u0001\u0001\u0006K!a\b\t\u0013\tE\u0001\u00011A\u0005\n\u0005u\u0001\"\u0003B\n\u0001\u0001\u0007I\u0011\u0002B\u000b\u0011!\u0011I\u0002\u0001Q!\n\u0005}\u0001\"\u0003B\u000e\u0001\t\u0007I\u0011\u0002B\u000f\u0011!\u0011)\u0003\u0001Q\u0001\n\t}\u0001b\u0002B\u0014\u0001\u0011\u0005#\u0011\u0006\u0005\b\u0005W\u0001A\u0011\tB\u0017\u0011\u001d\u0011\t\u0004\u0001C!\u0005SAqAa\r\u0001\t\u0003\u0012)\u0004C\u0004\u0003:\u0001!\tEa\u000f\t\u000f\t}\u0002\u0001\"\u0011\u0003B!9\u0011q\u0005\u0001\u0005\u0002\t5\u0003bBA\u0014\u0001\u0011\u0005!q\u000b\u0005\b\u0005?\u0002A\u0011\tB1\u0011\u001d\u0011y\u0007\u0001C!\u0005cB\u0011B!\"\u0001#\u0003%\tAa\"\t\u000f\tu\u0005\u0001\"\u0011\u0003 \"9!\u0011\u0015\u0001\u0005\u0002\t\r\u0006b\u0002B_\u0001\u0011\u0005!q\u0018\u0005\b\u0005'\u0004A\u0011\u0001Bk\u0011\u001d\u0011i\u000f\u0001C!\u0005SAqAa<\u0001\t\u0003\u0012\t\u0010C\u0004\u0003v\u0002!\tEa>\u0003C%s7M]3nK:$\u0018\r\u001c)beRLG/[8o\r\u0016$8\r['fi\u0006$\u0017\r^1\u000b\u00051k\u0015AB:feZ,'OC\u0001O\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001A)ZUB\u0011!kV\u0007\u0002'*\u0011A+V\u0001\u0005Y\u0006twMC\u0001W\u0003\u0011Q\u0017M^1\n\u0005a\u001b&AB(cU\u0016\u001cG\u000f\u0005\u0002[O:\u00111,Z\u0007\u00029*\u0011QLX\u0001\u0006kRLGn\u001d\u0006\u0003?\u0002\faaY8n[>t'B\u0001(b\u0015\t\u00117-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002I\u0006\u0019qN]4\n\u0005\u0019d\u0016\u0001H%na2L7-\u001b;MS:\\W\r\u001a%bg\"\u001cu\u000e\u001c7fGRLwN\\\u0005\u0003Q&\u0014q!\u00127f[\u0016tGO\u0003\u0002g9B\u00111\u000e\\\u0007\u0002\u0017&\u0011Qn\u0013\u0002\u0017!\u0006\u0014H/\u001b;j_:4U\r^2i\u001b\u0016$\u0018\rZ1uC\u0006)Ao\u001c9jGV\t\u0001\u000f\u0005\u0002ru:\u0011!\u000f\u001f\t\u0003gZl\u0011\u0001\u001e\u0006\u0003k>\u000ba\u0001\u0010:p_Rt$\"A<\u0002\u000bM\u001c\u0017\r\\1\n\u0005e4\u0018A\u0002)sK\u0012,g-\u0003\u0002|y\n11\u000b\u001e:j]\u001eT!!\u001f<\u0002\u0013Q|\u0007/[2`I\u0015\fHcA@\u0002\bA!\u0011\u0011AA\u0002\u001b\u00051\u0018bAA\u0003m\n!QK\\5u\u0011!\tIAAA\u0001\u0002\u0004\u0001\u0018a\u0001=%c\u00051Ao\u001c9jG\u0002\nq\u0001^8qS\u000eLE-\u0006\u0002\u0002\u0012A!\u00111CA\u000b\u001b\u0005q\u0016bAA\f=\n!Q+^5e\u0003!!x\u000e]5d\u0013\u0012\u0004\u0013!\u00039beRLG/[8o+\t\ty\u0002\u0005\u0003\u0002\u0002\u0005\u0005\u0012bAA\u0012m\n\u0019\u0011J\u001c;\u0002\u0015A\f'\u000f^5uS>t\u0007%\u0001\u0004=S:LGO\u0010\u000b\t\u0003W\ti#a\f\u00022A\u00111\u000e\u0001\u0005\u0006]\"\u0001\r\u0001\u001d\u0005\b\u0003\u001bA\u0001\u0019AA\t\u0011\u001d\tY\u0002\u0003a\u0001\u0003?\t\u0011B]3qY&\u001c\u0017-\u00133\u0002\u001bI,\u0007\u000f\\5dC&#w\fJ3r)\ry\u0018\u0011\b\u0005\n\u0003\u0013Q\u0011\u0011!a\u0001\u0003?\t!B]3qY&\u001c\u0017-\u00133!\u0003-1W\r^2i\u001f\u001a47/\u001a;\u0016\u0005\u0005\u0005\u0003\u0003BA\u0001\u0003\u0007J1!!\u0012w\u0005\u0011auN\\4\u0002\u001f\u0019,Go\u00195PM\u001a\u001cX\r^0%KF$2a`A&\u0011%\tI!DA\u0001\u0002\u0004\t\t%\u0001\u0007gKR\u001c\u0007n\u00144gg\u0016$\b%A\u0006ti\u0006\u0014Ho\u00144gg\u0016$\u0018aD:uCJ$xJ\u001a4tKR|F%Z9\u0015\u0007}\f)\u0006C\u0005\u0002\nA\t\t\u00111\u0001\u0002B\u0005a1\u000f^1si>3gm]3uA\u0005AQ.\u0019=CsR,7/\u0001\u0007nCb\u0014\u0015\u0010^3t?\u0012*\u0017\u000fF\u0002\u0000\u0003?B\u0011\"!\u0003\u0014\u0003\u0003\u0005\r!a\b\u0002\u00135\f\u0007PQ=uKN\u0004\u0013AE2veJ,g\u000e\u001e'fC\u0012,'/\u00129pG\",\"!a\u001a\u0011\r\u0005%\u0014qNA:\u001b\t\tYGC\u0002\u0002nU\u000bA!\u001e;jY&!\u0011\u0011OA6\u0005!y\u0005\u000f^5p]\u0006d\u0007c\u0001*\u0002v%\u0019\u0011qO*\u0003\u000f%sG/Z4fe\u000612-\u001e:sK:$H*Z1eKJ,\u0005o\\2i?\u0012*\u0017\u000fF\u0002\u0000\u0003{B\u0011\"!\u0003\u0017\u0003\u0003\u0005\r!a\u001a\u0002'\r,(O]3oi2+\u0017\rZ3s\u000bB|7\r\u001b\u0011\u0002!1\f7\u000f\u001e$fi\u000eDW\rZ#q_\u000eD\u0017\u0001\u00067bgR4U\r^2iK\u0012,\u0005o\\2i?\u0012*\u0017\u000fF\u0002\u0000\u0003\u000fC\u0011\"!\u0003\u001a\u0003\u0003\u0005\r!a\u001a\u0002#1\f7\u000f\u001e$fi\u000eDW\rZ#q_\u000eD\u0007%\u0001\u000bsKBd\u0017nY1uS>t7+Z:tS>t\u0017\nZ\u0001\u0019e\u0016\u0004H.[2bi&|gnU3tg&|g.\u00133`I\u0015\fHcA@\u0002\u0012\"I\u0011\u0011\u0002\u000f\u0002\u0002\u0003\u0007\u0011\u0011I\u0001\u0016e\u0016\u0004H.[2bi&|gnU3tg&|g.\u00133!\u0003Q1W\r^2i\u001b\u0016$\u0018\rZ1uCV\u0003H-\u0019;fIV\u0011\u0011\u0011\u0014\t\u0005\u0003\u0003\tY*C\u0002\u0002\u001eZ\u0014qAQ8pY\u0016\fg.\u0001\rgKR\u001c\u0007.T3uC\u0012\fG/Y+qI\u0006$X\rZ0%KF$2a`AR\u0011%\tIaHA\u0001\u0002\u0004\tI*A\u000bgKR\u001c\u0007.T3uC\u0012\fG/Y+qI\u0006$X\r\u001a\u0011\u00023\r,(O]3oi2+\u0017\rZ3s\u000bB|7\r[+qI\u0006$X\rZ\u0001\u001eGV\u0014(/\u001a8u\u0019\u0016\fG-\u001a:Fa>\u001c\u0007.\u00169eCR,Gm\u0018\u0013fcR\u0019q0!,\t\u0013\u0005%!%!AA\u0002\u0005e\u0015AG2veJ,g\u000e\u001e'fC\u0012,'/\u00129pG\",\u0006\u000fZ1uK\u0012\u0004\u0013!\u00067bgRD\u0015n\u001a5XCR,'/\\1sWN+g\u000e^\u0001\u001aY\u0006\u001cH\u000fS5hQ^\u000bG/\u001a:nCJ\\7+\u001a8u?\u0012*\u0017\u000fF\u0002\u0000\u0003oC\u0011\"!\u0003&\u0003\u0003\u0005\r!!\u0011\u0002-1\f7\u000f\u001e%jO\"<\u0016\r^3s[\u0006\u00148nU3oi\u0002\na\u0003\\1ti2{wm\u0015;beR|eMZ:fiN+g\u000e^\u0001\u001bY\u0006\u001cH\u000fT8h'R\f'\u000f^(gMN,GoU3oi~#S-\u001d\u000b\u0004\u007f\u0006\u0005\u0007\"CA\u0005Q\u0005\u0005\t\u0019AA!\u0003]a\u0017m\u001d;M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;TK:$\b%\u0001\reK\u001a\fW\u000f\u001c;QCJ$\u0018\u000e^5p]2K7\u000f^3oKJ,\"!!3\u0011\t\u0005-\u0017\u0011[\u0007\u0003\u0003\u001bT1!a4N\u0003\u001d\u0019G.^:uKJLA!a5\u0002N\nAB)\u001a4bk2$\b+\u0019:uSRLwN\u001c'jgR,g.\u001a:\u00029\u0011,g-Y;miB\u000b'\u000f^5uS>tG*[:uK:,'o\u0018\u0013fcR\u0019q0!7\t\u0013\u0005%1&!AA\u0002\u0005%\u0017!\u00073fM\u0006,H\u000e\u001e)beRLG/[8o\u0019&\u001cH/\u001a8fe\u0002B3\u0001LAp!\u0011\t\t!!9\n\u0007\u0005\rhO\u0001\u0005w_2\fG/\u001b7f\u0003M1W\r^2i\u001f\u001a47/\u001a;NKR\fG-\u0019;b+\t\tI\u000f\u0005\u0003\u0002l\u0006eXBAAw\u0015\u0011\ty/!=\u0002\u00071|wM\u0003\u0003\u0002t\u0006U\u0018!C5oi\u0016\u0014h.\u00197t\u0015\r\t9\u0010Y\u0001\bgR|'/Y4f\u0013\u0011\tY0!<\u0003#1{wm\u00144gg\u0016$X*\u001a;bI\u0006$\u0018-A\fgKR\u001c\u0007n\u00144gg\u0016$X*\u001a;bI\u0006$\u0018m\u0018\u0013fcR\u0019qP!\u0001\t\u0013\u0005%a&!AA\u0002\u0005%\u0018\u0001\u00064fi\u000eDwJ\u001a4tKRlU\r^1eCR\f\u0007\u0005K\u00020\u0003?\f!bY1dQ\u0016$g*\u001a=u\u00039\u0019\u0017m\u00195fI:+\u0007\u0010^0%KF$2a B\u0007\u0011%\tI!MA\u0001\u0002\u0004\ty\"A\u0006dC\u000eDW\r\u001a(fqR\u0004\u0013AC2bG\",G\r\u0015:fm\u0006q1-Y2iK\u0012\u0004&/\u001a<`I\u0015\fHcA@\u0003\u0018!I\u0011\u0011\u0002\u001b\u0002\u0002\u0003\u0007\u0011qD\u0001\fG\u0006\u001c\u0007.\u001a3Qe\u00164\b%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0005\t}\u0001\u0003BA\n\u0005CI1Aa\t_\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u0005]\u0016DH\u000f\u0006\u0002\u0002 \u000591/\u001a;OKb$HcA@\u00030!9!qE\u001dA\u0002\u0005}\u0011\u0001\u00029sKZ\fqa]3u!J,g\u000fF\u0002\u0000\u0005oAqA!\r<\u0001\u0004\ty\"\u0001\ftKR4U\r^2i\u001f\u001a47/\u001a;NKR\fG-\u0019;b)\ry(Q\b\u0005\b\u0003Kd\u0004\u0019AAu\u0003M)G.Z7f]R\\U-_:Be\u0016,\u0015/^1m)\u0011\tIJa\u0011\t\u000f\t\u0015S\b1\u0001\u0003H\u0005!A\u000f[1u!\u0011\t\tA!\u0013\n\u0007\t-cOA\u0002B]f$B!a\u000b\u0003P!9\u00111\u0004 A\u0002\tE\u0003\u0003BA\n\u0005'J1A!\u0016_\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0004\u0002,\te#1\f\u0005\b\u00037y\u0004\u0019\u0001B)\u0011\u0019\u0011if\u0010a\u0001U\u0006)\u0002/\u0019:uSRLwN\u001c$fi\u000eD'+Z9vKN$\u0018aF7bs\n,'+Z4jgR,'/Q:MSN$XM\\3s)\u0015y(1\rB3\u0011\u001d\t\u0019\u0004\u0011a\u0001\u0003?AqAa\u001aA\u0001\u0004\u0011I'\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\u0007-\u0014Y'C\u0002\u0003n-\u0013aBU3qY&\u001c\u0017-T1oC\u001e,'/\u0001\u0006jg\u000e\u000bWo\u001a5u+B$B!!'\u0003t!I!QO!\u0011\u0002\u0003\u0007!qO\u0001\nSN|G.\u0019;j_:\u0004BA!\u001f\u0003\u00026\u0011!1\u0010\u0006\u0005\u0003_\u0014iH\u0003\u0003\u0002x\n}$B\u0001'a\u0013\u0011\u0011\u0019Ia\u001f\u0003\u001d\u0019+Go\u00195Jg>d\u0017\r^5p]\u0006!\u0012n]\"bk\u001eDG/\u00169%I\u00164\u0017-\u001e7uIE*\"A!#+\t\t]$1R\u0016\u0003\u0005\u001b\u0003BAa$\u0003\u001a6\u0011!\u0011\u0013\u0006\u0005\u0005'\u0013)*A\u0005v]\u000eDWmY6fI*\u0019!q\u0013<\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u001c\nE%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006)1\r\\8tKR\tq0A\nva\u0012\fG/\u001a*fcV,7\u000f\u001e)be\u0006l7\u000fF\u0002\u0000\u0005KCqAa*E\u0001\u0004\u0011I+\u0001\bgKR\u001c\u0007\u000eU1si&$\u0018n\u001c8\u0011\t\t-&q\u0017\b\u0005\u0005[\u0013\u0019,\u0004\u0002\u00030*\u0019!\u0011\u00170\u0002\u000f5,7o]1hK&!!Q\u0017BX\u0003A1U\r^2i%\u0016\fX/Z:u\t\u0006$\u0018-\u0003\u0003\u0003:\nm&A\u0004$fi\u000eD\u0007+\u0019:uSRLwN\u001c\u0006\u0005\u0005k\u0013y+A\fnCf\u0014WMU3t_24X-\u00168l]><hNT1nKR\u0019qP!1\t\u000f\t\rW\t1\u0001\u0003F\u0006QAo\u001c9jG:\u000bW.Z:\u0011\t\t\u001d'Q\u001a\b\u0004W\n%\u0017b\u0001Bf\u0017\u0006aa)\u001a;dQN+7o]5p]&!!q\u001aBi\u00059!v\nU%D?:\u000bU*R0N\u0003BS1Aa3L\u0003]i\u0017-\u001f2f+B$\u0017\r^3SKN\u0004xN\\:f\t\u0006$\u0018\r\u0006\u0004\u0002\u001a\n]'\u0011\u001e\u0005\b\u000534\u0005\u0019\u0001Bn\u0003!\u0011Xm\u001d9ECR\f\u0007\u0003\u0002Bo\u0005GtAA!,\u0003`&!!\u0011\u001dBX\u0003E1U\r^2i%\u0016\u001c\bo\u001c8tK\u0012\u000bG/Y\u0005\u0005\u0005K\u00149OA\u0007QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u0006\u0005\u0005C\u0014y\u000bC\u0004\u0003l\u001a\u0003\r!!'\u0002\rU\u0004H-\u0019;f\u0003!A\u0017m\u001d5D_\u0012,\u0017AB3rk\u0006d7\u000f\u0006\u0003\u0002\u001a\nM\bb\u0002B#\u0011\u0002\u0007!qI\u0001\ti>\u001cFO]5oOR\t\u0001\u000f")
public class IncrementalPartitionFetchMetadata
implements ImplicitLinkedHashCollection.Element,
PartitionFetchMetadata {
    private String topic;
    private final Uuid topicId;
    private final int partition;
    private int replicaId;
    private long fetchOffset;
    private long startOffset;
    private int maxBytes;
    private Optional<Integer> currentLeaderEpoch;
    private Optional<Integer> lastFetchedEpoch;
    private long replicationSessionId;
    private boolean fetchMetadataUpdated;
    private boolean currentLeaderEpochUpdated;
    private long lastHighWatermarkSent;
    private long lastLogStartOffsetSent;
    private volatile DefaultPartitionListener defaultPartitionListener;
    private volatile LogOffsetMetadata fetchOffsetMetadata;
    private int cachedNext;
    private int cachedPrev;
    private final TopicPartition topicPartition;

    public String topic() {
        return this.topic;
    }

    public void topic_$eq(String x$1) {
        this.topic = x$1;
    }

    @Override
    public Uuid topicId() {
        return this.topicId;
    }

    public int partition() {
        return this.partition;
    }

    public int replicaId() {
        return this.replicaId;
    }

    public void replicaId_$eq(int x$1) {
        this.replicaId = x$1;
    }

    @Override
    public long fetchOffset() {
        return this.fetchOffset;
    }

    public void fetchOffset_$eq(long x$1) {
        this.fetchOffset = x$1;
    }

    @Override
    public long startOffset() {
        return this.startOffset;
    }

    public void startOffset_$eq(long x$1) {
        this.startOffset = x$1;
    }

    @Override
    public int maxBytes() {
        return this.maxBytes;
    }

    public void maxBytes_$eq(int x$1) {
        this.maxBytes = x$1;
    }

    @Override
    public Optional<Integer> currentLeaderEpoch() {
        return this.currentLeaderEpoch;
    }

    public void currentLeaderEpoch_$eq(Optional<Integer> x$1) {
        this.currentLeaderEpoch = x$1;
    }

    @Override
    public Optional<Integer> lastFetchedEpoch() {
        return this.lastFetchedEpoch;
    }

    public void lastFetchedEpoch_$eq(Optional<Integer> x$1) {
        this.lastFetchedEpoch = x$1;
    }

    @Override
    public long replicationSessionId() {
        return this.replicationSessionId;
    }

    public void replicationSessionId_$eq(long x$1) {
        this.replicationSessionId = x$1;
    }

    @Override
    public boolean fetchMetadataUpdated() {
        return this.fetchMetadataUpdated;
    }

    public void fetchMetadataUpdated_$eq(boolean x$1) {
        this.fetchMetadataUpdated = x$1;
    }

    public boolean currentLeaderEpochUpdated() {
        return this.currentLeaderEpochUpdated;
    }

    public void currentLeaderEpochUpdated_$eq(boolean x$1) {
        this.currentLeaderEpochUpdated = x$1;
    }

    private long lastHighWatermarkSent() {
        return this.lastHighWatermarkSent;
    }

    private void lastHighWatermarkSent_$eq(long x$1) {
        this.lastHighWatermarkSent = x$1;
    }

    private long lastLogStartOffsetSent() {
        return this.lastLogStartOffsetSent;
    }

    private void lastLogStartOffsetSent_$eq(long x$1) {
        this.lastLogStartOffsetSent = x$1;
    }

    public DefaultPartitionListener defaultPartitionListener() {
        return this.defaultPartitionListener;
    }

    public void defaultPartitionListener_$eq(DefaultPartitionListener x$1) {
        this.defaultPartitionListener = x$1;
    }

    @Override
    public LogOffsetMetadata fetchOffsetMetadata() {
        return this.fetchOffsetMetadata;
    }

    public void fetchOffsetMetadata_$eq(LogOffsetMetadata x$1) {
        this.fetchOffsetMetadata = x$1;
    }

    private int cachedNext() {
        return this.cachedNext;
    }

    private void cachedNext_$eq(int x$1) {
        this.cachedNext = x$1;
    }

    private int cachedPrev() {
        return this.cachedPrev;
    }

    private void cachedPrev_$eq(int x$1) {
        this.cachedPrev = x$1;
    }

    private TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public int next() {
        return this.cachedNext();
    }

    public void setNext(int next) {
        this.cachedNext_$eq(next);
    }

    public int prev() {
        return this.cachedPrev();
    }

    public void setPrev(int prev) {
        this.cachedPrev_$eq(prev);
    }

    @Override
    public void setFetchOffsetMetadata(LogOffsetMetadata fetchOffsetMetadata) {
        this.fetchOffsetMetadata_$eq(fetchOffsetMetadata);
    }

    public boolean elementKeysAreEqual(Object that) {
        Object object = that;
        if (object instanceof IncrementalPartitionFetchMetadata) {
            IncrementalPartitionFetchMetadata incrementalPartitionFetchMetadata = (IncrementalPartitionFetchMetadata)object;
            Uuid uuid = this.topicId();
            Uuid uuid2 = Uuid.ZERO_UUID;
            if (uuid == null ? uuid2 != null : !uuid.equals(uuid2)) {
                return ((Object)BoxesRunTime.boxToInteger(this.partition())).equals(BoxesRunTime.boxToInteger(incrementalPartitionFetchMetadata.partition())) && this.topicId().equals((Object)incrementalPartitionFetchMetadata.topicId());
            }
            return ((Object)BoxesRunTime.boxToInteger(this.partition())).equals(BoxesRunTime.boxToInteger(incrementalPartitionFetchMetadata.partition())) && this.topic().equals(incrementalPartitionFetchMetadata.topic());
        }
        return false;
    }

    @Override
    public void maybeRegisterAsListener(int replicaId, ReplicaManager replicaManager) {
        this.replicaId_$eq(replicaId);
        if (this.defaultPartitionListener() == null) {
            this.defaultPartitionListener_$eq(replicaManager.defaultPartitionListener(this.topicPartition()));
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isCaughtUp(FetchIsolation isolation) {
        DefaultPartitionListener listener = this.defaultPartitionListener();
        if (listener == null || listener.failed() || listener.deleted()) {
            this.defaultPartitionListener_$eq(null);
            return false;
        }
        if (this.replicaId() == -1) {
            FetchIsolation fetchIsolation = isolation;
            FetchIsolation fetchIsolation2 = FetchIsolation.HIGH_WATERMARK;
            if ((fetchIsolation != null ? !((Object)((Object)fetchIsolation)).equals((Object)fetchIsolation2) : fetchIsolation2 != null) || this.fetchOffset() != listener.highWatermark()) {
                FetchIsolation fetchIsolation3 = isolation;
                FetchIsolation fetchIsolation4 = FetchIsolation.TXN_COMMITTED;
                if (fetchIsolation3 == null) {
                    if (fetchIsolation4 != null) {
                        return false;
                    }
                } else if (!((Object)((Object)fetchIsolation3)).equals((Object)fetchIsolation4)) return false;
                if (this.fetchOffset() != listener.lastStableOffset()) return false;
            }
            if (this.lastHighWatermarkSent() != listener.highWatermark()) return false;
            if (this.lastLogStartOffsetSent() != listener.startOffset()) return false;
            if (!this.currentLeaderEpoch().equals(RequestUtils.getLeaderEpoch((int)listener.currentLeaderEpoch()))) return false;
            return true;
        }
        if (this.fetchOffset() != listener.endOffset()) return false;
        if (this.lastHighWatermarkSent() != listener.highWatermark()) return false;
        if (this.lastLogStartOffsetSent() != listener.startOffset()) return false;
        if (!this.currentLeaderEpoch().equals(RequestUtils.getLeaderEpoch((int)listener.currentLeaderEpoch()))) return false;
        if (!listener.isr().contains(BoxesRunTime.boxToInteger(this.replicaId()))) return false;
        if (!listener.isPushReplicationSupported()) return true;
        if (ReplicationStateMetadata.replicationSessionIdSupportsPushTransition(this.replicationSessionId())) return false;
        return true;
    }

    @Override
    public FetchIsolation isCaughtUp$default$1() {
        return FetchIsolation.HIGH_WATERMARK;
    }

    @Override
    public void close() {
        this.defaultPartitionListener_$eq(null);
    }

    public void updateRequestParams(FetchRequestData.FetchPartition fetchPartition) {
        if (this.fetchOffset() != fetchPartition.fetchOffset()) {
            this.fetchOffsetMetadata_$eq(new LogOffsetMetadata(fetchPartition.fetchOffset()));
            this.fetchOffset_$eq(fetchPartition.fetchOffset());
            this.fetchMetadataUpdated_$eq(true);
        }
        if (this.startOffset() != fetchPartition.logStartOffset()) {
            this.startOffset_$eq(fetchPartition.logStartOffset());
            this.fetchMetadataUpdated_$eq(true);
        }
        if (this.maxBytes() != fetchPartition.partitionMaxBytes()) {
            this.maxBytes_$eq(fetchPartition.partitionMaxBytes());
            this.fetchMetadataUpdated_$eq(true);
        }
        Optional newCurrentLeaderEpoch = RequestUtils.getLeaderEpoch((int)fetchPartition.currentLeaderEpoch());
        if (!this.currentLeaderEpoch().equals(newCurrentLeaderEpoch)) {
            this.currentLeaderEpoch_$eq(newCurrentLeaderEpoch);
            this.currentLeaderEpochUpdated_$eq(true);
            this.fetchMetadataUpdated_$eq(true);
        }
        Optional newLastFetchedEpoch = RequestUtils.getLeaderEpoch((int)fetchPartition.lastFetchedEpoch());
        if (!this.lastFetchedEpoch().equals(newLastFetchedEpoch)) {
            this.lastFetchedEpoch_$eq(newLastFetchedEpoch);
            this.fetchMetadataUpdated_$eq(true);
        }
        if (this.replicationSessionId() != fetchPartition.replicationSessionId()) {
            this.replicationSessionId_$eq(fetchPartition.replicationSessionId());
            this.fetchMetadataUpdated_$eq(true);
            return;
        }
    }

    public void maybeResolveUnknownName(Map<Uuid, String> topicNames) {
        if (this.topic() == null) {
            this.topic_$eq(topicNames.get(this.topicId()));
            return;
        }
    }

    public boolean maybeUpdateResponseData(FetchResponseData.PartitionData respData, boolean update) {
        boolean mustRespond;
        block10: {
            mustRespond = false;
            if (FetchResponse.recordsSize((FetchResponseData.PartitionData)respData) > 0) {
                mustRespond = true;
            }
            if (this.lastHighWatermarkSent() != respData.highWatermark()) {
                mustRespond = true;
                if (update) {
                    this.lastHighWatermarkSent_$eq(respData.highWatermark());
                }
            }
            if (this.lastLogStartOffsetSent() != respData.logStartOffset()) {
                mustRespond = true;
                if (update) {
                    this.lastLogStartOffsetSent_$eq(respData.logStartOffset());
                }
            }
            if (FetchResponse.isPreferredReplica((FetchResponseData.PartitionData)respData)) {
                mustRespond = true;
            }
            if (respData.errorCode() != Errors.NONE.code()) {
                if (update) {
                    this.lastHighWatermarkSent_$eq(-1L);
                    this.lastLogStartOffsetSent_$eq(-1L);
                }
                mustRespond = true;
            }
            if (FetchResponse.isDivergingEpoch((FetchResponseData.PartitionData)respData)) {
                mustRespond = true;
            }
            if (this.currentLeaderEpochUpdated()) {
                mustRespond = true;
            }
            if (!update) break block10;
            this.fetchMetadataUpdated_$eq(false);
            this.currentLeaderEpochUpdated_$eq(false);
        }
        return mustRespond;
    }

    public int hashCode() {
        Uuid uuid = this.topicId();
        Uuid uuid2 = Uuid.ZERO_UUID;
        if (uuid == null ? uuid2 != null : !uuid.equals(uuid2)) {
            return 31 * this.partition() + this.topicId().hashCode();
        }
        return 31 * this.partition() + this.topic().hashCode();
    }

    public boolean equals(Object that) {
        Object object = that;
        if (object instanceof IncrementalPartitionFetchMetadata) {
            IncrementalPartitionFetchMetadata incrementalPartitionFetchMetadata = (IncrementalPartitionFetchMetadata)object;
            return this == incrementalPartitionFetchMetadata;
        }
        return false;
    }

    public synchronized String toString() {
        return "IncrementalPartitionFetchMetadata(topic=" + this.topic() + ", topicId=" + this.topicId() + ", partition=" + this.partition() + ", fetchOffset=" + this.fetchOffset() + ", startOffset=" + this.startOffset() + ", maxBytes=" + this.maxBytes() + ", currentLeaderEpoch=" + this.currentLeaderEpoch() + ", lastFetchedEpoch=" + this.lastFetchedEpoch() + ", lastSentHighWatermark=" + this.lastHighWatermarkSent() + ", lastSentLogStartOffset=" + this.lastLogStartOffsetSent() + ", fetchMetadataUpdated=" + this.fetchMetadataUpdated() + ", defaultPartitionListener=" + this.defaultPartitionListener() + ")";
    }

    public IncrementalPartitionFetchMetadata(String topic, Uuid topicId, int partition) {
        this.topic = topic;
        this.topicId = topicId;
        this.partition = partition;
        this.replicaId = -1;
        this.fetchOffset = -1L;
        this.startOffset = -1L;
        this.maxBytes = -1;
        this.currentLeaderEpoch = Optional.empty();
        this.lastFetchedEpoch = Optional.empty();
        this.replicationSessionId = -1L;
        this.fetchMetadataUpdated = false;
        this.currentLeaderEpochUpdated = false;
        this.lastHighWatermarkSent = -1L;
        this.lastLogStartOffsetSent = -1L;
        this.defaultPartitionListener = null;
        this.fetchOffsetMetadata = new LogOffsetMetadata(this.fetchOffset());
        this.cachedNext = -2;
        this.cachedPrev = -2;
        this.topicPartition = new TopicPartition(this.topic(), partition);
    }

    public IncrementalPartitionFetchMetadata(TopicIdPartition partition) {
        this(partition.topic(), partition.topicId(), partition.partition());
    }

    public IncrementalPartitionFetchMetadata(TopicIdPartition partition, PartitionFetchMetadata partitionFetchRequest) {
        this(partition.topic(), partition.topicId(), partition.partition());
        this.fetchOffset_$eq(partitionFetchRequest.fetchOffset());
        this.setFetchOffsetMetadata(new LogOffsetMetadata(this.fetchOffset()));
        this.startOffset_$eq(partitionFetchRequest.startOffset());
        this.maxBytes_$eq(partitionFetchRequest.maxBytes());
        this.currentLeaderEpoch_$eq(partitionFetchRequest.currentLeaderEpoch());
        this.lastFetchedEpoch_$eq(partitionFetchRequest.lastFetchedEpoch());
        this.replicationSessionId_$eq(partitionFetchRequest.replicationSessionId());
    }
}

