/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.k2.kafka.K2ControllerHandler;
import io.confluent.k2.kafka.K2TopicMetadata;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import kafka.network.RequestChannel;
import kafka.server.AuthHelper;
import kafka.server.ConfigAdminManager$;
import kafka.server.K2ControllerApis$ErrorDetermination$;
import kafka.server.KafkaConfig;
import kafka.server.QuotaFactory;
import kafka.server.RequestHandlerHelper;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.TopicDeletionDisabledException;
import org.apache.kafka.common.internals.Plugin;
import org.apache.kafka.common.message.AlterConfigsRequestData;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreatePartitionsResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.authorizer.Authorizer;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.MapOps;
import scala.collection.mutable.ArrayBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\rUe\u0001\u0002\u001e<\u0001\u0001C\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t)\u0002\u0011\t\u0011)A\u0005+\"A\u0001\f\u0001B\u0001B\u0003%\u0011\f\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003_\u0011!)\bA!A!\u0002\u00131\bBCA\u0005\u0001\t\u0005\t\u0015!\u0003\u0002\f!Q\u0011Q\u0003\u0001\u0003\u0002\u0003\u0006I!a\u0006\t\u0015\u00055\u0002A!A!\u0002\u0013\ty\u0003C\u0004\u0002D\u0001!\t!!\u0012\t\u0013\u0005e\u0003A1A\u0005\u0002\u0005m\u0003\u0002CA2\u0001\u0001\u0006I!!\u0018\t\u0013\u0005\u0015\u0004A1A\u0005\u0002\u0005\u001d\u0004\u0002CA8\u0001\u0001\u0006I!!\u001b\u0007\r\u0005E\u0004\u0001BA:\u0011)\t)H\u0004B\u0001B\u0003%\u0011q\u000f\u0005\u000b\u0003\u0007s!\u0011!Q\u0001\n\u0005\u0015\u0005bBA\"\u001d\u0011\u0005\u0011\u0011\u0013\u0005\n\u00037s\u0001\u0019!C\u0005\u0003;C\u0011\"a*\u000f\u0001\u0004%I!!+\t\u0011\u0005Uf\u0002)Q\u0005\u0003?Cq!a.\u000f\t\u0003\tIL\u0002\u0004\u0002<\u0002!\u0015Q\u0018\u0005\u000b\u0003/4\"Q3A\u0005\u0002\u0005e\u0007BCAq-\tE\t\u0015!\u0003\u0002\\\"Q\u00111\u001d\f\u0003\u0016\u0004%\t!!:\t\u0015\u0005]hC!E!\u0002\u0013\t9\u000fC\u0004\u0002DY!\t!!?\t\u0013\t\u0005a#!A\u0005\u0002\t\r\u0001\"\u0003B\u0005-E\u0005I\u0011\u0001B\u0006\u0011%\u0011\tCFI\u0001\n\u0003\u0011\u0019\u0003C\u0005\u0003(Y\t\t\u0011\"\u0011\u0003*!I!Q\u0007\f\u0002\u0002\u0013\u0005!q\u0007\u0005\n\u0005s1\u0012\u0011!C\u0001\u0005wA\u0011B!\u0012\u0017\u0003\u0003%\tEa\u0012\t\u0013\tUc#!A\u0005\u0002\t]\u0003\"\u0003B.-\u0005\u0005I\u0011\tB/\u0011%\u0011\tGFA\u0001\n\u0003\u0012\u0019\u0007C\u0005\u0003fY\t\t\u0011\"\u0011\u0003h!I!\u0011\u000e\f\u0002\u0002\u0013\u0005#1N\u0004\n\u0005_\u0002\u0011\u0011!E\u0005\u0005c2\u0011\"a/\u0001\u0003\u0003EIAa\u001d\t\u000f\u0005\r\u0013\u0006\"\u0001\u0003\n\"I!QM\u0015\u0002\u0002\u0013\u0015#q\r\u0005\n\u0005\u0017K\u0013\u0011!CA\u0005\u001bC\u0011Ba%*\u0003\u0003%\tI!&\t\u000f\t\r\u0006\u0001\"\u0003\u0003&\"9!q\u0019\u0001\u0005\u0002\t%\u0007b\u0002Bo\u0001\u0011\u0005!q\u001c\u0005\b\u0005G\u0004A\u0011\u0001Bs\u0011\u001d\u0011I\u000f\u0001C\u0001\u0005WDqAa<\u0001\t\u0003\u0011\t\u0010C\u0004\u0003v\u0002!IAa>\t\u000f\tm\b\u0001\"\u0003\u0003~\"91Q\u0004\u0001\u0005\n\r}\u0001bBB\u0016\u0001\u0011%1Q\u0006\u0005\b\u0007g\u0001A\u0011BB\u001b\u0011\u001d\u0019I\b\u0001C\u0005\u0007w\u0012\u0001c\u0013\u001aD_:$(o\u001c7mKJ\f\u0005/[:\u000b\u0005qj\u0014AB:feZ,'OC\u0001?\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A!H!\t\u0011U)D\u0001D\u0015\u0005!\u0015!B:dC2\f\u0017B\u0001$D\u0005\u0019\te.\u001f*fMB\u0011\u0001jS\u0007\u0002\u0013*\u0011!*P\u0001\u0006kRLGn]\u0005\u0003\u0019&\u0013q\u0001T8hO&tw-\u0001\bsKF,Xm\u001d;DQ\u0006tg.\u001a7\u0011\u0005=\u0013V\"\u0001)\u000b\u0005Ek\u0014a\u00028fi^|'o[\u0005\u0003'B\u0013aBU3rk\u0016\u001cHo\u00115b]:,G.\u0001\u0005ce>\\WM]%e!\t\u0011e+\u0003\u0002X\u0007\n\u0019\u0011J\u001c;\u0002\r\r|gNZ5h!\tQ6,D\u0001<\u0013\ta6HA\u0006LC\u001a\\\u0017mQ8oM&<\u0017\u0001E1vi\"|'/\u001b>feBcWoZ5o!\r\u0011u,Y\u0005\u0003A\u000e\u0013aa\u00149uS>t\u0007c\u00012m]6\t1M\u0003\u0002eK\u0006I\u0011N\u001c;fe:\fGn\u001d\u0006\u0003M\u001e\faaY8n[>t'B\u0001 i\u0015\tI'.\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002W\u0006\u0019qN]4\n\u00055\u001c'A\u0002)mk\u001eLg\u000e\u0005\u0002pg6\t\u0001O\u0003\u0002re\u0006Q\u0011-\u001e;i_JL'0\u001a:\u000b\u0005q:\u0017B\u0001;q\u0005)\tU\u000f\u001e5pe&TXM]\u0001\u0007cV|G/Y:\u0011\u0007]\f\u0019A\u0004\u0002y\u007f:\u0011\u0011P \b\u0003uvl\u0011a\u001f\u0006\u0003y~\na\u0001\u0010:p_Rt\u0014\"\u0001 \n\u0005qj\u0014bAA\u0001w\u0005a\u0011+^8uC\u001a\u000b7\r^8ss&!\u0011QAA\u0004\u00055\tVo\u001c;b\u001b\u0006t\u0017mZ3sg*\u0019\u0011\u0011A\u001e\u0002\tQLW.\u001a\t\u0005\u0003\u001b\t\t\"\u0004\u0002\u0002\u0010)\u0011!*Z\u0005\u0005\u0003'\tyA\u0001\u0003US6,\u0017\u0001G2p]R\u0014x\u000e\u001c7feJ+\u0017/^3ti\"\u000bg\u000e\u001a7feB!\u0011\u0011DA\u0015\u001b\t\tYBC\u0002?\u0003;QA!a\b\u0002\"\u0005\u00111N\r\u0006\u0005\u0003G\t)#A\u0005d_:4G.^3oi*\u0011\u0011qE\u0001\u0003S>LA!a\u000b\u0002\u001c\t\u00192JM\"p]R\u0014x\u000e\u001c7fe\"\u000bg\u000e\u001a7fe\u0006AQ\r_3dkR|'\u000f\u0005\u0003\u00022\u0005}RBAA\u001a\u0015\u0011\t)$a\u000e\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002:\u0005m\u0012\u0001B;uS2T!!!\u0010\u0002\t)\fg/Y\u0005\u0005\u0003\u0003\n\u0019D\u0001\u0005Fq\u0016\u001cW\u000f^8s\u0003\u0019a\u0014N\\5u}Q\u0011\u0012qIA%\u0003\u0017\ni%a\u0014\u0002R\u0005M\u0013QKA,!\tQ\u0006\u0001C\u0003N\u0013\u0001\u0007a\nC\u0003U\u0013\u0001\u0007Q\u000bC\u0003Y\u0013\u0001\u0007\u0011\fC\u0003^\u0013\u0001\u0007a\fC\u0003v\u0013\u0001\u0007a\u000fC\u0004\u0002\n%\u0001\r!a\u0003\t\u000f\u0005U\u0011\u00021\u0001\u0002\u0018!9\u0011QF\u0005A\u0002\u0005=\u0012!\u0004:fcV,7\u000f\u001e%fYB,'/\u0006\u0002\u0002^A\u0019!,a\u0018\n\u0007\u0005\u00054H\u0001\u000bSKF,Xm\u001d;IC:$G.\u001a:IK2\u0004XM]\u0001\u000fe\u0016\fX/Z:u\u0011\u0016d\u0007/\u001a:!\u0003)\tW\u000f\u001e5IK2\u0004XM]\u000b\u0003\u0003S\u00022AWA6\u0013\r\tig\u000f\u0002\u000b\u0003V$\b\u000eS3ma\u0016\u0014\u0018aC1vi\"DU\r\u001c9fe\u0002\u0012\u0011c\u00117vgR,'/Q;uQ>\u0014\u0018N_3s'\tq\u0011)\u0001\bsKF,Xm\u001d;D_:$X\r\u001f;\u0011\t\u0005e\u0014qP\u0007\u0003\u0003wR1!! f\u0003!\u0011X-];fgR\u001c\u0018\u0002BAA\u0003w\u0012aBU3rk\u0016\u001cHoQ8oi\u0016DH/A\u0005pa\u0016\u0014\u0018\r^5p]B!\u0011qQAG\u001b\t\tIIC\u0002\u0002\f\u0016\f1!Y2m\u0013\u0011\ty)!#\u0003\u0019\u0005\u001bGn\u00149fe\u0006$\u0018n\u001c8\u0015\r\u0005M\u0015qSAM!\r\t)JD\u0007\u0002\u0001!9\u0011QO\tA\u0002\u0005]\u0004bBAB#\u0001\u0007\u0011QQ\u0001\u0018Q\u0006\u001c8\t\\;ti\u0016\u0014\u0018)\u001e;i_JL'0\u0019;j_:,\"!a(\u0011\t\t{\u0016\u0011\u0015\t\u0004\u0005\u0006\r\u0016bAAS\u0007\n9!i\\8mK\u0006t\u0017a\u00075bg\u000ecWo\u001d;fe\u0006+H\u000f[8sSj\fG/[8o?\u0012*\u0017\u000f\u0006\u0003\u0002,\u0006E\u0006c\u0001\"\u0002.&\u0019\u0011qV\"\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003g\u001b\u0012\u0011!a\u0001\u0003?\u000b1\u0001\u001f\u00132\u0003aA\u0017m]\"mkN$XM]!vi\"|'/\u001b>bi&|g\u000eI\u0001\rSN\fU\u000f\u001e5pe&TX\rZ\u000b\u0003\u0003C\u0013!#\u0012:s_J$U\r^3s[&t\u0017\r^5p]N1a#QA`\u0003\u000b\u00042AQAa\u0013\r\t\u0019m\u0011\u0002\b!J|G-^2u!\u0011\t9-!5\u000f\t\u0005%\u0017Q\u001a\b\u0004u\u0006-\u0017\"\u0001#\n\u0007\u0005=7)A\u0004qC\u000e\\\u0017mZ3\n\t\u0005M\u0017Q\u001b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0004\u0003\u001f\u001c\u0015!C3se>\u00148i\u001c3f+\t\tY\u000eE\u0002C\u0003;L1!a8D\u0005\u0015\u0019\u0006n\u001c:u\u0003))'O]8s\u0007>$W\rI\u0001\rKJ\u0014xN]'fgN\fw-Z\u000b\u0003\u0003O\u0004B!!;\u0002r:!\u00111^Aw!\tQ8)C\u0002\u0002p\u000e\u000ba\u0001\u0015:fI\u00164\u0017\u0002BAz\u0003k\u0014aa\u0015;sS:<'bAAx\u0007\u0006iQM\u001d:pe6+7o]1hK\u0002\"b!a?\u0002~\u0006}\bcAAK-!9\u0011q[\u000eA\u0002\u0005m\u0007bBAr7\u0001\u0007\u0011q]\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0002|\n\u0015!q\u0001\u0005\n\u0003/d\u0002\u0013!a\u0001\u00037D\u0011\"a9\u001d!\u0003\u0005\r!a:\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!Q\u0002\u0016\u0005\u00037\u0014ya\u000b\u0002\u0003\u0012A!!1\u0003B\u000f\u001b\t\u0011)B\u0003\u0003\u0003\u0018\te\u0011!C;oG\",7m[3e\u0015\r\u0011YbQ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0010\u0005+\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"A!\n+\t\u0005\u001d(qB\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t-\u0002\u0003\u0002B\u0017\u0005gi!Aa\f\u000b\t\tE\u00121H\u0001\u0005Y\u0006tw-\u0003\u0003\u0002t\n=\u0012\u0001\u00049s_\u0012,8\r^!sSRLX#A+\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!Q\bB\"!\r\u0011%qH\u0005\u0004\u0005\u0003\u001a%aA!os\"A\u00111W\u0011\u0002\u0002\u0003\u0007Q+A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011I\u0005\u0005\u0004\u0003L\tE#QH\u0007\u0003\u0005\u001bR1Aa\u0014D\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005'\u0012iE\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAQ\u00053B\u0011\"a-$\u0003\u0003\u0005\rA!\u0010\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0005W\u0011y\u0006\u0003\u0005\u00024\u0012\n\t\u00111\u0001V\u0003!A\u0017m\u001d5D_\u0012,G#A+\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"Aa\u000b\u0002\r\u0015\fX/\u00197t)\u0011\t\tK!\u001c\t\u0013\u0005Mv%!AA\u0002\tu\u0012AE#se>\u0014H)\u001a;fe6Lg.\u0019;j_:\u00042!!&*'\u0015I#Q\u000fBA!)\u00119H! \u0002\\\u0006\u001d\u00181`\u0007\u0003\u0005sR1Aa\u001fD\u0003\u001d\u0011XO\u001c;j[\u0016LAAa \u0003z\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\t\r%qQ\u0007\u0003\u0005\u000bSA!a\n\u0002<%!\u00111\u001bBC)\t\u0011\t(A\u0003baBd\u0017\u0010\u0006\u0004\u0002|\n=%\u0011\u0013\u0005\b\u0003/d\u0003\u0019AAn\u0011\u001d\t\u0019\u000f\fa\u0001\u0003O\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u0018\n}\u0005\u0003\u0002\"`\u00053\u0003rA\u0011BN\u00037\f9/C\u0002\u0003\u001e\u000e\u0013a\u0001V;qY\u0016\u0014\u0004\"\u0003BQ[\u0005\u0005\t\u0019AA~\u0003\rAH\u0005M\u0001\u0010e\u0016\u001cwN\u001d3OK^,%O]8sgRA\u00111\u0016BT\u0005g\u0013i\fC\u0004\u0003*:\u0002\rAa+\u0002#\u0019L'o\u001d;FeJ|'OQ=U_BL7\r\u0005\u0005\u0003.\n=\u0016q]A~\u001b\t\t9$\u0003\u0003\u00032\u0006]\"aA'ba\"9!Q\u0017\u0018A\u0002\t]\u0016AD1gM\u0016\u001cG/\u001a3U_BL7m\u001d\t\u0007\u0005\u0017\u0012I,a:\n\t\tm&Q\n\u0002\u0004'\u0016$\bb\u0002B`]\u0001\u0007!\u0011Y\u0001\u001bKJ\u0014xN\u001d#fi\u0016\u0014X.\u001b8bi&|gnU;qa2LWM\u001d\t\u0006\u0005\n\r\u00171`\u0005\u0004\u0005\u000b\u001c%!\u0003$v]\u000e$\u0018n\u001c81\u0003eA\u0017M\u001c3mK\u000e\u0013X-\u0019;f)>\u0004\u0018nY:SKF,Xm\u001d;\u0015\t\u0005-&1\u001a\u0005\b\u0005\u001b|\u0003\u0019\u0001Bh\u0003\u001d\u0011X-];fgR\u0004BA!5\u0003X:\u0019qJa5\n\u0007\tU\u0007+\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\n\t\te'1\u001c\u0002\b%\u0016\fX/Z:u\u0015\r\u0011)\u000eU\u0001%Q\u0006tG\r\\3J]\u000e\u0014X-\\3oi\u0006d\u0017\t\u001c;fe\u000e{gNZ5hgJ+\u0017/^3tiR!\u00111\u0016Bq\u0011\u001d\u0011i\r\ra\u0001\u0005\u001f\fq\u0004[1oI2,G*Z4bGf\fE\u000e^3s\u0007>tg-[4t%\u0016\fX/Z:u)\u0011\tYKa:\t\u000f\t5\u0017\u00071\u0001\u0003P\u0006I\u0002.\u00198eY\u0016$U\r\\3uKR{\u0007/[2t%\u0016\fX/Z:u)\u0011\tYK!<\t\u000f\t5'\u00071\u0001\u0003P\u0006i\u0002.\u00198eY\u0016\u001c%/Z1uKB\u000b'\u000f^5uS>t7OU3rk\u0016\u001cH\u000f\u0006\u0003\u0002,\nM\bb\u0002Bgg\u0001\u0007!qZ\u0001\u001cG>tg-\u001b:n)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8F]\u0006\u0014G.\u001a3\u0015\t\u0005-&\u0011 \u0005\b\u0005\u001b$\u0004\u0019\u0001Bh\u0003\u0005:W\r\u001e(p]j+'o\u001c+pa&\u001c\u0017\nZ:U_>\u001b7-\u001e:sK:\u001cW-T1q)\u0011\u0011ypa\u0005\u0011\u0011\t56\u0011AB\u0003\u0007\u001bIAaa\u0001\u00028\t9\u0001*Y:i\u001b\u0006\u0004\b\u0003BB\u0004\u0007\u0013i\u0011!Z\u0005\u0004\u0007\u0017)'\u0001B+vS\u0012\u0004BA!\f\u0004\u0010%!1\u0011\u0003B\u0018\u0005\u001dIe\u000e^3hKJDqa!\u00066\u0001\u0004\u00199\"A\neK2,G/\u001a+pa&\u001c7OU3rk\u0016\u001cH\u000f\u0005\u0003\u0002z\re\u0011\u0002BB\u000e\u0003w\u00121\u0003R3mKR,Gk\u001c9jGN\u0014V-];fgR\f\u0001\u0004^8uC2\u0014V-];fgR,G\rU1si&$\u0018n\u001c8t)\r)6\u0011\u0005\u0005\b\u0007G1\u0004\u0019AB\u0013\u00035!x\u000e]5d\u001b\u0016$\u0018\rZ1uCB!\u0011\u0011DB\u0014\u0013\u0011\u0019I#a\u0007\u0003\u001f-\u0013Dk\u001c9jG6+G/\u00193bi\u0006\f1eZ3u\u001d>tg*\u001e7m)>\u0004\u0018n\u0019(b[\u0016\u001cHk\\(dGV\u0014(/\u001a8dK6\u000b\u0007\u000f\u0006\u0003\u00040\rE\u0002\u0003\u0003BW\u0007\u0003\t9o!\u0004\t\u000f\rUq\u00071\u0001\u0004\u0018\u0005!\u0013-\u001e;i_JL'0Z!oIB{\u0007/\u001e7bi\u0016$VM\u001c;bi&4XMU3tk2$8\u000f\u0006\u0006\u00048\ru2qHB%\u0007\u001f\u0002bA!,\u0004:\u0005\u001d\u0018\u0002BB\u001e\u0003o\u0011q\u0001S1tQN+G\u000fC\u0004\u0002va\u0002\r!a\u001e\t\u000f\r\u0005\u0003\b1\u0001\u0004D\u0005\u00192M]3bi\u0016$v\u000e]5dgJ+\u0017/^3tiB!\u0011\u0011PB#\u0013\u0011\u00199%a\u001f\u0003'\r\u0013X-\u0019;f)>\u0004\u0018nY:SKF,Xm\u001d;\t\u000f\r-\u0003\b1\u0001\u0004N\u0005q\u0001o\\:tS\ndW-\u0012:s_J\u001c\b\u0003\u0003BW\u0007\u0003\t9/a?\t\u000f\rE\u0003\b1\u0001\u0004T\u00059!/Z:vYR\u001c\b\u0003BB+\u0007grAaa\u0016\u0004n9!1\u0011LB5\u001d\u0011\u0019Yfa\u001a\u000f\t\ru3Q\r\b\u0005\u0007?\u001a\u0019GD\u0002{\u0007CJ\u0011a[\u0005\u0003S*L!A\u00105\n\u0005\u0019<\u0017bAB6K\u00069Q.Z:tC\u001e,\u0017\u0002BB8\u0007c\n\u0001d\u0011:fCR,Gk\u001c9jGN\u0014Vm\u001d9p]N,G)\u0019;b\u0015\r\u0019Y'Z\u0005\u0005\u0007k\u001a9H\u0001\u0010De\u0016\fG/\u00192mKR{\u0007/[2SKN,H\u000e^\"pY2,7\r^5p]*!1qNB9\u000359W\r\u001e$jYR,'/\u001a3CsRA1QPBF\u0007\u001b\u001b\t\n\u0005\u0003\u0004\u0000\r\u0015e\u0002BB,\u0007\u0003KAaa!\u0004r\u000592I]3bi\u0016$v\u000e]5dgJ+\u0017/^3ti\u0012\u000bG/Y\u0005\u0005\u0007\u000f\u001bII\u0001\rDe\u0016\fG/\u00192mKR{\u0007/[2D_2dWm\u0019;j_:TAaa!\u0004r!91\u0011I\u001dA\u0002\r\r\u0003bBBHs\u0001\u00071qG\u0001\u0018i>\u0004\u0018n\u0019(b[\u0016\u001cHk\u001c+ssR{7I]3bi\u0016Dqaa%:\u0001\u0004\t\t+A\tiK\u0006dG\u000f[2iK\u000e\\G+\u001a8b]R\u0004")
public class K2ControllerApis
implements Logging {
    private volatile K2ControllerApis$ErrorDetermination$ ErrorDetermination$module;
    private final KafkaConfig config;
    private final K2ControllerHandler controllerRequestHandler;
    private final Executor executor;
    private final RequestHandlerHelper requestHelper;
    private final AuthHelper authHelper;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private K2ControllerApis$ErrorDetermination$ ErrorDetermination() {
        if (this.ErrorDetermination$module == null) {
            this.ErrorDetermination$lzycompute$1();
        }
        return this.ErrorDetermination$module;
    }

    private Logger logger$lzycompute() {
        K2ControllerApis k2ControllerApis = this;
        synchronized (k2ControllerApis) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public RequestHandlerHelper requestHelper() {
        return this.requestHelper;
    }

    public AuthHelper authHelper() {
        return this.authHelper;
    }

    private void recordNewErrors(Map<String, ErrorDetermination> firstErrorByTopic, Set<String> affectedTopics, Function0<ErrorDetermination> errorDeterminationSupplier) {
        if (affectedTopics.nonEmpty()) {
            ErrorDetermination errorDetermination = errorDeterminationSupplier.apply();
            affectedTopics.foreach((Function1<String, ErrorDetermination> & Serializable)topic -> firstErrorByTopic.putIfAbsent((String)topic, errorDetermination));
            return;
        }
    }

    public void handleCreateTopicsRequest(RequestChannel.Request request) {
        Option maybeTopicsToCreate;
        boolean healthcheckTenant;
        CreateTopicsRequest createTopicsRequest = (CreateTopicsRequest)request.body(ClassTag$.MODULE$.apply(CreateTopicsRequest.class));
        Iterable topics = CollectionConverters$.MODULE$.CollectionHasAsScala(createTopicsRequest.data().topics()).asScala();
        Iterable topicNames = (Iterable)topics.map((Function1<CreateTopicsRequestData.CreatableTopic, String> & Serializable)x$1 -> x$1.name());
        scala.collection.immutable.Set topicNameSet = topicNames.toSet();
        boolean validateOnly = createTopicsRequest.data().validateOnly();
        HashMap<String, ErrorDetermination> firstErrorByTopic = new HashMap<String, ErrorDetermination>();
        if (topicNameSet.contains("__cluster_metadata")) {
            this.recordNewErrors(firstErrorByTopic, (Set)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"__cluster_metadata"})), (Function0<ErrorDetermination> & Serializable)() -> new ErrorDetermination(this, Errors.INVALID_REQUEST.code(), "Cannot create a topic with name __cluster_metadata."));
        }
        scala.collection.immutable.Set<String> mirroredTopicsUnsupportedInK2 = ((IterableOnceOps)((IterableOps)topics.filter((Function1<CreateTopicsRequestData.CreatableTopic, Object> & Serializable)t -> BoxesRunTime.boxToBoolean(K2ControllerApis.$anonfun$handleCreateTopicsRequest$3(t)))).map((Function1<CreateTopicsRequestData.CreatableTopic, String> & Serializable)x$2 -> x$2.name())).toSet();
        this.recordNewErrors(firstErrorByTopic, mirroredTopicsUnsupportedInK2, (Function0<ErrorDetermination> & Serializable)() -> new ErrorDetermination(this, Errors.INVALID_REQUEST.code(), "Mirror topics are not supported."));
        scala.collection.immutable.Set<String> duplicatedTopicNames = ((MapOps)((IterableOps)topics.filter((Function1<CreateTopicsRequestData.CreatableTopic, Object> & Serializable)topic -> BoxesRunTime.boxToBoolean(topicNameSet.contains(topic.name())))).groupBy((Function1<CreateTopicsRequestData.CreatableTopic, String> & Serializable)x$3 -> x$3.name()).filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(K2ControllerApis.$anonfun$handleCreateTopicsRequest$8(x0$1)))).keySet();
        this.recordNewErrors(firstErrorByTopic, duplicatedTopicNames, (Function0<ErrorDetermination> & Serializable)() -> new ErrorDetermination(this, Errors.INVALID_REQUEST.code(), "Found multiple entries for this topic."));
        KafkaPrincipal kafkaPrincipal = request.context().principal;
        if (kafkaPrincipal instanceof MultiTenantPrincipal) {
            MultiTenantPrincipal multiTenantPrincipal = (MultiTenantPrincipal)kafkaPrincipal;
            v0 = multiTenantPrincipal.tenantMetadata().isHealthcheckTenant;
        } else {
            v0 = healthcheckTenant = false;
        }
        if (!healthcheckTenant) {
            scala.collection.immutable.Set<String> manualPartitionAssignmentsUnsupportedInK2 = ((IterableOnceOps)((IterableOps)topics.filter((Function1<CreateTopicsRequestData.CreatableTopic, Object> & Serializable)t -> BoxesRunTime.boxToBoolean(K2ControllerApis.$anonfun$handleCreateTopicsRequest$10(t)))).map((Function1<CreateTopicsRequestData.CreatableTopic, String> & Serializable)x$4 -> x$4.name())).toSet();
            this.recordNewErrors(firstErrorByTopic, manualPartitionAssignmentsUnsupportedInK2, (Function0<ErrorDetermination> & Serializable)() -> new ErrorDetermination(this, Errors.INVALID_REQUEST.code(), "Manual partition assignments are not supported."));
        }
        scala.collection.immutable.Set<String> nonStandardReplicationFactorUnsupportedInK2 = ((IterableOnceOps)((IterableOps)topics.filter((Function1<CreateTopicsRequestData.CreatableTopic, Object> & Serializable)t -> BoxesRunTime.boxToBoolean(K2ControllerApis.$anonfun$handleCreateTopicsRequest$13(this, t)))).map((Function1<CreateTopicsRequestData.CreatableTopic, String> & Serializable)x$5 -> x$5.name())).toSet();
        this.recordNewErrors(firstErrorByTopic, nonStandardReplicationFactorUnsupportedInK2, (Function0<ErrorDetermination> & Serializable)() -> new ErrorDetermination(this, Errors.INVALID_REQUEST.code(), "Explicit replication factors that do not match the default value of " + $this.config.defaultReplicationFactor() + " are not supported."));
        scala.collection.immutable.Set<String> invalidPartitionCount = ((IterableOnceOps)((IterableOps)topics.filter((Function1<CreateTopicsRequestData.CreatableTopic, Object> & Serializable)t -> BoxesRunTime.boxToBoolean(K2ControllerApis.$anonfun$handleCreateTopicsRequest$16(t)))).map((Function1<CreateTopicsRequestData.CreatableTopic, String> & Serializable)x$6 -> x$6.name())).toSet();
        this.recordNewErrors(firstErrorByTopic, invalidPartitionCount, (Function0<ErrorDetermination> & Serializable)() -> new ErrorDetermination(this, Errors.INVALID_PARTITIONS.code(), "Number of partitions was set to an invalid non-positive value."));
        CreateTopicsResponseData.CreatableTopicResultCollection results = new CreateTopicsResponseData.CreatableTopicResultCollection(createTopicsRequest.data().topics().size());
        HashSet<String> topicNamesToTryToCreate = this.authorizeAndPopulateTentativeResults(request.context(), createTopicsRequest, firstErrorByTopic, results);
        Option option = maybeTopicsToCreate = topicNamesToTryToCreate.isEmpty() ? None$.MODULE$ : new Some<CreateTopicsRequestData.CreatableTopicCollection>(this.getFilteredBy(createTopicsRequest, topicNamesToTryToCreate, healthcheckTenant));
        if (option instanceof Some) {
            Some some = (Some)option;
            CreateTopicsRequestData.CreatableTopicCollection topicsToCreate = (CreateTopicsRequestData.CreatableTopicCollection)some.value();
            RequestContext x$12 = request.context();
            AclOperation x$22 = AclOperation.DESCRIBE_CONFIGS;
            ResourceType x$32 = ResourceType.TOPIC;
            Iterable x$42 = (Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala(topicsToCreate).asScala().map((Function1<CreateTopicsRequestData.CreatableTopic, String> & Serializable)t -> t.name());
            boolean x$52 = false;
            boolean x$62 = this.authHelper().filterByAuthorized$default$5();
            Function1<String, String> & Serializable x$7 = (Function1<String, String> & Serializable)x -> Predef$.MODULE$.identity(x);
            scala.collection.immutable.Set<String> topicsAuthorizedForDescribeConfigs = this.authHelper().filterByAuthorized(x$12, AclOperation.DESCRIBE_CONFIGS, ResourceType.TOPIC, x$42, x$62, false, x$7);
            this.controllerRequestHandler.createTopics(topicsToCreate, CollectionConverters$.MODULE$.SetHasAsJava(topicsAuthorizedForDescribeConfigs).asJava(), validateOnly).whenCompleteAsyncRaw((createResult, throwable) -> this.sendResponse$1((CreateTopicsResponseData.CreatableTopicResultCollection)createResult, (Throwable)throwable, createTopicsRequest, results, request), this.executor);
        } else if (None$.MODULE$.equals(option)) {
            this.sendResponse$1(new CreateTopicsResponseData.CreatableTopicResultCollection(), null, createTopicsRequest, results, request);
        } else {
            throw new MatchError(option);
        }
    }

    public void handleIncrementalAlterConfigsRequest(RequestChannel.Request request) {
        IncrementalAlterConfigsRequest alterConfigsRequest = (IncrementalAlterConfigsRequest)request.body(ClassTag$.MODULE$.apply(IncrementalAlterConfigsRequest.class));
        IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection resources = alterConfigsRequest.data().resources();
        if (resources.stream().anyMatch(resource -> {
            ConfigResource.Type type = ConfigResource.Type.forId((byte)resource.resourceType());
            ConfigResource.Type type2 = ConfigResource.Type.TOPIC;
            return type == null ? type2 != null : !type.equals(type2);
        })) {
            throw new InvalidRequestException("Cannot alter configs for Freight topics and non-topic entities in the same RPC");
        }
        if (resources.isEmpty()) {
            throw new InvalidRequestException("Must specify at least one entity when altering configs");
        }
        HashMap<String, ErrorDetermination> firstErrorByTopic = new HashMap<String, ErrorDetermination>();
        scala.collection.immutable.Set<String> duplicatedTopicNames = ((MapOps)CollectionConverters$.MODULE$.CollectionHasAsScala(resources).asScala().groupBy((Function1<IncrementalAlterConfigsRequestData.AlterConfigsResource, String> & Serializable)x$8 -> x$8.resourceName()).filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(K2ControllerApis.$anonfun$handleIncrementalAlterConfigsRequest$3(x0$1)))).keySet();
        this.recordNewErrors(firstErrorByTopic, duplicatedTopicNames, (Function0<ErrorDetermination> & Serializable)() -> new ErrorDetermination(this, Errors.INVALID_REQUEST.code(), "Each resource must appear at most once."));
        ArrayBuffer authorized = new ArrayBuffer();
        ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(resources).asScala().filter((Function1<IncrementalAlterConfigsRequestData.AlterConfigsResource, Object> & Serializable)resource -> BoxesRunTime.boxToBoolean(K2ControllerApis.$anonfun$handleIncrementalAlterConfigsRequest$5(firstErrorByTopic, resource)))).foreach((Function1<IncrementalAlterConfigsRequestData.AlterConfigsResource, Object> & Serializable)resource -> {
            String topicName = resource.resourceName();
            if (CollectionConverters$.MODULE$.CollectionHasAsScala(resource.configs()).asScala().exists((Function1<IncrementalAlterConfigsRequestData.AlterableConfig, Object> & Serializable)config -> BoxesRunTime.boxToBoolean(K2ControllerApis.$anonfun$handleIncrementalAlterConfigsRequest$7(config)))) {
                return firstErrorByTopic.put(topicName, new ErrorDetermination(this, Errors.INVALID_REQUEST.code(), "Empty or null value not supported for config key."));
            }
            if (ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala(resource.configs()).asScala().map((Function1<IncrementalAlterConfigsRequestData.AlterableConfig, String> & Serializable)x$9 -> x$9.name()))) {
                return firstErrorByTopic.put(topicName, new ErrorDetermination(this, Errors.INVALID_REQUEST.code(), "Error due to duplicate config keys."));
            }
            if (CollectionConverters$.MODULE$.CollectionHasAsScala(resource.configs()).asScala().exists((Function1<IncrementalAlterConfigsRequestData.AlterableConfig, Object> & Serializable)config -> BoxesRunTime.boxToBoolean(K2ControllerApis.$anonfun$handleIncrementalAlterConfigsRequest$9(config)))) {
                return firstErrorByTopic.put(topicName, new ErrorDetermination(this, Errors.INVALID_REQUEST.code(), "Null value not supported for config update."));
            }
            if (!this.authHelper().authorize(request.context(), AclOperation.ALTER_CONFIGS, ResourceType.TOPIC, topicName, this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7())) {
                return firstErrorByTopic.put(topicName, new ErrorDetermination(this, Errors.TOPIC_AUTHORIZATION_FAILED.code(), "Authorization failed."));
            }
            return authorized.append(resource);
        });
        if (authorized.isEmpty()) {
            this.sendResponse$2(Collections.emptyMap(), null, alterConfigsRequest, resources, firstErrorByTopic, request);
        } else {
            Map<String, Collection<AlterConfigOp>> requestsByAuthorizedTopicName = CollectionConverters$.MODULE$.MapHasAsJava(((IterableOnceOps)authorized.map((Function1<IncrementalAlterConfigsRequestData.AlterConfigsResource, Tuple2> & Serializable)resource -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(resource.resourceName()), K2ControllerApis.getAlterConfigOps$1(resource.configs())))).toMap($less$colon$less$.MODULE$.refl())).asJava();
            this.controllerRequestHandler.alterTopicConfigs(requestsByAuthorizedTopicName, true, alterConfigsRequest.data().validateOnly()).whenCompleteAsyncRaw((alterResults, throwable) -> this.sendResponse$2((Map)alterResults, (Throwable)throwable, alterConfigsRequest, resources, firstErrorByTopic, request), this.executor);
        }
    }

    public void handleLegacyAlterConfigsRequest(RequestChannel.Request request) {
        AlterConfigsRequest alterConfigsRequest = (AlterConfigsRequest)request.body(ClassTag$.MODULE$.apply(AlterConfigsRequest.class));
        AlterConfigsRequestData.AlterConfigsResourceCollection resources = alterConfigsRequest.data().resources();
        if (resources.stream().anyMatch(resource -> {
            ConfigResource.Type type = ConfigResource.Type.forId((byte)resource.resourceType());
            ConfigResource.Type type2 = ConfigResource.Type.TOPIC;
            return type == null ? type2 != null : !type.equals(type2);
        })) {
            throw new InvalidRequestException("Cannot alter configs for Freight topics and non-topic entities in the same RPC");
        }
        if (resources.isEmpty()) {
            throw new InvalidRequestException("Must specify at least one entity when altering configs");
        }
        HashMap<String, ErrorDetermination> firstErrorByTopic = new HashMap<String, ErrorDetermination>();
        scala.collection.immutable.Set<String> duplicatedTopicNames = ((MapOps)CollectionConverters$.MODULE$.CollectionHasAsScala(resources).asScala().groupBy((Function1<AlterConfigsRequestData.AlterConfigsResource, String> & Serializable)x$11 -> x$11.resourceName()).filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(K2ControllerApis.$anonfun$handleLegacyAlterConfigsRequest$3(x0$1)))).keySet();
        this.recordNewErrors(firstErrorByTopic, duplicatedTopicNames, (Function0<ErrorDetermination> & Serializable)() -> new ErrorDetermination(this, Errors.INVALID_REQUEST.code(), "Each resource must appear at most once."));
        ArrayBuffer authorized = new ArrayBuffer();
        ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(resources).asScala().filter((Function1<AlterConfigsRequestData.AlterConfigsResource, Object> & Serializable)resource -> BoxesRunTime.boxToBoolean(K2ControllerApis.$anonfun$handleLegacyAlterConfigsRequest$5(firstErrorByTopic, resource)))).foreach((Function1<AlterConfigsRequestData.AlterConfigsResource, Object> & Serializable)resource -> {
            String topicName = resource.resourceName();
            if (CollectionConverters$.MODULE$.CollectionHasAsScala(resource.configs()).asScala().exists((Function1<AlterConfigsRequestData.AlterableConfig, Object> & Serializable)config -> BoxesRunTime.boxToBoolean(K2ControllerApis.$anonfun$handleLegacyAlterConfigsRequest$7(config)))) {
                return firstErrorByTopic.put(topicName, new ErrorDetermination(this, Errors.INVALID_REQUEST.code(), "Empty or null value not supported for config key."));
            }
            if (ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala(resource.configs()).asScala().map((Function1<AlterConfigsRequestData.AlterableConfig, String> & Serializable)x$12 -> x$12.name()))) {
                return firstErrorByTopic.put(topicName, new ErrorDetermination(this, Errors.INVALID_REQUEST.code(), "Error due to duplicate config keys."));
            }
            if (CollectionConverters$.MODULE$.CollectionHasAsScala(resource.configs()).asScala().exists((Function1<AlterConfigsRequestData.AlterableConfig, Object> & Serializable)config -> BoxesRunTime.boxToBoolean(K2ControllerApis.$anonfun$handleLegacyAlterConfigsRequest$9(config)))) {
                return firstErrorByTopic.put(topicName, new ErrorDetermination(this, Errors.INVALID_REQUEST.code(), "Null value not supported for config update."));
            }
            if (!this.authHelper().authorize(request.context(), AclOperation.ALTER_CONFIGS, ResourceType.TOPIC, topicName, this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7())) {
                return firstErrorByTopic.put(topicName, new ErrorDetermination(this, Errors.TOPIC_AUTHORIZATION_FAILED.code(), "Authorization failed."));
            }
            return authorized.append(resource);
        });
        Map<String, Collection<AlterConfigOp>> requestsByAuthorizedTopicName = CollectionConverters$.MODULE$.MapHasAsJava(((IterableOnceOps)authorized.map((Function1<AlterConfigsRequestData.AlterConfigsResource, Tuple2> & Serializable)resource -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(resource.resourceName()), K2ControllerApis.getAlterConfigOps$2(resource.configs())))).toMap($less$colon$less$.MODULE$.refl())).asJava();
        if (requestsByAuthorizedTopicName.isEmpty()) {
            this.sendResponse$3(Collections.emptyMap(), null, alterConfigsRequest, resources, firstErrorByTopic, request);
        } else {
            this.controllerRequestHandler.alterTopicConfigs(requestsByAuthorizedTopicName, false, alterConfigsRequest.data().validateOnly()).whenCompleteAsyncRaw((alterResults, throwable) -> this.sendResponse$3((Map)alterResults, (Throwable)throwable, alterConfigsRequest, resources, firstErrorByTopic, request), this.executor);
        }
    }

    public void handleDeleteTopicsRequest(RequestChannel.Request request) {
        this.confirmTopicDeletionEnabled(request);
        DeleteTopicsRequest deleteTopicsRequest = (DeleteTopicsRequest)request.body(ClassTag$.MODULE$.apply(DeleteTopicsRequest.class));
        HashMap<String, Integer> nonNullTopicNamesToOccurrenceMap = this.getNonNullTopicNamesToOccurrenceMap(deleteTopicsRequest);
        HashSet<String> nonNullNonRepeatedTopicNames = new HashSet<String>();
        nonNullTopicNamesToOccurrenceMap.entrySet().stream().filter(entry -> BoxesRunTime.equals(entry.getValue(), BoxesRunTime.boxToInteger(1))).forEach(entry -> nonNullNonRepeatedTopicNames.add((String)entry.getKey()));
        HashMap<Uuid, Integer> nonZeroTopicIdsToOccurrenceMap = this.getNonZeroTopicIdsToOccurrenceMap(deleteTopicsRequest);
        HashSet<Uuid> nonZeroNonRepeatedTopicIds = new HashSet<Uuid>();
        nonZeroTopicIdsToOccurrenceMap.entrySet().stream().filter(entry -> BoxesRunTime.equals(entry.getValue(), BoxesRunTime.boxToInteger(1))).forEach(entry -> nonZeroNonRepeatedTopicIds.add((Uuid)entry.getKey()));
        if (nonNullNonRepeatedTopicNames.isEmpty() && nonZeroNonRepeatedTopicIds.isEmpty()) {
            this.maybeTryToDeleteTopicsAndSendResponse$1(Collections.emptySet(), null, request, deleteTopicsRequest, nonNullTopicNamesToOccurrenceMap, nonZeroTopicIdsToOccurrenceMap);
        } else {
            this.controllerRequestHandler.getTopicMetadata(nonNullNonRepeatedTopicNames, nonZeroNonRepeatedTopicIds).whenCompleteAsyncRaw((topicMetadataForDeletions, throwable) -> this.maybeTryToDeleteTopicsAndSendResponse$1((java.util.Set)topicMetadataForDeletions, (Throwable)throwable, request, deleteTopicsRequest, nonNullTopicNamesToOccurrenceMap, nonZeroTopicIdsToOccurrenceMap), this.executor);
        }
    }

    public void handleCreatePartitionsRequest(RequestChannel.Request request) {
        CreatePartitionsRequest createPartitionsRequest = (CreatePartitionsRequest)request.body(ClassTag$.MODULE$.apply(CreatePartitionsRequest.class));
        CreatePartitionsRequestData.CreatePartitionsTopicCollection topics = createPartitionsRequest.data().topics();
        boolean validateOnly = createPartitionsRequest.data().validateOnly();
        HashMap validCreatePartitionsTopics = new HashMap();
        HashSet duplicateTopicNames = new HashSet();
        ArrayList responses = new ArrayList();
        topics.forEach(topic -> {
            if (validCreatePartitionsTopics.put(topic.name(), topic) != null) {
                duplicateTopicNames.add(topic.name());
                return;
            }
        });
        duplicateTopicNames.forEach(topicName -> {
            K2ControllerApis.addResponse$2(topicName, Errors.INVALID_REQUEST.code(), "Found multiple entries for this topic.", responses);
            validCreatePartitionsTopics.remove(topicName);
        });
        scala.collection.immutable.Set assignmentsTopicNames = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(validCreatePartitionsTopics.values()).asScala().filter((Function1<CreatePartitionsRequestData.CreatePartitionsTopic, Object> & Serializable)topic -> BoxesRunTime.boxToBoolean(K2ControllerApis.$anonfun$handleCreatePartitionsRequest$5(topic)))).map((Function1<CreatePartitionsRequestData.CreatePartitionsTopic, String> & Serializable)x$16 -> x$16.name())).toSet();
        assignmentsTopicNames.foreach((Function1<String, CreatePartitionsRequestData.CreatePartitionsTopic> & Serializable)topicName -> {
            K2ControllerApis.addResponse$2(topicName, Errors.INVALID_REQUEST.code(), "Cannot specify assignments when creating partitions on a Freight Cluster.", responses);
            return (CreatePartitionsRequestData.CreatePartitionsTopic)validCreatePartitionsTopics.remove(topicName);
        });
        ClusterAuthorizer clusterAuthorizer = new ClusterAuthorizer(this, request.context(), AclOperation.ALTER);
        HashSet<String> authorizedTopics = new HashSet<String>();
        validCreatePartitionsTopics.keySet().forEach(topicName -> {
            boolean authorizedToAlter;
            boolean bl = authorizedToAlter = clusterAuthorizer.isAuthorized() || this.authHelper().authorize(request.context(), AclOperation.ALTER, ResourceType.TOPIC, (String)topicName, this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7());
            if (!authorizedToAlter) {
                K2ControllerApis.addResponse$2(topicName, Errors.TOPIC_AUTHORIZATION_FAILED.code(), Errors.TOPIC_AUTHORIZATION_FAILED.message(), responses);
                return;
            }
            authorizedTopics.add((String)topicName);
        });
        if (authorizedTopics.isEmpty()) {
            this.sendResponses$2(responses, request);
        } else {
            this.controllerRequestHandler.getTopicMetadata(authorizedTopics, Collections.emptySet()).whenCompleteAsyncRaw((topicMetadataForPartitionCreations, throwable) -> this.maybeTryToCreatePartitionsAndSendResponse$1((java.util.Set)topicMetadataForPartitionCreations, (Throwable)throwable, authorizedTopics, validCreatePartitionsTopics, validateOnly, responses, request), this.executor);
        }
    }

    private void confirmTopicDeletionEnabled(RequestChannel.Request request) {
        if (!Predef$.MODULE$.Boolean2boolean(this.config.deleteTopicEnable())) {
            this.info((Function0<String> & Serializable)() -> "K2 DELETE_TOPICS disabled");
            if (request.header().apiVersion() < 3) {
                throw new InvalidRequestException("Topic deletion is disabled.");
            }
            throw new TopicDeletionDisabledException();
        }
    }

    private HashMap<Uuid, Integer> getNonZeroTopicIdsToOccurrenceMap(DeleteTopicsRequest deleteTopicsRequest) {
        HashMap<Uuid, Integer> topicIdsToOccurrences = new HashMap<Uuid, Integer>();
        deleteTopicsRequest.topics().stream().filter(topic -> !topic.topicId().equals((Object)Uuid.ZERO_UUID)).forEach(topic -> topicIdsToOccurrences.put(topic.topicId(), Predef$.MODULE$.int2Integer(1 + Predef$.MODULE$.Integer2int(topicIdsToOccurrences.getOrDefault(topic.topicId(), Predef$.MODULE$.int2Integer(0))))));
        return topicIdsToOccurrences;
    }

    private int totalRequestedPartitions(K2TopicMetadata topicMetadata) {
        return topicMetadata.numPartitions();
    }

    private HashMap<String, Integer> getNonNullTopicNamesToOccurrenceMap(DeleteTopicsRequest deleteTopicsRequest) {
        HashMap<String, Integer> topicNamesToOccurrences = new HashMap<String, Integer>();
        deleteTopicsRequest.topics().stream().filter(topic -> topic.name() != null).forEach(topic -> topicNamesToOccurrences.put(topic.name(), Predef$.MODULE$.int2Integer(1 + Predef$.MODULE$.Integer2int(topicNamesToOccurrences.getOrDefault(topic.name(), Predef$.MODULE$.int2Integer(0))))));
        return topicNamesToOccurrences;
    }

    private HashSet<String> authorizeAndPopulateTentativeResults(RequestContext requestContext, CreateTopicsRequest createTopicsRequest, HashMap<String, ErrorDetermination> possibleErrors, CreateTopicsResponseData.CreatableTopicResultCollection results) {
        ClusterAuthorizer clusterAuthorizer = new ClusterAuthorizer(this, requestContext, AclOperation.CREATE);
        HashSet<String> topicNamesToTryToCreate = new HashSet<String>();
        createTopicsRequest.data().topics().forEach(topic -> {
            CreateTopicsResponseData.CreatableTopicResult resultForTopicSoFar = new CreateTopicsResponseData.CreatableTopicResult().setName(topic.name()).setErrorCode(Errors.NONE.code());
            Option option = Option$.MODULE$.apply(possibleErrors.get(topic.name()));
            if (option instanceof Some) {
                Some some = (Some)option;
                ErrorDetermination determinedError = (ErrorDetermination)some.value();
                resultForTopicSoFar.setErrorCode(determinedError.errorCode()).setErrorMessage(determinedError.errorMessage());
            } else if (None$.MODULE$.equals(option)) {
                boolean authorized;
                boolean bl = authorized = clusterAuthorizer.isAuthorized() || this.authHelper().authorize(requestContext, AclOperation.CREATE, ResourceType.TOPIC, topic.name(), this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7());
                if (authorized) {
                    BoxesRunTime.boxToBoolean(topicNamesToTryToCreate.add(topic.name()));
                } else {
                    resultForTopicSoFar.setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage("Authorization failed.");
                }
            } else {
                throw new MatchError(option);
            }
            results.add((ImplicitLinkedHashCollection.Element)resultForTopicSoFar);
        });
        return topicNamesToTryToCreate;
    }

    private CreateTopicsRequestData.CreatableTopicCollection getFilteredBy(CreateTopicsRequest createTopicsRequest, HashSet<String> topicNamesToTryToCreate, boolean healthcheckTenant) {
        CreateTopicsRequestData.CreatableTopicCollection creatableTopicsFiltered = new CreateTopicsRequestData.CreatableTopicCollection(topicNamesToTryToCreate.size());
        Integer defaultNumPartitions = this.config.numPartitions();
        createTopicsRequest.data().topics().stream().filter(topic -> topicNamesToTryToCreate.contains(topic.name())).forEach(topic -> {
            boolean added;
            CreateTopicsRequestData.CreatableTopic topicDuplicate;
            CreateTopicsRequestData.CreatableTopic creatableTopic = topicDuplicate = topic.numPartitions() == -1 ? topic.duplicate().setNumPartitions(Predef$.MODULE$.Integer2int(defaultNumPartitions)) : topic.duplicate();
            if (healthcheckTenant) {
                topicDuplicate.configs().clear();
            }
            if (!(added = creatableTopicsFiltered.add((ImplicitLinkedHashCollection.Element)topicDuplicate))) {
                throw new IllegalStateException("Unable to create topic with name = " + topic.name() + " due to failure to add to collection (should never happen)");
            }
        });
        return creatableTopicsFiltered;
    }

    private final void ErrorDetermination$lzycompute$1() {
        K2ControllerApis k2ControllerApis = this;
        synchronized (k2ControllerApis) {
            if (this.ErrorDetermination$module == null) {
                this.ErrorDetermination$module = new K2ControllerApis$ErrorDetermination$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$handleCreateTopicsRequest$3(CreateTopicsRequestData.CreatableTopic t) {
        return t.linkName() != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(t.linkName()));
    }

    public static final /* synthetic */ boolean $anonfun$handleCreateTopicsRequest$8(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Iterable countOfCreatableTopicsForName = (Iterable)tuple2._2();
            return countOfCreatableTopicsForName.size() > 1;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$handleCreateTopicsRequest$10(CreateTopicsRequestData.CreatableTopic t) {
        return t.assignments() != null && !t.assignments().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$handleCreateTopicsRequest$13(K2ControllerApis $this, CreateTopicsRequestData.CreatableTopic t) {
        return t.replicationFactor() != -1 && t.replicationFactor() != $this.config.defaultReplicationFactor();
    }

    public static final /* synthetic */ boolean $anonfun$handleCreateTopicsRequest$16(CreateTopicsRequestData.CreatableTopic t) {
        return t.numPartitions() == 0 || t.numPartitions() < -1;
    }

    private final void sendResponse$1(CreateTopicsResponseData.CreatableTopicResultCollection createResult, Throwable throwable, CreateTopicsRequest createTopicsRequest$1, CreateTopicsResponseData.CreatableTopicResultCollection results$1, RequestChannel.Request request$1) {
        if (throwable != null) {
            this.error((Function0<String> & Serializable)() -> "Processed CreateTopicsRequest " + createTopicsRequest$1 + " via K2 topic metadata store. result: " + createResult + " throwable: " + throwable, (Function0<Throwable> & Serializable)() -> throwable);
        } else {
            this.info((Function0<String> & Serializable)() -> "Processed CreateTopicsRequest " + createTopicsRequest$1 + " via K2 topic metadata store. result: " + createResult + " throwable: " + throwable);
        }
        createResult.stream().forEach(creatableTopicResult -> {
            CreateTopicsResponseData.CreatableTopicResult originalResultForTopic = results$1.find(creatableTopicResult.name());
            originalResultForTopic.setErrorCode(throwable == null ? creatableTopicResult.errorCode() : Errors.forException((Throwable)throwable).code()).setErrorMessage(throwable == null ? creatableTopicResult.errorMessage() : throwable.getMessage());
            boolean errored = creatableTopicResult.errorCode() != Errors.NONE.code();
            originalResultForTopic.setTopicId(creatableTopicResult.topicId()).setNumPartitions(errored ? -1 : creatableTopicResult.numPartitions()).setReplicationFactor(errored ? (short)-1 : (short)creatableTopicResult.replicationFactor()).setConfigs(creatableTopicResult.configs()).setTopicConfigErrorCode(errored ? Errors.NONE.code() : creatableTopicResult.topicConfigErrorCode());
        });
        CreateTopicsResponse response = new CreateTopicsResponse(new CreateTopicsResponseData().setTopics(results$1));
        this.trace((Function0<String> & Serializable)() -> "Sending create topics response " + response + " for correlation id " + request$1.header().correlationId() + " to client " + request$1.header().clientId() + ".");
        this.requestHelper().sendResponseMaybeThrottle(request$1, (Function1<Object, AbstractResponse>)(Function1<Object, CreateTopicsResponse> & Serializable)x$7 -> response);
    }

    public static final /* synthetic */ boolean $anonfun$handleIncrementalAlterConfigsRequest$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Iterable countOfCreatableTopicsForName = (Iterable)tuple2._2();
            return countOfCreatableTopicsForName.size() > 1;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$handleIncrementalAlterConfigsRequest$5(HashMap firstErrorByTopic$2, IncrementalAlterConfigsRequestData.AlterConfigsResource resource) {
        return !firstErrorByTopic$2.containsKey(resource.resourceName());
    }

    public static final /* synthetic */ boolean $anonfun$handleIncrementalAlterConfigsRequest$7(IncrementalAlterConfigsRequestData.AlterableConfig config) {
        return config.name() == null || config.name().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$handleIncrementalAlterConfigsRequest$9(IncrementalAlterConfigsRequestData.AlterableConfig config) {
        return config.configOperation() != AlterConfigOp.OpType.DELETE.id() && config.value() == null;
    }

    private static final Collection getAlterConfigOps$1(IncrementalAlterConfigsRequestData.AlterableConfigCollection configs) {
        return CollectionConverters$.MODULE$.SetHasAsJava(((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(configs).asScala().map((Function1<IncrementalAlterConfigsRequestData.AlterableConfig, AlterConfigOp> & Serializable)alterableConfig -> new AlterConfigOp(new ConfigEntry(alterableConfig.name(), alterableConfig.value()), AlterConfigOp.OpType.forId((byte)alterableConfig.configOperation())))).toSet()).asJava();
    }

    private final void sendResponse$2(Map alterResults, Throwable throwable, IncrementalAlterConfigsRequest alterConfigsRequest$1, IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection resources$1, HashMap firstErrorByTopic$2, RequestChannel.Request request$2) {
        this.info((Function0<String> & Serializable)() -> "Processed IncrementalAlterConfigsRequest " + alterConfigsRequest$1 + " via K2 topic metadata store. result: " + alterResults + " throwable: " + throwable);
        List results = CollectionConverters$.MODULE$.SeqHasAsJava(((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(resources$1).asScala().map((Function1<IncrementalAlterConfigsRequestData.AlterConfigsResource, IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse> & Serializable)resource -> {
            String topicName = resource.resourceName();
            Option option = Option$.MODULE$.apply(firstErrorByTopic$2.get(topicName));
            if (option instanceof Some) {
                Some some = (Some)option;
                ErrorDetermination errorDetermination = (ErrorDetermination)some.value();
                return new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName(topicName).setErrorCode(errorDetermination.errorCode()).setErrorMessage(errorDetermination.errorMessage());
            }
            if (None$.MODULE$.equals(option)) {
                ApiError alterResult = (ApiError)alterResults.get(topicName);
                return new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName(topicName).setErrorCode(throwable == null ? alterResult.error().code() : Errors.forException((Throwable)throwable).code()).setErrorMessage(throwable == null ? alterResult.error().message() : throwable.getMessage());
            }
            throw new MatchError(option);
        })).toList()).asJava();
        IncrementalAlterConfigsResponse response = new IncrementalAlterConfigsResponse(new IncrementalAlterConfigsResponseData());
        response.data().setResponses(results);
        this.trace((Function0<String> & Serializable)() -> "Sending incremental alter configs response " + response + " for correlation id " + request$2.header().correlationId() + " to client " + request$2.header().clientId() + ".");
        this.requestHelper().sendResponseMaybeThrottle(request$2, (Function1<Object, AbstractResponse>)(Function1<Object, IncrementalAlterConfigsResponse> & Serializable)x$10 -> response);
    }

    public static final /* synthetic */ boolean $anonfun$handleLegacyAlterConfigsRequest$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Iterable countOfCreatableTopicsForName = (Iterable)tuple2._2();
            return countOfCreatableTopicsForName.size() > 1;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$handleLegacyAlterConfigsRequest$5(HashMap firstErrorByTopic$3, AlterConfigsRequestData.AlterConfigsResource resource) {
        return !firstErrorByTopic$3.containsKey(resource.resourceName());
    }

    public static final /* synthetic */ boolean $anonfun$handleLegacyAlterConfigsRequest$7(AlterConfigsRequestData.AlterableConfig config) {
        return config.name() == null || config.name().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$handleLegacyAlterConfigsRequest$9(AlterConfigsRequestData.AlterableConfig config) {
        return config.value() == null;
    }

    private static final Collection getAlterConfigOps$2(AlterConfigsRequestData.AlterableConfigCollection configs) {
        return CollectionConverters$.MODULE$.SetHasAsJava(((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(configs).asScala().map((Function1<AlterConfigsRequestData.AlterableConfig, AlterConfigOp> & Serializable)alterableConfig -> new AlterConfigOp(new ConfigEntry(alterableConfig.name(), alterableConfig.value()), AlterConfigOp.OpType.SET))).toSet()).asJava();
    }

    private final void sendResponse$3(Map alterResults, Throwable throwable, AlterConfigsRequest alterConfigsRequest$2, AlterConfigsRequestData.AlterConfigsResourceCollection resources$2, HashMap firstErrorByTopic$3, RequestChannel.Request request$3) {
        this.info((Function0<String> & Serializable)() -> "Processed AlterConfigsRequest " + alterConfigsRequest$2 + " via K2 topic metadata store. result: " + alterResults + " throwable: " + throwable);
        List results = CollectionConverters$.MODULE$.SeqHasAsJava(((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(resources$2).asScala().map((Function1<AlterConfigsRequestData.AlterConfigsResource, AlterConfigsResponseData.AlterConfigsResourceResponse> & Serializable)resource -> {
            String topicName = resource.resourceName();
            Option option = Option$.MODULE$.apply(firstErrorByTopic$3.get(topicName));
            if (option instanceof Some) {
                Some some = (Some)option;
                ErrorDetermination errorDetermination = (ErrorDetermination)some.value();
                return new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName(topicName).setErrorCode(errorDetermination.errorCode()).setErrorMessage(errorDetermination.errorMessage());
            }
            if (None$.MODULE$.equals(option)) {
                ApiError alterResult = (ApiError)alterResults.get(topicName);
                return new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName(topicName).setErrorCode(throwable == null ? alterResult.error().code() : Errors.forException((Throwable)throwable).code()).setErrorMessage(throwable == null ? alterResult.error().message() : throwable.getMessage());
            }
            throw new MatchError(option);
        })).toList()).asJava();
        AlterConfigsResponse response = new AlterConfigsResponse(new AlterConfigsResponseData());
        response.data().setResponses(results);
        this.trace((Function0<String> & Serializable)() -> "Sending alter configs response " + response + " for correlation id " + request$3.header().correlationId() + " to client " + request$3.header().clientId() + ".");
        this.requestHelper().sendResponseMaybeThrottle(request$3, (Function1<Object, AbstractResponse>)(Function1<Object, AlterConfigsResponse> & Serializable)x$13 -> response);
    }

    private static final boolean hasTopicName$1(DeleteTopicsRequestData.DeleteTopicState topic) {
        return topic.name() != null;
    }

    private static final boolean hasTopicId$1(DeleteTopicsRequestData.DeleteTopicState topic) {
        return !topic.topicId().equals((Object)Uuid.ZERO_UUID);
    }

    public static final /* synthetic */ boolean $anonfun$handleDeleteTopicsRequest$6(K2TopicMetadata k2tm) {
        K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState = k2tm.k2TopicLifecycleState();
        K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState2 = K2TopicMetadata.K2TopicLifecycleState.ONLINE;
        return !(k2TopicLifecycleState != null ? !((Object)((Object)k2TopicLifecycleState)).equals((Object)k2TopicLifecycleState2) : k2TopicLifecycleState2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$handleDeleteTopicsRequest$8(K2TopicMetadata k2tm) {
        K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState = k2tm.k2TopicLifecycleState();
        K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState2 = K2TopicMetadata.K2TopicLifecycleState.ONLINE;
        return !(k2TopicLifecycleState != null ? !((Object)((Object)k2TopicLifecycleState)).equals((Object)k2TopicLifecycleState2) : k2TopicLifecycleState2 != null);
    }

    private static final void addResponse$1(String name, Uuid id, ApiError error, HashSet responses$1) {
        responses$1.add(new DeleteTopicsResponseData.DeletableTopicResult().setName(name).setTopicId(id).setErrorCode(error.error().code()).setErrorMessage(error.message()));
    }

    private final void sendResponses$1(HashSet responses$1, RequestChannel.Request request$4) {
        DeleteTopicsResponseData.DeletableTopicResultCollection collection = new DeleteTopicsResponseData.DeletableTopicResultCollection();
        responses$1.forEach(newElement -> collection.add((ImplicitLinkedHashCollection.Element)newElement));
        DeleteTopicsResponse responseToSend = new DeleteTopicsResponse(new DeleteTopicsResponseData().setResponses(collection));
        this.trace((Function0<String> & Serializable)() -> "Sending delete topics response " + responseToSend + " for correlation id " + request$4.header().correlationId() + " to client " + request$4.header().clientId() + ".");
        this.requestHelper().sendResponseMaybeThrottle(request$4, (Function1<Object, AbstractResponse>)(Function1<Object, DeleteTopicsResponse> & Serializable)x$14 -> responseToSend);
    }

    private final void maybeTryToDeleteTopicsAndSendResponse$1(java.util.Set topicMetadataForDeletions, Throwable throwable2, RequestChannel.Request request$4, DeleteTopicsRequest deleteTopicsRequest$1, HashMap nonNullTopicNamesToOccurrenceMap$1, HashMap nonZeroTopicIdsToOccurrenceMap$1) {
        scala.collection.immutable.Map topicMetadataByName = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(topicMetadataForDeletions).asScala().filter((Function1<K2TopicMetadata, Object> & Serializable)k2tm -> BoxesRunTime.boxToBoolean(K2ControllerApis.$anonfun$handleDeleteTopicsRequest$6(k2tm)))).map((Function1<K2TopicMetadata, Tuple2> & Serializable)k2tm -> new Tuple2<String, K2TopicMetadata>(k2tm.topicName(), (K2TopicMetadata)k2tm))).toMap($less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map topicMetadataById = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(topicMetadataForDeletions).asScala().filter((Function1<K2TopicMetadata, Object> & Serializable)k2tm -> BoxesRunTime.boxToBoolean(K2ControllerApis.$anonfun$handleDeleteTopicsRequest$8(k2tm)))).map((Function1<K2TopicMetadata, Tuple2> & Serializable)k2tm -> new Tuple2<Uuid, K2TopicMetadata>(k2tm.topicId(), (K2TopicMetadata)k2tm))).toMap($less$colon$less$.MODULE$.refl());
        HashSet responses = new HashSet();
        HashSet potentiallyAuthorizeTopicNames = new HashSet();
        HashSet potentiallyAuthorizeTopicIds = new HashSet();
        deleteTopicsRequest$1.topics().forEach(topic -> {
            if (!K2ControllerApis.hasTopicName$1(topic) && !K2ControllerApis.hasTopicId$1(topic)) {
                K2ControllerApis.addResponse$1(null, Uuid.ZERO_UUID, new ApiError(Errors.INVALID_REQUEST, "Neither topic name nor id were specified."), responses);
                return;
            }
            if (K2ControllerApis.hasTopicName$1(topic) && K2ControllerApis.hasTopicId$1(topic)) {
                K2ControllerApis.addResponse$1(topic.name(), topic.topicId(), new ApiError(Errors.INVALID_REQUEST, "You may not specify both topic name and topic id."), responses);
                return;
            }
            if (K2ControllerApis.hasTopicName$1(topic) && Predef$.MODULE$.Integer2int((Integer)nonNullTopicNamesToOccurrenceMap$1.get(topic.name())) > 1) {
                K2ControllerApis.addResponse$1(topic.name(), Uuid.ZERO_UUID, new ApiError(Errors.INVALID_REQUEST, "Duplicate topic name."), responses);
                return;
            }
            if (K2ControllerApis.hasTopicId$1(topic) && Predef$.MODULE$.Integer2int((Integer)nonZeroTopicIdsToOccurrenceMap$1.get(topic.topicId())) > 1) {
                K2ControllerApis.addResponse$1(null, topic.topicId(), new ApiError(Errors.INVALID_REQUEST, "Duplicate topic id."), responses);
                return;
            }
            if (K2ControllerApis.hasTopicName$1(topic)) {
                if (throwable2 == null && !topicMetadataByName.contains(topic.name())) {
                    K2ControllerApis.addResponse$1(topic.name(), Uuid.ZERO_UUID, new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION), responses);
                    return;
                }
                potentiallyAuthorizeTopicNames.add(topic.name());
                return;
            }
            if (throwable2 == null && !topicMetadataById.contains(topic.topicId())) {
                K2ControllerApis.addResponse$1(null, topic.topicId(), new ApiError(Errors.UNKNOWN_TOPIC_ID), responses);
                return;
            }
            potentiallyAuthorizeTopicIds.add(topic.topicId());
        });
        if (throwable2 != null) {
            ApiError apiError = ApiError.fromThrowable((Throwable)throwable2);
            potentiallyAuthorizeTopicNames.forEach(topicName -> K2ControllerApis.addResponse$1(topicName, Uuid.ZERO_UUID, apiError, responses));
            potentiallyAuthorizeTopicIds.forEach(topicId -> K2ControllerApis.addResponse$1(null, topicId, apiError, responses));
            this.info((Function0<String> & Serializable)() -> "Received exception during processing of DeleteTopicsRequest while retrieving K2 topic metadata for topics: {" + String.join((CharSequence)",", topicMetadataForDeletions.toString()) + "} throwable: " + throwable2);
            this.sendResponses$1(responses, request$4);
            return;
        }
        ClusterAuthorizer clusterAuthorizer = new ClusterAuthorizer(this, request$4.context(), AclOperation.DELETE);
        HashMap authorizedTopicMetadata = new HashMap();
        potentiallyAuthorizeTopicNames.forEach(topicName -> {
            boolean authorizedToDelete;
            boolean authorizedToDescribe;
            boolean bl = authorizedToDescribe = clusterAuthorizer.isAuthorized() || this.authHelper().authorize(request$4.context(), AclOperation.DESCRIBE, ResourceType.TOPIC, (String)topicName, this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7());
            if (!authorizedToDescribe) {
                K2ControllerApis.addResponse$1(topicName, Uuid.ZERO_UUID, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses);
                return;
            }
            boolean bl2 = authorizedToDelete = clusterAuthorizer.isAuthorized() || this.authHelper().authorize(request$4.context(), AclOperation.DELETE, ResourceType.TOPIC, (String)topicName, this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7());
            if (!authorizedToDelete) {
                K2ControllerApis.addResponse$1(topicName, Uuid.ZERO_UUID, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses);
                return;
            }
            K2TopicMetadata topicMetadata = (K2TopicMetadata)topicMetadataByName.apply(topicName);
            Uuid topicId = topicMetadata.topicId();
            if (potentiallyAuthorizeTopicIds.contains(topicId)) {
                K2ControllerApis.addResponse$1(topicName, topicId, new ApiError(Errors.INVALID_REQUEST, "The provided topic name maps to an ID that was already supplied."), responses);
                return;
            }
            authorizedTopicMetadata.put(topicId, Predef$.MODULE$.int2Integer(this.totalRequestedPartitions(topicMetadata)));
        });
        potentiallyAuthorizeTopicIds.forEach(topicId -> {
            boolean authorizedToDelete;
            boolean authorizedToDescribe;
            K2TopicMetadata topicMetadata = (K2TopicMetadata)topicMetadataById.apply(topicId);
            String topicName = topicMetadata.topicName();
            boolean bl = authorizedToDescribe = clusterAuthorizer.isAuthorized() || this.authHelper().authorize(request$4.context(), AclOperation.DESCRIBE, ResourceType.TOPIC, topicName, this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7());
            if (!authorizedToDescribe) {
                K2ControllerApis.addResponse$1(null, topicId, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses);
                return;
            }
            boolean bl2 = authorizedToDelete = clusterAuthorizer.isAuthorized() || this.authHelper().authorize(request$4.context(), AclOperation.DELETE, ResourceType.TOPIC, topicName, this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7());
            if (!authorizedToDelete) {
                K2ControllerApis.addResponse$1(topicName, topicId, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses);
                return;
            }
            if (!potentiallyAuthorizeTopicNames.contains(topicName)) {
                authorizedTopicMetadata.put(topicId, Predef$.MODULE$.int2Integer(this.totalRequestedPartitions(topicMetadata)));
                return;
            }
        });
        if (authorizedTopicMetadata.isEmpty()) {
            this.sendResponses$1(responses, request$4);
            return;
        }
        this.controllerRequestHandler.deleteTopics(authorizedTopicMetadata.keySet()).whenCompleteAsyncRaw((deleteResult, throwable) -> {
            this.info((Function0<String> & Serializable)() -> "Processed DeleteTopicsRequest for authorized topics " + authorizedTopicMetadata + " via K2 topic metadata store. result: " + deleteResult + " throwable: " + throwable);
            authorizedTopicMetadata.keySet().forEach(topicId -> {
                String topicName = ((K2TopicMetadata)topicMetadataById.apply(topicId)).topicName();
                if (deleteResult.containsKey(topicId)) {
                    ApiError apiError = throwable != null ? ApiError.fromThrowable((Throwable)throwable) : (ApiError)deleteResult.get(topicId);
                    K2ControllerApis.addResponse$1(topicName, topicId, apiError, responses);
                    return;
                }
                K2ControllerApis.addResponse$1(topicName, topicId, new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION), responses);
                this.error((Function0<String> & Serializable)() -> "Missing result for topic: " + topicName + ", topicId: " + topicId + " from controller (should never happen).");
            });
            this.sendResponses$1(responses, request$4);
        }, this.executor);
    }

    private static final void addResponse$2(String name, short errorCode, String errorMessage, ArrayList responses$2) {
        responses$2.add(new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName(name).setErrorCode(errorCode).setErrorMessage(errorMessage));
    }

    private final void sendResponses$2(ArrayList responses$2, RequestChannel.Request request$5) {
        CreatePartitionsResponse responseToSend = new CreatePartitionsResponse(new CreatePartitionsResponseData().setResults((List)responses$2));
        this.trace((Function0<String> & Serializable)() -> "Sending create partitions response " + responseToSend + " for correlation id " + request$5.header().correlationId() + " to client " + request$5.header().clientId() + ".");
        this.requestHelper().sendResponseMaybeThrottle(request$5, (Function1<Object, AbstractResponse>)(Function1<Object, CreatePartitionsResponse> & Serializable)x$15 -> responseToSend);
    }

    public static final /* synthetic */ boolean $anonfun$handleCreatePartitionsRequest$5(CreatePartitionsRequestData.CreatePartitionsTopic topic) {
        return topic.assignments() != null && !topic.assignments().isEmpty();
    }

    private final void maybeTryToCreatePartitionsAndSendResponse$1(java.util.Set topicMetadataForPartitionCreations, Throwable throwable2, HashSet authorizedTopics$1, HashMap validCreatePartitionsTopics$1, boolean validateOnly$1, ArrayList responses$2, RequestChannel.Request request$5) {
        if (throwable2 != null) {
            ApiError apiError = ApiError.fromThrowable((Throwable)throwable2);
            authorizedTopics$1.forEach(topicName -> K2ControllerApis.addResponse$2(topicName, apiError.error().code(), apiError.message(), responses$2));
            this.info((Function0<String> & Serializable)() -> "Received exception during processing of CreatePartitionsRequest while retrieving K2 topic metadata for topics: {" + authorizedTopics$1.toString() + "} throwable: " + throwable2);
            this.sendResponses$2(responses$2, request$5);
            return;
        }
        scala.collection.immutable.Map topicMetadataByName = ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(topicMetadataForPartitionCreations).asScala().map((Function1<K2TopicMetadata, Tuple2> & Serializable)k2tm -> new Tuple2<String, K2TopicMetadata>(k2tm.topicName(), (K2TopicMetadata)k2tm))).toMap($less$colon$less$.MODULE$.refl());
        HashMap<String, List<Integer>> authorizedValidTopics = new HashMap<String, List<Integer>>();
        authorizedTopics$1.forEach(topicName -> {
            if (!topicMetadataByName.keySet().contains(topicName)) {
                K2ControllerApis.addResponse$2(topicName, Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), Errors.UNKNOWN_TOPIC_OR_PARTITION.message(), responses$2);
                return;
            }
            CreatePartitionsRequestData.CreatePartitionsTopic topic = (CreatePartitionsRequestData.CreatePartitionsTopic)validCreatePartitionsTopics$1.get(topicName);
            K2TopicMetadata topicMetadata = (K2TopicMetadata)topicMetadataByName.apply(topicName);
            int currentNumPartitions = this.totalRequestedPartitions(topicMetadata);
            K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState = topicMetadata.k2TopicLifecycleState();
            K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState2 = K2TopicMetadata.K2TopicLifecycleState.ONLINE;
            if (k2TopicLifecycleState == null ? k2TopicLifecycleState2 != null : !((Object)((Object)k2TopicLifecycleState)).equals((Object)k2TopicLifecycleState2)) {
                K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState3 = topicMetadata.k2TopicLifecycleState();
                K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState4 = K2TopicMetadata.K2TopicLifecycleState.CREATING;
                if (k2TopicLifecycleState3 == null ? k2TopicLifecycleState4 != null : !((Object)((Object)k2TopicLifecycleState3)).equals((Object)k2TopicLifecycleState4)) {
                    K2ControllerApis.addResponse$2(topicName, Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), Errors.UNKNOWN_TOPIC_OR_PARTITION.message(), responses$2);
                    return;
                }
            }
            if (topic.count() <= currentNumPartitions) {
                K2ControllerApis.addResponse$2(topicName, Errors.INVALID_PARTITIONS.code(), "The topic " + topicName + " currently has " + currentNumPartitions + " partition(s); " + topic.count() + " would not be an increase.", responses$2);
                return;
            }
            if (topicMetadata.isVirtual()) {
                K2ControllerApis.addResponse$2(topicName, Errors.INVALID_REQUEST.code(), "Cannot create partitions for virtual topic " + topicName + " with id " + topicMetadata.topicId(), responses$2);
                return;
            }
            authorizedValidTopics.put((String)topicName, (List<Integer>)Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(currentNumPartitions), Predef$.MODULE$.int2Integer(topic.count())}));
        });
        if (authorizedValidTopics.isEmpty()) {
            this.sendResponses$2(responses$2, request$5);
            return;
        }
        this.controllerRequestHandler.createAdditionalPartitions(authorizedValidTopics, validateOnly$1, Predef$.MODULE$.Boolean2boolean(this.config.applyCreateTopicsPolicyToCreatePartitions())).whenCompleteAsyncRaw((partitionCreationResult, throwable) -> {
            this.info((Function0<String> & Serializable)() -> "Processed CreatePartitionsRequest for authorized topics {" + authorizedValidTopics.toString() + "} via K2 topic metadata store. Result: " + Utils.mkString((Map)partitionCreationResult, (String)"{", (String)"}", (String)",", (String)"=") + " throwable: " + throwable);
            if (throwable != null) {
                ApiError apiError = ApiError.fromThrowable((Throwable)throwable);
                authorizedValidTopics.keySet().forEach(topicName -> K2ControllerApis.addResponse$2(topicName, apiError.error().code(), apiError.message(), responses$2));
            } else {
                authorizedValidTopics.keySet().forEach(topicName -> {
                    if (partitionCreationResult.containsKey(topicName)) {
                        ApiError apiError = (ApiError)partitionCreationResult.get(topicName);
                        K2ControllerApis.addResponse$2(topicName, apiError.error().code(), apiError.message(), responses$2);
                        return;
                    }
                    K2ControllerApis.addResponse$2(topicName, Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), Errors.UNKNOWN_TOPIC_OR_PARTITION.message(), responses$2);
                    this.error((Function0<String> & Serializable)() -> "Missing result for topic " + topicName + " from controller (should never happen).");
                });
            }
            this.sendResponses$2(responses$2, request$5);
        }, this.executor);
    }

    public K2ControllerApis(RequestChannel requestChannel, int brokerId, KafkaConfig config, Option<Plugin<Authorizer>> authorizerPlugin, QuotaFactory.QuotaManagers quotas, Time time, K2ControllerHandler controllerRequestHandler, Executor executor) {
        this.config = config;
        this.controllerRequestHandler = controllerRequestHandler;
        this.executor = executor;
        Logging.$init$(this);
        this.logIdent_$eq(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("[K2ControllerApis-%d] "), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(brokerId)})));
        this.requestHelper = new RequestHandlerHelper(requestChannel, quotas, time);
        this.authHelper = new AuthHelper(authorizerPlugin);
    }

    private class ClusterAuthorizer {
        private final RequestContext requestContext;
        private final AclOperation operation;
        private Option<Object> hasClusterAuthorization;
        public final /* synthetic */ K2ControllerApis $outer;

        private Option<Object> hasClusterAuthorization() {
            return this.hasClusterAuthorization;
        }

        private void hasClusterAuthorization_$eq(Option<Object> x$1) {
            this.hasClusterAuthorization = x$1;
        }

        public boolean isAuthorized() {
            Option<Object> option = this.hasClusterAuthorization();
            if (option instanceof Some) {
                Some some = (Some)option;
                boolean clusterAuthorized = BoxesRunTime.unboxToBoolean(some.value());
                return clusterAuthorized;
            }
            if (None$.MODULE$.equals(option)) {
                RequestContext x$1 = this.requestContext;
                AclOperation x$2 = this.operation;
                ResourceType x$3 = ResourceType.CLUSTER;
                String x$4 = "kafka-cluster";
                boolean x$5 = false;
                boolean x$6 = this.kafka$server$K2ControllerApis$ClusterAuthorizer$$$outer().authHelper().authorize$default$5();
                int x$7 = this.kafka$server$K2ControllerApis$ClusterAuthorizer$$$outer().authHelper().authorize$default$7();
                boolean authorized = this.kafka$server$K2ControllerApis$ClusterAuthorizer$$$outer().authHelper().authorize(x$1, x$2, ResourceType.CLUSTER, "kafka-cluster", x$6, false, x$7);
                this.hasClusterAuthorization_$eq(new Some<Object>(BoxesRunTime.boxToBoolean(authorized)));
                return authorized;
            }
            throw new MatchError(option);
        }

        public /* synthetic */ K2ControllerApis kafka$server$K2ControllerApis$ClusterAuthorizer$$$outer() {
            return this.$outer;
        }

        public ClusterAuthorizer(K2ControllerApis $outer, RequestContext requestContext, AclOperation operation) {
            this.requestContext = requestContext;
            this.operation = operation;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.hasClusterAuthorization = None$.MODULE$;
        }
    }

    private class ErrorDetermination
    implements Product,
    Serializable {
        private final short errorCode;
        private final String errorMessage;
        public final /* synthetic */ K2ControllerApis $outer;

        @Override
        public Iterator<String> productElementNames() {
            return Product.productElementNames$(this);
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public ErrorDetermination copy(short errorCode, String errorMessage) {
            return new ErrorDetermination(this.kafka$server$K2ControllerApis$ErrorDetermination$$$outer(), errorCode, errorMessage);
        }

        public short copy$default$1() {
            return this.errorCode();
        }

        public String copy$default$2() {
            return this.errorMessage();
        }

        @Override
        public String productPrefix() {
            return "ErrorDetermination";
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToShort(this.errorCode());
                }
                case 1: {
                    return this.errorMessage();
                }
            }
            return Statics.ioobe(x$1);
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof ErrorDetermination;
        }

        @Override
        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "errorCode";
                }
                case 1: {
                    return "errorMessage";
                }
            }
            return (String)Statics.ioobe(x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, this.errorCode());
            n = Statics.mix(n, Statics.anyHash(this.errorMessage()));
            return Statics.finalizeHash(n, 2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ErrorDetermination)) return false;
            if (((ErrorDetermination)object).kafka$server$K2ControllerApis$ErrorDetermination$$$outer() != this.kafka$server$K2ControllerApis$ErrorDetermination$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ErrorDetermination errorDetermination = (ErrorDetermination)x$1;
            if (this.errorCode() != errorDetermination.errorCode()) return false;
            String string = this.errorMessage();
            String string2 = errorDetermination.errorMessage();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!errorDetermination.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ K2ControllerApis kafka$server$K2ControllerApis$ErrorDetermination$$$outer() {
            return this.$outer;
        }

        public ErrorDetermination(K2ControllerApis $outer, short errorCode, String errorMessage) {
            this.errorCode = errorCode;
            this.errorMessage = errorMessage;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$(this);
        }
    }
}

