/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kafka.server.KafkaConfig;
import kafka.server.Server$;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.KafkaThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class KafkaBroker$ {
    public static final KafkaBroker$ MODULE$ = new KafkaBroker$();
    private static final String kafka$server$KafkaBroker$$MetricsTypeName = "KafkaServer";
    private static final String STARTED_MESSAGE = "Kafka Server started";
    private static final long MIN_INCREMENTAL_FETCH_SESSION_EVICTION_MS = 120000L;
    private static final AtomicLong externalShutdownInitiations = new AtomicLong(0L);
    private static final Logger logger = LoggerFactory.getLogger((String)"KafkaBroker");

    public String kafka$server$KafkaBroker$$MetricsTypeName() {
        return kafka$server$KafkaBroker$$MetricsTypeName;
    }

    public void augmentWithKafkaConfig(Map<String, Object> logProps, KafkaConfig kafkaConfig) {
        if (kafkaConfig != null) {
            logProps.put("confluent.schema.registry.max.cache.size", kafkaConfig.getInt("confluent.schema.registry.max.cache.size"));
            logProps.put("confluent.schema.registry.max.retries", kafkaConfig.getInt("confluent.schema.registry.max.retries"));
            logProps.put("confluent.schema.registry.retries.wait.ms", kafkaConfig.getInt("confluent.schema.registry.retries.wait.ms"));
            logProps.put("confluent.missing.id.query.range", kafkaConfig.getInt("confluent.missing.id.query.range"));
            logProps.put("confluent.missing.id.cache.ttl.sec", kafkaConfig.getLong("confluent.missing.id.cache.ttl.sec"));
            logProps.put("confluent.missing.schema.cache.ttl.sec", kafkaConfig.getLong("confluent.missing.schema.cache.ttl.sec"));
            return;
        }
    }

    public KafkaMetricsContext createKafkaMetricsContext(String clusterId, KafkaConfig config) {
        return Server$.MODULE$.createKafkaMetricsContext(config, clusterId);
    }

    public void notifyClusterListeners(String clusterId, Seq<Object> clusterListeners) {
        ClusterResourceListeners clusterResourceListeners = new ClusterResourceListeners();
        clusterResourceListeners.maybeAddAll(CollectionConverters$.MODULE$.SeqHasAsJava(clusterListeners).asJava());
        clusterResourceListeners.onUpdate(new ClusterResource(clusterId));
    }

    public void notifyMetricsReporters(String clusterId, KafkaConfig config, Seq<Object> metricsReporters) {
        KafkaMetricsContext metricsContext = Server$.MODULE$.createKafkaMetricsContext(config, clusterId);
        metricsReporters.foreach((Function1<Object, Object> & Serializable)x0$1 -> {
            KafkaBroker$.$anonfun$notifyMetricsReporters$1(metricsContext, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public Thread initiateShutdown() {
        long previousInitiations = this.externalShutdownInitiations().getAndAdd(1L);
        KafkaThread th = KafkaThread.daemon((String)("external-shutdown-" + previousInitiations), () -> {
            MODULE$.logger().warn("Initiating externally-requested shutdown by calling Exit (there were {} externally-initiated shutdowns previously)", (Object)BoxesRunTime.boxToLong(previousInitiations));
            Exit.exit((int)0);
            MODULE$.logger().warn("Externally-requested shutdown finished successfully");
        });
        th.start();
        return th;
    }

    public String STARTED_MESSAGE() {
        return STARTED_MESSAGE;
    }

    public long MIN_INCREMENTAL_FETCH_SESSION_EVICTION_MS() {
        return MIN_INCREMENTAL_FETCH_SESSION_EVICTION_MS;
    }

    public AtomicLong externalShutdownInitiations() {
        return externalShutdownInitiations;
    }

    private Logger logger() {
        return logger;
    }

    public static final /* synthetic */ void $anonfun$notifyMetricsReporters$1(KafkaMetricsContext metricsContext$1, Object x0$1) {
        Object object = x0$1;
        if (object instanceof MetricsReporter) {
            MetricsReporter metricsReporter = (MetricsReporter)object;
            metricsReporter.contextChange((MetricsContext)metricsContext$1);
            return;
        }
    }

    private KafkaBroker$() {
    }
}

