/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import io.confluent.kafka.availability.ThreadCountersManager;
import io.confluent.kafka.availability.ThreadLocalCounters;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.network.RequestChannel;
import kafka.network.RequestChannel$ShutdownRequest$;
import kafka.network.RequestChannel$WakeupRequest$;
import kafka.server.ApiRequestHandler;
import kafka.server.DefaultRequestLogger;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRequestHandler$;
import kafka.server.RequestLogger;
import kafka.utils.Logging;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.RequestLocal;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t5r!B\u0016-\u0011\u0003\td!B\u001a-\u0011\u0003!\u0004\"B\u001e\u0002\t\u0003a\u0004bB\u001f\u0002\u0005\u0004%IA\u0010\u0005\u0007\u001b\u0006\u0001\u000b\u0011B \t\u000f9\u000b!\u0019!C\u0005\u001f\"1\u0001,\u0001Q\u0001\nACq!W\u0001A\u0002\u0013%!\fC\u0004_\u0003\u0001\u0007I\u0011B0\t\r\u0015\f\u0001\u0015)\u0003\\\u0011\u0015Q\u0017\u0001\"\u0001l\u0011\u0015q\u0017\u0001\"\u0001p\u0011%\t)#AI\u0001\n\u0003\t9CB\u00034Y\u0001\t\u0019\u0006\u0003\u0006\u0002n5\u0011\t\u0011)A\u0005\u0003_B!\"!\u001e\u000e\u0005\u0003\u0005\u000b\u0011BA<\u0011)\ti(\u0004B\u0001B\u0003%\u00111\u0006\u0005\u000b\u0003\u007fj!\u0011!Q\u0001\n\u0005=\u0004BCAA\u001b\t\u0015\r\u0011\"\u0001\u0002\u0004\"Q\u0011QT\u0007\u0003\u0002\u0003\u0006I!!\"\t\u0015\u0005}UB!b\u0001\n\u0003\t\t\u000b\u0003\u0006\u000286\u0011\t\u0011)A\u0005\u0003GC!\"!/\u000e\u0005\u000b\u0007I\u0011AA^\u0011%\ti,\u0004B\u0001B\u0003%q\t\u0003\u0006\u0002@6\u0011\t\u0011)A\u0005\u0003\u0003D!\"a2\u000e\u0005\u0003\u0005\u000b\u0011BAe\u0011)\t).\u0004B\u0001B\u0003%\u00111\u0006\u0005\u0007w5!\t!a6\t\u0013\u0005=XB1A\u0005\n\u0005E\b\u0002CA~\u001b\u0001\u0006I!a=\t\u0013\u0005\rRB1A\u0005\n\u0005u\b\u0002CA\u0000\u001b\u0001\u0006I!!\u0003\t\u0013\t\u0005QB1A\u0005\n\t\r\u0001\u0002\u0003B\u0006\u001b\u0001\u0006IA!\u0002\t\u0011\t5Q\u00021A\u0005\niC\u0011Ba\u0004\u000e\u0001\u0004%IA!\u0005\t\u000f\tUQ\u0002)Q\u00057\"9!\u0011D\u0007\u0005\u0002\tm\u0001\u0002\u0003B\u000f\u001b\u0011\u0005AFa\b\t\u000f\t\u0015R\u0002\"\u0003\u0003\u001c!9!qE\u0007\u0005\u0002\tm\u0001b\u0002B\u0015\u001b\u0011\u0005!1\u0004\u0005\b\u0005WiA\u0011\u0001B\u000e\u0003MY\u0015MZ6b%\u0016\fX/Z:u\u0011\u0006tG\r\\3s\u0015\tic&\u0001\u0004tKJ4XM\u001d\u0006\u0002_\u0005)1.\u00194lC\u000e\u0001\u0001C\u0001\u001a\u0002\u001b\u0005a#aE&bM.\f'+Z9vKN$\b*\u00198eY\u0016\u00148CA\u00016!\t1\u0014(D\u00018\u0015\u0005A\u0014!B:dC2\f\u0017B\u0001\u001e8\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!M\u0001\u0015i\"\u0014X-\u00193SKF,Xm\u001d;DQ\u0006tg.\u001a7\u0016\u0003}\u00022\u0001Q#H\u001b\u0005\t%B\u0001\"D\u0003\u0011a\u0017M\\4\u000b\u0003\u0011\u000bAA[1wC&\u0011a)\u0011\u0002\f)\"\u0014X-\u00193M_\u000e\fG\u000e\u0005\u0002I\u00176\t\u0011J\u0003\u0002K]\u00059a.\u001a;x_J\\\u0017B\u0001'J\u00059\u0011V-];fgR\u001c\u0005.\u00198oK2\fQ\u0003\u001e5sK\u0006$'+Z9vKN$8\t[1o]\u0016d\u0007%\u0001\u000buQJ,\u0017\rZ\"veJ,g\u000e\u001e*fcV,7\u000f^\u000b\u0002!B\u0019\u0001)R)\u0011\u0005I+fB\u0001%T\u0013\t!\u0016*\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\n\u0005Y;&a\u0002*fcV,7\u000f\u001e\u0006\u0003)&\u000bQ\u0003\u001e5sK\u0006$7)\u001e:sK:$(+Z9vKN$\b%A\tcsB\f7o\u001d+ie\u0016\fGm\u00115fG.,\u0012a\u0017\t\u0003mqK!!X\u001c\u0003\u000f\t{w\u000e\\3b]\u0006)\"-\u001f9bgN$\u0006N]3bI\u000eCWmY6`I\u0015\fHC\u00011d!\t1\u0014-\u0003\u0002co\t!QK\\5u\u0011\u001d!\u0007\"!AA\u0002m\u000b1\u0001\u001f\u00132\u0003I\u0011\u0017\u0010]1tgRC'/Z1e\u0007\",7m\u001b\u0011)\u0005%9\u0007C\u0001\u001ci\u0013\tIwG\u0001\u0005w_2\fG/\u001b7f\u0003Q\u0019X\r\u001e\"za\u0006\u001c8\u000f\u00165sK\u0006$7\t[3dWR\u0011\u0001\r\u001c\u0005\u0006[*\u0001\raW\u0001\fEf\u0004\u0018m]:DQ\u0016\u001c7.A\txe\u0006\u0004\u0018i]=oG\u000e\u000bG\u000e\u001c2bG.,\"\u0001\u001d<\u0015\tE|\u0018\u0011\u0005\t\u0005mI$\b-\u0003\u0002to\tIa)\u001e8di&|g.\r\t\u0003kZd\u0001\u0001B\u0003x\u0017\t\u0007\u0001PA\u0001U#\tIH\u0010\u0005\u00027u&\u00111p\u000e\u0002\b\u001d>$\b.\u001b8h!\t1T0\u0003\u0002\u007fo\t\u0019\u0011I\\=\t\u000f\u0005\u00051\u00021\u0001\u0002\u0004\u00059\u0012m]=oG\u000e{W\u000e\u001d7fi&|gnQ1mY\n\f7m\u001b\t\bm\u0005\u0015\u0011\u0011\u0002;a\u0013\r\t9a\u000e\u0002\n\rVt7\r^5p]J\u0002B!a\u0003\u0002\u001e5\u0011\u0011Q\u0002\u0006\u0005\u0003\u001f\t\t\"\u0001\u0004d_6lwN\u001c\u0006\u0004[\u0005M!bA\u0018\u0002\u0016)!\u0011qCA\r\u0003\u0019\t\u0007/Y2iK*\u0011\u00111D\u0001\u0004_J<\u0017\u0002BA\u0010\u0003\u001b\u0011ABU3rk\u0016\u001cH\u000fT8dC2Dq!a\t\f\u0001\u0004\tI!\u0001\u0007sKF,Xm\u001d;M_\u000e\fG.\u0001\u000f%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0019\u0016\u0005\u0005%\"\u0006BA\u0016\u0003\u0003\u0002B!!\f\u0002<9!\u0011qFA\u001c!\r\t\tdN\u0007\u0003\u0003gQ1!!\u000e1\u0003\u0019a$o\\8u}%\u0019\u0011\u0011H\u001c\u0002\rA\u0013X\rZ3g\u0013\u0011\ti$a\u0010\u0003\rM#(/\u001b8h\u0015\r\tIdN\u0016\u0003\u0003\u0007\u0002B!!\u0012\u0002P5\u0011\u0011q\t\u0006\u0005\u0003\u0013\nY%A\u0005v]\u000eDWmY6fI*\u0019\u0011QJ\u001c\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002R\u0005\u001d#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dKN9Q\"!\u0016\u0002\\\u0005\u0005\u0004c\u0001!\u0002X%\u0019\u0011\u0011L!\u0003\r=\u0013'.Z2u!\r\u0001\u0015QL\u0005\u0004\u0003?\n%\u0001\u0003*v]:\f'\r\\3\u0011\t\u0005\r\u0014\u0011N\u0007\u0003\u0003KR1!a\u001a/\u0003\u0015)H/\u001b7t\u0013\u0011\tY'!\u001a\u0003\u000f1{wmZ5oO\u0006\u0011\u0011\u000e\u001a\t\u0004m\u0005E\u0014bAA:o\t\u0019\u0011J\u001c;\u0002\r\r|gNZ5h!\r\u0011\u0014\u0011P\u0005\u0004\u0003wb#aC&bM.\f7i\u001c8gS\u001e\f\u0011b\u00197vgR,'/\u00133\u0002\u0011\t\u0014xn[3s\u0013\u0012\f!#Y4he\u0016<\u0017\r^3JI2,W*\u001a;feV\u0011\u0011Q\u0011\t\u0005\u0003\u000f\u000bI*\u0004\u0002\u0002\n*!\u00111RAG\u0003\u0011\u0019wN]3\u000b\t\u0005=\u0015\u0011S\u0001\b[\u0016$(/[2t\u0015\u0011\t\u0019*!&\u0002\re\fW.\\3s\u0015\t\t9*A\u0002d_6LA!a'\u0002\n\n)Q*\u001a;fe\u0006\u0019\u0012mZ4sK\u001e\fG/Z%eY\u0016lU\r^3sA\u0005\u0019Bo\u001c;bY\"\u000bg\u000e\u001a7feRC'/Z1egV\u0011\u00111\u0015\t\u0005\u0003K\u000b\u0019,\u0004\u0002\u0002(*!\u0011\u0011VAV\u0003\u0019\tGo\\7jG*!\u0011QVAX\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0003c\u001b\u0015\u0001B;uS2LA!!.\u0002(\ni\u0011\t^8nS\u000eLe\u000e^3hKJ\fA\u0003^8uC2D\u0015M\u001c3mKJ$\u0006N]3bIN\u0004\u0013A\u0004:fcV,7\u000f^\"iC:tW\r\\\u000b\u0002\u000f\u0006y!/Z9vKN$8\t[1o]\u0016d\u0007%\u0001\u0003ba&\u001c\bc\u0001\u001a\u0002D&\u0019\u0011Q\u0019\u0017\u0003#\u0005\u0003\u0018NU3rk\u0016\u001cH\u000fS1oI2,'/\u0001\u0003uS6,\u0007\u0003BAf\u0003#l!!!4\u000b\t\u0005\u001d\u0014q\u001a\u0006\u0005\u0003\u001f\t\u0019\"\u0003\u0003\u0002T\u00065'\u0001\u0002+j[\u0016\f\u0001B\\8eK:\u000bW.\u001a\u000b\u0017\u00033\fY.!8\u0002`\u0006\u0005\u00181]As\u0003O\fI/a;\u0002nB\u0011!'\u0004\u0005\b\u0003[Z\u0002\u0019AA8\u0011\u001d\t)h\u0007a\u0001\u0003oBq!! \u001c\u0001\u0004\tY\u0003C\u0004\u0002\u0000m\u0001\r!a\u001c\t\u000f\u0005\u00055\u00041\u0001\u0002\u0006\"9\u0011qT\u000eA\u0002\u0005\r\u0006BBA]7\u0001\u0007q\tC\u0004\u0002@n\u0001\r!!1\t\u000f\u0005\u001d7\u00041\u0001\u0002J\"I\u0011Q[\u000e\u0011\u0002\u0003\u0007\u00111F\u0001\u0011g\",H\u000fZ8x]\u000e{W\u000e\u001d7fi\u0016,\"!a=\u0011\t\u0005U\u0018q_\u0007\u0003\u0003WKA!!?\u0002,\nq1i\\;oi\u0012{wO\u001c'bi\u000eD\u0017!E:ikR$wn\u001e8D_6\u0004H.\u001a;fAU\u0011\u0011\u0011B\u0001\u000ee\u0016\fX/Z:u\u0019>\u001c\u0017\r\u001c\u0011\u0002\u001bI,\u0017/^3ti2{wmZ3s+\t\u0011)\u0001E\u00023\u0005\u000fI1A!\u0003-\u00055\u0011V-];fgRdunZ4fe\u0006q!/Z9vKN$Hj\\4hKJ\u0004\u0013aB:u_B\u0004X\rZ\u0001\fgR|\u0007\u000f]3e?\u0012*\u0017\u000fF\u0002a\u0005'Aq\u0001Z\u0012\u0002\u0002\u0003\u00071,\u0001\u0005ti>\u0004\b/\u001a3!Q\t!s-A\u0002sk:$\u0012\u0001Y\u0001\u0005a>dG\u000eF\u0002a\u0005CAqAa\t'\u0001\u0004\ty'A\u0005uS6,w.\u001e;Ng\u0006\u00012m\\7qY\u0016$Xm\u00155vi\u0012|wO\\\u0001\u0005gR|\u0007/\u0001\tj]&$\u0018.\u0019;f'\",H\u000fZ8x]\u0006i\u0011m^1jiNCW\u000f\u001e3po:\u0004")
public class KafkaRequestHandler
implements Runnable,
Logging {
    private final int id;
    private final int brokerId;
    private final Meter aggregateIdleMeter;
    private final AtomicInteger totalHandlerThreads;
    private final RequestChannel requestChannel;
    private final ApiRequestHandler apis;
    private final Time time;
    private final CountDownLatch shutdownComplete;
    private final RequestLocal requestLocal;
    private final RequestLogger requestLogger;
    private volatile boolean stopped;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String $lessinit$greater$default$10() {
        return KafkaRequestHandler$.MODULE$.$lessinit$greater$default$10();
    }

    public static <T> Function1<T, BoxedUnit> wrapAsyncCallback(Function2<RequestLocal, T, BoxedUnit> asyncCompletionCallback, RequestLocal requestLocal) {
        return KafkaRequestHandler$.MODULE$.wrapAsyncCallback(asyncCompletionCallback, requestLocal);
    }

    public static void setBypassThreadCheck(boolean bypassCheck) {
        KafkaRequestHandler$.MODULE$.setBypassThreadCheck(bypassCheck);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        KafkaRequestHandler kafkaRequestHandler = this;
        synchronized (kafkaRequestHandler) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    public AtomicInteger totalHandlerThreads() {
        return this.totalHandlerThreads;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    private CountDownLatch shutdownComplete() {
        return this.shutdownComplete;
    }

    private RequestLocal requestLocal() {
        return this.requestLocal;
    }

    private RequestLogger requestLogger() {
        return this.requestLogger;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    @Override
    public void run() {
        try {
            ThreadCountersManager.LocalCounters.setThreadType((ThreadLocalCounters.ThreadGroupType)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
            KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadRequestChannel().set(this.requestChannel());
            while (!this.stopped()) {
                this.poll(300);
            }
        }
        finally {
            this.completeShutdown();
        }
    }

    public void poll(int timeoutMs) {
        long startSelectTime = this.time.nanoseconds();
        RequestChannel.BaseRequest req = this.requestChannel().receiveRequest(timeoutMs);
        long endTime = this.time.nanoseconds();
        long idleTime = endTime - startSelectTime;
        this.aggregateIdleMeter().mark(idleTime / (long)this.totalHandlerThreads().get());
        RequestChannel.BaseRequest baseRequest = req;
        if (RequestChannel$ShutdownRequest$.MODULE$.equals(baseRequest)) {
            this.debug((Function0<String> & Serializable)() -> "Kafka request handler " + $this.id + " on broker " + $this.brokerId + " received shut down command");
            this.stop();
            return;
        }
        if (baseRequest instanceof RequestChannel.CallbackRequest) {
            RequestChannel.CallbackRequest callbackRequest = (RequestChannel.CallbackRequest)baseRequest;
            RequestChannel.Request originalRequest = callbackRequest.originalRequest();
            try {
                BoxedUnit boxedUnit;
                try {
                    if (originalRequest.callbackRequestDequeueTimeNanos().isDefined()) {
                        long prevCallbacksTimeNanos = BoxesRunTime.unboxToLong(originalRequest.callbackRequestCompleteTimeNanos().getOrElse(() -> 0L)) - BoxesRunTime.unboxToLong(originalRequest.callbackRequestDequeueTimeNanos().getOrElse(() -> 0L));
                        originalRequest.callbackRequestCompleteTimeNanos_$eq(None$.MODULE$);
                        originalRequest.callbackRequestDequeueTimeNanos_$eq(new Some<Object>(BoxesRunTime.boxToLong(this.time.nanoseconds() - prevCallbacksTimeNanos)));
                    } else {
                        originalRequest.callbackRequestDequeueTimeNanos_$eq(new Some<Object>(BoxesRunTime.boxToLong(this.time.nanoseconds())));
                    }
                    KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadCurrentRequest().set(originalRequest);
                    boxedUnit = (BoxedUnit)ThreadCountersManager.wrapEngine(() -> {
                        KafkaRequestHandler.$anonfun$poll$4(this, callbackRequest);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (FatalExitError e) {
                    this.shutdownComplete().countDown();
                    Exit.exit((int)e.statusCode());
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (OutOfMemoryError e) {
                    this.shutdownComplete().countDown();
                    throw e;
                }
                catch (Throwable e) {
                    this.error((Function0<String> & Serializable)() -> "Exception when handling request", (Function0<Throwable> & Serializable)() -> e);
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            finally {
                this.requestChannel().tryCompleteActions();
                if (originalRequest.callbackRequestCompleteTimeNanos().isEmpty()) {
                    originalRequest.callbackRequestCompleteTimeNanos_$eq(new Some<Object>(BoxesRunTime.boxToLong(this.time.nanoseconds())));
                }
                KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadCurrentRequest().remove();
            }
            return;
        }
        if (baseRequest instanceof RequestChannel.Request) {
            RequestChannel.Request request = (RequestChannel.Request)baseRequest;
            try {
                BoxedUnit boxedUnit;
                try {
                    request.requestDequeueTimeNanos_$eq(endTime);
                    this.trace((Function0<String> & Serializable)() -> "Kafka request handler " + $this.id + " on broker " + $this.brokerId + " handling request " + request);
                    KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadCurrentRequest().set(request);
                    boxedUnit = (BoxedUnit)ThreadCountersManager.wrapEngine(() -> {
                        this.apis.handle(request, this.requestLogger(), this.requestLocal());
                        return BoxedUnit.UNIT;
                    });
                }
                catch (FatalExitError e) {
                    this.shutdownComplete().countDown();
                    Exit.exit((int)e.statusCode());
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (OutOfMemoryError e) {
                    this.shutdownComplete().countDown();
                    throw e;
                }
                catch (Throwable e) {
                    this.error((Function0<String> & Serializable)() -> "Exception when handling request", (Function0<Throwable> & Serializable)() -> e);
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            finally {
                KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadCurrentRequest().remove();
                request.releaseBuffer();
            }
            return;
        }
        if (RequestChannel$WakeupRequest$.MODULE$.equals(baseRequest)) {
            this.warn((Function0<String> & Serializable)() -> "Received a wakeup request outside of typical usage.");
            return;
        }
        if (baseRequest == null) {
            return;
        }
        throw new MatchError(baseRequest);
    }

    private void completeShutdown() {
        this.requestLocal().close();
        KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadRequestChannel().remove();
        this.shutdownComplete().countDown();
    }

    public void stop() {
        this.stopped_$eq(true);
    }

    public void initiateShutdown() {
        this.requestChannel().sendShutdownRequest();
    }

    public void awaitShutdown() {
        this.shutdownComplete().await();
    }

    public static final /* synthetic */ void $anonfun$poll$4(KafkaRequestHandler $this, RequestChannel.CallbackRequest x3$1) {
        x3$1.fun().apply($this.requestLocal());
    }

    public KafkaRequestHandler(int id, KafkaConfig config, String clusterId, int brokerId, Meter aggregateIdleMeter, AtomicInteger totalHandlerThreads, RequestChannel requestChannel, ApiRequestHandler apis, Time time, String nodeName) {
        this.id = id;
        this.brokerId = brokerId;
        this.aggregateIdleMeter = aggregateIdleMeter;
        this.totalHandlerThreads = totalHandlerThreads;
        this.requestChannel = requestChannel;
        this.apis = apis;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq("[Kafka Request Handler " + id + " on " + StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(nodeName)) + " " + brokerId + "] ");
        this.shutdownComplete = new CountDownLatch(1);
        this.requestLocal = RequestLocal.withThreadConfinedCaching();
        this.requestLogger = new DefaultRequestLogger(config, clusterId);
        this.stopped = false;
    }
}

